<HTML>
<HEAD>
<TITLE>SRC Modula-3: etext/src/ISOChar.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>etext/src/ISOChar.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> by Jim Meehan and Henri Gouraud                             

<P><PRE>INTERFACE <interface><A HREF="ISOChar.m3">ISOChar</A></interface>;
</PRE> ISO Latin-1 Characters and Character Sets
<P>
   ISOChar deals with individual characters, including the ISO Latin-1
   8-bit characters.  It classifies characters into groups, like
   digits or punctuation; each group is represented as a set of
   characters.  Finally, it provides mapping tables that translate
   lower-case letters into upper-case and the like.
<P>


<P><PRE>TYPE T = CHAR;

CONST
  All           = SET OF T {'\000'.. '\377'};
  Controls      = SET OF T {'\000'.. '\037', '\177'.. '\217', '\231', '\234'};
  Spaces        = SET OF T {' ', '\t', '\n', '\r', '\f', '\240'};
  Digits        = SET OF T {'0'.. '9'};
  Uppers        = SET OF T {'A'.. 'Z', '\300'.. '\326', '\330'.. '\336'};
  Lowers        = SET OF T {'a'.. 'z', '\337'.. '\366', '\367'.. '\377'};
  Letters       = Uppers + Lowers;
  AlphaNumerics = Letters + Digits;
  Graphics      = Asciis - Controls;
  Punctuation   = Graphics - AlphaNumerics;
  Asciis        = All;

VAR
  Upper   : ARRAY T OF T;
  Lower   : ARRAY T OF T;
  Control : ARRAY T OF T;
  (* These constant arrays implement character conversions (mappings):

         Upper[c]   = the upper-case equivalent of c if c is a letter, else c
         Lower[c]   = the lower-case equivalent of c if c is a letter, else c
         Control[c] = the control-shifted equivalent of c if c is in Graphics
                       (i.e. BitAnd (c, 037B)), else c
    *)

END ISOChar.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
