<HTML>
<HEAD>
<TITLE>SRC Modula-3: etext/src/IvyModel.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>etext/src/IvyModel.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>

INTERFACE <interface><A HREF="IvyModel.m3">IvyModel</A></interface>;

IMPORT <A HREF="TextPortClass.i3">TextPortClass</A>;

TYPE <A HREF="IvyModel.m3#T">T</A> &lt;: TextPortClass.Model;

END IvyModel.
</PRE> {\tt TextPort} was originally designed after an editor called Ivy
   \cite{IvyRefman} that was developed at SRC.  Ivy was written in
   Modula-2 and included a wealth of features; the Ivy model,
   documented here, implements only a small subset of them.
<P>
   The Ivy model supports both local text-selections, Primary and
   Secondary.  Primary is an alias for Target, and Secondary is an
   alias for Source.
<P>
   There are two ways of acquiring the Source selection.  The usual
   way is to make a Secondary selection (since Secondary is an alias
   for Source) by shift- or control-clicking to select a point, word, line,
   paragraph, or buffer. The second way is to use the Copy command
   (option-C) or the Cut command (option-X). These commands make a
   copy of the Primary selection; the copy becomes the Source
   selection, but it is not displayed.
<P>
   The following list shows the Ivy keybindings. The Ivy model also
   supports ISO Latin-1 character composition.  See
   Section~\ref{MetaOptionKeys} for an explanation of ``option'' keys
   and composition.
<P>
\begin{center}
\begin{tabbing}
option-LongKeyName \= This is just a tab-setting line. \kill
 Return              \&gt; invoke the {\tt returnAction} method \\
 shift-Return        \&gt; call {\tt Newline} \\
 option-Return       \&gt; insert a newline after the cursor \\
 Backspace           \&gt; delete primary selection or the previous character \\
 option-Backspace    \&gt; swap the two previous characters \\
 control-A           \&gt; delete previous character \\
 control-B           \&gt; delete whole line \\
 control-C           \&gt; delete to start of line \\
 option-C            \&gt; {\bf Copy} \\
 control-D           \&gt; delete to the start of the current word \\
 control-E           \&gt; {\bf Move}: replace target with source, and clear source \\
 control-F           \&gt; delete to the end of the current word \\
 control-G           \&gt; delete whole word \\
 control-H           \&gt; swap the selection {\it boundaries} \\
 control-I           \&gt; move to the next word \\
 control-J           \&gt; move to previous character \\
 control-K           \&gt; move to next character \\
 control-L           \&gt; move to first non-blank and select line \\
 control-M           \&gt; find previous occurrence \\
 option-M            \&gt; find previous occurrence of primary \\
 control-N           \&gt; find next occurrence of primary \\
 option-N            \&gt; find first occurrence of primary \\
 control-O           \&gt; move up 1 row in the current column \\
 control-P           \&gt; move down 1 row in the current column \\
 control-Q           \&gt; {\bf Clear} (delete the Primary selection) \\
 control-R           \&gt; {\bf Swap}: exchange the selected {\it text} \\
 control-S           \&gt; delete the next character \\
 control-U           \&gt; move to the previous word \\
 control-V           \&gt; delete to end of line \\
 option-V            \&gt; {\bf Paste} \\
 control-W           \&gt; {\bf Paste} \\
 option-X            \&gt; {\bf Cut} \\
 control-Y           \&gt; move to opposite end of selection \\
 control-Z           \&gt; {\bf Undo} \\
 control-shift-Z     \&gt; {\bf Redo} \\
 control-,           \&gt; find next occurrence \\
 control-;           \&gt; move to end of line and select line \\
 control-Space       \&gt; normalize
<P>
\end{tabbing}
\end{center}
<P>
\subsubsection{The Ivy selection model}
<P>
The following table shows the mouse-gestures that establish the
Primary selection; if the Shift or Control key is held down, these same
gestures establish the Secondary selection.
<P>
\begin{center}
\begin{tabbing}
quadruple-click \= AllThree \= This is just a tab-setting line \kill
          click \&gt; Left   \&gt; to select a point between characters\\
   double-click \&gt; Left   \&gt; to select a single line\\
   triple-click \&gt; Left   \&gt; to select the entire buffer\\
          drag  \&gt; Left   \&gt; to change the selected point \\
          click \&gt; Middle \&gt; to select a single word\\
   double-click \&gt; Middle \&gt; to select a single paragraph\\
   triple-click \&gt; Middle \&gt; to select the entire buffer\\
           drag \&gt; Middle \&gt; to change the selected word or paragraph \\
          click \&gt; Right  \&gt; to extend the current selection \\
   double-click \&gt; Right  \&gt; to reduce the selection-unit \\
           drag \&gt; Right  \&gt; to extend the current selection
\end{tabbing}
\end{center}
<P>
A selection is a sequence of ``units''; a unit is a point, a word, a
line, a paragraph, or the entire buffer.  Double-clicking the right
mouse-button reduces the unit of the current selection from buffer to
paragraph, from paragraph to line, from line to word, and from word to
point.
<P>
A single left-click selects the point (zero-length interval) between
two characters. If you move the mouse and then right-click, the
selection is extended to include all the characters between that point
and the new position of the mouse. If you do {\em not} move the mouse,
then a right-click extends the selection to include the character
nearest that point.
<P>
A ``word'' is a maximal non-empty character sequence containing (1)
only letters and digits, or (2) one or more space and tab characters,
or (3) a single character that is not a letter, a digit, a space, or a
tab.
<P>
A ``line'' is a non-empty character sequence containing at most one
newline, whose first character either is the first character of the buffer or
immediately follows a newline, and whose final character is
either a newline or the last character in the buffer.
<P>
A ``paragraph'' is a sequence of lines---either a maximal sequence of
non-blank lines or a maximal sequence of blank lines. (A blank
line contains only spaces, tabs, and at most one newline.)
<P>
\subsubsection{Replace-mode selection}\label{ReplaceMode}
<P>
When a Primary selection in a non-readonly buffer is extended, the
selection becomes what is called a replace-mode selection, and its
highlighting changes from a red underline to a pale red background. If
you type after making a replace-mode selection, the first character
you type will replace the selection. If you use the Copy or Move
commands, the Secondary selection will replace the Primary selection.
<P>


</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
