<HTML>
<HEAD>
<TITLE>SRC Modula-3: etext/src/KeyFilter.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>etext/src/KeyFilter.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE> by Jim Meehan and Mark Manasse                                            
                                                                           
 NOTE: The table of character combinations is in the file:                 
       /proj/m3/pkg/vbtkitdoc/ISO-Latin.tex                                

<P><PRE>INTERFACE <interface><A HREF="KeyFilter.m3">KeyFilter</A></interface>;

IMPORT <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>;

TYPE
  T = OBJECT
        next: T
      METHODS
        apply (v: VBT.T; cd: VBT.KeyRec)
      END;
  <A HREF="KeyFilter.m3#Composer">Composer</A> &lt;: T OBJECT
              METHODS
                feedback (v: VBT.T; composing: BOOLEAN)
              END;
  <A HREF="KeyFilter.m3#ComposeChar">ComposeChar</A> &lt;: Composer;
  <A HREF="KeyFilter.m3#Diacritical">Diacritical</A> &lt;: Composer;

PROCEDURE <A HREF="KeyFilter.m3#IsModifier">IsModifier</A> (c: VBT.KeySym): BOOLEAN;
</PRE><BLOCKQUOTE><EM> Test whether <CODE>c</CODE> is a ``modifier'' key, such as Shift,
   Control, or Meta.  Such keys are usually ignored by
   <CODE>Composer</CODE>s.  Equivalent to:
<PRE>
      KeyboardKey.Shift_L &lt;= c AND c &lt;= KeyboardKey.Hyper_R
   </EM></BLOCKQUOTE><PRE>

END KeyFilter.
</PRE> A <CODE>KeyFilter</CODE>'s <CODE>apply</CODE> method takes a <CODE>VBT.T</CODE> and a <CODE>VBT.KeyRec</CODE>
   and may pass them on to the <CODE>KeyFilter</CODE> in its <CODE>next</CODE> field,
   possibly having altered the <CODE>KeyRec</CODE> in the process.  For example,
   a ``transparent'' filter would simply call <CODE>SELF.next.apply(v,cd)</CODE>.
   An ``upper-case filter'' (transducer) would convert lower-case
   characters to upper-case before passing them on.
<P>
   A <CODE>KeyFilter</CODE> may also maintain an internal state, and it is not
   required to call <CODE>SELF.next.apply</CODE> on every call.  Various
   ``character composition'' schemes, for example, involve typing one
   character (e.g., a key labeled ``Compose Character'') followed by
   two others, which are all ``composed'' to produce a single
   character. That is, they effectively implement a ``look-ahead''
   reader.
<P>
   A <CODE>Composer</CODE> is a subtype that provides a <CODE>feedback</CODE> method; the
   intention is that the <CODE>apply</CODE> method calls <CODE>SELF.feedback(v, TRUE)</CODE>
   when it sees a key that begins a multi-character sequence, and
   <CODE>SELF.feedback(v, FALSE)</CODE> when it sees a key that ends a sequence.
   The default <CODE>feedback</CODE> method is a no-op, but a client may wish to
   override that in order to provide a visual cue to the user that
   key-composition is in effect (e.g., changing the cursor).
   Otherwise, the user might not understand why typed character are
   not being ``echoed.''
<P>
   Two types of <CODE>Composer</CODE>s are provided, <CODE>ComposeChar</CODE> and
   <CODE>Diacritical</CODE>.  <CODE>ComposeChar</CODE> produces the ISO Latin-1 (8-bit,
   extended ASCII) characters, using the VT220 style of composition:
   when the filter sees a <CODE>Keyrec</CODE> whose <CODE>whatChanged</CODE> field is
   <CODE>KeyboardKey.MultiKey</CODE>, it calls <CODE>SELF.feedback(v,TRUE)</CODE>; after two
   more <CODE>KeyRec</CODE>s have been passed to it, it looks for those two keys
   in an internal table.  If it finds a character, then it passes it
   to <CODE>SELF.next.apply</CODE>. For example, on many keyboards, there is a
   key labeled <CODE>Compose</CODE> or <CODE>Compose Character</CODE>, which produces the
   <CODE>MultiKey</CODE> code. When you type that key, followed by ``c'' and
   ``o'', the filter passes the character for the copyright symbol,
   \copyright, to the <CODE>next</CODE> filter. If there is no entry in the
   table, the filter does not pass anything to the <CODE>next</CODE> filter.  In
   any case, it always returns to its initial state.
<P>
   For some users, the ``Compose'' key is also the ``meta'' or
   ``option'' key. Holding this key down and typing ``a'', for
   example, produces a <CODE>KeyRec</CODE> with the <CODE>mod1</CODE> modifier (which
   Trestle represents as <CODE>VBT.Modifier.Option</CODE>). When the
   <CODE>ComposeChar</CODE> filter sees a <CODE>KeyRec</CODE> with this modifier, it
   assumes that the user is {\em not} composing an 8-bit character,
   so it calls <CODE>SELF.feedback(v,FALSE)</CODE> and <CODE>SELF.next.apply(v,cd)</CODE>, and
   it returns to its initial state.
<P>
   A <CODE>Diacritical</CODE> filter also produces 8-bit characters. The filter
   looks at 2-character sequences; comma followed by ``c'', for
   example, produces an ``c'' with a cedilla, \c{c}. If the sequence
   is not defined, such as comma followed by space, then filter passes
   both characters to the <CODE>next</CODE> filter; i.e., when it receives the
   second <CODE>KeyRec</CODE>, it makes {\em two} calls to <CODE>SELF.next.apply</CODE>.
   (This is why the <CODE>KeyFilter</CODE> uses a <CODE>next</CODE> field instead of merely
   returning a <CODE>KeyRec</CODE>.)
<P>
   Here is an example showing the intended use of this interface.
   Assume that <CODE>TextEditingVBT</CODE> is a subtype of <CODE>VBT</CODE> used for typing
   text, such as <CODE>TypeinVBT.T</CODE> or <CODE>TextPort.T</CODE>.  A client would
   override the <CODE>key</CODE> method in order to filter the keys delivered to
   the supertype's <CODE>key</CODE> method.
<P>
<PRE>
      TYPE
        MyTextEditor =
          TextEditingVBT.T OBJECT
              comp: KeyFilter.ComposeChar
            OVERRIDES
              key := Key 
            END;
        Parent = Keyfilter.T OBJECT
                     OVERRIDES
                        apply := ApplyParent
                     END;
      
      PROCEDURE Key (v: MyTextEditor; READONLY cd; VBT.KeyRec) =
        BEGIN
          IF cd.wentDown AND cd.whatChanged # VBT.NoKey THEN
            v.comp.apply (v, cd)
          END
        END Key;
      
      PROCEDURE ApplyParent (self : MyParent; 
                             v    : VBT.T; 
                             cd   : VBT.KeyRec) =
        BEGIN
          TextEditingVBT.T.key (v, cd)
        END ApplyMyParent;
      
      VAR editor := NEW (MyTextEditor,
                         comp := NEW (KeyFilter.ComposeChar,
                                      next := NEW (Parent)));
</PRE>
   A <CODE>ComposeChar</CODE> object is not case-sensitive where there is no
   ambiguity.  For example, <CODE>c</CODE> and <CODE>o</CODE> can be combined to produce the
   copyright symbol, \copyright; so can <CODE>C</CODE> and <CODE>O</CODE>, <CODE>c</CODE> and <CODE>O</CODE>, or
   <CODE>C</CODE> and <CODE>o</CODE>.  By contrast, <CODE>e</CODE> and <CODE>`</CODE> can be combined to produce a
   lower-case <CODE>e</CODE> with a grave accent, \`{e}, but <CODE>E</CODE> and <CODE>`</CODE> produce
   an upper-case <CODE>E</CODE> with a grave accent, \`{E}.
<P>
   Unless both of the characters are alphanumeric, they can be
   combined in either order.  So <CODE>`</CODE> and <CODE>e</CODE> have the same effect as
   <CODE>e</CODE> and <CODE>`</CODE>, but <CODE>o</CODE> and <CODE>c</CODE> do {\em not} combine to form the
   copyright symbol.
<P>


</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
