<HTML>
<HEAD>
<TITLE>SRC Modula-3: etext/src/KeyTrans.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>etext/src/KeyTrans.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>

MODULE <module><implements><A HREF="KeyTrans.i3">KeyTrans</A></implements></module>;

IMPORT <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>, <A HREF="Key.i3">Key</A>;

PROCEDURE <A NAME="Latin1"><procedure>Latin1</procedure></A> (key: VBT.KeySym): CHAR =
  BEGIN
    IF key &gt;= 32 AND key &lt;= 255 THEN (* ISO-Latin-1 printable *)
      RETURN VAL (key, CHAR)
    ELSE
      CASE key OF
      | Key.Backspace =&gt; RETURN '\010'
      | Key.Tab =&gt; RETURN '\t'
      | Key.Return =&gt; RETURN '\n'
      | Key.Escape =&gt; RETURN '\033'
      | Key.Delete =&gt; RETURN '\177'
      ELSE
        RETURN NullKey
      END
    END
  END Latin1;

PROCEDURE <A NAME="TTY"><procedure>TTY</procedure></A> (READONLY cd: VBT.KeyRec): CHAR =
  VAR c := Latin1 (cd.whatChanged);
  BEGIN
    IF VBT.Modifier.Control IN cd.modifiers THEN
      IF c &gt;= '@' AND c &lt;= '_' THEN (* ctrl-uppers *)
        c := VAL (ORD (c) - 8_100, CHAR)
      ELSIF c &gt;= '`' AND c &lt;= '~' THEN (* ctrl-lowers *)
        c := VAL (ORD (c) - 8_140, CHAR)
      ELSIF c = '?' THEN        (* ctrl-? *)
        c := '\177'
      END
    END;
    RETURN c
  END TTY;

BEGIN
END KeyTrans.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
