<HTML>
<HEAD>
<TITLE>SRC Modula-3: etext/src/MTextUnit.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>etext/src/MTextUnit.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE>      borrowed and de-ivified from IvyUnit,
                   Mon Aug  7 15:35:29 PDT 1989 by brooks      

<P><PRE>INTERFACE <interface><A HREF="MTextUnit.m3">MTextUnit</A></interface>;

IMPORT <A HREF="../../mtext/src/MText.i3">MText</A>, <A HREF="ISOChar.i3">ISOChar</A>;

TYPE
  T = MText.T;

  (* This module imposes structure on character sequences in an
     &quot;MText.T&quot;.  There are three different structures supported:
     {\it runs}, {\it lines}, and {\it paragraphs}.  Each
     structure defines a {\it unit}, in such a way that the
     entire mtext can be viewed as a sequence of non-overlapping
     units, possibly separated by characters that belong to no
     unit.

     A {\it run} is defined by a set of characters, typically
     &quot;ISOChar.AlphaNumerics&quot;.  A unit then corresponds to a ``word'',
     and the mtext is seen as a sequence of ``words'' separated by
     ``non-word'' characters.

     A {\it line} is defined as a set of characters delimited by
     newlines.  A unit corresponds to a single line.  The mtext
     is viewed as a sequence of lines with 0-length separators.

     A {\it paragraph} is a maximal sequence of non-blank lines.

     Given an index &quot;n&quot; into the text, we define the {\it extent}
     &quot;e&quot; for runs, lines, and paragraphs as a record containing
     the left and right boundaries of the unit surrounding the
     index, plus a boolean value indicating whether the character
     at position &quot;n&quot; is inside a unit or between units.  Normally,
     &quot;e.left &lt;= index &lt; e.right&quot;.  The only exception is when
     &quot;index&quot; is greater than or equal to the length of the text,
     in which case &quot;e.left = e.right = length&quot; and &quot;e.inside
     = FALSE&quot;.

     There are also utilities for handling blank lines and for
     finding the leading and trailing blanks on a line.

     If you pass an index that's less than 0, it is treated as 0;
     if you pass an index that's greater than the length of the
     text, it is treated as the length of the text.
*)

  (* {\it Note for future work:  There is nothing in the nature
     of runs, lines, and paragraphs that is specific to
     &quot;MText.T&quot;.  It would be at least as useful to provide this
     same functionality for &quot;TEXT&quot;, &quot;ARRAY&quot; &quot;OF CHAR&quot;, and
     seekable readers.} *)

CONST
  WordRun = ISOChar.AlphaNumerics;
  BlankRun = ISOChar.Spaces; (* {' ', '\n', '\t', '\r', '\f'} *)
  NonBlankRun = ISOChar.All - BlankRun;

TYPE
  Extent = RECORD
             left, right: INTEGER;
             inside     : BOOLEAN
           END;
</PRE> \subsubsection{Runs} 

<P><PRE>PROCEDURE <A HREF="MTextUnit.m3#RunExtent">RunExtent</A> (         t            : T;
                              index        : INTEGER;
                     READONLY includedChars := WordRun):
  Extent;

PROCEDURE <A HREF="MTextUnit.m3#StartOfRun">StartOfRun</A> (t    : T;
                      index: INTEGER;
                      READONLY includedChars := WordRun):
  INTEGER;
</PRE><BLOCKQUOTE><EM> Return the largest <CODE>i &lt;= index</CODE> for which <CODE>IsStartOfRun(t, i,
   includedChars)</CODE> is <CODE>TRUE</CODE>.  Return <CODE>-1</CODE> if there is no such
   <CODE>i</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="MTextUnit.m3#IsStartOfRun">IsStartOfRun</A> (t    : T;
                        index: INTEGER;
                        READONLY includedChars := WordRun):
  BOOLEAN;
</PRE><BLOCKQUOTE><EM> Equivalent to
<PRE>
      WITH e = RunExtent(t, index, includedChars) DO
       RETURN e.inside AND e.left = index END
   </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="MTextUnit.m3#EndOfRun">EndOfRun</A> (t    : T;
                    index: INTEGER;
                    READONLY includedChars := WordRun):
  INTEGER;
</PRE><BLOCKQUOTE><EM> Return the smallest <CODE>i &gt;= index</CODE> for which <CODE>IsEndOfRun(t, i,
   includedChars)</CODE> is <CODE>TRUE</CODE>.  Return <CODE>-1</CODE> if there is no such
   <CODE>i</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="MTextUnit.m3#IsEndOfRun">IsEndOfRun</A> (t    : T;
                      index: INTEGER;
                      READONLY includedChars := WordRun):
  BOOLEAN;
</PRE><BLOCKQUOTE><EM> Equivalent to
<PRE>
      WITH e = RunExtent(t, index, includedChars) DO
        RETURN NOT e.inside AND e.left = index END
    </PRE>
or
<PRE>
      IsStartOfRun(t, index, ISOChar.All - includedChars)
   </EM></BLOCKQUOTE><PRE>
</PRE> \subsubsection{Lines} 

<P><PRE>TYPE LineOption =
  {ExcludeBlanks, IncludeBlanks, IncludeNewline};
</PRE> A {\it line} is a sequence of characters delimited by newlines
   (or the mtext boundaries).  The client may specify a
   subsequence of the line by passing left and right
   ``line options.''  If the left option is <CODE>ExcludeBlanks</CODE>, then
   the subsequence will not include any initial blanks.  If the
   left option is <CODE>IncludeBlanks</CODE>, then it will.  If the left
   option is <CODE>IncludeNewline</CODE>, it will be treated the same as
   <CODE>IncludeBlanks</CODE>.
<P>
   If the right option is <CODE>ExcludeBlanks</CODE>, then the subsequence
   will not include any trailing blanks.  If the right option is
   <CODE>IncludeBlanks</CODE>, then it will.  If the right option is
   <CODE>IncludeNewline</CODE>, then it will include both the trailing
   blanks and the following newline.
<P>
   The default left option is <CODE>IncludeBlanks</CODE>; the default right
   option is <CODE>IncludeNewline</CODE>.  This is consistent with the view
   of the text as a sequence of lines, with no intermediate
   ``gaps.'' 

<P><PRE>PROCEDURE <A HREF="MTextUnit.m3#LineExtent">LineExtent</A> (t: T; index: INTEGER): Extent;
</PRE><BLOCKQUOTE><EM> Compute the extent of the line surrounding index.  If a
   newline immediately precedes index, it uses the line that
   begins at index, not the one that ends there.  <CODE>LineExtent(t,
   index).inside</CODE> is always <CODE>TRUE</CODE>. </EM></BLOCKQUOTE><PRE>

TYPE
  LineRec = RECORD
              left       : INTEGER;  (* start of line *)
              leftMargin : INTEGER;  (* first non-blank *)
              rightMargin: INTEGER;  (* 1 + last non-blank *)
              rightEnd   : INTEGER;  (* final newline *)
              right      : INTEGER;  (* rightEnd + 1 *)
            END;
</PRE><BLOCKQUOTE><EM> A <CODE>LineRec</CODE> contains the positions within a line.  Normally,
<P>
<PRE>
      left &lt;= leftMargin &lt;= rightMargin &lt;= rightEnd
</PRE>
   and <CODE>right = rightEnd + 1</CODE>, i.e., the <CODE>left</CODE> of the next line,
   but there are exceptions.  On a line consisting entirely of
   blanks (at least one),
   <P>
<PRE>
      left &lt; leftMargin = rightMargin = rightEnd
</PRE>
   On the last line of the file (following the last newline),
   <CODE>right = rightEnd</CODE>.
<P>
   If <CODE>index = length(t)</CODE> and there is a newline immediately
   preceding <CODE>index</CODE>, then all 5 values will be equal to
   <CODE>index</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="MTextUnit.m3#LineInfo">LineInfo</A> (t: T; index: INTEGER): LineRec;

PROCEDURE <A HREF="MTextUnit.m3#LineFacts">LineFacts</A> (              t          : T;
                                   index      : INTEGER;
                     VAR (* out *) left       : INTEGER;
                     VAR (* out *) leftMargin : INTEGER;
                     VAR (* out *) rightMargin: INTEGER;
                     VAR (* out *) rightEnd   : INTEGER;
                     VAR (* out *) right      : INTEGER  );

PROCEDURE <A HREF="MTextUnit.m3#StartOfLine">StartOfLine</A> (t    : T;
                       index: INTEGER;
                       leftOption := LineOption.IncludeBlanks):
  INTEGER;
</PRE><BLOCKQUOTE><EM> IF <CODE>leftOption = ExcludeBlanks</CODE>, then return <CODE>LineInfo(t,
   index).leftMargin</CODE>.  Otherwise return <CODE>LineInfo(t,
   index).left</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="MTextUnit.m3#IsStartOfLine">IsStartOfLine</A> (t    : T;
                         index: INTEGER;
                         leftOption := LineOption.IncludeBlanks):
  BOOLEAN;
</PRE><BLOCKQUOTE><EM> Return <CODE>index = StartOfLine(t, index, leftOption)</CODE> </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="MTextUnit.m3#EndOfLine">EndOfLine</A> (t    : T;
                     index: INTEGER;
                     rightOption := LineOption.IncludeNewline):
  INTEGER;
</PRE><BLOCKQUOTE><EM> Return the <CODE>rightMargin</CODE>, <CODE>rightEnd</CODE>, or <CODE>right</CODE> field of
   <CODE>LineInfo(t, index)</CODE>, depending on whether <CODE>rightOption</CODE> is
   <CODE>ExcludeBlanks</CODE>, <CODE>IncludeBlanks</CODE>, or <CODE>IncludeNewline</CODE>,
   respectively. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="MTextUnit.m3#IsEndOfLine">IsEndOfLine</A> (t    : T;
                       index: INTEGER;
                       rightOption := LineOption.IncludeNewline):
  BOOLEAN;
</PRE><BLOCKQUOTE><EM> Return <CODE>index = EndOfLine (t, index, rightOption)</CODE> </EM></BLOCKQUOTE><PRE>
</PRE> \subsubsection{Blank lines} 

<P><PRE>PROCEDURE <A HREF="MTextUnit.m3#IsBlankLine">IsBlankLine</A> (t: T; index: INTEGER): BOOLEAN;
</PRE><BLOCKQUOTE><EM> Return <CODE>TRUE</CODE> if <CODE>index</CODE> is located on a line that consists
   entirely of blanks, tabs, and form-feeds, including empty
   lines. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="MTextUnit.m3#BlankLinesExtent">BlankLinesExtent</A> (t: T; ndex: INTEGER): Extent;
</PRE><BLOCKQUOTE><EM> Computes the extent of maximal sequence of blank lines
   surrounding <CODE>index</CODE>. </EM></BLOCKQUOTE><PRE>
</PRE> \subsubsection{Paragraphs} 

<P> A {\it paragraph} is a maximal sequence of non-blank lines, in
   the sense of <CODE>LineExtent</CODE> where the left option is
   <CODE>IncludeBlanks</CODE> and the right option is <CODE>IncludeNewline</CODE>. 

<P><PRE>PROCEDURE <A HREF="MTextUnit.m3#ParagraphExtent">ParagraphExtent</A> (t: T; index: INTEGER): Extent;

PROCEDURE <A HREF="MTextUnit.m3#StartOfParagraph">StartOfParagraph</A> (t: T; index: INTEGER): INTEGER;
</PRE><BLOCKQUOTE><EM> Return the largest <CODE>i &lt;= index</CODE> for which
   <CODE>IsStartOfParagraph(t, i)</CODE> is <CODE>TRUE</CODE>.  Return <CODE>-1</CODE> if there is
   no such <CODE>i</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="MTextUnit.m3#IsStartOfParagraph">IsStartOfParagraph</A> (t: T; index: INTEGER): BOOLEAN;
</PRE><BLOCKQUOTE><EM> Equivalent to
<PRE>
      WITH e = ParagraphExtent(t, index) DO
       RETURN e.inside AND e.left = index END
   </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="MTextUnit.m3#EndOfParagraph">EndOfParagraph</A> (t: T; index: INTEGER): INTEGER;
</PRE><BLOCKQUOTE><EM> Return the smallest <CODE>i &gt;= index</CODE> for which
   <CODE>IsEndOfParagraph(t, i)</CODE> is <CODE>TRUE</CODE>.  Return <CODE>-1</CODE> if there is
   no such <CODE>i</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="MTextUnit.m3#IsEndOfParagraph">IsEndOfParagraph</A> (t: T; index: INTEGER): BOOLEAN;
</PRE><BLOCKQUOTE><EM> Equivalent to
<PRE>
      WITH e = ParagraphExtent(t, index) DO
       RETURN NOT e.inside AND e.left = index END
   </EM></BLOCKQUOTE><PRE>

END MTextUnit.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
