<HTML>
<HEAD>
<TITLE>SRC Modula-3: etext/src/MacModel.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>etext/src/MacModel.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
&lt;* PRAGMA LL *&gt;

INTERFACE <interface><A HREF="MacModel.m3">MacModel</A></interface>;

IMPORT <A HREF="TextPortClass.i3">TextPortClass</A>;

TYPE <A HREF="MacModel.m3#T">T</A> &lt;: TextPortClass.Model;

END MacModel.
</PRE> The Mac model supports only a single selection, Primary. Is it not
   an alias for either Source or Target. A Primary selection in a
   non-readonly textport is always in replace-mode.
<P>
   The conventions for the Mac model are taken from Apple's {\it Human
   Interface Guidelines} \cite[pages 106-114]{AppleUI}.
<P>
   The first unmodified downclick establishes the {\it anchor point}.
   If the user then drags the mouse, the upclick establishes the {\it
   active end}; the range between the anchor point and the active end
   is the Primary selection, and it is highlighted. If the user
   releases the mouse without dragging, that establishes the {\it
   type-in point}, and there is no selection or highlighting.
<P>
   Shift-downclick extends (or reduces) the primary selection and
   establishes the new active end.
<P>
   Double-clicking selects a word; dragging after a double-click
   extends the selection in word-size increments.
<P>
   The Mac model implements the following Apple guidelines:
<P>
   \begin{quote}
<P>
   When a Shift-arrow key combination is pressed, the active end of
   the selection moves and the range over which it moves becomes
   selected. ...  Option-Shift-Left Arrow selects the whole word that
   contains the character to the left of the insertion point (just
   like double-clicking on a word).
<P>
   In a text application, pressing Shift and either Left Arrow or
   Right Arrow selects a single character.  Assuming that the Left
   Arrow key was used, the anchor point of the selection is on the
   right side of the selection, the active end on the left.  Each
   subsequent Shift-Left Arrow adds another character to the left side
   of the selection.  A Shift-Right Arrow at this point shrinks the
   selection.
<P>
   Pressing Option-Shift and either Left Arrow or Right Arrow ...
   selects the entire word containing the character to the left of the
   insertion point.  Assuming Left Arrow was pressed, the anchor point
   is at the right end of the word, the active end at the left.  Each
   subsequent Option-Shift-Left Arrow adds another word to the left
   end of the selection...
<P>
   When a block of text is selected, either with a pointing device or
   with cursor keys, pressing either Left Arrow or Right Arrow
   deselects the range.  If Left Arrow is pressed, the insertion point
   goes to the beginning of what had been the selection.  If Right
   Arrow is pressed, the insertion point goes to the end of what had
   been the selection.
<P>
   [From page 83] When the user chooses Cut, ... the place where the
   selection used to be becomes the new selection. ... In text, the
   new selection is an insertion point [and the highlighting is
   removed].
<P>
   Paste ... inserts the contents of the Clipboard [Source] into the
   document, replacing the current selection [i.e., Primary selections
   are always replace-mode].  If there is no current selection, it's
   inserted at the insertion point.... After a Paste, the new
   selection is ... an insertion point immediately after the pasted
   text. [In either case, there is no highlighting.]
<P>
   \end{quote}
<P>
   In documentation from Apple, Mac keybindings are typically
   described in terms of ``command'' and ``option'' modifiers. DEC
   keyboards and the X server do not use those terms, but a
   correspondence can be established. The Mac model uses the value of
   environment variable <CODE>MacCommandModifier</CODE>\index{MacCommandModifier}
   to name the X-modifier that the user would like to behave as if it
   were the ``command'' key. The choices are:
<PRE>
      lock, control, mod1, mod2, mod3, mod4, <KBD>and</KBD> mod5 
   </PRE>
(Case is not significant in these names.) The default is <CODE>control</CODE>.
   Consult the manpage for <CODE>xmodmap(1)</CODE> for more information on these 
   modifiers.
<P>
   Similarly, the Mac model uses the environment variable
   <CODE>MacOptionModifier</CODE>\index{MacOptionModifier} to name the X-modifier
   that the user would like to behave as if it were the ``option''
   key. The choices are the same as in the list above.  The default is
   <CODE>mod1</CODE>.
<P>
   The following commands are implemented in the Mac model:
<P>
\begin{center}
\begin{tabbing}
LongCommandKeyName \= This is just a tab-setting line. \kill
command-c \&gt; {\bf Copy} \\
command-v \&gt; {\bf Paste} \\
command-x \&gt; {\bf Cut} \\
command-z \&gt; {\bf Undo} \\
command-shift-z \&gt; {\bf Redo} \\
\end{tabbing}
\end{center}
<P>
   The Mac model supports the Apple standards for typing extended
   characters, insofar as the resulting characters are defined for ISO
   Latin-1. For example, option-g produces the copyright symbol,
   \copyright, but option-shift-7, which produces a double dagger,
   \ddag, on the Macintosh, produces no key in the Mac model, since
   the double-dagger is not in ISO Latin-1. The Mac model supports all
   the two-character sequences, such as option-e followed by ``a'' to
   produce ``a'' with an acute accent, \'{a}. The complete table appears
   on page~\pageref{MacExtendedCharacters}. 

</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
