<HTML>
<HEAD>
<TITLE>SRC Modula-3: etext/src/TextEditVBT.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>etext/src/TextEditVBT.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
&lt;* PRAGMA LL *&gt;

MODULE <module><implements><A HREF="TextEditVBT.i3">TextEditVBT</A></implements></module>;

IMPORT <A HREF="../../geometry/src/Axis.i3">Axis</A>, <A HREF="../../ui/src/split/HVSplit.i3">HVSplit</A>, <A HREF="../../ui/src/vbt/PaintOp.i3">PaintOp</A>, <A HREF="../../ui/src/vbt/Pixmap.i3">Pixmap</A>, <A HREF="../../vbtkitutils/src/Pts.i3">Pts</A>, <A HREF="../../rw/src/Common/Rd.i3">Rd</A>,
       <A HREF="../../lego/src/ScrollerVBTClass.i3">ScrollerVBTClass</A>, <A HREF="../../ui/src/split/Split.i3">Split</A>, <A HREF="TextPort.i3">TextPort</A>, <A HREF="TextPortClass.i3">TextPortClass</A>,
       <A HREF="../../ui/src/split/TextureVBT.i3">TextureVBT</A>, <A HREF="../../thread/src/Common/Thread.i3">Thread</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>, <A HREF="../../vtext/src/VTDef.i3">VTDef</A>, <A HREF="../../vtext/src/VText.i3">VText</A>;

REVEAL
  <A NAME="T">T</A> = Public BRANDED OBJECT OVERRIDES init := Init END;
  <A NAME="Private">Private</A> = HVSplit.T BRANDED OBJECT END;

REVEAL
  <A NAME="Scrollbar">Scrollbar</A> = TextPortClass.Scrollbar BRANDED OBJECT
              OVERRIDES
                scroll     := Scroll;
                autoScroll := AutoScroll;
                thumb      := Thumb;
                update     := Update
              END;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A> (v: T; scrollable := TRUE): T =
  VAR colors: PaintOp.ColorScheme;
  BEGIN
    TRY
      v := HVSplit.T.init (v, Axis.T.Hor);
      IF v.tp = NIL THEN v.tp := NEW (TextPort.T).init () END;
      Split.Insert (v, NIL, v.tp);
      colors := v.tp.getColorScheme ();
      IF scrollable THEN
        IF v.sb = NIL THEN
          v.sb := NEW (Scrollbar).init (Axis.T.Ver, colors)
        END;
        v.tp.scrollbar := v.sb;
        v.sb.textport := v.tp;
        Split.Insert (v, NIL, NEW (TextureVBT.T, shape := Shape).init (
                                colors.fg, Pixmap.Solid));
        Split.Insert (v, NIL, v.sb)
      END
    EXCEPT
    | Split.NotAChild =&gt;         &lt;* ASSERT FALSE *&gt;
    END;
    RETURN v
  END Init;

PROCEDURE <A NAME="Shape"><procedure>Shape</procedure></A> (v: TextureVBT.T; ax: Axis.T; n: CARDINAL): VBT.SizeRange =
  VAR sr: VBT.SizeRange;
  BEGIN
    IF ax = Axis.T.Hor THEN
      sr.lo := Pts.ToScreenPixels (v, 1.0, Axis.T.Hor);
      sr.pref := sr.lo;
      sr.hi := sr.lo + 1;
      RETURN sr
    ELSE
      RETURN TextureVBT.T.shape (v, ax, n)
    END
  END Shape;

PROCEDURE <A NAME="Update"><procedure>Update</procedure></A> (s: Scrollbar) =
  &lt;* LL = v.mu *&gt;
  CONST name = &quot;Update Scrollbar&quot;;
  VAR
    v     := s.textport;
    vtext := v.vtext;
    start: CARDINAL;
  BEGIN
    TRY
      start := VText.StartIndex (vtext, 0);
      ScrollerVBTClass.Update (
        s, start, start + VText.CharsInRegion (vtext, 0),
        v.length ())
    EXCEPT
    | VTDef.Error (ec) =&gt; v.vterror (name, ec)
    | Rd.EndOfFile =&gt; v.rdeoferror (name)
    | Rd.Failure (ref) =&gt; v.rdfailure (name, ref)
    | Thread.Alerted =&gt;
    END
  END Update;

CONST NearEdge = 13;
</PRE><BLOCKQUOTE><EM> Thumbing closer than this to top/bottom of scroll bar is treated as
       being exactly at the top/bottom. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A NAME="Scroll"><procedure>Scroll</procedure></A> (                      s     : Scrollbar;
                  &lt;* UNUSED *&gt; READONLY cd    : VBT.MouseRec;
                                        part  : INTEGER;
                  &lt;* UNUSED *&gt;          height: INTEGER;
                  towardsEOF: BOOLEAN) =
  &lt;* LL= VBT.mu *&gt;
  CONST name = &quot;Scroll&quot;;
  VAR
    v                 := s.textport;
    vtext             := v.vtext;
    distance: INTEGER;
  BEGIN
    LOCK v.mu DO
      TRY
        distance := MAX (1, VText.WhichLine (vtext, 0, part));
        IF NOT towardsEOF THEN distance := -distance END;
        VText.Scroll (vtext, 0, distance);
        VText.Update (vtext);
        s.update ()
      EXCEPT
      | VTDef.Error (ec) =&gt; v.vterror (name, ec)
      | Rd.EndOfFile =&gt; v.rdeoferror (name)
      | Rd.Failure (ref) =&gt; v.rdfailure (name, ref)
      | Thread.Alerted =&gt;
      END
    END
  END Scroll;

PROCEDURE <A NAME="AutoScroll"><procedure>AutoScroll</procedure></A> (                      s : Scrollbar;
                      &lt;* UNUSED *&gt; READONLY cd: VBT.MouseRec;
                      linesToScroll: CARDINAL;
                      towardsEOF   : BOOLEAN   ) =
  &lt;* LL = VBT.mu *&gt;
  CONST name = &quot;AutoScroll&quot;;
  VAR
    distance: INTEGER := linesToScroll;
    v                 := s.textport;
    vtext             := v.vtext;
  BEGIN
    LOCK v.mu DO
      IF NOT towardsEOF THEN distance := -distance END;
      TRY
        VText.Scroll (vtext, 0, distance);
        VText.Update (vtext);
        s.update ()
      EXCEPT
      | VTDef.Error (ec) =&gt; v.vterror (name, ec)
      | Rd.EndOfFile =&gt; v.rdeoferror (name)
      | Rd.Failure (ref) =&gt; v.rdfailure (name, ref)
      | Thread.Alerted =&gt;
      END
    END
  END AutoScroll;

PROCEDURE <A NAME="Thumb"><procedure>Thumb</procedure></A> (                      s     : Scrollbar;
                 &lt;* UNUSED *&gt; READONLY cd    : VBT.MouseRec;
                                       part  : INTEGER;
                                       height: INTEGER       ) =
  &lt;* LL = VBT.mu *&gt;
  CONST name = &quot;Thumb&quot;;
  VAR
    position: CARDINAL;
    v                  := s.textport;
    vtext              := v.vtext;
    length             := v.length ();
  BEGIN
    LOCK v.mu DO
      TRY
        IF length = 0 OR part &lt; NearEdge THEN
          position := 0
        ELSIF part + NearEdge &gt; height THEN
          position := length - 1
        ELSE
          position :=
            MAX (0, ROUND (FLOAT (length)
                             * (FLOAT (part) / FLOAT (height))))
        END;
        VText.SetStart (vtext, 0, position);
        VText.Update (vtext);
        s.update ()
      EXCEPT
      | VTDef.Error (ec) =&gt; v.vterror (name, ec)
      | Rd.EndOfFile =&gt; v.rdeoferror (name)
      | Rd.Failure (ref) =&gt; v.rdfailure (name, ref)
      | Thread.Alerted =&gt;
      END
    END
  END Thumb;

BEGIN
END TextEditVBT.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
