<HTML>
<HEAD>
<TITLE>SRC Modula-3: etext/src/TextPort.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>etext/src/TextPort.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                              </EM></BLOCKQUOTE><PRE>
&lt;* PRAGMA LL *&gt;
</PRE> A textport is a <CODE>VBT</CODE> that allows the user to type and edit text.
<P>
   The methods and procedures in this interface fall into several categories,
   each dealing with different aspects of the text-editor. 
<P>
   \begin{description}
   <P>
   \item[Appearance] The client can choose the font, colors, margins,
   and whether long lines should be clipped or wrapped. The fonts and
   colors can be changed dynamically.
<P>
   \item[Access to the text] There are procedures to read and write
   subsequences of the text, to read and set the current ``type-in''
   point (cursor position), to get the length of the text, and to make
   the text read-only.
<P>
   \item[Keybindings and Text-Selections] A textport is initialized
   with a {\em model}, an object (defined in the <CODE>TextPortClass</CODE>
   interface) that establishes the connection between keystrokes and
   editing operations, and the connection between mouse-gestures, the
   cursor position, local selections (including highlighted regions),
   and global selections such as the ``clipboard'' (<CODE>VBT.Source</CODE>).
   Four such models are implemented---Emacs, Ivy, Xterm, and
   Mac---corresponding to different editing paradigms. The choice of
   model can be changed dynamically. The client may override the
   <CODE>filter</CODE> method to intercept keystrokes.
<P>
   \item[Feedback] A textport has callback-methods that are invoked
   when the text changes, when the user types Return or Tab, when the
   textport gains or loses the keyboard focus, when the visible
   region changes, and when errors are detected. All these methods
   have defaults.
<P>
   \end{description}
<P>
   The locking level for all procedures is <CODE>LL &lt;= VBT.mu</CODE> except as noted. 

<P><PRE>INTERFACE <interface><A HREF="TextPort.m3">TextPort</A></interface>;

IMPORT <A HREF="../../ui/src/vbt/Font.i3">Font</A>, <A HREF="../../ui/src/vbt/PaintOp.i3">PaintOp</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>, <A HREF="../../vtext/src/VText.i3">VText</A>;

TYPE
  <A HREF="TextPort.m3#T">T</A> &lt;: Public;
  Public = VBT.Leaf OBJECT
           METHODS
             init (hMargin, vMargin := 0.5;
                   font             := Font.BuiltIn;
                   colorScheme: PaintOp.ColorScheme := NIL;
                   wrap                             := TRUE;
                   readOnly                         := FALSE;
                   turnMargin                       := 0.5;
                   model := Model.Default): T;

             &lt;* LL.sup = VBT.mu *&gt;
             filter         (cd: VBT.KeyRec);
             getFont        (): Font.T;
             setFont        (font: Font.T);
             getColorScheme (): PaintOp.ColorScheme;
             setColorScheme (c: PaintOp.ColorScheme);
             getModel       (): SpecificModel;
             setModel       (model: Model);
             getReadOnly    (): BOOLEAN;
             setReadOnly    (flag: BOOLEAN);

             (* callbacks *)
             modified     ();
             returnAction (READONLY cd: VBT.KeyRec);
             tabAction    (READONLY cd: VBT.KeyRec);
             focus (gaining: BOOLEAN; time: VBT.TimeStamp);
             error        (msg: TEXT);

           END;
</PRE> The call <CODE>v.init(...)</CODE> initializes <CODE>v</CODE> as a <CODE>TextPort.T</CODE> and
   returns it.
<P>
   The parameters <CODE>hMargin</CODE> and <CODE>vMargin</CODE> indicate how much whitespace
   to leave around the text, expressed in millimeters.
<P>
   <CODE>colorScheme</CODE> is used for painting the text.  If the parameter is
   <CODE>NIL</CODE>, then <CODE>PaintOp.bgFg</CODE> will be used.
<P>
   If <CODE>wrap</CODE> is <CODE>TRUE</CODE>, then text will be wrapped across line
   boundaries; otherwise it will be clipped.  If it is wrapped, then
   <CODE>turnMargin</CODE> specifies the width (in millimeters) of the gray bar
   placed at the end of the first line and the beginning of the
   second, indicating that the text has been wrapped.
<P>
   If <CODE>readOnly</CODE> is <CODE>TRUE</CODE>, then the text cannot be changed through
   the user interface (keyboard and mouse).  The procedures <CODE>Replace</CODE>,
   <CODE>Insert</CODE>, <CODE>SetText</CODE>, and <CODE>PutText</CODE> bypass the read-only protection,
   but these are not called by internal routines.  In all other
   descriptions in this interface, the words {\it replace}, {\it insert},
   {\it delete}, and so on should be understood as having the
   restriction that <CODE>v</CODE> is not read-only.
<P>
   If <CODE>model</CODE> is <CODE>Model.Default</CODE>, then the current value of
   <CODE>DefaultModel</CODE> will be used. <CODE>DefaultModel</CODE> is defined below.
<P>
   <CODE>v.getModel()</CODE> returns the name of the current model; note that the
   return value cannot be <CODE>Model.Default</CODE>.  The call <CODE>v.setModel(...)</CODE>
   changes the current model; its parameter may be <CODE>Model.Default</CODE>, in
   which case the value of <CODE>DefaultModel</CODE> will be used.
<P>
   The call <CODE>v.setFont(font)</CODE> changes the font used for displaying
   the text.
<P>
   The call <CODE>v.setColorScheme(c)</CODE> changes the colors used for
   displaying the text.
<P>
   The implementation calls <CODE>v.focus(gaining, time)</CODE> whenever
   <CODE>v</CODE> gains or loses the keyboard focus.  If <CODE>gaining</CODE> is <CODE>TRUE</CODE>,
   then <CODE>v</CODE> is about to gain the keyboard focus (and <CODE>time</CODE> is a
   valid event-time); i.e., this method is called {\em before} the
   selection feedback is established, so it is reasonable to call
   <CODE>Select</CODE> (below) or put up some other indication.  If <CODE>gaining</CODE> is
   <CODE>FALSE</CODE>, then <CODE>v</CODE> has just lost the keyboard focus (and <CODE>time</CODE>
   is {\em not} valid), so it reasonable to take down whatever
   indicated that the focus had been acquired.  It is not within the
   power of the <CODE>focus</CODE> method to prevent <CODE>v</CODE> from gaining or
   losing the focus.  The default for this method is a no-op.
<P>
   The implementation calls <CODE>v.error(msg)</CODE> whenever an exception is
   raised for which there is no particular remedy, such as an
   <CODE>Rd.Failure</CODE>.  The value of <CODE>msg</CODE> will be a short description of
   the error, typically the name of the procedure where the exception
   was raised.  No method or procedure defined in this interface
   raises exceptions, but the client may wish to override this method
   in order to report the error in a popup window, for example. The
   default for this method is a procedure that tests whether the
   environment-variable named <CODE>TEXTPORTDEBUG</CODE>\index{TEXTPORTDEBUG} is
   set (to any value); if so, it writes the message to
   <CODE>Stdio.stderr</CODE>.
<P>


<P>
<P> \subsubsection{Access to the text}
   <P>
   The textport's initial read-only status depends on the <CODE>readOnly</CODE>
   parameter to the <CODE>init</CODE> method. The <CODE>getReadOnly</CODE> method returns
   it; the <CODE>setReadOnly</CODE> method sets it.
<P>
 

<P><PRE>PROCEDURE <A HREF="TextPort.m3#GetText">GetText</A> (v    : T;
                   begin: CARDINAL := 0;
                   end  : CARDINAL := LAST (CARDINAL)): TEXT;
&lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Returns a sub-sequence of the text in <CODE>v</CODE>.  The result will be
   empty if
<PRE>
      begin &gt;= Length(v)
   </PRE>
Otherwise the range of indexes of the subsequence is
<PRE>
      [begin .. MIN (end, Length (v)) - 1]
   </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="TextPort.m3#SetText">SetText</A> (v: T; t: TEXT);
</PRE><BLOCKQUOTE><EM> Replace the current contents of <CODE>v</CODE> with <CODE>t</CODE>. This procedure does
   not test the read-only status of <CODE>v</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="TextPort.m3#PutText">PutText</A> (v: T; t: TEXT);
</PRE><BLOCKQUOTE><EM> Append <CODE>t</CODE> to the current contents of <CODE>v</CODE>.  This procedure does not
   test the read-only status of <CODE>v</CODE>.</EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="TextPort.m3#Replace">Replace</A> (v: T; begin, end: CARDINAL; newText: TEXT);
</PRE><BLOCKQUOTE><EM> Replace the text between positions <CODE>begin</CODE> and <CODE>end</CODE> in <CODE>v</CODE> with
   <CODE>newText</CODE>.  If <CODE>begin</CODE> and <CODE>end</CODE> are beyond the end of the text,
   they are taken to refer to the end of the text.  This procedure
   does not test the read-only status of <CODE>v</CODE>.</EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="TextPort.m3#Insert">Insert</A> (v: T; text: TEXT);
</PRE><BLOCKQUOTE><EM> If there is a replace-mode selection (see
   Section~\ref{ReplaceMode}, page~\pageref{ReplaceMode}), replace it
   with <CODE>text</CODE>; otherwise insert <CODE>text</CODE> at the type-in point. In
   either case, this is a no-op if <CODE>text</CODE> is the empty string.  This
   procedure does not test the read-only status of <CODE>v</CODE>.</EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="TextPort.m3#Index">Index</A> (v: T): CARDINAL;
</PRE><BLOCKQUOTE><EM> Return the current ``type-in'' position. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="TextPort.m3#Seek">Seek</A> (v: T; n: CARDINAL);
</PRE><BLOCKQUOTE><EM> Set the ``type-in'' position to <CODE>n</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="TextPort.m3#Length">Length</A> (v: T): CARDINAL;
</PRE><BLOCKQUOTE><EM> Return the number of characters in <CODE>v</CODE>'s text. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="TextPort.m3#Newline">Newline</A> (v: T);
</PRE><BLOCKQUOTE><EM> Insert a newline character at the type-in point. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="TextPort.m3#NewlineAndIndent">NewlineAndIndent</A> (v: T);
</PRE><BLOCKQUOTE><EM> Insert a newline character and enough spaces to match the
   indentation of the previous line.  As it leaves a blank line,
   it will delete all spaces from that line so as to leave it
   truly empty. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="TextPort.m3#IsVisible">IsVisible</A> (v: T; pos: CARDINAL): BOOLEAN;
</PRE><BLOCKQUOTE><EM> Test whether the character at position <CODE>pos</CODE> is visible. </EM></BLOCKQUOTE><PRE>
</PRE> \subsubsection {Models}\index{Model} 

<P><PRE>TYPE
  Model = {Default, Ivy, Emacs, Mac, Xterm};
  SpecificModel = [Model.Ivy .. Model.Xterm];

VAR DefaultModel: SpecificModel := Model.Emacs;
</PRE> The initial value of <CODE>DefaultModel</CODE> depends on the environment
   variable named <CODE>TEXTPORTMODEL</CODE>;\index{TEXTPORTMODEL} if that is set
   to <CODE>emacs</CODE>, <CODE>ivy</CODE>, <CODE>mac</CODE>, or <CODE>xterm</CODE> at startup time, then
   <CODE>DefaultModel</CODE> will be set accordingly.  If it is not defined, or
   is defined as some other value, then the initial value of
   <CODE>DefaultModel</CODE> will be <CODE>Model.Emacs</CODE>. See the <CODE>EmacsModel</CODE>,
   <CODE>IvyModel</CODE>, <CODE>XtermModel</CODE>, and <CODE>MacModel</CODE> interfaces in Appendices
   \ref{EmacsModel}--\ref{XtermModel} for details on keybindings,
   mouse-clicks, and selections.

<P><PRE>PROCEDURE <A HREF="TextPort.m3#ChangeAllTextPorts">ChangeAllTextPorts</A> (newModel := Model.Default);
</PRE><BLOCKQUOTE><EM> For each textport <CODE>p</CODE>, call <CODE>p.setModel(newModel)</CODE>.  (The
   implementation maintains a list of weak references to all
   initialized textports.)  The principal client is <CODE>FormsVBT</CODE>. </EM></BLOCKQUOTE><PRE>
</PRE> \subsubsection {Keybindings}\label{TextPortKeybindings}
<P>
   The <CODE>TextPort</CODE> interface allows clients a great deal of flexibility
   in handling keystrokes.  <CODE>v.key(cd)</CODE> proceeds in
   three steps:
<P>
   In step 1, it tests whether <CODE>cd.wentDown</CODE> is true, whether <CODE>v</CODE>
   has the keyboard focus, and whether <CODE>v</CODE>'s domain is non-empty.
   If all three conditions are true, it proceeds to step 2.
<P>
   In step 2, it passes <CODE>cd</CODE> to the model's <CODE>keyfilter</CODE> object, which
   handles low-level tasks such as converting ``Escape + character''
   into ``meta-character'' (in Emacs mode), 8-bit ``compose
   character'' operations, and so on.  The model may actually contain
   a {\em chain} of keyfilters (see the <CODE>KeyFilter</CODE> interface), each
   implementing some translation.
<P>
   In step 3, the model passes <CODE>cd</CODE> (possibly changed by the
   keyfilters) to the textport's <CODE>filter</CODE> method. Clients who wish
   to intercept keystrokes usually do so at this point, by overriding
   the <CODE>filter</CODE> method, rather than by overriding the <CODE>key</CODE> method, so
   that they can take advantage of the low-level conversions.
<P>
   In the default <CODE>filter</CODE> method, there are several mutually
   exclusive possibilities, tested in this order:
<P>
   \begin{itemize}
<P>
   \item{If the key is Return, then if the <CODE>shift</CODE> modifier is on, we
   insert a newline; if the <CODE>option</CODE> modifier is on, we insert a
   newline but leave the cursor in place; otherwise, we invoke
   <CODE>v.returnAction(cd)</CODE>, another callback method. Its default
   method calls <CODE>NewlineAndIndent(v, cd)</CODE>.}
<P>
   \item{If the key is Tab, we invoke <CODE>v.tabAction(cd)</CODE>.  The
   default method inserts 4 spaces.}
<P>
   \item{If the key is an ``arrow'' key, we call the model's
   <CODE>arrowKey</CODE> method, which moves the cursor one character forward,
   one character backward, one line up, or one line down, as
   appropriate.}
<P>
   \item{If the <CODE>control</CODE> modifier is on, we call the model's
   <CODE>controlChord</CODE> method.}
<P>
   \item{If the <CODE>option</CODE> modifier is on, we call the model's
   <CODE>optionChord</CODE> method.}
<P>
   \item{If the key is Backspace or Delete, we delete the previous
   character, or the current primary selection, if that is non-empty and
   in replace-mode.}
<P>
   \item{If the key is an ISO Latin-1 graphic character, we insert it into
   the text.}
<P>
   \item{Otherwise, we ignore it.}
<P>
   \end{itemize}
<P>
   Finally, we call <CODE>Normalize(v)</CODE>, except in the <CODE>controlChord</CODE> and
   <CODE>optionChord</CODE> cases.
<P>
   Clients can specialize the handling of keys, therefore, by
   overriding the textport's <CODE>key</CODE>, <CODE>filter</CODE>, <CODE>returnAction</CODE>, or
   <CODE>tabAction</CODE> methods, and by overriding the model's <CODE>controlChord</CODE>,
   <CODE>optionChord</CODE>, or <CODE>arrowKey</CODE> methods.
<P>
   The following procedures give the client access to the keyboard
   focus:


<P><PRE>PROCEDURE <A HREF="TextPort.m3#TryFocus">TryFocus</A> (v: T; t: VBT.TimeStamp): BOOLEAN;
</PRE><BLOCKQUOTE><EM> Try to acquire the keyboard focus and the primary selection, and
   report whether it succeeded. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="TextPort.m3#HasFocus">HasFocus</A> (v: T): BOOLEAN; &lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Test whether <CODE>v</CODE> has the keyboard focus. </EM></BLOCKQUOTE><PRE>
</PRE> \subsubsection{Selections}\label{TextPortSelections}
<P>
   With various keyboard and mouse-gestures, the user may delimit a
   range of text, known as a {\em local selection}.  The <CODE>TextPort</CODE>
   interface defines two local selections, called {\em primary} and
   {\em secondary}. The mechanism for doing this depends entirely on
   the textport's model. (In fact, only the Ivy model implements
   secondary selection.) The type-in point is always at one end or the
   other of the primary selection.
<P>
   Primary selections in non-readonly textports may be in {\em
   replace mode}, also called {\em pending-delete mode}. This means
   that any text that is inserted will replace the primary selection,
   and that the Backspace and Delete keys will delete it.
<P>
   Independent of the local selections are the two {\em global
   selections} defined by Trestle: <CODE>VBT.Source</CODE> and <CODE>VBT.Target</CODE>.  On
   X window systems, these are defined by the X server, and are shared
   across applications. The Source selection, for example, is
   effectively the ``clipboard.'' Globals selections are ``owned'' by
   one program at a time; in Trestle programs, they are owned by one
   <CODE>VBT</CODE> at a time. While every textport may have a primary and
   secondary local selection, at most one can own Source, and at most
   one can own Target. The {\em contents} of a global selection are
   controlled by its owner.
<P>
   The correspondence between local and global selections also depends
   entirely on the model. Every model implements an operation called
   {\bf Copy}\index{Copy}, which is defined as follows: the textport
   acquires ownership of Source, and copies the Primary selection so
   that it is the contents of Source.
<P>
   Some models establish an {\em alias}\index{alias} between a local
   and a global selection, which means that when that textport owns
   the global selection, the contents of the global selection are
   {\em identical with} the contents of the local selection.
<P>
   In the Ivy model, for example, Primary is an alias for Target, and
   Secondary is an alias for Source. In the Xterm model, Primary is an
   alias for Source. The other models do not use aliasing at all; they
   implement {\bf Copy} by making a separate copy of the local
   selection. In those models, the contents of the global selection
   are not visible; i.e., they are not displayed in the textport.
<P>
   Local selections are usually highlighted in some way. The
   highlighting obeys the following conventions, applied in this
   order:
<P>
   \begin{enumerate}\index{TextPortHighlighting}\label{TextPortHighlighting}
<P>
   \item A replace-mode Primary selection is highlighted with black
   text on a light red background.  (On monochrome screens, it is
   highlighted with ``inverse video'': white text on a dark
   background.)
<P>
   \item If a Source selection is visible (i.e., if it is aliased with
   a local selection), it is highlighted with a thin, green underline.
   (On monochrome screens, it is a thin, black underline.)
<P>
   \item A Primary selection that is neither a replace-mode selection
   nor a Source selection (e.g., a selection in the Emacs model), is
   underlined with a thick line.  On color screens, there is a further
   distinction: in a read-only text, the underline is blue; otherwise,
   the underline is red.
<P>
   \end{enumerate}
<P>
   A selection is represented by a pair of inclusive indexes (<CODE>begin</CODE>
   and <CODE>end</CODE>) into the text.  The current selection-indices can be
   retrieved via the <CODE>GetSelection</CODE> procedure.
 

<P><PRE>TYPE SelectionType = {Primary, Secondary};

PROCEDURE <A HREF="TextPort.m3#Select">Select</A> (v    : T;
                  time : VBT.TimeStamp;
                  begin: CARDINAL        := 0;
                  end  : CARDINAL        := LAST (CARDINAL);
                  sel         := SelectionType.Primary;
                  replaceMode := FALSE;
                  caretEnd    := VText.WhichEnd.Right   );
</PRE> Make a selection in <CODE>v</CODE>, at event-time <CODE>time</CODE>.  If <CODE>begin</CODE> and/or
   <CODE>end</CODE> are beyond the end of the text, they will be clipped to the
   end of the text.  Acquire ownership of the corresponding
   <CODE>VBT.Selection</CODE>; if <CODE>sel</CODE> is <CODE>SelectionType.Primary</CODE>, acquire
   ownership of the keyboard focus as well.
<P>
   The parameters <CODE>replaceMode</CODE> and <CODE>caretEnd</CODE> are relevant only if
   the value of <CODE>sel</CODE> is <CODE>SelectionType.Primary</CODE>.  If <CODE>replaceMode</CODE> is
   <CODE>TRUE</CODE> and the entire selection is writable, then <CODE>Insert</CODE> and
   <CODE>VBT.Write</CODE> will {\em replace} the selected text; otherwise, they
   cause the new text to be {\em inserted} at whichever end of the
   primary selection is specified by <CODE>caretEnd</CODE>. 

<P><PRE>PROCEDURE <A HREF="TextPort.m3#IsReplaceMode">IsReplaceMode</A> (v: T): BOOLEAN;
</PRE><BLOCKQUOTE><EM> Return <CODE>TRUE</CODE> if the primary selection is in replace mode. </EM></BLOCKQUOTE><PRE>

TYPE Extent = RECORD l, r: CARDINAL END;

CONST NotFound = Extent {LAST (CARDINAL), LAST (CARDINAL)};

PROCEDURE <A HREF="TextPort.m3#GetSelection">GetSelection</A> (v: T; sel := SelectionType.Primary):
  Extent;
</PRE><BLOCKQUOTE><EM> Return the extent of the most recent selection in <CODE>v</CODE>. If there is no
   such selection, return <CODE>NotFound</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="TextPort.m3#GetSelectedText">GetSelectedText</A> (v: T; sel := SelectionType.Primary):
  TEXT;
&lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Return the text of the most recent selection in <CODE>v</CODE> if there is one, or
   the empty string otherwise. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="TextPort.m3#PutSelectedText">PutSelectedText</A> (v: T;
                           t: TEXT;
                           sel := SelectionType.Primary);
&lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Replace the text of the most recent selection in <CODE>v</CODE>, if there is
   one, with <CODE>t</CODE>.  If there is no such selection, this is a no-op. </EM></BLOCKQUOTE><PRE>
</PRE> \subsubsection{Feedback}
<P>
   A textport maintains a ``modified'' flag.  Any operation that
   changes the text will cause this flag to be set to <CODE>TRUE</CODE>.  If it
   was previously <CODE>FALSE</CODE>, then the implementation calls
   <CODE>v.modified()</CODE> {\it after} the change has already happened to <CODE>v</CODE>.
   The default is a no-op.  The <CODE>IsModified</CODE> and <CODE>SetModified</CODE>
   procedures set and test this flag, respectively. 

<P><PRE>PROCEDURE <A HREF="TextPort.m3#IsModified">IsModified</A> (v: T): BOOLEAN;
</PRE><BLOCKQUOTE><EM> Return the value of the ``modified'' flag for <CODE>v</CODE>. Any change to
   the text will cause the flag to be set to <CODE>TRUE</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="TextPort.m3#SetModified">SetModified</A> (v: T; value: BOOLEAN);
</PRE><BLOCKQUOTE><EM> Set the value of the ``modified'' flag for <CODE>v</CODE>. This will not
   invoke <CODE>v.modified</CODE>, even if <CODE>value</CODE> is <CODE>TRUE</CODE>. </EM></BLOCKQUOTE><PRE>
</PRE> A textport also maintains a scrollbar (optional).  See the
   <CODE>TextEditVBT</CODE> interface in Section~\ref{TextEditVBTSection}. 

<P><PRE>PROCEDURE <A HREF="TextPort.m3#Normalize">Normalize</A> (v: T; to := -1);
</PRE><BLOCKQUOTE><EM> Scroll <CODE>v</CODE> if necessary to ensure that position <CODE>to</CODE> is visible.
   If <CODE>to &lt; 0</CODE>, it refers to the current type-in point.  If <CODE>to</CODE> is
   larger than the length of the text, normalizes to the end of the
   text. </EM></BLOCKQUOTE><PRE>
</PRE> \subsubsection{Direct access to the text} 

<P><PRE>PROCEDURE <A HREF="TextPort.m3#GetVText">GetVText</A> (v: T): VText.T;
</PRE><BLOCKQUOTE><EM> For wizards only: extract the underlying <CODE>VText</CODE>.  It is legal to
   create and manipulate highlighting intervals on it.  It is legal to
   run readers on it, provided you can be sure that you are locking
   out concurrent change (for example, by holding <CODE>VBT.mu</CODE>).  It is
   not legal to modify it directly.  It is not legal to scroll it
   directly either, because that will leave the scrollbar incorrect.
   </EM></BLOCKQUOTE><PRE>

END TextPort.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
