<HTML>
<HEAD>
<TITLE>SRC Modula-3: etext/src/TextPortClass.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>etext/src/TextPortClass.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
&lt;* PRAGMA LL                                                                 *&gt;
</PRE> The <CODE>TextPortClass</CODE> interface reveals more of the representation of
   a textport, and it defines the object-type (<CODE>Model</CODE>) that is used
   to implement keybindings and selection-controls.  Four subtypes of
   models are implemented: Ivy, Emacs, Mac, and Xterm.
   <CODE>TextPort.Model</CODE> is an enumeration type for the four names, but
   <CODE>TextPortClass.Model</CODE> is the type of the actual object attached to
   a textport, to which user-events (keys, mouse clicks, position
   reports) are sent.
<P>
   In this interface, the variable <CODE>v</CODE> always refers to a textport,
   and the variable <CODE>m</CODE> always refers to a model.
<P>
   Unless otherwise noted, the locking level of all procedures in this
   interface is <CODE>v.mu</CODE>.


<P><PRE>INTERFACE <interface><A HREF="TextPortClass.m3">TextPortClass</A></interface>;

IMPORT <A HREF="../../ui/src/vbt/Font.i3">Font</A>, <A HREF="KeyFilter.i3">KeyFilter</A>, <A HREF="../../ui/src/vbt/PaintOp.i3">PaintOp</A>, <A HREF="../../rw/src/Common/Rd.i3">Rd</A>, <A HREF="../../lego/src/ScrollerVBTClass.i3">ScrollerVBTClass</A>,
       <A HREF="TextPort.i3">TextPort</A>, <A HREF="../../thread/src/Common/Thread.i3">Thread</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>, <A HREF="../../vtext/src/VTDef.i3">VTDef</A>, <A HREF="../../vtext/src/VText.i3">VText</A>;

REVEAL TextPort.T &lt;: T;

TYPE VType = {Focus, Source, Target};
</PRE><BLOCKQUOTE><EM> Constants for the three Trestle selections used here. </EM></BLOCKQUOTE><PRE>

CONST
  Primary   = TextPort.SelectionType.Primary;
  Secondary = TextPort.SelectionType.Secondary;
  Focus     = VType.Focus;
  Source    = VType.Source;
  Target    = VType.Target;

TYPE
  Pixels = CARDINAL;
  T =
    TextPort.Public OBJECT
      mu: MUTEX;                 (* VBT.mu &lt; mu *)
      &lt;* LL = mu *&gt;
      m             : Model              := NIL;
      readOnly      : BOOLEAN;
      vtext         : VText.T;

      font          : Font.T;
      fontHeight    : Pixels             := 0;
      charWidth     : Pixels             := 0;
      scrollbar     : Scrollbar          := NIL;
      typeinStart   : CARDINAL;

      thisCmdKind   : CommandKind;
      lastCmdKind   : CommandKind;
      wishCol       : CARDINAL;

      cur           : UndoRec;

      owns := ARRAY VType OF BOOLEAN {FALSE, ..};

      &lt;* LL.sup = VBT.mu.SELF *&gt;
      lastNonEmptyWidth: Pixels := 0;

    METHODS
      &lt;* LL = SELF.mu *&gt;
      getText       (begin, end: CARDINAL): TEXT;
      index         (): CARDINAL;
      isReplaceMode (): BOOLEAN;
      length        (): CARDINAL;
      normalize     (to := -1);

      replace (begin, end: CARDINAL; newText: TEXT):
               TextPort.Extent;
      unsafeReplace (begin, end: CARDINAL; newText: TEXT):
                     TextPort.Extent;
      insert           (t: TEXT);
      unsafeInsert     (t: TEXT);
      getKFocus        (time: VBT.TimeStamp): BOOLEAN;
      newlineAndIndent ();

      findSource (time      : VBT.TimeStamp;
                  loc                         := Loc.Next;
                  ignoreCase                  := TRUE      );
      notFound ();

      (* All of these call SELF.error. *)
      vbterror   (msg: TEXT; ec: VBT.ErrorCode);
      vterror    (msg: TEXT; ec: VTDef.ErrorCode);
      rdfailure  (msg: TEXT; ec: REFANY);
      rdeoferror (msg: TEXT);

      (* We release SELF.mu around the following callbacks. *)
      ULreturnAction (READONLY cd: VBT.KeyRec);
      ULtabAction    (READONLY cd: VBT.KeyRec);
      ULfocus        (gaining: BOOLEAN; time: VBT.TimeStamp);
      ULmodified     ();
      ULerror        (msg: TEXT);

    END;
</PRE> <CODE>v.font</CODE> is the current font. <CODE>v.fontHeight</CODE> is the height of a
   (maximal) character. <CODE>v.charwidth</CODE> is the width of a (maximal)
   character. <CODE>v.scrollbar</CODE> contains the scrollbar that is updated
   when the visible region of text changes, and vice versa.
<P>
   <CODE>v.typeinStart</CODE> is meaningful only for typescripts, where it
   indicates the point that divides the ``history'' part of the
   transcript, which is read-only, from the current command line,
   which is not.  See the <CODE>TypescriptVBT</CODE> interface.  For
   non-typescripts, this field is always zero.
<P>
   <CODE>v.thisCmdKind</CODE> and <CODE>v.lastCmdKind</CODE> allow the interpretation of a
   command to depend on the previous command.  Currently, the only
   commands that depend on context are the ``vertical'' commands that
   call <CODE>UpOneLine</CODE> and <CODE>DownOneLine</CODE>. The column to which they move
   is stored in <CODE>v.wishCol</CODE>.
   <P>
   <CODE>v.cur</CODE> holds the information needed to reverse or reinstate the
   effects of editing operations that change the text.
<P>
   <CODE>v.owns[vtype]</CODE> is <CODE>TRUE</CODE> when <CODE>v</CODE> owns the <CODE>VBT.Selection</CODE>
   corresponding to <CODE>vtype</CODE>: keyboard focus, Source selection, or
   Target selection.
   <P>
   <CODE>v.lastNonEmptyWidth</CODE> is used by the <CODE>shape</CODE> and <CODE>reshape</CODE> methods.
   <P>
   <CODE>v.replace</CODE> tests <CODE>v.readOnly</CODE>; if that is <CODE>TRUE</CODE>, then it
   returns the constant <CODE>TextPort.NotFound</CODE>.  Otherwise it calls
   <CODE>v.unsafeReplace</CODE>, which is the only routine that actually
   alters the underlying text. (The ``unsafe'' methods are those
   that do not test <CODE>v.readOnly</CODE>.)
<P>
   <CODE>v.insert</CODE> calls <CODE>v.replace</CODE>; i.e., it is safe.
<P>
   <CODE>v.notFound</CODE> is called when a search fails; see <CODE>FindAndSelect</CODE>,
   below. The default method is a no-op.


<P><PRE>TYPE
  CommandKind = {VertCommand, OtherCommand};
  Scrollbar = ScrollerVBTClass.T OBJECT
                textport: T
              METHODS
                update ()        &lt;* LL = SELF.textport.mu *&gt;
              END;
</PRE> \subsubsection{Models}\index{Model}
<P>
   A <CODE>TextPortClass.Model</CODE> is the object that interprets keyboard and
   mouse events. The model can be replaced via <CODE>v.setModel</CODE>.
<P>
   {\em Keybindings}
<P>
   Trestle calls <CODE>v.key(cd)</CODE>, which calls <CODE>m.keyfilter.apply(v,cd)</CODE>,
   as described on page~\pageref{TextPortKeybindings}. A keyfilter is
   essentially a linked list of objects, each of which implements some
   low-level character translation such as ``quoted insert'' or
   ``compose character.'' The last link calls <CODE>v.filter(cd)</CODE>, which
   calls <CODE>m.controlChord</CODE> or <CODE>m.optionChord</CODE> for ``command-keys'',
   or <CODE>m.arrowKey</CODE> for cursor-keys.
   <P>
   {\em Text-selections}
<P>
   As explained on page~\pageref{TextPortSelections}, the model
   interprets keyboard and mouse events to establish the local
   selections, Primary and Secondary, which are subsequences of the
   text, usually highlighted in some way. The model also deals with
   the global selections, Source and Target, which may be owned
   (``acquired'') by any VBT or by an external program such as an
   Xterm shell. The owner of a global selection controls its contents;
   <CODE>read</CODE> and <CODE>write</CODE> calls are forwarded to the owner.
<P>
   A particular model may establish an ``alias'' relationship between
   a local selection and a global selection, which means that if the
   textport owns the global selection, then its contents are identical
   with (mapped to) the local selection. For example, in an Xterm
   shell, and therefore in the Xterm model, Primary is an alias for
   Source, which means that when you click and drag to highlight a
   region, that defines not only the local Primary selection but the
   global Source selection as well. Any program that asks to read the
   Source selection will be given a copy of the highlighted text.
<P>
   In Ivy, Primary is an alias for Target, and Secondary is an alias
   for Source. (Ivy users therefore have a hard time understanding
   the distinction between local and global selections, since they
   are wired together.)
<P>
   A Primary selection in a non-readonly textport may be in ``replace
   mode'' (or ``pending-delete mode''). In this mode, insertions
   replace the entire selection; Backspace deletes the entire
   selection.
<P>
   {\em Selection-related editing operations}
   \index{Cut}\index{Copy}\index{Paste}\index{Clear}
   \index{Select All}
<P>
   The standard editing operations such as Cut, Copy, and Paste, are
   defined not merely in terms of the underlying text, but also in
   terms of the effects they have on the local and global selections.
   Indeed, they are not functions at all; Copy does not return a copy
   of anything. 
<P>
   \begin{description}
<P>
   \item[Copy] If the Primary selection is not empty, then acquire
   Source, and unless Primary is an alias for Source, make a copy of
   the Primary selection as the contents of Source. (If Primary is an
   alias for Source, no copy is needed.)
<P>
   \item[Paste] If the Primary selection is not empty and is in
   replace-mode, then replace the Primary selection with the contents
   of Source. Otherwise, insert the contents of Source at the type-in
   point.
<P>
   \item[Clear] Delete the contents of the Primary selection.
<P>
   \item[Cut] This is defined as {\bf Copy} followed by {\bf Clear}.
<P>
   \item[Select All] Extend the Primary selection to include the
   entire text.
<P>
   \end{description}


<P><PRE>TYPE
  <A HREF="TextPortClass.m3#Model">Model</A> &lt;: PublicModel;
  PublicModel =
    OBJECT
      v: T;
      selection := ARRAY TextPort.SelectionType OF
                     SelectionRecord {NIL, NIL};
      dragging := FALSE;
      dragType := TextPort.SelectionType.Primary;
      approachingFromLeft: BOOLEAN;
      keyfilter          : KeyFilter.T
    METHODS
      &lt;* LL = SELF.v.mu *&gt;
      init  (cs: PaintOp.ColorScheme; keyfilter: KeyFilter.T):
             Model;
      close ();
      seek  (position: CARDINAL);

      (* Keybindings *)
      controlChord (ch: CHAR; READONLY cd: VBT.KeyRec);
      optionChord  (ch: CHAR; READONLY cd: VBT.KeyRec);
      arrowKey     (READONLY cd: VBT.KeyRec);

      (* Mouse and Selection-controls *)
      mouse    (READONLY cd: VBT.MouseRec);
      position (READONLY cd: VBT.PositionRec);
      misc     (READONLY cd: VBT.MiscRec);
      read     (READONLY s   : VBT.Selection;
                         time: VBT.TimeStamp): TEXT
             RAISES {VBT.Error};
      write    (READONLY s   : VBT.Selection;
                         time: VBT.TimeStamp;
                         t   : TEXT           )
             RAISES {VBT.Error};

      cut   (time: VBT.TimeStamp);
      copy  (time: VBT.TimeStamp);
      paste (time: VBT.TimeStamp);
      clear ();
      select (time : VBT.TimeStamp;
              begin: CARDINAL        := 0;
              end  : CARDINAL        := LAST (CARDINAL);
              sel                    := Primary;
              replaceMode            := FALSE;
              caretEnd               := VText.WhichEnd.Right);

      getSelection    (sel := Primary): TextPort.Extent;
      getSelectedText (sel := Primary): TEXT;
      putSelectedText (t: TEXT; sel := Primary);
      takeSelection (READONLY sel : VBT.Selection;
                              type: TextPort.SelectionType;
                              time: VBT.TimeStamp           ):
                     BOOLEAN;
      highlight (rec: SelectionRecord; READONLY r: IRange);
      extend    (rec: SelectionRecord; left, right: CARDINAL)
    END;
</PRE> <CODE>m.init(...)</CODE> initializes a Model <CODE>m</CODE>.  The default method stores
   <CODE>keyfilter</CODE> and returns <CODE>m</CODE>.
<P>
   <CODE>m.close()</CODE> releases the <CODE>VBT</CODE> selections (Source, Target, and
   KBFocus) and deletes highlighting intervals.
<P>
   <CODE>m.seek(position)</CODE> sets the type-in point. 
<P>
   The type <CODE>TextPort.T</CODE> overrides the <CODE>VBT</CODE> <CODE>mouse</CODE>, <CODE>position</CODE>,
   <CODE>misc</CODE>, <CODE>read</CODE>, and <CODE>write</CODE> methods with procedures that lock
   <CODE>v.mu</CODE> and call <CODE>m.mouse</CODE>, <CODE>m.position</CODE>, etc.  Note that the
   signatures are not identical to their Trestle counterparts.
   <CODE>v.position</CODE> checks <CODE>m.dragging</CODE> and <CODE>cd.cp.gone</CODE> before
   calling <CODE>m.position</CODE>.
<P>
   Clients must override the <CODE>read</CODE> method with a procedure that
   returns a text if <CODE>m</CODE> owns the selection <CODE>s</CODE>; otherwise it should
   call the default method, which calls <CODE>VBT.Read(s, time)</CODE>.  <CODE>time</CODE>
   is valid when the caller is a user-event procedure such as <CODE>Paste</CODE>;
   it will be 0 when called from <CODE>v.read</CODE>, but in that case, <CODE>m</CODE> owns
   the selection, so <CODE>time</CODE> is not needed.
<P>
   Similarly, clients must override the <CODE>write</CODE> method.  <CODE>write</CODE> is
   called by <CODE>v.write</CODE>, which ensures that <CODE>v.readOnly</CODE> is <CODE>FALSE</CODE>
   before calling <CODE>m.write</CODE>.
<P>
   If there is a non-empty Primary selection, then <CODE>m.copy(time)</CODE>
   arranges for that text to become the Source selection.  Otherwise,
   it is a no-op; in particular, if the Primary selection is empty,
   <CODE>copy</CODE> must not acquire the Source selection. There is no default
   method for <CODE>copy</CODE>; the client must override this method.
<P>
   The default for <CODE>m.cut(time)</CODE> is <CODE>m.copy(time); m.clear()</CODE>.
<P>
   The default for <CODE>m.paste(time)</CODE> is <CODE>m.insert(m.read(VBT.Source,
   time))</CODE>.
<P>
   <CODE>m.clear()</CODE> deletes the Primary selection. Its default method is
<PRE>
      m.putSelectedText (&quot;&quot;, TextPort.SelectionType.Primary)
</PRE>
   <CODE>m.insert(t)</CODE> implements <CODE>TextPort.Insert</CODE>. The default method
   replaces the Primary selection, if there is one, with <CODE>t</CODE>;
   otherwise, it inserts <CODE>t</CODE> at the type-in point.  Clients may wish
   to override this in order to alter the highlighting.
<P>
   <CODE>m.extend(rec,...)</CODE> extends the highlighting for the given selection. 

<P> \subsubsection{Selections} 

<P><PRE>TYPE
  SelectionRecord = OBJECT
                      type := TextPort.SelectionType.Primary;
                      interval   : VText.Interval;
                      cursor     : CARDINAL;
                      mode       : VText.SelectionMode;
                      anchor     : TextPort.Extent;
                      alias      : VBT.Selection;
                      replaceMode                   := FALSE
                    END;
</PRE> Each local selection is represented by a <CODE>SelectionRecord</CODE>. <CODE>type</CODE>
   indicates whether this is a Primary or Secondary selection.
   <CODE>interval</CODE> describes the range of text and the highlighting. <CODE>mode</CODE>
   indicates whether this selection includes a character (point),
   word, line, paragraph, or the entire text. <CODE>anchor</CODE> is the range
   that stays fixed when we extend a selection.  <CODE>replaceMode</CODE>
   indicates whether the selection was created with a replace-mode
   gesture or with <CODE>TextPort.Select(..., replaceMode := TRUE)</CODE>. 

<P><PRE>PROCEDURE <A HREF="TextPortClass.m3#ChangeIntervalOptions">ChangeIntervalOptions</A> (v: T; rec: SelectionRecord)
  RAISES {VTDef.Error};
</PRE><BLOCKQUOTE><EM> Change the highlighting according to the conventions specified in
   the <CODE>TextPort</CODE> interface (see page~\pageref{TextPortHighlighting}). </EM></BLOCKQUOTE><PRE>

TYPE IRange = RECORD left, middle, right: CARDINAL END;

PROCEDURE <A HREF="TextPortClass.m3#GetRange">GetRange</A> (         v   : T;
                    READONLY cp  : VBT.CursorPosition;
                             mode: VText.SelectionMode ):
  IRange;
&lt;* LL = v.mu *&gt;
</PRE><BLOCKQUOTE><EM> Return an <CODE>IRange</CODE> indicating the boundaries of the character,
   word, paragraph, etc., that contains the position <CODE>cp</CODE>.  The
   <CODE>middle</CODE> field of the result will be equal to either the <CODE>left</CODE>
   field or the <CODE>right</CODE> field, depending on which end the cursor was
   nearer. </EM></BLOCKQUOTE><PRE>
</PRE> \subsubsection {Cursor-motion} 

<P><PRE>PROCEDURE <A HREF="TextPortClass.m3#ToPrevChar">ToPrevChar</A> (v: T);
PROCEDURE <A HREF="TextPortClass.m3#ToNextChar">ToNextChar</A> (v: T);
</PRE><BLOCKQUOTE><EM> Move the cursor (type-in point) left or right one char. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="TextPortClass.m3#ToStartOfLine">ToStartOfLine</A> (v: T);
PROCEDURE <A HREF="TextPortClass.m3#ToEndOfLine">ToEndOfLine</A>   (v: T);
</PRE><BLOCKQUOTE><EM> Move the cursor to start or end of line. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="TextPortClass.m3#UpOneLine">UpOneLine</A>   (v: T);
PROCEDURE <A HREF="TextPortClass.m3#DownOneLine">DownOneLine</A> (v: T);
</PRE><BLOCKQUOTE><EM> Move the cursor up or down one line. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="TextPortClass.m3#ToOtherEnd">ToOtherEnd</A> (v: T);
</PRE><BLOCKQUOTE><EM> Move the cursor to other end of the Primary selection. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="TextPortClass.m3#FindNextWord">FindNextWord</A> (v: T): TextPort.Extent;
PROCEDURE <A HREF="TextPortClass.m3#FindPrevWord">FindPrevWord</A> (v: T): TextPort.Extent;
</PRE><BLOCKQUOTE><EM> Locate the ``next'' or ``previous'' word. </EM></BLOCKQUOTE><PRE>
</PRE> In <CODE>FindNextWord</CODE>, we scan right from the current position until we
   reach an alphanumeric character.  Then we continue scanning right
   until we reach the first non-alphanumeric character; that position
   defines the right end of the extent.  Then we scan left until we
   find a non-alphanumeric character.  That position, plus 1, defines
   the left end of the extent.
<P>
   If the initial position is in the middle of a word, then the extent
   actually covers the {\it current} word, but on successive calls, it
   covers each following word in turn.
<P>
   <CODE>FindPrevWord</CODE> works the same as <CODE>ToNextWord</CODE>, except that all the
   scanning directions are reversed.
<P>
   ``Alphanumeric characters'' include the ISO Latin-1 characters,
   such as accented letters.


<P>
<P> \subsubsection {Deletion commands}
<P>
   All these procedures return an <CODE>Extent</CODE> indicating the range of
   characters that were deleted, or <CODE>TextPort.NotFound</CODE> if no
   characters were deleted. 
 
<P><PRE>PROCEDURE <A HREF="TextPortClass.m3#DeletePrevChar">DeletePrevChar</A> (v: T): TextPort.Extent;
PROCEDURE <A HREF="TextPortClass.m3#DeleteNextChar">DeleteNextChar</A> (v: T): TextPort.Extent;

PROCEDURE <A HREF="TextPortClass.m3#DeleteToStartOfWord">DeleteToStartOfWord</A> (v: T): TextPort.Extent;
PROCEDURE <A HREF="TextPortClass.m3#DeleteToEndOfWord">DeleteToEndOfWord</A>   (v: T): TextPort.Extent;
</PRE><BLOCKQUOTE><EM> Delete from the current position to the beginning of the previous
   word (as defined in <CODE>ToPrevWord</CODE>) or the end of the ``next'' word
   (as defined in <CODE>ToNextWord</CODE>). </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="TextPortClass.m3#DeleteToStartOfLine">DeleteToStartOfLine</A> (v: T): TextPort.Extent;
</PRE><BLOCKQUOTE><EM> Delete from the cursor to the beginning of the current line, or
   delete the preceding newline if the cursor is already at the
   beginning of the line.  </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="TextPortClass.m3#DeleteToEndOfLine">DeleteToEndOfLine</A> (v: T): TextPort.Extent;
</PRE><BLOCKQUOTE><EM> Delete to the end of line.  If the cursor is at the end, delete the
   newline. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="TextPortClass.m3#DeleteCurrentWord">DeleteCurrentWord</A> (v: T): TextPort.Extent;
</PRE><BLOCKQUOTE><EM> Delete the word containing the cursor. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="TextPortClass.m3#DeleteCurrentLine">DeleteCurrentLine</A> (v: T): TextPort.Extent;
</PRE><BLOCKQUOTE><EM> Delete line containing the cursor. </EM></BLOCKQUOTE><PRE>
</PRE> \subsubsection {Other modification commands} 

<P><PRE>PROCEDURE <A HREF="TextPortClass.m3#SwapChars">SwapChars</A>(v: T);
</PRE><BLOCKQUOTE><EM> Swap the two characters to the left of the cursor. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="TextPortClass.m3#InsertNewline">InsertNewline</A>(v: T);
</PRE><BLOCKQUOTE><EM> Insert a newline without moving the cursor. </EM></BLOCKQUOTE><PRE>
</PRE> \subsubsection {Searching} 

<P><PRE>TYPE Loc = {First, Next, Prev};

PROCEDURE <A HREF="TextPortClass.m3#Find">Find</A> (v         : T;
                pattern   : TEXT;
                loc                := Loc.Next;
                ignoreCase         := TRUE      ):
  TextPort.Extent;
</PRE><BLOCKQUOTE><EM> Search for <CODE>pattern</CODE> in the text of <CODE>v</CODE>.  The search proceeds
   either forward from the beginning of the text (<CODE>Loc.First</CODE>),
   forward from <CODE>v.index()</CODE> (<CODE>Loc.Next</CODE>, the default), or backward
   from <CODE>v.index()</CODE> (<CODE>Loc.Prev</CODE>).  If <CODE>ignoreCase</CODE> is <CODE>TRUE</CODE>, the case
   of letters is not significant in the search. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="TextPortClass.m3#FindAndSelect">FindAndSelect</A> (v         : T;
                         pattern   : TEXT;
                         time: VBT.TimeStamp;
                         loc                := Loc.Next;
                         ignoreCase         := TRUE      );
</PRE><BLOCKQUOTE><EM> Call <CODE>Find(v, pattern, loc, ignoreCase)</CODE>.  If the search was
   successful, then select the found text in replace-mode.
   Otherwise, call <CODE>v.notFound()</CODE>. </EM></BLOCKQUOTE><PRE>
</PRE> \subsubsection {Scrolling the display} 

<P><PRE>PROCEDURE <A HREF="TextPortClass.m3#ScrollOneLineUp">ScrollOneLineUp</A> (v: T)
  RAISES {VTDef.Error, Rd.EndOfFile, Rd.Failure,
          Thread.Alerted};
PROCEDURE <A HREF="TextPortClass.m3#ScrollOneLineDown">ScrollOneLineDown</A> (v: T)
  RAISES {VTDef.Error, Rd.EndOfFile, Rd.Failure,
          Thread.Alerted};
PROCEDURE <A HREF="TextPortClass.m3#ScrollOneScreenUp">ScrollOneScreenUp</A> (v: T)
  RAISES {VTDef.Error, Rd.EndOfFile, Rd.Failure,
          Thread.Alerted};
PROCEDURE <A HREF="TextPortClass.m3#ScrollOneScreenDown">ScrollOneScreenDown</A> (v: T)
  RAISES {VTDef.Error, Rd.EndOfFile, Rd.Failure,
          Thread.Alerted};
</PRE> Move the displayed text up or down by either a line or screen.
   This doesn't move the selections or the cursor, so the <CODE>TextPort</CODE> may
   not be normalized when done.  A ``screen'' contains <CODE>MAX(1, n-2)</CODE>
   lines, where <CODE>n</CODE> is the number of displayed lines. 

<P> \subsubsection {Managing the ``Undo'' stack} 

<P> The ``Undo'' stack records all the editing changes made to the <CODE>TextPort</CODE>.
   These changes can be undone; once undone, they can be redone.  There is no
   built-in limit to the number of changes that are recorded.  A sequence of
   insertions of graphic characters (i.e., plain typing) counts as one
   ``edit.'' 

<P><PRE>TYPE <A HREF="TextPortClass.m3#UndoRec">UndoRec</A> &lt;: ROOT;

PROCEDURE <A HREF="TextPortClass.m3#AddToUndo">AddToUndo</A> (v: T; begin, end: CARDINAL; newText: TEXT);
&lt;* LL = v.mu *&gt;
</PRE><BLOCKQUOTE><EM> This is called by <CODE>v.unsafeReplace(begin, end, newText)</CODE> to record a
   change to the underlying text. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="TextPortClass.m3#Undo">Undo</A> (v: T); &lt;* LL = v.mu *&gt;
</PRE><BLOCKQUOTE><EM> Reverse the effect of the last editing command. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="TextPortClass.m3#Redo">Redo</A> (v: T); &lt;* LL = v.mu *&gt;
</PRE><BLOCKQUOTE><EM> Reinstate the effect of the last editing command. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="TextPortClass.m3#ResetUndo">ResetUndo</A> (v: T); &lt;* LL &lt; v.mu *&gt;
</PRE><BLOCKQUOTE><EM> Clear the ``Undo'' stack.  (Nothing in the implementation calls this
   procedure.) </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="TextPortClass.m3#UndoCount">UndoCount</A> (v: T): CARDINAL; &lt;* LL &lt; v.mu *&gt;
</PRE><BLOCKQUOTE><EM> Return the number of changes that can be undone. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="TextPortClass.m3#RedoCount">RedoCount</A> (v: T): CARDINAL; &lt;* LL &lt; v.mu *&gt;
</PRE><BLOCKQUOTE><EM> Return the number of undone changes that can be redone. </EM></BLOCKQUOTE><PRE>
</PRE> \subsubsection {Compose-character filtering} 

<P><PRE>TYPE <A HREF="TextPortClass.m3#Composer">Composer</A> &lt;: KeyFilter.ComposeChar;
</PRE><BLOCKQUOTE><EM> This type overrides the <CODE>feedback</CODE> method to change the
   cursor-shape to <CODE>XC_exchange</CODE> during character-composition, and the
   standard ``text pointer'' otherwise. </EM></BLOCKQUOTE><PRE>
</PRE> \subsubsection {Miscellany} 

<P><PRE>PROCEDURE <A HREF="TextPortClass.m3#TextReverse">TextReverse</A> (t: TEXT): TEXT;
PROCEDURE <A HREF="TextPortClass.m3#TextLowerCase">TextLowerCase</A> (t: TEXT): TEXT;

CONST
  VBTErrorCodeTexts = ARRAY VBT.ErrorCode OF
                        TEXT {
                        &quot;event not current&quot;, &quot;timeout&quot;,
                        &quot;uninstalled&quot;, &quot;unreadable&quot;,
                        &quot;unwritable&quot;, &quot;unowned selection&quot;,
                        &quot;wrong type&quot;};

END TextPortClass.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
