<HTML>
<HEAD>
<TITLE>SRC Modula-3: etext/src/TextPortClass.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>etext/src/TextPortClass.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                       </EM></BLOCKQUOTE><PRE>
&lt;* PRAGMA LL *&gt;

MODULE <module><implements><A HREF="TextPortClass.i3">TextPortClass</A></implements></module>;

IMPORT <A HREF="../../ui/src/vbt/Cursor.i3">Cursor</A>, <A HREF="../../fmtlex/src/Fmt.i3">Fmt</A>, <A HREF="ISOChar.i3">ISOChar</A>, <A HREF="../../ui/src/vbt/KeyboardKey.i3">KeyboardKey</A>, <A HREF="KeyFilter.i3">KeyFilter</A>, <A HREF="../../mtext/src/MText.i3">MText</A>, <A HREF="../../mtext/src/MTextRd.i3">MTextRd</A>,
       <A HREF="MTextUnit.i3">MTextUnit</A>, <A HREF="../../ui/src/vbt/PaintOp.i3">PaintOp</A>, <A HREF="../../rw/src/Common/Rd.i3">Rd</A>, <A HREF="../../rw/src/Common/RdUtils.i3">RdUtils</A>, <A HREF="../../geometry/src/Rect.i3">Rect</A>, <A HREF="../../rw/src/Common/Stdio.i3">Stdio</A>, <A HREF="../../text/src/Text.i3">Text</A>, <A HREF="TextPort.i3">TextPort</A>, <A HREF="../../thread/src/Common/Thread.i3">Thread</A>,
       <A HREF="TypescriptVBT.i3">TypescriptVBT</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>, <A HREF="../../vtext/src/VTDef.i3">VTDef</A>, <A HREF="../../vtext/src/VText.i3">VText</A>, <A HREF="../../rw/src/Common/Wr.i3">Wr</A>;

FROM <A HREF="TextPort.i3">TextPort</A> IMPORT Extent, NotFound;

REVEAL
  <A NAME="Model">Model</A> = PublicModel BRANDED OBJECT
          OVERRIDES
            init            := Init;
            close           := Close;
            arrowKey        := ArrowKey;
            clear           := Clear;
            cut             := Cut;
            extend          := Extend;
            getSelectedText := GetSelectedText;
            getSelection    := GetSelection;
            highlight       := Highlight;
            misc            := Misc;
            paste           := Paste;
            position        := Position;
            putSelectedText := PutSelectedText;
            read            := Read;
            seek            := Seek;
            select          := Select;
            takeSelection   := TakeSelection;
            write           := Write;
          END;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A> (             m        : Model;
                &lt;* UNUSED *&gt; cs       : PaintOp.ColorScheme;
                             keyfilter: KeyFilter.T          ): Model =
  BEGIN
    m.keyfilter := keyfilter;
    RETURN m
  END Init;

PROCEDURE <A NAME="Close"><procedure>Close</procedure></A> (m: Model) =
  CONST name = &quot;Close&quot;;
  VAR v := m.v;
  BEGIN
    VBT.Release (v, VBT.KBFocus);
    VBT.Release (v, VBT.Source);
    VBT.Release (v, VBT.Target);
    TRY
      VText.SwitchCaret (v.vtext, VText.OnOffState.Off);
      FOR t := Primary TO Secondary DO
        IF m.selection [t] # NIL THEN
          VText.DeleteInterval (m.selection [t].interval)
        END
      END
    EXCEPT
    | VTDef.Error (ec) =&gt; v.vterror (name, ec)
    | Rd.EndOfFile =&gt; v.rdeoferror (name)
    | Rd.Failure (ref) =&gt; v.rdfailure (name, ref)
    | Thread.Alerted =&gt;
    END
  END Close;

PROCEDURE <A NAME="Cut"><procedure>Cut</procedure></A> (m: Model; time: VBT.TimeStamp) =
  BEGIN
    m.copy (time);
    m.clear ()
  END Cut;

PROCEDURE <A NAME="Clear"><procedure>Clear</procedure></A> (m: Model) =
  BEGIN
    m.putSelectedText (&quot;&quot;, Primary)
  END Clear;
</PRE><P>
 * Caret and interval-twiddling
 

<P><PRE>PROCEDURE <A NAME="ArrowKey"><procedure>ArrowKey</procedure></A> (m: Model; READONLY cd: VBT.KeyRec) =
  BEGIN
    CASE cd.whatChanged OF
    | KeyboardKey.Left =&gt; ToPrevChar (m.v)
    | KeyboardKey.Right =&gt; ToNextChar (m.v)
    | KeyboardKey.Up =&gt; UpOneLine (m.v)
    | KeyboardKey.Down =&gt; DownOneLine (m.v)
    ELSE &lt;* ASSERT FALSE *&gt;
    END
  END ArrowKey;

PROCEDURE <A NAME="FindNextWord"><procedure>FindNextWord</procedure></A> (v: T): Extent =
  VAR
    right := LocateNextWordBoundary (v);
    left  := MTextUnit.StartOfRun (v.vtext.mtext, right);
  BEGIN
    IF left &gt;= 0 THEN RETURN Extent {left, right} ELSE RETURN NotFound END
  END FindNextWord;

PROCEDURE <A NAME="FindPrevWord"><procedure>FindPrevWord</procedure></A> (v: T): Extent =
  VAR
    left  := LocateNextWordBoundary (v, reverse := TRUE);
    right := MTextUnit.EndOfRun (v.vtext.mtext, left);
  BEGIN
    IF right &gt;= 0 THEN RETURN Extent {left, right} ELSE RETURN NotFound END
  END FindPrevWord;

VAR
  readerLock := NEW (MUTEX);
  reader     := NEW (MTextRd.T); &lt;* LL = readerLock *&gt;

PROCEDURE <A NAME="LocateNextWordBoundary"><procedure>LocateNextWordBoundary</procedure></A> (v: T; reverse := FALSE): CARDINAL =
  VAR
    index       := v.index ();
    rd   : Rd.T;
    c    : CHAR;
    count       := 0;
  BEGIN
    LOCK readerLock DO
      TRY
        rd := reader.init (v.vtext.mtext, index, reverse := reverse);
        REPEAT
          c := Rd.GetChar (rd);
          INC (count);
        UNTIL c IN ISOChar.AlphaNumerics;
        REPEAT
          c := Rd.GetChar (rd);
          INC (count);
        UNTIL NOT c IN ISOChar.AlphaNumerics;
        DEC (count)
      EXCEPT
        Rd.EndOfFile, Rd.Failure, Thread.Alerted =&gt;
      END
    END;
    IF reverse THEN RETURN index - count ELSE RETURN index + count END
  END LocateNextWordBoundary;

PROCEDURE <A NAME="ToPrevChar"><procedure>ToPrevChar</procedure></A> (v: T) =
  VAR index := v.index ();
  BEGIN
    IF index &gt; 0 THEN v.m.seek (index - 1) END
  END ToPrevChar;

PROCEDURE <A NAME="ToNextChar"><procedure>ToNextChar</procedure></A> (v: T) =
  BEGIN
    v.m.seek (v.index () + 1)
  END ToNextChar;

PROCEDURE <A NAME="ToStartOfLine"><procedure>ToStartOfLine</procedure></A> (v: T) =
  BEGIN
    v.m.seek (MTextUnit.LineInfo (v.vtext.mtext, v.index ()).left)
  END ToStartOfLine;

PROCEDURE <A NAME="ToEndOfLine"><procedure>ToEndOfLine</procedure></A> (v: T) =
  BEGIN
    v.m.seek (MTextUnit.LineInfo (v.vtext.mtext, v.index ()).rightEnd)
  END ToEndOfLine;

PROCEDURE <A NAME="ToOtherEnd"><procedure>ToOtherEnd</procedure></A> (v: T) =
  VAR x := v.m.getSelection ();
  BEGIN
    IF v.index () = x.l THEN v.m.seek (x.r) ELSE v.m.seek (x.l) END
  END ToOtherEnd;
</PRE><P>
 * Vertical movement commands.
 

<P><PRE>PROCEDURE <A NAME="UpOneLine"><procedure>UpOneLine</procedure></A> (v: T) =
  BEGIN
    GoUpDown (v, goUp := TRUE)
  END UpOneLine;

PROCEDURE <A NAME="DownOneLine"><procedure>DownOneLine</procedure></A> (v: T) =
  BEGIN
    GoUpDown (v, goUp := FALSE)
  END DownOneLine;

PROCEDURE <A NAME="GoUpDown"><procedure>GoUpDown</procedure></A> (v: T; goUp: BOOLEAN) =
  VAR
    mtext                   := v.vtext.mtext;
    e    : MTextUnit.Extent := MTextUnit.LineExtent (mtext, v.index ());
  BEGIN
    (* Vertical movement commands *)
    IF v.lastCmdKind # CommandKind.VertCommand THEN
      v.wishCol := v.index () - e.left
    END;
    v.thisCmdKind := CommandKind.VertCommand;
    IF goUp THEN
      IF e.left = 0 THEN RETURN END;
      e := MTextUnit.LineExtent (mtext, e.left - 1)
    ELSE
      e.left := e.right
    END;
    v.m.seek (
      MIN (e.left + v.wishCol, MTextUnit.LineInfo (mtext, e.left).rightEnd))
  END GoUpDown;
</PRE><P>
 * Deletion commands.
 

<P><PRE>PROCEDURE <A NAME="DeletePrevChar"><procedure>DeletePrevChar</procedure></A> (v: T): Extent =
  VAR here := v.index ();
  BEGIN
    IF here &gt; 0 THEN
      RETURN v.replace (here - 1, here, &quot;&quot;)
    ELSE
      RETURN NotFound
    END
  END DeletePrevChar;

PROCEDURE <A NAME="DeleteNextChar"><procedure>DeleteNextChar</procedure></A> (v: T): Extent =
  VAR here := v.index ();
  BEGIN
    RETURN v.replace (here, here + 1, &quot;&quot;)
  END DeleteNextChar;

PROCEDURE <A NAME="DeleteToEndOfWord"><procedure>DeleteToEndOfWord</procedure></A> (v: T): Extent =
  VAR
    start := v.index ();
    end   := LocateNextWordBoundary (v);
  BEGIN
    RETURN v.replace (start, end, &quot;&quot;)
  END DeleteToEndOfWord;

PROCEDURE <A NAME="DeleteToStartOfWord"><procedure>DeleteToStartOfWord</procedure></A> (v: T): Extent =
  VAR
    end   := v.index ();
    start := LocateNextWordBoundary (v, reverse := TRUE);
  BEGIN
    RETURN v.replace (start, end, &quot;&quot;)
  END DeleteToStartOfWord;

PROCEDURE <A NAME="DeleteCurrentWord"><procedure>DeleteCurrentWord</procedure></A> (v: T): Extent =
  PROCEDURE WordAt (mtext: MText.T; index: CARDINAL): Extent =
    (** A word is
        - a run of alphanumerics
        - a run of blanks
        - any other single character
       We find a word such that left &lt;= index &lt; right.
    **)
    VAR e: MTextUnit.Extent;
    BEGIN
      e := MTextUnit.RunExtent (mtext, index, ISOChar.AlphaNumerics);
      IF e.inside THEN
        RETURN Extent {e.left, e.right}
      ELSE
        e := MTextUnit.RunExtent (mtext, index, ISOChar.Spaces);
        IF e.inside THEN
          RETURN Extent {e.left, e.right}
        ELSE
          RETURN Extent {index, index + 1}
        END
      END
    END WordAt;
  VAR extent := WordAt (v.vtext.mtext, v.index ());
  BEGIN
    RETURN v.replace (extent.l, extent.r, &quot;&quot;)
  END DeleteCurrentWord;

PROCEDURE <A NAME="DeleteToStartOfLine"><procedure>DeleteToStartOfLine</procedure></A> (v: T): Extent =
  VAR
    here := v.index ();
    left := MTextUnit.StartOfLine (v.vtext.mtext, here);
  BEGIN
    IF here = left THEN
      (* We're already at the start of line; delete one char. *)
      RETURN v.replace (here - 1, here, &quot;&quot;)
    ELSE
      RETURN v.replace (left, here, &quot;&quot;)
    END
  END DeleteToStartOfLine;

PROCEDURE <A NAME="DeleteToEndOfLine"><procedure>DeleteToEndOfLine</procedure></A> (v: T): Extent =
  VAR
    here := v.index ();
    info := MTextUnit.LineInfo (v.vtext.mtext, here);
  BEGIN
    IF here = info.rightEnd THEN
      (* We're already at the end of line. *)
      RETURN v.replace (here, info.right, &quot;&quot;)
    ELSE
      RETURN v.replace (here, info.rightEnd, &quot;&quot;)
    END
  END DeleteToEndOfLine;

PROCEDURE <A NAME="DeleteCurrentLine"><procedure>DeleteCurrentLine</procedure></A> (v: T): Extent =
  VAR
    here := v.index ();
    info := MTextUnit.LineInfo (v.vtext.mtext, here);
  BEGIN
    RETURN v.replace (info.left, info.right, &quot;&quot;)
  END DeleteCurrentLine;
</PRE><P>
 * Other modifications.
 

<P><PRE>PROCEDURE <A NAME="SwapChars"><procedure>SwapChars</procedure></A> (v: T) =
  (* Swap the two characters to the left of the caret. *)
  VAR
    here                         := v.index ();
    two : ARRAY [0 .. 1] OF CHAR;
  BEGIN
    IF here - 2 &lt; v.typeinStart THEN RETURN END;
    two [1] := MText.GetChar (v.vtext.mtext, here - 2);
    two [0] := MText.GetChar (v.vtext.mtext, here - 1);
    EVAL v.replace (here - 2, here, Text.FromChars (two))
  END SwapChars;

PROCEDURE <A NAME="InsertNewline"><procedure>InsertNewline</procedure></A> (v: T) =
  (* Insert a newline without moving the cursor. *)
  VAR here := v.index ();
  BEGIN
    v.m.seek (v.replace (here, here, &quot;\n&quot;).l)
  END InsertNewline;
</PRE><P>
 * Searching
 

<P><PRE>PROCEDURE <A NAME="Find"><procedure>Find</procedure></A> (v: T; pattern: TEXT; loc := Loc.Next; ignoreCase := TRUE):
  Extent =
  CONST name = &quot;Find&quot;;
  VAR
    len                         := Text.Length (pattern);
    found: INTEGER;
    start                       := v.index ();
    can  : RdUtils.Canonicalize := NIL;
  BEGIN
    IF len = 0 THEN RETURN NotFound END;
    IF ignoreCase THEN can := ToUpperCaseISO END;
    TRY
      CASE loc OF
      | Loc.First, Loc.Next =&gt;
          IF loc = Loc.First THEN start := 0 END;
          LOCK readerLock DO
            EVAL reader.init (v.vtext.mtext, start := start);
            found := RdUtils.Find (reader, pattern, can);
            IF found &gt;= 0 THEN RETURN Extent {found, found + len} END
          END
      | Loc.Prev =&gt;
          LOCK readerLock DO
            EVAL reader.init (v.vtext.mtext, start := start, rangeStart := 0,
                              rangeEnd := start, reverse := TRUE);
            found := RdUtils.Find (reader, TextReverse (pattern), can);
            IF found &gt;= 0 THEN
              RETURN Extent {start - found - len, start - found}
            END                  (* IF *)
          END                    (* LOCK *)
      END                        (* CASE *)
    EXCEPT
    | Rd.Failure (ref) =&gt; v.rdfailure (name, ref)
    | Thread.Alerted =&gt;
    END;
    RETURN NotFound
  END Find;

PROCEDURE <A NAME="ToUpperCaseISO"><procedure>ToUpperCaseISO</procedure></A> (ch: CHAR): CHAR =
  BEGIN
    RETURN ISOChar.Upper [ch]
  END ToUpperCaseISO;

PROCEDURE <A NAME="FindAndSelect"><procedure>FindAndSelect</procedure></A> (v      : T;
                         pattern: TEXT;
                         time   : VBT.TimeStamp;
                         loc        := Loc.Next;
                         ignoreCase := TRUE      ) =
  CONST
    map = ARRAY Loc OF
            VText.WhichEnd {
            VText.WhichEnd.Right, VText.WhichEnd.Right,
            VText.WhichEnd.Left};
  VAR ext := Find (v, pattern, loc, ignoreCase);
  BEGIN
    IF ext = TextPort.NotFound THEN
      v.notFound ()
    ELSE
      v.m.select (time, ext.l, ext.r, replaceMode := TRUE,
                  caretEnd := map [loc]);
      v.normalize (ext.l)
    END
  END FindAndSelect;

PROCEDURE <A NAME="TextReverse"><procedure>TextReverse</procedure></A> (t: TEXT): TEXT =
  VAR
    buf       := NEW (REF ARRAY OF CHAR, Text.Length (t));
    i         := FIRST (buf^);
    j         := LAST (buf^);
    c  : CHAR;
  BEGIN
    Text.SetChars (buf^, t);
    WHILE i &lt; j DO
      c := buf [i];
      buf [i] := buf [j];
      buf [j] := c;
      INC (i);
      DEC (j)
    END;
    RETURN Text.FromChars (buf^)
  END TextReverse;

PROCEDURE <A NAME="TextLowerCase"><procedure>TextLowerCase</procedure></A> (t: TEXT): TEXT =
  VAR buf := NEW (REF ARRAY OF CHAR, Text.Length (t));
  BEGIN
    Text.SetChars (buf^, t);
    FOR i := FIRST (buf^) TO LAST (buf^) DO
      buf [i] := ISOChar.Lower [buf [i]]
    END;
    RETURN Text.FromChars (buf^)
  END TextLowerCase;

PROCEDURE <A NAME="GetRange"><procedure>GetRange</procedure></A> (         v   : T;
                    READONLY cp  : VBT.CursorPosition;
                             mode: VText.SelectionMode ): IRange =
  &lt;* LL = v.mu *&gt;
  CONST name = &quot;GetRange&quot;;
  VAR
    whichEnd  : VText.WhichEnd;
    rect      : Rect.T;
    lineNum   : CARDINAL;
    ch        : CHAR;
    atEnd     : BOOLEAN;
    lt, md, rt: CARDINAL;
    e         : MTextUnit.Extent;
  VAR vt := v.vtext;
  BEGIN
    TRY
      VText.PounceLocate (vt, 0, cp.pt, lt, rt, lineNum, ch);
      atEnd := lt = rt;
      IF atEnd AND lt &gt; 0 THEN DEC (lt) END;
      CASE mode OF
      | VText.SelectionMode.ParagraphSelection =&gt;
          (* paragraph strategy differs from VText's strategy *)
          e := MTextUnit.ParagraphExtent (vt.mtext, lt);
          lt := e.left;
          rt := e.right
      | VText.SelectionMode.LineSelection =&gt;
          e := MTextUnit.LineExtent (vt.mtext, lt);
          lt := e.left;
          rt := e.right
      ELSE
        VText.PounceExtend (vt, 0, lt, rt, lineNum, ch, mode)
      END;
      whichEnd := VText.PounceEncage (vt, 0, cp.pt, lt, md, rt, rect);
      VBT.SetCage (vt.vbt, VBT.CageFromRect (rect, cp));
      IF    (   mode = VText.SelectionMode.CharSelection
             OR mode = VText.SelectionMode.WordSelection)
         AND ch # '\n'
         AND (whichEnd = VText.WhichEnd.Right OR atEnd) THEN
        md := rt
      ELSE
        md := lt
      END
    EXCEPT
    | VTDef.Error (ec) =&gt; v.vterror (name, ec)
    | Rd.EndOfFile =&gt; v.rdeoferror (name)
    | Rd.Failure (ref) =&gt; v.rdfailure (name, ref)
    | Thread.Alerted =&gt;
    END;
    RETURN IRange {lt, md, rt}
  END GetRange;
</PRE>*************** Scrolling the display *******************

<P><PRE>PROCEDURE <A NAME="Scroll"><procedure>Scroll</procedure></A> (v: T; delta: INTEGER)
  RAISES {VTDef.Error, Rd.EndOfFile, Rd.Failure, Thread.Alerted} =
  VAR
    vt := v.vtext;
    p  := VText.CaretIndex (vt);
  BEGIN
    VText.Scroll (vt, 0, delta);
    IF VText.InRegion (vt, 0, p) THEN (* skip *)
    ELSIF delta &lt; 0 THEN
      VText.MoveCaret (vt, VText.UpLines (vt, p, -delta, 0))
    ELSE
      VText.MoveCaret (vt, VText.StartIndex (vt, 0))
    END;
    VBT.Mark (v)
  END Scroll;

PROCEDURE <A NAME="ScrollOneLineUp"><procedure>ScrollOneLineUp</procedure></A> (v: T)
  RAISES {VTDef.Error, Rd.EndOfFile, Rd.Failure, Thread.Alerted} =
  BEGIN
    Scroll (v, 1)
  END ScrollOneLineUp;

PROCEDURE <A NAME="ScrollOneLineDown"><procedure>ScrollOneLineDown</procedure></A> (v: T)
  RAISES {VTDef.Error, Rd.EndOfFile, Rd.Failure, Thread.Alerted} =
  BEGIN
    Scroll (v, -1)
  END ScrollOneLineDown;

PROCEDURE <A NAME="ScrollOneScreenUp"><procedure>ScrollOneScreenUp</procedure></A> (v: T)
  RAISES {VTDef.Error, Rd.EndOfFile, Rd.Failure, Thread.Alerted} =
  BEGIN
    Scroll (v, MAX (1, v.vtext.region [0].nLines - 2))
  END ScrollOneScreenUp;

PROCEDURE <A NAME="ScrollOneScreenDown"><procedure>ScrollOneScreenDown</procedure></A> (v: T)
  RAISES {VTDef.Error, Rd.EndOfFile, Rd.Failure, Thread.Alerted} =
  BEGIN
    Scroll (v, -MAX (1, v.vtext.region [0].nLines - 2))
  END ScrollOneScreenDown;
</PRE>**************************** Undo  *******************************

<P><PRE>REVEAL
  <A NAME="UndoRec">UndoRec</A> = BRANDED OBJECT
                          begin, end: VText.Index := 0;
                          text                    := &quot;&quot;;
                          next, prev: UndoRec     := NIL
                        END;

PROCEDURE <A NAME="AddToUndo"><procedure>AddToUndo</procedure></A> (v: T; begin, end: CARDINAL; newText: TEXT) =
  &lt;* LL = v.mu *&gt;
  VAR
    n := Text.Length (newText);
    r := v.cur;
    vv: VBT.T := v; (* ISTYPE demands that v be assignable to TypescriptVBT.T*)
  BEGIN
    IF v.readOnly OR begin = end AND n = 0 OR ISTYPE (vv, TypescriptVBT.T) THEN
      RETURN
    END;
    IF r.prev # NIL AND begin = end AND n = 1 AND r.prev.end = begin
         AND Text.GetChar (newText, 0) IN ISOChar.Graphics THEN
      (* It's straight typing.  Extend the previous record. *)
      INC (r.prev.end)
    ELSE
      r.begin := begin;
      r.end := begin + n;
      r.text := MText.GetText (v.vtext.mtext, begin, end);
      IF r.next = NIL THEN r.next := NEW (UndoRec, prev := r) END;
      v.cur := r.next
    END;
    TraceUndo (v)
  END AddToUndo;

VAR tracingUndo := FALSE; (* For runtime debugging *)

PROCEDURE <A NAME="TraceUndo"><procedure>TraceUndo</procedure></A> (v: T) =
  &lt;* LL = v.mu *&gt;
  &lt;* FATAL Wr.Failure, Thread.Alerted *&gt;
  VAR
    r          := v.cur;
    t: TEXT;
    n: INTEGER := 0;
  BEGIN
    IF NOT tracingUndo THEN RETURN END;
    WHILE r.prev # NIL DO r := r.prev; INC (n) END;
    WHILE r.next # NIL DO
      t := r.text;
      IF Text.Length (t) &gt; 20 THEN t := Text.Sub (t, 0, 20) &amp; &quot;...&quot; END;
      IF n = 0 THEN Wr.PutText (Stdio.stderr, &quot;***** &quot;) END;
      Wr.PutText (Stdio.stderr,
                       Fmt.F (&quot;[%s .. %s] = \&quot;%s\&quot;\n&quot;, Fmt.Int (r.begin),
                              Fmt.Int (r.end), t));
      r := r.next;
      DEC (n)
    END;
    Wr.PutText (Stdio.stderr, &quot;-------------------\n&quot;)
  END TraceUndo;

PROCEDURE <A NAME="Undo"><procedure>Undo</procedure></A> (v: T) =
  BEGIN
    IF v.cur.prev # NIL THEN v.cur := v.cur.prev; Exchange (v) END
  END Undo;

PROCEDURE <A NAME="Redo"><procedure>Redo</procedure></A> (v: T) =
  BEGIN
    IF v.cur.next # NIL THEN Exchange (v); v.cur := v.cur.next END
  END Redo;

PROCEDURE <A NAME="UndoCount"><procedure>UndoCount</procedure></A> (v: T): CARDINAL =
  &lt;* LL &lt; v.mu *&gt;
  VAR
    n: CARDINAL := 0;
    r: UndoRec;
  BEGIN
    LOCK v.mu DO
      r := v.cur;
      WHILE r.prev # NIL DO INC (n); r := r.prev END;
      RETURN n
    END
  END UndoCount;

PROCEDURE <A NAME="RedoCount"><procedure>RedoCount</procedure></A> (v: T): CARDINAL =
  &lt;* LL &lt; v.mu *&gt;
  VAR
    n: CARDINAL := 0;
    r: UndoRec;
  BEGIN
    LOCK v.mu DO
      r := v.cur;
      WHILE r.next # NIL DO INC(n); r := r.next END;
      RETURN n
    END
  END RedoCount;

PROCEDURE <A NAME="ResetUndo"><procedure>ResetUndo</procedure></A> (v: T) =
  &lt;* LL &lt; v.mu *&gt;
  BEGIN
    LOCK v.mu DO v.cur := NEW(UndoRec) END
  END ResetUndo;

PROCEDURE <A NAME="Exchange"><procedure>Exchange</procedure></A> (v: T) =
  &lt;* LL = v.mu *&gt;
  CONST name = &quot;Undo&quot;;
  VAR
    prev := &quot;&quot;;
    r    := v.cur;
  BEGIN
    IF r.begin &lt; r.end AND r.begin &lt; v.length () THEN
      prev := v.getText (r.begin, r.end)
    END;
    v.normalize (r.begin);
    TRY
      VText.Replace (v.vtext, r.begin, r.end, r.text)
    EXCEPT
    | VTDef.Error (ec) =&gt; v.vterror (name, ec)
    | Rd.EndOfFile =&gt; v.rdeoferror (name)
    | Rd.Failure (ref) =&gt; v.rdfailure (name, ref)
    | Thread.Alerted =&gt;
    END;
    r.end := r.begin + Text.Length (r.text);
    r.text := prev;
    TraceUndo (v)
  END Exchange;
</PRE>******************** Default methods ****************************

<P><PRE>PROCEDURE <A NAME="Misc"><procedure>Misc</procedure></A> (m: Model; READONLY cd: VBT.MiscRec) =
  CONST name = &quot;Misc&quot;;
  VAR v := m.v;
  PROCEDURE turnOff (vtype: VType)
    RAISES {VTDef.Error} =
    BEGIN
      IF NOT v.owns [vtype] THEN RETURN END;
      v.owns [vtype] := FALSE;
      FOR type := Primary TO Secondary DO
        VAR rec := m.selection [type];
        BEGIN
          IF rec # NIL AND rec.alias = cd.selection THEN
            VText.SwitchInterval (rec.interval, VText.OnOffState.Off)
          END
        END
      END
    END turnOff;
  BEGIN
    TRY
      IF cd.type = VBT.Lost THEN
        IF cd.selection = VBT.KBFocus AND v.owns [Focus] THEN
          v.owns [Focus] := FALSE;
          VText.SwitchCaret (v.vtext, VText.OnOffState.Off);
          v.ULfocus (FALSE, cd.time)
        ELSIF cd.selection = VBT.Source THEN
          turnOff (Source)
        ELSIF cd.selection = VBT.Target THEN
          turnOff (Target)
        END
      ELSIF cd.type = VBT.TakeSelection AND cd.selection = VBT.KBFocus THEN
        EVAL v.getKFocus (cd.time)
      END;
      VBT.Mark (v)
    EXCEPT
    | VTDef.Error (ec) =&gt; v.vterror (name, ec)
    | Rd.EndOfFile =&gt; v.rdeoferror (name)
    | Rd.Failure (ref) =&gt; v.rdfailure (name, ref)
    | Thread.Alerted =&gt;
    END
  END Misc;

PROCEDURE <A NAME="GetSelectedText"><procedure>GetSelectedText</procedure></A> (m: Model; sel: TextPort.SelectionType): TEXT =
  VAR extent := m.getSelection (sel);
  BEGIN
    IF extent.l = extent.r THEN
      RETURN &quot;&quot;
    ELSE
      RETURN m.v.getText (extent.l, extent.r)
    END
  END GetSelectedText;

PROCEDURE <A NAME="Paste"><procedure>Paste</procedure></A> (m: Model; time: VBT.TimeStamp) =
  BEGIN
    TRY
      m.v.insert (m.read (VBT.Source, time))
    EXCEPT
    | VBT.Error (ec) =&gt; m.v.vbterror (&quot;Paste&quot;, ec)
    END
  END Paste;

PROCEDURE <A NAME="Read"><procedure>Read</procedure></A> (m: Model; READONLY s: VBT.Selection; time: VBT.TimeStamp): TEXT
  RAISES {VBT.Error} =
  BEGIN
    TYPECASE VBT.Read (m.v, s, time).toRef () OF
    | NULL =&gt; RAISE VBT.Error (VBT.ErrorCode.WrongType)
    | TEXT (t) =&gt; RETURN t
    ELSE
      RAISE VBT.Error (VBT.ErrorCode.WrongType)
    END
  END Read;

PROCEDURE <A NAME="Write"><procedure>Write</procedure></A> (         m   : Model;
                 READONLY s   : VBT.Selection;
                          time: VBT.TimeStamp;
                          t   : TEXT           ) RAISES {VBT.Error} =
  BEGIN
    VBT.Write (m.v, s, time, VBT.FromRef (t))
  END Write;

PROCEDURE <A NAME="Seek"><procedure>Seek</procedure></A> (m: Model; position: CARDINAL) =
  CONST name = &quot;Seek&quot;;
  BEGIN
    TRY
      VText.MoveCaret (m.v.vtext, position);
      VBT.Mark (m.v)
    EXCEPT
    | VTDef.Error (ec) =&gt; m.v.vterror (name, ec)
    | Rd.EndOfFile =&gt; m.v.rdeoferror (name)
    | Rd.Failure (ref) =&gt; m.v.rdfailure (name, ref)
    | Thread.Alerted =&gt;
    END
  END Seek;

PROCEDURE <A NAME="ChangeIntervalOptions"><procedure>ChangeIntervalOptions</procedure></A> (v: T; rec: SelectionRecord)
  RAISES {VTDef.Error} =
  VAR
    st          := VBT.ScreenTypeOf (v);
    interval    := rec.interval;
    options     := interval.getOptions ();
    replaceMode := rec.type = Primary AND v.isReplaceMode ();
  BEGIN
    IF st = NIL THEN RETURN END;
    options.whiteStroke := PaintOp.bgFg; (* Reset. *)
    options.whiteBlack := PaintOp.bgFg;
    IF st.depth &lt;= 1 THEN        (* monochrome *)
      IF replaceMode THEN
        options.style := VTDef.IntervalStyle.InverseStyle
      ELSIF rec.alias = VBT.Source THEN
        options.style := VTDef.IntervalStyle.ThinUnderlineStyle
      ELSE
        options.style := VTDef.IntervalStyle.UnderlineStyle
      END
    ELSIF replaceMode THEN
      options.style := VTDef.IntervalStyle.HighlightStyle;
      options.whiteBlack := ReplaceColorScheme
    ELSIF rec.alias = VBT.Source THEN
      options.style := VTDef.IntervalStyle.ThinUnderlineStyle;
      options.whiteStroke := SourceColorScheme
    ELSE
      options.style := VTDef.IntervalStyle.UnderlineStyle;
      IF v.readOnly THEN
        options.whiteStroke := ReadOnlyColorScheme
      ELSE
        options.whiteStroke := WritableColorScheme
      END
    END;
    VText.ChangeIntervalOptions (interval, options);
    VBT.Mark (v)
  END ChangeIntervalOptions;

VAR
  ReplaceColorScheme :=          (* black letters on a pale red background *)
  PaintOp.MakeColorScheme (
    bg := PaintOp.FromRGB (r := 1.0, g := 0.7, b := 0.7), fg := PaintOp.Fg);

  (* For underlines, only the .fg field is used. *)

  SourceColorScheme :=           (* green underline *)
  PaintOp.MakeColorScheme (
    fg := PaintOp.FromRGB (r := 0.0, g := 0.8, b := 0.0), bg := PaintOp.Bg);

  ReadOnlyColorScheme :=         (* blue underline *)
  PaintOp.MakeColorScheme (
    fg := PaintOp.FromRGB (r := 0.0, g := 0.0, b := 1.0), bg := PaintOp.Bg);

  WritableColorScheme :=         (* red underline *)
  PaintOp.MakeColorScheme (
    fg := PaintOp.FromRGB (r := 1.0, g := 0.0, b := 0.0), bg := PaintOp.Bg);

PROCEDURE <A NAME="Highlight"><procedure>Highlight</procedure></A> (m: Model; rec: SelectionRecord; READONLY r: IRange) =
  CONST name = &quot;Highlight&quot;;
  BEGIN
    TRY
      VText.MoveInterval (rec.interval, r.left, r.right);
      VText.SwitchInterval (rec.interval, VText.OnOffState.On);
      rec.cursor := r.middle;
      m.seek (r.middle);
      VBT.Mark (m.v)
    EXCEPT
    | VTDef.Error (ec) =&gt; m.v.vterror (name, ec)
    END
  END Highlight;

PROCEDURE <A NAME="TakeSelection"><procedure>TakeSelection</procedure></A> (         m   : Model;
                         READONLY sel : VBT.Selection;
                                  type: TextPort.SelectionType;
                                  time: VBT.TimeStamp           ): BOOLEAN =
  CONST name = &quot;TakeSelection&quot;;
  VAR
    v   := m.v;
    rec := m.selection [type];
  PROCEDURE take (vtype: VType): BOOLEAN =
    BEGIN
      IF NOT v.owns [vtype] THEN
        TRY
          VBT.Acquire (v, sel, time);
          IF type = Secondary OR v.getKFocus (time) THEN
            v.owns [vtype] := TRUE;
            IF rec.alias = sel THEN
              VText.SwitchInterval (rec.interval, VText.OnOffState.On)
            END
          ELSE
            VBT.Release (v, sel)
          END;
          VBT.Mark (v)
        EXCEPT
        | VBT.Error (ec) =&gt; v.vbterror (name, ec)
        | VTDef.Error (ec) =&gt; v.vterror (name, ec)
        END
      END;
      RETURN v.owns [vtype]
    END take;
  BEGIN
    IF sel = VBT.Source THEN
      RETURN take (Source)
    ELSIF sel = VBT.Target THEN
      RETURN take (Target)
    ELSE                         &lt;* ASSERT FALSE *&gt;
    END;
  END TakeSelection;

PROCEDURE <A NAME="Extend"><procedure>Extend</procedure></A> (m: Model; rec: SelectionRecord; newL, newR: CARDINAL) =
  BEGIN
    IF m.approachingFromLeft AND newL &lt; rec.anchor.r
         OR NOT m.approachingFromLeft AND newR &lt;= rec.anchor.l THEN
      m.highlight (rec, IRange {newL, newL, rec.anchor.r})
    ELSE
      m.highlight (rec, IRange {rec.anchor.l, newR, newR})
    END
  END Extend;

PROCEDURE <A NAME="Position"><procedure>Position</procedure></A> (m: Model; READONLY cd: VBT.PositionRec) =
  VAR
    rec  := m.selection [m.dragType];
    r    := GetRange (m.v, cd.cp, rec.mode);
  BEGIN
    IF rec.mode = VText.SelectionMode.CharSelection THEN
      m.extend (rec, r.middle, r.middle)
    ELSE
      m.extend (rec, r.left, r.right)
    END
  END Position;

PROCEDURE <A NAME="GetSelection"><procedure>GetSelection</procedure></A> (m: Model; sel := Primary): TextPort.Extent =
  VAR rec := m.selection [sel];
  BEGIN
    IF rec = NIL THEN
      RETURN TextPort.NotFound
    ELSE
      RETURN TextPort.Extent {rec.interval.left (), rec.interval.right ()}
    END
  END GetSelection;

PROCEDURE <A NAME="Select"><procedure>Select</procedure></A> (m          : Model;
                  time       : VBT.TimeStamp;
                  begin      : CARDINAL        := 0;
                  end        : CARDINAL        := LAST (CARDINAL);
                  type                         := Primary;
                  replaceMode                  := FALSE;
                  caretEnd                     := VText.WhichEnd.Right) =
  CONST name = &quot;Select&quot;;
  VAR rec := m.selection [type];
  BEGIN
    IF rec = NIL THEN            (* skip *)
    ELSIF rec.alias = VBT.Source
            AND NOT m.takeSelection (VBT.Source, type, time) THEN (* skip *)
    ELSIF rec.alias = VBT.Target
            AND NOT m.takeSelection (VBT.Target, type, time) THEN (* skip *)
    ELSE
      IF type = Primary THEN
        rec.replaceMode := replaceMode AND NOT m.v.readOnly;
        TRY
          ChangeIntervalOptions (m.v, rec)
        EXCEPT
        | VTDef.Error (ec) =&gt; m.v.vterror (name, ec)
        END
      END;
      IF caretEnd = VText.WhichEnd.Left THEN
        m.highlight (rec, IRange {begin, begin, end})
      ELSE
        m.highlight (rec, IRange {begin, end, end})
      END
    END
  END Select;

PROCEDURE <A NAME="PutSelectedText"><procedure>PutSelectedText</procedure></A> (m: Model; t: TEXT; type: TextPort.SelectionType) =
  CONST name = &quot;PutSelectedText&quot;;
  VAR
    rec := m.selection [type];
  BEGIN
    IF rec = NIL THEN RETURN END;
    VAR
      interval := rec.interval;
      left     := interval.left ();
      right    := interval.right ();
    BEGIN
      TRY
        IF m.v.replace (left, right, t) = TextPort.NotFound THEN RETURN END;
        (* NB: Replace changes interval! *)
        rec.replaceMode := FALSE;
        ChangeIntervalOptions (m.v, rec);
        VText.MoveInterval (interval, left, left + Text.Length (t))
      EXCEPT
      | VTDef.Error (ec) =&gt; m.v.vterror (name, ec)
      END
    END
  END PutSelectedText;

REVEAL
  <A NAME="Composer">Composer</A> =
    KeyFilter.ComposeChar BRANDED OBJECT OVERRIDES feedback := Feedback END;

VAR
  cursors := ARRAY BOOLEAN OF
               Cursor.T {Cursor.TextPointer,
                         Cursor.FromName (ARRAY OF TEXT {&quot;XC_exchange&quot;})};

PROCEDURE <A NAME="Feedback"><procedure>Feedback</procedure></A> (&lt;* UNUSED *&gt; c: Composer; v: VBT.T; composing: BOOLEAN) =
  BEGIN
    VBT.SetCursor (v, cursors [composing])
  END Feedback;

BEGIN END TextPortClass.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
