<HTML>
<HEAD>
<TITLE>SRC Modula-3: etext/src/TypescriptVBT.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>etext/src/TypescriptVBT.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
&lt;* PRAGMA LL                                                                 *&gt;
</PRE> A <CODE>TypescriptVBT</CODE> is a subtype of <CODE>TextEditVBT</CODE>, with additional
   features to make it serve as a ``glass teletype'' with a memory.
<P>
   Abstractly, a typescript contains
<P>
<PRE>
      reader(v)           <KBD>an intermittent, unseekable reader</KBD>
      writer(v)           <KBD>a buffered, unseekable writer</KBD>
      readingThread(v)    <KBD>a thread</KBD>
   </PRE>
   <CODE>reader(v)</CODE> provides the client with input that the user typed.
   <CODE>writer(v)</CODE> is used to display output. The reader and writer are
   paired such that the writer is flushed whenever a seek blocks on
   the reader.  The writer is not flushed at every newline.
<P>
   All input to the typescript, once it has been read, and all output,
   become part of the {\em history} of the typescript, and is not
   modifiable; it remains until the client deletes it by calling
   <CODE>ClearHistory</CODE>.  Selections that lie fully or partially within the
   history region are never ``replace-mode'' selections (see
   Section~\ref{ReplaceMode}, page~\pageref{ReplaceMode}).  Any
   attempt to type or insert text in the history region becomes an
   insertion at the end of the typescript instead.
<P>
   <CODE>readingThread(v)</CODE> is initially <CODE>NIL</CODE>. When a client reads from
   <CODE>v</CODE>, <CODE>readingThread(v)</CODE> is set to <CODE>Thread.Self()</CODE>. The
   <CODE>handleInterrupt</CODE> method (see below) alerts <CODE>readingThread(v)</CODE>.
   This is useful when the reading thread is blocked waiting for
   input.
<P>
   A typescript's textport, <CODE>v.tp</CODE>, must be of type
   <CODE>TypescriptVBT.Port</CODE> (which is a subtype of <CODE>TextPort.T</CODE>).  The
   textport's <CODE>returnAction</CODE> method makes the text of the current
   type-in region available to the reader and no longer editable. The
   textport's <CODE>setReadOnly</CODE> method is a no-op.
<P>
   Typescripts do not allow the use of Undo and Redo.
<P>


<P><PRE>INTERFACE <interface><A HREF="TypescriptVBT.m3">TypescriptVBT</A></interface>;

IMPORT <A HREF="../../rw/src/Common/Rd.i3">Rd</A>, <A HREF="TextEditVBT.i3">TextEditVBT</A>, <A HREF="TextPort.i3">TextPort</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>, <A HREF="../../rw/src/Common/Wr.i3">Wr</A>, <A HREF="../../thread/src/Common/Thread.i3">Thread</A>;

TYPE
  <A HREF="TypescriptVBT.m3#T">T</A> &lt;: Public;
  Public = TextEditVBT.T OBJECT
           METHODS
             &lt;* LL.sup &lt;= VBT.mu *&gt;
             init            (scrollable := TRUE): T;
             interrupt       (time: VBT.TimeStamp);
             handleInterrupt (time: VBT.TimeStamp);
             terminate       ();
             setThread       (thread: Thread.T := NIL);
           END;
  <A HREF="TypescriptVBT.m3#Port">Port</A> &lt;: TextPort.T;
</PRE> The call <CODE>v.init()</CODE> initializes <CODE>v</CODE> as an empty typescript.
<P>
   It is a checked runtime error if <CODE>v.tp</CODE> is <CODE>NIL</CODE> or is not of type
   <CODE>TypescriptVBT.Port</CODE>, which is a subtype of <CODE>TextPort.T</CODE>.
<P>
   The call <CODE>v.interrupt(time)</CODE> simulates an interrupt by
   flushing any pending type-in, writing the characters <CODE>^C</CODE>, and then
   calling <CODE>v.handleInterrupt(time)</CODE>. 
<P>
   The call <CODE>v.handleInterrupt(time)</CODE> alerts <CODE>readingThread(v)</CODE>.
<P>
   After <CODE>v.terminate()</CODE> is called, subsequent attempts to read from
   <CODE>v</CODE> will causes it to report end of file, and <CODE>v</CODE> becomes
   unresponsive to further user input, although it will continue to
   display output written to its output stream.  This is appropriate
   when <CODE>v</CODE> is being discarded.
<P>
   The call <CODE>v.setThread(thread)</CODE> changes <CODE>readingThread(v)</CODE>.  This
   can be used to protect <CODE>Thread.Self()</CODE> from being alerted after it
   has finished reading from <CODE>reader(v)</CODE>.  Subsequent reads on
   <CODE>reader(v)</CODE> will reset the <CODE>readingThread(v)</CODE> to <CODE>Thread.Self()</CODE>.

<P><PRE>TYPE
  <A HREF="TypescriptVBT.m3#Reader">Reader</A> &lt;: PublicReader;
  PublicReader = Rd.T OBJECT METHODS typescript (): T END;

  <A HREF="TypescriptVBT.m3#Writer">Writer</A> &lt;: PublicWriter;
  PublicWriter = Wr.T OBJECT METHODS typescript (): T END;

PROCEDURE <A HREF="TypescriptVBT.m3#GetRd">GetRd</A> (v: T): Reader;
</PRE><BLOCKQUOTE><EM> Get the input stream for <CODE>v</CODE>. By definition,
<PRE>
      GetRd(v).typescript() = v
</EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="TypescriptVBT.m3#GetWr">GetWr</A> (v: T): Writer;
</PRE><BLOCKQUOTE><EM> Get the output stream for <CODE>v</CODE>. By definition,
<PRE>
      GetWr(v).typescript() = v
</EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="TypescriptVBT.m3#GetHistory">GetHistory</A> (v: T): TEXT; &lt;* LL &lt;= VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Return the ``history'' text of <CODE>v</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="TypescriptVBT.m3#ClearHistory">ClearHistory</A> (v: T);  &lt;*  LL &lt;= VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Clear the ``history'' text of <CODE>v</CODE>. </EM></BLOCKQUOTE><PRE>

END TypescriptVBT.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
