<HTML>
<HEAD>
<TITLE>SRC Modula-3: etext/src/TypescriptVBT.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>etext/src/TypescriptVBT.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
&lt;* PRAGMA LL *&gt;

MODULE <module><implements><A HREF="TypescriptVBT.i3">TypescriptVBT</A></implements></module>;
</PRE>* Here's how the typescript works:
<P>
    The vtext holds the underlying text.
    0 &lt;= outputEnd &lt;= typeinStart &lt;= len(vtext).
<P>
    vtext[0 .. outputEnd-1] is the <CODE>history</CODE>.  It is accessible to
    neither the reader nor the writer.  ClearHistory <CODE>erases</CODE> this,
    i.e., deletes that section of the vtext and decrements outputEnd
    and typeinStart accordingly.
<P>
    Wr.Flush inserts characters at outputEnd, in the <CODE>middle</CODE> of the
    vtext.  After the insertion, outputEnd and typeinStart are
    incremented by the number of inserted characters.
<P>
    vtext[outputEnd .. typeinStart-1] is the section that's accessible
    to the reader.  RSeek copies characters from this part of the vtext.
    If outputEnd = typeinStart (i.e., if there are no characters
    available) and dontBlock is false, then RSeek calls Wr.Flush and
    waits for inputReady to be signaled.
<P>
    vtext[typeinStart .. len(vtext) - 1] contains typed-in characters.
    That is, keyboard input is appended to the end of the vtext.  This
    segment is editable.  When Return is typed, a Newline is appended,
    typeinStart is set to len(vtext), and inputReady is signaled, thus
    making the input line accessible to the reader.
<P>
*

<P><PRE>IMPORT <A HREF="../../rw/src/Common/RdClass.i3">RdClass</A>, <A HREF="../../text/src/Text.i3">Text</A>, <A HREF="TextEditVBT.i3">TextEditVBT</A>, <A HREF="TextPort.i3">TextPort</A>, <A HREF="TextPortClass.i3">TextPortClass</A>, <A HREF="../../thread/src/Common/Thread.i3">Thread</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>,
       <A HREF="../../rw/src/Common/Wr.i3">Wr</A>, <A HREF="../../rw/src/Common/WrClass.i3">WrClass</A>;

REVEAL
  <A NAME="T">T</A> = Public BRANDED OBJECT
        mu: MUTEX;
        &lt;* LL = mu *&gt;
        rd        : Reader;
        wr        : Writer;
        lastReader: Thread.T;          (* whom to alert on ^C *)
        inputReady: Thread.Condition;
        terminated: BOOLEAN;
        outputEnd : CARDINAL;
      OVERRIDES
        init            := Init;
        interrupt       := Interrupt;
        handleInterrupt := HandleInterrupt;
        setThread       := SetThread;
        terminate       := Terminate;
      END;
  <A NAME="Reader">Reader</A> = PublicReader BRANDED &quot;Typescript.Reader&quot; OBJECT
             v: T
           OVERRIDES
             seek       := RSeek;
             typescript := RdTypescript
           END;
  <A NAME="Writer">Writer</A> = PublicWriter BRANDED OBJECT
             v: T
           OVERRIDES
             seek       := WSeek;
             flush      := WFlush;
             typescript := WrTypescript
           END;

REVEAL
  <A NAME="Port">Port</A> = TextPort.T BRANDED OBJECT
           v: T
         OVERRIDES
           returnAction := ReturnAction;
           setReadOnly  := SetReadOnly
         END;

EXCEPTION Error;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A> (v: T; scrollable := TRUE): T =
  &lt;* FATAL Error *&gt;
  CONST
    TerminalReaderBuffSize = 4096;
    TerminalWriterBuffSize = 4096;
  BEGIN
    v := TextEditVBT.T.init (v, scrollable);
    v.inputReady := NEW (Thread.Condition);
    v.rd := NEW (Reader, v := v, lo := 0, cur := 0, hi := 0, st := 0,
                 buff := NEW (REF ARRAY OF CHAR, TerminalReaderBuffSize),
                 closed := FALSE, seekable := FALSE, intermittent := TRUE);
    v.wr :=
      NEW (Writer, v := v, lo := 0, cur := 0, hi := TerminalWriterBuffSize,
           st := 0, buff := NEW (REF ARRAY OF CHAR, TerminalWriterBuffSize),
           closed := FALSE, seekable := FALSE, buffered := TRUE);
    v.lastReader := NIL;
    v.terminated := FALSE;
    v.outputEnd := 0;
    v.mu := NEW (MUTEX);
    TYPECASE v.tp OF | NULL =&gt; | Port (p) =&gt; p.v := v; RETURN v ELSE END;
    RAISE Error
  END Init;
</PRE>**********************  Typescript-specific code  **********************

<P><PRE>PROCEDURE <A NAME="WSeek"><procedure>WSeek</procedure></A> (wr: Writer; &lt;* UNUSED *&gt; n: CARDINAL)
  RAISES {Wr.Failure, Thread.Alerted} =
  BEGIN
    wr.flush ()
  END WSeek;

PROCEDURE <A NAME="WFlush"><procedure>WFlush</procedure></A> (wr: Writer) RAISES {Thread.Alerted} =
  VAR
    v      := wr.v; tp := v.tp;
    normP  := TextPort.IsVisible (v.tp, TextPort.Index (tp));
    nchars := wr.cur - wr.lo;
  BEGIN
    LOCK v.mu DO
      TextPort.Replace (tp, v.outputEnd, v.outputEnd,
                        Text.FromChars (SUBARRAY (wr.buff^, 0, nchars)));
      INC (v.outputEnd, nchars)
    END;
    INC (tp.typeinStart, nchars);
    wr.lo := wr.cur;
    wr.hi := wr.lo + NUMBER (wr.buff^);
    IF normP THEN TextPort.Normalize (tp) ELSE VBT.Mark (tp) END;
    IF Thread.TestAlert () THEN RAISE Thread.Alerted END
  END WFlush;

PROCEDURE <A NAME="RSeek"><procedure>RSeek</procedure></A> (rd: Reader; &lt;*UNUSED*&gt; n: CARDINAL;
                 dontBlock: BOOLEAN): RdClass.SeekResult
  RAISES {Thread.Alerted} =
  VAR
    nchars: CARDINAL;
    v                := rd.v;
  BEGIN
    LOCK v.mu DO
      v.lastReader := Thread.Self ();
      nchars := v.tp.typeinStart - v.outputEnd;
      IF nchars &gt; 0 THEN
      ELSIF v.terminated THEN
        rd.buff := NIL;
        RETURN RdClass.SeekResult.Eof
      ELSIF dontBlock THEN
        RETURN RdClass.SeekResult.WouldBlock
      ELSE
        REPEAT
          Thread.Release (v.mu);
          TRY
            TRY Wr.Flush (v.wr) EXCEPT Wr.Failure =&gt; END
          FINALLY
            Thread.Acquire (v.mu)
          END;
          Thread.AlertWait (v.mu, v.inputReady);
          nchars := v.tp.typeinStart - v.outputEnd
        UNTIL nchars &gt; 0
      END;
      WITH n   = MIN (nchars, NUMBER (rd.buff^)),
           txt = TextPort.GetText (v.tp, v.outputEnd, v.outputEnd + n) DO
        Text.SetChars (rd.buff^, txt);
        INC (v.outputEnd, n);
        rd.lo := rd.cur;
        rd.hi := rd.lo + n;      (* NOT v.outputEnd! *)
        RETURN RdClass.SeekResult.Ready
      END                        (* WITH n *)
    END                          (* LOCK *)
  END RSeek;

PROCEDURE <A NAME="ReturnAction"><procedure>ReturnAction</procedure></A> (tp: Port; READONLY event: VBT.KeyRec) =
  (* Input action, called when the user presses Return in the input area.
     Unblocks RSeek if it was blocked. *)
  BEGIN
    IF event.modifiers = VBT.Modifiers {} AND NOT tp.getReadOnly () THEN
      TextPort.Seek (tp, TextPort.Length (tp));
      TextPort.Insert (tp, &quot;\n&quot;);
      tp.typeinStart := TextPort.Length (tp);
      (* activate the reading client *)
      Thread.Signal (tp.v.inputReady);
      TextPort.Normalize (tp)
    END
  END ReturnAction;

PROCEDURE <A NAME="SetReadOnly"><procedure>SetReadOnly</procedure></A> (&lt;* UNUSED *&gt; tp: Port; &lt;* UNUSED *&gt; flag: BOOLEAN) =
  BEGIN
  END SetReadOnly;

PROCEDURE <A NAME="Interrupt"><procedure>Interrupt</procedure></A> (v: T; time: VBT.TimeStamp) =
  (* Interrupt.  It flushes (ignores) all pending typein, then calls the
     interrupt handler. *)
  VAR length := TextPort.Length (v.tp);
  BEGIN
    TextPort.Seek (v.tp, length);
    TextPort.Insert (v.tp, &quot;^C&quot;);
    LOCK v.mu DO v.outputEnd := length + 2 END; (* flush all pending typein *)
    v.tp.typeinStart := length + 2;
    v.handleInterrupt (time)
  END Interrupt;

PROCEDURE <A NAME="HandleInterrupt"><procedure>HandleInterrupt</procedure></A> (v: T; &lt;* UNUSED *&gt; time: VBT.TimeStamp) =
  BEGIN
    LOCK v.mu DO
      IF v.lastReader # NIL THEN Thread.Alert (v.lastReader) END
    END
  END HandleInterrupt;

PROCEDURE <A NAME="GetRd"><procedure>GetRd</procedure></A> (v: T): Reader =
  BEGIN
    RETURN v.rd
  END GetRd;

PROCEDURE <A NAME="GetWr"><procedure>GetWr</procedure></A> (v: T): Writer =
  BEGIN
    RETURN v.wr
  END GetWr;

PROCEDURE <A NAME="RdTypescript"><procedure>RdTypescript</procedure></A> (r: Reader): T =
  BEGIN
    RETURN r.v
  END RdTypescript;

PROCEDURE <A NAME="WrTypescript"><procedure>WrTypescript</procedure></A> (r: Writer): T =
  BEGIN
    RETURN r.v
  END WrTypescript;

PROCEDURE <A NAME="GetHistory"><procedure>GetHistory</procedure></A> (v: T): TEXT =
  BEGIN
    LOCK v.mu DO RETURN TextPort.GetText (v.tp, 0, v.outputEnd) END
  END GetHistory;

PROCEDURE <A NAME="ClearHistory"><procedure>ClearHistory</procedure></A> (v: T) =
  BEGIN
    LOCK v.mu DO
      TextPort.Replace (v.tp, 0, v.outputEnd, &quot;&quot;);
      DEC (v.tp.typeinStart, v.outputEnd);
      v.outputEnd := 0
    END;
    VBT.Mark (v.tp)
  END ClearHistory;
</PRE>*************************  Special controls  *************************

<P><PRE>PROCEDURE <A NAME="SetThread"><procedure>SetThread</procedure></A> (v: T; thread: Thread.T := NIL) =
  BEGIN
    LOCK v.mu DO
      IF thread = NIL THEN
        v.lastReader := Thread.Self ()
      ELSE
        v.lastReader := thread
      END
    END
  END SetThread;

PROCEDURE <A NAME="Terminate"><procedure>Terminate</procedure></A> (v: T) =
  BEGIN
    LOCK v.mu DO v.terminated := TRUE END;
    v.tp.setReadOnly (TRUE);
    Thread.Signal (v.inputReady)
  END Terminate;

BEGIN
END TypescriptVBT.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
