<HTML>
<HEAD>
<TITLE>SRC Modula-3: etimer/src/ETimer.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>etimer/src/ETimer.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: ETimer.i3                                             

<P> This interface provides a set of non-overlapping timers.
   The timers record elapsed time, not CPU time.
<P>
   A background timer and a garbage collection timer are
   automatically provided.
<P>
   The stack of suspended timers can contain at most 100 timers.


<P><PRE>INTERFACE <interface><A HREF="ETimer.m3">ETimer</A></interface>;

IMPORT <A HREF="../../rw/src/Common/Wr.i3">Wr</A>;

TYPE <A HREF="ETimer.m3#T">T</A> &lt;: REFANY;

PROCEDURE <A HREF="ETimer.m3#New">New</A> (lab: TEXT): T;
</PRE><BLOCKQUOTE><EM> Create and return a new timer with label <CODE>lab</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="ETimer.m3#Relabel">Relabel</A> (t: T;  lab: TEXT);
</PRE><BLOCKQUOTE><EM> Assign <CODE>lab</CODE> to <CODE>t</CODE>'s label. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="ETimer.m3#Push">Push</A> (t: T);
</PRE><BLOCKQUOTE><EM> Suspend the currently running timer, start <CODE>t</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="ETimer.m3#Pop">Pop</A> ();
</PRE><BLOCKQUOTE><EM> Suspend the currently running timer, resume the previous one. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="ETimer.m3#Dump">Dump</A> (wr: Wr.T);
</PRE><BLOCKQUOTE><EM> Dump the non-zero timers to <CODE>wr</CODE>.  Note, the timers will be dumped
   in the reverse order of how they were created.  </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="ETimer.m3#Elapsed">Elapsed</A> (t: T): LONGREAL;
</PRE><BLOCKQUOTE><EM> Returns the seconds accumulated by <CODE>t</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="ETimer.m3#TotalElapsed">TotalElapsed</A> (): LONGREAL;
</PRE><BLOCKQUOTE><EM> Returns the total elpased seconds </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="ETimer.m3#Next">Next</A> (prev: T): T;
</PRE><BLOCKQUOTE><EM> Returns the timer following <CODE>prev</CODE> in the global list of all timers.
   If <CODE>prev</CODE> is <CODE>NIL</CODE>, the first timer is returned.  If <CODE>prev</CODE> is the
   last known timer, <CODE>NIL</CODE> is returned. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="ETimer.m3#Enable">Enable</A> ();
</PRE><BLOCKQUOTE><EM> Start the timers.  Note that <CODE>Enable</CODE> must be called at
   least once before any timers will begin accumulating time.  </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="ETimer.m3#Reset">Reset</A> (t: T);
</PRE><BLOCKQUOTE><EM> Reset <CODE>t</CODE>'s accumulator to zero. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="ETimer.m3#ResetAll">ResetAll</A> ();
</PRE><BLOCKQUOTE><EM> Reset all timers to zero. </EM></BLOCKQUOTE><PRE>

END ETimer.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
