<HTML>
<HEAD>
<TITLE>SRC Modula-3: filename/src/WINNT/Filename.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>filename/src/WINNT/Filename.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

INTERFACE <interface><A HREF="#x1">Filename</A></interface>;
</PRE><BLOCKQUOTE><EM>*************************************************************</EM></BLOCKQUOTE><PRE>
</PRE> Procedures for file names and search paths                  
                                                             
 This interface provides several standard procedures for     
 working with file names and search paths.  A search path    
 is a list of directories separated by colons in the         
 traditional Unix style.                                     
                                                             
 The procedures exported by this package are listed          
 below.  A more complete description of each operation is    
 provided in the comments that following the declaration.    
                                                             
         Root(filename)                                      
         Extension(filename)                                 
         Head(filename)                                      
         Tail(filename)                                      
         DefaultExtension(filename, <CODE>.xxx</CODE>)                  
         ExpandTilde(filename)                               
         SearchPath(dir, path, filename, [file predicate])   
         RdFromPath(dir, path, filename)                     
                                                             
 This interface is similar to the C language interface in    
 /proj/packages/clib/file.c and provides the same basic      
 functionality.                                              
                                                             
 Index: search path, manipulating from Modula-3; files,      
 naming operations                                           
*************************************************************

<P>
<P><PRE>IMPORT <A HREF="../../../rw/src/Common/Rd.i3">Rd</A>;

TYPE
  FilePredicate = PROCEDURE ((* dir: OS.Dir; *)filename: TEXT): BOOLEAN;

EXCEPTION Error;

PROCEDURE <A HREF="#x2">FileIsReadable</A> (filename: TEXT): BOOLEAN;
</PRE><BLOCKQUOTE><EM> Return TRUE iff filename names a readable file.         </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="#x3">Root</A> (filename: TEXT): TEXT;
</PRE><BLOCKQUOTE><EM> Returns the root part of the filename and is equivalent </EM></BLOCKQUOTE><PRE>
</PRE> to the :r substitution in the C shell.                  

<P><PRE>PROCEDURE <A HREF="#x4">Extension</A> (filename: TEXT): TEXT;
</PRE><BLOCKQUOTE><EM> Returns the extension part of the filename and is       </EM></BLOCKQUOTE><PRE>
</PRE> equivalent to the :e substitution in the C shell.       

<P><PRE>PROCEDURE <A HREF="#x5">Head</A> (filename: TEXT): TEXT;
</PRE><BLOCKQUOTE><EM> Returns the head part of the filename and is equivalent </EM></BLOCKQUOTE><PRE>
</PRE> to the :h substitution in the C shell.                  

<P><PRE>PROCEDURE <A HREF="#x6">Tail</A> (filename: TEXT): TEXT;
</PRE><BLOCKQUOTE><EM> Returns the tail part of the filename and is equivalent </EM></BLOCKQUOTE><PRE>
</PRE> to the :t substitution in the C shell.                  

<P><PRE>PROCEDURE <A HREF="#x7">DefaultExtension</A> (filename, ext: TEXT): TEXT;
</PRE><BLOCKQUOTE><EM> Adds an extension to a filename if none already         </EM></BLOCKQUOTE><PRE>
</PRE> exists.  Alternatively, if the extension field begins   
 with a *, any old extension in the first filename is    
 replaced with the given extension.                      

<P><PRE>PROCEDURE <A HREF="#x8">ExpandTilde</A> (filename: TEXT): TEXT  RAISES {Error};
</PRE><BLOCKQUOTE><EM> Expands the <CODE>~user/</CODE> at the beginning of a file name    </EM></BLOCKQUOTE><PRE>
</PRE> to be the path of user's home directory.  If <CODE>user</CODE> is  
 empty, the home directory of the user running the       
 program is used.  The password file is used to map user 
 names to directories.  If there is any problem finding  
 <CODE>user</CODE>, Error is raised.                                

<P><PRE>PROCEDURE <A HREF="#x9">SearchPath</A> (path, filename: TEXT;
                      pred: FilePredicate := FileIsReadable): TEXT;
</PRE><BLOCKQUOTE><EM> Most clients will not specify a filepred argument       </EM></BLOCKQUOTE><PRE>
</PRE> and will use this simply to find the first file         
 that exists along a given search path.  More            
 generally, SearchPath returns a pathname to the         
 first instance of filename in the list of               
 directories specified by the path for which the         
 filepred returns TRUE.  If none exist, SearchPath       
 returns NIL.                                            

<P><PRE>PROCEDURE <A HREF="#x10">RdFromPath</A> (path, filename: TEXT): Rd.T  RAISES {Rd.Failure};
</PRE><BLOCKQUOTE><EM> This is a convenience routine and is a shorthand for    </EM></BLOCKQUOTE><PRE>
</PRE> FileStream.OpenRead(dir,                                
                     SearchPath(dir, path, filename))    

<P><PRE>END Filename.
</PRE>*************************************************************
 Additional notes by Ken Brooks for those not entirely       
 familiar with csh:                                          
                                                             
 A pathname consists of components, separated by slashes.    
 An extension is the part of the pathname following the      
 last period in the last component.  If there is no period   
 in the last component, the extension is the null string.    
 The root of a pathname is all of the pathname except the    
 extension and its period.                                   
                                                             
 The tail of a pathname is the last component.  The head is  
 everything except the last component and the slash that     
 divides it from the rest.  Exception: If the pathname has   
 only one component, that is both the head and the tail;     
 the head is not the null string.                            
 ************************************************************* 

</inInterface>
<HR>
<A NAME="x1">Filename's implementation  is in:
</A><UL>
<LI><A HREF="../POSIX/Filename.m3#0TOP0">filename/src/POSIX/Filename.m3</A>
<LI><A HREF="Filename.m3#0TOP0">filename/src/WINNT/Filename.m3</A>
</UL>
<P>
<HR>
<A NAME="x2">procedure Filename.FileIsReadable is in:
</A><UL>
<LI><A HREF="../POSIX/Filename.m3#FileIsReadable">filename/src/POSIX/Filename.m3</A>
<LI><A HREF="Filename.m3#FileIsReadable">filename/src/WINNT/Filename.m3</A>
</UL>
<P>
<HR>
<A NAME="x3">procedure Filename.Root is in:
</A><UL>
<LI><A HREF="../POSIX/Filename.m3#Root">filename/src/POSIX/Filename.m3</A>
<LI><A HREF="Filename.m3#Root">filename/src/WINNT/Filename.m3</A>
</UL>
<P>
<HR>
<A NAME="x4">procedure Filename.Extension is in:
</A><UL>
<LI><A HREF="../POSIX/Filename.m3#Extension">filename/src/POSIX/Filename.m3</A>
<LI><A HREF="Filename.m3#Extension">filename/src/WINNT/Filename.m3</A>
</UL>
<P>
<HR>
<A NAME="x5">procedure Filename.Head is in:
</A><UL>
<LI><A HREF="../POSIX/Filename.m3#Head">filename/src/POSIX/Filename.m3</A>
<LI><A HREF="Filename.m3#Head">filename/src/WINNT/Filename.m3</A>
</UL>
<P>
<HR>
<A NAME="x6">procedure Filename.Tail is in:
</A><UL>
<LI><A HREF="../POSIX/Filename.m3#Tail">filename/src/POSIX/Filename.m3</A>
<LI><A HREF="Filename.m3#Tail">filename/src/WINNT/Filename.m3</A>
</UL>
<P>
<HR>
<A NAME="x7">procedure Filename.DefaultExtension is in:
</A><UL>
<LI><A HREF="../POSIX/Filename.m3#DefaultExtension">filename/src/POSIX/Filename.m3</A>
<LI><A HREF="Filename.m3#DefaultExtension">filename/src/WINNT/Filename.m3</A>
</UL>
<P>
<HR>
<A NAME="x8">procedure Filename.ExpandTilde is in:
</A><UL>
<LI><A HREF="../POSIX/Filename.m3#ExpandTilde">filename/src/POSIX/Filename.m3</A>
<LI><A HREF="Filename.m3#ExpandTilde">filename/src/WINNT/Filename.m3</A>
</UL>
<P>
<HR>
<A NAME="x9">procedure Filename.SearchPath is in:
</A><UL>
<LI><A HREF="../POSIX/Filename.m3#SearchPath">filename/src/POSIX/Filename.m3</A>
<LI><A HREF="Filename.m3#SearchPath">filename/src/WINNT/Filename.m3</A>
</UL>
<P>
<HR>
<A NAME="x10">procedure Filename.RdFromPath is in:
</A><UL>
<LI><A HREF="../POSIX/Filename.m3#RdFromPath">filename/src/POSIX/Filename.m3</A>
<LI><A HREF="Filename.m3#RdFromPath">filename/src/WINNT/Filename.m3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
