<HTML>
<HEAD>
<TITLE>SRC Modula-3: fingerprint/src/Fingerprint.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>fingerprint/src/Fingerprint.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                             </EM></BLOCKQUOTE><PRE>
</PRE> A <CODE>Fingerprint.T</CODE> is a 64-bit checksum.  This interface
   provides procedures that can be used to fingerprint
   text strings or more general data structures, such as 
   graphs.
   \index{checksum}
<P>
   The interface is based on the original idea of M. O. Rabin
   \cite{Rabin}, as refined by Andrei Broder \cite{Broder}. 

<P><PRE>INTERFACE <interface><A HREF="Fingerprint.m3">Fingerprint</A></interface>;

CONST Brand = &quot;Fingerprint&quot;;

TYPE T = RECORD
    byte: ARRAY [0..7] OF BITS 8 FOR [0..255]
  END;

PROCEDURE <A HREF="Fingerprint.m3#FromText">FromText</A>(txt: TEXT): T;
</PRE><BLOCKQUOTE><EM> Return the fingerprint of <CODE>txt</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Fingerprint.m3#Combine">Combine</A>(READONLY fp1, fp2: T): T;
</PRE><BLOCKQUOTE><EM> Return the fingerprint of the ordered 
   pair <CODE>(fp1, fp2)</CODE>. </EM></BLOCKQUOTE><PRE>

CONST Zero = T{ARRAY [0..7] OF BITS 8 FOR [0..255] {0, ..}};

VAR (*CONST*) OfEmpty: T;
</PRE><BLOCKQUOTE><EM> The fingerprint of the empty text. </EM></BLOCKQUOTE><PRE>
</PRE> The following procedure, <CODE>FromChars</CODE>, provides two
   additional features.  First, it takes an array of
   characters instead of a <CODE>TEXT</CODE>, which can save
   on allocations.  Second, it can be used to compute
   the fingerprint of a sequence incrementally,
   a buffer at a time, since it accepts the checksum of
   the previous text together with a new buffer full
   of text and computes the checksum of the whole text.


<P><PRE>PROCEDURE <A HREF="Fingerprint.m3#FromChars">FromChars</A>
  (READONLY buff: ARRAY OF CHAR; READONLY fp: T): T;
</PRE><BLOCKQUOTE><EM> Return the fingerprint of <CODE>t &amp; Text.FromChars(buff)</CODE>,
   where <CODE>t</CODE> is the text whose fingerprint is <CODE>fp</CODE>. </EM></BLOCKQUOTE><PRE>
</PRE> The last two procedures in the interface allow you to
   use fingerprints as the key type in a generic table. 

<P><PRE>PROCEDURE <A HREF="Fingerprint.m3#Equal">Equal</A>(READONLY fp1, fp2: T): BOOLEAN;
</PRE><BLOCKQUOTE><EM> Return <CODE>fp1 = fp2</CODE>.  </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Fingerprint.m3#Hash">Hash</A>(READONLY fp: T): INTEGER;
</PRE><BLOCKQUOTE><EM> Return a hash code for <CODE>fp</CODE>. </EM></BLOCKQUOTE><PRE>

END Fingerprint.
</PRE> \paragraph{The probabilistic guarantee.}
<P>
The fingerprint module produces a provably secure checksum.
To explain exactly what this means requires a few definitions.
<P>
Define a {\it nest} to be a text string or an ordered 
pair of two nests.  The fingerprint <CODE>FP(x)</CODE> of a nest <CODE>x</CODE> 
is defined as follows:
<P>
<PRE>
      FP(x) = FromText(x) <KBD>if </KBD>x<KBD> is a text</KBD>
      FP(x) = Combine(FP(y), FP(z)) <KBD>if </KBD>x<KBD> is a pair </KBD>(y, z)<KBD></KBD>.
</PRE>
Two nests <CODE>x</CODE> and <CODE>y</CODE> {\it collide} if <CODE>x # y</CODE> but 
<CODE>FP(x) = FP(y)</CODE>.  (Two texts are equal if they
are <CODE>Text.Equal</CODE>, and two pairs are equal if their
corresponding components are equal.  We assume that
nests are finite and non-circular.)
<P>
A nest <CODE>x</CODE> is a {\it subnest} of <CODE>y</CODE> if it occurs anywhere
in <CODE>y</CODE>; that is, if it equals <CODE>y</CODE> or if <CODE>y</CODE> is an ordered
pair and <CODE>x</CODE> is a subnest of one of <CODE>y</CODE>'s components.
<P>
Define the {\it length} of a nest to be the sum of the
lengths of all the distinct texts that occur anywhere
inside it, and the {\it size} of a nest to be the number 
of distinct subnests that it has. For example, the 
length of the nest
<P>
<PRE>
      ((&quot;a&quot;, &quot;b&quot;), (&quot;a&quot;, &quot;b&quot;))
</PRE>
is two, since the only texts that occur inside it are 
<CODE>a</CODE> and <CODE>b</CODE>, whose lengths sum to two.
The size of the nest is four, since its distinct 
subnests are itself, the pair (<CODE>a</CODE>, <CODE>b</CODE>), and the
texts <CODE>a</CODE> and <CODE>b</CODE>.
<P>
The fingerprint module contains a magic number that
was chosen on 12 December 1986 by flipping a quarter
128 times in Andrei Broder's office at SRC.  The checksum 
produced by the package is a function of this magic number.
<P>
The probabilistic guarantee for the fingerprint algorithm
is that for any nest <CODE>S</CODE>, even one produced by an adversary
who knows everything about the algorithm except the magic
number, the probability that the 1986 coin-flipping produced 
a magic number such that some pair of subnests of <CODE>S</CODE> collide 
is at most
<P>
<PRE>
         (length(S) * size(S)) / 2^62.
</PRE>
From this basic guarantee you can compute an upper bound
on the probability of a collision in your application.
For example, if two texts <CODE>t1</CODE> and <CODE>t2</CODE> collide, then
the nest <CODE>(t1,  t2)</CODE> contains two colliding subnests.
The odds against this are at least <CODE>2^62</CODE> to <CODE>N * 3</CODE>,
where <CODE>N</CODE> is the total length of the two texts.  For
example, if the total length is a million characters,
the collision probability is at most
<P>
<PRE>
         (10^6 * 3) / 2^62
</PRE>
This is less than one in a trillion.  
<P>
Similarly, given a thousand texts each of length a thousand, 
considering the linear list of all of them as a nest and
applying the guarantee, we conclude that the probability
that some pair collide is at most
<P>
<PRE>
         (10^6 * 2 * 10^3) / 2^62
</PRE>
which is less than one in <CODE>2^31</CODE>, or less than one in <CODE>10^9</CODE>.
<P>
Of course these are probabilities with respect to a random
coin-flipping that has already happened and is therefore not
random anymore.  If you were present in Andrei's office, 
or if you look at the magic number in the implementation, you 
can easily construct a small nest that contains a collision.  The 
probabilistic guarantee is valid only if the structure 
you are fingerprinting is independent of the coin-flipping event.  
For example, it would not really be a good idea to fingerprint 
the text of the module <CODE>Fingerprint.m3</CODE>, since that text contains the
magic number as a constant, and therefore the probabilistic
guarantee says nothing about the quality of its fingerprint.
<P>
\paragraph{Example applications.}
<P>
Fingerprints are useful in many aspects of computer systems.  For 
example, to determine if two long files stored on different computer 
systems are identical, it is not necessary to transfer the entire 
file from one system to another: it suffices to fingerprint the files 
and transfer and compare the fingerprints.  (Assuming that the
probabilistic guarantee is good enough for your application.)
<P>
Fingerprints are also a key technology for achieving type safety in 
distributed programming.  Within a single address space, the compiler 
and linker can ensure that the value of every variable is consistent 
with its type.  In a distributed computation, where values in one 
program are reduced to bit sequences and sent over the network to 
become values of variables in another program, the compiler cannot 
perform this check: whatever the compiler does, a programmer could 
erroneously change the type in one of the programs and recompile and 
execute it.  Some kind of runtime check is required when the
value is transferred.  The simplest check is to send the type 
of the value along with the value itself, and then to check the type 
when the value is received.  But types can be quite complicated in 
modern programming languages, and it would be inefficient to 
communicate types by sending a full description of their structure 
over the wire.  Fingerprints provide the answer: the sending program 
computes a fingerprint of the type, and the receiving program
compares the fingerprint with the fingerprint of the receiving
variable.  Fingerprints play essentially the same role in
making persistent storage typesafe.  The SRC Modula-3 runtime
provides an interface for converting between typecodes and
type fingerprints, for exactly this purpose.
<P>
\paragraph{Fingerprinting general data structures.}
<P>
The <CODE>Combine</CODE> function makes it convenient to fingerprint
many data structures.  For example, consider a directed acyclic
graph (DAG) in which each node <CODE>nd</CODE> has a text label <CODE>lbl(nd)</CODE> and
<CODE>deg(nd)</CODE> neighbor nodes <CODE>nd[1]</CODE>, ..., <CODE>nd[deg(nd)]</CODE>.
Such a graph represents an expression in which a
node <CODE>nd</CODE> of degree zero represents a constant value named
by <CODE>lbl(nd)</CODE>, and a node <CODE>nd</CODE> of degree greater than
zero represents an expression with root operator
<CODE>lbl(nd)</CODE> and arguments <CODE>nd[1]</CODE>, ..., <CODE>nd[deg(nd)]</CODE>.
<P>
One way to find common subexpressions is to compute
a fingerprint <CODE>F(nd)</CODE> for every node <CODE>nd</CODE> by the
following rule:
<P>
<PRE>
      PROCEDURE F(nd): T =
        VAR res := FromText(lbl(nd)); BEGIN
          FOR i := 1 TO deg(nd) DO
            res := Combine(res, F(nd[i]))
          END;
          RETURN res
        END F;
</PRE>
(If the DAG is not a tree, the program as written
will recompute the fingerprint of nodes with multiple parents,
possibly many times.  To avoid this, you can easily modify 
the program to record the fingerprint in the node, so that 
the total computation time is proportional to the size of the 
graph.) 
<P>
The procedure <CODE>F</CODE> has the property that with high 
probability, two nodes have the same fingerprint
if and only if they represent common subexpressions. 
This is a consequence of the probabilistic guarantee 
together with the observation that <CODE>f(a1, ..., an)</CODE> and
<CODE>g(b1, ..., bm)</CODE> are common subexpressions if and 
only if the nests 
<P>
<PRE>
       ( ... ((f, a1),  a2), ... an)
       ( ... ((g, b1),  b2), ... bm)
</PRE>
are equal.  
<P>
Other data structures, such as cyclic graphs, can be 
fingerprinted with more elaborate strategies based on the 
same idea.  When designing fingerprinting algorithms for
other data structures, it is important to remember that
<CODE>Combine</CODE> is neither commutative nor associative.
<P>
\paragraph{Pitfalls.}
<P>
The original fingerprint interface offered at SRC did not include the
procedure <CODE>Combine</CODE>.  The Vesta configuration management project built
a system that cached intermediate results for large software builds.
Abstractly, this is a special case of the common subexpression problem
mentioned previously, and the project used fingerprints as keys in the
cache.  It is instructive to learn what happened.
<P>
You might think that a simple way to solve the common subexpression 
problem without <CODE>Combine</CODE> would be to fingerprint the texts that result from 
printing the expressions represented by the nodes of the DAG.  
But if the DAG is not a tree, this is a serious error, since the 
length of the strings produced by printing a DAG can grow geometrically 
with its size, and therefore the probabilistic 
guarantee becomes useless even for quite small DAGs.  
<P>
Avoiding this error, the Vesta group computed the fingerprint
of a node by concatenating the node's label with the {\it fingerprints}
of its children---treating these fingerprints as 8-byte texts---
and fingerprinted the resulting text.  With this strategy, the
number of texts fingerprinted is proportional to the number of
nodes of the DAG, and the total length of these texts is
proportional to the number of edges of the DAG.  Thus the method 
appears efficient and sound.  
<P>
Alas, the method is not sound.  Recall that the probabilistic
guarantee is valid only if the strings being 
fingerprinted are independent of the magic number.  But 
fingerprints themselves are dependent on the magic number, so the
probabalistic guarantee is invalid whenever fingerprints
are fingerprinted.  The Vesta group was soon debugging 
an unexpected collision.
<P>
The moral is simple: the procedure <CODE>Combine</CODE> is a convenience, but it 
is also much more than a convenience.  It should be the only way
that you ever generate a fingerprint from another fingerprint.
In particular, never treat a fingerprint as text to be passed to 
<CODE>FromText</CODE>.  

</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
