<HTML>
<HEAD>
<TITLE>SRC Modula-3: fingerprint/src/Poly.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>fingerprint/src/Poly.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                            </EM></BLOCKQUOTE><PRE>

INTERFACE <interface><A HREF="Poly.m3">Poly</A></interface>;
</PRE> This module provides polynomials of degree [0..63] with
    coefficients in the field Z(2).


<P><PRE>TYPE
  T      = ARRAY [0..1] OF Int32;
  Int32  = [-16_7fffffff-1 .. 16_7fffffff];
  Card32 = [0 .. LAST (Int32)];
  Byte   = BITS 8 FOR [0..255];
  Bytes  = ARRAY [0..7] OF Byte;

CONST
  ZERO = T{ 0, 0 };
  ONE  = T{ 0, FIRST (Int32) };
  X    = T{ 0, 16_40000000 };

PROCEDURE <A HREF="Poly.m3#Sum">Sum</A>     (READONLY p, q: T): T; (* returns (p+q) *)
PROCEDURE <A HREF="Poly.m3#Product">Product</A> (READONLY p, q: T): T; (* returns (p * q MOD PolyBasis.P) *)
PROCEDURE <A HREF="Poly.m3#TimesX">TimesX</A>  (READONLY p : T)  : T; (* returns (p * X^1) *)
PROCEDURE <A HREF="Poly.m3#Power">Power</A>   (d: Card32)       : T; (* returns (x^d MOD PolyBasis.P) *)

PROCEDURE <A HREF="Poly.m3#ComputeMod">ComputeMod</A> (READONLY init: T;  addr: ADDRESS;  len: INTEGER): T;
</PRE><BLOCKQUOTE><EM> This procedure assumes that the 'len' bytes beginning at address
   'addr' define a polynomial, A(x), of degree '(8*len)'.
   The procedure returns '(init*x^(8*len) + A(x)) MOD PolyBasis.P' </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Poly.m3#ToBytes">ToBytes</A>   (READONLY t: T;  VAR b: Bytes);
PROCEDURE <A HREF="Poly.m3#FromBytes">FromBytes</A> (READONLY b: Bytes;  VAR t: T);

END Poly.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
