<HTML>
<HEAD>
<TITLE>SRC Modula-3: fingerprint/src/PolyBasis.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>fingerprint/src/PolyBasis.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                            </EM></BLOCKQUOTE><PRE>

INTERFACE <interface><A HREF="PolyBasis.m3">PolyBasis</A></interface>;
</PRE> This module exports a single polynomial P and associated tables
   for arithmetic MOD P. 

<P><PRE>IMPORT <A HREF="Poly.i3">Poly</A>;

TYPE
  X = Poly.T;
  T = ARRAY [0..255] OF X;

CONST
  P = X { 116277429, 431580288 };
  (* an irreducible degree 61 polynomial * X^3 *)

CONST
  MIN_INT = FIRST (Poly.Int32);

CONST
  poly64 = T{ (* poly64[i] = i(x)*x^64 MOD P *)
    X{ 0, 0 },                     X{ 36728807, 152935311 },
    X{ 73457614, 305870622 },      X{ 105951273, 455519377 },
    X{ 85802743, 386180924 },      X{ 120410384, 504970419 },
    X{ 25026873, 88051746 },       X{ 55414494, 203557805 },
    X{ 132578437, 494634872 },     X{ 97948514, 342236407 },
    X{ 59122507, 255897702 },      X{ 28724396, 106769385 },
    X{ 50053746, 176103492 },      X{ 13348245, 56802251 },
    X{ 110828988, 407115610 },     X{ 78344795, 291081429 },
    X{ 34699361, 159762416 },      X{ 2168710, 9985151 },
    X{ 108111791, 465498350 },     X{ 71419976, 312699745 },
    X{ 118245014, 511795404 },     X{ 87828849, 396163907 },
    X{ 57448792, 213538770 },      X{ 22869695, 94882909 },
    X{ 100107492, 352206984 },     X{ 130542339, 501472007 },
    X{ 26696490, 113604502 },      X{ 61289677, 265874457 },
    X{ 15383059, 66774964 },       X{ 47896052, 182942779 },
    X{ 76178909, 297914538 },      X{ 112855610, 417090341 },
    X{ 69398722, 319524832 },      X{ 101883685, 437654639 },
    X{ 4337420, 19970302 },        X{ 41042155, 137175921 },
    X{ 20958773, 68102364 },       X{ 51356114, 219329363 },
    X{ 90116603, 372514754 },      X{ 124747292, 522814541 },
    X{ 63179847, 242223256 },      X{ 32793504, 124621591 },
    X{ 128242569, 474693510 },     X{ 93633646, 357999625 },
    X{ 114897584, 427077540 },     X{ 82402647, 275330091 },
    X{ 45739390, 189765818 },      X{ 9011865, 38929205 },
    X{ 104040611, 445532176 },     X{ 67364676, 328455071 },
    X{ 39016301, 146112270 },      X{ 6502538, 27845761 },
    X{ 53392980, 227209004 },      X{ 18799027, 77034659 },
    X{ 122579354, 531748914 },     X{ 92145277, 380388285 },
    X{ 30766118, 133549928 },      X{ 65346497, 250107111 },
    X{ 95792104, 365885558 },      X{ 126206991, 483615737 },
    X{ 80235217, 284256340 },      X{ 116925750, 434959323 },
    X{ 11048223, 46817098 },       X{ 43580152, 198689989 },
    X{ 93937903, 358995648 },      X{ 128519944, 477646159 },
    X{ 33144609, 123658718 },      X{ 63557830, 239303249 },
    X{ 8674840, 39940604 },        X{ 45363711, 192735859 },
    X{ 82084310, 274351842 },      X{ 114617905, 424140141 },
    X{ 41917546, 136204728 },      X{ 5239693, 17025591 },
    X{ 102712228, 438658726 },     X{ 70200387, 322501929 },
    X{ 123904669, 521860740 },     X{ 89312634, 369585419 },
    X{ 50494803, 220316058 },      X{ 20058804, 71064085 },
    X{ 126359694, 484446512 },     X{ 95975273, 368937663 },
    X{ 65587008, 249243182 },      X{ 30976167, 130465185 },
    X{ 43329145, 199538188 },      X{ 10832286, 49884547 },
    X{ 116783543, 434077970 },     X{ 80057936, 281156253 },
    X{ 7267339, 26973768 },        X{ 39750636, 143003079 },
    X{ 68041669, 329294166 },      X{ 104748066, 448608985 },
    X{ 91478780, 379531636 },      X{ 121877787, 528657147 },
    X{ 18023730, 77858410 },       X{ 52652757, 230268389 },
    X{ 29069357, 107895072 },      X{ 59506634, 259244719 },
    X{ 98258915, 341143102 },      X{ 132849668, 491320753 },
    X{ 78032602, 292224540 },      X{ 110543165, 410477971 },
    X{ 13005076, 55691522 },       X{ 49684211, 172774029 },
    X{ 106785960, 454418008 },     X{ 74253135, 302532055 },
    X{ 37598054, 154069318 },      X{ 908417, 3371721 },
    X{ 54547039, 202471780 },      X{ 24133048, 84730603 },
    X{ 119573905, 506089082 },     X{ 84992630, 389535221 },
    X{ 61532236, 267099856 },      X{ 26904491, 116786527 },
    X{ 130692994, 500214222 },     X{ 100292709, 348992065 },
    X{ 112711355, 418331116 },     X{ 76003676, 301113955 },
    X{ 47647093, 181669618 },      X{ 15165074, 63542653 },
    X{ 72094921, 311433640 },      X{ 108821294, 462258727 },
    X{ 2935559, 11218614 },        X{ 35431648, 162968889 },
    X{ 22096446, 93634196 },       X{ 56706521, 210314523 },
    X{ 87160304, 397379978 },      X{ 117545495, 514986501 },
    X{ 116277429, 431580288 },     X{ 81669970, 279248655 },
    X{ 42901371, 193090462 },      X{ 12513436, 44025873 },
    X{ 66289218, 247317436 },      X{ 29561253, 127948851 },
    X{ 127115660, 478606498 },     X{ 94621291, 362508077 },
    X{ 17349680, 79881208 },       X{ 54055895, 232749175 },
    X{ 90727422, 385471718 },      X{ 123210777, 535056233 },
    X{ 68518599, 331760836 },      X{ 103148832, 450617163 },
    X{ 7691529, 33387482 },        X{ 38089454, 148957269 },
    X{ 83835092, 272409456 },      X{ 114251571, 421607679 },
    X{ 10479386, 34051182 },       X{ 45058301, 186257377 },
    X{ 31589923, 121111628 },      X{ 64121284, 237346755 },
    X{ 92461549, 352531282 },      X{ 129152522, 471771357 },
    X{ 52020305, 222766088 },      X{ 19508150, 73056135 },
    X{ 125377439, 528225046 },     X{ 88700024, 375490713 },
    X{ 100989606, 440632116 },     X{ 70554945, 324933819 },
    X{ 40117608, 142128170 },      X{ 5524111, 23408549 },
    X{ 46968951, 179497824 },      X{ 16572304, 61829359 },
    X{ 111964089, 411688062 },     X{ 77332574, 294930417 },
    X{ 131174016, 498486364 },     X{ 98689383, 346806227 },
    X{ 61952334, 260930370 },      X{ 25247401, 110158029 },
    X{ 86658290, 399076376 },      X{ 119153429, 517273495 },
    X{ 21664572, 99769094 },       X{ 58391771, 217038985 },
    X{ 3633669, 13486884 },        X{ 34020834, 164647083 },
    X{ 72854987, 318176314 },      X{ 107463212, 468412341 },
    X{ 14534678, 53947536 },       X{ 49129457, 170571551 },
    X{ 79501272, 286006158 },      X{ 109934655, 403800065 },
    X{ 96532193, 338922412 },      X{ 133208326, 489558051 },
    X{ 27273519, 101235890 },      X{ 59786952, 253044541 },
    X{ 121320595, 508341224 },     X{ 84630388, 391196775 },
    X{ 56355677, 209165558 },      X{ 23823546, 90834809 },
    X{ 36047460, 155716820 },      X{ 1467779, 5609307 },
    X{ 105305514, 460536778 },     X{ 74889805, 309239877 },
    X{ 58138714, 215790144 },      X{ 21450685, 96545231 },
    X{ 119013268, 518489438 },     X{ 86478963, 402267857 },
    X{ 107617965, 467146108 },     X{ 73036106, 314937075 },
    X{ 34259299, 165880418 },      X{ 3845764, 16693741 },
    X{ 76668127, 296170808 },      X{ 111260472, 414887607 },
    X{ 15794961, 60555814 },       X{ 46230774, 176265641 },
    X{ 26010152, 111383044 },      X{ 62688719, 264112523 },
    X{ 99368422, 345548058 },      X{ 131879425, 495271573 },
    X{ 23484475, 89748912 },       X{ 55982044, 205844031 },
    X{ 84314101, 392315566 },      X{ 121038866, 511695137 },
    X{ 75196108, 308138636 },      X{ 105580843, 457197827 },
    X{ 1816834, 6743442 },         X{ 36427493, 159088157 },
    X{ 109094078, 404943560 },     X{ 78695257, 289368391 },
    X{ 48266096, 169461206 },      X{ 13636759, 50617945 },
    X{ 60660297, 254170612 },      X{ 28177838, 104582779 },
    X{ 134038919, 488465130 },     X{ 97331808, 335608165 },
    X{ 123064472, 534199712 },     X{ 90554239, 382379567 },
    X{ 53808982, 233573054 },      X{ 17129649, 82940209 },
    X{ 38334063, 148085404 },      X{ 7897480, 30277907 },
    X{ 103297441, 451456386 },     X{ 68705862, 334837261 },
    X{ 11742237, 44874456 },       X{ 42157050, 196157783 },
    X{ 80999379, 278367686 },      X{ 115579956, 428480073 },
    X{ 95294186, 363339236 },      X{ 127827213, 481658475 },
    X{ 30330148, 127085306 },      X{ 67019459, 244232565 },
    X{ 88385785, 374536784 },      X{ 125093662, 525296095 },
    X{ 19167031, 74042702 },       X{ 51648720, 225728193 },
    X{ 5871118, 22437228 },        X{ 40499689, 139183843 },
    X{ 70863296, 325937778 },      X{ 101262887, 443609597 },
    X{ 44192892, 187268392 },      X{ 9583515, 37021351 },
    X{ 113413042, 420629046 },     X{ 83027029, 269472185 },
    X{ 129985163, 472766996 },     X{ 93259116, 355484059 },
    X{ 64992581, 236383498 },      X{ 32496290, 118191749}
  };
CONST
  poly72 = T{ (* poly72[i] = i(x)*x^72 MOD P *)
    X{ 0, 0 },                     X{ -1961202135, 335293334 },
    X{ 468213049, 344628781 },     X{ -1863175408, 125220283 },
    X{ 973880089, 443020634 },     X{ -1323936464, 161210060 },
    X{ 568616480, 250440567 },     X{ -1426192375, 487669985 },
    X{ 2042951513, 129835956 },    X{ -220292752, 339806242 },
    X{ 1647094368, 322420121 },    X{ -382286775, 13342223 },
    X{ 1137232960, 500881134 },    X{ -925719959, 237436280 },
    X{ 1478529401, 156256451 },    X{ -751108272, 447505237 },
    X{ -209064270, 259671912 },    X{ 2022932635, 478571774 },
    X{ -396250229, 468769093 },    X{ 1669062050, 135066323 },
    X{ -913975893, 354267698 },    X{ 1117764482, 115448228 },
    X{ -764573550, 26684447 },     X{ 1501030075, 309004169 },
    X{ -1974658581, 147285212 },   X{ 22509506, 456871754 },
    X{ -1851439918, 474872561 },   X{ 448735995, 263311719 },
    X{ -1337908494, 312512902 },   X{ 995839195, 22854160 },
    X{ -1414955061, 103419819 },   X{ 548606434, 366355517 },
    X{ -418128540, 519343825 },    X{ 1812575053, 218670407 },
    X{ -50626467, 176034044 },     X{ 2011295348, 427965290 },
    X{ -585111939, 76774283 },     X{ 1443203156, 393170973 },
    X{ -956843196, 270132646 },    X{ 1307432301, 65392176 },
    X{ -1630066115, 424258917 },   X{ 365773844, 179668723 },
    X{ -2059438332, 230896456 },   X{ 237312301, 507451614 },
    X{ -1529147100, 53368895 },    X{ 801210125, 282227625 },
    X{ -1087157219, 396674578 },   X{ 875110964, 72936836 },
    X{ 345650134, 294570425 },     X{ -1618977281, 41083439 },
    X{ 259157743, 84170644 },      X{ -2073558842, 385383426 },
    X{ 781584591, 199834851 },     X{ -1517525274, 404035445 },
    X{ 897471990, 526623438 },     X{ -1100727329, 211781976 },
    X{ 1834927247, 372501005 },    X{ -431707482, 97501595 },
    X{ 1991678390, 45708320 },     X{ -38996065, 289759158 },
    X{ 1465057174, 206839639 },    X{ -599223873, 531117249 },
    X{ 1287299759, 417235322 },    X{ -945763194, 186821356 },
    X{ -1006945373, 245093539 },   X{ 1222727050, 493354805 },
    X{ -669817190, 437340814 },    X{ 1393100979, 166551832 },
    X{ -101252934, 352068089 },    X{ 1928162963, 117443183 },
    X{ -501260925, 7782356 },      X{ 1761948586, 327849026 },
    X{ -1170223878, 153548567 },   X{ 824550099, 450550913 },
    X{ -1579707965, 497838394 },   X{ 718143466, 240140972 },
    X{ -2144077853, 323027533 },   X{ 187275722, 12397019 },
    X{ -1680102694, 130784352 },   X{ 281134323, 339195894 },
    X{ 812832017, 31560651 },      X{ -1150764232, 303937629 },
    X{ 731547688, 359337446 },     X{ -1602165247, 110569072 },
    X{ 176090632, 461792913 },     X{ -2124120031, 142232839 },
    X{ 295088945, 252508348 },     X{ -1702044392, 485544746 },
    X{ 1236673096, 106737791 },    X{ -1028895647, 362847209 },
    X{ 1381924721, 316026450 },    X{ -649850536, 19531204 },
    X{ 1941576017, 473646373 },    X{ -123701384, 264728243 },
    X{ 1750221928, 145873672 },    X{ -481809855, 458092702 },
    X{ 619243207, 275733106 },     X{ -1343059730, 59994596 },
    X{ 1057012734, 82166879 },     X{ -1273309737, 387575753 },
    X{ 518315486, 168341288 },     X{ -1778469897, 435455166 },
    X{ 84705511, 511848709 },      X{ -1911099698, 226368147 },
    X{ 1563169182, 399669702 },    X{ -701071433, 70144592 },
    X{ 1187269799, 56158187 },     X{ -841080178, 279235709 },
    X{ 1730161287, 230001820 },    X{ -331725650, 508143370 },
    X{ 2093512638, 423563953 },    X{ -137225833, 180566311 },
    X{ -681506699, 521477402 },    X{ 1551591004, 216610444 },
    X{ -863414964, 195003191 },    X{ 1200831333, 409184417 },
    X{ -311610516, 91416640 },     X{ 1719098693, 378454998 },
    X{ -159027627, 301495917 },    X{ 2107572348, 33840635 },
    X{ -1364852948, 413679278 },   X{ 633311493, 190059832 },
    X{ -1253203435, 203595907 },   X{ 1045941308, 534678293 },
    X{ -1800813515, 47172596 },    X{ 531868188, 288612450 },
    X{ -1891526388, 373642713 },   X{ 73135909, 96042575 },
    X{ -2013890746, 490187079 },   X{ 216799599, 248218321 },
    X{ -1675744641, 163395434 },   X{ 386155606, 440474876 },
    X{ -1107669921, 122706973 },   X{ 920658550, 346847115 },
    X{ -1508765338, 333103664 },   X{ 755531599, 2550182 },
    X{ -30244833, 445287155 },     X{ 1965616694, 158769509 },
    X{ -438641370, 234886366 },    X{ 1858122511, 503070536 },
    X{ -1002521850, 15564713 },    X{ 1327813935, 319902783 },
    X{ -539564481, 342352260 },    X{ 1422690326, 127650322 },
    X{ 1954519540, 307097135 },    X{ -10094627, 28427705 },
    X{ 1872217293, 113733634 },    X{ -460477724, 356211604 },
    X{ 1316201197, 136977269 },    X{ -982922044, 467022051 },
    X{ 1436286932, 480281944 },    X{ -561933827, 257732302 },
    X{ 230387373, 368102811 },     X{ -2036268924, 101508621 },
    X{ 374551444, 24794038 },      X{ -1656136259, 310802464 },
    X{ 934761908, 261568705 },     X{ -1129497699, 476779351 },
    X{ 744425613, 454928108 },     X{ -1488623964, 148999546 },
    X{ 1625664034, 63121302 },     X{ -335559669, 272567296 },
    X{ 2064512795, 390707643 },    X{ -266888910, 79008301 },
    X{ 1525256507, 430232268 },    X{ -772538606, 173603162 },
    X{ 1090636802, 221138145 },    X{ -904158677, 517105527 },
    X{ 421617019, 75367458 },      X{ -1841613998, 394407860 },
    X{ 46727234, 284465679 },      X{ -1982632341, 50901401 },
    X{ 590177890, 505016696 },     X{ -1472788405, 233167598 },
    X{ 952449883, 177434453 },     X{ -1277209230, 426722499 },
    X{ -1821621104, 213475582 },   X{ 410397369, 524634984 },
    X{ -2004608599, 406060755 },   X{ 60716928, 198169925 },
    X{ -1453293687, 383686052 },   X{ 578425248, 86162994 },
    X{ -1299701072, 39062409 },    X{ 965889177, 296230943 },
    X{ -358042679, 184828746 },    X{ 1639112160, 418932956 },
    X{ -247402768, 529456487 },    X{ 2052751577, 208860913 },
    X{ -794523440, 291747344 },    X{ 1539237625, 44014982 },
    X{ -884156951, 99166269 },     X{ 1079425984, 370475947 },
    X{ 1141722341, 330071524 },    X{ -820567348, 5265010 },
    X{ 1608847836, 119989193 },    X{ -721453067, 349882463 },
    X{ 2114025468, 164333758 },    X{ -182773291, 439853864 },
    X{ 1709779653, 490804883 },    X{ -286046996, 247282949 },
    X{ 1036630972, 336682576 },    X{ -1227631211, 133002694 },
    X{ 639755909, 10207357 },      X{ -1388607316, 325577707 },
    X{ 130384037, 242658058 },     X{ -1931481460, 495616156 },
    X{ 472767900, 452736295 },     X{ -1757957195, 151002801 },
    X{ -1216044457, 483801740 },   X{ 1017039998, 254415130 },
    X{ -1402142866, 140289185 },   X{ 662081863, 463507255 },
    X{ -1920427698, 112316374 },   X{ 110294887, 357426240 },
    X{ -1772043145, 305877499 },   X{ 494578270, 29850221 },
    X{ -834644722, 460003640 },    X{ 1163541287, 144126638 },
    X{ -710408137, 266438421 },    X{ 1588749854, 471706755 },
    X{ -196317673, 17624162 },     X{ 2136342590, 317769716 },
    X{ -274451666, 361132623 },    X{ 1690197255, 108681689 },
    X{ -1558277759, 223933237 },   X{ 671416232, 514119843 },
    X{ -1191785288, 433220888 },   X{ 871146129, 170804878 },
    X{ -1726829928, 390006383 },   X{ 302564529, 79900153 },
    X{ -2097481823, 62232642 },    X{ 165714312, 273265620 },
    X{ -623221032, 182833281 },    X{ 1371539697, 421133079 },
    X{ -1053672479, 510611116 },   X{ 1244157384, 227763514 },
    X{ -522822207, 276964827 },    X{ 1808544744, 58592845 },
    X{ -79822600, 67681270 },      X{ 1881435857, 401903712 },
    X{ 1352105779, 35828829 },     X{ -611512038, 299802571 },
    X{ 1266622986, 380119664 },    X{ -1067103197, 89391590 },
    X{ 1788560426, 407191815 },    X{ -511628797, 196700817 },
    X{ 1903368467, 214949674 },    X{ -93751494, 523498684 },
    X{ 693340266, 94345193 },      X{ -1572215229, 375635071 },
    X{ 851170643, 286591428 },     X{ -1180583046, 48833106 },
    X{ 325038963, 536371891 },     X{ -1740251814, 201607461 },
    X{ 146271818, 192085150 },     X{ -2085781405, 412014344}
  };

CONST
  poly80 = T{ (* poly80[i] = i(x)*x^80 MOD P *)
    X{ 0, 0 },                     X{ -1753253426, 125726524 },
    X{ 788460444, 251453049 },     X{ -1182692782, 159560005 },
    X{ 1576920888, 502906098 },    X{ -897409290, 445109198 },
    X{ 1929581732, 319120011 },    X{ -461607574, 343608759 },
    X{ -1238937829, 142717156 },   X{ 559429333, 268427224 },
    X{ -1730560889, 108883613 },   X{ 262587721, 16974241 },
    X{ -337991645, 360188950 },    X{ 2091241965, 302408490 },
    X{ -987472961, 461689455 },    X{ 1381704305, 486194515 },
    X{ 1817091638, 285434313 },    X{ -80615432, 377294581 },
    X{ 1118858666, 536854448 },    X{ -707849116, 411160716 },
    X{ 833845518, 217767227 },     X{ -1496579904, 193245703 },
    X{ 525175442, 33948482 },      X{ -2009926820, 91778174 },
    X{ -630599379, 428003629 },    X{ 1293330659, 519880209 },
    X{ -191421775, 394137428 },    X{ 1676172159, 268460136 },
    X{ -2020329963, 75197919 },    X{ 283856859, 50660067 },
    X{ -1452620407, 176665510 },   X{ 1041611847, 234478746 },
    X{ -717112057, 292817554 },    X{ 1111409865, 369780142 },
    X{ -71348581, 529061099 },     X{ 1824536405, 418823127 },
    X{ -2000922049, 210613856 },   X{ 532882417, 200530268 },
    X{ -1505580637, 40986649 },    X{ 826134637, 84870949 },
    X{ 1667691036, 435534454 },    X{ -199652398, 512480586 },
    X{ 1301807488, 386491407 },    X{ -622364594, 276237107 },
    X{ 1050350884, 67896964 },     X{ -1444647702, 57829816 },
    X{ 275113656, 183556349 },     X{ -2028298378, 227456961 },
    X{ -1190190287, 7826267 },     X{ 779115263, 118031463 },
    X{ -1745760083, 244036898 },   X{ 9349475, 167107102 },
    X{ -453852151, 495900585 },    X{ 1938668999, 451983509 },
    X{ -905169003, 326240720 },    X{ 1567837787, 336357100 },
    X{ 254307370, 150395839 },     X{ -1739123228, 260617347 },
    X{ 567713718, 101320134 },     X{ -1230379400, 24406778 },
    X{ 1389726482, 353331021 },    X{ -978652452, 309397617 },
    X{ 2083223694, 468957492 },    X{ -346816192, 479057416 },
    X{ -1486881947, 295361573 },   X{ 807436971, 384086809 },
    X{ -1985935111, 526778972 },   X{ 517894455, 404254048 },
    X{ -90039203, 207839447 },     X{ 1843226003, 186453995 },
    X{ -732106815, 44023470 },     X{ 1126405647, 98685330 },
    X{ 293123198, 421227713 },     X{ -2046308944, 509936637 },
    X{ 1065764834, 401060536 },    X{ -1460060628, 278519172 },
    X{ 1283806022, 81973299 },     X{ -604362104, 60604175 },
    X{ 1652269274, 169741898 },    X{ -184231660, 224420214 },
    X{ -888052397, 10075628 },     X{ 1550720157, 132633296 },
    X{ -437283121, 241525653 },    X{ 1922100993, 152767657 },
    X{ -1762885013, 492831006 },   X{ 26475429, 438201890 },
    X{ -1206750729, 329047911 },   X{ 795674681, 350400603 },
    X{ 2100701768, 135793928 },    X{ -364293242, 258368052 },
    X{ 1405671892, 115659633 },    X{ -994598886, 26917965 },
    X{ 550227312, 367112698 },     X{ -1212894018, 312467142 },
    X{ 238370540, 454913923 },     X{ -1723185374, 476250303 },
    X{ 1914586722, 15652535 },     X{ -446611540, 126925195 },
    X{ 1558230526, 236062926 },    X{ -878719952, 158099442 },
    X{ 803447130, 488073797 },     X{ -1197680492, 443090297 },
    X{ 18698950, 334214204 },      X{ -1771951352, 345365248 },
    X{ -1002894983, 141518419 },   X{ 1397125303, 252774767 },
    X{ -355992859, 110344234 },    X{ 2109244203, 32364310 },
    X{ -1715147199, 362207905 },   X{ 247175055, 317240733 },
    X{ -1220928035, 459932888 },   X{ 541418515, 471100388 },
    X{ 508614740, 300791678 },     X{ -1993367142, 378787906 },
    X{ 816720840, 521234695 },     X{ -1479454202, 409929275 },
    X{ 1135427436, 202640268 },    X{ -724416862, 191521968 },
    X{ 1834208496, 48813557 },     X{ -97733314, 93764297 },
    X{ -1468557489, 426510234 },   X{ 1057549953, 504522918 },
    X{ -2037816109, 395368931 },   X{ 301341981, 284079839 },
    X{ -175476617, 76921704 },     X{ 1660225977, 65786964 },
    X{ -613121045, 174679313 },    X{ 1275853349, 219613741 },
    X{ 1130592161, 273117515 },    X{ -736358801, 389619319 },
    X{ 1839039549, 515616562 },    X{ -85787149, 432390158 },
    X{ 513708185, 230608313 },     X{ -1981683369, 180396677 },
    X{ 811623173, 54662080 },      X{ -1491133749, 71073020 },
    X{ -180078406, 415678895 },    X{ 1648050548, 532197011 },
    X{ -608515290, 372907990 },    X{ 1288024808, 289698026 },
    X{ -1464213630, 88046941 },    X{ 1069983308, 37818977 },
    X{ -2042156002, 197370660 },   X{ 288904656, 213765144 },
    X{ 791538071, 21237890 },      X{ -1202548647, 104497086 },
    X{ 30611979, 263769851 },      X{ -1767087163, 147235271 },
    X{ 1926237871, 482192496 },    X{ -441485471, 465814348 },
    X{ 1546583347, 306278921 },    X{ -883849987, 356457781 },
    X{ -1727355252, 163946598 },   X{ 242605890, 247189338 },
    X{ -1208724208, 121208351 },   X{ 545991902, 4657443 },
    X{ -990428748, 339483796 },    X{ 1401436282, 323122088 },
    X{ -368463320, 448840429 },    X{ 2104937446, 499035601 },
    X{ -1776104794, 20151257 },    X{ 22917992, 105714917 },
    X{ -1193526982, 265266592 },   X{ 799228148, 145869468 },
    X{ -874566242, 483051307 },    X{ 1554011216, 464824343 },
    X{ -450765310, 305535314 },    X{ 1918805964, 357070446 },
    X{ 537232829, 162712381 },     X{ -1216676749, 248292353 },
    X{ 251360801, 122557764 },     X{ -1719398417, 3177080 },
    X{ 2113430149, 340490191 },    X{ -360244405, 322246899 },
    X{ 1392939289, 448244150 },    X{ -998643497, 499762826 },
    X{ -93563760, 271587856 },     X{ 1829973342, 391017772 },
    X{ -728586484, 516736105 },    X{ 1139662530, 431139669 },
    X{ -1483623512, 231319266 },   X{ 820955750, 179816926 },
    X{ -1989197772, 53835931 },    X{ 504379898, 72030119 },
    X{ 1279990667, 414296820 },    X{ -617323963, 533710280 },
    X{ 1656088599, 374174861 },    X{ -171273767, 288562097 },
    X{ 297204915, 88610310 },      X{ -2033613443, 37124410 },
    X{ 1061687087, 196397183 },    X{ -1472760095, 214607683 },
    X{ -465793852, 31305070 },     X{ 1933833482, 111395410 },
    X{ -893223080, 253850391 },    X{ 1572669078, 140450859 },
    X{ -1178506244, 472125852 },   X{ 784208434, 458915488 },
    X{ -1757439904, 316198885 },   X{ 4252078, 363241689 },
    X{ 1377551327, 157031818 },    X{ -983254511, 237138614 },
    X{ 2095394883, 127976435 },    X{ -342210163, 14593231 },
    X{ 266740967, 346399096 },     X{ -1734779607, 333172292 },
    X{ 555276155, 442072833 },     X{ -1234719051, 489099325 },
    X{ -2005789966, 283036839 },   X{ 520973116, 396403611 },
    X{ -1500716690, 505549534 },   X{ 838047904, 425491938 },
    X{ -711985718, 220688469 },    X{ 1123060740, 173612905 },
    X{ -76478890, 64728620 },      X{ 1812889496, 77971728 },
    X{ 1045781993, 408910915 },    X{ -1456856025, 522261375 },
    X{ 279686773, 379822650 },     X{ -2016094277, 299748614 },
    X{ 1672002257, 94814385 },     X{ -187186401, 47755149 },
    X{ 1297500493, 190455496 },    X{ -634834813, 203715060 },
    X{ 830288323, 279554044 },     X{ -1509799923, 400017600 },
    X{ 528728671, 508918149 },     X{ -1996702831, 422254265 },
    X{ 1820382971, 223353614 },    X{ -67129547, 170816562 },
    X{ 1115563367, 61654391 },     X{ -721331031, 80915019 },
    X{ -2024112424, 405280536 },   X{ 270862102, 525760548 },
    X{ -1448833724, 383043937 },   X{ 1054602378, 296396381 },
    X{ -626550304, 97627114 },     X{ 1306058798, 45073622 },
    X{ -195466628, 187528595 },    X{ 1663439794, 206772911 },
    X{ 1563668469, 27969077 },     X{ -900934085, 114600201 },
    X{ 1942838377, 257300556 },    X{ -458087001, 136869744 },
    X{ 13519053, 475232967 },      X{ -1749995261, 455939579 },
    X{ 774945617, 313500862 },     X{ -1185955169, 366070658 },
    X{ -350953234, 153843409 },    X{ 2087426336, 240458221 },
    X{ -974515342, 131573928 },    X{ 1385523900, 11126676 },
    X{ -1226242090, 349358627 },   X{ 563510808, 330081567 },
    X{ -1743260598, 439227482 },   X{ 258510212, 491813734}
  };

CONST
  poly88 = T{ (* poly88[i] = i(x)*x^88 MOD P *)
    X{ 0, 0 },                     X{ 964379295, 346020725 },
    X{ 2133460053, 441286634 },    X{ 1179731658, 248685727 },
    X{ -209155647, 132658900 },    X{ -889992354, 326626721 },
    X{ -1935503980, 497371454 },   X{ -1244016885, 154833483 },
    X{ -418311294, 265317801 },    X{ -563457763, 458208988 },
    X{ -1740957737, 362615363 },   X{ -1589619384, 16959798 },
    X{ 345610819, 137911165 },     X{ 769841372, 480739336 },
    X{ 1806933526, 309666967 },    X{ 1388895369, 116064226 },
    X{ -836622588, 530635603 },    X{ -145136229, 188678182 },
    X{ -1324866735, 99460281 },    X{ -2005704242, 292716492 },
    X{ 1034596037, 407432583 },    X{ 80866394, 215430898 },
    X{ 1115728528, 33919597 },     X{ 2080106511, 379210008 },
    X{ 691221638, 275822330 },     X{ 273184281, 82800015 },
    X{ 1444491475, 171821328 },    X{ 1868722764, 513938021 },
    X{ -625230521, 395870254 },    X{ -473890856, 50813787 },
    X{ -1517176558, 232128452 },   X{ -1662321779, 424289457 },
    X{ -1852256413, 204701607 },   X{ -1461481988, 413967570 },
    X{ -290272458, 377356365 },    X{ -674657879, 48356152 },
    X{ 1645233826, 198920563 },    X{ 1533740093, 524587526 },
    X{ 490357495, 295057049 },     X{ 608239720, 84536812 },
    X{ 1988746465, 65212942 },     X{ 1341300350, 394054011 },
    X{ 161732788, 430861796 },     X{ 819501611, 221361809 },
    X{ -2063510240, 67839194 },    X{ -1132849217, 278200239 },
    X{ -97824395, 507927344 },     X{ -1018162198, 182026309 },
    X{ 1606084711, 328443124 },    X{ 1723968248, 118259585 },
    X{ 546368562, 165600030 },     X{ 434876077, 490799211 },
    X{ -1405984346, 343642656 },   X{ -1790368967, 14960981 },
    X{ -753375757, 238480842 },    X{ -362600596, 447297215 },
    X{ -1196688411, 474204509 },   X{ -2117027462, 148640296 },
    X{ -947781712, 101627575 },    X{ -17122001, 311520706 },
    X{ 1260614180, 464256905 },    X{ 1918382267, 255075580 },
    X{ 873035377, 31883363 },      X{ 225588462, 360274710 },
    X{ 590454470, 409403215 },     X{ 441113689, 217654330 },
    X{ 1545312915, 36405413 },     X{ 1700845580, 380918736 },
    X{ -793176313, 529451419 },    X{ -373140072, 185668334 },
    X{ -1349315758, 96712305 },    X{ -1763159603, 291269892 },
    X{ -1004499644, 397841126 },   X{ -44314661, 53037459 },
    X{ -1156937455, 234614028 },   X{ -2106471538, 425997945 },
    X{ 933758085, 274637874 },     X{ 248727066, 79789895 },
    X{ 1216479440, 169073624 },    X{ 1912160847, 512491693 },
    X{ -317474366, 130425884 },    X{ -731317411, 324665193 },
    X{ -1841709673, 495672310 },   X{ -1421672696, 152338563 },
    X{ 513486851, 3019464 },       X{ 669020828, 347195837 },
    X{ 1639003222, 442723618 },    X{ 1489663689, 251442775 },
    X{ 167946816, 135678389 },     X{ 863627487, 478778048 },
    X{ 1965600277, 307967583 },    X{ 1280568458, 113569066 },
    X{ -108387455, 268336993 },    X{ -1057922786, 459383828 },
    X{ -2036324396, 364052619 },   X{ -1076140725, 19717118 },
    X{ -1297526363, 341147880 },   X{ -1949166790, 13261725 },
    X{ -847030800, 236519170 },    X{ -185067665, 445064311 },
    X{ 1092737124, 331200060 },    X{ 2019203835, 119696713 },
    X{ 1040964657, 166775254 },    X{ 124821166, 493818531 },
    X{ 1438138919, 461761857 },    X{ 1824719032, 253376052 },
    X{ 714229362, 29921963 },      X{ 334038253, 358042078 },
    X{ -1506751514, 476961685 },   X{ -1622439559, 150077664 },
    X{ -652554317, 102802559 },    X{ -530477780, 314539786 },
    X{ 2089514657, 200629179 },    X{ 1173369918, 527073486 },
    X{ 60912372, 297280593 },      X{ 987377771, 86507300 },
    X{ -1895563424, 203255151 },   X{ -1233601025, 411219482 },
    X{ -265684171, 374346373 },    X{ -917325398, 47172080 },
    X{ -1684380381, 69547538 },    X{ -1562302532, 280685927 },
    X{ -458202762, 510151160 },    X{ -573889559, 183997069 },
    X{ 1746070754, 63766726 },     X{ 1365880445, 391306163 },
    X{ 389605559, 427851564 },     X{ 776186408, 220177497 },
    X{ 1270856935, 62863262 },     X{ 1925512824, 388033771 },
    X{ 882227378, 435308660 },     X{ 233765421, 225284865 },
    X{ -1204341466, 72810826 },    X{ -2125695047, 281598527 },
    X{ -954388109, 505052832 },    X{ -26840084, 176530901 },
    X{ -1397837979, 208624183 },   X{ -1781142022, 418414914 },
    X{ -746280144, 371336669 },    X{ -352327249, 46005928 },
    X{ 1596335780, 193424611 },    X{ 1717396539, 521713558 },
    X{ 537666289, 298455817 },     X{ 427253870, 89507964 },
    X{ -2053268509, 471854285 },   X{ -1125721732, 142620600 },
    X{ -88629322, 106074919 },     X{ -1009984215, 315443282 },
    X{ 1981092386, 469228057 },    X{ 1332629693, 258474348 },
    X{ 155129463, 29009395 },      X{ 809784552, 354778758 },
    X{ 1653377121, 332366180 },    X{ 1542966014, 122706449 },
    X{ 497454132, 159579790 },     X{ 618516139, 488449531 },
    X{ -1862008416, 338147248 },   X{ -1468054721, 12086469 },
    X{ -298973707, 241879130 },    X{ -682277014, 452268847 },
    X{ -634948732, 260851769 },    X{ -480497381, 454267724 },
    X{ -1525844015, 364984275 },   X{ -1669974706, 22998182 },
    X{ 699398725, 140803821 },     X{ 282376410, 486253976 },
    X{ 1451621904, 304677127 },    X{ 1878965391, 112646770 },
    X{ 1026973702, 6038928 },      X{ 72163993, 348389093 },
    X{ 1109156947, 437344890 },    X{ 2070357708, 244220175 },
    X{ -826349113, 129241924 },    X{ -138040488, 321636401 },
    X{ -1315639918, 502885550 },   X{ -1997558003, 157726683 },
    X{ 335893632, 271356778 },     X{ 763237919, 78858271 },
    X{ 1798262997, 174189696 },    X{ 1381241418, 519976949 },
    X{ -410133183, 398763454 },    X{ -554262562, 56327883 },
    X{ -1733830380, 227138132 },   X{ -1579377781, 420872481 },
    X{ -216774910, 536673987 },    X{ -898693731, 191047094 },
    X{ -1942076585, 95519017 },    X{ -1253768760, 288250460 },
    X{ 10276547, 404015127 },      X{ 971476060, 210441058 },
    X{ 2142685846, 39434237 },     X{ 1187874825, 382102664 },
    X{ 1754145313, 467257553 },    X{ 1375035582, 256250788 },
    X{ 396633716, 26523451 },      X{ 786392299, 353070158 },
    X{ -1694061600, 473038341 },   X{ -1568806529, 145630576 },
    X{ -466833483, 108823023 },    X{ -581440214, 316889754 },
    X{ -1885392477, 336176504 },   X{ -1226542276, 9862669 },
    X{ -256559626, 239393426 },    X{ -909215895, 450560487 },
    X{ 2081929314, 333550508 },    X{ 1164770045, 125716697 },
    X{ 54377527, 162327622 },      X{ 977731240, 489895731 },
    X{ -1498675931, 75043714 },    X{ -1613281350, 283560183 },
    X{ -645529232, 506752104 },    X{ -520272913, 179025693 },
    X{ 1428458724, 59843926 },     X{ 1818218107, 386858531 },
    X{ 705595569, 433871548 },     X{ 326486574, 222527945 },
    X{ 1102911143, 195657259 },    X{ 2026263608, 523674974 },
    X{ 1050088178, 300155329 },    X{ 132927597, 92002996 },
    X{ -1305108634, 205605119 },   X{ -1957765639, 417239946 },
    X{ -853566669, 369899285 },    X{ -194717268, 43248736 },
    X{ -115937982, 401258358 },    X{ -1066553379, 58027011 },
    X{ -2042828521, 229099676 },   X{ -1085822072, 423105513 },
    X{ 178152579, 268599714 },     X{ 870655516, 77421271 },
    X{ 1974755542, 173014600 },    X{ 1288643145, 516957501 },
    X{ 503840448, 406510303 },     X{ 662486111, 212140458 },
    X{ 1630403221, 41395509 },     X{ 1482078218, 384335424 },
    X{ -309364991, 533916683 },    X{ -722192994, 189609854 },
    X{ -1834650796, 94344161 },    X{ -1411501621, 285231252 },
    X{ 926206534, 139095077 },     X{ 240093401, 483768144 },
    X{ 1209978387, 302453711 },    X{ 1902480524, 110676154 },
    X{ -994294905, 262298353 },    X{ -37289704, 457015684 },
    X{ -1147779118, 367994139 },   X{ -2098395827, 24182382 },
    X{ -802825788, 127533452 },    X{ -379675813, 319150841 },
    X{ -1357914735, 500661862 },   X{ -1770742002, 155755795 },
    X{ 598560773, 7485272 },       X{ 450237082, 351136813 },
    X{ 1552372816, 440354994 },    X{ 1711019727, 245404615}
  };

CONST
  power   = T{ (* power[i]   = x^i        MOD P *)
    X{0, MIN_INT },                X{0, 1073741824 },
    X{0, 536870912 },              X{0, 268435456 },
    X{0, 134217728 },              X{0, 67108864 },
    X{0, 33554432 },               X{0, 16777216 },
    X{0, 8388608 },                X{0, 4194304 },
    X{0, 2097152 },                X{0, 1048576 },
    X{0, 524288 },                 X{0, 262144 },
    X{0, 131072 },                 X{0, 65536 },
    X{0, 32768 },                  X{0, 16384 },
    X{0, 8192 },                   X{0, 4096 },
    X{0, 2048 },                   X{0, 1024 },
    X{0, 512 },                    X{0, 256 },
    X{0, 128 },                    X{0, 64 },
    X{0, 32 },                     X{0, 16 },
    X{0, 8 },                      X{0, 4 },
    X{0, 2 },                      X{0, 1 },
    X{MIN_INT, 0 },                X{1073741824, 0 },
    X{536870912, 0 },              X{268435456, 0 },
    X{134217728, 0 },              X{67108864, 0 },
    X{33554432, 0 },               X{16777216, 0 },
    X{8388608, 0 },                X{4194304, 0 },
    X{2097152, 0 },                X{1048576, 0 },
    X{524288, 0 },                 X{262144, 0 },
    X{131072, 0 },                 X{65536, 0 },
    X{32768, 0 },                  X{16384, 0 },
    X{8192, 0 },                   X{4096, 0 },
    X{2048, 0 },                   X{1024, 0 },
    X{512, 0 },                    X{256, 0 },
    X{128, 0 },                    X{64, 0 },
    X{32, 0 },                     X{16, 0 },
    X{8, 0 },                      X{4, 0 },
    X{2, 0 },                      X{1, 0 },
    X{116277429, 431580288 },      X{93937903, 358995648 },
    X{69398722, 319524832 },       X{34699361, 159762416 },
    X{132578437, 494634872 },      X{85802743, 386180924 },
    X{73457614, 305870622 },       X{36728807, 152935311 },
    X{-2013890746, 490187079 },    X{-1006945373, 245093539 },
    X{-418128540, 519343825 },     X{-209064270, 259671912 },
    X{2042951513, 129835956 },     X{973880089, 443020634 },
    X{468213049, 344628781 },      X{-1961202135, 335293334 },
    X{1130592161, 273117515 },     X{-1486881947, 295361573 },
    X{-717112057, 292817554 },     X{1817091638, 285434313 },
    X{-1238937829, 142717156 },    X{1576920888, 502906098 },
    X{788460444, 251453049 },      X{-1753253426, 125726524 },
    X{1270856935, 62863262 },      X{590454470, 409403215 },
    X{-1852256413, 204701607 },    X{-836622588, 530635603 },
    X{-418311294, 265317801 },     X{-209155647, 132658900 },
    X{2133460053, 441286634 },     X{964379295, 346020725 },
    X{-1705778694, 334924090 },    X{1294594301, 167462045 },
    X{-1602570037, 491046606 },    X{1456676048, 387647463 },
    X{-1419145624, 193823731 },    X{-709572812, 96911865 },
    X{-354786406, 48455932 },      X{1970090445, 24227966 },
    X{1012455507, 419544255 },     X{-1732105060, 356104927 },
    X{-866052530, 178052463 },     X{-433026265, 89026231 },
    X{-168426202, 454972379 },     X{-84213101, 227486189 },
    X{-74202628, 528412790 },      X{2110382334, 264206395 },
    X{-1092292481, 132103197 },    X{-644073334, 441891470 },
    X{1825446981, 220945735 },     X{-1333178729, 523029027 },
    X{-559224834, 372179345 },     X{-279612417, 186089672 },
    X{1900345674, 473081060 },     X{950172837, 236540530 },
    X{448757479, 515231161 },      X{-1951268922, 384008796 },
    X{1171849187, 192004398 },     X{604127044, 469861399 },
    X{-1845420126, 234930699 },    X{-922710063, 117465349 },
    X{-496105635, 439964674 },     X{2010727195, 346410625 },
    X{-1123884744, 334201792 },    X{1585541276, 167100896 },
    X{792770638, 83550448 },       X{396385319, 41775224 },
    X{222195366, 411557052 },      X{111097683, 205778526 },
    X{94493468, 530092975 },       X{-2100236914, 265046487 },
    X{-1050118457, 132523243 },    X{-430277674, 441087733 },
    X{-215138837, 220543866 },     X{2138627648, 522975549 },
    X{-1078169824, 261487774 },    X{1608398736, 130743887 },
    X{-1343284280, 65371943 },     X{-671642140, 32685971 },
    X{-335821070, 16342985 },      X{-167910535, 8171492 },
    X{2081468681, 428290930 },     X{954603569, 360381753 },
    X{-1700967251, 319035932 },    X{1268836067, 272329102 },
    X{591279044, 296013895 },      X{-1851844126, 148006947 },
    X{-925922063, 74003473 },      X{-494303539, 462290568 },
    X{2007663571, 343907268 },     X{1027277148, 327592290 },
    X{513638574, 163796145 },      X{-1890664361, 81898072 },
    X{1095311518, 466203052 },     X{547655759, 233101526 },
    X{381421714, 525011179 },      X{-1956772791, 262505589 },
    X{-1019133295, 510371514 },    X{1733222909, 378320861 },
    X{-1253494709, 318717806 },    X{1548408976, 281475895 },
    X{-1373279160, 140737947 },    X{-686639580, 70368973 },
    X{-343319790, 35184486 },      X{1975823753, 17592243 },
    X{-1140058511, 423580505 },    X{-655864947, 354864428 },
    X{1788503411, 321520150 },     X{866349580, 271345035 },
    X{-1714308858, 135672517 },    X{-857154429, 67836258 },
    X{1620717300, 465365041 },     X{-1337124998, 232682520 },
    X{1478921149, 116341260 },     X{721225067, 449771910 },
    X{328253952, 350099523 },      X{-1983356672, 175049761 },
    X{-991678336, 87524880 },      X{1651644480, 43762440 },
    X{825822240, 21881220 },       X{412911120, 10940610 },
    X{206455560, 5470305 },        X{-2044255868, 2735152 },
    X{1125355714, 1367576 },       X{562677857, 683788 },
    X{371893381, 431772422 },      X{234558199, 359091459 },
    X{-2146186802, 319472129 },    X{-1073093401, 159736064 },
    X{1726657222, 494654464 },     X{863328611, 247327232 },
    X{525659140, 518492544 },      X{262829570, 259246272 },
    X{131414785, 129623136 },      X{84204853, 442865328 },
    X{74198575, 344698840 },       X{81287074, 335328108 },
    X{40643537, 167664054 },       X{131618141, 491145307 },
    X{-2063439333, 387596461 },    X{-999328328, 305415382 },
    X{1647819484, 152707691 },     X{-1323573906, 76353845 },
    X{-661786953, 38176922 },      X{1789442030, 412754125 },
    X{-1252762633, 206377062 },    X{1547988302, 530574515 },
    X{-1373489497, 265287257 },    X{-771793946, 509517740 },
    X{1761586675, 254758870 },     X{848401996, 506381163 },
    X{-1723282650, 253190581 },    X{-861641325, 126595290 },
    X{1622962812, 444382445 },     X{-1336002242, 222191222 },
    X{1479482527, 111095611 },     X{-1426469126, 452391709 },
    X{-713234563, 226195854 },     X{1817195275, 520411207 },
    X{-1329178320, 372967587 },    X{-664589160, 186483793 },
    X{-332294580, 93241896 },      X{1981336358, 46620948 },
    X{990668179, 23310474 },       X{459829884, 420003013 },
    X{-1917568706, 210001506 },    X{1188699295, 105000753 },
    X{-1518121222, 446198552 },    X{1388423037, 223099276 },
    X{797872907, 522156102 },      X{287902000, 372693155 },
    X{-2003532648, 186346577 },    X{-1001766324, 93173288 },
    X{1646600486, 46586644 },      X{823300243, 23293322 },
    X{510068988, 420008517 },      X{-1892449154, 210004258 },
    X{1201259071, 105002129 },     X{-1524457046, 446201544 },
    X{1385255125, 223100772 },     X{799467743, 522156850 },
    X{289223898, 372693273 },      X{-2002871699, 186346636 },
    X{1117851011, 473223878 },     X{666814068, 396561891 },
    X{-1814076614, 198280945 },    X{-907038307, 99140472 },
    X{1645844603, 458032444 },     X{937593992, 337634846 },
    X{468796996, 168817423 },      X{-1913085150, 84408711}
  };

CONST
  power8  = T{ (* power8[i]  = x^(i*2^8)  MOD P *)
    X{ 0, MIN_INT },               X{ -956542575, 42204355 },
    X{ 2124032800, 440173005 },    X{ -411289161, 519166785 },
    X{ 407531543, 145381745 },     X{ 108738866, 98552085 },
    X{ 400921722, 498874605 },     X{ 1242762180, 256911310 },
    X{ 2109856647, 96964726 },     X{ 996671204, 257998531 },
    X{ 467564516, 323782309 },     X{ 2111394312, 21238660 },
    X{ -1306609287, 245139119 },   X{ -1468669664, 195722279 },
    X{ -516932754, 246338639 },    X{ 1012877479, 207077650 },
    X{ 2117923080, 435812612 },    X{ -823360084, 489334521 },
    X{ 826081040, 423945279 },     X{ -1899395231, 292825033 },
    X{ -1897029508, 484374966 },   X{ -1632278146, 451753137 },
    X{ 1459848618, 120681369 },    X{ 1044300319, 518200537 },
    X{ -929635973, 1165678 },      X{ -439593506, 105840678 },
    X{ -1156712271, 342268821 },   X{ 1069160894, 213373093 },
    X{ 683088256, 291076695 },     X{ -1813073306, 230393933 },
    X{ -1290194516, 55028625 },    X{ 1267593112, 88131170 },
    X{ 1817135625, 357639862 },    X{ -792214377, 477495567 },
    X{ -76607110, 141586934 },     X{ 211787753, 101986847 },
    X{ 104004757, 480961197 },     X{ 909571009, 296857293 },
    X{ -1123090224, 456361475 },   X{ 1536547100, 413695142 },
    X{ -1657239059, 161333384 },   X{ 521758144, 368927712 },
    X{ -434504887, 24436703 },     X{ 824325828, 253654286 },
    X{ 1914539473, 504727018 },    X{ 2080002382, 235576710 },
    X{ 746273941, 131364118 },     X{ 1362713990, 307518467 },
    X{ -40909559, 489054954 },     X{ 1542723221, 278477958 },
    X{ -1500579184, 342323111 },   X{ -1582877898, 508730486 },
    X{ 1939066413, 104760045 },    X{ 1448076412, 7518756 },
    X{ 623297840, 400236131 },     X{ 907453588, 22536882 },
    X{ -344707023, 244969127 },    X{ 2051682947, 122684066 },
    X{ -1229266218, 235596861 },   X{ 1346399555, 235318506 },
    X{ 1890368057, 15629626 },     X{ -1146489684, 482661680 },
    X{ 498970576, 255141532 },     X{ -1018294377, 254528317 },
    X{ 1834084637, 522448373 },    X{ -387504286, 492367403 },
    X{ -1787765673, 37698862 },    X{ -1461476520, 3740318 },
    X{ -1254116433, 42525406 },    X{ -2098170326, 254291074 },
    X{ 1072214591, 436109877 },    X{ 1991696910, 47500127 },
    X{ -1432189233, 211838503 },   X{ -1442951782, 205312392 },
    X{ -1106095412, 48517532 },    X{ 22660718, 390984368 },
    X{ 524281292, 267221139 },     X{ -1845226176, 204863180 },
    X{ 1963748931, 112017517 },    X{ -1710480955, 126835037 },
    X{ -420176568, 522472489 },    X{ -612194488, 132336312 },
    X{ -637324919, 507254976 },    X{ -1030018720, 27761662 },
    X{ -24886530, 177605189 },     X{ -1089856883, 483805709 },
    X{ -1934831872, 89701473 },    X{ 382213120, 101449642 },
    X{ -1521945565, 294256282 },   X{ -1232822099, 534055331 },
    X{ -770519155, 267690300 },    X{ -1707734987, 205892118 },
    X{ 178334811, 267340822 },     X{ -350504510, 487003117 },
    X{ -1116622204, 433564342 },   X{ -68104151, 522258599 },
    X{ -1506138012, 93534962 },    X{ -358740389, 407747717 },
    X{ -889173447, 529082332 },    X{ 2027514893, 395796846 },
    X{ -1263245053, 295594250 },   X{ 1437129515, 500475907 },
    X{ 1397161202, 300553572 },    X{ -1059164606, 318641117 },
    X{ 1281601804, 462491965 },    X{ 830706174, 72502412 },
    X{ 1109825191, 239962806 },    X{ 1185777874, 43841869 },
    X{ -1691461857, 251678844 },   X{ -479580480, 517061579 },
    X{ 437068553, 426769711 },     X{ 2018483490, 491830982 },
    X{ -1737809146, 454161300 },   X{ -2058679811, 95518128 },
    X{ -88094296, 442916112 },     X{ 795531819, 434968401 },
    X{ 1409941612, 417064365 },    X{ -1896826697, 202677161 },
    X{ 1102776187, 332705169 },    X{ -977757158, 396349074 },
    X{ 1192502348, 488089383 },    X{ 162289698, 132333848 },
    X{ 194183384, 303638860 },     X{ 1616859133, 79182063 },
    X{ 1710909095, 526590344 },    X{ 1786512988, 224547476 },
    X{ 743844186, 459275474 },     X{ -1228580555, 490517242 },
    X{ -835147179, 249130647 },    X{ 1339384881, 20588815 },
    X{ 1255855826, 137700074 },    X{ -15109745, 367544686 },
    X{ -1313283925, 123784603 },   X{ 160536435, 356117842 },
    X{ 77785876, 376243261 },      X{ 1411345322, 269687277 },
    X{ 295559031, 236363511 },     X{ -1372818698, 214966837 },
    X{ -147095249, 450035622 },    X{ 763043319, 232135063 },
    X{ 1141743120, 492665447 },    X{ -985544832, 15654553 },
    X{ 1025146880, 355888219 },    X{ 2112316569, 142292453 },
    X{ -1683908498, 8597831 },     X{ 1667184629, 22509059 },
    X{ -535306318, 271756997 },    X{ 1450129185, 9459290 },
    X{ -977277070, 137024272 },    X{ -1602589172, 460952731 },
    X{ 41291348, 254439706 },      X{ -851388363, 504023908 },
    X{ -585897849, 300170631 },    X{ 34456730, 457648097 },
    X{ -249778292, 444994829 },    X{ 253336365, 355706363 },
    X{ 319156688, 516510617 },     X{ 1779211472, 289721227 },
    X{ 561976658, 299963917 },     X{ -336816944, 193696412 },
    X{ 694958124, 155142944 },     X{ -255582935, 338798470 },
    X{ -490503272, 204314813 },    X{ -841981343, 26163782 },
    X{ -1640956486, 7698609 },     X{ -1912646784, 98113337 },
    X{ -1721913609, 325212669 },   X{ -33461311, 319859165 },
    X{ 792102754, 511046 },        X{ -1049980753, 155841439 },
    X{ -1424096078, 1891814 },     X{ 520435069, 463093127 },
    X{ 129882717, 341665161 },     X{ 80802150, 510649656 },
    X{ -144464195, 413718426 },    X{ 937872305, 394707762 },
    X{ -795090295, 287549574 },    X{ -1515783054, 485482128 },
    X{ -1514436799, 387463837 },   X{ 1306087628, 499930981 },
    X{ -115517554, 266309435 },    X{ 41082427, 258935155 },
    X{ -1369160845, 375523642 },   X{ 1398174633, 357053667 },
    X{ 2029419962, 456055852 },    X{ -808815043, 316561270 },
    X{ 1132496869, 463898341 },    X{ 120311771, 485273195 },
    X{ 292887978, 56528975 },      X{ -1435333035, 531344745 },
    X{ 476255486, 283436476 },     X{ 1096971469, 306642308 },
    X{ -1045594748, 356670089 },   X{ -241920442, 412631285 },
    X{ 1401348312, 36887795 },     X{ 846877050, 47175104 },
    X{ -774386367, 399665752 },    X{ 293559024, 63162905 },
    X{ 1647997704, 532841799 },    X{ -1250949434, 497102179 },
    X{ 1013747108, 344532755 },    X{ -983871697, 471696935 },
    X{ -1669952318, 520525352 },   X{ 584185668, 1757397 },
    X{ -1478337704, 406519420 },   X{ 437808926, 89121386 },
    X{ 1967109526, 440936834 },    X{ 1101304635, 526509206 },
    X{ -494077575, 235410581 },    X{ -1744956552, 67149223 },
    X{ -668028656, 192347208 },    X{ -1940193177, 476259633 },
    X{ 556236764, 290694085 },     X{ -1019083596, 507007163 },
    X{ -145062323, 360506473 },    X{ 1894805112, 12434204 },
    X{ -1733480812, 23147710 },    X{ 1963542541, 271215160 },
    X{ 1590211080, 439796576 },    X{ 1836762911, 249108524 },
    X{ -1474292830, 345185137 },   X{ -835263671, 145609403 },
    X{ -1439717266, 224550867 },   X{ -1117954056, 301988311 },
    X{ -314205758, 292832267 },    X{ 361673507, 503693088 },
    X{ -780914265, 500728130 },    X{ 1889859380, 212131032 },
    X{ -1016096850, 374591353 },   X{ 1794576981, 191920970 },
    X{ 1709892996, 142266329 },    X{ -796335842, 443022428 },
    X{ 249474832, 535535315 },     X{ 822941827, 436915854 },
    X{ 1354448609, 188411651 },    X{ -753698851, 511426941 },
    X{ -190645870, 114644134 },    X{ -2012972165, 126962442 },
    X{ -1211100783, 426537534 },   X{ -1114104017, 46657378 },
    X{ -487541132, 123408400 },    X{ 2113073001, 457632770 },
    X{ -1456695137, 5558241 },     X{ 72555277, 388058671 },
    X{ -1590753797, 257762090 },   X{ 431940252, 263798169 },
    X{ 772557054, 241439872 },     X{ -426898440, 430997964 },
    X{ 840237192, 74866239 },      X{ -244056613, 448245722 },
    X{ 859507487, 428015061 },     X{ -1118637316, 524969751 },
    X{ -1190955688, 201817482 },   X{ 149845942, 493833311 },
    X{ -334182865, 416469525 },    X{ -427335541, 346059531}
  };

CONST
  power16 = T{ (* power16[i] = x^(i*2^16) MOD P *)
    X{ 0, MIN_INT },               X{ -1567899632, 294886881 },
    X{ 568631169, 362347968 },     X{ -114783263, 243464157 },
    X{ -714197785, 358411499 },    X{ -1570371506, 484745442 },
    X{ -1939465737, 262949375 },   X{ -1954958383, 385053630 },
    X{ -1203584496, 152959048 },   X{ -448326570, 7051940 },
    X{ 2027132716, 338161520 },    X{ 383077265, 267801222 },
    X{ 906232167, 469458163 },     X{ 839978444, 281761375 },
    X{ 615937270, 158150155 },     X{ -1572743054, 154124343 },
    X{ -1529528352, 477536499 },   X{ -527524695, 182699293 },
    X{ 1263751590, 159020045 },    X{ 664894937, 296678928 },
    X{ 996120108, 84718346 },      X{ -895538845, 488640679 },
    X{ 1364733437, 328728729 },    X{ -817632917, 354838268 },
    X{ 1378464068, 58864553 },     X{ 1514761523, 358158744 },
    X{ -1889967186, 228585120 },   X{ -283953129, 10562543 },
    X{ -1025808620, 234525559 },   X{ -1210675430, 52918345 },
    X{ -819132486, 346166288 },    X{ -340155351, 209072043 },
    X{ -1961175645, 57615189 },    X{ -1974520473, 381671254 },
    X{ -1015907407, 279854312 },   X{ 1185573414, 510338396 },
    X{ -1359439513, 63217651 },    X{ 1128439227, 13384045 },
    X{ 323191676, 447933119 },     X{ 2049939046, 516436701 },
    X{ 489038815, 126304509 },     X{ 1763797904, 233637184 },
    X{ 2144742575, 352295230 },    X{ 608675317, 50945485 },
    X{ -878381163, 66931145 },     X{ -1067651643, 326136341 },
    X{ -345447664, 239461950 },    X{ 1636870761, 519063558 },
    X{ -128218836, 340321784 },    X{ 769927390, 462364699 },
    X{ -1029826769, 353416590 },   X{ 232540007, 163597721 },
    X{ -872725120, 386430266 },    X{ -1320793906, 40072319 },
    X{ -2135675994, 256450140 },   X{ 1205427873, 508089546 },
    X{ 1875975568, 456571924 },    X{ 1078942089, 63482466 },
    X{ -109600111, 529578043 },    X{ -1686607223, 407987567 },
    X{ 1254086629, 380442184 },    X{ 1333734526, 1836091 },
    X{ -598373038, 384125632 },    X{ -1675703001, 68370705 },
    X{ -1639055057, 156955950 },   X{ -74526113, 475288569 },
    X{ 1010375985, 314503638 },    X{ 1411374627, 183436333 },
    X{ -531038029, 502046798 },    X{ -1062626054, 248819981 },
    X{ 15959017, 466303354 },      X{ 145962297, 127055429 },
    X{ -279574801, 392285150 },    X{ -1505652182, 73628295 },
    X{ 1579538903, 69259098 },     X{ 745890213, 310955105 },
    X{ -1949306111, 34195052 },    X{ -1591869649, 223908207 },
    X{ 721834126, 136038378 },     X{ -1873318756, 64437831 },
    X{ -1230383180, 384586523 },   X{ 1567264225, 87503796 },
    X{ -1602523543, 98966152 },    X{ 1655174871, 427135499 },
    X{ 1571615415, 179207612 },    X{ 1808520173, 476014812 },
    X{ -1039182112, 392665230 },   X{ 326877215, 395331479 },
    X{ 1925230038, 331920632 },    X{ -923609335, 298349082 },
    X{ -433437834, 182219877 },    X{ -1912169332, 440670606 },
    X{ -1906294962, 507911746 },   X{ -308180274, 449873910 },
    X{ -418323059, 50705223 },     X{ -377964883, 87863427 },
    X{ -621791746, 86895362 },     X{ -755839719, 16614841 },
    X{ 1011850791, 314031773 },    X{ 1062416546, 321379523 },
    X{ 2029907126, 168281415 },    X{ -563043312, 249241541 },
    X{ -587642401, 8144863 },      X{ -1631335026, 453631731 },
    X{ 958866894, 411932781 },     X{ -1949095621, 278333487 },
    X{ 335964047, 93925354 },      X{ -1918487164, 42924064 },
    X{ 1621558129, 24577595 },     X{ 62502947, 267696162 },
    X{ 1648076400, 380636235 },    X{ -796688859, 286503872 },
    X{ 1653298692, 476162902 },    X{ 1393507780, 462456937 },
    X{ -794211675, 49262805 },     X{ -439815809, 322499951 },
    X{ -1158869471, 49541742 },    X{ -1717122657, 409287017 },
    X{ 1306113411, 70367532 },     X{ 1707279735, 495393041 },
    X{ -664804243, 146598960 },    X{ 837021045, 121113125 },
    X{ 1549353979, 168164791 },    X{ 679491019, 291036556 },
    X{ 1304360064, 278439000 },    X{ 628707368, 1531811 },
    X{ -1958743309, 234292495 },   X{ -233530516, 441165982 },
    X{ 1405855824, 385495375 },    X{ -1409283893, 176929904 },
    X{ -1354190778, 518137549 },   X{ 2003150103, 307782160 },
    X{ -908240154, 253770652 },    X{ 2116520838, 173577787 },
    X{ -261463148, 224759837 },    X{ 498881131, 533320720 },
    X{ 593849415, 183162694 },     X{ 1113278332, 99150646 },
    X{ 1020653419, 435815184 },    X{ 1931770323, 419883664 },
    X{ -64676832, 530117738 },     X{ -603162000, 203872652 },
    X{ 1864488667, 212325378 },    X{ -153814907, 95662406 },
    X{ 809565493, 366537745 },     X{ -480959945, 149292567 },
    X{ -866668920, 436447185 },    X{ 624241039, 301678611 },
    X{ 1623000506, 405894445 },    X{ 256889637, 79210067 },
    X{ 1408347251, 348707271 },    X{ 100371876, 522097007 },
    X{ 11758722, 353765931 },      X{ 873674486, 343301652 },
    X{ 1735757295, 203703158 },    X{ -1059348374, 184484065 },
    X{ 230547522, 329537425 },     X{ 1345380029, 42771243 },
    X{ -1848157711, 114522168 },   X{ -1123659126, 465055128 },
    X{ 1044460118, 145936756 },    X{ -299861943, 95530134 },
    X{ -1046811188, 439764859 },   X{ -535952216, 210410423 },
    X{ -638195303, 67745881 },     X{ 1139572389, 479036252 },
    X{ -801419683, 368549267 },    X{ -2108199495, 218364466 },
    X{ -731930181, 267628820 },    X{ 1642922203, 171400409 },
    X{ -467181125, 248927251 },    X{ -1061154016, 281853347 },
    X{ -1004314584, 130708169 },   X{ -51936627, 460532769 },
    X{ -1138793292, 292567259 },   X{ 2060152647, 463545294 },
    X{ 742773172, 534780575 },     X{ 1056899665, 151212272 },
    X{ -1392627297, 456675899 },   X{ 1434823454, 186936626 },
    X{ 296890418, 293934970 },     X{ -1684835675, 455644582 },
    X{ 183991425, 205482512 },     X{ -1890080192, 450000207 },
    X{ 1615243788, 249972821 },    X{ -1312254197, 3917897 },
    X{ 953312061, 5931134 },       X{ -21265849, 152722247 },
    X{ -2118214003, 201557149 },   X{ -1768658192, 354959752 },
    X{ 706991448, 536282075 },     X{ 894311130, 119912240 },
    X{ -1743990809, 47058894 },    X{ -968852140, 292576 },
    X{ -1363762719, 222678664 },   X{ -992950262, 389662511 },
    X{ -523396314, 354402377 },    X{ -1020360851, 192920532 },
    X{ 1939292062, 20281443 },     X{ 711730764, 395885920 },
    X{ 741118683, 225051622 },     X{ -79236678, 57785847 },
    X{ -593488906, 92499355 },     X{ 1543052343, 239742936 },
    X{ -1747286963, 167172447 },   X{ 444112784, 17837811 },
    X{ -182481550, 127046263 },    X{ -51672225, 51000687 },
    X{ 558603647, 437083010 },     X{ 1584945700, 25889449 },
    X{ 1791972543, 42497128 },     X{ -1902924136, 288760274 },
    X{ -978584720, 286864447 },    X{ 1871584259, 467303938 },
    X{ -640455127, 100613399 },    X{ -54960750, 150843885 },
    X{ -803199051, 376799588 },    X{ 1814971029, 157967026 },
    X{ 1325333158, 500826377 },    X{ -866787111, 375385567 },
    X{ -93277656, 360027683 },     X{ -970091540, 355613771 },
    X{ -891015539, 77544971 },     X{ -1044762860, 4497377 },
    X{ 1417818749, 140295696 },    X{ 560218457, 224128045 },
    X{ 2098804855, 244617152 },    X{ 1524565775, 20812417 },
    X{ -481179886, 106363909 },    X{ -450086417, 172414084 },
    X{ -498107279, 56099842 },     X{ 738980023, 528431509 },
    X{ -313453891, 345861993 },    X{ -1616337141, 333250310 },
    X{ 177580429, 155655725 },     X{ 159537200, 211021552 },
    X{ 1534967243, 247708853 },    X{ -900850195, 530337543 },
    X{ 851534134, 530478040 },     X{ 723971805, 132956808 },
    X{ -1038777150, 469591075 },   X{ -1904015403, 197719336 },
    X{ 1587857101, 409849098 },    X{ 1174927476, 121718416 },
    X{ -1138486870, 390101289 },   X{ -1199553202, 39720099 },
    X{ -1351955296, 251463944 },   X{ 1800605150, 527958657 },
    X{ 412933259, 448480020 },     X{ 1091585535, 75693767 },
    X{ 772738984, 247714767 },     X{ 1521603519, 409933166 },
    X{ -1173086599, 57000853 },    X{ -431875822, 191936722 },
    X{ -522240412, 12345203 },     X{ -1609514443, 90586859}
  };

CONST
  power24 = T{ (* power24[i] = x^(i*2^24) MOD P *)
    X{ 0, MIN_INT },               X{ 1025676958, 392019518 },
    X{ -389184262, 499926821 },    X{ 1954619554, 510357858 },
    X{ 848423582, 362296893 },     X{ 1036060047, 422834256 },
    X{ -1344613542, 509635336 },   X{ -617685560, 61119924 },
    X{ 955630439, 153105548 },     X{ -826963727, 408489249 },
    X{ -1650620779, 305466494 },   X{ -2010138452, 194593368 },
    X{ 1956335766, 480498900 },    X{ -1114233300, 55156199 },
    X{ -116805579, 179128249 },    X{ 1087603194, 415640578 },
    X{ -578361098, 224125824 },    X{ 940968450, 245614316 },
    X{ 400959844, 472905715 },     X{ -179135644, 73419283 },
    X{ 2053222973, 493417149 },    X{ 279604750, 382710252 },
    X{ -1917158171, 288997962 },   X{ -221308028, 153656002 },
    X{ -1369984539, 163384924 },   X{ -2123977226, 222908023 },
    X{ -186605591, 84340898 },     X{ -980425389, 97989098 },
    X{ 1515413873, 351860438 },    X{ 328411943, 216370729 },
    X{ -1193316886, 386771706 },   X{ 663438765, 230228077 },
    X{ -414929369, 90182584 },     X{ 1797533776, 406093161 },
    X{ 662704391, 333410355 },     X{ -1809793413, 438116550 },
    X{ -421017597, 177112845 },    X{ 351409943, 165259839 },
    X{ 1956632259, 66433428 },     X{ 1539424402, 157272366 },
    X{ 1931722430, 62757991 },     X{ -1913932174, 119082512 },
    X{ 338854799, 20231558 },      X{ -2131154656, 514660876 },
    X{ 272210747, 478389166 },     X{ 1201348211, 2905887 },
    X{ 232987159, 180573004 },     X{ 8298714, 227132493 },
    X{ 1641573194, 242039763 },    X{ -1958265854, 205931196 },
    X{ -1194562585, 109555250 },   X{ 104274193, 355324002 },
    X{ 383301940, 204033033 },     X{ -1065740863, 455794406 },
    X{ 1042118219, 524680243 },    X{ -2048108847, 357108410 },
    X{ -434985340, 121063262 },    X{ -1908186377, 402774934 },
    X{ 1628142789, 352408963 },    X{ 245240617, 20273124 },
    X{ 1951510682, 176077115 },    X{ -568865080, 461788454 },
    X{ 1492222227, 13919466 },     X{ 1265272, 312701741 },
    X{ 422471513, 519072785 },     X{ -96795729, 509652040 },
    X{ -1220906650, 506839945 },   X{ -2143738266, 287801731 },
    X{ -817581232, 2138236 },      X{ 307309761, 144780266 },
    X{ 744820470, 14587061 },      X{ -1938943117, 364596782 },
    X{ 1148166905, 496927310 },    X{ 2802381, 455487703 },
    X{ -298007813, 196513373 },    X{ 1296952196, 166240888 },
    X{ 236302757, 83966162 },      X{ -486648890, 295141560 },
    X{ -879068201, 261300159 },    X{ -2058415005, 414639331 },
    X{ -881344943, 376907216 },    X{ 1280446177, 83986596 },
    X{ 1033672976, 325513185 },    X{ -1768189132, 203203939 },
    X{ 323182883, 349486287 },     X{ -584123424, 431317906 },
    X{ -1946091841, 510689209 },   X{ -680625181, 508466593 },
    X{ -1481853674, 66165228 },    X{ -381462418, 329107507 },
    X{ 1098127566, 255722027 },    X{ 1783486129, 519876295 },
    X{ -2034309784, 141081748 },   X{ 969992319, 318586263 },
    X{ -899392893, 167739864 },    X{ -1107634046, 428986195 },
    X{ 1016799619, 1320179 },      X{ -715967150, 173612793 },
    X{ 1012223693, 187725780 },    X{ 445435359, 266020661 },
    X{ 1177182560, 224535464 },    X{ -142639087, 314968532 },
    X{ 328655396, 103774829 },     X{ -1635792828, 301875998 },
    X{ -1083603876, 438911584 },   X{ 224124582, 504418938 },
    X{ -1405163019, 345122157 },   X{ -1217808833, 253757715 },
    X{ -441136005, 279367758 },    X{ -488498492, 29286635 },
    X{ 847799885, 352448192 },     X{ 1247853037, 430539098 },
    X{ -2119575777, 181502409 },   X{ 534895569, 124178822 },
    X{ 1185485601, 165182879 },    X{ 407600186, 119967138 },
    X{ -1914243612, 317817613 },   X{ 630443473, 28984012 },
    X{ -1453053852, 247193561 },   X{ -780928505, 77744923 },
    X{ 1918773969, 372395392 },    X{ 2003008156, 419251976 },
    X{ -310308587, 459258613 },    X{ 34299939, 536068595 },
    X{ -1095875835, 92770966 },    X{ -83642988, 524870707 },
    X{ -521805041, 355304830 },    X{ 93685060, 475070415 },
    X{ 394502188, 475227367 },     X{ 1176732470, 183319464 },
    X{ 2108059316, 434255370 },    X{ -1186272671, 508199722 },
    X{ 1808599205, 111235938 },    X{ 201966247, 21523729 },
    X{ -572308880, 5118199 },      X{ 1786397554, 504107349 },
    X{ 80987436, 148913249 },      X{ 1692454143, 409741485 },
    X{ -1699782205, 404644050 },   X{ 164990334, 305323500 },
    X{ -953861029, 472436092 },    X{ -1367108560, 242632832 },
    X{ 1325649259, 343800592 },    X{ -102283904, 341255044 },
    X{ 60455617, 196732691 },      X{ 881630428, 361322809 },
    X{ -1334479840, 381765403 },   X{ -1648357822, 1024891 },
    X{ 110507177, 84264710 },      X{ 1818531983, 192185641 },
    X{ -550886461, 344264124 },    X{ -835045152, 66762525 },
    X{ 879158546, 427845879 },     X{ 1983836234, 233918287 },
    X{ -1911212804, 19274418 },    X{ -807129490, 50480182 },
    X{ 1638037375, 369729787 },    X{ 886834834, 217848943 },
    X{ 567813926, 492886512 },     X{ 895892998, 512097805 },
    X{ -1966853372, 285616608 },   X{ 694273333, 399473241 },
    X{ 331892859, 248748020 },     X{ 435560063, 15631256 },
    X{ -1583486610, 7128853 },     X{ -166058498, 62012943 },
    X{ 1052251564, 250304644 },    X{ -1053324862, 33081239 },
    X{ -2918518, 207884965 },      X{ 518991015, 236884187 },
    X{ -1684171207, 66660785 },    X{ -443165728, 429576979 },
    X{ 217475293, 464679952 },     X{ -784267634, 248825454 },
    X{ -252028882, 266476649 },    X{ 1080677286, 181196219 },
    X{ 1666837019, 142087113 },    X{ -237447391, 162374390 },
    X{ 2100600904, 519129542 },    X{ -1420480257, 131759634 },
    X{ 168600263, 381940552 },     X{ 98583255, 236144394 },
    X{ 521283313, 416282972 },     X{ -1599922528, 106438756 },
    X{ -92486081, 58370898 },      X{ 916688289, 10750722 },
    X{ 1825973796, 298818074 },    X{ 293320254, 240378794 },
    X{ -1014546125, 186805674 },   X{ -232400835, 381635475 },
    X{ -1126931826, 345787789 },   X{ -1658561051, 189612860 },
    X{ 1261153146, 51332782 },     X{ 1888575208, 254348830 },
    X{ 1655823559, 469753110 },    X{ 1785410539, 534513582 },
    X{ -1764575369, 355533916 },   X{ -1659636885, 519469519 },
    X{ -690386035, 45754215 },     X{ 1803847717, 187082998 },
    X{ -896352539, 482150851 },    X{ 90344993, 473642184 },
    X{ -2113258458, 316444623 },   X{ 1585850713, 492717785 },
    X{ -1475031118, 520314994 },   X{ -860240030, 436134851 },
    X{ 457623487, 286239811 },     X{ -1100924567, 302230858 },
    X{ 1686475437, 422909192 },    X{ -613050027, 425455728 },
    X{ -1818935704, 202959143 },   X{ -1935032211, 7991178 },
    X{ 1087973111, 299981990 },    X{ 1355837449, 82419730 },
    X{ -1246247823, 460179142 },   X{ -622796352, 440409131 },
    X{ 1913854855, 355146011 },    X{ 319621660, 413989936 },
    X{ -1485035480, 393071740 },   X{ 1944217270, 157417378 },
    X{ 963969155, 481958750 },     X{ -1668413329, 423711551 },
    X{ -1261029261, 490187077 },   X{ 1336659642, 486684942 },
    X{ 275690888, 334347972 },     X{ 1904903434, 184728229 },
    X{ 1481304643, 215289928 },    X{ -561551198, 520394962 },
    X{ -1442996290, 23174940 },    X{ 859649575, 303886107 },
    X{ 861000290, 359618536 },     X{ 319070980, 245648249 },
    X{ -1370130170, 54332941 },    X{ -1032137567, 188808633 },
    X{ 1580206959, 311390099 },    X{ 801297727, 195545264 },
    X{ -1378919471, 451426685 },   X{ -1029066185, 145335539 },
    X{ 1877911799, 339519663 },    X{ 2013917064, 439251451 },
    X{ -1148400771, 57121386 },    X{ 1892190551, 236299958 },
    X{ -515096133, 125620370 },    X{ 73210628, 252081338 },
    X{ 257802669, 417814762 },     X{ -1499904487, 169359427 },
    X{ -1349238847, 132808390 },   X{ 61392070, 123979478 },
    X{ 1603952830, 39011486 },     X{ 2000379798, 20448897 },
    X{ -1293844821, 52683744 },    X{ 277061296, 181808366 },
    X{ -74276183, 176511742 },     X{ -1604178001, 40043168 },
    X{ 1372174866, 5613001 },      X{ 537710964, 72055391}
  };

END PolyBasis.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
