<HTML>
<HEAD>
<TITLE>SRC Modula-3: float/src/Common/DragonInt.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>float/src/Common/DragonInt.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>

INTERFACE <interface><A HREF="DragonInt.m3">DragonInt</A></interface>;
</PRE> Internal computations of Dragon require the use of bignums.
   Also, the fraction of a floating-point number can occupy more bits
   than there are in a Word.T.  We use an ad-hoc implementation of
   bignums, because only few of the arithmetic operations are needed,
   and only positive numbers are needed.
<P>
   Except for Zero and One, it is an unchecked runtime error to pass
   a DragonInt.T, x, to a method of any DragonInt.Session other than
   the one that returned x.


<P><PRE>TYPE
  <A HREF="DragonInt.m3#Session">Session</A> &lt;: REFANY;

PROCEDURE <A HREF="DragonInt.m3#NewSession">NewSession</A> (): Session;
</PRE><BLOCKQUOTE><EM> allocates, initializes, and returns a fresh session. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="DragonInt.m3#EndSession">EndSession</A> (s: Session);
</PRE><BLOCKQUOTE><EM> called at the end of a session for statistics gathering. </EM></BLOCKQUOTE><PRE>

TYPE (*OPAQUE*)
  T = RECORD s, w: INTEGER; END;

CONST
  Zero = T {0, 0};
  One  = T {1, 1};

PROCEDURE <A HREF="DragonInt.m3#New">New</A> (s: Session;  a, b: INTEGER): T;
</PRE><BLOCKQUOTE><EM> returns a T representing the 64-bit value:
      (a &amp; 16_ffffffff)&lt;&lt;32 + (b &amp; 16_ffffffff) </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="DragonInt.m3#copy">copy</A> (s: Session;  READONLY a: T): T;
</PRE><BLOCKQUOTE><EM> returns a copy of a </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="DragonInt.m3#add">add</A> (s: Session;  READONLY a,b: T): T;
</PRE><BLOCKQUOTE><EM> returns the sum of a and b </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="DragonInt.m3#diff">diff</A> (s: Session;  READONLY a,b: T): T;
</PRE><BLOCKQUOTE><EM> returns a - b; b is assumes a &gt;= b </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="DragonInt.m3#compare">compare</A> (s: Session;  READONLY a, b: T): [-1..1];
</PRE><BLOCKQUOTE><EM> returns -1, 0, or 1 when a &lt; b, a = b, or a &gt; b </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="DragonInt.m3#max">max</A> (s: Session;  READONLY a, b: T): T;
</PRE><BLOCKQUOTE><EM> returns the biggest of a and b </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="DragonInt.m3#shift">shift</A> (s: Session;  READONLY a: T; n: INTEGER): T;
</PRE><BLOCKQUOTE><EM> returns a shifted n bits, to the left for n&gt;0, to the right for n&lt;0
    == returns (a * 2^n)  </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="DragonInt.m3#times2">times2</A> (s: Session;  READONLY a: T): T;
</PRE><BLOCKQUOTE><EM> returns 2 * a </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="DragonInt.m3#timesTenInPlace">timesTenInPlace</A> (s: Session;  VAR a: T): T;
</PRE><BLOCKQUOTE><EM> modifies a to be 10 * a and returns it </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="DragonInt.m3#divideTen">divideTen</A> (s: Session;  READONLY a: T): T;
</PRE><BLOCKQUOTE><EM> returns a / 10 </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="DragonInt.m3#divmod">divmod</A> (s: Session;  READONLY a, b : T; VAR d: INTEGER): T;
</PRE><BLOCKQUOTE><EM> assume that a = d * b + res, with d a number between 0 and 9;
   computes d and returns res. </EM></BLOCKQUOTE><PRE>
</PRE>----- debugging stats ---
<PRE>VAR
  maxHighWater := 0;
  highWater    : ARRAY [0..100] OF INTEGER;
  allocates    : ARRAY [0..100] OF INTEGER;
  nSessions    := 0;
  nAllocates   := 0;

END DragonInt.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
