<HTML>
<HEAD>
<TITLE>SRC Modula-3: float/src/Common/Float.ig</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>float/src/Common/Float.ig</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> The generic interface <CODE>Float</CODE> provides access to the floating-point
   operations required or recommended by the IEEE floating-point
   standard.  Consult the standard to resolve any fine points in the
   specification of the procedures.  Non-IEEE implementations that
   have values similar to NaNs and infinities should explain how those
   values behave in an implementation guide. (NaN is an IEEE term
   whose informal meaning is ``not a number''.) 

<P><PRE>GENERIC INTERFACE <genericInterface>Float</genericInterface>(R);

IMPORT <A HREF="#x1">FloatMode</A>;

TYPE T = R.T;

PROCEDURE Scalb(x: T; n: INTEGER): T RAISES {FloatMode.Trap};
</PRE><BLOCKQUOTE><EM> Return $\hbox<CODE>x</CODE>\cdot 2^{\hbox<CODE>n</CODE>}$. </EM></BLOCKQUOTE><PRE>

PROCEDURE Logb(x: T): T RAISES {FloatMode.Trap};
</PRE><BLOCKQUOTE><EM> Return the exponent of <CODE>x</CODE>.  More precisely, return the unique
   integer $n$ such that the ratio $\hbox<CODE>ABS(x) / Base</CODE>^{n}$ is in
   the half-open interval <CODE>[1..Base)</CODE>, unless <CODE>x</CODE> is denormalized, in
   which case return the minimum exponent value for <CODE>T</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE ILogb(x: T): INTEGER;
</PRE><BLOCKQUOTE><EM> Like <CODE>Logb</CODE>, but returns an integer, never raises an exception, and
   always returns the $n$ such that $\hbox<CODE>ABS(x) / Base</CODE>^{n}$ is in
   the half-open interval <CODE>[1..Base)</CODE>, even for denormalized numbers.
   Special cases: it returns <CODE>FIRST(INTEGER)</CODE> when <CODE>x</CODE> = 0.0,
   <CODE>LAST(INTEGER)</CODE> when <CODE>x</CODE> is plus or minus infinity, and zero when
   <CODE>x</CODE> is NaN.  </EM></BLOCKQUOTE><PRE>

PROCEDURE NextAfter(x, y: T): T RAISES {FloatMode.Trap};
</PRE><BLOCKQUOTE><EM> Return the next representable neighbor of <CODE>x</CODE> in the direction
   towards <CODE>y</CODE>.  If <CODE>x = y</CODE>, return <CODE>x</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE CopySign(x, y: T): T;
</PRE><BLOCKQUOTE><EM> Return <CODE>x</CODE> with the sign of <CODE>y</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE Finite(x: T): BOOLEAN;
</PRE><BLOCKQUOTE><EM> Return <CODE>TRUE</CODE> if <CODE>x</CODE> is strictly between minus infinity and plus
   infinity.  This always returns <CODE>TRUE</CODE> on non-IEEE implementations.
   </EM></BLOCKQUOTE><PRE>

PROCEDURE IsNaN(x: T): BOOLEAN;
</PRE><BLOCKQUOTE><EM> Return <CODE>FALSE</CODE> if <CODE>x</CODE> represents a numerical (possibly
   infinite) value, and <CODE>TRUE</CODE> if <CODE>x</CODE> does not represent a
   numerical value.  For example, on IEEE implementations, returns
   <CODE>TRUE</CODE> if x is a NaN, <CODE>FALSE</CODE> otherwise. </EM></BLOCKQUOTE><PRE>
</PRE><P>
\index{NaN (not a number)}


<P>
<P><PRE>PROCEDURE Sign(x: T): [0..1];
</PRE><BLOCKQUOTE><EM> Return the sign bit <CODE>x</CODE>.  For non-IEEE implementations, this is
   the same as <CODE>ORD(x &gt;= 0)</CODE>; for IEEE implementations,
   <CODE>Sign(-0) = 1</CODE> and <CODE>Sign(+0) = 0</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE Differs(x, y: T): BOOLEAN;
</PRE><BLOCKQUOTE><EM> Return <CODE>(x &lt; y OR y &lt; x)</CODE>.  Thus, for IEEE implementations,
   <CODE>Differs(NaN,x)</CODE> is always <CODE>FALSE</CODE>; for non-IEEE implementations,
   <CODE>Differs(x,y)</CODE> is the same as <CODE>x # y</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE Unordered(x, y: T): BOOLEAN;
</PRE><BLOCKQUOTE><EM> Return <CODE>NOT (x &lt;= y OR y &lt;= x)</CODE>. Thus, for IEEE implementations,
   <CODE>Unordered(NaN, x)</CODE> is always <CODE>TRUE</CODE>; for non-IEEE implementations,
   <CODE>Unordered(x, y)</CODE> is always <CODE>FALSE</CODE>.
</EM></BLOCKQUOTE><PRE>

PROCEDURE Sqrt(x: T): T RAISES {FloatMode.Trap};
</PRE><BLOCKQUOTE><EM> Return the square root of <CODE>T</CODE>.  This must be correctly rounded if
   <CODE>FloatMode.IEEE</CODE> is <CODE>TRUE</CODE>. </EM></BLOCKQUOTE><PRE>

TYPE IEEEClass =
  {SignalingNaN, QuietNaN, Infinity, Normal, Denormal, Zero};

PROCEDURE Class(x: T): IEEEClass;
</PRE><BLOCKQUOTE><EM> Return the IEEE number class containing <CODE>x</CODE>.  On non-IEEE systems,
   the result will be <CODE>Normal</CODE> or <CODE>Zero</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE FromDecimal(
    sign: [0..1];
    READONLY digits: ARRAY OF [0..9];
    exp: INTEGER): T RAISES {FloatMode.Trap};
</PRE><BLOCKQUOTE><EM> Convert from floating-decimal to type <CODE>T</CODE>. </EM></BLOCKQUOTE><PRE>
</PRE> \index{floating-point!conversion from decimal}
   \index{decimal conversion!to floating-point}
<P>
   Let <CODE>F</CODE> denote the nonnegative, floating-decimal number
<P>
<PRE>
      digits[0] . digits[1] ... digits[LAST(digits)] * 10^exp
      = sum(i, digits[i] * 10^(exp - i))
</PRE>
   The result of <CODE>FromDecimal</CODE> is the number <CODE>(-1)^sign * F</CODE>, rounded
   to a value of type <CODE>T</CODE>.
<P>
   The procedure <CODE>FromDecimal</CODE> is a floating-point operation, just
   like <CODE>+</CODE> and <CODE>*</CODE>, in the sense that it rounds its ideal result
   correctly, observing the current rounding mode, and it sets flags
   and raises traps by the usual rules.  On IEEE implementations, it
   returns minus zero when <CODE>F</CODE> is sufficiently small and <CODE>sign=1</CODE>. 

<P><PRE>TYPE DecimalApprox = RECORD
    class: IEEEClass;
    sign: [0..1];
    len: [1..R.MaxSignifDigits];
    digits: ARRAY[0..R.MaxSignifDigits-1] OF [0..9];
    exp: INTEGER;
    errorSign: [-1..1]
  END;

PROCEDURE ToDecimal(x: T): DecimalApprox;
</PRE><BLOCKQUOTE><EM> Convert from type <CODE>T</CODE> to floating-decimal. </EM></BLOCKQUOTE><PRE>
</PRE> \index{floating-point!conversion to decimal}
   \index{decimal conversion!from floating-point}
<P>
   Let <CODE>D</CODE> denote <CODE>ToDecimal(x)</CODE>.  Then, <CODE>D.class = Class(x)</CODE> and
   <CODE>D.sign = Sign(x)</CODE>.  The other fields are defined only when
   <CODE>D.class</CODE> is either <CODE>Normal</CODE> or <CODE>Denormal</CODE>.  In those cases, the
   values <CODE>D.len</CODE>, <CODE>D.digits[0]</CODE> through <CODE>D.digits[D.len-1]</CODE>, and
   <CODE>D.exp</CODE> encode a floating-decimal number <CODE>F</CODE> with the property that
   <CODE>(-1)^D.sign * F</CODE> approximates <CODE>x</CODE> in a sense discussed below.  The
   encoding is such that
<P>
<PRE>
      F = digits[0] . digits[1] ... digits[len - 1]  *  10^exp
        = sum(i, digits[i] * 10^(exp - i))
</PRE>
   and
<P>
<PRE>
      ABS(x) = F * (1 + errorSign * epsilon)
</PRE>
   where <CODE>epsilon</CODE> is small and positive.  In particular, <CODE>D.errorSign</CODE>
   is <CODE>+1</CODE>, <CODE>0</CODE>, or <CODE>-1</CODE> according as <CODE>ABS(x)</CODE> is larger than, equal
   to, or smaller than <CODE>F</CODE>.
<P>
   The current rounding mode determines the sense in which the
   floating-decimal number <CODE>(-1)^sign * F</CODE> approximates <CODE>x</CODE>, but in a
   slightly subtle way.  Define the opposite of a directed rounding
   mode by reversing the direction, as follows:
<P>
<PRE>
           Opp(TowardPlusInfinity) := TowardMinusInfinity
          Opp(TowardMinusInfinity) := TowardPlusInfinity
                   Opp(TowardZero) := AwayFromZero
</PRE>
   Note that <CODE>AwayFromZero</CODE> isn't actually a rounding mode, but it is
   clear what it would mean if it were.  For all other rounding modes
   <CODE>M</CODE>, we define <CODE>Opp(M) = M</CODE>.  If the current rounding mode is <CODE>M</CODE>,
   the call <CODE>ToDecimal(x)</CODE> returns a floating-decimal number that
   <CODE>FromDecimal</CODE> would convert, under rounding mode <CODE>Opp(M)</CODE>, back to
   <CODE>x</CODE>.  Among all such numbers, the returned value has as few digits
   as possible.  This implies that both <CODE>D.digits[0]</CODE> and
   <CODE>D.digits[D.len-1]</CODE> are nonzero.  If there is a tie for having the
   fewest digits, the tying number closest to <CODE>x</CODE> wins.  If there is
   also a tie for being closest to <CODE>x</CODE>, it must be a two-way tie and
   the number whose last digit is even wins.
<P>
   Unlike <CODE>FromDecimal</CODE>, <CODE>ToDecimal</CODE> never sets a <CODE>FloatMode.Flag</CODE> and
   never raises <CODE>FloatMode.Trap</CODE>.
<P>
   The idea of converting to decimal by retaining just as many digits
   as are necessary to convert back to binary exactly was popularized
   by Guy L.~Steele Jr.\ and Jon L White~\cite{Steele}.  David M.~Gay
   pointed out the importance, in this context, of demanding that the
   conversion to binary handle mid-point cases by a known
   rule~\cite{Gay}.  For example, in IEEE double precision, the
   floating-decimal number <CODE>1e23</CODE> is precisely halfway between two
   adjacent floating-binary numbers.  If conversion to binary were
   allowed to go either way in such a mid-point case, conversion to
   decimal would have to avoid producing the simple number <CODE>1e23</CODE>,
   producing instead either <CODE>1.0000000000000001e23</CODE> or
   <CODE>9.999999999999999e22</CODE>.  We believe the idea of combining the
   Steele/White style of automatic precision control with directed
   rounding by using opposite rounding modes, as above, is new with
   Lyle Ramshaw. 

<P><PRE>END Float.
</PRE>
</inInterface>
<HR>
<A NAME="x1">interface FloatMode is in:
</A><UL>
<LI><A HREF="../DS3100/FloatMode.i3#0TOP0">float/src/DS3100/FloatMode.i3</A>
<LI><A HREF="../IEEE-default/FloatMode.i3#0TOP0">float/src/IEEE-default/FloatMode.i3</A>
<LI><A HREF="../IRIX5/FloatMode.i3#0TOP0">float/src/IRIX5/FloatMode.i3</A>
<LI><A HREF="../SOLsun/FloatMode.i3#0TOP0">float/src/SOLsun/FloatMode.i3</A>
<LI><A HREF="../SPARC/FloatMode.i3#0TOP0">float/src/SPARC/FloatMode.i3</A>
<LI><A HREF="../SUN386/FloatMode.i3#0TOP0">float/src/SUN386/FloatMode.i3</A>
<LI><A HREF="../VAX/FloatMode.i3#0TOP0">float/src/VAX/FloatMode.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
