<HTML>
<HEAD>
<TITLE>SRC Modula-3: float/src/DS3100/FloatMode.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>float/src/DS3100/FloatMode.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

UNSAFE MODULE <module><implements><A HREF="#x1">FloatMode</A></implements></module> (* FOR DS3100 *);
</PRE> NOTE: the following code makes some assumptions about threads:
<P>
   1) thread switching (via _setjmp/_longjmp) properly preserves the IEEE
      <CODE>sticky</CODE> and <CODE>trap enable</CODE> bits for each thread.
<P>
   2) when the signal for a float-point exception is actually delivered,
      we're running in the thread that caused the exception and
      that thread asked for the particular fault to be trapped.
      (i.e. signals are delivered quickly and thread switching doesn't
       doesn't cause floating-point exceptions)


<P><PRE>IMPORT <A HREF="#x2">FPU</A>, <A HREF="#x3">Usignal</A>, <A HREF="#x4">ThreadF</A>, <A HREF="../../../word/src/Word.i3">Word</A>, <A HREF="../../../runtime/src/common/RTMisc.i3">RTMisc</A>;

TYPE RM  = RoundingMode;
TYPE MRM = FPU.RoundingMode;

PROCEDURE <A NAME="SetRounding"><procedure>SetRounding</procedure></A>(md: RoundingMode) RAISES {Failure} =
  BEGIN
    CASE md OF
    | RM.TowardMinusInfinity =&gt; EVAL FPU.SetRounding (ORD (MRM.ToMinusInfinity));
    | RM.TowardPlusInfinity  =&gt; EVAL FPU.SetRounding (ORD (MRM.ToPlusInfinity));
    | RM.TowardZero          =&gt; EVAL FPU.SetRounding (ORD (MRM.ToZero));
    | RM.NearestElseEven     =&gt; EVAL FPU.SetRounding (ORD (MRM.ToNearest));
    ELSE RAISE Failure;
    END;
  END SetRounding;

PROCEDURE <A NAME="GetRounding"><procedure>GetRounding</procedure></A>(): RoundingMode =
  CONST Map = ARRAY MRM OF RM{ RM.NearestElseEven, RM.TowardZero,
                               RM.TowardPlusInfinity, RM.TowardMinusInfinity };
  VAR status := LOOPHOLE (FPU.GetStatus (),  FPU.ControlStatus);
  BEGIN
    RETURN Map [status.rounding_mode];
  END GetRounding;

PROCEDURE <A NAME="GetFlags"><procedure>GetFlags</procedure></A>(): SET OF Flag =
  VAR status := LOOPHOLE (FPU.GetStatus (),  FPU.ControlStatus);
  VAR state  := ThreadF.MyFPState ();
  BEGIN
    RETURN ExtractFlags (status, state^);
  END GetFlags;

PROCEDURE <A NAME="ExtractFlags"><procedure>ExtractFlags</procedure></A> (READONLY status: FPU.ControlStatus;
                        READONLY state: ThreadState): SET OF Flag =
  VAR flags  := NoFlags;
  BEGIN
    IF (state.behavior[Flag.Inexact] = Behavior.Ignore) THEN
      IF (state.sticky[Flag.Inexact]) THEN
        flags := flags + SET OF Flag{Flag.Inexact};
      END;
    ELSIF (status.se_inexact) THEN
      flags := flags + SET OF Flag{Flag.Inexact};
    END;

    IF (state.behavior[Flag.Underflow] = Behavior.Ignore) THEN
      IF (state.sticky[Flag.Underflow]) THEN
        flags := flags + SET OF Flag{Flag.Underflow};
      END;
    ELSIF (status.se_underflow) THEN
      flags := flags + SET OF Flag{Flag.Underflow};
    END;

    IF (state.behavior[Flag.Overflow] = Behavior.Ignore) THEN
      IF (state.sticky[Flag.Overflow]) THEN
        flags := flags + SET OF Flag{Flag.Overflow};
      END;
    ELSIF (status.se_overflow) THEN
      flags := flags + SET OF Flag{Flag.Overflow};
    END;

    IF (state.behavior[Flag.DivByZero] = Behavior.Ignore) THEN
      IF (state.sticky[Flag.DivByZero]) THEN
        flags := flags + SET OF Flag{Flag.DivByZero};
      END;
    ELSIF (status.se_divide0) THEN
      flags := flags + SET OF Flag{Flag.DivByZero};
    END;

    IF (state.behavior[Flag.Inexact] = Behavior.Ignore) THEN
      IF (state.sticky[Flag.Inexact]) THEN
        flags := flags + SET OF Flag{Flag.Invalid};
      END;
    ELSIF (status.se_invalid) THEN
      flags := flags + SET OF Flag{Flag.Invalid};
    END;

    IF (state.behavior[Flag.Inexact] = Behavior.Ignore) THEN
      IF (state.sticky[Flag.Inexact]) THEN
        flags := flags + SET OF Flag{Flag.Invalid};
      END;
    ELSIF (status.se_invalid) THEN
      flags := flags + SET OF Flag{Flag.Invalid};
    END;

    IF (state.sticky[Flag.IntOverflow]) THEN
      flags := flags + SET OF Flag{Flag.IntOverflow};
    END;

    IF (state.sticky[Flag.IntDivByZero]) THEN
      flags := flags + SET OF Flag{Flag.IntDivByZero};
    END;

    RETURN flags;
  END ExtractFlags;

PROCEDURE <A NAME="SetFlags"><procedure>SetFlags</procedure></A>(s: SET OF Flag): SET OF Flag =
  VAR status := LOOPHOLE (FPU.GetStatus (),  FPU.ControlStatus);
  VAR state  := ThreadF.MyFPState ();
  VAR flags  := ExtractFlags (status, state^);
  VAR new: FPU.ControlStatus;
  BEGIN
    (* set the FPU control register *)
    new := status;
    new.se_inexact   := (Flag.Inexact   IN s);
    new.se_underflow := (Flag.Underflow IN s);
    new.se_overflow  := (Flag.Overflow  IN s);
    new.se_divide0   := (Flag.DivByZero IN s);
    new.se_invalid   := (Flag.Invalid   IN s);
    EVAL FPU.SetStatus (LOOPHOLE (new, INTEGER));

    (* set the saved thread state *)
    FOR f := FIRST (Flag) TO LAST (Flag) DO
      state.sticky [f] := (f IN s);
    END;

    RETURN flags;
  END SetFlags;

PROCEDURE <A NAME="ClearFlag"><procedure>ClearFlag</procedure></A>(f: Flag) =
  VAR status := LOOPHOLE (FPU.GetStatus (),  FPU.ControlStatus);
  VAR state  := ThreadF.MyFPState ();
  BEGIN
    CASE f OF
    | Flag.Inexact      =&gt; status.se_inexact   := FALSE;
    | Flag.Underflow    =&gt; status.se_underflow := FALSE;
    | Flag.Overflow     =&gt; status.se_overflow  := FALSE;
    | Flag.DivByZero    =&gt; status.se_divide0   := FALSE;
    | Flag.Invalid      =&gt; status.se_invalid   := FALSE;
    | Flag.IntOverflow  =&gt; (* nop *)
    | Flag.IntDivByZero =&gt; (* nop *)
    ELSE
    END;
    EVAL FPU.SetStatus (LOOPHOLE (status, INTEGER));
    state.sticky [f] := FALSE;
  END ClearFlag;

TYPE
  BHMap = ARRAY Behavior OF BOOLEAN;
CONST
  AllowedBehavior = ARRAY Flag OF BHMap {
    (*  --- flag ---           Trap    SetFlag  Ignore  *)
    (* Invalid      *) BHMap { TRUE,   TRUE,    TRUE  },
    (* Inexact      *) BHMap { TRUE,   TRUE,    TRUE  },
    (* Overflow     *) BHMap { TRUE,   TRUE,    TRUE  },
    (* Underflow    *) BHMap { TRUE,   TRUE,    TRUE  },
    (* DivByZero    *) BHMap { TRUE,   TRUE,    TRUE  },
    (* IntOverflow  *) BHMap { FALSE,  FALSE,   TRUE  },
    (* IntDivByZero *) BHMap { TRUE,   FALSE,   FALSE }
  };

PROCEDURE <A NAME="SetBehavior"><procedure>SetBehavior</procedure></A>(f: Flag; b: Behavior) RAISES {Failure} =
  TYPE BH = Behavior;
  VAR status := LOOPHOLE (FPU.GetStatus (),  FPU.ControlStatus);
  VAR state  := ThreadF.MyFPState ();
  VAR old    := state.behavior [f];
  BEGIN
    IF (old = b) THEN RETURN END;
    IF NOT AllowedBehavior [f, b] THEN RAISE Failure END;
    state.behavior [f] := b;
    CASE f OF
    | Flag.Inexact =&gt;
        IF (old = BH.Ignore) THEN
          status.se_inexact := state.sticky[Flag.Inexact];
        END;
        CASE b OF
        | BH.Ignore  =&gt; state.sticky[Flag.Inexact] := status.se_inexact;
        | BH.SetFlag =&gt; status.en_inexact := FALSE;
        | BH.Trap    =&gt; status.en_inexact := TRUE;
        END;
    | Flag.Underflow =&gt;
        IF (old = BH.Ignore) THEN
          status.se_underflow := state.sticky[Flag.Underflow];
        END;
        CASE b OF
        | BH.Ignore  =&gt; state.sticky[Flag.Underflow] := status.se_underflow;
        | BH.SetFlag =&gt; status.en_underflow := FALSE;
        | BH.Trap    =&gt; status.en_underflow := TRUE;
        END;
    | Flag.Overflow =&gt;
        IF (old = BH.Ignore) THEN
          status.se_overflow := state.sticky[Flag.Overflow];
        END;
        CASE b OF
        | BH.Ignore  =&gt; state.sticky[Flag.Overflow] := status.se_overflow;
        | BH.SetFlag =&gt; status.en_overflow := FALSE;
        | BH.Trap    =&gt; status.en_overflow := TRUE;
        END;
    | Flag.DivByZero =&gt;
        IF (old = BH.Ignore) THEN
          status.se_divide0 := state.sticky[Flag.DivByZero];
        END;
        CASE b OF
        | BH.Ignore  =&gt; state.sticky[Flag.DivByZero] := status.se_divide0
        | BH.SetFlag =&gt; status.en_divide0 := FALSE;
        | BH.Trap    =&gt; status.en_divide0 := TRUE;
        END;
    | Flag.Invalid =&gt;
        IF (old = BH.Ignore) THEN
          status.se_invalid := state.sticky[Flag.Invalid];
        END;
        CASE b OF
        | BH.Ignore  =&gt; state.sticky[Flag.Invalid] := status.se_invalid;
        | BH.SetFlag =&gt; status.en_invalid := FALSE;
        | BH.Trap    =&gt; status.en_invalid := TRUE;
        END;
    | Flag.IntOverflow  =&gt; (* only Ignore is allowed =&gt; ok *)
    | Flag.IntDivByZero =&gt; (* only Trap is allowed =&gt; ok *)
    ELSE RAISE Failure;
    END;
    EVAL FPU.SetStatus (LOOPHOLE (status, INTEGER));
  END SetBehavior;

PROCEDURE <A NAME="GetBehavior"><procedure>GetBehavior</procedure></A>(f: Flag): Behavior =
  BEGIN
    RETURN ThreadF.MyFPState().behavior [f];
  END GetBehavior;
</PRE>------------------------------------------------- thread initialization ---

<P><PRE>CONST
  DefaultControl = FPU.ControlStatus {
     FPU.RoundingMode.ToNearest,
     FALSE, FALSE, FALSE, FALSE, FALSE, (* sticky bits *)
     FALSE, FALSE, FALSE, FALSE, FALSE, (* trap enable bits *)
     FALSE, FALSE, FALSE, FALSE, FALSE, (* exception bits *)
     FALSE,                             (* unimplemented exception *)
     0, FALSE, 0                        (* condition flag *)
  };

CONST
  DefaultState = ThreadState {
     ARRAY Flag OF Behavior { Behavior.SetFlag, .. },
     ARRAY Flag OF BOOLEAN { FALSE, .. }
  };

PROCEDURE <A NAME="InitThread"><procedure>InitThread</procedure></A> (VAR state: ThreadState) =
  BEGIN
    (* set the actual FPU control register *)
    EVAL FPU.SetStatus (LOOPHOLE (DefaultControl, INTEGER));

    (* initialize the saved thread state *)
    state := DefaultState;
    state.behavior [Flag.IntOverflow]  := Behavior.Ignore;
    state.behavior [Flag.IntDivByZero] := Behavior.Trap;
  END InitThread;
</PRE>----------------------------------------- floating-point fault handling ---

<P><PRE>VAR
  new_handler,
  old_FPE_handler,
  old_TRAP_handler : Usignal.struct_sigvec;

PROCEDURE <A NAME="InstallTraps"><procedure>InstallTraps</procedure></A> () =
  VAR i: INTEGER;
  BEGIN
    new_handler.sv_handler := LOOPHOLE (FPFaultHandler, Usignal.SignalHandler);
    new_handler.sv_mask    := Usignal.empty_sigset_t;
    new_handler.sv_flags   := 0;
    i := Usignal.sigvec (Usignal.SIGFPE, new_handler, old_FPE_handler);
    &lt;* ASSERT  i = 0 *&gt;
    i := Usignal.sigvec (Usignal.SIGTRAP, new_handler, old_TRAP_handler);
    &lt;* ASSERT  i = 0 *&gt;
  END InstallTraps;

PROCEDURE <A NAME="FPFaultHandler"><procedure>FPFaultHandler</procedure></A> (sig: INTEGER;  code: INTEGER;
                          scp: UNTRACED REF Usignal.struct_sigcontext)
     RAISES {Trap} =
  VAR flag: Flag; old_handler : Usignal.struct_sigvec; i: INTEGER;
  BEGIN
    IF sig = Usignal.SIGFPE AND code = 0 THEN
      (* floating point trap *)
      VAR
        status := LOOPHOLE (scp.sc_fpc_csr, FPU.ControlStatus);
      BEGIN
        (* inexact should be tested first, because other flags have
           precedence *)
        IF status.ex_inexact THEN   flag := Flag.Inexact; END;
        IF status.ex_underflow THEN flag := Flag.Underflow; END;
        IF status.ex_overflow THEN  flag := Flag.Overflow; END;
        IF status.ex_divide0 THEN   flag := Flag.DivByZero; END;
        IF status.ex_invalid THEN   flag := Flag.Invalid; END;

        status.ex_inexact := FALSE;
        status.ex_underflow := FALSE;
        status.ex_overflow := FALSE;
        status.ex_divide0 := FALSE;
        status.ex_invalid := FALSE;

        EVAL FPU.SetStatus (LOOPHOLE (status, INTEGER));

        (* enable the exception *)
        i := Usignal.sigsetmask (0);
        i := Word.And (i, Word.Not (Usignal.sigmask (Usignal.SIGFPE)));
        EVAL Usignal.sigsetmask (i);

        RAISE Trap (flag);
      END;

    ELSIF sig = Usignal.SIGTRAP AND code = Usignal.BRK_DIVZERO THEN
      i := Usignal.sigsetmask (0);
      i := Word.And (i, Word.Not (Usignal.sigmask (Usignal.SIGTRAP)));
      EVAL Usignal.sigsetmask (i);
      RAISE Trap (Flag.IntDivByZero);

    ELSIF sig = Usignal.SIGFPE THEN
      old_handler := old_FPE_handler;
    ELSIF sig = Usignal.SIGTRAP THEN
      old_handler := old_TRAP_handler;
    ELSE
      Die (&quot;unrecognized arithmetic trap!?&quot;);
    END;

    (* if we got here, the fault is unhandled =&gt; resignal to the old handler *)
    VAR p := old_handler.sv_handler; BEGIN
      IF (p = Usignal.SIG_IGN) THEN
        (* ignore *)
      ELSIF (p = Usignal.SIG_DFL) THEN
        (* default =&gt; crash *)
        Die (&quot;unhandled arithmetic trap&quot;);
      ELSE (* call the old handler *)
        p (sig, code, scp);
      END;
    END;
  END FPFaultHandler;

PROCEDURE <A NAME="Die"><procedure>Die</procedure></A> (msg: TEXT) =
  BEGIN
    RTMisc.FatalError (NIL, 0, msg);
    &lt;*ASSERT FALSE*&gt;
  END Die;

BEGIN
  InstallTraps ();
END FloatMode.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface FloatMode is in:
</A><UL>
<LI><A HREF="FloatMode.i3#0TOP0">float/src/DS3100/FloatMode.i3</A>
<LI><A HREF="../IEEE-default/FloatMode.i3#0TOP0">float/src/IEEE-default/FloatMode.i3</A>
<LI><A HREF="../IRIX5/FloatMode.i3#0TOP0">float/src/IRIX5/FloatMode.i3</A>
<LI><A HREF="../SOLsun/FloatMode.i3#0TOP0">float/src/SOLsun/FloatMode.i3</A>
<LI><A HREF="../SPARC/FloatMode.i3#0TOP0">float/src/SPARC/FloatMode.i3</A>
<LI><A HREF="../SUN386/FloatMode.i3#0TOP0">float/src/SUN386/FloatMode.i3</A>
<LI><A HREF="../VAX/FloatMode.i3#0TOP0">float/src/VAX/FloatMode.i3</A>
</UL>
<P>
<HR>
<A NAME="x2">interface FPU is in:
</A><UL>
<LI><A HREF="FPU.i3#0TOP0">float/src/DS3100/FPU.i3</A>
<LI><A HREF="../IEEE-default/FPU.i3#0TOP0">float/src/IEEE-default/FPU.i3</A>
<LI><A HREF="../IRIX5/FPU.i3#0TOP0">float/src/IRIX5/FPU.i3</A>
<LI><A HREF="../SOLsun/FPU.i3#0TOP0">float/src/SOLsun/FPU.i3</A>
<LI><A HREF="../SPARC/FPU.i3#0TOP0">float/src/SPARC/FPU.i3</A>
<LI><A HREF="../SUN386/FPU.i3#0TOP0">float/src/SUN386/FPU.i3</A>
<LI><A HREF="../VAX/FPU.i3#0TOP0">float/src/VAX/FPU.i3</A>
</UL>
<P>
<HR>
<A NAME="x3">interface Usignal is in:
</A><UL>
<LI><A HREF="../../../unix/src/aix-3-2/Usignal.i3#0TOP0">unix/src/aix-3-2/Usignal.i3</A>
<LI><A HREF="../../../unix/src/aix-ps2-1-2/Usignal.i3#0TOP0">unix/src/aix-ps2-1-2/Usignal.i3</A>
<LI><A HREF="../../../unix/src/freebsd-1/Usignal.i3#0TOP0">unix/src/freebsd-1/Usignal.i3</A>
<LI><A HREF="../../../unix/src/freebsd-2/Usignal.i3#0TOP0">unix/src/freebsd-2/Usignal.i3</A>
<LI><A HREF="../../../unix/src/hpux-7-0/Usignal.i3#0TOP0">unix/src/hpux-7-0/Usignal.i3</A>
<LI><A HREF="../../../unix/src/ibm-4-3/Usignal.i3#0TOP0">unix/src/ibm-4-3/Usignal.i3</A>
<LI><A HREF="../../../unix/src/irix-5.2/Usignal.i3#0TOP0">unix/src/irix-5.2/Usignal.i3</A>
<LI><A HREF="../../../unix/src/linux/Usignal.i3#0TOP0">unix/src/linux/Usignal.i3</A>
<LI><A HREF="../../../unix/src/osf-1.ALPHA_OSF/Usignal.i3#0TOP0">unix/src/osf-1.ALPHA_OSF/Usignal.i3</A>
<LI><A HREF="../../../unix/src/osf-1.DS3100/Usignal.i3#0TOP0">unix/src/osf-1.DS3100/Usignal.i3</A>
<LI><A HREF="../../../unix/src/solaris-2-x/Usignal.i3#0TOP0">unix/src/solaris-2-x/Usignal.i3</A>
<LI><A HREF="../../../unix/src/sunos-4-x/Usignal.i3#0TOP0">unix/src/sunos-4-x/Usignal.i3</A>
<LI><A HREF="../../../unix/src/sysv-4.0/Usignal.i3#0TOP0">unix/src/sysv-4.0/Usignal.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.AP3000/Usignal.i3#0TOP0">unix/src/ultrix-3-1.AP3000/Usignal.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.ARM/Usignal.i3#0TOP0">unix/src/ultrix-3-1.ARM/Usignal.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.DS3100/Usignal.i3#0TOP0">unix/src/ultrix-3-1.DS3100/Usignal.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.NEXT/Usignal.i3#0TOP0">unix/src/ultrix-3-1.NEXT/Usignal.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.SEQUENT/Usignal.i3#0TOP0">unix/src/ultrix-3-1.SEQUENT/Usignal.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.SUN3/Usignal.i3#0TOP0">unix/src/ultrix-3-1.SUN3/Usignal.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.SUN386/Usignal.i3#0TOP0">unix/src/ultrix-3-1.SUN386/Usignal.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.UMAX/Usignal.i3#0TOP0">unix/src/ultrix-3-1.UMAX/Usignal.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.VAX/Usignal.i3#0TOP0">unix/src/ultrix-3-1.VAX/Usignal.i3</A>
</UL>
<P>
<HR>
<A NAME="x4">interface ThreadF is in:
</A><UL>
<LI><A HREF="../../../thread/src/NOOP/ThreadF.i3#0TOP0">thread/src/NOOP/ThreadF.i3</A>
<LI><A HREF="../../../thread/src/POSIX/ThreadF.i3#0TOP0">thread/src/POSIX/ThreadF.i3</A>
<LI><A HREF="../../../thread/src/WIN32/ThreadF.i3#0TOP0">thread/src/WIN32/ThreadF.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
