<HTML>
<HEAD>
<TITLE>SRC Modula-3: float/src/IEEE/ExtendedFloat.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>float/src/IEEE/ExtendedFloat.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>

MODULE <module><implements><A HREF="../Common/ExtendedFloat.i3">ExtendedFloat</A></implements></module>;
</PRE> This module implements the operations on IEEE extended precisionreals 
   that do not depend on the operating system. 
   We assume that EXTENDED = LONGREAL. 

<P><PRE>IMPORT <A HREF="../Common/LongFloat.i3">LongFloat</A>, <A HREF="#x1">FloatMode</A>;

PROCEDURE <A NAME="Scalb"><procedure>Scalb</procedure></A> (x: T; n: INTEGER): T RAISES {FloatMode.Trap} =
  BEGIN
    RETURN FLOAT (LongFloat.Scalb (FLOAT (x, LONGREAL), n), T);
  END Scalb;

PROCEDURE <A NAME="Logb"><procedure>Logb</procedure></A> (x: T): T RAISES {FloatMode.Trap} =
  BEGIN
    RETURN FLOAT (LongFloat.Logb (FLOAT (x, LONGREAL)), T);
  END Logb;

PROCEDURE <A NAME="ILogb"><procedure>ILogb</procedure></A> (x: T): INTEGER =
  BEGIN
    RETURN LongFloat.ILogb (FLOAT (x, LONGREAL));
  END ILogb;

PROCEDURE <A NAME="NextAfter"><procedure>NextAfter</procedure></A> (x, y: T): T RAISES {FloatMode.Trap} =
  BEGIN
    RETURN FLOAT (LongFloat.NextAfter (FLOAT (x, LONGREAL),
                                       FLOAT (y, LONGREAL)),
                  T);
  END NextAfter;

PROCEDURE <A NAME="CopySign"><procedure>CopySign</procedure></A> (x, y: T): T =
  BEGIN
    RETURN FLOAT (LongFloat.CopySign (FLOAT (x, LONGREAL),
                                      FLOAT (y, LONGREAL)), T);
  END CopySign;

PROCEDURE <A NAME="Finite"><procedure>Finite</procedure></A> (x: T): BOOLEAN =
  BEGIN
    RETURN LongFloat.Finite (FLOAT (x, LONGREAL));
  END Finite;

PROCEDURE <A NAME="IsNaN"><procedure>IsNaN</procedure></A> (x: T): BOOLEAN =
  BEGIN
    RETURN LongFloat.IsNaN (FLOAT (x, LONGREAL));
  END IsNaN;

PROCEDURE <A NAME="Sign"><procedure>Sign</procedure></A> (x: T): [0..1] =
  BEGIN
    RETURN LongFloat.Sign (FLOAT (x, LONGREAL));
  END Sign;

PROCEDURE <A NAME="Differs"><procedure>Differs</procedure></A> (x, y: T): BOOLEAN =
  BEGIN
    RETURN LongFloat.Differs (FLOAT (x, LONGREAL), FLOAT (y, LONGREAL));
  END Differs;

PROCEDURE <A NAME="Unordered"><procedure>Unordered</procedure></A> (x, y: T): BOOLEAN =
  BEGIN
    RETURN LongFloat.Unordered (FLOAT (x, LONGREAL), FLOAT (y, LONGREAL));
  END Unordered;

PROCEDURE <A NAME="Sqrt"><procedure>Sqrt</procedure></A> (x: T): T RAISES {FloatMode.Trap} =
  BEGIN
    RETURN FLOAT (LongFloat.Sqrt (FLOAT (x, LONGREAL)), T);
  END Sqrt;

PROCEDURE <A NAME="Class"><procedure>Class</procedure></A> (x: T): IEEEClass =
  BEGIN
    RETURN LongFloat.Class (FLOAT (x, LONGREAL));
  END Class;

PROCEDURE <A NAME="FromDecimal"><procedure>FromDecimal</procedure></A> (
    sign: [0..1]; READONLY digits: ARRAY OF [0..9]; exp: INTEGER): T
    RAISES {FloatMode.Trap} =
  BEGIN
    RETURN FLOAT (LongFloat.FromDecimal (sign, digits, exp), T);
  END FromDecimal;

PROCEDURE <A NAME="ToDecimal"><procedure>ToDecimal</procedure></A>(x: T): DecimalApprox =
  BEGIN
    RETURN LongFloat.ToDecimal (FLOAT (x, LONGREAL));
  END ToDecimal;

BEGIN
END ExtendedFloat.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface FloatMode is in:
</A><UL>
<LI><A HREF="../DS3100/FloatMode.i3#0TOP0">float/src/DS3100/FloatMode.i3</A>
<LI><A HREF="../IEEE-default/FloatMode.i3#0TOP0">float/src/IEEE-default/FloatMode.i3</A>
<LI><A HREF="../IRIX5/FloatMode.i3#0TOP0">float/src/IRIX5/FloatMode.i3</A>
<LI><A HREF="../SOLsun/FloatMode.i3#0TOP0">float/src/SOLsun/FloatMode.i3</A>
<LI><A HREF="../SPARC/FloatMode.i3#0TOP0">float/src/SPARC/FloatMode.i3</A>
<LI><A HREF="../SUN386/FloatMode.i3#0TOP0">float/src/SUN386/FloatMode.i3</A>
<LI><A HREF="../VAX/FloatMode.i3#0TOP0">float/src/VAX/FloatMode.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
