<HTML>
<HEAD>
<TITLE>SRC Modula-3: float/src/IEEE/LongFloat.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>float/src/IEEE/LongFloat.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>

UNSAFE MODULE <module><implements><A HREF="../Common/LongFloat.i3">LongFloat</A></implements></module>;
</PRE> This module implements the operations on IEEE double precision reals 
   that do not depend on the operating system. 

<P><PRE>IMPORT <A HREF="#x1">LongRealRep</A> AS Rep;
IMPORT <A HREF="../Common/DragonT.i3">DragonT</A>, <A HREF="#x2">FPU</A>, <A HREF="../../../word/src/Word.i3">Word</A>, <A HREF="../../../C/src/Common/Ctypes.i3">Ctypes</A>, <A HREF="../../../convert/src/Convert.i3">Convert</A>;

PROCEDURE <A NAME="Scalb"><procedure>Scalb</procedure></A> (x: T; n: INTEGER): T =
  BEGIN
    RETURN FLOAT (FPU.scalb (FLOAT (x, LONGREAL), n), T);
  END Scalb;

PROCEDURE <A NAME="Logb"><procedure>Logb</procedure></A> (x: T): T =
  CONST Log_of_zero = Rep.T {sign := 1, exponent := 16_7ff,
                        significand0 := 0, significand1 := 0};
  VAR ans: T;
  BEGIN
    CASE Class (x) OF
    | IEEEClass.SignalingNaN,
      IEEEClass.QuietNaN =&gt;
        RETURN x;
    | IEEEClass.Infinity =&gt;
        RETURN ABS (x);
    | IEEEClass.Zero =&gt;
        LOOPHOLE (ans, Rep.T) := Log_of_zero;
        RETURN ans;
    | IEEEClass.Normal =&gt;
        RETURN FLOAT (LOOPHOLE (x, Rep.T).exponent - 1023, T);
    | IEEEClass.Denormal =&gt;
        RETURN -1022.0d0;
    END;
  END Logb;

PROCEDURE <A NAME="ILogb"><procedure>ILogb</procedure></A> (x: T): INTEGER =
  VAR xx := LOOPHOLE (x, Rep.T);  v, w: Word.T;  n: INTEGER;
  BEGIN
    CASE Class (x) OF
    | IEEEClass.SignalingNaN,
      IEEEClass.QuietNaN =&gt;
        (* RETURN 0; *)
        &lt;* ASSERT FALSE*&gt;
    | IEEEClass.Infinity =&gt;
        RETURN (LAST (INTEGER));
    | IEEEClass.Zero =&gt;
        RETURN (FIRST (INTEGER));
    | IEEEClass.Normal =&gt;
        RETURN xx.exponent - 1023;
    | IEEEClass.Denormal =&gt;
        IF xx.significand0 = 0
          THEN v := 16_80000000;  n := - 1043;  w := xx.significand1;
          ELSE v := 16_00080000;  n := - 1023;  w := xx.significand0;
        END;
        WHILE Word.And (v, w) = 0 DO
          v := Word.RightShift (v, 1);
          DEC (n);
        END;
        RETURN n;
    END; (*CASE*)
  END ILogb;

PROCEDURE <A NAME="NextAfter"><procedure>NextAfter</procedure></A> (x, y: T): T =
  CONST Ones0 = 16_fffff; (* BITSIZE (significand0) 1's *)
        Ones1 = -1; (* all 1's *)
  VAR xx := LOOPHOLE (x, Rep.T);  yy := LOOPHOLE (y, Rep.T);  z: T;
  BEGIN
    IF x = y                       THEN RETURN x; END;
    IF IsNaN (x) OR NOT Finite (x) THEN RETURN x; END;
    IF IsNaN (y)                   THEN RETURN y; END;

    IF x = 0.0d0   THEN
      LOOPHOLE(z, Rep.T).sign         := yy.sign;
      LOOPHOLE(z, Rep.T).exponent     := 0;
      LOOPHOLE(z, Rep.T).significand0 := 0;
      LOOPHOLE(z, Rep.T).significand1 := 1;
      RETURN z; END;

    IF (x &gt; 0.0d0 AND x &gt; y) OR (x &lt; 0.0d0 AND x &lt; y) THEN
      IF xx.significand0 = 0 AND xx.significand1 = 0 THEN
        xx.significand0 := Ones0;
        xx.significand1 := Ones1;
        DEC (xx.exponent);
        IF xx.exponent = 0 THEN
          RETURN (2.0d0 * x) / 2.0d0; (* generate underflow *) END;
      ELSIF xx.significand1 = 0 THEN
        xx.significand1 := Ones1;
        DEC (xx.significand0);
      ELSE
        DEC (xx.significand1); END;
    ELSE
      IF xx.significand0 = Ones0 AND xx.significand1 = Ones1 THEN
        xx.significand0 := 0;
        xx.significand1 := 0;
        INC (xx.exponent);
        IF xx.exponent = 16_7ff THEN
          RETURN (x + x); (* generate overflow *) END;
      ELSIF xx.significand1 = Ones1 THEN
        xx.significand1 := 0;
        INC (xx.significand0);
      ELSE
        INC (xx.significand1); END; END;

    LOOPHOLE (z, Rep.T) := xx;
    RETURN z;
  END NextAfter;

PROCEDURE <A NAME="CopySign"><procedure>CopySign</procedure></A> (x, y: T): T =
  VAR res := x;
  BEGIN
    LOOPHOLE (res, Rep.T).sign := LOOPHOLE (y, Rep.T).sign;
    RETURN res;
  END CopySign;

PROCEDURE <A NAME="Finite"><procedure>Finite</procedure></A> (x: T): BOOLEAN =
  VAR xx := LOOPHOLE (x, Rep.T);
  BEGIN
    RETURN xx.exponent # 16_7ff;
  END Finite;

PROCEDURE <A NAME="IsNaN"><procedure>IsNaN</procedure></A> (x: T): BOOLEAN =
  VAR xx := LOOPHOLE (x, Rep.T);
  BEGIN
    RETURN xx.exponent = 16_7ff
           AND xx.significand0 = 0
           AND xx.significand1 = 0;
  END IsNaN;

PROCEDURE <A NAME="Sign"><procedure>Sign</procedure></A> (x: T): [0..1] =
  VAR xx := LOOPHOLE (x, Rep.T);
  BEGIN
    RETURN xx.sign;
  END Sign;

PROCEDURE <A NAME="Differs"><procedure>Differs</procedure></A> (x, y: T): BOOLEAN =
  BEGIN
    RETURN (x &lt; y) OR (y &lt; x);
  END Differs;

PROCEDURE <A NAME="Unordered"><procedure>Unordered</procedure></A> (x, y: T): BOOLEAN =
  BEGIN
    RETURN NOT (x &lt;= y OR y &lt;= x);
  END Unordered;

PROCEDURE <A NAME="Class"><procedure>Class</procedure></A> (x: T): IEEEClass =
  VAR xx := LOOPHOLE (x, Rep.T);
  BEGIN
    IF xx.exponent = 0 THEN
      IF xx.significand0 = 0 AND xx.significand1 = 0
        THEN RETURN IEEEClass.Zero;
        ELSE RETURN IEEEClass.Denormal;
      END;
    ELSIF xx.exponent # 16_7FF THEN
      RETURN IEEEClass.Normal;
    ELSIF xx.significand0 = 0 AND xx.significand1 = 0 THEN
      RETURN IEEEClass.Infinity;
    ELSIF Word.And (16_00080000, xx.significand0) = 0 THEN
      RETURN IEEEClass.QuietNaN;
    ELSE
      RETURN IEEEClass.SignalingNaN;
    END;
  END Class;

PROCEDURE <A NAME="Sqrt"><procedure>Sqrt</procedure></A> (x: T): T =
  BEGIN
    RETURN FLOAT (FPU.sqrt (FLOAT (x, LONGREAL)), T);
  END Sqrt;

PROCEDURE <A NAME="FromDecimal"><procedure>FromDecimal</procedure></A> (sign   : [0..1];
              READONLY digits : ARRAY OF [0..9];
                       exp    : INTEGER): T =
  &lt;*FATAL Convert.Failed*&gt;
  TYPE CharBuf = UNTRACED REF ARRAY OF Ctypes.char;
  CONST Sign = ARRAY [0..1] OF Ctypes.char { ORD ('+'), ORD ('-') };
  VAR
    ebuf: ARRAY [0..Word.Size] OF CHAR;
    buf: CharBuf;
    expLen, len: CARDINAL;
    res: T;
  BEGIN
    (* strategy:  build a C-style null terminated string and
       call the C runtime library to convert it to binary value. *)

    (* Allocate the buffer to hold the digits, the exponent value, and the
       four characters: 1) the leading sign, 2) the decimal point, 3) the 'e'
       character, and 4) the terminating 0 character. *)
    IF exp # 0 THEN expLen := Convert.FromInt(ebuf, exp) END;
    buf := NEW(CharBuf, NUMBER(digits) + expLen + 4);
    buf[0] := Sign [sign];              len := 1;
    buf[len] := ORD('0') + digits[0];   INC(len);
    buf[len] := ORD('.');               INC(len);
    FOR i := FIRST(digits) + 1 TO LAST(digits) DO
      buf[len] := ORD ('0') + digits [i];  INC (len);
    END;
    IF exp # 0 THEN
      buf[len] := ORD ('e');  INC (len);
      FOR i := 0 TO expLen - 1 DO
	buf[len] := ORD (ebuf[i]);  INC (len);
      END
    END;
    buf[len] := 0;

    res := FLOAT (DragonT.strtod (ADR(buf[0]), NIL), T);
    DISPOSE(buf);
    RETURN res
  END FromDecimal;

PROCEDURE <A NAME="ToDecimal"><procedure>ToDecimal</procedure></A>(x: T): DecimalApprox =
  VAR
    xx := LOOPHOLE (x, Rep.T);
    res: DecimalApprox;
    exp, sig0, sig1: INTEGER;
    count: CARDINAL;
  BEGIN
    res.class := Class (x);
    res.sign := Sign (x);

    IF (res.class # IEEEClass.Denormal) AND (res.class # IEEEClass.Normal) THEN
      RETURN res;
    END;

    (* we have the lower 32 bits in significand1, the upper 20 bits in
       significand0 and may be a bit to set at the top (if bits = 53) *)

    sig1 := Word.And (xx.significand1, 16_ffffffff);
    sig0 := Word.And (xx.significand0, 16_fffff);

    IF xx.exponent = 0 THEN
      exp := -1021;
    ELSE
      exp  := xx.exponent - 1022;
      sig0 := Word.Or (sig0, 16_100000);  (* add the implied 53rd bit *)
    END;

    DragonT.F (exp, sig0, sig1, 53, DragonT.CutoffMode.normal, 0,
                 res.digits, count, res.exp);
    res.len := count;
    res.errorSign := 0;
    RETURN res;
  END ToDecimal;

BEGIN
END LongFloat.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface LongRealRep is in:
</A><UL>
<LI><A HREF="../IEEE-be/LongRealRep.i3#0TOP0">float/src/IEEE-be/LongRealRep.i3</A>
<LI><A HREF="../IEEE-le/LongRealRep.i3#0TOP0">float/src/IEEE-le/LongRealRep.i3</A>
<LI><A HREF="../VAX/LongRealRep.i3#0TOP0">float/src/VAX/LongRealRep.i3</A>
</UL>
<P>
<HR>
<A NAME="x2">interface FPU is in:
</A><UL>
<LI><A HREF="../DS3100/FPU.i3#0TOP0">float/src/DS3100/FPU.i3</A>
<LI><A HREF="../IEEE-default/FPU.i3#0TOP0">float/src/IEEE-default/FPU.i3</A>
<LI><A HREF="../IRIX5/FPU.i3#0TOP0">float/src/IRIX5/FPU.i3</A>
<LI><A HREF="../SOLsun/FPU.i3#0TOP0">float/src/SOLsun/FPU.i3</A>
<LI><A HREF="../SPARC/FPU.i3#0TOP0">float/src/SPARC/FPU.i3</A>
<LI><A HREF="../SUN386/FPU.i3#0TOP0">float/src/SUN386/FPU.i3</A>
<LI><A HREF="../VAX/FPU.i3#0TOP0">float/src/VAX/FPU.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
