<HTML>
<HEAD>
<TITLE>SRC Modula-3: float/src/IEEE/LongReal.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>float/src/IEEE/LongReal.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

INTERFACE <interface><A HREF="../Common/LongReal.m3">LongReal</A></interface>;
</PRE> Properties of LONGREAL (for ANSI/IEEE Standard 754-1985).
<P>
   This package defines some basic properties of the 
   built-in float type LONGREAL.
<P>
   Index: LONGREAL; floating-point; generics


<P><PRE>TYPE T = LONGREAL;

CONST
  Base: INTEGER = 2;
  (* The radix of the floating-point representation for T *)

  Precision: INTEGER = 53;
  (* The number of digits of precision in the given Base for T. *)

  MaxFinite: T = 1.7976931348623157D+308;
  (* The maximum finite value in T.  For non-IEEE implementations,
     this is the same as LAST(T). *)

  MinPos: T = 4.9406564584124654D-324;
  (* The minimum positive value in T. *)

  MinPosNormal: T = 2.2250738585072014D-308;
  (* The minimum positive &quot;normal&quot; value in T; differs from MinPos
     only for implementations with denormalized numbers. *)

CONST
  MaxExpDigits = 3;
  MaxSignifDigits = 17;
</PRE><BLOCKQUOTE><EM> <CODE>MaxExpDigits</CODE> is the smallest integer with the property that every
   finite number of type <CODE>T</CODE> can be written in base-10 scientific
   notation using an exponent with at most <CODE>MaxExpDigits</CODE>.
   <CODE>MaxSignifDigits</CODE> is the smallest integer with the property that
   floating-decimal numbers with <CODE>MaxSignifDigits</CODE> are more closely
   spaced, all along the number line, than are numbers of type <CODE>T</CODE>.
   Typically, </EM></BLOCKQUOTE><PRE>
</PRE><P>
<PRE>
      MaxExpDigits    = ceiling(log_10(log_10(MaxFinite)))
      MaxSignifDigits = ceiling(log_10(Base^Precision)) + 1.

<PRE>END LongReal.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
