<HTML>
<HEAD>
<TITLE>SRC Modula-3: float/src/IRIX5/FPU.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>float/src/IRIX5/FPU.i3</H2></A><HR>
<inInterface>
<PRE></PRE> Copyright (C) 1992, Xerox                                                 

<P>
<P><PRE>INTERFACE <interface><A HREF="#x1">FPU</A></interface>;
</PRE>--------------------------------------------------- IEEE classification ---

<P><PRE>TYPE
  FPClass = { SignalingNaN, QuietNaN,
              PosInfinity,  NegInfinity,
              PosNormal,    NegNormal,
              PosDenormal,  NegDenormal,
              PosZero,      NegZero };

&lt;*EXTERNAL fpclass*&gt; PROCEDURE LongClass (x: LONGREAL): INTEGER;
</PRE><BLOCKQUOTE><EM> returns the IEEE defined class of its argument -- from ieeefp.h </EM></BLOCKQUOTE><PRE>
</PRE>----------------------------------------------- control/status register ---

<P> From sys/fpu.h 

<P><PRE>TYPE
  Flag = BITS 1 FOR BOOLEAN;

TYPE
  ControlStatus = RECORD
    reserved0 : BITS 7 FOR [0..127];
    flush     : Flag;
    condition : Flag;  (* result of most recent compare instruction *)
    reserved1 : BITS 5 FOR [0..31];

    (* exceptions that occurred during the most recent instruction *)
    ex_unimplemented : Flag;
    ex_invalid   : Flag;
    ex_divide0   : Flag;
    ex_overflow  : Flag;
    ex_underflow : Flag;
    ex_inexact   : Flag;

    (* trap enable flags for the exceptions *)
    en_invalid   : Flag;
    en_divide0   : Flag;
    en_overflow  : Flag;
    en_underflow : Flag;
    en_inexact   : Flag;

    (* &quot;sticky&quot; bits, only reset by writing the control register *)
    se_invalid   : Flag;
    se_divide0   : Flag;
    se_overflow  : Flag;
    se_underflow : Flag;
    se_inexact   : Flag;

    rounding_mode : BITS 2 FOR RoundingMode;
  END;

TYPE
  RoundingMode = { ToNearest, ToZero, ToPlusInfinity, ToMinusInfinity };

&lt;*EXTERNAL get_fpc_csr*&gt;
PROCEDURE GetStatus (): INTEGER(*ControlStatus*);
</PRE><BLOCKQUOTE><EM> returns the current setting of the floating point control registers </EM></BLOCKQUOTE><PRE>

&lt;*EXTERNAL set_fpc_csr*&gt;
PROCEDURE SetStatus (new: INTEGER): INTEGER(*ControlStatus*);
</PRE><BLOCKQUOTE><EM> sets the floating point control registers and returns their previous state</EM></BLOCKQUOTE><PRE>
</PRE> From &lt;ieeefp.h&gt; 

<P><PRE>&lt;*EXTERNAL fpgetround*&gt;
PROCEDURE GetRounding (): INTEGER(*RoundingMode*);
</PRE><BLOCKQUOTE><EM> returns the current rounding mode </EM></BLOCKQUOTE><PRE>

&lt;*EXTERNAL fpsetround*&gt;
PROCEDURE SetRounding(new: INTEGER): INTEGER(*RoundingMode*);
</PRE><BLOCKQUOTE><EM> sets the rounding mode and returns its previous value </EM></BLOCKQUOTE><PRE>
</PRE> From &lt;math.h&gt; 

<P><PRE>&lt;*EXTERNAL isnan*&gt; PROCEDURE IsNaN (x: LONGREAL): BOOLEAN;
</PRE><BLOCKQUOTE><EM> return 1 if x is NaN, 0 otherwise. </EM></BLOCKQUOTE><PRE>

&lt;*EXTERNAL copysign*&gt; PROCEDURE CopySign (x, y: LONGREAL): LONGREAL;
</PRE><BLOCKQUOTE><EM> return 'x' with the sign of 'y'. </EM></BLOCKQUOTE><PRE>

&lt;*EXTERNAL drem*&gt; PROCEDURE Remainder (x, y: LONGREAL): LONGREAL;
</PRE><BLOCKQUOTE><EM> returns the remainder r := x - n*y  where n is the integer nearest the
   exact value of x/y.  Additionally if |n-x/y|=1/2, then n is even.
   Consequently the remainder is computed exactly and |r| &lt; |y|/2.
   Remainder (x, 0.0) and Remainder (infinity, y) produce NaN. </EM></BLOCKQUOTE><PRE>

&lt;*EXTERNAL finite*&gt; PROCEDURE IsFinite (x: LONGREAL): BOOLEAN;
</PRE><BLOCKQUOTE><EM> = 1 if -infinity &lt; x &lt; +infinity, otherwise = 0 </EM></BLOCKQUOTE><PRE>

&lt;*EXTERNAL logb*&gt; PROCEDURE BinaryLog (x: LONGREAL): LONGREAL;
</PRE><BLOCKQUOTE><EM> for x finite, non-zero, and above the underflow threshold,
   returns the integer valued floating-point number n, such that
   1 &lt; ABS (x) / (2^n) &lt; 2.  Note that BinaryLog (+infinity) = +infinity,
   and BinaryLog (0) = -infinity (and causes a division-by-zero error). </EM></BLOCKQUOTE><PRE>

&lt;*EXTERNAL ldexp*&gt; PROCEDURE scalb (x: LONGREAL;  n: INTEGER): LONGREAL;
</PRE><BLOCKQUOTE><EM> returns x * (2^n) </EM></BLOCKQUOTE><PRE>

&lt;*EXTERNAL*&gt; PROCEDURE sqrt (x: LONGREAL): LONGREAL;
</PRE><BLOCKQUOTE><EM> returns sqrt (x) </EM></BLOCKQUOTE><PRE>

END FPU.
</PRE>
</inInterface>
<HR>
<A NAME="x1">FPU's implementation  is in:
</A><UL>
<LI><A HREF="../IEEE-default/FPU.m3#0TOP0">float/src/IEEE-default/FPU.m3</A>
<LI><A HREF="../VAX/FPU.m3#0TOP0">float/src/VAX/FPU.m3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
