<HTML>
<HEAD>
<TITLE>SRC Modula-3: float/src/VAX/Extended.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>float/src/VAX/Extended.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

INTERFACE <interface><A HREF="../Common/Extended.m3">Extended</A></interface>;
</PRE> Properties of EXTENDED (for the VAX).
<P>
   This package defines some basic properties of the 
   built-in float type EXTENDED, for the VAX architecture.
<P>
   Index: EXTENDED; floating-point; generics


<P><PRE>TYPE T = EXTENDED;

CONST
  Base: INTEGER = 2;
  (* The radix of the floating-point representation for T *)

  Precision: INTEGER = 56;
  (* The number of digits of precision in the given Base for T. *)

  MaxFinite: T = 1.70141183460469230X+38;
  (* The maximum finite value in T.  For non-IEEE implementations,
     this is the same as LAST(T). *)

  MinPos: T = 2.93873587705571880X-39;
  (* The minimum positive value in T. *)

  MinPosNormal: T = MinPos;
  (* The minimum positive &quot;normal&quot; value in T; differs from MinPos
     only for implementations with denormalized numbers. *)

CONST
  MaxExpDigits = 2;
  MaxSignifDigits = 18;
</PRE> <CODE>MaxExpDigits</CODE> is the smallest integer with the property that every
   finite number of type <CODE>T</CODE> can be written in base-10 scientific notation
   using an exponent with at most <CODE>MaxExpDigits</CODE>.  <CODE>MaxSignifDigits</CODE>
   is the smallest integer with the property that floating-decimal
   numbers with <CODE>MaxSignifDigits</CODE> are more closely spaced, all along
   the number line, than are numbers of type <CODE>T</CODE>.  Typically,
<P>
<PRE>
      MaxExpDigits    = ceiling(log_10(log_10(MaxFinite)))
      MaxSignifDigits = ceiling(log_10(Base^Precision)) + 1.
</PRE>

<PRE>END Extended.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
