<HTML>
<HEAD>
<TITLE>SRC Modula-3: float/src/VAX/ExtendedFloat.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>float/src/VAX/ExtendedFloat.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                             </EM></BLOCKQUOTE><PRE>

UNSAFE MODULE <module><implements><A HREF="../Common/ExtendedFloat.i3">ExtendedFloat</A></implements></module>;

IMPORT <A HREF="#x1">FPU</A>, <A HREF="#x2">LongRealRep</A>, <A HREF="#x3">FloatMode</A>, <A HREF="../Common/LongFloat.i3">LongFloat</A>;

PROCEDURE <A NAME="Scalb"><procedure>Scalb</procedure></A>(x: T; n: INTEGER): T =
  BEGIN
    RETURN FLOAT (FPU.ldexp (FLOAT (x, LONGREAL), n), T);
  END Scalb;

PROCEDURE <A NAME="Logb"><procedure>Logb</procedure></A>(&lt;*UNUSED*&gt; x: T): T =
  BEGIN
    &lt;* ASSERT FALSE *&gt;
  END Logb;

PROCEDURE <A NAME="ILogb"><procedure>ILogb</procedure></A>(&lt;*UNUSED*&gt; x: T): INTEGER =
  BEGIN
    &lt;* ASSERT FALSE *&gt;
  END ILogb;

PROCEDURE <A NAME="NextAfter"><procedure>NextAfter</procedure></A>(&lt;*UNUSED*&gt; x, y: T): T =
  BEGIN
    &lt;* ASSERT FALSE *&gt;
  END NextAfter;

PROCEDURE <A NAME="CopySign"><procedure>CopySign</procedure></A>(x, y: T): T =
  VAR res := x;
  BEGIN
    LOOPHOLE (res, LongRealRep.T).sign := LOOPHOLE (y, LongRealRep.T).sign;
    RETURN res;
  END CopySign;

PROCEDURE <A NAME="Finite"><procedure>Finite</procedure></A>(&lt;*UNUSED*&gt; x: T): BOOLEAN =
  BEGIN
    RETURN TRUE;
  END Finite;

PROCEDURE <A NAME="IsNaN"><procedure>IsNaN</procedure></A>(x: T): BOOLEAN =
  VAR xx := LOOPHOLE (x, LongRealRep.T);
  BEGIN
    RETURN (xx.sign # 0) AND (xx.exponent = 0);
  END IsNaN;

PROCEDURE <A NAME="Sign"><procedure>Sign</procedure></A>(x: T): [0..1] =
  VAR xx := LOOPHOLE (x, LongRealRep.T);
  BEGIN
    RETURN xx.sign;
  END Sign;

PROCEDURE <A NAME="Differs"><procedure>Differs</procedure></A>(x, y: T): BOOLEAN =
  BEGIN
    RETURN (NOT (IsNaN (x) OR IsNaN (y))) AND (x # y);
  END Differs;

PROCEDURE <A NAME="Unordered"><procedure>Unordered</procedure></A>(x, y: T): BOOLEAN =
  BEGIN
    RETURN IsNaN (x) OR IsNaN (y);
  END Unordered;

PROCEDURE <A NAME="Sqrt"><procedure>Sqrt</procedure></A>(x: T): T =
  BEGIN
    RETURN FLOAT (FPU.sqrt (FLOAT (x, LONGREAL)), T);
  END Sqrt;

PROCEDURE <A NAME="Class"><procedure>Class</procedure></A>(x: T): IEEEClass =
  BEGIN
    IF IsNaN (x) THEN
      RETURN IEEEClass.SignalingNaN;
    ELSIF (x = 0.0x+0) THEN
      RETURN IEEEClass.Zero;
    ELSE
      RETURN IEEEClass.Normal;
    END;
  END Class;

PROCEDURE <A NAME="FromDecimal"><procedure>FromDecimal</procedure></A>(
    sign: [0..1]; READONLY digits: ARRAY OF [0..9]; exp: INTEGER): T
    RAISES {FloatMode.Trap} =
  BEGIN
    RETURN FLOAT (LongFloat.FromDecimal (sign, digits, exp), T);
  END FromDecimal;

PROCEDURE <A NAME="ToDecimal"><procedure>ToDecimal</procedure></A>(x: T): DecimalApprox =
  BEGIN
    RETURN LongFloat.ToDecimal (FLOAT (x, LONGREAL));
  END ToDecimal;

BEGIN
END ExtendedFloat.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface FPU is in:
</A><UL>
<LI><A HREF="../DS3100/FPU.i3#0TOP0">float/src/DS3100/FPU.i3</A>
<LI><A HREF="../IEEE-default/FPU.i3#0TOP0">float/src/IEEE-default/FPU.i3</A>
<LI><A HREF="../IRIX5/FPU.i3#0TOP0">float/src/IRIX5/FPU.i3</A>
<LI><A HREF="../SOLsun/FPU.i3#0TOP0">float/src/SOLsun/FPU.i3</A>
<LI><A HREF="../SPARC/FPU.i3#0TOP0">float/src/SPARC/FPU.i3</A>
<LI><A HREF="../SUN386/FPU.i3#0TOP0">float/src/SUN386/FPU.i3</A>
<LI><A HREF="FPU.i3#0TOP0">float/src/VAX/FPU.i3</A>
</UL>
<P>
<HR>
<A NAME="x2">interface LongRealRep is in:
</A><UL>
<LI><A HREF="../IEEE-be/LongRealRep.i3#0TOP0">float/src/IEEE-be/LongRealRep.i3</A>
<LI><A HREF="../IEEE-le/LongRealRep.i3#0TOP0">float/src/IEEE-le/LongRealRep.i3</A>
<LI><A HREF="LongRealRep.i3#0TOP0">float/src/VAX/LongRealRep.i3</A>
</UL>
<P>
<HR>
<A NAME="x3">interface FloatMode is in:
</A><UL>
<LI><A HREF="../DS3100/FloatMode.i3#0TOP0">float/src/DS3100/FloatMode.i3</A>
<LI><A HREF="../IEEE-default/FloatMode.i3#0TOP0">float/src/IEEE-default/FloatMode.i3</A>
<LI><A HREF="../IRIX5/FloatMode.i3#0TOP0">float/src/IRIX5/FloatMode.i3</A>
<LI><A HREF="../SOLsun/FloatMode.i3#0TOP0">float/src/SOLsun/FloatMode.i3</A>
<LI><A HREF="../SPARC/FloatMode.i3#0TOP0">float/src/SPARC/FloatMode.i3</A>
<LI><A HREF="../SUN386/FloatMode.i3#0TOP0">float/src/SUN386/FloatMode.i3</A>
<LI><A HREF="FloatMode.i3#0TOP0">float/src/VAX/FloatMode.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
