<HTML>
<HEAD>
<TITLE>SRC Modula-3: float/src/VAX/FloatMode.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>float/src/VAX/FloatMode.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                             </EM></BLOCKQUOTE><PRE>

MODULE <module><implements><A HREF="#x1">FloatMode</A></implements></module> (* FOR VAX *);

IMPORT <A HREF="#x2">ThreadF</A>;

PROCEDURE <A NAME="SetRounding"><procedure>SetRounding</procedure></A>(md: RoundingMode) RAISES {Failure} =
  BEGIN
    IF (md # RoundDefault) THEN RAISE Failure END;
  END SetRounding;

PROCEDURE <A NAME="GetRounding"><procedure>GetRounding</procedure></A>(): RoundingMode =
  BEGIN
    RETURN RoundDefault;
  END GetRounding;

PROCEDURE <A NAME="GetFlags"><procedure>GetFlags</procedure></A>(): SET OF Flag =
  VAR state := ThreadF.MyFPState ();
  BEGIN
    RETURN state.sticky;
  END GetFlags;

PROCEDURE <A NAME="SetFlags"><procedure>SetFlags</procedure></A>(s: SET OF Flag): SET OF Flag =
  VAR state := ThreadF.MyFPState ();
  VAR old := state.sticky;
  BEGIN
    state.sticky := s;
    RETURN old;
  END SetFlags;

PROCEDURE <A NAME="ClearFlag"><procedure>ClearFlag</procedure></A>(f: Flag) =
  VAR state := ThreadF.MyFPState ();
  BEGIN
    state.sticky := state.sticky - SET OF Flag {f};
  END ClearFlag;

TYPE
  BHMap = ARRAY Behavior OF BOOLEAN;
CONST
  AllowedBehavior = ARRAY Flag OF BHMap {
    (*  --- flag ---           Trap    SetFlag  Ignore  *)
    (* Invalid      *) BHMap { FALSE,  FALSE,   TRUE  },
    (* Inexact      *) BHMap { FALSE,  FALSE,   TRUE  },
    (* Overflow     *) BHMap { FALSE,  FALSE,   TRUE  },
    (* Underflow    *) BHMap { FALSE,  FALSE,   TRUE  },
    (* DivByZero    *) BHMap { FALSE,  FALSE,   TRUE  },
    (* IntOverflow  *) BHMap { FALSE,  FALSE,   TRUE  },
    (* IntDivByZero *) BHMap { FALSE,  FALSE,   TRUE  }
  };

PROCEDURE <A NAME="SetBehavior"><procedure>SetBehavior</procedure></A>(f: Flag; b: Behavior) RAISES {Failure} =
  VAR state := ThreadF.MyFPState ();
  BEGIN
    IF (state.behavior [f] = b) THEN RETURN END;
    IF NOT AllowedBehavior [f, b] THEN RAISE Failure END;
    state.behavior [f] := b;
  END SetBehavior;

PROCEDURE <A NAME="GetBehavior"><procedure>GetBehavior</procedure></A>(f: Flag): Behavior =
  BEGIN
    RETURN ThreadF.MyFPState().behavior [f];
  END GetBehavior;
</PRE>------------------------------------------------- thread initialization ---

<P><PRE>CONST
  DefaultState = ThreadState {
     ARRAY Flag OF Behavior { Behavior.Ignore, .. },
     NoFlags
  };

PROCEDURE <A NAME="InitThread"><procedure>InitThread</procedure></A> (VAR state: ThreadState) =
  BEGIN
    state := DefaultState;
  END InitThread;

BEGIN
END FloatMode.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface FloatMode is in:
</A><UL>
<LI><A HREF="../DS3100/FloatMode.i3#0TOP0">float/src/DS3100/FloatMode.i3</A>
<LI><A HREF="../IEEE-default/FloatMode.i3#0TOP0">float/src/IEEE-default/FloatMode.i3</A>
<LI><A HREF="../IRIX5/FloatMode.i3#0TOP0">float/src/IRIX5/FloatMode.i3</A>
<LI><A HREF="../SOLsun/FloatMode.i3#0TOP0">float/src/SOLsun/FloatMode.i3</A>
<LI><A HREF="../SPARC/FloatMode.i3#0TOP0">float/src/SPARC/FloatMode.i3</A>
<LI><A HREF="../SUN386/FloatMode.i3#0TOP0">float/src/SUN386/FloatMode.i3</A>
<LI><A HREF="FloatMode.i3#0TOP0">float/src/VAX/FloatMode.i3</A>
</UL>
<P>
<HR>
<A NAME="x2">interface ThreadF is in:
</A><UL>
<LI><A HREF="../../../thread/src/NOOP/ThreadF.i3#0TOP0">thread/src/NOOP/ThreadF.i3</A>
<LI><A HREF="../../../thread/src/POSIX/ThreadF.i3#0TOP0">thread/src/POSIX/ThreadF.i3</A>
<LI><A HREF="../../../thread/src/WIN32/ThreadF.i3#0TOP0">thread/src/WIN32/ThreadF.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
