<HTML>
<HEAD>
<TITLE>SRC Modula-3: float/src/VAX/LongFloat.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>float/src/VAX/LongFloat.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                             </EM></BLOCKQUOTE><PRE>

UNSAFE MODULE <module><implements><A HREF="../Common/LongFloat.i3">LongFloat</A></implements></module>;

IMPORT <A HREF="#x1">FPU</A>, <A HREF="#x2">LongRealRep</A>, <A HREF="../../../convert/src/Convert.i3">Convert</A>, <A HREF="../Common/DragonT.i3">DragonT</A>, <A HREF="../../../C/src/Common/Ctypes.i3">Ctypes</A>, <A HREF="../../../word/src/Word.i3">Word</A>;

PROCEDURE <A NAME="Scalb"><procedure>Scalb</procedure></A>(x: T; n: INTEGER): T =
  BEGIN
    RETURN FPU.ldexp (x, n);
  END Scalb;

PROCEDURE <A NAME="Logb"><procedure>Logb</procedure></A>(&lt;*UNUSED*&gt; x: T): T =
  BEGIN
    &lt;* ASSERT FALSE *&gt;
  END Logb;

PROCEDURE <A NAME="ILogb"><procedure>ILogb</procedure></A>(&lt;*UNUSED*&gt; x: T): INTEGER =
  BEGIN
    &lt;* ASSERT FALSE *&gt;
  END ILogb;

PROCEDURE <A NAME="NextAfter"><procedure>NextAfter</procedure></A>(&lt;*UNUSED*&gt; x, y: T): T =
  BEGIN
    &lt;* ASSERT FALSE *&gt;
  END NextAfter;

PROCEDURE <A NAME="CopySign"><procedure>CopySign</procedure></A>(x, y: T): T =
  VAR res := x;
  BEGIN
    LOOPHOLE (res, LongRealRep.T).sign := LOOPHOLE (y, LongRealRep.T).sign;
    RETURN res;
  END CopySign;

PROCEDURE <A NAME="Finite"><procedure>Finite</procedure></A>(&lt;*UNUSED*&gt; x: T): BOOLEAN =
  BEGIN
    RETURN TRUE;
  END Finite;

PROCEDURE <A NAME="IsNaN"><procedure>IsNaN</procedure></A>(x: T): BOOLEAN =
  VAR xx := LOOPHOLE (x, LongRealRep.T);
  BEGIN
    RETURN (xx.sign # 0) AND (xx.exponent = 0);
  END IsNaN;

PROCEDURE <A NAME="Sign"><procedure>Sign</procedure></A>(x: T): [0..1] =
  VAR xx := LOOPHOLE (x, LongRealRep.T);
  BEGIN
    RETURN xx.sign;
  END Sign;

PROCEDURE <A NAME="Differs"><procedure>Differs</procedure></A>(x, y: T): BOOLEAN =
  BEGIN
    RETURN (NOT (IsNaN (x) OR IsNaN (y))) AND (x # y);
  END Differs;

PROCEDURE <A NAME="Unordered"><procedure>Unordered</procedure></A>(x, y: T): BOOLEAN =
  BEGIN
    RETURN IsNaN (x) OR IsNaN (y);
  END Unordered;

PROCEDURE <A NAME="Sqrt"><procedure>Sqrt</procedure></A>(x: T): T =
  BEGIN
    RETURN FPU.sqrt (x);
  END Sqrt;

PROCEDURE <A NAME="Class"><procedure>Class</procedure></A>(x: T): IEEEClass =
  BEGIN
    IF IsNaN (x) THEN
      RETURN IEEEClass.SignalingNaN;
    ELSIF (x = 0.0d+0) THEN
      RETURN IEEEClass.Zero;
    ELSE
      RETURN IEEEClass.Normal;
    END;
  END Class;

PROCEDURE <A NAME="FromDecimal"><procedure>FromDecimal</procedure></A>(
            sign: [0..1]; READONLY digits: ARRAY OF [0..9]; exp: INTEGER): T =
  &lt;*FATAL Convert.Failed*&gt;
  TYPE CharBuf = UNTRACED REF ARRAY OF Ctypes.char;
  CONST Sign = ARRAY [0..1] OF Ctypes.char { ORD ('+'), ORD ('-') };
  VAR
    ebuf: ARRAY [0..Word.Size] OF CHAR;
    buf: CharBuf;
    expLen, len: CARDINAL;
    res: T;
  BEGIN
    (* strategy:  build a C-style null terminated string and
       call the C runtime library to convert it to binary value. *)

    (* Allocate the buffer to hold the digits, the exponent value, and the
       four characters: 1) the leading sign, 2) the decimal point, 3) the 'e'
       character, and 4) the terminating 0 character. *)
    IF exp # 0 THEN expLen := Convert.FromInt(ebuf, exp) END;
    buf := NEW(CharBuf, NUMBER(digits) + expLen + 4);
    buf[0] := Sign [sign];              len := 1;
    buf[len] := ORD('0') + digits[0];   INC(len);
    buf[len] := ORD('.');               INC(len);
    FOR i := FIRST(digits) + 1 TO LAST(digits) DO
      buf[len] := ORD ('0') + digits [i];  INC (len);
    END;
    IF exp # 0 THEN
      buf[len] := ORD ('e');  INC (len);
      FOR i := 0 TO expLen - 1 DO
	buf[len] := ORD (ebuf[i]);  INC (len);
      END
    END;
    buf[len] := 0;

    res := FLOAT (DragonT.strtod (ADR(buf[0]), NIL), T);
    DISPOSE(buf);
    RETURN res
  END FromDecimal;

PROCEDURE <A NAME="ToDecimal"><procedure>ToDecimal</procedure></A>(x: T): DecimalApprox =
  VAR
    xx := LOOPHOLE (x, LongRealRep.T);
    res: DecimalApprox;
    exp, sig0, sig1: INTEGER;
    count: CARDINAL;
  BEGIN
    res.class := Class (x);
    res.sign := Sign (x);

    IF (res.class # IEEEClass.Denormal) AND (res.class # IEEEClass.Normal) THEN
      RETURN res;
    END;

    exp  := xx.exponent - LongRealRep.ExponentBias;

    sig0 := Word.Shift (Word.Extract (xx.fraction2, 0, 12), 16)
                + xx.fraction3;

    sig1 := Word.Extract (xx.fraction2, 12, 4)
                + Word.Shift (xx.fraction1, 4)
                + Word.Shift (xx.fraction0, 20)
                + 16_8000000;

    DragonT.F (exp, sig1, sig0, 56, DragonT.CutoffMode.normal, 0,
                 res.digits, count, res.exp);
    res.len := count;
    res.errorSign := 0;
    RETURN res;
  END ToDecimal;

BEGIN
END LongFloat.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface FPU is in:
</A><UL>
<LI><A HREF="../DS3100/FPU.i3#0TOP0">float/src/DS3100/FPU.i3</A>
<LI><A HREF="../IEEE-default/FPU.i3#0TOP0">float/src/IEEE-default/FPU.i3</A>
<LI><A HREF="../IRIX5/FPU.i3#0TOP0">float/src/IRIX5/FPU.i3</A>
<LI><A HREF="../SOLsun/FPU.i3#0TOP0">float/src/SOLsun/FPU.i3</A>
<LI><A HREF="../SPARC/FPU.i3#0TOP0">float/src/SPARC/FPU.i3</A>
<LI><A HREF="../SUN386/FPU.i3#0TOP0">float/src/SUN386/FPU.i3</A>
<LI><A HREF="FPU.i3#0TOP0">float/src/VAX/FPU.i3</A>
</UL>
<P>
<HR>
<A NAME="x2">interface LongRealRep is in:
</A><UL>
<LI><A HREF="../IEEE-be/LongRealRep.i3#0TOP0">float/src/IEEE-be/LongRealRep.i3</A>
<LI><A HREF="../IEEE-le/LongRealRep.i3#0TOP0">float/src/IEEE-le/LongRealRep.i3</A>
<LI><A HREF="LongRealRep.i3#0TOP0">float/src/VAX/LongRealRep.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
