<HTML>
<HEAD>
<TITLE>SRC Modula-3: fmtlex/src/Fmt.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>fmtlex/src/Fmt.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> The <CODE>Fmt</CODE> interface provides procedures for formatting numbers and
   other data as text.
   \index{writing formatted data}
   \index{formatted data!writing}


<P><PRE>INTERFACE <interface><A HREF="Fmt.m3">Fmt</A></interface>;

IMPORT <A HREF="../../word/src/Word.i3">Word</A>, <A HREF="#x1">Real</A> AS R, <A HREF="#x2">LongReal</A> AS LR, <A HREF="#x3">Extended</A> AS ER;

PROCEDURE <A HREF="Fmt.m3#Bool">Bool</A>(b: BOOLEAN): TEXT;
</PRE><BLOCKQUOTE><EM> Format <CODE>b</CODE> as {\tt "TRUE"} or  {\tt "FALSE"}. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Fmt.m3#Char">Char</A>(c: CHAR): TEXT;
</PRE><BLOCKQUOTE><EM> Return a text containing the character <CODE>c</CODE>. </EM></BLOCKQUOTE><PRE>

TYPE Base = [2..16];

PROCEDURE <A HREF="Fmt.m3#Int">Int</A>(n: INTEGER; base: Base := 10): TEXT;
PROCEDURE <A HREF="Fmt.m3#Unsigned">Unsigned</A>(n: Word.T; base: Base := 16): TEXT;
</PRE><BLOCKQUOTE><EM> Format the signed or unsigned number <CODE>n</CODE> in the specified base. </EM></BLOCKQUOTE><PRE>
</PRE> The value returned by <CODE>Int</CODE> or <CODE>Unsigned</CODE> never contains upper-case
   letters, and it never starts with an explicit base and underscore.
   For example, to render an unsigned number <CODE>N</CODE> in hexadecimal as a
   legal Modula-3 literal, you must write something like:
<PRE>
      &quot;16_&quot; &amp; Fmt.Unsigned(N, 16)


<P><PRE>TYPE Style = {Sci, Fix, Auto};

PROCEDURE <A HREF="Fmt.m3#Real">Real</A>(
    x: REAL;
    style := Style.Auto;
    prec: CARDINAL := R.MaxSignifDigits - 1;
    literal := FALSE)
  : TEXT;
PROCEDURE <A HREF="Fmt.m3#LongReal">LongReal</A>(
    x: LONGREAL;
    style := Style.Auto;
    prec: CARDINAL := LR.MaxSignifDigits - 1;
    literal := FALSE)
  : TEXT;
PROCEDURE <A HREF="Fmt.m3#Extended">Extended</A>(
    x: EXTENDED;
    style := Style.Auto;
    prec: CARDINAL := ER.MaxSignifDigits - 1;
    literal := FALSE)
  : TEXT;
</PRE><BLOCKQUOTE><EM> Format the floating-point number <CODE>x</CODE>. </EM></BLOCKQUOTE><PRE>
</PRE><P>
<P>
\paragraph*{Overview.}
<P>
   <CODE>Style.Sci</CODE> gives scientific notation with fields padded to fixed
   widths, suitable for making a table.  The parameter <CODE>prec</CODE>
   specifies the number of digits after the decimal point---that is,
   the relative precision.
   \index{scientific notation}
<P>
   <CODE>Style.Fix</CODE> gives fixed point, with <CODE>prec</CODE> once again specifying
   the number of digits after the decimal point---in this case, the
   absolute precision.  The results of <CODE>Style.Fix</CODE> have varying
   widths, but they will form a table if they are right-aligned (using
   <CODE>Fmt.Pad</CODE>) in a sufficiently wide field.
   \index{fixed-point notation}
<P>
   <CODE>Style.Auto</CODE> is not intended for tables.  It gives scientific
   notation with at most <CODE>prec</CODE> digits after the decimal point for
   numbers that are very big or very small.  There may be fewer than
   <CODE>prec</CODE> digits after the decimal point because trailing zeros are
   suppressed.  For numbers that are neither too big nor too small, it
   formats the same significant digits---at most <CODE>prec+1</CODE> of them---in
   fixed point, for greater legibility.
<P>
   All styles omit the decimal point unless it is followed by at least
   one digit.
<P>
   Setting <CODE>literal</CODE> to <CODE>TRUE</CODE> alters all styles as necessary to make
   the result a legal Modula-3 literal of the appropriate type.
<P>
<P>
\paragraph*{Accuracy.}
<P>
   As discussed in the <CODE>Float</CODE> interface, the call <CODE>ToDecimal(x)</CODE>
   converts <CODE>x</CODE> to a floating-decimal number with automatic precision
   control~\cite{Steele,Gay}: Just enough digits are retained to
   distinguish <CODE>x</CODE> from other values of type <CODE>T</CODE>, which implies that
   at most <CODE>T.MaxSignifDigits</CODE> are retained.  The <CODE>Real</CODE>, <CODE>LongReal</CODE>,
   and <CODE>Extended</CODE> procedures format those digits as an appropriate
   string of characters.  If the precision requested by <CODE>prec</CODE> is
   higher than the automatic precision provided by <CODE>ToDecimal(x)</CODE>,
   they append trailing zeros.  If the precision requested by <CODE>prec</CODE>
   is lower, they round <CODE>ToDecimal(x)</CODE> as necessary, obeying the
   current rounding mode.  Because they exploit the <CODE>errorSign</CODE> field
   of the record <CODE>ToDecimal(x)</CODE> in doing this rounding, they get the
   same result that rounding <CODE>x</CODE> itself would give.
<P>
   As a consequence, setting <CODE>prec</CODE> higher than <CODE>T.MaxSignifDigits-1</CODE>
   in <CODE>Style.Sci</CODE> isn't very useful: The trailing digits of all of the
   resulting numbers will be zero.  Setting <CODE>prec</CODE> higher than
   <CODE>T.MaxSignifDigits-1</CODE> in <CODE>Style.Auto</CODE> actually has no effect at
   all, since trailing zeros are suppressed.
<P>
<P>
\paragraph*{Details.}
<P>
   We restrict ourselves at first to those cases where <CODE>Class(x)</CODE> is
   either <CODE>Normal</CODE> or <CODE>Denormal</CODE>.
<P>
   In those cases, <CODE>Style.Sci</CODE> returns: a minus sign or blank, the
   leading nonzero digit of <CODE>x</CODE>, a decimal point, <CODE>prec</CODE> more digits
   of <CODE>x</CODE>, a character <CODE>'e'</CODE>, a minus sign or plus sign, and
   <CODE>T.MaxExpDigits</CODE> of exponent (with leading zeros as necessary).
   When <CODE>prec</CODE> is zero, the decimal point is omitted.
<P>
   <CODE>Style.Fix</CODE> returns: a minus sign if necessary, one or more digits,
   a decimal point, and <CODE>prec</CODE> more digits---never any blanks.  When
   <CODE>prec</CODE> is zero, the decimal point is omitted.
<P>
   <CODE>Style.Auto</CODE> first formats <CODE>x</CODE> as in <CODE>Style.Sci</CODE>, using scientific
   notation with <CODE>prec</CODE> digits after the decimal point.  Call this
   intermediate result <CODE>R</CODE>.
<P>
   If the exponent of <CODE>R</CODE> is at least <CODE>6</CODE> in magnitude, <CODE>Style.Auto</CODE>
   leaves <CODE>R</CODE> in scientific notation, but condenses it by omitting all
   blanks, plus signs, trailing zero digits, and leading zeros in the
   exponent.  If this leaves no digits after the decimal point, the
   decimal point itself is omitted.
<P>
   If the exponent of <CODE>R</CODE> is at most <CODE>5</CODE> in magnitude, <CODE>Style.Auto</CODE>
   reformats the digits of <CODE>R</CODE> in fixed point, first deleting any
   trailing zeros and then adding leading or trailing zeros as
   necessary to bridge the gap from the digits of <CODE>R</CODE> to the unit's
   place.
<P>
   For example, assuming the current rounding mode is <CODE>NearestElseEven</CODE>:
<P>
<PRE>
      Fmt.Real(1.287e6,  Style.Auto, prec := 2) = &quot;1.29e6&quot;
      Fmt.Real(1.297e6,  Style.Auto, prec := 2) = &quot;1.3e6&quot;
      Fmt.Real(1.297e5,  Style.Auto, prec := 2) = &quot;130000&quot;
      Fmt.Real(1.297e-5, Style.Auto, prec := 2) = &quot;0.000013&quot;
      Fmt.Real(1.297e-6, Style.Auto, prec := 2) = &quot;1.3e-6&quot;
      Fmt.Real(9.997e5,  Style.Auto, prec := 2) = &quot;1e6&quot;
      Fmt.Real(9.997e-6, Style.Auto, prec := 2) = &quot;0.00001&quot;
</PRE>
   <CODE>Style.Sci</CODE> handles zero by replacing the entire exponent field by
   blanks, for example: {\tt " 0.00    "}.  <CODE>Style.Fix</CODE> renders zero
   with all digits zero; for example, <CODE>"0.00"</CODE>.
   <CODE>Style.Auto</CODE> renders zero as <CODE>"0"</CODE>.  On IEEE
   implementations, the value minus zero is rendered as a negative
   number.
<P>
   Also on IEEE implementations, <CODE>Style.Sci</CODE> formats infinities or
   NaN's with a minus sign or blank, the string <CODE>"Infinity"</CODE> or <CODE>"NaN"</CODE>, and enough trailing
   blanks to get the correct overall width.  <CODE>Style.Fix</CODE> and
   <CODE>Style.Auto</CODE> omit the blanks.  In <CODE>Style.Sci</CODE>, if <CODE>"Infinity"</CODE> doesn't fit, <CODE>"Inf"</CODE> is used
   instead.
<P>
   Setting <CODE>literal</CODE> to <CODE>TRUE</CODE> alters things as follows: Numbers that
   are rendered without a decimal point when <CODE>literal</CODE> is <CODE>FALSE</CODE> have
   a decimal point and one trailing zero appended to their digits.
   For the routines <CODE>Fmt.LongReal</CODE> and <CODE>Fmt.Extended</CODE>, an exponent
   field of <CODE>d0</CODE> or <CODE>x0</CODE> is appended to numbers in fixed point and
   <CODE>'d'</CODE> or <CODE>'x'</CODE> is used, rather than <CODE>'e'</CODE>, to introduce the
   exponents of numbers in scientific notation.  On IEEE
   implementations, the string <CODE>"Infinity"</CODE> is
   replaced by <CODE>"1.0/0.0"</CODE>, <CODE>"1.0d0/0.0d0"</CODE>, or <CODE>"1.0x0/0.0x0"</CODE> as
   appropriate, and <CODE>"NaN"</CODE> is similarly replaced by
   a representation of the quotient <CODE>0/0</CODE>.  (Unfortunately, these
   quotient strings are so long that they may ruin the formatting of
   <CODE>Style.Sci</CODE> tables when <CODE>prec</CODE> is small and <CODE>literal</CODE> is <CODE>TRUE</CODE>.)
<P>


<P><PRE>TYPE Align = {Left, Right};

PROCEDURE <A HREF="Fmt.m3#Pad">Pad</A>(
    text: TEXT;
    length: CARDINAL;
    padChar: CHAR := ' ';
    align: Align := Align.Right): TEXT;
</PRE><BLOCKQUOTE><EM> If <CODE>Text.Length(text) &gt;= length</CODE>, then <CODE>text</CODE> is returned
   unchanged.  Otherwise, <CODE>text</CODE> is padded with <CODE>padChar</CODE> until it has
   the given <CODE>length</CODE>.  The text goes to the right or left, according
   to <CODE>align</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Fmt.m3#F">F</A>(fmt: TEXT; t1, t2, t3, t4, t5: TEXT := NIL)
  : TEXT;
</PRE><BLOCKQUOTE><EM> Uses <CODE>fmt</CODE> as a format string. The result is a copy of <CODE>fmt</CODE> in
   which all format specifiers have been replaced, in order, by the
   text arguments <CODE>t1</CODE>, <CODE>t2</CODE>, etc. </EM></BLOCKQUOTE><PRE>
</PRE> A format specifier contains a field width, alignment and one of two
   padding characters. The procedure <CODE>F</CODE> evaluates the specifier and
   replaces it by the corresponding text argument padded as it would
   be by a call to <CODE>Pad</CODE> with the specified field width, padding
   character and alignment.
<P>
   The syntax of a format specifier is:
<PRE>
      %[-]{0-9}s
   </PRE>
that is, a percent character followed by an optional minus sign, an
   optional number and a compulsory terminating <CODE>s</CODE>.
<P>
   If the minus sign is present the alignment is <CODE>Align.Left</CODE>,
   otherwise it is <CODE>Align.Right</CODE>. The alignment corresponds to the
   <CODE>align</CODE> argument to <CODE>Pad</CODE>.
<P>
   The number specifies the field width (this corresponds to the
   <CODE>length</CODE> argument to <CODE>Pad</CODE>). If the number is omitted it defaults
   to zero.
<P>
   If the number is present and starts with the digit <CODE>0</CODE> the padding character
   is <CODE>'0'</CODE>; otherwise it is the space character. The padding character
   corresponds to the <CODE>padChar</CODE> argument to <CODE>Pad</CODE>.
<P>
   It is a checked runtime error if <CODE>fmt</CODE> is <CODE>NIL</CODE> or the number of
   format specifiers in <CODE>fmt</CODE> is not equal to the number of non-nil
   arguments to <CODE>F</CODE>.
<P>
   Non-nil arguments to <CODE>F</CODE> must precede any <CODE>NIL</CODE> arguments; it is a
   checked runtime error if they do not.
<P>
   If <CODE>t1</CODE> to <CODE>t5</CODE> are all <CODE>NIL</CODE> and <CODE>fmt</CODE> contains no format
   specifiers, the result is <CODE>fmt</CODE>.
<P>
   Examples:
<PRE>
      F(&quot;%s %s\n&quot;, &quot;Hello&quot;, &quot;World&quot;) <KBD>returns</KBD> &quot;Hello World\n&quot;.
      F(&quot;%s&quot;, Int(3))                <KBD>returns</KBD> &quot;3&quot;
      F(&quot;%2s&quot;, Int(3))               <KBD>returns</KBD> &quot; 3&quot;
      F(&quot;%-2s&quot;, Int(3))              <KBD>returns</KBD> &quot;3 &quot;
      F(&quot;%02s&quot;, Int(3))              <KBD>returns</KBD> &quot;03&quot;
      F(&quot;%-02s&quot;, Int(3))             <KBD>returns</KBD> &quot;30&quot;
      F(&quot;%s&quot;, &quot;%s&quot;)                  <KBD>returns</KBD> &quot;%s&quot;
      F(&quot;%s% tax&quot;, Int(3))           <KBD>returns</KBD> &quot;3% tax&quot;
</PRE>
   The following examples are legal but pointless:
<PRE>
      F(&quot;%-s&quot;, Int(3))               <KBD>returns</KBD> &quot;3&quot;
      F(&quot;%0s&quot;, Int(3))               <KBD>returns</KBD> &quot;3&quot;
      F(&quot;%-0s&quot;, Int(3))              <KBD>returns</KBD> &quot;3&quot;


<P><PRE>PROCEDURE <A HREF="Fmt.m3#FN">FN</A>(fmt: TEXT; READONLY texts: ARRAY OF TEXT)
  : TEXT;
</PRE><BLOCKQUOTE><EM> Similar to <CODE>F</CODE> but accepts an array of text arguments. It is a
   checked runtime error if the number of format specifiers in <CODE>fmt</CODE>
   is not equal to <CODE>NUMBER(texts)</CODE> or if any element of <CODE>texts</CODE> is
   <CODE>NIL</CODE>. If <CODE>NUMBER(texts) = 0</CODE> and <CODE>fmt</CODE> contains no format
   specifiers the result is <CODE>fmt</CODE>. </EM></BLOCKQUOTE><PRE>
</PRE> Example:
<P>
<PRE>
      FN(&quot;%s %s %s %s %s %s %s&quot;,
        ARRAY OF TEXT{&quot;Too&quot;, &quot;many&quot;, &quot;arguments&quot;,
          &quot;for&quot;, &quot;F&quot;, &quot;to&quot;, &quot;handle&quot;})
</PRE>
   returns {\tt "Too many arguments for F to handle"}.


<P><PRE>END Fmt.

&lt;*PRAGMA SPEC *&gt;

&lt;*SPEC Bool(b)                           ENSURES RES # NIL *&gt;
&lt;*SPEC Char(c)                           ENSURES RES # NIL *&gt;
&lt;*SPEC Int(n, base)                      ENSURES RES # NIL *&gt;
&lt;*SPEC Unsigned(n, base)                 ENSURES RES # NIL *&gt;
&lt;*SPEC Real(x, style, prec, literal)     ENSURES RES # NIL *&gt;
&lt;*SPEC LongReal(x, style, prec, literal) ENSURES RES # NIL *&gt;
&lt;*SPEC Extended(x, style, prec, literal) ENSURES RES # NIL *&gt;
</PRE>
</inInterface>
<HR>
<A NAME="x1">interface Real is in:
</A><UL>
<LI><A HREF="../../float/src/IEEE/Real.i3#0TOP0">float/src/IEEE/Real.i3</A>
<LI><A HREF="../../float/src/VAX/Real.i3#0TOP0">float/src/VAX/Real.i3</A>
</UL>
<P>
<HR>
<A NAME="x2">interface LongReal is in:
</A><UL>
<LI><A HREF="../../float/src/IEEE/LongReal.i3#0TOP0">float/src/IEEE/LongReal.i3</A>
<LI><A HREF="../../float/src/VAX/LongReal.i3#0TOP0">float/src/VAX/LongReal.i3</A>
</UL>
<P>
<HR>
<A NAME="x3">interface Extended is in:
</A><UL>
<LI><A HREF="../../float/src/IEEE/Extended.i3#0TOP0">float/src/IEEE/Extended.i3</A>
<LI><A HREF="../../float/src/VAX/Extended.i3#0TOP0">float/src/VAX/Extended.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
