<HTML>
<HEAD>
<TITLE>SRC Modula-3: fmtlex/src/FmtBuf.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>fmtlex/src/FmtBuf.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                             </EM></BLOCKQUOTE><PRE>

MODULE <module>FmtBuf</module> EXPORTS <A HREF="FmtBuf.i3"><implements>FmtBuf</A></implements>, <A HREF="FmtBufF.i3"><implements>FmtBufF</A></implements>, <A HREF="FmtBufTest.i3"><implements>FmtBufTest</A></implements>;

IMPORT <A HREF="../../text/src/Text.i3">Text</A>, <A HREF="../../text/src/TextF.i3">TextF</A>, <A HREF="../../word/src/Word.i3">Word</A>, <A HREF="../../convert/src/Convert.i3">Convert</A>, <A HREF="#x1">FloatMode</A>, <A HREF="../../os/src/Common/Process.i3">Process</A>;
IMPORT <A HREF="#x2">Real</A> AS R, <A HREF="#x3">LongReal</A> AS LR, <A HREF="#x4">Extended</A> AS ER;
IMPORT <A HREF="../../float/src/Common/RealFloat.i3">RealFloat</A>, <A HREF="../../float/src/Common/LongFloat.i3">LongFloat</A>, <A HREF="../../float/src/Common/ExtendedFloat.i3">ExtendedFloat</A>;

PROCEDURE <A NAME="Int"><procedure>Int</procedure></A>(VAR (*INOUT*) b: T; n: INTEGER; base: Base := 10): CARDINAL =
  &lt;* FATAL Convert.Failed *&gt;
  BEGIN
    RETURN Convert.FromInt(b, n, base, prefix := FALSE)
  END Int;

PROCEDURE <A NAME="Unsigned"><procedure>Unsigned</procedure></A>(VAR (*INOUT*) b: T; n: Word.T; base: Base := 16): CARDINAL =
  &lt;* FATAL Convert.Failed *&gt;
  BEGIN
    RETURN Convert.FromUnsigned(b, n, base, prefix := FALSE)
  END Unsigned;
</PRE> Floating-point values --------------------------------------------------- 

<P><PRE>PROCEDURE <A NAME="Real"><procedure>Real</procedure></A>(
    VAR (*INOUT*) b: T;
    x: REAL;
    style := Style.Auto;
    prec: CARDINAL := R.MaxSignifDigits - 1;
    literal := FALSE)
  : CARDINAL =
  VAR da := RealFloat.ToDecimal(x); num: NumAttr; BEGIN
    num.class := ClassMapReal[da.class];
    num.kind := IEEEKind.Single;
    num.maxExpDigits := R.MaxExpDigits;
    num.sign := da.sign;
    IF num.class = Class.Number THEN
      num.len := da.len;
      num.exp := da.exp;
      num.errorSign := da.errorSign
    END;
    RETURN Float(b, num, da.digits, FmtRec{style, prec, literal})
  END Real;

PROCEDURE <A NAME="LongReal"><procedure>LongReal</procedure></A>(
    VAR (*INOUT*) b: T;
    x: LONGREAL;
    style := Style.Auto;
    prec: CARDINAL := LR.MaxSignifDigits - 1;
    literal := FALSE)
  : CARDINAL =
  VAR da := LongFloat.ToDecimal(x); num: NumAttr; BEGIN
    num.class := ClassMapLong[da.class];
    num.kind := IEEEKind.Double;
    num.maxExpDigits := LR.MaxExpDigits;
    num.sign := da.sign;
    IF num.class = Class.Number THEN
      num.len := da.len;
      num.exp := da.exp;
      num.errorSign := da.errorSign
    END;
    RETURN Float(b, num, da.digits, FmtRec{style, prec, literal})
  END LongReal;

PROCEDURE <A NAME="Extended"><procedure>Extended</procedure></A>(
    VAR (*INOUT*) b: T;
    x: EXTENDED;
    style := Style.Auto;
    prec: CARDINAL := ER.MaxSignifDigits - 1;
    literal := FALSE)
  : CARDINAL =
  VAR da := ExtendedFloat.ToDecimal(x); num: NumAttr; BEGIN
    num.class := ClassMapExtd[da.class];
    num.kind := IEEEKind.Extended;
    num.maxExpDigits := ER.MaxExpDigits;
    num.sign := da.sign;
    IF num.class = Class.Number THEN
      num.len := da.len;
      num.exp := da.exp;
      num.errorSign := da.errorSign
    END;
    RETURN Float(b, num, da.digits, FmtRec{style, prec, literal})
  END Extended;
</PRE> The different styles have the following formats, where:
<P>
<PRE>
       &quot;D&quot; represents a digit,
       &quot;PP***P&quot; represents a total of &quot;prec&quot; digits,
       &quot;XX***X&quot; represents a total of T.MaxExpDigits for floating-point type &quot;T&quot;,
       &quot;DD***D&quot; represents a total of &quot;whole&quot; digits
</PRE>
<PRE>
       Style.Sci: (-| )D.PP***Pe(+|-)XX***X   width = prec + T.MaxExpDigits + 5
       Style.Fix: [-]DD***D.PP***P            width = prec + whole + 1 [ + 1 ]
</PRE>
   <CODE>Style.Auto</CODE> has either the <CODE>Style.Sci</CODE> or the <CODE>Style.Fix</CODE> format,
   depending on the magnitude of the number. In both cases, if <CODE>prec = 0</CODE>, the
   decimal point is dropped (unless the number is being rendered as a Modula-3
   literal, in which case the decimal is not dropped and an extra zero is
   added after the decimal). 

<P><PRE>PROCEDURE <A NAME="Float"><procedure>Float</procedure></A>(
    VAR (*OUT*) b: T;
    READONLY num: NumAttr;
    VAR (*IN*) digits: Digits;
    READONLY fmt: FmtRec)
  : CARDINAL =
  BEGIN
    CASE num.class OF
      Class.NaN =&gt; RETURN NaN(b, num, fmt)
    | Class.Inf =&gt; RETURN Inf(b, num, fmt)
    | Class.Zero =&gt; RETURN Zero(b, num, fmt)
    | Class.Number =&gt; RETURN Number(b, num, digits, fmt)
    END
  END Float;

PROCEDURE <A NAME="SciWidth"><procedure>SciWidth</procedure></A>(READONLY fmt: FmtRec; maxExpDigits: CARDINAL): CARDINAL =
</PRE><BLOCKQUOTE><EM> Return the width of a number formated for <CODE>Style.Sci</CODE> with <CODE>fmt.prec</CODE>
   digits of precision and <CODE>maxExpDigits</CODE> in the exponent. If <CODE>fmt.prec = 0</CODE>,
   the decimal is dropped unless <CODE>fmt.literal = TRUE</CODE> </EM></BLOCKQUOTE><PRE>
  VAR res: CARDINAL := fmt.prec + maxExpDigits + 5; BEGIN
    IF fmt.prec = 0 THEN
      IF fmt.literal
        THEN INC(res)			 (* include extra '0' after '.' *)
        ELSE DEC(res)			 (* don't include '.' *)
      END
    END;
    RETURN res
  END SciWidth;

TYPE
  KindValues = ARRAY IEEEKind OF TEXT;
  TwoKindValues = ARRAY [0..1] OF KindValues;

CONST
  LitSpecials = TwoKindValues{
    KindValues{&quot;0.0/0.0&quot;, &quot;0.0d0/0.0d0&quot;, &quot;0.0x0/0.0x0&quot;},
    KindValues{&quot;1.0/0.0&quot;, &quot;1.0d0/0.0d0&quot;, &quot;1.0x0/0.0x0&quot;}};

PROCEDURE <A NAME="NaN"><procedure>NaN</procedure></A>(VAR (*OUT*) b: T; READONLY num: NumAttr; READONLY fmt: FmtRec)
  : CARDINAL =
  VAR str: TEXT; BEGIN
    IF fmt.literal
      THEN str := LitSpecials[0, num.kind]
      ELSE str := &quot;NaN&quot;
    END;
    RETURN Special(b, num, fmt, str)
  END NaN;

PROCEDURE <A NAME="Inf"><procedure>Inf</procedure></A>(VAR (*OUT*) b: T; READONLY num: NumAttr; READONLY fmt: FmtRec)
  : CARDINAL =
  VAR str: TEXT; truncate: BOOLEAN; BEGIN
    IF fmt.literal
      THEN str := LitSpecials[1, num.kind]; truncate := FALSE
      ELSE str := &quot;Infinity&quot;; truncate := TRUE
    END;
    RETURN Special(b, num, fmt, str, truncate := truncate)
  END Inf;

PROCEDURE <A NAME="Special"><procedure>Special</procedure></A>(
    VAR (*INOUT*) b: T;
    READONLY num: NumAttr;
    READONLY fmt: FmtRec;
    str: TEXT;
    truncate := FALSE)
  : CARDINAL =
</PRE><BLOCKQUOTE><EM> Format the string <CODE>str</CODE> into the buffer <CODE>b</CODE>, and return the number of
   characters inserted. If <CODE>fmt.style</CODE> is not <CODE>Style.Sci</CODE>, then the result is
   either <CODE>str</CODE> or <CODE>-str</CODE> as <CODE>num.sign</CODE> is 0 or 1, respectively. If
   <CODE>fmt.style</CODE> is <CODE>Style.Sci</CODE>, the result is the concatenation of a space or
   minus sign and <CODE>str</CODE> followed by sufficient space characters to pad the
   result to overall width for scientific notation formatting according to
   <CODE>num.maxExpDigits</CODE>, <CODE>fmt.prec</CODE>, and <CODE>fmt.literal</CODE>. If the leading space or
   minus sign followed by <CODE>str</CODE> does not fit in this width and <CODE>truncate</CODE> is
   <CODE>TRUE</CODE>, then <CODE>str</CODE> is first truncated to 3 characters. </EM></BLOCKQUOTE><PRE>

  PROCEDURE AppendBlanks(
      VAR (*INOUT*) b: T;
      VAR (*INOUT*) pos: CARDINAL;
      num: CARDINAL) =
  (* Append &quot;num&quot; blanks to &quot;b&quot; starting at &quot;pos&quot;. Requires &quot;num &gt; 0&quot;. *)
    CONST
      BlanksLen = 20;
      Blanks = ARRAY [0..BlanksLen-1] OF CHAR{' ', ..};
    VAR toGo := num; copyCnt: CARDINAL; BEGIN
      &lt;* ASSERT num &gt; 0 *&gt;
      REPEAT
        copyCnt := MIN(toGo, BlanksLen);
        SUBARRAY(b, pos, copyCnt) := SUBARRAY(Blanks, 0, copyCnt);
        DEC(toGo, copyCnt); INC(pos, copyCnt)
      UNTIL toGo = 0
    END AppendBlanks;

  (* Special *)
  VAR res: CARDINAL; BEGIN
    CASE fmt.style OF
      Style.Fix, Style.Auto =&gt;
        VAR strLen := Text.Length(str); BEGIN
          res := num.sign;
          IF res = 1 THEN b[0] := '-' END;
          SUBARRAY(b, res, strLen) := SUBARRAY(str^, 0, strLen);
          INC(res, strLen)
        END
    | Style.Sci =&gt;
        IF num.sign = 0
          THEN b[0] := ' '
          ELSE b[0] := '-'
        END;
        VAR
          name: TEXT; nmLen: CARDINAL;
          strLen := Text.Length(str);
          sciWidth := SciWidth(fmt, num.maxExpDigits);
        BEGIN
          IF strLen &gt;= sciWidth AND truncate
            THEN name := Text.Sub(str, 0, 3); nmLen := 3
            ELSE name := str; nmLen := strLen
          END;
          SUBARRAY(b, 1, nmLen) := SUBARRAY(name^, 0, nmLen);
          res := 1 + nmLen;
          WITH num = sciWidth - res DO
            IF num &gt; 0 THEN AppendBlanks(b, res, num) END
          END
        END
    END;
    RETURN res
  END Special;

CONST
  SignChar = ARRAY [0..1] OF CHAR{ ' ', '-' };
  ExpChar = ARRAY IEEEKind OF CHAR{ 'e', 'd', 'x' };
  MaxExpDigits = MAX(R.MaxExpDigits, MAX(LR.MaxExpDigits, ER.MaxExpDigits));

PROCEDURE <A NAME="AppendZeros"><procedure>AppendZeros</procedure></A>(
    VAR (*INOUT*) b: T;
    VAR (*INOUT*) pos: CARDINAL;
    num: CARDINAL) =
</PRE><BLOCKQUOTE><EM> Append <CODE>num</CODE> zero characters ('0') to <CODE>b</CODE> starting at <CODE>pos</CODE>, and advance
   <CODE>pos</CODE> by <CODE>num</CODE>. Requires <CODE>num &gt; 0</CODE>. </EM></BLOCKQUOTE><PRE>
  CONST
    ZerosLen = 20;
    Zeros = ARRAY [0..ZerosLen-1] OF CHAR{'0', ..};
  VAR toGo := num; copyCnt: CARDINAL; BEGIN
    &lt;* ASSERT num &gt; 0 *&gt;
    REPEAT
      copyCnt := MIN(toGo, ZerosLen);
      SUBARRAY(b, pos, copyCnt) := SUBARRAY(Zeros, 0, copyCnt);
      DEC(toGo, copyCnt); INC(pos, copyCnt)
    UNTIL toGo = 0
  END AppendZeros;

PROCEDURE <A NAME="Zero"><procedure>Zero</procedure></A>(VAR (*OUT*) b: T; READONLY num: NumAttr; READONLY fmt: FmtRec)
  : CARDINAL =
  VAR res: CARDINAL; fullPrec: CARDINAL; BEGIN
    IF fmt.prec = 0 AND fmt.literal
      THEN fullPrec := 1
      ELSE fullPrec := fmt.prec
    END;
    CASE fmt.style OF
      Style.Sci =&gt;
        b[0] := SignChar[num.sign]; b[1] := '0'; res := 2;
        IF fullPrec &gt; 0 THEN
          b[res] := '.'; INC(res);
          AppendZeros(b, res, fullPrec)
        END;
        IF fmt.literal AND num.kind # IEEEKind.Single THEN
          b[res] := ExpChar[num.kind]; b[res+1] := '0';
          INC(res, 2)
        END;
        CONST Spaces = ARRAY [0..MaxExpDigits+1] OF CHAR{' ', ..};
        VAR cnt := SciWidth(fmt, num.maxExpDigits) - res; BEGIN
          &lt;* ASSERT cnt &gt; 0 *&gt;
          (* &quot;cnt&quot; will be the space for the exponent, which requires 2 +
             &quot;T.MaxExpDigits&quot;. The size of the &quot;Spaces&quot; array guarantees that
             &quot;cnt &lt;= NUMBER(spaces)&quot;. *)
          SUBARRAY(b, res, cnt) := SUBARRAY(Spaces, 0, cnt);
          INC(res, cnt)
        END
    | Style.Fix =&gt;
        IF num.sign = 1 THEN b[0] := '-' END;
        b[num.sign] := '0'; res := num.sign + 1;
        IF fullPrec &gt; 0 THEN
          b[res] := '.'; INC(res);
          AppendZeros(b, res, fullPrec)
        END;
        IF fmt.literal AND num.kind # IEEEKind.Single THEN
          b[res] := ExpChar[num.kind]; b[res+1] := '0';
          INC(res, 2)
        END
    | Style.Auto =&gt;
	CONST
	  LitZero = TwoKindValues{
	    KindValues{ &quot;0.0&quot;,  &quot;0.0d0&quot;,  &quot;0.0x0&quot;},
	    KindValues{&quot;-0.0&quot;, &quot;-0.0d0&quot;, &quot;-0.0x0&quot;}};
	  AutoZero = ARRAY [0..1] OF TEXT{&quot;0&quot;, &quot;-0&quot;};
        VAR str: TEXT; BEGIN
          IF fmt.literal
            THEN str := LitZero[num.sign, num.kind]
            ELSE str := AutoZero[num.sign]
          END;
          res := Text.Length(str);
          SUBARRAY(b, 0, res) := SUBARRAY(str^, 0, res)
        END
    END;
    RETURN res
  END Zero;

PROCEDURE <A NAME="Number"><procedure>Number</procedure></A>(
    VAR (*OUT*) b: T;
    READONLY num: NumAttr;
    VAR (*IN*) digits: Digits;
    READONLY fmt: FmtRec)
  : CARDINAL =
  CONST Zero = ORD('0');
  VAR pos: CARDINAL := 0;

  PROCEDURE FmtNum(len, prec: CARDINAL; shift: INTEGER) =
  (* Write the first &quot;len&quot; digits of &quot;digits&quot; into &quot;b&quot; starting at position
     &quot;pos&quot;, inserting a decimal point between digits &quot;digits[shift-1]&quot; and
     &quot;digits[shift]&quot;. If &quot;shift &lt;= 0&quot;, a suitable number of leading digits are
     written. A total of &quot;prec&quot; digits are written after the decimal point.
     Hence, if &quot;shift &lt;= 0&quot;, only &quot;MAX(0, MIN(len, prec + shift))&quot; of the
     &quot;len&quot; digits are written. If &quot;prec &gt; len - shift&quot;, then a suitable number
     of trailing zeros are written.

     If &quot;prec = 0&quot;, no decimal point is written, unless &quot;fmt.literal&quot; is
     &quot;TRUE&quot;, in which case a decimal and a single &quot;0&quot; are written.

     This procedure increments &quot;pos&quot; by the number of characters written.

     There are 3 cases to consider: the decimal is to the left of the &quot;len&quot;
     digits (i.e., &quot;shift &lt;= 0&quot;), the decimal is between some of these digits
     (i.e., &quot;0 &lt; shift &lt; len&quot;), or it is to the right of the digits (i.e.,
     &quot;len &lt;= shift&quot;). *)

    (* FmtNum *)
    VAR toGo := prec; curr: CARDINAL; BEGIN
      (* Write digits before decimal point: *)
      IF shift &lt;= 0 THEN
        curr := 0;
        b[pos] := '0'; INC(pos)
      ELSE
        curr := MIN(shift, len);
        (* write leading digits *)
        FOR i := 0 TO curr - 1 DO
          b[pos] := VAL(digits[i] + Zero, CHAR); INC(pos)
        END;
        (* write zeros down to units place, if necessary *)
      	IF len &lt; shift THEN AppendZeros(b, pos, shift-len) END
      END;

      (* Handle &quot;prec = 0&quot; case *)
      IF prec = 0 THEN
        IF fmt.literal THEN b[pos] := '.'; b[pos+1] := '0'; INC(pos, 2) END;
        RETURN
      END;

      (* Write decimal point and &quot;prec&quot; digits after it: *)
      b[pos] := '.'; INC(pos);
      IF shift &lt;= 0 THEN
        WITH zeroCnt = MIN(toGo, ABS(shift)) DO
          IF zeroCnt &gt; 0 THEN
            AppendZeros(b, pos, zeroCnt);
            DEC(toGo, zeroCnt)
          END
        END
      END;
      IF shift &lt;= 0 OR shift &lt; len THEN
        WITH digCnt = MIN(toGo, len - curr) DO
          FOR i := curr TO curr + digCnt - 1 DO
            b[pos] := VAL(digits[i] + Zero, CHAR); INC(pos)
          END;
          DEC(toGo, digCnt)
        END
      END;
      IF toGo &gt; 0 THEN AppendZeros(b, pos, toGo) END
    END FmtNum;

  PROCEDURE DelTrailingZeros() =
  (* Requires &quot;pos &gt; 0 AND (E i: 0 &lt;= i &lt; pos: b[i] = '.')&quot;. *)
    BEGIN
      REPEAT DEC(pos) UNTIL b[pos] # '0';
      IF b[pos] = '.' THEN
        IF fmt.literal
          THEN INC(pos); b[pos] := '0'
          ELSE DEC(pos)
        END
      END;
      INC(pos)
    END DelTrailingZeros;

  PROCEDURE FmtExp(exp: INTEGER; auto: BOOLEAN) =
  (* Write the exponent portion of a number in scientific notation to the
     array &quot;b&quot; starting at position &quot;pos&quot;, and increment &quot;pos&quot; by the number
     of characters written. The written characters take the form:
     &quot;e(+|-)XX**X&quot;, where the value of &quot;XX**X&quot; is &quot;exp&quot;, left-padded with
     zeros to have width &quot;num.maxExpChars&quot;. If &quot;fmt.literal&quot; is &quot;TRUE&quot;, then
     the leading character is one of &quot;e&quot;, &quot;d&quot;, or &quot;x&quot; depending on &quot;num.sign&quot;.
     If &quot;auto&quot; is &quot;TRUE&quot;, then the plus sign and leading exponent zeros, if
     any, are dropped. *)
    CONST ExpSignChar = ARRAY [0..1] OF CHAR{ '+', '-' };
    VAR expLen: CARDINAL; expBuf: ARRAY [0..MaxExpDigits-1] OF CHAR; BEGIN
      IF fmt.literal
        THEN b[pos] := ExpChar[num.kind]
        ELSE b[pos] := 'e'
      END;
      INC(pos);
      expLen := Unsigned(expBuf, ABS(exp), base := 10);
      IF auto THEN
        IF exp &lt; 0 THEN b[pos] := '-'; INC(pos) END
      ELSE
        b[pos] := ExpSignChar[ORD(exp &lt; 0)]; INC(pos);
        CONST Zeros = ARRAY [0..MaxExpDigits-1] OF CHAR{'0', ..};
        VAR zLen: INTEGER := num.maxExpDigits - expLen; BEGIN
          (* The size of the &quot;Zeros&quot; array is chosen so as to
             guarantee that &quot;zLen &lt;= NUMBER(Zeros)&quot;. *)
          IF zLen &gt; 0 THEN
            SUBARRAY(b, pos, zLen) := SUBARRAY(Zeros, 0, zLen);
            INC(pos, zLen)
          END
        END
      END;
      SUBARRAY(b, pos, expLen) := SUBARRAY(expBuf, 0, expLen);
      INC(pos, expLen)
    END FmtExp;

  (* Number *)
  VAR carry: BOOLEAN; exp := num.exp; len: INTEGER; BEGIN
    CASE fmt.style OF
      Style.Sci =&gt;
        len := fmt.prec + 1;
        carry := Round(num, digits, len);
        IF carry THEN INC(exp) END;
        b[pos] := SignChar[num.sign]; INC(pos);
        FmtNum(len, prec := fmt.prec, shift := 1);
        FmtExp(exp, auto := FALSE)
    | Style.Fix =&gt;
        len := fmt.prec + 1 + num.exp;
        carry := Round(num, digits, len);
        IF carry THEN INC(exp, 1 + ABS(MIN(0, len))) END;
        IF num.sign = 1 THEN b[pos] := '-'; INC(pos) END;
        FmtNum(len, prec := fmt.prec, shift := 1 + exp);
        IF fmt.literal AND num.kind # IEEEKind.Single THEN
          b[pos] := ExpChar[num.kind]; b[pos+1] := '0'; INC(pos, 2)
        END
    | Style.Auto =&gt;
        len := fmt.prec + 1;
        carry := Round(num, digits, len);
        IF carry THEN INC(exp) END;
        IF num.sign = 1 THEN b[pos] := '-'; INC(pos) END;
        IF ABS(exp) &gt;= 6 THEN
          FmtNum(len, prec := fmt.prec, shift := 1);
          IF fmt.prec &gt; 0 THEN DelTrailingZeros() END;
          FmtExp(exp, auto := TRUE)
        ELSE
          WITH shift = 1 + exp, prec = MAX(fmt.prec, len - shift) DO
            FmtNum(len, prec := prec, shift := shift);
            IF prec &gt; 0 THEN DelTrailingZeros() END
          END;
          IF fmt.literal AND num.kind # IEEEKind.Single THEN
            b[pos] := ExpChar[num.kind]; b[pos+1] := '0'; INC(pos, 2)
          END
        END
    END;
    RETURN pos
  END Number;

PROCEDURE <A NAME="Round"><procedure>Round</procedure></A>(
    READONLY num: NumAttr;
    VAR (*IN*) digits: Digits;
    VAR (*INOUT*) len: INTEGER)
  : BOOLEAN =
</PRE><BLOCKQUOTE><EM> Round the number <CODE>(num, digits)</CODE> to <CODE>len</CODE> digits of precision, modifying
   the digits <CODE>digits</CODE> in place. Requires <CODE>num.len &gt;= 1</CODE>. On exit from this
   procedure, <CODE>len</CODE> is set to the (non-negative) number of digits in <CODE>digits</CODE>
   that are valid, namely:
<P>
<PRE>
         &quot;MIN(MAX(len, ORD(RESULT)), num.len)&quot;
</PRE>
   where <CODE>RESULT</CODE> denotes the Boolean return value. The final value for <CODE>len</CODE>
   can also be expressed by considering two cases:
<P>
<PRE>
         Input len   Output len
         ---------   -----------------
         len &lt;= 0    ORD(RESULT)           (* since num.len &gt;= 1 
</EM></BLOCKQUOTE><PRE>
|    len =&gt; 1    MIN(len, num.len)     (* since ORD(BOOLEAN) &lt;= 1 *)

   If &quot;len &gt;= num.len&quot;, then this procedure does not change &quot;digits&quot;.
   Otherwise, the values &quot;num.sign&quot;, &quot;num.errorSign&quot;, and

|    digits[len], ..., digits[num.len-1]

   (where we define &quot;digits[i] = 0&quot; for &quot;i &lt; 0&quot;), along with the current
   rounding mode, are used to decide if the digits

|    digits[0], ..., digits[len-1]

   taken as an integer, should be incremented. The algorithm used to make this
   determination is described below. If it is decided that the number should
   be incremented and it is all &quot;9&quot;'s (or if it is empty, i.e., &quot;len &lt;= 0&quot;),
   then incrementing it would cause an overflow. In this case, &quot;digits[0]&quot; is
   replaced by a &quot;1&quot;. The procedure returns TRUE iff an overflow resulted due
   to incrementing the digits.

   See the &quot;FmtBufTest&quot; interface for a description of how the &quot;current
   rounding mode&quot; is determined from the global variables &quot;useCurrentRounding&quot;
   and &quot;testRoundingMode&quot;. *)

  PROCEDURE NearestInc(tieBreak: BOOLEAN): BOOLEAN =
  (* Algorithm to decide whether or not to increment in the &quot;NearestElse...&quot;
     rounding mode cases. Returns TRUE iff an increment should be done. If
     &quot;len &lt; 0&quot;, the increment is never done. Otherwise, the value &quot;R&quot; is
     compared to &quot;0.5&quot; as described below. In the event that the decimal
     approximation is exactly half way between the unincremented and
     incremented values (i.e., when &quot;R = 0.5&quot; in the above analysis) and is
     exactly equal to the floating-binary value (i.e., when &quot;num.errorSign =
     0&quot;), the result is given by &quot;tieBreak&quot;. *)
    BEGIN
      IF len &lt; 0 THEN RETURN FALSE END;
      &lt;* ASSERT 0 &lt;= len AND len &lt; num.len AND 1 &lt;= num.len *&gt;
      IF digits[len] &lt; 5 THEN
        RETURN FALSE
      ELSIF digits[len] &gt; 5 THEN
        RETURN TRUE
      ELSE
        VAR i := len + 1; BEGIN
          WHILE i &lt; num.len AND digits[i] = 0 DO INC(i) END;
          IF i &lt; num.len THEN RETURN TRUE END;
        END;
        CASE num.errorSign OF
          -1 =&gt; RETURN FALSE
        |  0 =&gt; RETURN tieBreak
        | +1 =&gt; RETURN TRUE
        END
      END
    END NearestInc;

  PROCEDURE Increment(): BOOLEAN =
  (* Increment the value &quot;digits[0] ... digits[len-1]&quot;. If &quot;len &lt;= 0&quot;, this
     does nothing, but is considered to overflow. In the event of an overflow,
     set &quot;digits[0]&quot; to &quot;1&quot;. Return TRUE iff there was an overflow. *)
    BEGIN
      (* handle empty prefix case *)
      IF len &lt;= 0 THEN digits[0] := 1; RETURN TRUE END;
      (* otherwise, increment from right to left *)
      VAR i := len; BEGIN
      	REPEAT
      	  DEC(i);
      	  digits[i] := (digits[i] + 1) MOD 10
      	UNTIL i = 0 OR digits[i] # 0;
      	IF i = 0 AND digits[i] = 0 THEN digits[0] := 1; RETURN TRUE END
      END;
      RETURN FALSE
    END Increment;

  CONST RoundingName = ARRAY FloatMode.RoundingMode OF TEXT{
    &quot;NearestElseEven&quot;, &quot;TowardMinusInfinity&quot;, &quot;TowardPlusInfinity&quot;,
    &quot;TowardZero&quot;, &quot;NearestElseAwayFromZero&quot;, &quot;IBM370&quot;, &quot;Other&quot;};

  (* Round *)
  VAR inc: BOOLEAN; roundingMode: FloatMode.RoundingMode; BEGIN
    &lt;* ASSERT num.len &gt;= 1 *&gt;
    IF len &gt;= num.len THEN len := num.len; RETURN FALSE END;
    IF useCurrentRounding
      THEN roundingMode := FloatMode.GetRounding()
      ELSE roundingMode := testRoundingMode
    END;
    CASE roundingMode OF
      FloatMode.RoundingMode.TowardZero =&gt; inc := FALSE
    | FloatMode.RoundingMode.TowardMinusInfinity =&gt; inc := num.sign = 1
    | FloatMode.RoundingMode.TowardPlusInfinity =&gt; inc := num.sign = 0
    | FloatMode.RoundingMode.NearestElseEven =&gt;
        inc := NearestInc(tieBreak := (len &gt;= 1 AND digits[len-1] MOD 2 = 1))
    | FloatMode.RoundingMode.NearestElseAwayFromZero =&gt;
        inc := NearestInc(tieBreak := TRUE)
    | FloatMode.RoundingMode.IBM370, FloatMode.RoundingMode.Other =&gt;
        Process.Crash(&quot;FmtBuf: Unimplemented rounding mode: \&quot;&quot;
          &amp; RoundingName[roundingMode] &amp; &quot;\&quot;.&quot;)
    END;
    VAR res: BOOLEAN; BEGIN
      IF inc
        THEN res := Increment()
        ELSE res := FALSE
      END;
      len := MIN(MAX(len, ORD(res)), num.len);
      RETURN res
    END
  END Round;
</PRE> Algorithm for deciding whether or not to increment in the Round procedure:
<P>
   Whether or not to increment the digits is determined as follows. Define
   <CODE>lo</CODE> and <CODE>hi</CODE> by:
<P>
<PRE>
         lo = (-1)^num.sign * digits[0] . digits[1] ... digits[len-1] * 10^num.exp
         hi = lo + (-1)^num.sign * 10^(num.exp - (len-1))
</PRE>
   Roughly speaking, at the end of the <CODE>Round</CODE> procedure, the value denoted by
   <CODE>num</CODE>, <CODE>digits</CODE>, <CODE>len</CODE>, and the Boolean return result is either <CODE>lo</CODE> or
   <CODE>hi</CODE>.
<P>
   On entry to the <CODE>Round</CODE> procedure, the value represented by the parameters
   <CODE>num</CODE>, <CODE>digits</CODE>, and <CODE>len</CODE> is a decimal approximation <CODE>da</CODE> defined by:
<P>
<PRE>
         da = (-1)^num.sign * digits[0] . digits[1] ... digits[num.len-1]
                            * 10^num.exp
</PRE>
   The value <CODE>da</CODE> approximates some floating point value <CODE>r</CODE> according to the
   procedure <CODE>Float.ToDecimal</CODE>. Since <CODE>len &lt; num.len</CODE>, we have:
<P>
<PRE>
         (1) ABS(lo) &lt; ABS(da) &lt; ABS(hi)
</PRE>
   Moreover, by definition of the approximation produced by <CODE>ToDecimal</CODE>, we
   can prove that:
<P>
<PRE>
         (2) ABS(lo) &lt; ABS(r) &lt; ABS(hi)
</PRE>
   Proof: Without loss of generality, suppose all values are non-negative and
   that <CODE>lo &lt; hi &lt;= r</CODE>. By (1), we would then have <CODE>lo &lt; da &lt; hi &lt;= r</CODE>. But
   since <CODE>hi</CODE> has fewer digits than <CODE>da</CODE> and is nearer to <CODE>r</CODE> than <CODE>da</CODE> in the
   same rounding direction, <CODE>ToDecimal</CODE> would have produced <CODE>hi</CODE> instead of
   <CODE>da</CODE> in this case. Hence, <CODE>r &lt; hi</CODE>. For the same reason, we must also have
   <CODE>lo &lt; r</CODE>.
<P>
   The relations (1) and (2) guide the development of the algorithm. The
   algorithm can be divided into cases based on the current rounding mode.
<P>
   The following table describes when to increment for the rounding modes
   <CODE>TowardZero</CODE>, <CODE>TowardMinusInfinity</CODE>, and <CODE>TowardPlusInfinity</CODE>:
<P>
<PRE>
         Rounding Mode          Increment when...
         -------------------    -----------------
         TowardZero             NEVER
         TowardMinusInfinity    num.sign = 1
         TowardPlusInfinity     num.sign = 0
</PRE>
   The determination in the <CODE>NearestElseEven</CODE> and <CODE>NearestElseAwayFromZero</CODE>
   cases is made as follows. Let <CODE>R</CODE> be the nonnegative floating-decimal
   number defined by
<P>
<PRE>
         R = 0 . digits[len] ... digits[num.len-1]
           = sum(i: len &lt;= i &lt; num.len, digits[i] * 10^(len - i - 1))
</PRE>
   Then the decision whether or not to increment is based to the first order
   on the value of <CODE>R</CODE> as follows:
<P>
<PRE>
                        R &lt; 0.5    R = 0.5    R &gt; 0.5
         Increment?       NO        MAYBE       YES
</PRE>
   When <CODE>R = 0.5</CODE>, we use <CODE>num.errorSign</CODE> to make our decision as follows:
<P>
<PRE>
         num.errorSign =  -1          0          1               
         Increment?       NO        MAYBE       YES
</PRE>
   When <CODE>R = 0.5</CODE> and <CODE>num.errorSign = 0</CODE>, the decision to increment or not
   depends on the rounding mode, according to the following table:
<P>
<PRE>
         Rounding Mode              Increment when...
         -----------------------    -----------------
         NearestElseEven            digits[len-1] MOD 2 = 1
         NearestElseAwayFromZero    ALWAYS


<P><PRE>BEGIN
END FmtBuf.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface FloatMode is in:
</A><UL>
<LI><A HREF="../../float/src/DS3100/FloatMode.i3#0TOP0">float/src/DS3100/FloatMode.i3</A>
<LI><A HREF="../../float/src/IEEE-default/FloatMode.i3#0TOP0">float/src/IEEE-default/FloatMode.i3</A>
<LI><A HREF="../../float/src/IRIX5/FloatMode.i3#0TOP0">float/src/IRIX5/FloatMode.i3</A>
<LI><A HREF="../../float/src/SOLsun/FloatMode.i3#0TOP0">float/src/SOLsun/FloatMode.i3</A>
<LI><A HREF="../../float/src/SPARC/FloatMode.i3#0TOP0">float/src/SPARC/FloatMode.i3</A>
<LI><A HREF="../../float/src/SUN386/FloatMode.i3#0TOP0">float/src/SUN386/FloatMode.i3</A>
<LI><A HREF="../../float/src/VAX/FloatMode.i3#0TOP0">float/src/VAX/FloatMode.i3</A>
</UL>
<P>
<HR>
<A NAME="x2">interface Real is in:
</A><UL>
<LI><A HREF="../../float/src/IEEE/Real.i3#0TOP0">float/src/IEEE/Real.i3</A>
<LI><A HREF="../../float/src/VAX/Real.i3#0TOP0">float/src/VAX/Real.i3</A>
</UL>
<P>
<HR>
<A NAME="x3">interface LongReal is in:
</A><UL>
<LI><A HREF="../../float/src/IEEE/LongReal.i3#0TOP0">float/src/IEEE/LongReal.i3</A>
<LI><A HREF="../../float/src/VAX/LongReal.i3#0TOP0">float/src/VAX/LongReal.i3</A>
</UL>
<P>
<HR>
<A NAME="x4">interface Extended is in:
</A><UL>
<LI><A HREF="../../float/src/IEEE/Extended.i3#0TOP0">float/src/IEEE/Extended.i3</A>
<LI><A HREF="../../float/src/VAX/Extended.i3#0TOP0">float/src/VAX/Extended.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
