<HTML>
<HEAD>
<TITLE>SRC Modula-3: fmtlex/src/FmtBufF.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>fmtlex/src/FmtBufF.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                     </EM></BLOCKQUOTE><PRE>

INTERFACE <interface><A HREF="FmtBuf.m3">FmtBufF</A></interface>;
</PRE> A <CODE>friends</CODE> interface for the <CODE>FmtBuf</CODE> interface that reveals
   internal types and procedures. 

<P><PRE>IMPORT <A HREF="Fmt.i3">Fmt</A>, <A HREF="FmtBuf.i3">FmtBuf</A>, <A HREF="../../float/src/Common/RealFloat.i3">RealFloat</A>, <A HREF="../../float/src/Common/LongFloat.i3">LongFloat</A>, <A HREF="../../float/src/Common/ExtendedFloat.i3">ExtendedFloat</A>;

TYPE
  Class = { NaN, Inf, Number, Zero };
  IEEEKind = { Single, Double, Extended };
</PRE> The <CODE>Class</CODE> type is a coarse-grained and precision-independent
   representation of the class of an IEEE floating-point number.
   The <CODE>NaN</CODE> class includes both quiet and signalling NaN's. The
   <CODE>Number</CODE> class includes both normal and denormal numbers.
<P>
   The <CODE>IEEEKind</CODE> type enumerates the three IEEE floating-point
   precisions. 

<P><PRE>CONST
  ClassMapReal = ARRAY RealFloat.IEEEClass OF Class{
    Class.NaN, Class.NaN, Class.Inf, Class.Number, Class.Number, Class.Zero};
  ClassMapLong = ARRAY LongFloat.IEEEClass OF Class{
    Class.NaN, Class.NaN, Class.Inf, Class.Number, Class.Number, Class.Zero};
  ClassMapExtd = ARRAY ExtendedFloat.IEEEClass OF Class{
    Class.NaN, Class.NaN, Class.Inf, Class.Number, Class.Number, Class.Zero};
</PRE> The <CODE>ClassMapReal</CODE>, <CODE>ClassMapLong</CODE>, and <CODE>ClassMapExtd</CODE> arrays
   are maps from the appropriate <CODE>IEEEClass</CODE> type to the corresponding
   precision-independent <CODE>Class</CODE> type. 

<P><PRE>TYPE
  NumAttr = RECORD
    class: Class;
    kind: IEEEKind;
    sign: [0..1];
    maxExpDigits: CARDINAL;
    len: CARDINAL;
    exp: INTEGER;
    errorSign: [-1..1];
  END;
  Digits = ARRAY OF [0..9];
</PRE> This interface represents a floating point number by a pair of values
   <CODE>(num, digits)</CODE> in the set <CODE>NumAttr x Digits</CODE>. <CODE>num</CODE> contains attributes
   of the number, and <CODE>digits</CODE> contains the digits of the number. The
   first four fields of <CODE>num</CODE> are defined by:
<P>
<PRE>
        &quot;class&quot; denotes the class of the number,
        &quot;kind&quot; denotes the precision of the number,
        &quot;sign&quot; is the sign bit of the number (0 = positive, 1 = negative), and
        &quot;maxExpDigits&quot; is the maximum number of base-10 exponent digits
          required by &quot;kind&quot;-precision real numbers
</PRE>
   If <CODE>num.class = Class.Number</CODE>, then the other fields of <CODE>num</CODE>
   are the same as those in the <CODE>DecimalApprox</CODE> structure produced
   by the <CODE>ToDecimal</CODE> procedure in instantiations of the <CODE>Float</CODE>
   interface. A <CODE>Digits</CODE> value contains the same digits as the <CODE>digits</CODE>
   field of the <CODE>DecimalApprox</CODE> record; this field has been removed from
   the record so it can be passed READONLY on the stack for efficiency. 

<P><PRE>TYPE
  FmtRec = RECORD
    style: Fmt.Style;
    prec: CARDINAL;
    literal: BOOLEAN;
  END;
</PRE> A <CODE>FmtRec</CODE> bundles together the three formatting parameters that
   determine how a floating-point value should be formatted. 

<P><PRE>PROCEDURE <A HREF="FmtBuf.m3#Float">Float</A>(
    VAR (*OUT*) b: FmtBuf.T;
    READONLY num: NumAttr;
    VAR (*IN*) digits: Digits;
    READONLY fmt: FmtRec)
  : CARDINAL;
</PRE><BLOCKQUOTE><EM> Format the number <CODE>(num, digits)</CODE> into the buffer <CODE>b</CODE> to precision
   <CODE>fmt.prec</CODE> according to formatting style <CODE>fmt.style</CODE> and <CODE>fmt.literal</CODE>
   as defined in the <CODE>Fmt</CODE> interface. Returns the number of characters
   written into the buffer <CODE>b</CODE>. It is a checked run-time error for <CODE>b</CODE>
   not to be large enough to hold the result. The contents of <CODE>digits</CODE> is
   undefined on return. </EM></BLOCKQUOTE><PRE>
</PRE> The caller must guarantee that the buffer <CODE>b</CODE> passed to <CODE>Float</CODE> is
   sufficiently large. The tricky question is to decide how large the
   buffer needs to be. Our goal here is to develop an upper-bound that
   is easy to compute. We proceed by a case analysis.
<P>
   We need not consider the <CODE>Style.Auto</CODE> style, since the width of a
   number produced with <CODE>Style.Auto</CODE> is at most the maximum of the width
   produced using <CODE>Style.Sci</CODE> and <CODE>Style.Fix</CODE>.
<P>
   A number of type <CODE>T</CODE> rendered to <CODE>prec</CODE> digits of precision with
   <CODE>Style.Sci</CODE> will normally produce a text of length <CODE>5 + prec +
   T.MaxExpDigits</CODE> (the 5 extra characters are for the leading sign,
   leading digit, decimal point, exponent character, and exponent sign).
   However, in the case that <CODE>prec = 0</CODE>, the width will be 1 larger if
   <CODE>literal = TRUE</CODE> and 1 smaller otherwise. Also, in the case where
   <CODE>literal = TRUE</CODE>, the special values <CODE>Nan</CODE> and <CODE>Infinity</CODE> require 8
   characters in the single-precision case and 12 characters in the
   double- and extended-precision cases. Hence, some good upper-bounds
   for <CODE>Style.Sci</CODE> are:
<P>
<PRE>
         literal = FALSE:  width &lt;= 5 + prec + T.MaxExpDigits
         literal = TRUE:   width &lt;= MAX(5 + MAX(prec, 1) + T.MaxExpDigits, 12)
</PRE>
   The width of a number rendered according to <CODE>Style.Fix</CODE> is a bit more
   difficult to bound. Independent of the <CODE>literal</CODE> parameter, the values
   <CODE>NaN</CODE> and <CODE>Infinity</CODE> require at most 12 characters, and the value zero
   requires at most <CODE>MAX(prec, 1) + 5</CODE> characters. A non-zero fixpoint
   number is formatted to have the form <CODE>[-]DD***D.PP***P[(d|x)0]</CODE>. There
   are exactly <CODE>prec</CODE> digits after the decimal, but the number of digits
   before the decimal depends on the magnitude of the number. Suppose the
   base-10 exponent of the number, if rendered in scientific notation, is
   <CODE>exp</CODE>. Then the number of digits before the decimal is given by
   <CODE>MAX(exp, 1)</CODE>. Hence, the maximum width for each class of number
   rendered in <CODE>Style.Fix</CODE> is: 
<P>
<PRE>
         Nan, Infinity:    width &lt;= 12
         Zero:             width &lt;= 5 + MAX(prec, 1)
         All others:       width &lt;= 4 + MAX(prec, 1) + MAX(exp, 1)
</PRE>
   Hence, an overall cautious upper-bound is given by the following
   formula, where <CODE>exp</CODE> is defined to be zero in the <CODE>Nan</CODE>, <CODE>Infinity</CODE>,
   and <CODE>Zero</CODE> cases:
<P>
<PRE>
         Style.Fix:        width &lt;= MAX(4 + MAX(prec, 1) + MAX(exp, 1), 12)


<P><PRE>END FmtBufF.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
