<HTML>
<HEAD>
<TITLE>SRC Modula-3: fmtlex/src/FmtBufTest.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>fmtlex/src/FmtBufTest.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                             </EM></BLOCKQUOTE><PRE>

INTERFACE <interface><A HREF="FmtBuf.m3">FmtBufTest</A></interface>;
</PRE> By default, the procedures in the <CODE>FmtBuf</CODE> interface for formatting real
   numbers use the current rounding mode to round the result when fewer
   digits of precision are requested than are provided automatically by
   <CODE>Float.ToDecimal</CODE>. In order to test the implementation of the <CODE>FmtBuf</CODE>
   interface, we would like to be able to exercise it under each rounding
   mode. Unfortunately, not all rounding modes are necessarily supported by
   each architecture. In particular, the <CODE>FloatMode.SetRounding</CODE> procedure
   may raise the exception <CODE>FloatMode.Failure</CODE> if the requested rounding
   mode is not supported by the underlying architecture.
<P>
   This interface provides a mechanism for test programs to override this
   default behavior and fix the current rounding mode, even if it is not
   supported by the underlying architecture. 

<P><PRE>IMPORT <A HREF="#x1">FloatMode</A>;

VAR
  useCurrentRounding := TRUE;
  testRoundingMode: FloatMode.RoundingMode;
</PRE> If <CODE>useCurrentRounding</CODE> is <CODE>TRUE</CODE>, then the procedures in <CODE>FmtBuf</CODE> for
   formatting real numbers use the current rounding mode. In this case, the
   value of the global variable <CODE>testRoundingMode</CODE> is ignored.
<P>
   If <CODE>useCurrentRounding</CODE> is <CODE>FALSE</CODE>, then these procedures use
   <CODE>testRoundingMode</CODE> as the rounding mode, even if it is not a rounding
   mode supported by the underlying architecture. 

<P><PRE>END FmtBufTest.
</PRE>
</inInterface>
<HR>
<A NAME="x1">interface FloatMode is in:
</A><UL>
<LI><A HREF="../../float/src/DS3100/FloatMode.i3#0TOP0">float/src/DS3100/FloatMode.i3</A>
<LI><A HREF="../../float/src/IEEE-default/FloatMode.i3#0TOP0">float/src/IEEE-default/FloatMode.i3</A>
<LI><A HREF="../../float/src/IRIX5/FloatMode.i3#0TOP0">float/src/IRIX5/FloatMode.i3</A>
<LI><A HREF="../../float/src/SOLsun/FloatMode.i3#0TOP0">float/src/SOLsun/FloatMode.i3</A>
<LI><A HREF="../../float/src/SPARC/FloatMode.i3#0TOP0">float/src/SPARC/FloatMode.i3</A>
<LI><A HREF="../../float/src/SUN386/FloatMode.i3#0TOP0">float/src/SUN386/FloatMode.i3</A>
<LI><A HREF="../../float/src/VAX/FloatMode.i3#0TOP0">float/src/VAX/FloatMode.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
