<HTML>
<HEAD>
<TITLE>SRC Modula-3: fmtlex/src/Lex.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>fmtlex/src/Lex.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> The <CODE>Lex</CODE> interface provides procedures for reading strings,
   booleans, integers, and floating-point numbers from an input
   stream.  Similar functionality on text strings is available
   from the <CODE>Scan</CODE> interface. 

<P><PRE>INTERFACE <interface><A HREF="Lex.m3">Lex</A></interface>;

IMPORT <A HREF="#x1">FloatMode</A>, <A HREF="../../rw/src/Common/Rd.i3">Rd</A>, <A HREF="../../word/src/Word.i3">Word</A>;
FROM <A HREF="../../thread/src/Common/Thread.i3">Thread</A> IMPORT Alerted;

EXCEPTION Error;

CONST
   Blanks = SET OF CHAR{
     ' ', '\t', '\n', '\r', '\013' (* vertical tab *), '\f'};
   NonBlanks = SET OF CHAR{'!' .. '~'};
</PRE> Each of the procedures in this interface reads a specified prefix
   of the characters in the reader passed to the procedure, and leaves
   the reader positioned immediately after that prefix, perhaps at
   end-of-file.  Each procedure may call <CODE>Rd.UngetChar</CODE> after its
   final call on <CODE>Rd.GetChar</CODE>. 

<P><PRE>PROCEDURE <A HREF="Lex.m3#Scan">Scan</A>(
    rd: Rd.T; READONLY cs: SET OF CHAR := NonBlanks): TEXT
  RAISES {Rd.Failure, Alerted};
</PRE><BLOCKQUOTE><EM> Read the longest prefix of <CODE>rd</CODE> composed of characters in <CODE>cs</CODE> and
   return that prefix as a <CODE>TEXT</CODE>.  </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Lex.m3#Skip">Skip</A>(
    rd: Rd.T; READONLY cs: SET OF CHAR := Blanks)
  RAISES {Rd.Failure, Alerted};
</PRE><BLOCKQUOTE><EM> Read the longest prefix of <CODE>rd</CODE> composed of characters in <CODE>cs</CODE> and
   discard it.  </EM></BLOCKQUOTE><PRE>
</PRE> Whenever a specification of one of the procedures mentions skipping
   blanks, this is equivalent to performing the call <CODE>Skip(rd, Blanks)</CODE>. 

<P><PRE>PROCEDURE <A HREF="Lex.m3#Match">Match</A>(rd: Rd.T; t: TEXT)
  RAISES {Error, Rd.Failure, Alerted};
</PRE><BLOCKQUOTE><EM> Read the longest prefix of <CODE>rd</CODE> that is also a prefix of <CODE>t</CODE>.
   Raise <CODE>Error</CODE> if that prefix is not, in fact, equal to all of <CODE>t</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Lex.m3#Bool">Bool</A>(rd: Rd.T): BOOLEAN RAISES {Error, Rd.Failure, Alerted};
</PRE><BLOCKQUOTE><EM> Read a boolean from <CODE>rd</CODE> and return its value. </EM></BLOCKQUOTE><PRE>
</PRE> <CODE>Bool</CODE> skips blanks, then reads the longest prefix of <CODE>rd</CODE> that is
   a prefix of a <CODE>Boolean</CODE> in the following grammar:
<P>
<PRE>
      Boolean = &quot;F&quot; &quot;A&quot; &quot;L&quot; &quot;S&quot; &quot;E&quot; | &quot;T&quot; &quot;R&quot; &quot;U&quot; &quot;E&quot;.
</PRE>
   The case of letters in a <CODE>Boolean</CODE> is not significant.  If the
   prefix read from <CODE>rd</CODE> is an entire <CODE>Boolean</CODE>, <CODE>Bool</CODE> returns that
   boolean; else it raises <CODE>Error</CODE>.  

<P><PRE>PROCEDURE <A HREF="Lex.m3#Int">Int</A>(rd: Rd.T; defaultBase: [2..16] := 10)
  : INTEGER RAISES {Error, FloatMode.Trap, Rd.Failure, Alerted};
PROCEDURE <A HREF="Lex.m3#Unsigned">Unsigned</A>(rd: Rd.T; defaultBase: [2..16] := 16)
  : Word.T RAISES {Error, FloatMode.Trap, Rd.Failure, Alerted};
</PRE><BLOCKQUOTE><EM> Read a number from <CODE>rd</CODE> and return its value. </EM></BLOCKQUOTE><PRE>
</PRE> Each procedure skips blanks, then reads the longest prefix of <CODE>rd</CODE>
   that is a prefix of a <CODE>Number</CODE> as defined by the grammar below.  If
   <CODE>defaultBase</CODE> exceeds 10, then the procedure scans for a
   <CODE>BigBaseNum</CODE>; otherwise it scans for a <CODE>SmallBaseNum</CODE>.  The effect
   of this rule is that the letters 'a' through 'f' and 'A' through
   'F' stop the scan unless either the <CODE>defaultBase</CODE> or the explicitly
   provided base exceeds 10.  <CODE>Unsigned</CODE> omits the scan for a <CODE>Sign</CODE>.
<P>
<PRE>
      Number       = [Sign] (SmallBaseNum | BigBaseNum).
      SmallBaseNum = DecVal | BasedInt.
      BigBaseNum   = HexVal | BasedInt.
      BasedInt     = SmallBase &quot;_&quot; DecVal | BigBase &quot;_&quot; HexVal.
      DecVal       = Digit {Digit}.
      HexVal       = HexDigit {HexDigit}.
      Sign         = &quot;+&quot; | &quot;-&quot;.
      SmallBase    = &quot;2&quot; | &quot;3&quot; | ... | &quot;10&quot;.
      BigBase      = &quot;11&quot; | &quot;12&quot; | ... | &quot;16&quot;.
      Digit        = &quot;0&quot; | &quot;1&quot; | ... | &quot;9&quot;.
      HexDigit     = Digit | &quot;A&quot; | &quot;B&quot; | &quot;C&quot; | &quot;D&quot; | &quot;E&quot; | &quot;F&quot;
                           | &quot;a&quot; | &quot;b&quot; | &quot;c&quot; | &quot;d&quot; | &quot;e&quot; | &quot;f&quot;.
</PRE>
   If the prefix read from <CODE>rd</CODE> is an entire <CODE>Number</CODE> (as described
   above), the corresponding number is returned; else <CODE>Error</CODE> is
   raised.
<P>
   If an explicit base is given with an underscore, it is interpreted
   in decimal.  In this case, the digits in <CODE>DecVal</CODE> or <CODE>HexVal</CODE> are
   interpreted in the explicit base, else they are interpreted in the
   <CODE>defaultBase</CODE>.
<P>
   Both procedures may raise <CODE>FloatMode.Trap(IntOverflow)</CODE>.  They
   raise <CODE>Error</CODE> if some digit in the value part is not a legal digit
   in the chosen base. 

<P><PRE>PROCEDURE <A HREF="Lex.m3#Real">Real</A>(rd: Rd.T): REAL
  RAISES {Error, FloatMode.Trap, Rd.Failure, Alerted};
PROCEDURE <A HREF="Lex.m3#LongReal">LongReal</A>(rd: Rd.T): LONGREAL
  RAISES {Error, FloatMode.Trap, Rd.Failure, Alerted};
PROCEDURE <A HREF="Lex.m3#Extended">Extended</A>(rd: Rd.T): EXTENDED
  RAISES {Error, FloatMode.Trap, Rd.Failure, Alerted};
</PRE><BLOCKQUOTE><EM> Read a real number from <CODE>rd</CODE> and return its value. </EM></BLOCKQUOTE><PRE>
</PRE> Each procedure skips blanks, then reads the longest prefix of <CODE>rd</CODE>
   that is a prefix of a floating-decimal number <CODE>Float</CODE> in the
   grammar:
<P>
<PRE>
      Float  = [Sign] FloVal [Exp].
      FloVal = {Digit} (Digit | Digit &quot;.&quot; | &quot;.&quot; Digit) {Digit}.
      Exp    = Marker [Sign] Digit {Digit}.
      Marker = (&quot;E&quot; | &quot;e&quot; | &quot;D&quot; | &quot;d&quot; | &quot;X&quot; | &quot;x&quot;).
</PRE>
   where <CODE>Sign</CODE> and <CODE>Digit</CODE> are as defined above.  If the prefix read
   from <CODE>rd</CODE> is an entire <CODE>Float</CODE>, that <CODE>Float</CODE> is converted to a
   <CODE>REAL</CODE>, <CODE>LONGREAL</CODE>, or <CODE>EXTENDED</CODE> using the routine <CODE>FromDecimal</CODE>
   in the appropriate instance of the <CODE>Float</CODE> generic interface; else
   <CODE>Error</CODE> is raised.  Note that the exponent of <CODE>Float</CODE> can be
   introduced with any of the six characters <CODE>'e'</CODE>, <CODE>'E'</CODE>, <CODE>'d'</CODE>,
   <CODE>'D'</CODE>, <CODE>'x'</CODE>, or <CODE>'X'</CODE>, independent of the target type of the
   conversion.
<P>
   On IEEE implementations, the syntax for <CODE>Float</CODE> is extended as
   follows:
<P>
<PRE>
      Float   = [Sign] FloVal [Exp] | [Sign] IEEEVal.
      IEEEVal = &quot;I&quot; &quot;N&quot; &quot;F&quot; &quot;I&quot; &quot;N&quot; &quot;I&quot; &quot;T&quot; &quot;Y&quot; | &quot;I&quot; &quot;N&quot; F&quot;
              | &quot;N&quot; &quot;A&quot; &quot;N&quot;.
</PRE>
   The case of letters in an <CODE>IEEEVal</CODE> is not significant. The
   <CODE>FloatMode.Trap</CODE> exception may be raised with any of the arguments
   <CODE>Overflow</CODE>, <CODE>Underflow</CODE>, or <CODE>Inexact</CODE>.
<P>


<P><PRE>END Lex.
</PRE>
</inInterface>
<HR>
<A NAME="x1">interface FloatMode is in:
</A><UL>
<LI><A HREF="../../float/src/DS3100/FloatMode.i3#0TOP0">float/src/DS3100/FloatMode.i3</A>
<LI><A HREF="../../float/src/IEEE-default/FloatMode.i3#0TOP0">float/src/IEEE-default/FloatMode.i3</A>
<LI><A HREF="../../float/src/IRIX5/FloatMode.i3#0TOP0">float/src/IRIX5/FloatMode.i3</A>
<LI><A HREF="../../float/src/SOLsun/FloatMode.i3#0TOP0">float/src/SOLsun/FloatMode.i3</A>
<LI><A HREF="../../float/src/SPARC/FloatMode.i3#0TOP0">float/src/SPARC/FloatMode.i3</A>
<LI><A HREF="../../float/src/SUN386/FloatMode.i3#0TOP0">float/src/SUN386/FloatMode.i3</A>
<LI><A HREF="../../float/src/VAX/FloatMode.i3#0TOP0">float/src/VAX/FloatMode.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
