<HTML>
<HEAD>
<TITLE>SRC Modula-3: fmtlex/src/Lex.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>fmtlex/src/Lex.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>									     </EM></BLOCKQUOTE><PRE>

MODULE <module><implements><A HREF="Lex.i3">Lex</A></implements></module>;
IMPORT <A HREF="../../float/src/Common/IEEESpecial.i3">IEEESpecial</A>, <A HREF="#x1">FloatMode</A>, <A HREF="../../rw/src/Common/Rd.i3">Rd</A>, <A HREF="../../word/src/Word.i3">Word</A>, <A HREF="../../text/src/Text.i3">Text</A>;
IMPORT <A HREF="../../float/src/Common/RealFloat.i3">RealFloat</A>, <A HREF="../../float/src/Common/LongFloat.i3">LongFloat</A>, <A HREF="../../float/src/Common/ExtendedFloat.i3">ExtendedFloat</A>;
FROM <A HREF="../../thread/src/Common/Thread.i3">Thread</A> IMPORT Alerted;

PROCEDURE <A NAME="Scan"><procedure>Scan</procedure></A>(rd: Rd.T; READONLY cs: SET OF CHAR := NonBlanks): TEXT
    RAISES {Rd.Failure, Alerted} =
  CONST BufSize = 256;
  VAR res := &quot;&quot;; i := 0; c: CHAR; buf: ARRAY [0..BufSize-1] OF CHAR; BEGIN
    TRY
      LOOP
	c := Rd.GetChar(rd);
	IF NOT (c IN cs) THEN
	  Rd.UnGetChar(rd);
	  EXIT
	END;
	IF i = BufSize THEN
	  res := res &amp; Text.FromChars(buf);
	  i := 0
	END;
	buf[i] := c;
	INC(i)
      END
    EXCEPT
      Rd.EndOfFile =&gt; (* SKIP *)
    END;
    RETURN res &amp; Text.FromChars(SUBARRAY(buf, 0, i))
  END Scan;

PROCEDURE <A NAME="Skip"><procedure>Skip</procedure></A>(rd: Rd.T; READONLY cs: SET OF CHAR := Blanks)
    RAISES {Rd.Failure, Alerted} =
  BEGIN
    TRY
      LOOP
	IF NOT (Rd.GetChar(rd) IN cs) THEN
	  Rd.UnGetChar(rd);
	  RETURN
	END
      END
    EXCEPT Rd.EndOfFile =&gt; (* SKIP *)
    END
  END Skip;

PROCEDURE <A NAME="Match"><procedure>Match</procedure></A>(rd: Rd.T; t: TEXT) RAISES {Error, Rd.Failure, Alerted} =
  BEGIN
    TRY
      FOR i := 0 TO Text.Length(t) - 1 DO
	IF Rd.GetChar(rd) # Text.GetChar(t, i) THEN
	  Rd.UnGetChar(rd);
	  RAISE Error
	END
      END
    EXCEPT
      Rd.EndOfFile =&gt; RAISE Error
    END
  END Match;

PROCEDURE <A NAME="Bool"><procedure>Bool</procedure></A>(rd: Rd.T): BOOLEAN RAISES {Error, Rd.Failure, Alerted} =
  PROCEDURE M(c: ['A'..'Z']) RAISES {Error, Rd.Failure, Rd.EndOfFile, Alerted}=
    CONST UpperToLower = ORD('a') - ORD('A');
    VAR c1: CHAR; BEGIN
      c1 := Rd.GetChar(rd);
      IF c1 # c AND c1 # VAL(ORD(c) + UpperToLower, CHAR) THEN
        Rd.UnGetChar(rd); RAISE Error
      END
    END M;
  BEGIN
    Skip(rd, Blanks);
    TRY
      CASE Rd.GetChar(rd) OF
      | 'F', 'f' =&gt; M('A'); M('L'); M('S'); M('E'); RETURN FALSE
      | 'T', 't' =&gt; M('R'); M('U'); M('E'); RETURN TRUE
      ELSE Rd.UnGetChar(rd); RAISE Error
      END
    EXCEPT
      Rd.EndOfFile =&gt; RAISE Error
    END
  END Bool;
</PRE> Implementation Note:
<P>
   When possible, this implementation uses one-character look-ahead and
   exceptions to avoid calls to <CODE>Rd.UnGetChar</CODE> and unnecessary tests in the
   fast case.
<P>
   The following procedures attempt to read characters representing non-
   terminals in the grammar defining <CODE>Number</CODE>'s and <CODE>Float</CODE>'s in the <CODE>Lex</CODE>
   interface. These procedures often take a <CODE>Rd.T</CODE> parameter <CODE>rd</CODE> along with a
   <CODE>VAR</CODE> character <CODE>c</CODE>. The semantics of these procedures is to read from the
   conceptual stream of characters formed by concatenating <CODE>c</CODE> with the stream
   of characters represented by <CODE>rd</CODE>, and to set <CODE>c</CODE> on exit from the
   procedure to the character after the last character that was processed.
   Those procedures that take the character <CODE>c</CODE> as a <CODE>VALUE</CODE> parameter exit
   with <CODE>rd</CODE> containing all unprocessed characters (in particular, such
   procedures call <CODE>Rd.UnGetChar</CODE> if they cannot process the character <CODE>c</CODE>).
<P>
   Some of these procedures raise <CODE>Rd.EndOfFile</CODE> while some do not. The
   general convention is that those procedures representing non-terminals that
   *must* be followed by at least one more character (because of their place
   in the grammar) will raise <CODE>Rd.EndOfFile</CODE>. For example, the <CODE>ReadSign</CODE>
   procedure represents the optional <CODE>Sign</CODE> non-terminal, and in expansions of
   both the <CODE>Number</CODE> and <CODE>Float</CODE> non-terminal, it must be followed by at least
   one more character. On the other hand, the <CODE>ReadUnsigned</CODE> procedure, which
   reads an unsigned number represented by a string of digits, need not be
   followed by any characters, so if end-of-file is encountered, it returns
   success so long as at least one digit has been read. 

<P><PRE>PROCEDURE <A NAME="ReadSign"><procedure>ReadSign</procedure></A>(rd: Rd.T; VAR (*INOUT*) c: CHAR): [0..1]
    RAISES {Rd.EndOfFile, Rd.Failure, Alerted} =
</PRE><BLOCKQUOTE><EM> If <CODE>c</CODE> is the character <CODE>+</CODE> or <CODE>-</CODE>, then read the next character from <CODE>rd</CODE>
   into <CODE>c</CODE>, and return 0 or 1, respectively. Otherwise, return 0. </EM></BLOCKQUOTE><PRE>
  BEGIN
    CASE c OF
      '+' =&gt; c := Rd.GetChar(rd); RETURN 0
    | '-' =&gt; c := Rd.GetChar(rd); RETURN 1
    ELSE RETURN 0
    END
  END ReadSign;

PROCEDURE <A NAME="ReadUnsigned"><procedure>ReadUnsigned</procedure></A>(rd: Rd.T; c: CHAR; base: [2..16]; noBasedInt := FALSE):
    Word.T RAISES {Error, FloatMode.Trap, Rd.Failure, Alerted} =
</PRE><BLOCKQUOTE><EM> Read an unsigned integer of the form <CODE>SmallBaseNum</CODE> or <CODE>BigBaseNum</CODE> (see
   the specification for <CODE>Lex.Integer</CODE>) as <CODE>base</CODE> is at most 10 or exceeds 10,
   respectively. If <CODE>noBasedInt</CODE>, then don't allow an explicit base prefix
   (i.e., read an unsigned integer of the form <CODE>DecVal</CODE> or <CODE>HexVal</CODE> as <CODE>base</CODE>
   is at most 10 or exceeds 10, respectively).
<P>
   Raises <CODE>Error</CODE> if no legal digits were read, or if some digit in the stream
   is not a legal digit in the chosen base. Raises <CODE>FloatMode.Trap</CODE> with
   argument <CODE>FloatMode.Flag.IntOverflow</CODE> if the value exceeds the largest
   value representable by a <CODE>Word.T</CODE>. </EM></BLOCKQUOTE><PRE>
  CONST
    MaxWord = Word.Not(0);
  VAR
    digit: [0..15];
    digitsSeen, specBase: CARDINAL := 0;
    seenUnderscore := noBasedInt;
    badDigit, overflow := FALSE;
    fastUB := Word.Divide(Word.Minus(MaxWord, base-1), base);
    slowUB := Word.Divide(MaxWord, base);
    res: Word.T := 0;
  BEGIN
    LOOP
      CASE c OF
        '0'..'9' =&gt;
          digit := ORD(c) - ORD('0');
          IF digitsSeen &lt; 2 THEN specBase := specBase * 10 + digit END
      | 'a'..'f' =&gt;
          IF base &lt;= 10 THEN Rd.UnGetChar(rd); EXIT END;
          digit := ORD(c) - ORD('a') + 10;
      | 'A'..'F' =&gt;
          IF base &lt;= 10 THEN Rd.UnGetChar(rd); EXIT END;
          digit := ORD(c) - ORD('A') + 10;
      | '_' =&gt;
          (* finish if the preceeding base is not one of &quot;2&quot;, &quot;3&quot;, ..., &quot;16&quot; *)
          IF seenUnderscore OR digitsSeen &gt; 2
             OR specBase &lt; 2 OR specBase &gt; 16
             OR (digitsSeen &gt; 1 AND specBase &lt; 10) THEN
            Rd.UnGetChar(rd); EXIT
          END;
          seenUnderscore := TRUE;
          (* reinitialize state for new base*)
          base := specBase;
          fastUB := Word.Divide(Word.Minus(MaxWord, base-1), base);
          slowUB := Word.Divide(MaxWord, base);
          digitsSeen := 0;
          badDigit := FALSE;
          overflow := FALSE;
          res := 0;
      ELSE Rd.UnGetChar(rd); EXIT
      END;
      IF c # '_' THEN
	INC(digitsSeen);
	IF digit &gt;= base THEN
	  badDigit := TRUE
	ELSIF Word.LE(res, fastUB) THEN
          (* fast path *)
	  res := Word.Plus(Word.Times(res, base), digit)
        ELSIF Word.LE(res, slowUB) THEN
          (* slow path *)
          res := Word.Times(res, base);
          IF digit &lt;= Word.Minus(MaxWord, res)
            THEN res := Word.Plus(res, digit)
            ELSE overflow := TRUE
          END
        ELSE
	  overflow := TRUE
	END
      END;
      TRY c := Rd.GetChar(rd) EXCEPT Rd.EndOfFile =&gt; EXIT END
    END;
    IF digitsSeen = 0 OR badDigit THEN RAISE Error END;
    IF overflow THEN RAISE FloatMode.Trap(FloatMode.Flag.IntOverflow) END;
    RETURN res
  END ReadUnsigned;

PROCEDURE <A NAME="ReadNumber"><procedure>ReadNumber</procedure></A>(rd: Rd.T; defaultBase: [2..16]; signed: BOOLEAN): Word.T
    RAISES {Error, FloatMode.Trap, Rd.Failure, Alerted} =
</PRE><BLOCKQUOTE><EM> Raises <CODE>FloatMode.Trap(FloatMode.Flag.IntOverflow)</CODE> if the read number
   exceeds a <CODE>Word.T</CODE> or if <CODE>signed = TRUE</CODE> and the read number exceeds
   <CODE>LAST(INTEGER)</CODE> when the sign is positive or exceeds <CODE>-FIRST(INTEGER)</CODE> when
   the sign is negative. </EM></BLOCKQUOTE><PRE>
  VAR c: CHAR; sign: [0..1]; res: Word.T; BEGIN
    Skip(rd, Blanks);
    TRY
      c := Rd.GetChar(rd);
      IF signed
        THEN sign := ReadSign(rd, c)
        ELSE sign := 0
      END
    EXCEPT
      Rd.EndOfFile =&gt; RAISE Error
    END;
    res := ReadUnsigned(rd, c, defaultBase);
    IF signed AND
       ((sign = 0 AND Word.GT(res, LAST(INTEGER))) OR
        (sign = 1 AND Word.GT(res, -FIRST(INTEGER)))) THEN
      RAISE FloatMode.Trap(FloatMode.Flag.IntOverflow)
    END;
    IF sign = 1 THEN res := - res END;
    RETURN res
  END ReadNumber;

PROCEDURE <A NAME="Int"><procedure>Int</procedure></A>(rd: Rd.T; defaultBase: [2..16] := 10): INTEGER
    RAISES {Error, FloatMode.Trap, Rd.Failure, Alerted} =
  BEGIN RETURN ReadNumber(rd, defaultBase, signed := TRUE) END Int;

PROCEDURE <A NAME="Unsigned"><procedure>Unsigned</procedure></A>(rd: Rd.T; defaultBase: [2..16] := 16): Word.T
    RAISES {Error, FloatMode.Trap, Rd.Failure, Alerted} =
  BEGIN RETURN ReadNumber(rd, defaultBase, signed := FALSE) END Unsigned;

CONST
  DigitBufSz = 40;

TYPE
  Digits = ARRAY OF [0..9];
  DigitBuf = ARRAY [0..DigitBufSz-1] OF [0..9];

PROCEDURE <A NAME="ReadFloVal"><procedure>ReadFloVal</procedure></A>(
    rd: Rd.T;
    VAR (*INOUT*) c: CHAR;
    VAR (*OUT*) prefix: REF Digits;
    VAR (*OUT*) digits: DigitBuf;
    VAR (*OUT*) digCnt: CARDINAL;
    VAR (*OUT*) exp: INTEGER): BOOLEAN
    RAISES {Rd.Failure, Rd.EndOfFile, Alerted} =
</PRE><BLOCKQUOTE><EM> Read a <CODE>FloVal</CODE> (as defined in the BNF for a <CODE>Float</CODE>) from the character
   stream formed by concatenating <CODE>c</CODE> with the stream <CODE>rd</CODE>. If the number of
   digits in this <CODE>FloVal</CODE> is at most <CODE>DigitBufSz</CODE>, then set <CODE>prefix</CODE> to
   <CODE>NIL</CODE>, and store the digits in <CODE>digits</CODE> and the number of digits read in
   <CODE>digCnt</CODE>. Otherwise (the slow path), <CODE>prefix</CODE> is set to a buffer of the
   prefix digits; the remaining digits are in <CODE>SUBARRAY(digits, 0, digCnt)</CODE>.
   The value <CODE>exp</CODE> is set to the power of 10 to which the read digits
   *with a demimal point inserted just after the first digit* must be raised
   to equal the <CODE>FloVal</CODE> that was read. For example:
<P>
<PRE>
         FloVal read   digits[]    digCnt    exp
         -----------   --------    ------    ---
         &quot;1.234&quot;       1234        4          0
         &quot;0.1234&quot;      1234        4         -1
         &quot;12.34&quot;       1234        4          1
         &quot;0.00012&quot;     12          2         -4
         &quot;00012.3&quot;     123         3          1
</PRE>
   Notice that this implementation ignores leading zeroes, so if there are any
   non-zero digits, then <CODE>digits[0] # 0</CODE>.
<P>
   Returns TRUE iff end-of-file was encountered after first reading a valid
   <CODE>FloVal</CODE>. In this case, the value of the INOUT parameter <CODE>c</CODE> on return is
   undefined. Otherwise, <CODE>c</CODE> is the next unprocessed character on <CODE>rd</CODE>.
<P>
   Raises <CODE>Rd.EndOfFile</CODE> if end-of-file was encountered before reading a valid
   <CODE>FloVal</CODE>. </EM></BLOCKQUOTE><PRE>

  VAR sawZero, foundDecimal := FALSE;

  PROCEDURE SkipZeros() RAISES {Rd.EndOfFile, Rd.Failure, Alerted} =
  (* Skip leading zeros and at most one decimal point in the character stream
     formed by concatenating &quot;c&quot; with the stream &quot;rd&quot;. Set &quot;sawZero&quot; to TRUE
     iff at least one zero digit was skipped. Set &quot;foundDecimal&quot; to TRUE iff a
     decimal point was skipped. If the stream does not contain a decimal
     point, then set &quot;exp&quot; to 0. Otherwise, set &quot;exp&quot; to the negation of the
     number of zeros read after the decimal.

     If this routine reads at least one new character, then &quot;sawZero OR
     foundDecimal&quot;. *)
    BEGIN
      LOOP
	CASE c OF
	  '0' =&gt;
	    sawZero := TRUE;
	    IF foundDecimal THEN DEC(exp) END
	| '.' =&gt;
	    IF foundDecimal
	      THEN RETURN
	      ELSE foundDecimal := TRUE
	    END
	ELSE RETURN
	END;
	c := Rd.GetChar(rd)
      END
    END SkipZeros;

  PROCEDURE AppendToPrefix() =
  (* Append the digits in &quot;digits[0..digCnt-1]&quot; to the &quot;prefix&quot; array. *)
    VAR new: REF ARRAY OF [0..9]; BEGIN
      IF prefix = NIL THEN
        new := NEW(REF ARRAY OF [0..9], digCnt);
      ELSE
        new := NEW(REF ARRAY OF [0..9], NUMBER(prefix^) + digCnt);
        SUBARRAY(new^, 0, NUMBER(prefix^)) := prefix^
      END;
      prefix := new;
      SUBARRAY(prefix^, NUMBER(prefix^) - digCnt, digCnt) :=
        SUBARRAY(digits, 0, digCnt)
    END AppendToPrefix;

  PROCEDURE ReadDigits() RAISES {Rd.EndOfFile, Rd.Failure, Alerted} =
  (* Read decimal digits into &quot;digits&quot;, setting &quot;foundDecimal&quot; if a decimal
     point is seen, and incrementing &quot;exp&quot; for each digit seen before a
     decimal point.

     Note: If &quot;digCnt = 0 AND prefix = NIL&quot; on entry, then on any sort of
     return, &quot;digCnt = 0 =&gt; prefix = NIL&quot;. *)
    BEGIN
      &lt;* ASSERT c # '0' *&gt;
      LOOP
	CASE c OF
	  '0'..'9' =&gt;
            IF NOT foundDecimal THEN INC(exp) END;
            IF digCnt = DigitBufSz THEN
              AppendToPrefix();
              digCnt := 0
            END;
            digits[digCnt] := ORD(c) - ORD('0');
            INC(digCnt)
	| '.' =&gt;
	    IF foundDecimal THEN RETURN END;
	    foundDecimal := TRUE
	ELSE RETURN
	END;
	c := Rd.GetChar(rd)
      END
    END ReadDigits;

  (* ReadFloVal *)
  VAR res := FALSE; BEGIN
    TRY
      exp := -1;
      SkipZeros();
      prefix := NIL;
      digCnt := 0;
      ReadDigits()
    EXCEPT
      Rd.EndOfFile =&gt;
        IF digCnt = 0 AND NOT sawZero THEN
          RAISE Rd.EndOfFile
        END;
        res := TRUE
    END;
    IF digCnt = 0 AND sawZero THEN
      digits[0] := 0; INC(digCnt); INC(exp)
    END;
    RETURN res
  END ReadFloVal;

EXCEPTION IntOverflow(BOOLEAN);
</PRE><BLOCKQUOTE><EM> The exception is raised in the event of an integer overflow; the Boolean
   argument is TRUE iff the preceeding sign was negative. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A NAME="ReadExponent"><procedure>ReadExponent</procedure></A>(rd: Rd.T; c: CHAR): INTEGER
    RAISES {Error, IntOverflow, Rd.Failure, Alerted} =
</PRE><BLOCKQUOTE><EM> Read an optional <CODE>Exp</CODE> as defined in the BNF for a <CODE>Float</CODE>. If <CODE>c</CODE> is not
   one of the valid first characters of an <CODE>Exp</CODE>, return 0. Since <CODE>c</CODE> is not a
   VAR parameter, this routine must also guarantee than the last read but
   unprocessed character is prepended to <CODE>rd</CODE>. </EM></BLOCKQUOTE><PRE>
  VAR sign: [0..1]; val: INTEGER; BEGIN
    TRY
      CASE c OF
	'd', 'e', 'x', 'D', 'E', 'X' =&gt; c := Rd.GetChar(rd)
      ELSE Rd.UnGetChar(rd); RETURN 0
      END;
      sign := ReadSign(rd, c)
    EXCEPT
      Rd.EndOfFile =&gt; RAISE Error
    END;
    (* read the exponent; if it overflows a Word.T or is bigger than
       LAST(INTEGER), then it is obviously too large *)
    TRY
      val := ReadUnsigned(rd, c, base := 10, noBasedInt := TRUE);
      IF Word.GT(val, LAST(INTEGER)) THEN
        RAISE FloatMode.Trap(FloatMode.Flag.IntOverflow)
      END
    EXCEPT
      FloatMode.Trap (flag) =&gt;
        &lt;* ASSERT flag = FloatMode.Flag.IntOverflow *&gt;
        RAISE IntOverflow(sign = 1)
    END;
    IF sign = 1 THEN val := -val END;
    RETURN val
  END ReadExponent;

TYPE SpecialKind = { NaN, PosInf, NegInf };
EXCEPTION SpecialReal(SpecialKind);

PROCEDURE <A NAME="ReadReal"><procedure>ReadReal</procedure></A>(
    rd: Rd.T;
    VAR (*OUT*) sign: [0..1];
    VAR (*OUT*) digits: ARRAY OF [0..9];
    VAR (*OUT*) digCnt: CARDINAL;
    VAR (*OUT*) exp: INTEGER):
    REF ARRAY OF [0..9]
    RAISES {SpecialReal, Error, FloatMode.Trap, Rd.Failure, Alerted} =
</PRE><BLOCKQUOTE><EM> Common entry point for parsing Real, LongReal, and Extended floating point
   numbers. </EM></BLOCKQUOTE><PRE>

  PROCEDURE M(c: ['A'..'Z']) RAISES {Error, Rd.Failure, Alerted} =
  (* Read the next character from &quot;rd&quot;. If it is &quot;c&quot; or the lower-case
     character corresponding to &quot;c&quot;, then return. Raises &quot;Error&quot; on
     end-of-file or if the match failed. In the latter case, the bad character
     is returned to the reader. *)
    CONST UpperToLower = ORD('a') - ORD('A');
    VAR c1: CHAR; BEGIN
      TRY c1 := Rd.GetChar(rd) EXCEPT Rd.EndOfFile =&gt; RAISE Error END;
      IF c1 # c AND c1 # VAL(ORD(c) + UpperToLower, CHAR) THEN
        Rd.UnGetChar(rd); RAISE Error
      END
    END M;

  PROCEDURE Inf(s: [0..1]): SpecialKind =
    BEGIN
      CASE s OF
        0 =&gt; RETURN SpecialKind.PosInf
      | 1 =&gt; RETURN SpecialKind.NegInf
      END
    END Inf;

  (* ReadReal *)
  VAR c: CHAR; prefix: REF ARRAY OF [0..9]; BEGIN
    exp := 0;
    Skip(rd, Blanks);
    TRY
      c := Rd.GetChar(rd);
      sign := ReadSign(rd, c);
      IF ReadFloVal(rd, c, prefix, digits, digCnt, exp) THEN
        RETURN prefix
      END;
    EXCEPT
      Rd.EndOfFile =&gt; RAISE Error
    END;
    IF digCnt = 0 THEN
      &lt;* ASSERT prefix = NIL *&gt;
      IF NOT FloatMode.IEEE THEN
        Rd.UnGetChar(rd);
        RAISE Error
      END;
      (* check for NAN, INFINITY here *)
      CASE c OF
        'I', 'i' =&gt;
          M('N'); M('F');
          TRY
            c := Rd.GetChar(rd);
            CASE c OF
              'I', 'i' =&gt; M('N'); M('I'); M('T'); M('Y')
            ELSE Rd.UnGetChar(rd)
            END
          EXCEPT Rd.EndOfFile =&gt; (* SKIP *)
          END;
          RAISE SpecialReal(Inf(sign))
      | 'N', 'n' =&gt;
          M('A'); M('N');
          RAISE SpecialReal(SpecialKind.NaN)
      ELSE Rd.UnGetChar(rd); RAISE Error
      END
    END;
    TRY exp := exp + ReadExponent(rd, c) EXCEPT IntOverflow (neg) =&gt;
      IF neg
        THEN RAISE FloatMode.Trap(FloatMode.Flag.Underflow)
        ELSE RAISE FloatMode.Trap(FloatMode.Flag.Overflow)
      END
    END;
    RETURN prefix
  END ReadReal;

PROCEDURE <A NAME="ConcatDigits"><procedure>ConcatDigits</procedure></A>(READONLY d1, d2: ARRAY OF [0..9]): REF ARRAY OF [0..9] =
</PRE><BLOCKQUOTE><EM> Return a new array of digits containing the concatenation of the digits in
   <CODE>d1</CODE> and <CODE>d2</CODE>. </EM></BLOCKQUOTE><PRE>
  VAR
    d1Cnt := NUMBER(d1); d2Cnt := NUMBER(d2);
    res := NEW(REF ARRAY OF [0..9], d1Cnt + d2Cnt);
  BEGIN
    SUBARRAY(res^, 0, d1Cnt) := d1;
    SUBARRAY(res^, d1Cnt, d2Cnt) := d2;
    RETURN res
  END ConcatDigits;

PROCEDURE <A NAME="Real"><procedure>Real</procedure></A>(rd: Rd.T): REAL
    RAISES {Error, FloatMode.Trap, Rd.Failure, Alerted} =
  VAR
    sign: [0..1];
    prefix: REF ARRAY OF [0..9];
    digits: DigitBuf;
    digCnt: CARDINAL;
    exp: INTEGER;
  BEGIN
    TRY
      prefix := ReadReal(rd, sign, digits, digCnt, exp);
      IF prefix = NIL THEN
	RETURN RealFloat.FromDecimal(sign, SUBARRAY(digits, 0, digCnt), exp)
      ELSE
	VAR digs := ConcatDigits(prefix^, SUBARRAY(digits, 0, digCnt)); BEGIN
	  RETURN RealFloat.FromDecimal(sign, digs^, exp)
	END
      END
    EXCEPT SpecialReal(kind) =&gt;
      CASE kind OF
        SpecialKind.NegInf =&gt; RETURN IEEESpecial.RealNegInf
      | SpecialKind.PosInf =&gt; RETURN IEEESpecial.RealPosInf
      | SpecialKind.NaN    =&gt; RETURN IEEESpecial.RealNan
      END
    END
  END Real;

PROCEDURE <A NAME="LongReal"><procedure>LongReal</procedure></A>(rd: Rd.T): LONGREAL
    RAISES {Error, FloatMode.Trap, Rd.Failure, Alerted} =
  VAR
    sign: [0..1];
    prefix: REF ARRAY OF [0..9];
    digits: DigitBuf;
    digCnt: CARDINAL;
    exp: INTEGER;
  BEGIN
    TRY
      prefix := ReadReal(rd, sign, digits, digCnt, exp);
      IF prefix = NIL THEN
	RETURN LongFloat.FromDecimal(sign, SUBARRAY(digits, 0, digCnt), exp)
      ELSE
	VAR digs := ConcatDigits(prefix^, SUBARRAY(digits, 0, digCnt)); BEGIN
	  RETURN LongFloat.FromDecimal(sign, digs^, exp)
	END
      END
    EXCEPT SpecialReal(kind) =&gt;
      CASE kind OF
        SpecialKind.NegInf =&gt; RETURN IEEESpecial.LongNegInf
      | SpecialKind.PosInf =&gt; RETURN IEEESpecial.LongPosInf
      | SpecialKind.NaN    =&gt; RETURN IEEESpecial.LongNan
      END
    END
  END LongReal;

PROCEDURE <A NAME="Extended"><procedure>Extended</procedure></A>(rd: Rd.T): EXTENDED
    RAISES {Error, FloatMode.Trap, Rd.Failure, Alerted} =
  VAR
    sign: [0..1];
    prefix: REF ARRAY OF [0..9];
    digits: DigitBuf;
    digCnt: CARDINAL;
    exp: INTEGER;
  BEGIN
    TRY
      prefix := ReadReal(rd, sign, digits, digCnt, exp);
      IF prefix = NIL THEN
	RETURN ExtendedFloat.FromDecimal(sign,SUBARRAY(digits, 0, digCnt),exp)
      ELSE
	VAR digs := ConcatDigits(prefix^, SUBARRAY(digits, 0, digCnt)); BEGIN
	  RETURN ExtendedFloat.FromDecimal(sign, digs^, exp)
	END
      END
    EXCEPT SpecialReal(kind) =&gt;
      CASE kind OF
        SpecialKind.NegInf =&gt; RETURN IEEESpecial.ExtdNegInf
      | SpecialKind.PosInf =&gt; RETURN IEEESpecial.ExtdPosInf
      | SpecialKind.NaN    =&gt; RETURN IEEESpecial.ExtdNan
      END
    END
  END Extended;

BEGIN END Lex.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface FloatMode is in:
</A><UL>
<LI><A HREF="../../float/src/DS3100/FloatMode.i3#0TOP0">float/src/DS3100/FloatMode.i3</A>
<LI><A HREF="../../float/src/IEEE-default/FloatMode.i3#0TOP0">float/src/IEEE-default/FloatMode.i3</A>
<LI><A HREF="../../float/src/IRIX5/FloatMode.i3#0TOP0">float/src/IRIX5/FloatMode.i3</A>
<LI><A HREF="../../float/src/SOLsun/FloatMode.i3#0TOP0">float/src/SOLsun/FloatMode.i3</A>
<LI><A HREF="../../float/src/SPARC/FloatMode.i3#0TOP0">float/src/SPARC/FloatMode.i3</A>
<LI><A HREF="../../float/src/SUN386/FloatMode.i3#0TOP0">float/src/SUN386/FloatMode.i3</A>
<LI><A HREF="../../float/src/VAX/FloatMode.i3#0TOP0">float/src/VAX/FloatMode.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
