<HTML>
<HEAD>
<TITLE>SRC Modula-3: fmtlex/src/Scan.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>fmtlex/src/Scan.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> The <CODE>Scan</CODE> interface provides procedures for reading strings,
   booleans, integers, and floating-point numbers from a text string.
   Similar functionality on readers is availble from the <CODE>Lex</CODE>
   interface. 

<P><PRE>INTERFACE <interface><A HREF="Scan.m3">Scan</A></interface>;

IMPORT <A HREF="../../word/src/Word.i3">Word</A>, <A HREF="Lex.i3">Lex</A>, <A HREF="#x1">FloatMode</A>;
</PRE> Each of these procedures parses a string of characters and converts
   it to a binary value.  Leading and trailing blanks (ie. characters
   in <CODE>Lex.Blanks</CODE>) are ignored.  <CODE>Lex.Error</CODE> is raised if the first
   non-blank substring is not generated by the corresponding <CODE>Lex</CODE>
   grammar or if there are zero or more than one non-blank substrings.
   <CODE>FloatMode.Trap</CODE> is raised as per <CODE>Lex</CODE>. 

<P><PRE>PROCEDURE <A HREF="Scan.m3#Bool">Bool</A>(txt: TEXT): BOOLEAN
  RAISES {Lex.Error};

PROCEDURE <A HREF="Scan.m3#Int">Int</A>(txt: TEXT; defaultBase: [2..16] := 10): INTEGER
  RAISES {Lex.Error, FloatMode.Trap};
PROCEDURE <A HREF="Scan.m3#Unsigned">Unsigned</A>(txt: TEXT; defaultBase: [2..16] := 16): Word.T
  RAISES {Lex.Error, FloatMode.Trap};

PROCEDURE <A HREF="Scan.m3#Real">Real</A>(txt: TEXT): REAL
  RAISES {Lex.Error, FloatMode.Trap};
PROCEDURE <A HREF="Scan.m3#LongReal">LongReal</A>(txt: TEXT): LONGREAL
  RAISES {Lex.Error, FloatMode.Trap};
PROCEDURE <A HREF="Scan.m3#Extended">Extended</A>(txt: TEXT): EXTENDED
  RAISES {Lex.Error, FloatMode.Trap};

END Scan.
</PRE>
</inInterface>
<HR>
<A NAME="x1">interface FloatMode is in:
</A><UL>
<LI><A HREF="../../float/src/DS3100/FloatMode.i3#0TOP0">float/src/DS3100/FloatMode.i3</A>
<LI><A HREF="../../float/src/IEEE-default/FloatMode.i3#0TOP0">float/src/IEEE-default/FloatMode.i3</A>
<LI><A HREF="../../float/src/IRIX5/FloatMode.i3#0TOP0">float/src/IRIX5/FloatMode.i3</A>
<LI><A HREF="../../float/src/SOLsun/FloatMode.i3#0TOP0">float/src/SOLsun/FloatMode.i3</A>
<LI><A HREF="../../float/src/SPARC/FloatMode.i3#0TOP0">float/src/SPARC/FloatMode.i3</A>
<LI><A HREF="../../float/src/SUN386/FloatMode.i3#0TOP0">float/src/SUN386/FloatMode.i3</A>
<LI><A HREF="../../float/src/VAX/FloatMode.i3#0TOP0">float/src/VAX/FloatMode.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
