<HTML>
<HEAD>
<TITLE>SRC Modula-3: formsvbt/src/FVRuntime.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>formsvbt/src/FVRuntime.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                       </EM></BLOCKQUOTE><PRE>

INTERFACE <interface><A HREF="#x1">FVRuntime</A></interface>;
</PRE> This is the (private) interface for FormsVBT. 

<P><PRE>IMPORT <A HREF="../../atom/src/Atom.i3">Atom</A>, <A HREF="../../geometry/src/Axis.i3">Axis</A>, <A HREF="../../ui/src/split/ButtonVBT.i3">ButtonVBT</A>, <A HREF="../../lego/src/ChoiceVBT.i3">ChoiceVBT</A>, <A HREF="../../color/src/Color.i3">Color</A>, <A HREF="../../lego/src/FlexVBT.i3">FlexVBT</A>, <A HREF="../../ui/src/vbt/Font.i3">Font</A>,
       <A HREF="FormsVBT.i3">FormsVBT</A>, <A HREF="FVTypes.i3">FVTypes</A>, <A HREF="../../ui/src/split/HVSplit.i3">HVSplit</A>, <A HREF="../../lego/src/ListVBT.i3">ListVBT</A>, <A HREF="../../ui/src/vbt/PaintOp.i3">PaintOp</A>,
       <A HREF="../../ui/src/vbt/Pixmap.i3">Pixmap</A>, <A HREF="../../rw/src/Common/Rd.i3">Rd</A>, <A HREF="../../libm3/derived/RefList.i3">RefList</A>, <A HREF="../../vbtkitutils/src/Rsrc.i3">Rsrc</A>, <A HREF="../../lego/src/Shadow.i3">Shadow</A>, <A HREF="../../sx/src/Sx.i3">Sx</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>, <A HREF="../../lego/src/ZChildVBT.i3">ZChildVBT</A>, <A HREF="../../ui/src/split/ZSplit.i3">ZSplit</A>;
IMPORT <A HREF="StubImageVBT.i3">StubImageVBT</A> AS ImageVBT;

TYPE
  <A HREF="FormsVBT.m3#Private">Private</A> &lt;: SemiPublic;
  SemiPublic =
    FormsVBT.Public OBJECT
      path     : Rsrc.Path;
      formstack: RefList.T   := NIL
      (* The current (parse-time) sub-form.  For reporting errors. *)
    END;
  Millimeters = REAL;
  Points = REAL;

CONST
  EMPTYSHAPE = FlexVBT.Shape {
                 FlexVBT.SizeRange {0.0, 0.0, 0.0},
                 FlexVBT.SizeRange {0.0, 0.0, 0.0}};
  DefaultShadowSizePts: Points = 1.5;
  DefaultShadowSize: Millimeters = DefaultShadowSizePts * 25.4 / 72.0;

PROCEDURE <A HREF="FVRuntime.m3#SetFirstFocus">SetFirstFocus</A> (widget: VBT.T);
PROCEDURE <A HREF="FVRuntime.m3#SetPopTarget">SetPopTarget</A> (source: ButtonVBT.T; target: ZChildVBT.T);
PROCEDURE <A HREF="FVRuntime.m3#SetLinkTarget">SetLinkTarget</A> (source: ButtonVBT.T; target: VBT.T);
PROCEDURE <A HREF="FVRuntime.m3#SetPageTarget">SetPageTarget</A> (source: ButtonVBT.T; target: FVTypes.FVTSplit);

PROCEDURE <A HREF="FVRuntime.m3#SetVBT">SetVBT</A> (fv: FormsVBT.T; name: TEXT; vbt: VBT.T)
  RAISES {FormsVBT.Error};

TYPE
  State = RECORD
            (* The inherited properties: *)
            bgOp, fgOp, darkOp, lightOp: PaintOp.T;

            bgRGB    := Color.T {0.8, 0.8, 0.8};
            fgRGB    := Color.T {0.0, 0.0, 0.0};
            darkRGB  := Color.T {0.333, 0.333, 0.333};
            lightRGB := Color.T {1.0, 1.0, 1.0};

            fontName, labelFontName      : TEXT;
            font, labelFont              : Font.T;
            fontMetrics, labelFontMetrics: RefList.T;

            shadow  : Shadow.T;
            shadowSz: Millimeters := DefaultShadowSize;

            (* The various &quot;scoping&quot; properties: *)
            glueAxis: Axis.T            := Axis.T.Hor;
            hvsplit : HVSplit.T         := NIL;
            macros  : RefList.T            := NIL;
            menubar : VBT.T             := NIL;
            radio   : FVTypes.FVRadio   := NIL;
            tsplit  : FVTypes.FVTSplit  := NIL;
            zchild  : ZChildVBT.T       := NIL;
            zsplit  : ZSplit.T          := NIL;

            (* Per component info: *)
            name: TEXT := NIL;
          END;

VAR DefaultFontMetrics, DefaultLabelFontMetrics: RefList.T; (* CONST *)

PROCEDURE <A HREF="FormsVBT.m3#InitParser">InitParser</A> ();

PROCEDURE <A HREF="FormsVBT.m3#Parse">Parse</A> (         t          : FormsVBT.T;
                          description: Sx.T;
                 READONLY state      : State           ): VBT.T
  RAISES {FormsVBT.Error};

PROCEDURE <A HREF="FVRuntime.m3#NamedVBTs">NamedVBTs</A> (t: FormsVBT.T): RefList.T;
</PRE><BLOCKQUOTE><EM> Returns an alist of names and VBTs, sorted by name. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="FVRuntime.m3#GetAttachments">GetAttachments</A> (fv: FormsVBT.T): RefList.T;
PROCEDURE <A HREF="FVRuntime.m3#SetAttachments">SetAttachments</A> (fv: FormsVBT.T; alist: RefList.T)
  RAISES {FormsVBT.Error};
</PRE> These routines get and set the procedures that are attached to <CODE>fv</CODE>
   via Attach.  <CODE>alist</CODE> is an association list of names and [internal]
   refs that contain the actual procedures.  This is used by
   FormsEditVBT to copy the attachments from one FormsVBT to its
   replacement.
<P>
   SetAttachments will raise Error if an attachment fails, probably because
   <CODE>fv</CODE> does not contain a named VBT for every name in the alist. 

<P><PRE>PROCEDURE <A HREF="FVRuntime.m3#FindFont">FindFont</A> (fontname: TEXT): Font.T;
 (* This maintains a cache of fonts, indexed by names. *)

PROCEDURE <A HREF="FormsVBT.m3#MetricsToName">MetricsToName</A> (metrics: RefList.T): TEXT;
</PRE><BLOCKQUOTE><EM> Convert a metrics-list into a font-name. </EM></BLOCKQUOTE><PRE>

REVEAL FVTypes.FVImage &lt;: PrivateImage;
TYPE
  PrivateImage = ImageVBT.T OBJECT
    op: PaintOp.T; (* to paint the image *)
    bg: PaintOp.T; (* to paint empty space in VBT *)
    gamma: REAL; (* gamma correction *)
    rd: Rd.T; (* reader on the ppm file *)
  END;

PROCEDURE <A HREF="FormsVBT.m3#GetPixmap">GetPixmap</A> (name: TEXT; path: Rsrc.Path): Pixmap.T
   RAISES {FormsVBT.Error};

REVEAL FVTypes.UniSelector &lt;: PrivateUniSelector;
TYPE
  PrivateUniSelector = ListVBT.UniSelector OBJECT
                         quick  : BOOLEAN;
                         browser: FVTypes.FVBrowser
                       END;

REVEAL FVTypes.MultiSelector &lt;: PrivateMultiSelector;
TYPE
  PrivateMultiSelector = ListVBT.MultiSelector OBJECT
                           quick  : BOOLEAN;
                           browser: FVTypes.FVMultiBrowser
                         END;

REVEAL FVTypes.FVCloseButton &lt;: PrivateCloseButton;
TYPE
  PrivateCloseButton =
    FVTypes.PublicCloseButton OBJECT target: ZChildVBT.T END;

REVEAL FVTypes.FVChoice &lt;: PrivateChoice;
TYPE
  PrivateChoice = ChoiceVBT.T OBJECT
                    radio: FVTypes.FVRadio;
                    name : TEXT
                  END;

VAR
  FVSyntax: Sx.Syntax; (* The syntax used by the parser. *)

  qBOA, qName, qValue, qBackquote, qComma, qCommaAtsign, qQuote: Atom.T;
  (* Symbols needed by the parser and FormsEdit. *)

PROCEDURE <A HREF="FVRuntime.m3#ToText">ToText</A> (x        : REFANY;
                  maxDepth : CARDINAL := LAST (CARDINAL);
                  maxLength: CARDINAL := LAST (CARDINAL)  ): TEXT;

END FVRuntime.
</PRE>
</inInterface>
<HR>
<A NAME="x1">FVRuntime's implementation  is in:
</A><UL>
<LI><A HREF="FVRuntime.m3#0TOP0">formsvbt/src/FVRuntime.m3</A>
<LI><A HREF="FormsVBT.m3#0TOP0">formsvbt/src/FormsVBT.m3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
