<HTML>
<HEAD>
<TITLE>SRC Modula-3: formsvbt/src/FVRuntime.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>formsvbt/src/FVRuntime.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>

MODULE <module>FVRuntime</module> EXPORTS <A HREF="FVRuntime.i3"><implements>FVRuntime</A></implements>, <A HREF="FVTypes.i3"><implements>FVTypes</A></implements>, <A HREF="FormsVBT.i3"><implements>FormsVBT</A></implements>;
</PRE> This module contains the runtime code for FormsVBTs. 

<P><PRE>IMPORT <A HREF="../../lego/src/AnchorSplit.i3">AnchorSplit</A>, <A HREF="../../vbtkitutils/src/AnyEvent.i3">AnyEvent</A>, <A HREF="../../atom/src/Atom.i3">Atom</A>, <A HREF="../../videovbt/src/AudioVBT.i3">AudioVBT</A>, <A HREF="../../geometry/src/Axis.i3">Axis</A>, <A HREF="../../lego/src/BooleanVBT.i3">BooleanVBT</A>,
       <A HREF="../../ui/src/split/BorderedVBT.i3">BorderedVBT</A>, <A HREF="../../ui/src/split/ButtonVBT.i3">ButtonVBT</A>, <A HREF="../../lego/src/ChoiceVBT.i3">ChoiceVBT</A>, <A HREF="../../color/src/Color.i3">Color</A>, <A HREF="../../color/src/ColorName.i3">ColorName</A>,
       <A HREF="../../ui/src/vbt/Cursor.i3">Cursor</A>, <A HREF="../../lego/src/FileBrowserVBT.i3">FileBrowserVBT</A>, <A HREF="../../rw/src/Common/FileRd.i3">FileRd</A>, <A HREF="../../ui/src/split/Filter.i3">Filter</A>, <A HREF="../../lego/src/FlexVBT.i3">FlexVBT</A>,
       <A HREF="../../formsvbtpixmaps/derived/FormsVBTPixmapsBundle.i3">FormsVBTPixmapsBundle</A>, <A HREF="../../fmtlex/src/Fmt.i3">Fmt</A>, <A HREF="../../ui/src/vbt/Font.i3">Font</A>, <A HREF="../../lego/src/GuardedBtnVBT.i3">GuardedBtnVBT</A>,
       <A HREF="../../ui/src/split/HighlightVBT.i3">HighlightVBT</A>, <A HREF="../../ui/src/split/HVSplit.i3">HVSplit</A>, <A HREF="../../rw/src/Common/IO.i3">IO</A>,
       <A HREF="../../jvideo/src/Jva.i3">Jva</A>, <A HREF="../../jvideo/src/JVSink.i3">JVSink</A>, <A HREF="../../lego/src/ListVBT.i3">ListVBT</A>, <A HREF="Macro.i3">Macro</A>,
       <A HREF="../../lego/src/MenuSwitchVBT.i3">MenuSwitchVBT</A>, <A HREF="../../lego/src/MultiClass.i3">MultiClass</A>, <A HREF="../../lego/src/MultiSplit.i3">MultiSplit</A>, <A HREF="../../lego/src/NumericVBT.i3">NumericVBT</A>,
       <A HREF="../../os/src/Common/OSError.i3">OSError</A>, <A HREF="../../ui/src/vbt/PaintOp.i3">PaintOp</A>, <A HREF="../../os/src/Common/Pathname.i3">Pathname</A>, <A HREF="../../lego/src/PixmapVBT.i3">PixmapVBT</A>, <A HREF="../../vbtkitutils/src/Pts.i3">Pts</A>, <A HREF="../../rw/src/Common/Rd.i3">Rd</A>, <A HREF="../../rw/src/Common/RdUtils.i3">RdUtils</A>,
       <A HREF="../../lego/src/ReactivityVBT.i3">ReactivityVBT</A>, <A HREF="../../libm3/derived/RefList.i3">RefList</A>, <A HREF="../../vbtkitutils/src/Rsrc.i3">Rsrc</A>, <A HREF="../../runtime/src/common/RTTypeSRC.i3">RTTypeSRC</A>, <A HREF="../../lego/src/ScaleFilter.i3">ScaleFilter</A>,
       <A HREF="../../lego/src/ScrollerVBT.i3">ScrollerVBT</A>, <A HREF="../../lego/src/Shadow.i3">Shadow</A>, <A HREF="../../lego/src/ShadowedVBT.i3">ShadowedVBT</A>, <A HREF="../../lego/src/ShadowedFeedbackVBT.i3">ShadowedFeedbackVBT</A>,
       <A HREF="../../libm3/derived/SortedTextRefTbl.i3">SortedTextRefTbl</A>, <A HREF="../../lego/src/SourceVBT.i3">SourceVBT</A>, <A HREF="../../ui/src/split/Split.i3">Split</A>, <A HREF="../../lego/src/SplitterVBT.i3">SplitterVBT</A>,
       <A HREF="../../lego/src/SwitchVBT.i3">SwitchVBT</A>, <A HREF="../../sx/src/Sx.i3">Sx</A>, <A HREF="../../text/src/Text.i3">Text</A>, <A HREF="../../etext/src/TextEditVBT.i3">TextEditVBT</A>, <A HREF="../../etext/src/TextPort.i3">TextPort</A>, <A HREF="../../etext/src/TextPortClass.i3">TextPortClass</A>,
       <A HREF="../../rw/src/Common/TextRd.i3">TextRd</A>, <A HREF="../../ui/src/split/TextureVBT.i3">TextureVBT</A>, <A HREF="../../ui/src/split/TextVBT.i3">TextVBT</A>, <A HREF="../../rw/src/Common/TextWr.i3">TextWr</A>, <A HREF="../../thread/src/Common/Thread.i3">Thread</A>,
       <A HREF="../../lego/src/TrillSwitchVBT.i3">TrillSwitchVBT</A>, <A HREF="../../ui/src/split/TSplit.i3">TSplit</A>, <A HREF="../../libm3/derived/TextIntTbl.i3">TextIntTbl</A>, <A HREF="../../etext/src/TypeinVBT.i3">TypeinVBT</A>,
       <A HREF="../../etext/src/TypescriptVBT.i3">TypescriptVBT</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>, <A HREF="../../ui/src/vbt/VBTClass.i3">VBTClass</A>, <A HREF="../../rw/src/Common/Wr.i3">Wr</A>, <A HREF="../../lego/src/ZChassisVBT.i3">ZChassisVBT</A>, <A HREF="../../lego/src/ZChildVBT.i3">ZChildVBT</A>,
       <A HREF="../../ui/src/split/ZSplit.i3">ZSplit</A>, <A HREF="../../lego/src/ZSplitUtils.i3">ZSplitUtils</A>;
IMPORT <A HREF="StubImageRd.i3">StubImageRd</A> AS ImageRd;
IMPORT <A HREF="StubImageVBT.i3">StubImageVBT</A> AS ImageVBT;

FROM <A HREF="RefListUtils.i3">RefListUtils</A> IMPORT Push, Pop;

&lt;* PRAGMA LL *&gt;

REVEAL
  <A NAME="T">T</A> = Private BRANDED OBJECT
        mu: MUTEX;
        &lt;* LL = mu *&gt;
        getVBT     : SortedTextRefTbl.T;
        eventCount : CARDINAL              := 0;
        keyRec     : REF VBT.KeyRec;
        mouseRec   : REF VBT.MouseRec;
        positionRec: REF VBT.PositionRec;
        miscRec    : REF VBT.MiscRec;
        eventCode  : CARDINAL              := 0; (* typecode of event *)
        timeStamp  : VBT.TimeStamp;
        gensym                             := 0;
        raw                                := FALSE;
      OVERRIDES
        init         := InitFromText;
        initFromFile := InitFromFile;
        initFromSx   := InitFromSx;
        initFromRd   := InitFromRd;
        initFromRsrc := InitFromRsrc;
        snapshot     := Snapshot;
        restore      := Restore;
      END;

VAR cleanState: State;            (* CONST *)
</PRE>************************** Creation ******************************
  
<P><PRE>PROCEDURE <A NAME="NewFromFile"><procedure>NewFromFile</procedure></A> (filename: TEXT; raw := FALSE; path: Rsrc.Path := NIL): T
  RAISES {Error, Rd.Failure, Thread.Alerted} =
  BEGIN
    RETURN NEW (T).initFromFile (filename, raw, path)
  END NewFromFile;

PROCEDURE <A NAME="InitFromFile"><procedure>InitFromFile</procedure></A> (fv      : T;
                        filename: TEXT;
                        raw                 := FALSE;
                        path    : Rsrc.Path := NIL    ): T
  RAISES {Error, Rd.Failure, Thread.Alerted} =
  VAR rd: Rd.T;
  BEGIN
    TRY
      rd := FileRd.Open (filename);
      TRY RETURN InitFromRd (fv, rd, raw, path) FINALLY Rd.Close (rd) END
    EXCEPT
    | OSError.E (code) =&gt; RAISE Error (Atom.ToText (code.head))
    END
  END InitFromFile;

PROCEDURE <A NAME="InitFromText"><procedure>InitFromText</procedure></A> (fv         : T;
                        description: TEXT;
                        raw                    := FALSE;
                        path       : Rsrc.Path := NIL    ): T RAISES {Error} =
  &lt;* FATAL Rd.Failure, Thread.Alerted *&gt;
  BEGIN
    RETURN InitFromRd (fv, TextRd.New (description), raw, path)
  END InitFromText;

TYPE
  ReaderClosure = Thread.SizedClosure OBJECT
                    rd     : Rd.T;
                    errType: ErrType;
                    errArg : REFANY
                  OVERRIDES
                    apply := Read
                  END;
  ErrType = {ReadError, EndOfFile, Failure, Alerted};

PROCEDURE <A NAME="Read"><procedure>Read</procedure></A> (rc: ReaderClosure): REFANY =
  VAR
    exp  : REFANY;
    gotIt         := FALSE;
  BEGIN
    TRY
      exp := Sx.Read (rc.rd, syntax := FVSyntax);
      gotIt := TRUE;
      IF Rd.EOF (rc.rd) THEN RETURN exp END;
      (* Check for extra garbage: *)
      EVAL Sx.Read (rc.rd, syntax := FVSyntax);
      RAISE Sx.ReadError (&quot;extra characters on input&quot;)
    EXCEPT
    | Sx.ReadError (Text) =&gt; rc.errArg := Text; rc.errType := ErrType.ReadError
    | Rd.EndOfFile =&gt;
        IF gotIt THEN RETURN exp END;
        rc.errType := ErrType.EndOfFile
    | Rd.Failure (ref) =&gt; rc.errArg := ref; rc.errType := ErrType.Failure
    | Thread.Alerted =&gt; rc.errType := ErrType.Alerted
    END;
    (* If there's an error, we return the ReaderClosure itself. *)
    RETURN rc
  END Read;

PROCEDURE <A NAME="InitFromRd"><procedure>InitFromRd</procedure></A> (fv: T; rd: Rd.T; raw := FALSE; path: Rsrc.Path := NIL): T
  RAISES {Error, Rd.Failure, Thread.Alerted} =
  BEGIN
    TYPECASE
        Thread.Join (
          Thread.Fork (NEW (ReaderClosure, rd := rd, stackSize := 10000))) OF
    | ReaderClosure (rc) =&gt;
        CASE rc.errType OF
        | ErrType.ReadError =&gt; RAISE Error (&quot;Sx.ReadError: &quot; &amp; rc.errArg)
        | ErrType.EndOfFile =&gt; RAISE Error (&quot;End of input&quot;)
        | ErrType.Failure =&gt; RAISE Rd.Failure (rc.errArg)
        | ErrType.Alerted =&gt; RAISE Thread.Alerted
        END
    | REFANY (desc) =&gt; RETURN InitFromSx (fv, desc, raw, path)
    END
  END InitFromRd;

PROCEDURE <A NAME="InitFromRsrc"><procedure>InitFromRsrc</procedure></A> (fv: T; name: TEXT; path: Rsrc.Path; raw := FALSE): T
  RAISES {Error, Rd.Failure, Rsrc.NotFound, Thread.Alerted} =
  VAR rd: Rd.T;
  BEGIN
    rd := Rsrc.Open (name, path);
    TRY RETURN InitFromRd (fv, rd, raw, path) FINALLY Rd.Close (rd) END
  END InitFromRsrc;

TYPE
  MC = MultiClass.Filter OBJECT
       OVERRIDES
         succ    := Succ;
         pred    := Succ;
         replace := Replace
       END;

PROCEDURE <A NAME="Replace"><procedure>Replace</procedure></A> (m: MC; &lt;* UNUSED *&gt; ch: VBT.T; new: VBT.T) =
  &lt;* FATAL Split.NotAChild *&gt;
  VAR fv: T := m.vbt;
  BEGIN
    IF fv.raw THEN
     EVAL  Filter.Replace (fv, new)
    ELSE
      WITH zsplit    = Filter.Child (fv),
           highlight = Split.Succ (zsplit, NIL),
           react     = Filter.Child (highlight) DO
        EVAL Filter.Replace (react, new)
      END
    END
  END Replace;

PROCEDURE <A NAME="Succ"><procedure>Succ</procedure></A> (m: MC; ch: VBT.T): VBT.T =
  &lt;* FATAL Split.NotAChild *&gt;
  VAR fv: T := m.vbt;
  BEGIN
    IF ch # NIL THEN
      RETURN NIL
    ELSIF fv.raw THEN
      RETURN Filter.Child (fv)
    ELSE
      WITH zsplit    = Filter.Child (fv),
           highlight = Split.Succ (zsplit, NIL),
           react     = Filter.Child (highlight) DO
        RETURN Filter.Child (react)
      END
    END
  END Succ;

PROCEDURE <A NAME="InitFromSx"><procedure>InitFromSx</procedure></A> (fv         : T;
                      description: Sx.T;
                      raw                    := FALSE;
                      path       : Rsrc.Path := NIL    ): T
  RAISES {Error} =
  VAR
    state        := cleanState;
    ch   : VBT.T;
  BEGIN
    fv.getVBT := NEW(SortedTextRefTbl.Default).init();
    fv.mu := NEW(MUTEX);
    fv.keyRec := NEW(REF VBT.KeyRec);
    fv.mouseRec := NEW(REF VBT.MouseRec);
    fv.positionRec := NEW(REF VBT.PositionRec);
    fv.miscRec := NEW(REF VBT.MiscRec);
    fv.path :=
      RefList.Append(
        path, RefList.List1(FormsVBTPixmapsBundle.Get()));
    fv.raw := raw;
    MultiClass.Be(fv, NEW(MC));
    state.menubar := NEW(VBT.T);
    IF raw THEN
      (* fv = (Filter parsedVBT) *)
      ch := Parse(fv, description, state);
      EVAL Filter.T.init(fv, ch);
    ELSE
      (* fv = (Filter (ZSplit (Highlight (Reactivity
         parsedVBT)))) *)
      (* The trick here is that state.zsplit must already be set
         BEFORE we parse the description. *)
      WITH react     = NEW(FVFilter),
           highlight = NEW(HighlightVBT.T).init(react),
           zsplit    = NEW(ZSplit.T).init(highlight)    DO
        EVAL Filter.T.init(fv, zsplit);
        state.zsplit := zsplit;
        ch := Parse(fv, description, state);
        EVAL react.init(ch)
      END
    END;
    MultiClass.BeChild(fv, ch);
    RETURN fv
  END InitFromSx;

PROCEDURE <A NAME="GetZSplit"><procedure>GetZSplit</procedure></A> (fv: T): ZSplit.T RAISES {Error} =
  BEGIN
    IF fv.raw THEN RAISE Error (&quot;Uncooked FormsVBT (GetZSplit)&quot;) END;
    RETURN Filter.Child (fv)
  END GetZSplit;

PROCEDURE <A NAME="Insert"><procedure>Insert</procedure></A> (fv         : T;
                  parent     : TEXT;
                  description: TEXT;
                  at         : CARDINAL := LAST (CARDINAL)): VBT.T
  RAISES {Error} =
  VAR
    stateRef: REF State := VBT.GetProp (
                             GetVBT (fv, parent), TYPECODE (REF State));
    res: VBT.T;
    rd         := TextRd.New (description);
  BEGIN
    TRY
      res := Parse (fv, Sx.Read (rd, syntax := FVSyntax), stateRef^);
      Rd.Close (rd);
      InsertVBT (fv, parent, res, at);
      RETURN res
    EXCEPT
    | Sx.ReadError (text) =&gt; RAISE Error (&quot;Sx.ReadError: &quot; &amp; text)
    | Rd.EndOfFile =&gt; RAISE Error (&quot;End of input&quot;)
    | Rd.Failure =&gt;              &lt;* ASSERT FALSE *&gt;
    | Thread.Alerted =&gt; RAISE Error (&quot;Thread.Alerted&quot;)
    END
  END Insert;

PROCEDURE <A NAME="InsertFromFile"><procedure>InsertFromFile</procedure></A> (fv      : T;
                          parent  : TEXT;
                          filename: Pathname.T;
                          at      : CARDINAL     := LAST (CARDINAL)): VBT.T
  RAISES {Error, Rd.Failure, Thread.Alerted} =
  VAR rd: Rd.T;
  BEGIN
    TRY
      rd := FileRd.Open (filename);
      TRY
        RETURN Insert (fv, parent, Rd.GetText (rd, LAST (CARDINAL)), at)
      FINALLY
        Rd.Close (rd)
      END
    EXCEPT
    | OSError.E (code) =&gt; RAISE Error (Atom.ToText (code.head))
    END
  END InsertFromFile;

PROCEDURE <A NAME="InsertFromRsrc"><procedure>InsertFromRsrc</procedure></A> (fv    : T;
                          parent: TEXT;
                          name  : TEXT;
                          path  : Rsrc.Path;
                          n     : CARDINAL    := LAST (CARDINAL)): VBT.T
  RAISES {Error, Rd.Failure, Rsrc.NotFound, Thread.Alerted} =
  BEGIN
    RETURN Insert (fv, parent, Rsrc.Get (name, path), n)
  END InsertFromRsrc;
</PRE>************************** snapshots ******************************

<P><PRE>PROCEDURE <A NAME="GetVal"><procedure>GetVal</procedure></A> (fv: T; name: TEXT): REFANY =
  (* Returns value of name as REFANY, if a value can be
     retrieved *)
  BEGIN
    TRY
      WITH ri = NEW(REF INTEGER) DO
        ri^ := GetInteger(fv, name);
        RETURN ri
      END
    EXCEPT
      Error, Unimplemented =&gt;
    END;
    TRY
      WITH rb = NEW(REF BOOLEAN) DO
        rb^ := GetBoolean(fv, name);
        IF rb^ THEN RETURN Sx.True ELSE RETURN Sx.False END;
      END
    EXCEPT
      Error, Unimplemented =&gt;
    END;
    TRY
      RETURN GetText(fv, name);
    EXCEPT
      Error, Unimplemented =&gt;
    END;
    RETURN NIL
  END GetVal;

PROCEDURE <A NAME="Snapshot"><procedure>Snapshot</procedure></A> (fv: T; wr: Wr.T) RAISES {Error} =
  VAR
    key        : TEXT;
    val, ignore: REFANY;
    iter                   := fv.getVBT.iterateOrdered ();
    alist: RefList.T := NIL;
  BEGIN
    TRY
      WHILE iter.next (key, ignore) DO
        val := GetVal (fv, key);
        IF val # NIL THEN
          Push (alist, RefList.List2 (Atom.FromText (key), val))
        END
      END;
      Sx.Print (wr, alist);
      Wr.PutChar (wr, '\n')
    EXCEPT
    | Sx.PrintError, Thread.Alerted, Wr.Failure =&gt;
        RAISE Error (&quot;Problem writing snapshot&quot;);
    END
  END Snapshot;

PROCEDURE <A NAME="Restore"><procedure>Restore</procedure></A> (fv: T; rd: Rd.T) RAISES {Mismatch, Error} =
  VAR
    mismatch          := FALSE;
    ignoreRef: REFANY;
    name     : TEXT;
  BEGIN
    TRY
      TYPECASE Sx.Read(rd) OF
      | NULL =&gt;
      | RefList.T (sx) =&gt;
          WHILE sx # NIL DO
            TYPECASE sx.head OF
            | RefList.T (l) =&gt;
                IF RefList.Length(l) # 2 THEN
                  RAISE Error(&quot;Illegal expression in snapshot&quot;)
                END;
                TYPECASE l.head OF
                | Atom.T (sym) =&gt;
                    name := Atom.ToText(sym);
                    IF NOT fv.getVBT.get(name, ignoreRef) THEN
                      mismatch := TRUE
                    ELSE
                      TYPECASE l.tail.head OF
                      | TEXT (text) =&gt; PutText(fv, name, text)
                      | REF BOOLEAN (refBool) =&gt;
                          PutBoolean(fv, name, refBool^)
                      | REF INTEGER (refInt) =&gt;
                          PutInteger(fv, name, refInt^)
                      | Atom.T (atm) =&gt;
                          IF atm = Sx.True THEN
                            PutBoolean(fv, name, TRUE)
                          ELSIF atm = Sx.False THEN
                            PutBoolean(fv, name, FALSE)
                          ELSE
                            RAISE Error(&quot;Value of component &quot;
                                          &amp; Atom.ToText(sym)
                                          &amp; &quot; has illegal value: &quot;
                                          &amp; Atom.ToText(atm));
                          END;
                      ELSE
                        RAISE
                          Error(&quot;Value of component &quot; &amp; Atom.ToText(sym)
                                  &amp; &quot; has illegal type&quot;);
                      END        (* TYPECASE *)
                    END          (* IF *)
                ELSE
                  RAISE Error(&quot;Illegal component name in snapshot&quot;);
                END              (* TYPECASE *)
            ELSE
              RAISE Error(&quot;Snapshot is not a valid s-expression&quot;);
            END;                 (* TYPECASE *)
            sx := sx.tail
          END;                   (* WHILE *)
          IF mismatch THEN RAISE Mismatch END;
      ELSE
        RAISE Error(&quot;Snapshot is not a valid s-expression&quot;)
      END                        (* TYPECASE *)
    EXCEPT
    | Sx.ReadError, Rd.EndOfFile, Thread.Alerted, Unimplemented =&gt;
        RAISE Error(&quot;Problem with reading snapshot&quot;)
    END
  END Restore;
</PRE> ========================= Attachment ========================= 

<P><PRE>TYPE ClosureRef = BRANDED REF RECORD fv: T; name: TEXT; cl: Closure END;

PROCEDURE <A NAME="Attach"><procedure>Attach</procedure></A> (fv: T; name: TEXT; cl: Closure) RAISES {Error} =
  VAR vbt := GetVBT (fv, name);
  BEGIN
    TYPECASE vbt OF
    | FVBoolean, FVBrowser, FVButton, FVChoice, FVCloseButton, FVFileBrowser,
        FVGuard, FVLinkButton, FVLinkMButton, FVMButton, FVMenu,
        FVMultiBrowser, FVNumeric, FVPageButton, FVPageMButton, FVPopButton,
        FVPopMButton, FVRadio, FVScroller, FVSource,
        FVTextEdit, FVTrillButton, FVTypeIn,
        FVZChassis, FVZChild, ReservedVBT =&gt;
        IF cl # NIL THEN
          VBT.PutProp (
            vbt, NEW (ClosureRef, fv := fv, name := name, cl := cl))
        ELSE
          VBT.RemProp (vbt, TYPECODE (ClosureRef))
        END
    ELSE
      RAISE Error (&quot;The component named \&quot;&quot; &amp; name
                     &amp; &quot;\&quot; does not generate events.&quot;)
    END;
  END Attach;

PROCEDURE <A NAME="MouseProc"><procedure>MouseProc</procedure></A> (self: VBT.T; READONLY cd: VBT.MouseRec) =
  (* This is the callback, directly or indirectly, for all the components that
     generate events (see Attach) except TypeIn, TextEdit, and Numeric,
     which handle attachment directly and using KeyProc. *)
  VAR
    cr: ClosureRef := VBT.GetProp (self, TYPECODE (ClosureRef));
    fv: T;
  BEGIN
    IF cr # NIL THEN
      fv := cr.fv;
      LOCK fv.mu DO
        INC (fv.eventCount);
        IF fv.eventCount = 1 THEN
          fv.mouseRec^ := cd;
          fv.eventCode := TYPECODE (REF VBT.MouseRec)
        END
      END;
      TRY
        cr.cl.apply (fv, cr.name, cd.time)
      FINALLY
        LOCK fv.mu DO DEC (fv.eventCount) END
      END;
    END
  END MouseProc;

PROCEDURE <A NAME="KeyProc"><procedure>KeyProc</procedure></A> (self: VBT.T; READONLY cd: VBT.KeyRec) =
  VAR
    cr: ClosureRef := VBT.GetProp (self, TYPECODE (ClosureRef));
    fv: T;
  BEGIN
    IF cr # NIL THEN
      fv := cr.fv;
      LOCK fv.mu DO
        INC (fv.eventCount);
        IF fv.eventCount = 1 THEN
          fv.keyRec^ := cd;
          fv.eventCode := TYPECODE (REF VBT.KeyRec)
        END
      END;
      TRY
        cr.cl.apply (fv, cr.name, cd.time)
      FINALLY
        LOCK fv.mu DO DEC (fv.eventCount) END
      END
    END
  END KeyProc;

TYPE
  OldClosure = Closure OBJECT
                 ref : REFANY;
                 proc: Proc
               OVERRIDES
                 apply := OldApply
               END;

PROCEDURE <A NAME="AttachProc"><procedure>AttachProc</procedure></A> (fv: T; name: TEXT; proc: Proc; cl: REFANY := NIL)
  RAISES {Error} =
  BEGIN
    IF proc # NIL THEN
      Attach (fv, name, NEW (OldClosure, ref := cl, proc := proc))
    ELSE
      Attach (fv, name, NIL)
    END
  END AttachProc;

PROCEDURE <A NAME="OldApply"><procedure>OldApply</procedure></A> (oc: OldClosure; fv: T; name: TEXT; time: VBT.TimeStamp) =
  BEGIN
    oc.proc (fv, name, oc.ref, time)
  END OldApply;
</PRE> ========================= Edit Ops ========================= 

<P><PRE>TYPE
  C = Closure OBJECT
        port: TextPort.T;
        op  : Op
      OVERRIDES
        apply := ApplyEditOp
      END;
  Op = {cut, copy, paste, clear, selectAll, undo, redo, first, next, prev};

PROCEDURE <A NAME="AttachEditOps"><procedure>AttachEditOps</procedure></A> (fv        : T;
                         editorName: TEXT;
                         cut, copy, paste, clear,
                         selectAll, undo, redo,
                         findFirst, findNext, findPrev: TEXT := NIL)
  RAISES {Error} =
  VAR port: TextPort.T := NIL;
  BEGIN
    TYPECASE GetVBT (fv, editorName) OF
    | NULL =&gt;
    | FVTextEdit (vbt) =&gt; port := vbt.tp
    | FVNumeric (vbt) =&gt; port := vbt.typein
    | FVTypescript (vbt) =&gt; port := vbt.tp
    | FVTypeIn (vbt) =&gt; port := vbt
    ELSE
    END;
    IF port = NIL THEN
      RAISE
        Error (&quot;There's no TextPort in the component named \&quot;&quot; &amp;
          editorName &amp; &quot;\&quot;&quot;)
    END;
    IF cut # NIL THEN
      Attach (fv, cut, NEW (C, port := port, op := Op.cut))
    END;
    IF copy # NIL THEN
      Attach (fv, copy, NEW (C, port := port, op := Op.copy))
    END;
    IF paste # NIL THEN
      Attach (fv, paste, NEW (C, port := port, op := Op.paste))
    END;
    IF clear # NIL THEN
      Attach (fv, clear, NEW (C, port := port, op := Op.clear))
    END;
    IF selectAll # NIL THEN
      Attach (fv, selectAll, NEW (C, port := port, op := Op.selectAll))
    END;
    IF undo # NIL THEN
      Attach (fv, undo, NEW (C, port := port, op := Op.undo))
    END;
    IF redo # NIL THEN
      Attach (fv, redo, NEW (C, port := port, op := Op.redo))
    END;
    IF findFirst # NIL THEN
      Attach (fv, findFirst, NEW (C, port := port, op := Op.first))
    END;
    IF findNext # NIL THEN
      Attach (fv, findNext, NEW (C, port := port, op := Op.next))
    END;
    IF findPrev # NIL THEN
      Attach (fv, findPrev, NEW (C, port := port, op := Op.prev))
    END;
  END AttachEditOps;

PROCEDURE <A NAME="ApplyEditOp"><procedure>ApplyEditOp</procedure></A> (             cl  : C;
                       &lt;* UNUSED *&gt; fv  : T;
                       &lt;* UNUSED *&gt; name: TEXT;
                                    time: VBT.TimeStamp) =
  VAR
    port := cl.port;
    m    := port.m;
  BEGIN
    LOCK port.mu DO
      CASE cl.op OF
      | Op.cut =&gt; m.cut (time)
      | Op.copy =&gt; m.copy (time)
      | Op.paste =&gt; m.paste (time)
      | Op.clear =&gt; m.clear ()
      | Op.selectAll =&gt;
            m.select (time, 0, LAST (CARDINAL), replaceMode := TRUE)
      | Op.undo =&gt; TextPortClass.Undo (port)
      | Op.redo =&gt; TextPortClass.Redo (port)
      | Op.first =&gt; port.findSource (time, TextPortClass.Loc.First)
      | Op.next =&gt; port.findSource (time, TextPortClass.Loc.Next)
      | Op.prev =&gt; port.findSource (time, TextPortClass.Loc.Prev)
      END
    END
  END ApplyEditOp;

TYPE ReservedVBT = VBT.Leaf BRANDED OBJECT END;

PROCEDURE <A NAME="AddSymbol"><procedure>AddSymbol</procedure></A> (fv: T; name: TEXT) RAISES {Error} =
  VAR ref: REFANY;
  BEGIN
    LOCK fv.mu DO
      IF fv.getVBT.get (name, ref) THEN
        RAISE Error (&quot;The name &quot; &amp; name &amp; &quot; is already in use.&quot;)
      ELSE
        EVAL fv.getVBT.put (name, NEW (ReservedVBT))
      END
    END
  END AddSymbol;

PROCEDURE <A NAME="AddUniqueSymbol"><procedure>AddUniqueSymbol</procedure></A> (fv: T): TEXT =
  VAR
    ref : REFANY;
    name: TEXT;
  BEGIN
    LOCK fv.mu DO
      LOOP
        name := &quot;-v-b-t-&quot; &amp; Fmt.Int (fv.gensym);
        IF fv.getVBT.get (name, ref) THEN INC (fv.gensym) ELSE EXIT END
      END;
      EVAL fv.getVBT.put (name, NEW (ReservedVBT));
      RETURN name
    END
  END AddUniqueSymbol;
</PRE> ===================== MakeEvent &amp; GetTheEvent ==================== 

<P><PRE>VAR MakeEventSelection: VBT.Selection; (* CONST *)

PROCEDURE <A NAME="MakeEvent"><procedure>MakeEvent</procedure></A> (fv: T; name: TEXT; time: VBT.TimeStamp) RAISES {Error} =
  &lt;* LL = VBT.mu *&gt;
  VAR
    vbt                    := GetVBT (fv, name);
    cr        : ClosureRef := VBT.GetProp (vbt, TYPECODE (ClosureRef));
    popTarget : PopTarget  := VBT.GetProp (vbt, TYPECODE (PopTarget));
    pageTarget: PageTarget := VBT.GetProp (vbt, TYPECODE (PageTarget));
    linkTarget: LinkTarget := VBT.GetProp (vbt, TYPECODE (LinkTarget));
  BEGIN
    IF cr = NIL AND popTarget = NIL AND pageTarget = NIL AND linkTarget = NIL THEN
      RAISE Error (&quot;Nothing attached to &quot; &amp; name)
    END;
    IF popTarget # NIL THEN
      popTarget.apply (time)
    ELSIF pageTarget # NIL THEN
      pageTarget.apply (time)
    ELSIF linkTarget # NIL THEN
      linkTarget.apply (time)
    END;
    IF cr # NIL THEN
      LOCK fv.mu DO
        INC (fv.eventCount);
        IF fv.eventCount = 1 THEN
          fv.miscRec.type := MakeEventMiscCodeType;
          fv.miscRec.time := time;
          fv.miscRec.selection := MakeEventSelection;
          fv.eventCode := TYPECODE (REF VBT.MiscRec)
        END
      END;
      TRY
        cr.cl.apply (cr.fv, cr.name, time)
      FINALLY
        LOCK fv.mu DO DEC (fv.eventCount) END
      END
    END
  END MakeEvent;

PROCEDURE <A NAME="GetTheEvent"><procedure>GetTheEvent</procedure></A> (fv: T): AnyEvent.T RAISES {Error} =
  VAR tc: CARDINAL;
  BEGIN
    LOCK fv.mu DO
      tc := fv.eventCode;
      IF fv.eventCount = 0 THEN
        RAISE Error (&quot;There is no active event&quot;)
      (*
      ELSIF fv.eventCount &gt; 1 THEN
        RAISE Error (&quot;More than 1 event is active&quot;)
      *)
      ELSIF tc = TYPECODE (REF VBT.KeyRec) THEN
        RETURN AnyEvent.FromKey (fv.keyRec^)
      ELSIF tc = TYPECODE (REF VBT.MouseRec) THEN
        RETURN AnyEvent.FromMouse (fv.mouseRec^)
      ELSIF tc = TYPECODE (REF VBT.PositionRec) THEN
        RETURN AnyEvent.FromPosition (fv.positionRec^)
      ELSIF tc = TYPECODE (REF VBT.MiscRec) THEN
        RETURN AnyEvent.FromMisc (fv.miscRec^)
      ELSE
        RAISE
          Error (&quot;Internal error: The active event has an unknown type&quot;)
      END
    END
  END GetTheEvent;

PROCEDURE <A NAME="GetTheEventTime"><procedure>GetTheEventTime</procedure></A> (fv: T): VBT.TimeStamp RAISES {Error} =
  VAR tc: CARDINAL;
  BEGIN
    LOCK fv.mu DO
      IF fv.eventCount = 0 THEN RETURN 0 END;
      tc := fv.eventCode;
      IF tc = TYPECODE (REF VBT.KeyRec) THEN
        RETURN fv.keyRec.time
      ELSIF tc = TYPECODE (REF VBT.MouseRec) THEN
        RETURN fv.mouseRec.time
      ELSIF tc = TYPECODE (REF VBT.PositionRec) THEN
        RETURN fv.positionRec.time
      ELSIF tc = TYPECODE (REF VBT.MiscRec) THEN
        RETURN fv.miscRec.time
      ELSE
        RAISE Error (&quot;Internal error: The active event has an unknown type&quot;)
      END
    END
  END GetTheEventTime;
</PRE>*********************** Text edit-widget callback ***********************

<P><PRE>REVEAL
  <A NAME="Port">Port</A> = PublicPort BRANDED OBJECT
    textedit: FVTextEdit;
    reportKeys: BOOLEAN;
  OVERRIDES
    init := PortInit;
    filter := PortFilter;
  END;

PROCEDURE <A NAME="PortInit"><procedure>PortInit</procedure></A> (v: Port;
    textedit: FVTextEdit;
    reportKeys: BOOLEAN;
    font: Font.T;
    colorScheme: PaintOp.ColorScheme;
    wrap, readOnly: BOOLEAN;
    turnMargin: REAL): Port =
  BEGIN
    v.textedit := textedit;
    v.reportKeys := reportKeys;
    RETURN TextPort.T.init(v, font := font, colorScheme := colorScheme,
                readOnly := readOnly, wrap := wrap,
                turnMargin := turnMargin)
  END PortInit;

PROCEDURE <A NAME="PortFilter"><procedure>PortFilter</procedure></A> (v: Port; cd: VBT.KeyRec) =
  BEGIN
    IF NOT v.reportKeys THEN
      TextPort.T.filter (v, cd)
    ELSE
      WITH len = TextPort.Length (v), text = TextPort.GetText(v) DO
        TextPort.T.filter (v, cd);
        IF len = TextPort.Length (v) THEN
           IF Text.Equal (text, TextPort.GetText (v)) THEN RETURN END
        END
      END;
      KeyProc (v.textedit, cd)
    END
  END PortFilter;
</PRE>*********************** Typein-widget callback ***********************

<P><PRE>REVEAL
  <A NAME="FVTypeIn">FVTypeIn</A> =
    TypeinVBT.T BRANDED OBJECT OVERRIDES returnAction := DeliverText END;

PROCEDURE <A NAME="DeliverText"><procedure>DeliverText</procedure></A> (typein: TypeinVBT.T; READONLY cd: VBT.KeyRec) =
  (* Callback for our TypeIns. *)
  BEGIN
    IF VBT.GetProp (typein, TYPECODE (ClosureRef)) = NIL THEN
      TypeinVBT.T.returnAction (typein, cd)
    ELSE
      KeyProc (typein, cd)
    END
  END DeliverText;
</PRE> ====================== Pixmap ===================== 

<P><PRE>REVEAL
  <A NAME="FVImage">FVImage</A> = PrivateImage BRANDED OBJECT
    OVERRIDES
      shape := ImageShape;
    END;

PROCEDURE <A NAME="ImageShape"><procedure>ImageShape</procedure></A>(v: PrivateImage; ax: Axis.T; n: CARDINAL): VBT.SizeRange =
    (* LL = VBT.mu.v *)
  VAR sr := ImageVBT.T.shape(v, ax, n);
  BEGIN
    sr.hi := 99999;
    RETURN sr
  END ImageShape;
</PRE> ====================== FileBrowser ===================== 

<P><PRE>REVEAL
  <A NAME="FVFileBrowser">FVFileBrowser</A> = FileBrowserVBT.T BRANDED OBJECT
                  OVERRIDES
                    activateFile := ActivateFileB
                  END;

PROCEDURE <A NAME="ActivateFileB"><procedure>ActivateFileB</procedure></A> (             self    : FVFileBrowser;
                         &lt;* UNUSED *&gt; filename: TEXT;
                                      event   : AnyEvent.T) =
  (* callback for our FileBrowserVBTs. *)
  VAR mr: VBT.MouseRec;
  BEGIN
    TYPECASE event OF
    | AnyEvent.Key (key) =&gt;
        mr.time := key.key.time;
        MouseProc (self, mr);
    | AnyEvent.Mouse (mouse) =&gt; MouseProc (self, mouse.mouse)
    ELSE
    END;
  END ActivateFileB;
</PRE> ====================== Browser ===================== 

<P><PRE>REVEAL
  <A NAME="UniSelector">UniSelector</A> = PrivateUniSelector BRANDED OBJECT
                OVERRIDES
                  insideClick := InsideClick
                END;

PROCEDURE <A NAME="InsideClick"><procedure>InsideClick</procedure></A> (         v   : UniSelector;
                       READONLY cd  : VBT.MouseRec;
                                this: ListVBT.Cell  ) =
  BEGIN
    ListVBT.UniSelector.insideClick (v, cd, this);
    IF cd.clickType = VBT.ClickType.LastUp
         AND (v.quick OR cd.clickCount = 3) THEN
      MouseProc (v.browser, cd)
    END
  END InsideClick;

REVEAL
  <A NAME="MultiSelector">MultiSelector</A> = PrivateMultiSelector BRANDED OBJECT
                  OVERRIDES
                    insideClick := MultiInsideClick
                  END;

PROCEDURE <A NAME="MultiInsideClick"><procedure>MultiInsideClick</procedure></A> (         v   : MultiSelector;
                            READONLY cd  : VBT.MouseRec;
                                     this: ListVBT.Cell   ) =
  BEGIN
    ListVBT.MultiSelector.insideClick (v, cd, this);
    IF cd.clickType = VBT.ClickType.LastUp
         AND (v.quick OR cd.clickCount = 3) THEN
      MouseProc (v.browser, cd)
    END
  END MultiInsideClick;
</PRE> ====================== Buttons ===================== 

<P><PRE>REVEAL
  <A NAME="FVBoolean">FVBoolean</A> = BooleanVBT.T BRANDED OBJECT OVERRIDES callback := MouseProc END;
  <A NAME="FVButton">FVButton</A> = SwitchVBT.T BRANDED OBJECT OVERRIDES callback := MouseProc END;
  <A NAME="FVGuard">FVGuard</A> =
    GuardedBtnVBT.T BRANDED OBJECT OVERRIDES callback := MouseProc END;
  <A NAME="FVMButton">FVMButton</A> =
    MenuSwitchVBT.T BRANDED OBJECT OVERRIDES callback := MouseProc END;
  <A NAME="FVScroller">FVScroller</A> =
    ScrollerVBT.T BRANDED OBJECT OVERRIDES callback := MouseProc END;
  <A NAME="FVSource">FVSource</A> = SourceVBT.T BRANDED OBJECT OVERRIDES callback := MouseProc END;
  <A NAME="FVTrillButton">FVTrillButton</A> =
    TrillSwitchVBT.T BRANDED OBJECT OVERRIDES callback := MouseProc END;
  <A NAME="FVZChassis">FVZChassis</A> =
    ZChassisVBT.T BRANDED OBJECT OVERRIDES callback := MouseProc END;
</PRE> ====================== Radio &amp; Choice ===================== 

<P><PRE>REVEAL
  <A NAME="FVChoice">FVChoice</A> =
    PrivateChoice BRANDED OBJECT OVERRIDES callback := ChoiceCallback END;

PROCEDURE <A NAME="ChoiceCallback"><procedure>ChoiceCallback</procedure></A> (self: FVChoice; READONLY cd: VBT.MouseRec) =
  BEGIN
    MouseProc (self, cd);
    MouseProc (self.radio, cd)
  END ChoiceCallback;
</PRE> ============================ FirstFocus =========================== 

<P> The following widgets play the first-focus game: Helper,
   Numeric (.typein), TextEdit (.tp), TypeIn, and TypeScript
   (.tp).  When a component of this type is encountered during
   the parsing of an s-expression, and if the FirstFocus property
   was set TRUE, SetFirstFocus is called to mark the VBT as
   having a TRUE FirstFocus property.  Later, when a TSplit or
   sub-window is made visible, FirstFocus is called to find a
   visible descendant that was marked as having a TRUE FirstFocus
   property. 

<P><PRE>TYPE FirstFocusProp = BRANDED REF INTEGER;

PROCEDURE <A NAME="SetFirstFocus"><procedure>SetFirstFocus</procedure></A> (widget: VBT.T) =
  VAR prop := NEW(FirstFocusProp);
  BEGIN
    VBT.PutProp(widget, prop)
  END SetFirstFocus;

PROCEDURE <A NAME="FirstFocus"><procedure>FirstFocus</procedure></A> (v: VBT.T; time: VBT.TimeStamp) =
  VAR
    widget: VBT.T;
    port  : TextPort.T;
  BEGIN
    widget := FindFocus(v);
    IF widget = NIL THEN RETURN END;
    TYPECASE widget OF
    | FVHelper (h) =&gt; port := h;
    | FVNumeric (n) =&gt; port := n.typein;
    | FVTextEdit (t) =&gt; port := t.tp;
    | FVTypeIn (t) =&gt; port := t;
    | FVTypescript (t) =&gt; port := t.tp;
    ELSE &lt;* ASSERT FALSE *&gt;
    END;
    IF NOT TextPort.TryFocus(port, time) THEN RETURN END;
    IF ISTYPE(port, TypeinVBT.T) THEN
      TextPort.Select(port, time, replaceMode := TRUE)
    END
  END FirstFocus;

PROCEDURE <A NAME="FindFocus"><procedure>FindFocus</procedure></A> (v: VBT.T): VBT.T =
  &lt;* FATAL MultiSplit.NotAChild *&gt;
  VAR ch, focus: VBT.T;
  BEGIN
    IF VBT.GetProp(v, TYPECODE(FirstFocusProp)) # NIL THEN
      RETURN v
    END;
    IF LeafVBT (v) THEN RETURN NIL END;
    IF ISTYPE(v, FVTSplit) THEN
      ch := TSplit.GetCurrent(v);
      IF ch # NIL THEN RETURN FindFocus(ch) END
    ELSE
      ch := MultiSplit.Succ(v, NIL);
      WHILE ch # NIL DO
        focus := FindFocus(ch);
        IF focus # NIL THEN RETURN focus END;
        ch := MultiSplit.Succ(v, ch);
      END
    END;
    RETURN NIL;
  END FindFocus;
</PRE> ====================== PopButton &amp; PopMButton ===================== 
 ========================== PopUp &amp; PopDown ======================== 

<P><PRE>REVEAL
  <A NAME="FVPopButton">FVPopButton</A> =
    SwitchVBT.T BRANDED OBJECT OVERRIDES callback := PopButtonProc END;
  <A NAME="FVPopMButton">FVPopMButton</A> =
    MenuSwitchVBT.T BRANDED OBJECT OVERRIDES callback := PopButtonProc END;

TYPE
  Callback = OBJECT METHODS apply (time: VBT.TimeStamp) END;
  PopTarget =
    Callback OBJECT target: ZChildVBT.T OVERRIDES apply := ApplyPopTarget END;

PROCEDURE <A NAME="SetPopTarget"><procedure>SetPopTarget</procedure></A> (source: ButtonVBT.T; target: ZChildVBT.T) =
  BEGIN
    VBT.PutProp (source, NEW (PopTarget, target := target))
  END SetPopTarget;

PROCEDURE <A NAME="PopButtonProc"><procedure>PopButtonProc</procedure></A> (self: VBT.T; READONLY cd: VBT.MouseRec) =
  (* Callback procedure for Pop[M]Button *)
  VAR popTarget: PopTarget := VBT.GetProp (self, TYPECODE (PopTarget));
  BEGIN
    IF popTarget # NIL THEN popTarget.apply (cd.time) END;
    MouseProc (self, cd)
  END PopButtonProc;

PROCEDURE <A NAME="ApplyPopTarget"><procedure>ApplyPopTarget</procedure></A> (p: PopTarget; time: VBT.TimeStamp) =
  BEGIN
    DoPopUp (p.target, forcePlace := FALSE, time := time);
  END ApplyPopTarget;

PROCEDURE <A NAME="PopUp"><procedure>PopUp</procedure></A> (fv        : T;
                 name      : TEXT;
                 forcePlace: BOOLEAN       := FALSE;
                 time      : VBT.TimeStamp := 0      ) RAISES {Error} =
  VAR vbt := GetVBT (fv, name);
  BEGIN
    IF time = 0 THEN time := GetTheEventTime (fv) END;
    DoPopUp (vbt, forcePlace, time);
  END PopUp;

PROCEDURE <A NAME="DoPopUp"><procedure>DoPopUp</procedure></A> (vbt: VBT.T; forcePlace: BOOLEAN; time: VBT.TimeStamp) =
  VAR zchild := ZSplitUtils.FindZChild (vbt);
  BEGIN
    IF zchild # NIL THEN
      ZChildVBT.Pop (zchild, forcePlace);
      FirstFocus (zchild, time)
    END
  END DoPopUp;

PROCEDURE <A NAME="PopDown"><procedure>PopDown</procedure></A> (fv: T; name: TEXT) RAISES {Error} =
  VAR zchild := ZSplitUtils.FindZChild (GetVBT (fv, name));
  BEGIN
    IF zchild # NIL THEN ZSplit.Unmap (zchild) END
  END PopDown;
</PRE> ===================== PageButton, PageMButton ============================ 

<P><PRE>TYPE
  PageTarget = Callback OBJECT
                 target   : FVTSplit;
                 backwards: BOOLEAN
               OVERRIDES
                 apply := ApplyPageTarget
               END;

REVEAL
  <A NAME="FVPageButton">FVPageButton</A> = PublicPageButton BRANDED OBJECT
                   backwards := FALSE
                 OVERRIDES
                   callback := PageButtonProc;
                   init     := InitPageButton
                 END;
  <A NAME="FVPageMButton">FVPageMButton</A> = PublicPageMButton BRANDED OBJECT
                    backwards := FALSE
                  OVERRIDES
                    callback := PageButtonProc;
                    init     := InitPageMButton
                  END;

PROCEDURE <A NAME="InitPageButton"><procedure>InitPageButton</procedure></A> (b        : FVPageButton;
                          ch       : VBT.T;
                          shadow   : Shadow.T;
                          backwards: BOOLEAN;
                          tsplit   : FVTSplit      ): FVPageButton =
  BEGIN
    EVAL SwitchVBT.T.init (b, NEW (ShadowedFeedbackVBT.T).init (ch, shadow));
    VBT.PutProp (
      b, NEW (PageTarget, backwards := backwards, target := tsplit));
    RETURN b
  END InitPageButton;

PROCEDURE <A NAME="InitPageMButton"><procedure>InitPageMButton</procedure></A> (b        : FVPageMButton;
                           ch       : VBT.T;
                           shadow   : Shadow.T;
                           backwards: BOOLEAN;
                           tsplit   : FVTSplit       ): FVPageMButton =
  BEGIN
    EVAL MenuSwitchVBT.T.init (b, ShadowedFeedbackVBT.NewMenu (ch, shadow));
    VBT.PutProp (
      b, NEW (PageTarget, backwards := backwards, target := tsplit));
    RETURN b
  END InitPageMButton;

PROCEDURE <A NAME="SetPageTarget"><procedure>SetPageTarget</procedure></A> (source: ButtonVBT.T; target: FVTSplit) =
  VAR p: PageTarget := VBT.GetProp (source, TYPECODE (PageTarget));
  BEGIN
    p.target := target
  END SetPageTarget;

PROCEDURE <A NAME="PageButtonProc"><procedure>PageButtonProc</procedure></A> (self: VBT.T; READONLY cd: VBT.MouseRec) =
  VAR p: PageTarget := VBT.GetProp (self, TYPECODE (PageTarget));
  BEGIN
    IF p # NIL THEN p.apply (cd.time) END;
    MouseProc (self, cd)
  END PageButtonProc;

PROCEDURE <A NAME="ApplyPageTarget"><procedure>ApplyPageTarget</procedure></A> (p: PageTarget; time: VBT.TimeStamp) =
  VAR
    tsplit         := p.target;
    current        := TSplit.GetCurrent (tsplit);
    next   : VBT.T;
  &lt;* FATAL Split.NotAChild *&gt;
  BEGIN
    IF p.backwards THEN
      next := Split.Pred (tsplit, current);
      IF next = NIL AND tsplit.circular THEN
        next := Split.Pred (tsplit, NIL)
      END
    ELSE
      next := Split.Succ (tsplit, current);
      IF next = NIL AND tsplit.circular THEN
        next := Split.Succ (tsplit, NIL)
      END
    END;
    IF next # NIL THEN
      TSplit.SetCurrent (tsplit, next);
      FirstFocus (next, time)
    END;
  END ApplyPageTarget;
</PRE> ===================== LinkButton, LinkMButton ============================ 

<P><PRE>TYPE
  LinkTarget = Callback OBJECT
                 Tparent: FVTSplit;
                 Tchild : VBT.T
               OVERRIDES
                 apply := ApplyLinkTarget
               END;
REVEAL
  <A NAME="FVLinkButton">FVLinkButton</A> = SwitchVBT.T BRANDED OBJECT
                 OVERRIDES
                   callback := LinkButtonProc
                 END;
  <A NAME="FVLinkMButton">FVLinkMButton</A> = MenuSwitchVBT.T BRANDED OBJECT
                  OVERRIDES
                    callback := LinkButtonProc
                  END;

PROCEDURE <A NAME="SetLinkTarget"><procedure>SetLinkTarget</procedure></A> (source: ButtonVBT.T; target: VBT.T) =
  BEGIN
    VBT.PutProp (source, NEW (LinkTarget, Tchild := target,
                              Tparent := VBT.Parent (target)))
  END SetLinkTarget;

PROCEDURE <A NAME="LinkButtonProc"><procedure>LinkButtonProc</procedure></A> (self: VBT.T; READONLY cd: VBT.MouseRec) =
  VAR lt: LinkTarget := VBT.GetProp (self, TYPECODE (LinkTarget));
  BEGIN
    IF lt # NIL THEN lt.apply (cd.time) END;
    MouseProc (self, cd)
  END LinkButtonProc;

PROCEDURE <A NAME="ApplyLinkTarget"><procedure>ApplyLinkTarget</procedure></A> (lt: LinkTarget; time: VBT.TimeStamp) =
  BEGIN
    TRY
      TSplit.SetCurrent (lt.Tparent, lt.Tchild);
      FirstFocus (lt.Tchild, time)
    EXCEPT
    | Split.NotAChild =&gt;         (* ignore *)
    END
  END ApplyLinkTarget;
</PRE> =========================== CloseButton ============================ 

<P><PRE>REVEAL
  <A NAME="FVCloseButton">FVCloseButton</A> = PrivateCloseButton BRANDED OBJECT
                  OVERRIDES
                    callback := CloseButtonProc;
                    init     := InitCloseButton
                  END;

PROCEDURE <A NAME="InitCloseButton"><procedure>InitCloseButton</procedure></A> (b: FVCloseButton; ch: VBT.T; shadow: Shadow.T):
  FVCloseButton =
  BEGIN
    EVAL
      SwitchVBT.T.init (b, NEW (ShadowedFeedbackVBT.T).init (ch, shadow));
    RETURN b
  END InitCloseButton;

PROCEDURE <A NAME="CloseButtonProc"><procedure>CloseButtonProc</procedure></A> (         self: FVCloseButton;
                           READONLY cd  : VBT.MouseRec   ) =
  VAR zch := ZSplitUtils.FindZChild (self.target);
  BEGIN
    IF zch # NIL THEN
      ZSplit.Unmap (zch);
      MouseProc (self, cd);
      MouseProc (zch, cd)
    END
  END CloseButtonProc;
</PRE> ============================= HBox, VBox ============================== 

<P><PRE>REVEAL
  <A NAME="FVHBox">FVHBox</A> = HVSplit.T BRANDED OBJECT OVERRIDES shape := HVSplitShape END;
  <A NAME="FVVBox">FVVBox</A> = HVSplit.T BRANDED OBJECT OVERRIDES shape := HVSplitShape END;

CONST EmptyShape = VBT.SizeRange {lo := 0, pref := 0, hi := 1};

PROCEDURE <A NAME="HVSplitShape"><procedure>HVSplitShape</procedure></A> (v: HVSplit.T; ax: Axis.T; n: CARDINAL):
  VBT.SizeRange =
  BEGIN
    IF v.succ (NIL) = NIL THEN
      RETURN EmptyShape
    ELSE
      RETURN HVSplit.T.shape (v, ax, n)
    END
  END HVSplitShape;
</PRE> ============================= HTile, VTile ============================== 

<P><PRE>REVEAL
  <A NAME="FVHTile">FVHTile</A> = SplitterVBT.T BRANDED OBJECT OVERRIDES shape := HVTileShape END;
  <A NAME="FVVTile">FVVTile</A> = SplitterVBT.T BRANDED OBJECT OVERRIDES shape := HVTileShape END;

PROCEDURE <A NAME="HVTileShape"><procedure>HVTileShape</procedure></A> (v: SplitterVBT.T; ax: Axis.T; n: CARDINAL):
  VBT.SizeRange =
  BEGIN
    IF v.succ (NIL) = NIL THEN
      RETURN EmptyShape
    ELSE
      RETURN SplitterVBT.T.shape (v, ax, n)
    END
  END HVTileShape;
</PRE> ============================= Numeric ============================== 

<P><PRE>REVEAL
  <A NAME="FVNumeric">FVNumeric</A> =
    NumericVBT.T BRANDED OBJECT OVERRIDES callback := NumericProc END;

PROCEDURE <A NAME="NumericProc"><procedure>NumericProc</procedure></A> (self: FVNumeric; event: AnyEvent.T) =
  BEGIN
    TYPECASE event OF
    | AnyEvent.Mouse (mouse) =&gt; MouseProc (self, mouse.mouse)
    | AnyEvent.Key (key) =&gt;
          IF VBT.GetProp (self, TYPECODE (ClosureRef)) = NIL THEN
            NumericVBT.T.callback (self, event)
          ELSE
            KeyProc (self, key.key)
          END
    ELSE &lt;* ASSERT FALSE *&gt;
    END
  END NumericProc;
</PRE> ============================= Menu ============================== 

<P><PRE>REVEAL <A NAME="FVMenu">FVMenu</A> = AnchorSplit.T BRANDED OBJECT OVERRIDES pre := PreMenu END;

PROCEDURE <A NAME="PreMenu"><procedure>PreMenu</procedure></A> (v: AnchorSplit.T) =
  VAR mouse: VBT.MouseRec;
  BEGIN
    mouse.time := 0;
    MouseProc (v, mouse);
    AnchorSplit.T.pre (v);
  END PreMenu;
</PRE> ============================= IntApply ============================ 

<P><PRE>REVEAL
  <A NAME="FVIntApply">FVIntApply</A> =
    IntApplyPublic BRANDED OBJECT
      name    : TEXT;            (* name of destination VBT *)
      property: TEXT   := NIL;   (* name of property to set, if any *)
    OVERRIDES
      init    := IntApplyInit;
      discard := IntApplyDiscard;
      misc    := IntApplyMisc;
    END;

PROCEDURE <A NAME="IntApplyInit"><procedure>IntApplyInit</procedure></A> (v       : FVIntApply;
                        fv      : VBT.T;
                        ch      : VBT.T;
                        name    : TEXT;
                        property: TEXT       := NIL): FVIntApply
  RAISES {Error} =
  BEGIN
    v.name := name;
    v.property := property;
    TYPECASE fv OF
    | T =&gt;
        TYPECASE ch OF
        | FVNumeric, FVScroller =&gt;
            IF VBT.GetProp(ch, TYPECODE(ClosureRef)) # NIL THEN
              RAISE
                Error(&quot;IntApply: child already has event handler attached&quot;);
            END;
            VBT.PutProp(ch, NEW(ClosureRef, fv := fv,
                                cl := NEW(IAClosure, ia := v)));
        ELSE
          RAISE Error(&quot;IntApply: child not a Numeric or Scroller&quot;);
        END;
    ELSE
      RAISE Error(&quot;IntApply: not attached to a FormsVBT&quot;);
    END;
    RETURN Filter.T.init(v, ch);
  END IntApplyInit;

PROCEDURE <A NAME="IntApplyMisc"><procedure>IntApplyMisc</procedure></A> (v: FVIntApply; READONLY cd: VBT.MiscRec) =
  VAR ch := Filter.Child(v);
  BEGIN
    IF cd.type = VBT.Deleted OR cd.type = VBT.Disconnected AND ch # NIL THEN
      (* remove the callback if its ours *)
      WITH cr = VBT.GetProp(ch, TYPECODE(ClosureRef)) DO
        IF cr # NIL AND ISTYPE(NARROW(cr, ClosureRef).cl, IAClosure) THEN
          VBT.RemProp(ch, TYPECODE(ClosureRef))
        END;
      END;
    END;
    Filter.T.misc(v, cd);
  END IntApplyMisc;

PROCEDURE <A NAME="IntApplyDiscard"><procedure>IntApplyDiscard</procedure></A> (v: FVIntApply) =
  VAR ch := Filter.Child(v);
  BEGIN
    IF ch # NIL THEN
      WITH cr = VBT.GetProp(ch, TYPECODE(ClosureRef)) DO
        IF cr # NIL AND ISTYPE(NARROW(cr, ClosureRef).cl, IAClosure) THEN
          VBT.RemProp(ch, TYPECODE(ClosureRef))
        END;
      END;
    END;
    Filter.T.discard(v);
  END IntApplyDiscard;

TYPE
  IAClosure =
    Closure OBJECT ia: FVIntApply;  OVERRIDES apply := IAApply; END;

PROCEDURE <A NAME="IAApply"><procedure>IAApply</procedure></A> (             cl  : IAClosure;
                                fv  : T;
                   &lt;* UNUSED *&gt; name: TEXT;
                   &lt;* UNUSED*&gt;  time: VBT.TimeStamp) =
  VAR int: INTEGER;
  BEGIN
    TRY
      TYPECASE Filter.Child(cl.ia) OF
      | FVScroller (t) =&gt; int := ScrollerVBT.Get(t)
      | FVNumeric (t) =&gt; int := NumericVBT.Get(t)
      ELSE
        RAISE Unimplemented;
      END;

      IF cl.ia.property = NIL THEN
        PutInteger(fv, cl.ia.name, int);
      ELSE
        PutIntegerProperty(fv, cl.ia.name, cl.ia.property, int);
      END;
    EXCEPT
    | Error, Unimplemented =&gt;
      &lt;* ASSERT FALSE *&gt;
    END;
  END IAApply;
</PRE> ====================== Runtime support routines ==================== 

<P><PRE>PROCEDURE <A NAME="GetText"><procedure>GetText</procedure></A> (fv: T; name: TEXT): TEXT RAISES {Error, Unimplemented} =
  BEGIN
    TYPECASE GetVBT (fv, name) OF
    | FVBrowser (v) =&gt;
        VAR this: ListVBT.Cell;
        BEGIN
          IF v.getFirstSelected (this) THEN RETURN v.getValue (this) END;
          RETURN &quot;&quot;
        END
    | FVFileBrowser (v) =&gt;
        TRY
          RETURN FileBrowserVBT.GetFile (v)
        EXCEPT
        | FileBrowserVBT.Error (e) =&gt;
            RAISE Error (Fmt.F (&quot;Error for %s: %s&quot;, e.path, e.text))
        END
    | FVText (t) =&gt; RETURN TextVBT.Get (t)
    | FVTypescript (v) =&gt;
        TRY
          RETURN Rd.GetText (TypescriptVBT.GetRd (v), LAST (CARDINAL))
        EXCEPT
        | Rd.Failure (ref) =&gt; RAISE Error (RdUtils.FailureText (ref))
        | Thread.Alerted =&gt; RAISE Error (&quot;Thread.Alerted&quot;)
        END
    | TextEditVBT.T (v) =&gt; RETURN TextPort.GetText (v.tp)
    | TextPort.T (v) =&gt; RETURN TextPort.GetText (v)
    | FVNumeric (v) =&gt;
        IF NumericVBT.IsEmpty (v) THEN
          RETURN &quot;&quot;
        ELSE
          RETURN Fmt.Int (NumericVBT.Get (v))
        END
    ELSE
      RAISE Unimplemented
    END
  END GetText;

PROCEDURE <A NAME="PutText"><procedure>PutText</procedure></A> (fv: T; name: TEXT; text: TEXT; append := FALSE)
  RAISES {Error, Unimplemented} =
  BEGIN
    TYPECASE GetVBT (fv, name) OF
    | FVBrowser (v) =&gt;
        VAR this: ListVBT.Cell;
        BEGIN
          IF v.getFirstSelected (this) THEN v.setValue (this, text) END
        END
    | FVFileBrowser (v) =&gt;
        TRY
          FileBrowserVBT.Set (v, text)
        EXCEPT
          FileBrowserVBT.Error (e) =&gt;
            RAISE Error (Fmt.F (&quot;Error for %s: %s&quot;, e.path, e.text))
        END
    | FVPixmap (t) =&gt; PixmapVBT.Put (t, GetPixmap (text, fv.path))
    | FVImage (t) =&gt;
        VAR pm: ImageRd.T; len: INTEGER; BEGIN
        TRY Rd.Close (t.rd); t.rd := NIL EXCEPT
        | Rd.Failure (ref) =&gt; RAISE Error (RdUtils.FailureText (ref))
        | Thread.Alerted =&gt; (* ignore *)
        END;
        TRY t.rd := Rsrc.Open (text, fv.path) EXCEPT
        | Rsrc.NotFound =&gt; RAISE Error(&quot;No such resource: &quot; &amp; text)
        END;
        TRY len := Rd.Length(t.rd) EXCEPT
        | Rd.Failure (ref) =&gt; RAISE Error(RdUtils.FailureText(ref))
        | Thread.Alerted =&gt; (* ignore *)
        END;
        pm := t.get();
        EVAL pm.init (t.rd, 0, len, t.op, NIL, t.gamma);
        t.put (pm, t.bg);
        END;
    | FVText (t) =&gt;
        IF append THEN
          TextVBT.Put (t, TextVBT.Get (t) &amp; text)
        ELSE
          TextVBT.Put (t, text)
        END
    | FVTypescript (v) =&gt;
        TRY
          Wr.PutText (TypescriptVBT.GetWr (v), text)
        EXCEPT
        | Wr.Failure (ref) =&gt; RAISE Error (RdUtils.FailureText (ref))
        | Thread.Alerted =&gt;      (* ignore *)
        END
    | TextEditVBT.T (v) =&gt;
        IF append THEN
          TextPort.PutText (v.tp, text)
        ELSE
          TextPort.SetText (v.tp, text)
        END
    | TextPort.T (v) =&gt;
        IF append THEN
          TextPort.PutText (v, text)
        ELSE
          TextPort.SetText (v, text)
        END
    ELSE
      RAISE Unimplemented
    END
  END PutText;

PROCEDURE <A NAME="GetInteger"><procedure>GetInteger</procedure></A> (fv: T; name: TEXT): INTEGER
  RAISES {Error, Unimplemented} =
  &lt;* FATAL Split.NotAChild *&gt;
  BEGIN
    TYPECASE GetVBT (fv, name) OF
    | FVScroller (t) =&gt; RETURN ScrollerVBT.Get (t)
    | FVNumeric (t) =&gt; RETURN NumericVBT.Get (t)
    | FVTSplit (t) =&gt; RETURN Split.Index (t, TSplit.GetCurrent (t))
    | FVBrowser (t) =&gt;
        VAR this: ListVBT.Cell;
        BEGIN
          IF t.getFirstSelected (this) THEN RETURN this END;
          RAISE Error (&quot;Nothing has been selected.&quot;)
        END
    ELSE
      RAISE Unimplemented
    END
  END GetInteger;

PROCEDURE <A NAME="PutInteger"><procedure>PutInteger</procedure></A> (fv: T; name: TEXT; int: INTEGER)
  RAISES {Error, Unimplemented} =
  VAR vbt: VBT.T;
  &lt;* FATAL Split.NotAChild *&gt;
  BEGIN
    TYPECASE GetVBT (fv, name) OF
    | FVScroller (t) =&gt; ScrollerVBT.Put (t, int)
    | FVNumeric (t) =&gt; NumericVBT.Put (t, int)
    | FVTSplit (t) =&gt;
        IF 0 &lt;= int AND int &lt; Split.NumChildren (t) THEN
          vbt := Split.Nth (t, int);
          TSplit.SetCurrent (t, vbt);
          FirstFocus (vbt, GetTheEventTime (fv))
        ELSE
          RAISE Error (Fmt.F (&quot;%s is an illegal TSplit-index for %s.&quot;,
                              Fmt.Int (int), name))
        END
    | FVBrowser (t) =&gt;
        IF 0 &lt;= int AND int &lt; t.count () THEN
          t.selectOnly (int)
        ELSE
          RAISE Error (Fmt.F (&quot;%s is an illegal selection for %s.&quot;,
                              Fmt.Int (int), name))
        END
    ELSE
      RAISE Unimplemented
    END
  END PutInteger;

PROCEDURE <A NAME="GetIntegerProperty"><procedure>GetIntegerProperty</procedure></A> (fv: T; name, propertyName: TEXT): INTEGER
  RAISES {Error, Unimplemented} =
  VAR
    fvbt := GetVBT (fv, name);
  BEGIN
    IF Text.Equal(propertyName, &quot;NorthEdge&quot;) THEN
      RETURN ROUND(FLOAT(VBT.Domain(fvbt).north)/ Pts.ToPixels(fvbt, 1.0, Axis.T.Ver));
    ELSIF Text.Equal(propertyName, &quot;SouthEdge&quot;) THEN
      RETURN ROUND(FLOAT(VBT.Domain(fvbt).south)/ Pts.ToPixels(fvbt, 1.0, Axis.T.Ver));
   ELSIF Text.Equal(propertyName, &quot;EastEdge&quot;) THEN
     RETURN ROUND(FLOAT(VBT.Domain(fvbt).east)/ Pts.ToPixels(fvbt, 1.0, Axis.T.Hor));
   ELSIF Text.Equal(propertyName, &quot;WestEdge&quot;) THEN
     RETURN ROUND(FLOAT(VBT.Domain(fvbt).west)/ Pts.ToPixels(fvbt, 1.0, Axis.T.Hor));
   ELSE
    TYPECASE fvbt  OF
    | TextEditVBT.T (v) =&gt;
      IF Text.Equal(propertyName, &quot;Position&quot;) THEN
        RETURN TextPort.Index(v.tp)
      ELSIF Text.Equal(propertyName, &quot;Length&quot;) THEN
        RETURN TextPort.Length(v.tp)
      END
    | FVNumeric (v) =&gt;
        IF Text.Equal (propertyName, &quot;Min&quot;) THEN
          RETURN NumericVBT.GetMin (v)
        ELSIF Text.Equal (propertyName, &quot;Max&quot;) THEN
          RETURN NumericVBT.GetMax (v)
        END
    | FVScroller (v) =&gt;
        IF Text.Equal (propertyName, &quot;Min&quot;) THEN
          RETURN ScrollerVBT.GetMin (v)
        ELSIF Text.Equal (propertyName, &quot;Max&quot;) THEN
          RETURN ScrollerVBT.GetMax (v)
        ELSIF Text.Equal (propertyName, &quot;Step&quot;) THEN
          RETURN ScrollerVBT.GetStep (v)
        ELSIF Text.Equal (propertyName, &quot;Thumb&quot;) THEN
          RETURN ScrollerVBT.GetThumb (v)
        END
    ELSE
    END;
    RAISE Unimplemented
  END;
  END GetIntegerProperty;

PROCEDURE <A NAME="PutIntegerProperty"><procedure>PutIntegerProperty</procedure></A> (fv     : T;
                              name, p: TEXT;
                              value  : INTEGER)
  RAISES {Error, Unimplemented} =
  BEGIN
    TYPECASE GetVBT(fv, name) OF
    | TextEditVBT.T (v) =&gt;
        IF Text.Equal(p, &quot;Position&quot;) THEN
          TextPort.Seek(v.tp, Cardinal(value, p));
          RETURN
        ELSIF Text.Equal(p, &quot;Normalize&quot;) THEN
          TextPort.Normalize(v.tp, Cardinal(value, p));
          RETURN
        END
    | FVNumeric (v) =&gt;
        IF Text.Equal(p, &quot;Min&quot;) THEN
          NumericVBT.PutBounds(v, value, NumericVBT.GetMax(v));
          RETURN
        ELSIF Text.Equal(p, &quot;Max&quot;) THEN
          NumericVBT.PutBounds(v, NumericVBT.GetMin(v), value);
          RETURN
        END
    | FVScroller (v) =&gt;
        IF Text.Equal(p, &quot;Step&quot;) THEN
          ScrollerVBT.PutStep(v, Cardinal(value, p));
          RETURN
        ELSE
          VAR
            min   := ScrollerVBT.GetMin(v);
            max   := ScrollerVBT.GetMax(v);
            thumb := ScrollerVBT.GetThumb(v);
          BEGIN
            IF Text.Equal(p, &quot;Min&quot;) THEN
              min := value
            ELSIF Text.Equal(p, &quot;Max&quot;) THEN
              max := value
            ELSIF Text.Equal(p, &quot;Thumb&quot;) THEN
              thumb := Cardinal(value, p)
            END;
            ScrollerVBT.PutBounds(v, min, max, thumb);
            RETURN
          END
        END
    | FVVideo (v) =&gt;
        EVAL Cardinal(value, p);
        IF Text.Equal(p, &quot;Quality&quot;) THEN
          IF value &lt; FIRST(JVSink.Quality)
               OR LAST(JVSink.Quality) &lt; value THEN
            RAISE
              Error(&quot;Video: quality must be between 0 and 15&quot;);
          END;
          v.setQuality(value);
        ELSIF Text.Equal(p, &quot;Width&quot;) THEN
          SetVideoSize(v, value, Axis.T.Hor);
        ELSIF Text.Equal(p, &quot;Height&quot;) THEN
          SetVideoSize(v, value, Axis.T.Ver);
        ELSIF Text.Equal(p, &quot;MSecs&quot;) THEN
          v.setMinFrameMSecs(value);
        END;
        RETURN
    | FVAudio (t) =&gt;
        IF Text.Equal(p, &quot;Volume&quot;) THEN
          IF value &lt; FIRST(Jva.Volume)
               OR LAST(Jva.Volume) &lt; value THEN
            RAISE
              Error(
                Fmt.F(&quot;Audio: volume must be in range [%s..%s]&quot;,
                      Fmt.Int(FIRST(Jva.Volume)),
                      Fmt.Int(LAST(Jva.Volume))));
          END;
          TRY
            AudioVBT.SetVolume(t, value);
          EXCEPT
          | Thread.Alerted =&gt;
            RAISE Error(&quot;PutInteger: Audio, Thread Alerted&quot;);
          END (* TRY *);
          RETURN
          END (* IF *)
    ELSE
    END;
    RAISE Unimplemented
  END PutIntegerProperty;

PROCEDURE <A NAME="GetRealProperty"><procedure>GetRealProperty</procedure></A> (fv: T; name, propertyName: TEXT): REAL
  RAISES {Error, Unimplemented} =
  VAR hscale, vscale: REAL;
  BEGIN
    TYPECASE GetVBT(fv, name) OF
    | ScaleFilter.T (v) =&gt;
        ScaleFilter.Get(v, hscale, vscale);
        IF Text.Equal(propertyName, &quot;HScale&quot;) THEN
          RETURN hscale
        ELSIF Text.Equal(propertyName, &quot;VScale&quot;) THEN
          RETURN vscale
        END
    ELSE
    END;
    RAISE Unimplemented
  END GetRealProperty;

PROCEDURE <A NAME="PutRealProperty"><procedure>PutRealProperty</procedure></A> (fv: T; name, p: TEXT; value: REAL)
  RAISES {Error, Unimplemented} =
  VAR hscale, vscale: REAL;
  BEGIN
    TYPECASE GetVBT(fv, name) OF
    | ScaleFilter.T (v) =&gt;
        ScaleFilter.Get(v, hscale, vscale);
        IF Text.Equal(p, &quot;HScale&quot;) THEN
          ScaleFilter.Scale(v, value, vscale);
          RETURN
        ELSIF Text.Equal(p, &quot;VScale&quot;) THEN
          ScaleFilter.Scale(v, hscale, value);
          RETURN
        END
    ELSE
    END;
    RAISE Unimplemented
  END PutRealProperty;

PROCEDURE <A NAME="GetBooleanProperty"><procedure>GetBooleanProperty</procedure></A> (fv: T; name, propertyName: TEXT):
  BOOLEAN RAISES {Error, Unimplemented} =
  BEGIN
    TYPECASE GetVBT(fv, name) OF
    | TextEditVBT.T (v) =&gt;
        IF Text.Equal(propertyName, &quot;ReadOnly&quot;) THEN
          RETURN v.tp.getReadOnly()
        ELSE
        END;
    | ShadowedVBT.T (v) =&gt;
        IF Text.Equal(propertyName, &quot;Raised&quot;) THEN
          RETURN ShadowedVBT.GetStyle (v) = Shadow.Style.Raised
        ELSIF Text.Equal(propertyName, &quot;Flat&quot;) THEN
          RETURN ShadowedVBT.GetStyle (v) = Shadow.Style.Flat
        ELSIF Text.Equal(propertyName, &quot;Lowered&quot;) THEN
          RETURN ShadowedVBT.GetStyle (v) = Shadow.Style.Lowered
        ELSIF Text.Equal(propertyName, &quot;Ridged&quot;) THEN
          RETURN ShadowedVBT.GetStyle (v) = Shadow.Style.Ridged
        ELSIF Text.Equal(propertyName, &quot;Chiseled&quot;) THEN
          RETURN ShadowedVBT.GetStyle (v) = Shadow.Style.Chiseled
        END
    ELSE
    END;
    RAISE Unimplemented
  END GetBooleanProperty;

PROCEDURE <A NAME="PutBooleanProperty"><procedure>PutBooleanProperty</procedure></A> (fv     : T;
                              name, p: TEXT;
                              value  : BOOLEAN)
  RAISES {Error, Unimplemented} =
  BEGIN
    TYPECASE GetVBT(fv, name) OF
    | TextEditVBT.T (v) =&gt;
        IF Text.Equal(p, &quot;ReadOnly&quot;) THEN
          v.tp.setReadOnly(value);
          RETURN
        END
    | ShadowedVBT.T (v) =&gt;
        IF Text.Equal(p, &quot;Raised&quot;) THEN
          ShadowedVBT.SetStyle (v, Shadow.Style.Raised);
          RETURN
        ELSIF Text.Equal(p, &quot;Flat&quot;) THEN
          ShadowedVBT.SetStyle (v, Shadow.Style.Flat);
          RETURN
        ELSIF Text.Equal(p, &quot;Lowered&quot;) THEN
          ShadowedVBT.SetStyle (v, Shadow.Style.Lowered);
          RETURN
        ELSIF Text.Equal(p, &quot;Ridged&quot;) THEN
          ShadowedVBT.SetStyle (v, Shadow.Style.Ridged);
          RETURN
        ELSIF Text.Equal(p, &quot;Chiseled&quot;) THEN
          ShadowedVBT.SetStyle (v, Shadow.Style.Chiseled);
          RETURN
        END
    | FVVideo (v) =&gt;
        IF Text.Equal(p, &quot;Synchronous&quot;) THEN
          v.setSynchronous(value);
          RETURN
        ELSIF Text.Equal(p, &quot;Paused&quot;) THEN
          v.setPaused(value);
          RETURN
        ELSIF Text.Equal(p, &quot;FixedSize&quot;) THEN
          v.setFixedSize(value);
          VBT.NewShape(v);
          RETURN
        ELSE
          RAISE Error(&quot;Video: unknown Boolean property &quot; &amp; p);
        END;
    | FVAudio (a) =&gt;
        TRY
          IF Text.Equal(p, &quot;Mute&quot;) THEN
            AudioVBT.SetMute(a, value);
            RETURN
          ELSIF Text.Equal(p, &quot;IgnoreMapping&quot;) THEN
            AudioVBT.SetIgnoreMapping(a, value);
            RETURN
          ELSE
            RAISE Error(&quot;Audio: unknown Boolean property &quot; &amp; p);
          END;
        EXCEPT
        | Thread.Alerted =&gt;
            RAISE Error(&quot;Audio: Put Boolean, Thread Alerted&quot;);
        END;
    ELSE
    END;
    RAISE Unimplemented
  END PutBooleanProperty;

PROCEDURE <A NAME="Cardinal"><procedure>Cardinal</procedure></A> (n: INTEGER; name: TEXT): CARDINAL RAISES {Error} =
  BEGIN
    IF n &lt; 0 THEN
      RAISE Error (Fmt.F (&quot;Value for %s, %s, should be a CARDINAL.&quot;, name,
                          Fmt.Int (n)))
    ELSE
      RETURN n
    END
  END Cardinal;

PROCEDURE <A NAME="SetVideoSize"><procedure>SetVideoSize</procedure></A> (v: FVVideo; value: CARDINAL; ax: Axis.T) =
  VAR width, height: CARDINAL;
  BEGIN
    v.getSize(width, height);
    CASE ax OF
    | Axis.T.Hor =&gt; width := value;
    | Axis.T.Ver =&gt; height := value;
    END;
    v.setSize(width, height);
    VBT.NewShape(v);
  END SetVideoSize;

PROCEDURE <A NAME="PutBoolean"><procedure>PutBoolean</procedure></A> (fv: T; name: TEXT; val: BOOLEAN)
  RAISES {Error, Unimplemented} =
  BEGIN
    TYPECASE GetVBT (fv, name) OF
    | FVBoolean (b) =&gt; BooleanVBT.Put (b, val)
    | FVChoice (c) =&gt;
        IF val THEN
          ChoiceVBT.Put (c)
        ELSIF ChoiceVBT.Get (c) = c THEN
          ChoiceVBT.Clear (c)
        END
    ELSE
      RAISE Unimplemented
    END
  END PutBoolean;

PROCEDURE <A NAME="PutChoice"><procedure>PutChoice</procedure></A> (fv: T; radioName, choiceName: TEXT)
  RAISES {Error, Unimplemented} =
  BEGIN
    TYPECASE GetVBT (fv, radioName) OF
    | FVRadio (r) =&gt;
        IF choiceName = NIL THEN
          WITH cur = ChoiceVBT.Selection (r.radio) DO
            IF cur # NIL THEN ChoiceVBT.Clear (cur) END
          END
        ELSE
          TYPECASE GetVBT (fv, choiceName) OF
          | FVChoice (c) =&gt; ChoiceVBT.Put (c)
          ELSE
            RAISE Error (&quot;No Choice named &quot; &amp; choiceName)
          END
        END
    ELSE
      RAISE Unimplemented
    END
  END PutChoice;
</PRE>***********************  Direct access  ************************

<P><PRE>PROCEDURE <A NAME="SetVBT"><procedure>SetVBT</procedure></A> (fv: T; name: TEXT; vbt: VBT.T) RAISES {Error} =
  BEGIN
    LOCK fv.mu DO
      IF fv.getVBT.put (name, vbt) THEN
        RAISE Error (&quot;There is already a VBT named &quot; &amp; name)
      END
    END
  END SetVBT;

PROCEDURE <A NAME="GetVBT"><procedure>GetVBT</procedure></A> (fv: T; name: TEXT): VBT.T RAISES {Error} =
  VAR result: REFANY;
  BEGIN
    LOCK fv.mu DO
      IF fv.getVBT.get (name, result) THEN RETURN result END;
      RAISE Error (&quot;There is no VBT named &quot; &amp; name)
    END
  END GetVBT;

PROCEDURE <A NAME="GetName"><procedure>GetName</procedure></A> (vbt: VBT.T): TEXT RAISES {Error} =
  VAR stateRef: REF State := VBT.GetProp(vbt, TYPECODE(REF State));
  BEGIN
    IF stateRef # NIL AND stateRef.name # NIL THEN
      RETURN stateRef.name
    ELSE
      RAISE Error(&quot;VBT is not named&quot;)
    END
  END GetName;

PROCEDURE <A NAME="RemoveName"><procedure>RemoveName</procedure></A> (fv: T; vbt: VBT.T) RAISES {Error} =
  &lt;* FATAL MultiSplit.NotAChild *&gt;
  VAR stateRef: REF State; result: REFANY;
  BEGIN
    stateRef := VBT.GetProp(vbt, TYPECODE(REF State));
    LOCK fv.mu DO
      IF stateRef # NIL AND stateRef.name # NIL THEN
        IF NOT fv.getVBT.delete(stateRef.name, result) THEN
          &lt;* ASSERT FALSE *&gt;
        END
      END
    END;
    (* now recursively remove the names of all descendants as well *)
    IF NOT LeafVBT(vbt) THEN
      VAR ch := MultiSplit.Succ (vbt, NIL); BEGIN
        WHILE ch # NIL DO
          RemoveName (fv, ch);
          ch := MultiSplit.Succ (vbt, ch)
        END
      END
    END
  END RemoveName;

PROCEDURE <A NAME="Delete"><procedure>Delete</procedure></A> (fv: T; parent: TEXT; at: CARDINAL; count: CARDINAL := 1)
  RAISES {Error} =
  BEGIN
    TRY
      WITH p  = GetVBT (fv, parent),
           at = MIN (at, MultiSplit.NumChildren (p)) DO
        FOR i := 1 TO MIN (count, MultiSplit.NumChildren (p) - at) DO
          WITH ch = MultiSplit.Nth(p, at) DO
            RemoveName (fv, ch);
            MultiSplit.Delete (p, ch)
          END
        END
      END
    EXCEPT
    | MultiSplit.NotAChild =&gt; RAISE Error (&quot;Delete: No Split named &quot; &amp; parent)
    END
  END Delete;

PROCEDURE <A NAME="InsertVBT"><procedure>InsertVBT</procedure></A> (fvLocal: T;
                     parent : TEXT;
                     child  : VBT.T;
                     at     : CARDINAL := LAST (CARDINAL)) RAISES {Error} =
  BEGIN
    TRY
      WITH p  = GetVBT (fvLocal, parent),
           at = MIN (at, MultiSplit.NumChildren (p)) DO
        IF at = 0 THEN
          MultiSplit.Insert (p, NIL, child)
        ELSE
          MultiSplit.Insert (p, MultiSplit.Nth (p, at - 1), child)
        END
      END
    EXCEPT
    | MultiSplit.NotAChild =&gt;
        RAISE Error (&quot;InsertVBT: No Split named &quot; &amp; parent)
    END
  END InsertVBT;

PROCEDURE <A NAME="LeafVBT"><procedure>LeafVBT</procedure></A> (v: VBT.T): BOOLEAN =
  BEGIN
    RETURN NOT ISTYPE(v, VBT.Split) AND MultiClass.Resolve(v) = NIL
  END LeafVBT;
</PRE>**********************  Special controls  **********************

<P><PRE>PROCEDURE <A NAME="TakeFocus"><procedure>TakeFocus</procedure></A> (fv       : T;
                     name     : TEXT;
                     eventTime: VBT.TimeStamp;
                     select                     := FALSE) RAISES {Error} =
  VAR vbt := GetVBT (fv, name);
  PROCEDURE focus (port: TextPort.T) =
    BEGIN
      IF TextPort.TryFocus (port, eventTime) AND select THEN
        TextPort.Select (
          port, eventTime, 0, LAST (CARDINAL), replaceMode := TRUE)
      END
    END focus;
  BEGIN
    TYPECASE vbt OF
    | TextPort.T (v) =&gt; focus (v)
    | TextEditVBT.T (v) =&gt; focus (v.tp)
    | FVNumeric (v) =&gt; focus (v.typein)
    ELSE
      RAISE Error (name &amp; &quot; cannot take a keyboard focus&quot;)
    END
  END TakeFocus;
</PRE>*********************** Runtime properties ***********************

<P><PRE>PROCEDURE <A NAME="GetTextProperty"><procedure>GetTextProperty</procedure></A> (fv: T; name, prop: TEXT): TEXT
  RAISES {Error, Unimplemented} =
  VAR
    vbt                 := GetVBT (fv, name);
    stateRef: REF State := VBT.GetProp (vbt, TYPECODE (REF State));
  BEGIN
    IF Text.Equal (prop, &quot;Select&quot;) THEN
      TYPECASE vbt OF
      | FVBrowser, FVMultiBrowser =&gt;
          VAR
            v := NARROW(vbt, ListVBT.T);
            cells := v.getAllSelected();
            sel: TEXT;
          BEGIN
            IF NUMBER(cells^) # 0 THEN
              sel :=v.getValue (cells[FIRST(cells^)]) ;
              FOR c := FIRST(cells^)+1 TO LAST(cells^) DO
                sel := sel &amp; &quot;\n&quot; &amp; v.getValue (cells[c])
              END;
              RETURN sel
            ELSE
              RETURN NIL
            END
          END
      ELSE
        RAISE Unimplemented
      END
    ELSIF Text.Equal(prop, &quot;Items&quot;) THEN
      TYPECASE vbt OF
      | FVBrowser, FVMultiBrowser =&gt;
         VAR v := NARROW (vbt, ListVBT.T); stringRep := &quot;&quot;;
          BEGIN
            FOR this := 0 TO v.count() -1 DO
              stringRep := stringRep &amp; &quot;\n&quot; &amp;  v.getValue(this)
            END;
            RETURN stringRep
          END
       ELSE
         RAISE Unimplemented
       END
    ELSIF Text.Equal(prop, &quot;ActiveTarget&quot;) THEN
      TYPECASE vbt OF
      | FVSource (v) =&gt;
         WITH target = SourceVBT.GetTarget(v) DO
            IF target = NIL THEN RAISE Error (&quot;No active target&quot;) END;
            RETURN GetName (target);
         END
       ELSE
         RAISE Unimplemented
       END
    ELSIF stateRef = NIL THEN
      RAISE Error (Fmt.F (&quot;The form named \&quot;%s\&quot; has no properties&quot;, name))
    ELSIF Text.Equal (prop, &quot;Font&quot;) THEN
      RETURN stateRef.fontName
    ELSIF Text.Equal (prop, &quot;LabelFont&quot;) THEN
      RETURN stateRef.labelFontName
    ELSE
      RAISE Unimplemented
    END
  END GetTextProperty;

PROCEDURE <A NAME="PutTextProperty"><procedure>PutTextProperty</procedure></A> (fv: T; name, property: TEXT; t: TEXT)
  RAISES {Error, Unimplemented} =
  VAR
    vbt                 := GetVBT (fv, name);
    stateRef: REF State := VBT.GetProp (vbt, TYPECODE (REF State));
    indx, ct, from : INTEGER;

  PROCEDURE setFont (v: TextPort.T) =
    BEGIN
      stateRef.fontName := t;
      stateRef.font := FindFont (t);
      stateRef.fontMetrics := NIL;
      v.setFont (stateRef.font)
    END setFont;
  BEGIN
    IF Text.Equal (property, &quot;Select&quot;) THEN
      TYPECASE vbt OF
      | FVBrowser, FVMultiBrowser =&gt;
          VAR
            v := NARROW(vbt, ListVBT.T);
          BEGIN
            FOR this := 0 TO v.count () - 1 DO
              IF Text.Equal (v.getValue (this), t) THEN
                v.selectOnly (this);   (* turn off previous selection if any *)
                RETURN
                END (* IF *)
            END;
            v.selectNone ();
            RETURN
            END (* BEGIN *)
      ELSE
      END (* TYPECASE *)
    ELSIF Text.Equal (property, &quot;SelectAlso&quot;) AND   ISTYPE(vbt, FVMultiBrowser) THEN
      (* Selects t if present, else noop *)
      VAR
        v := NARROW(vbt, ListVBT.T);
      BEGIN
         FOR this := 0 TO v.count () - 1 DO
              IF Text.Equal (v.getValue (this), t) THEN
                v.select (this, TRUE);   (* turn off previous selection if any *)
                RETURN
                END
            END;
         RETURN;
       END (* BEGIN *)
    ELSIF Text.Equal (property, &quot;ScrollToShow&quot;) THEN
      (* Scrolls to first occurrence of specified item. Noop if not present *)
      TYPECASE vbt OF
      | FVBrowser, FVMultiBrowser =&gt;
          VAR
            v := NARROW(vbt, ListVBT.T);
          BEGIN
            FOR this := 0 TO v.count () - 1 DO
              IF Text.Equal (v.getValue (this), t) THEN
                v.scrollToShow(this);
                RETURN
                END
            END;
            RETURN
            END (* BEGIN *)
      ELSE
      END (* TYPECASE *)
    ELSIF Text.Equal (property, &quot;Items&quot;) THEN
      TYPECASE vbt OF
      | FVBrowser, FVMultiBrowser =&gt;
        (* FVBrowser and  FVMultiBrowser are ListVBTs - interpret t as a sequence of cells
           demarcated by '\n'. Insert appropriately *)
          VAR
            v := NARROW(vbt, ListVBT.T);
          BEGIN
            v.removeCells(0, v.count()); (* empty listVBT *)
            indx := Text.FindChar(t, '\n', 0); from := 0; ct := 0;
            WHILE indx # -1 DO
              v.insertCells(ct, 1);
              v.setValue(ct, Text.Sub(t, from, indx-from));
              from := indx+1;
              INC(ct);
              IF from &lt; Text.Length(t) THEN
                indx := Text.FindChar(t, '\n', from);
              ELSE
                indx := -1
              END
            END;
            IF from &lt; Text.Length(t) THEN (* last cell *)
              v.insertCells(ct, 1);
              v.setValue(ct, Text.Sub(t, from));
            END;
            v.selectNone ();
            RETURN
            END (* BEGIN *)
      ELSE
      END (* TYPECASE *)
    ELSIF stateRef = NIL THEN
      RAISE Error (Fmt.F (&quot;The form named \&quot;%s\&quot; has no properties&quot;, name))
    ELSIF Text.Equal (property, &quot;Color&quot;) OR Text.Equal (property, &quot;BgColor&quot;) THEN
      TRY
        PutColorProperty (fv, name, property, ColorName.ToRGB (t));
        RETURN
      EXCEPT
      | ColorName.NotFound =&gt; RAISE Error (&quot;No such color: &quot; &amp; t)
      END
    ELSIF Text.Equal (property, &quot;Font&quot;) THEN
      TYPECASE vbt OF
      | TextPort.T (v) =&gt; setFont (v); RETURN
      | TextEditVBT.T (v) =&gt; setFont (v.tp); RETURN
      | NumericVBT.T (v) =&gt; setFont (v.typein); RETURN
      ELSE
      END
    ELSIF Text.Equal (property, &quot;LabelFont&quot;) THEN
      TYPECASE vbt OF
      | FVText (v) =&gt;
          stateRef.labelFontName := t;
          stateRef.labelFont := FindFont (t);
          stateRef.labelFontMetrics := NIL;
          TextVBT.SetFont (v, stateRef.labelFont, TextVBT.GetQuad (v));
          RETURN
      ELSE
      END
    END;
    RAISE Unimplemented
  END PutTextProperty;

PROCEDURE <A NAME="GetColorProperty"><procedure>GetColorProperty</procedure></A> (fv: T; name, property: TEXT): Color.T
  RAISES {Error, Unimplemented} =
  VAR
    vbt                 := GetVBT (fv, name);
    stateRef: REF State := VBT.GetProp (vbt, TYPECODE (REF State));
  BEGIN
    IF Text.Equal (property, &quot;Color&quot;) THEN
      RETURN stateRef.fgRGB
    ELSIF Text.Equal (property, &quot;BgColor&quot;) THEN
      RETURN stateRef.bgRGB
    ELSIF Text.Equal (property, &quot;LightShadow&quot;) THEN
      RETURN stateRef.lightRGB
    ELSIF Text.Equal (property, &quot;DarkShadow&quot;) THEN
      RETURN stateRef.darkRGB
    ELSE
      RAISE Unimplemented
    END
  END GetColorProperty;

PROCEDURE <A NAME="PutColorProperty"><procedure>PutColorProperty</procedure></A> (         fv            : T;
                                     name, property: TEXT;
                            READONLY color         : Color.T)
  RAISES {Error, Unimplemented} =
  PROCEDURE setColor (v: TextPort.T) =
    BEGIN
      v.setColorScheme (
        PaintOp.MakeColorScheme (stateRef.bgOp, stateRef.fgOp))
    END setColor;
  VAR
    vbt                 := GetVBT (fv, name);
    stateRef: REF State := VBT.GetProp (vbt, TYPECODE (REF State));
  BEGIN
    IF Text.Equal (property, &quot;Color&quot;) THEN
      stateRef.fgRGB := color;
      stateRef.fgOp :=
        PaintOp.FromRGB (color.r, color.g, color.b, PaintOp.Mode.Accurate);
      TYPECASE vbt OF
      | TextureVBT.T (v) =&gt; TextureVBT.Set (v, stateRef.fgOp)
      | FVBar (v) =&gt; TextureVBT.Set (Filter.Child (v), stateRef.fgOp)
      | FVBorder (v) =&gt; BorderedVBT.SetColor (v, stateRef.fgOp)
      | TextPort.T (v) =&gt; setColor (v)
      | TextEditVBT.T (v) =&gt; setColor (v.tp)
      | NumericVBT.T (v) =&gt; setColor (v.typein)
      | PixmapVBT.T (v) =&gt;
          PixmapVBT.SetColors (v,
            PaintOp.Pair (stateRef.bgOp, stateRef.fgOp), stateRef.bgOp);
      | FVText (v) =&gt;
          TextVBT.SetFont (
            v, TextVBT.GetFont (v),
            PaintOp.MakeColorQuad (stateRef.bgOp, stateRef.fgOp))
      ELSE
        RAISE Unimplemented
      END
    ELSIF Text.Equal (property, &quot;BgColor&quot;) THEN
      stateRef.bgRGB := color;
      stateRef.bgOp :=
        PaintOp.FromRGB (color.r, color.g, color.b, PaintOp.Mode.Accurate);
      TYPECASE vbt OF
      | TextureVBT.T (v) =&gt; TextureVBT.Set (v, stateRef.bgOp)
      | FVGlue (v) =&gt; TextureVBT.Set (Filter.Child (v), stateRef.bgOp)
      | FVRim (v) =&gt; BorderedVBT.SetColor (v, stateRef.bgOp)
      | TextPort.T (v) =&gt; setColor (v)
      | TextEditVBT.T (v) =&gt; setColor (v.tp)
      | NumericVBT.T (v) =&gt; setColor (v.typein)
      | PixmapVBT.T (v) =&gt;
          PixmapVBT.SetColors (v,
            PaintOp.Pair (stateRef.bgOp, stateRef.fgOp), stateRef.bgOp);
      | FVText (v) =&gt;
          TextVBT.SetFont (
            v, TextVBT.GetFont (v),
            PaintOp.MakeColorQuad (stateRef.bgOp, stateRef.fgOp))
      ELSE
        RAISE Unimplemented
      END
    ELSE
      RAISE Unimplemented
    END
  END PutColorProperty;

VAR fontCache := NEW (TextIntTbl.Default).init ();

PROCEDURE <A NAME="FindFont"><procedure>FindFont</procedure></A> (fontname: TEXT): Font.T =
  VAR fontnumber: INTEGER;
  BEGIN
    IF fontCache.get (fontname, fontnumber) THEN
      RETURN Font.T {fontnumber}
    ELSE
      WITH f = Font.FromName (ARRAY OF TEXT {fontname}) DO
        EVAL fontCache.put (fontname, f.fnt);
        RETURN f
      END
    END
  END FindFont;

PROCEDURE <A NAME="MakeActive"><procedure>MakeActive</procedure></A> (fv: T; name: TEXT; cursor := &quot;&quot;)
  RAISES {Error} =
  BEGIN
    SetReactivity(fv, name, ReactivityVBT.State.Active, cursor);
  END MakeActive;

PROCEDURE <A NAME="MakePassive"><procedure>MakePassive</procedure></A> (fv: T; name: TEXT; cursor := &quot;&quot;)
  RAISES {Error} =
  BEGIN
    SetReactivity(fv, name, ReactivityVBT.State.Passive, cursor);
  END MakePassive;

PROCEDURE <A NAME="MakeDormant"><procedure>MakeDormant</procedure></A> (fv: T; name: TEXT; cursor := &quot;&quot;)
  RAISES {Error} =
  BEGIN
    SetReactivity(fv, name, ReactivityVBT.State.Dormant, cursor);
  END MakeDormant;

PROCEDURE <A NAME="MakeVanish"><procedure>MakeVanish</procedure></A>(fv: T; name: TEXT; cursor:= &quot;&quot;) RAISES {Error} =
  BEGIN
     SetReactivity(fv, name, ReactivityVBT.State.Vanish, cursor);
  END MakeVanish;

PROCEDURE <A NAME="SetReactivity"><procedure>SetReactivity</procedure></A> (fv    : T;
                         name  : Text.T;
                         state : ReactivityVBT.State;
                         cursor: TEXT                 )
  RAISES {Error} =
  VAR curs: Cursor.T;
  BEGIN
    IF Text.Empty(cursor) THEN
      curs := Cursor.DontCare
    ELSE
      curs := Cursor.FromName(ARRAY OF TEXT{cursor})
    END;
    ReactivityVBT.Set(FindReactivityVBT(fv, name), state, curs);
  END SetReactivity;

PROCEDURE <A NAME="IsActive"><procedure>IsActive</procedure></A>(fv: T; name: Text.T): BOOLEAN RAISES {Error} =
  BEGIN
    RETURN TestReactivity(fv, name, ReactivityVBT.State.Active);
  END IsActive;

PROCEDURE <A NAME="IsPassive"><procedure>IsPassive</procedure></A>(fv: T; name: Text.T): BOOLEAN RAISES {Error} =
  BEGIN
    RETURN TestReactivity(fv, name, ReactivityVBT.State.Passive);
  END IsPassive;

PROCEDURE <A NAME="IsDormant"><procedure>IsDormant</procedure></A>(fv: T; name: Text.T): BOOLEAN RAISES {Error} =
  BEGIN
    RETURN TestReactivity(fv, name, ReactivityVBT.State.Dormant);
  END IsDormant;

PROCEDURE <A NAME="IsVanished"><procedure>IsVanished</procedure></A>(fv: T; name: Text.T): BOOLEAN RAISES {Error} =
  BEGIN
    RETURN TestReactivity(fv, name, ReactivityVBT.State.Vanish);
  END IsVanished;

PROCEDURE <A NAME="TestReactivity"><procedure>TestReactivity</procedure></A> (fv: T; name: Text.T; state: ReactivityVBT.State):
  BOOLEAN RAISES {Error} =
  BEGIN
    RETURN state = ReactivityVBT.Get (FindReactivityVBT (fv, name));
  END TestReactivity;

PROCEDURE <A NAME="FindReactivityVBT"><procedure>FindReactivityVBT</procedure></A> (fv: T; name: Text.T): FVFilter
  RAISES {Error} =
  VAR v := GetVBT (fv, name);
  BEGIN
    WHILE v # NIL DO
      TYPECASE v OF FVFilter =&gt; RETURN v ELSE END;
      v := VBT.Parent (v);
    END;
    RAISE Error (&quot;Cannot find FVFilter&quot;);
  END FindReactivityVBT;

PROCEDURE <A NAME="GetBoolean"><procedure>GetBoolean</procedure></A> (fv: T; name: TEXT): BOOLEAN
  RAISES {Error, Unimplemented} =
  BEGIN
    TYPECASE GetVBT (fv, name) OF
    | FVBoolean (b) =&gt; RETURN BooleanVBT.Get (b)
    | FVChoice (c) =&gt; RETURN ChoiceVBT.Get (c) = c
    ELSE
      RAISE Unimplemented
    END
  END GetBoolean;

PROCEDURE <A NAME="GetChoice"><procedure>GetChoice</procedure></A> (fv: T; radioName: TEXT): TEXT
  RAISES {Error, Unimplemented} =
  BEGIN
    TYPECASE GetVBT (fv, radioName) OF
    | FVRadio (r) =&gt;
        TYPECASE ChoiceVBT.Selection (r.radio) OF
        | NULL =&gt; RETURN NIL
        | FVChoice (c) =&gt; RETURN c.name
        ELSE
        END
    ELSE
    END;
    RAISE Unimplemented
  END GetChoice;

PROCEDURE <A NAME="MakeSelected"><procedure>MakeSelected</procedure></A> (fv: T; choiceName: TEXT) RAISES {Error} =
  BEGIN
    TYPECASE GetVBT (fv, choiceName) OF
    | FVChoice (c) =&gt; ChoiceVBT.Put (c)
    ELSE
      RAISE Error (&quot;No Choice named &quot; &amp; choiceName)
    END
  END MakeSelected;

PROCEDURE <A NAME="IsSelected"><procedure>IsSelected</procedure></A> (fv: T; choiceName: TEXT): BOOLEAN RAISES {Error} =
  BEGIN
    TYPECASE GetVBT (fv, choiceName) OF
    | FVChoice (c) =&gt; RETURN ChoiceVBT.Get (c) = c
    ELSE
      RAISE Error (&quot;No Choice named &quot; &amp; choiceName)
    END
  END IsSelected;
</PRE>************************ Generic interactors *********************

<P><PRE>PROCEDURE <A NAME="PutGeneric"><procedure>PutGeneric</procedure></A> (fv: T; genericName: TEXT; vbt: VBT.T)
  RAISES {Error} =
  BEGIN
    TYPECASE GetVBT (fv, genericName) OF
    | FVGeneric (v) =&gt;
        IF vbt = NIL THEN
          EVAL Filter.Replace (v, NIL);
          FlexVBT.Set (v, EMPTYSHAPE)
        ELSE
          EVAL Filter.Replace (v, vbt);
          FlexVBT.Set (v, FlexVBT.Default)
        END;
        RETURN
    ELSE
      RAISE Error (&quot;No Generic named &quot; &amp; genericName)
    END
  END PutGeneric;

PROCEDURE <A NAME="GetGeneric"><procedure>GetGeneric</procedure></A> (fv: T; genericName: TEXT): VBT.T RAISES {Error} =
  BEGIN
    TYPECASE GetVBT (fv, genericName) OF
    | FVGeneric (v) =&gt; RETURN Filter.Child (v)
    ELSE
      RAISE Error (&quot;No Generic named &quot; &amp; genericName)
    END
  END GetGeneric;
</PRE>*********************** Debugging tools ***********************

<P><PRE>PROCEDURE <A NAME="ToText"><procedure>ToText</procedure></A> (x        : REFANY;
                  maxDepth : CARDINAL := LAST (CARDINAL);
                  maxLength: CARDINAL := LAST (CARDINAL)  ): TEXT =
  BEGIN
    TYPECASE x OF
    | NULL =&gt; RETURN &quot;NIL&quot;
    | Atom.T (sym) =&gt; RETURN Atom.ToText (sym)
    | TEXT (t) =&gt; RETURN t
    ELSE
      WITH wr = TextWr.New () DO
        TRY
          Sx.Print (wr, x, maxDepth, maxLength);
          RETURN TextWr.ToText (wr)
        EXCEPT
        | Thread.Alerted, Sx.PrintError, Wr.Failure =&gt;
            RETURN &quot;&lt;Unprintable expression&gt;&quot;
        END
      END
    END
  END ToText;

PROCEDURE <A NAME="NamedVBTs"><procedure>NamedVBTs</procedure></A> (t: T): RefList.T =
  VAR
    name: TEXT;
    vbt : REFANY;
    res : RefList.T := NIL;
    iter            := t.getVBT.iterateOrdered (FALSE);
  BEGIN
    WHILE iter.next (name, vbt) DO Push (res, RefList.List2 (name, vbt)) END;
    RETURN res
  END NamedVBTs;

&lt;*UNUSED *&gt; (* except during debugging! *)
PROCEDURE <A NAME="DumpTable"><procedure>DumpTable</procedure></A> (fv: T) =
  VAR
    value      : REFANY;
    key        : TEXT;
    alist, pair: RefList.T;
  BEGIN
    alist := NamedVBTs (fv);
    WHILE alist # NIL DO
      pair := Pop (alist);
      key := Pop (pair);
      value := pair.head;
      IO.Put (key);
      IO.Put (&quot; -&gt; &quot;);
      IO.Put (RTTypeSRC.TypeName (value));
      IO.Put (&quot;\n&quot;)
    END
  END DumpTable;

PROCEDURE <A NAME="GetAttachments"><procedure>GetAttachments</procedure></A> (fv: T): RefList.T =
  VAR
    key     : TEXT;
    value   : REFANY;
    alist   : RefList.T := NIL;
    iter                := fv.getVBT.iterate ();
    property: REFANY;
  BEGIN
    WHILE iter.next (key, value) DO
      property := VBT.GetProp (value, TYPECODE (ClosureRef));
      IF property # NIL THEN Push (alist, RefList.List2 (key, property)) END
    END;
    RETURN alist
  END GetAttachments;

PROCEDURE <A NAME="SetAttachments"><procedure>SetAttachments</procedure></A> (fv: T; alist: RefList.T) RAISES {Error} =
  VAR
    name      : TEXT;
    attachment: ClosureRef;
    pair      : RefList.T;
  BEGIN
    WHILE alist # NIL DO
      pair := Pop (alist);
      name := pair.head;
      attachment := pair.tail.head;
      Attach (fv, name, attachment.cl)
    END
  END SetAttachments;

PROCEDURE <A NAME="InitRuntime"><procedure>InitRuntime</procedure></A> () =
  BEGIN
    MakeEventMiscCodeType := VBT.GetMiscCodeType (&quot;FVRuntime.MakeEvent&quot;);
    MakeEventSelection := VBT.GetSelection (&quot;FVRuntime.MakeEvent&quot;);
    cleanState.fgOp :=
      PaintOp.FromRGB (
        cleanState.fgRGB.r,
        cleanState.fgRGB.g,
        cleanState.fgRGB.b,
        PaintOp.Mode.Accurate, bw := PaintOp.BW.UseFg);
    cleanState.bgOp :=
      PaintOp.FromRGB (
        cleanState.bgRGB.r,
        cleanState.bgRGB.g,
        cleanState.bgRGB.b,
        PaintOp.Mode.Accurate, bw := PaintOp.BW.UseBg);
    cleanState.lightOp :=
      PaintOp.FromRGB (
        cleanState.lightRGB.r,
        cleanState.lightRGB.g,
        cleanState.lightRGB.b,
        PaintOp.Mode.Accurate, bw := PaintOp.BW.UseFg);
    cleanState.darkOp :=
      PaintOp.FromRGB (
        cleanState.darkRGB.r,
        cleanState.darkRGB.g,
        cleanState.darkRGB.b,
        PaintOp.Mode.Accurate, bw := PaintOp.BW.UseFg);

    cleanState.fontMetrics := DefaultFontMetrics;
    cleanState.fontName := MetricsToName (cleanState.fontMetrics);
    cleanState.font := Font.FromName (ARRAY OF TEXT {cleanState.fontName});

    cleanState.labelFontMetrics := DefaultLabelFontMetrics;
    cleanState.labelFontName := MetricsToName (cleanState.labelFontMetrics);
    cleanState.labelFont :=
      Font.FromName (ARRAY OF TEXT {cleanState.labelFontName});

    cleanState.shadow :=
      Shadow.New (cleanState.shadowSz,
                  cleanState.bgOp, cleanState.fgOp,
                  cleanState.lightOp, cleanState.darkOp);
    (* Initial state.zsplit are set in Init. *)

  END InitRuntime;

BEGIN
  (* From the FormsVBT language itself: *)
  qBOA := Atom.FromText (&quot;BOA&quot;);
  qName := Atom.FromText (&quot;Name&quot;);
  qValue := Atom.FromText (&quot;Value&quot;);
  (* &quot;Internal&quot; symbols for macros: *)
  qBackquote := Atom.FromText (&quot; backquote &quot;);
  qComma := Atom.FromText (&quot; comma &quot;);
  qCommaAtsign := Atom.FromText (&quot; comma-atsign &quot;);
  qQuote := Atom.FromText (&quot; quote &quot;);
  InitParser ();
  InitRuntime ();
  Macro.Init ()
END FVRuntime.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
