<HTML>
<HEAD>
<TITLE>SRC Modula-3: formsvbt/src/FormsVBT.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>formsvbt/src/FormsVBT.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
&lt;* PRAGMA LL *&gt;
&lt;* PRAGMA SUBTYPE *&gt;
</PRE> FormsVBT is a system for building graphical user interfaces.
   FormsVBT provides a special-purpose language for describing
   user interfaces, an interface-builder that allows editing of
   such descriptions, and a runtime library for applications to
   make use of the user interfaces.
<P>
   The locking level for any procedure in this interface that may
   alter an installed <CODE>VBT</CODE> is <CODE>LL.sup = VBT.mu</CODE>. (See the 
   {\it Trestle Reference Manual\/} for a complete description
   of locking levels~\cite{TrestleTutorial}.) Most applications 
   don't need to worry about <CODE>VBT.mu</CODE> because their event-handlers 
   don't fork any threads that call FormsVBT. 

<P><PRE>INTERFACE <interface><A HREF="#x1">FormsVBT</A></interface>;

IMPORT <A HREF="../../vbtkitutils/src/AnyEvent.i3">AnyEvent</A>, <A HREF="../../color/src/Color.i3">Color</A>, <A HREF="../../ui/src/split/Filter.i3">Filter</A>, <A HREF="../../rw/src/Common/Rd.i3">Rd</A>, <A HREF="../../vbtkitutils/src/Rsrc.i3">Rsrc</A>, <A HREF="../../sx/src/Sx.i3">Sx</A>, <A HREF="../../thread/src/Common/Thread.i3">Thread</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>,
       <A HREF="../../rw/src/Common/Wr.i3">Wr</A>, <A HREF="../../ui/src/split/ZSplit.i3">ZSplit</A>;

EXCEPTION
  Error (TEXT);
  Unimplemented;
  Mismatch;
</PRE> \section{Creation, allocation, and initialization} 

<P> An object <CODE>fv</CODE> of type <CODE>FormsVBT.T</CODE> (or simply, a {\it form}) is
   created by parsing an S-expression.  These expressions are usually
   stored in files with the suffix <CODE>.fv</CODE>.  One way of creating a form
   is to call the procedure <CODE>NewFromFile</CODE>, or the method
   <CODE>fv.initFromFile</CODE>, with the name of such a file; the expression is
   parsed, and if there are no errors, a new <CODE>VBT</CODE> is created and
   stored in the form, which is returned.
<P>
   It is also possible for a program to generate a description
   ``on the fly'' and then use it to create a form.  The methods
   <CODE>fv.init</CODE>, <CODE>fv.initFromRd</CODE>, and <CODE>fv.initFromSx</CODE> support these
   options. 

<P><PRE>TYPE
  <A HREF="FVRuntime.m3#T">T</A> &lt;: Public;
  &lt;* SUBTYPE T &lt;: MultiFilter.T *&gt; (* ... *)
  Public = Filter.T OBJECT
           METHODS
             &lt;* LL.sup &lt;= VBT.mu *&gt;
             init (description : TEXT;
                   raw         : BOOLEAN   := FALSE;
                   path        : Rsrc.Path := NIL    ): T
                   RAISES {Error};
             initFromFile (filename : TEXT;
                           raw      : BOOLEAN   := FALSE;
                           path     : Rsrc.Path := NIL    ): T
                 RAISES {Error, Rd.Failure, Thread.Alerted};
             initFromRd (rd   : Rd.T;
                         raw  : BOOLEAN   := FALSE;
                         path : Rsrc.Path := NIL    ): T
                 RAISES {Error, Rd.Failure, Thread.Alerted};
             initFromSx (sx   : Sx.T;
                         raw  : BOOLEAN   := FALSE;
                         path : Rsrc.Path := NIL    ): T
                 RAISES {Error};
             initFromRsrc (name : TEXT;
                           path : Rsrc.Path;
                           raw  : BOOLEAN    := FALSE): T
                 RAISES {Error, Rd.Failure,
                         Rsrc.NotFound, Thread.Alerted};

             realize (type, name: TEXT): VBT.T RAISES {Error};

             &lt;* LL.sup = VBT.mu *&gt;
             snapshot (wr: Wr.T) RAISES {Error};
             restore  (rd: Rd.T) RAISES {Mismatch, Error};

           END;
</PRE> The call <CODE>fv.init(description, raw, path)</CODE> initializes <CODE>fv</CODE> as
   a form and returns <CODE>fv</CODE>.  It creates a <CODE>VBT</CODE>, {\it v}, from
   <CODE>description</CODE>, which must contain a single, valid
   S-expression.  The methods <CODE>initFromFile</CODE>, <CODE>initFromRd</CODE>,
   <CODE>initFromSx</CODE>, and <CODE>initFromRsrc</CODE> provide analogous support for
   files, readers, S-expressions, and named resources.  Files are
   accessed via 
<PRE>
      FileRd.Open (filename) 
   </PRE>
Exceptions of type <CODE>OSError.E</CODE>, <CODE>Rd.EndOfFile</CODE> 
   and <CODE>Rsrc.NotFound</CODE> are signaled as <CODE>Error</CODE>.
<P>
   The <CODE>raw</CODE> parameter is used to control that actual internal
   structure <CODE>fv</CODE>.  Regardless of the value of <CODE>raw,</CODE> <CODE>fv</CODE> is a
   multi-filter and <CODE>MultiFilter.Child(fv)</CODE> will always return
   {\it v}.  Internally, <CODE>fv</CODE> is a filter; if <CODE>raw</CODE> is <CODE>TRUE</CODE>,
   then the filter's child is {\it v}.  Otherwise, <CODE>fv</CODE> is
   ``cooked'', which means there are several filters inserted
   between {\it v} and <CODE>fv</CODE>, so that the filter's child has the
   following structure:
<P>
<PRE>
      (ZSplit
        (Filter
          (HighlightVBT
            (Filter <KBD>{\it v}</KBD>))))
</PRE>
   The filter above {\it v} supports the common case of making an
   entire form passive without requiring an explicit <CODE>Filter</CODE>
   interactor in the description.  It also functions to restore
   the keyboard focus to whichever of the form's
   descendant-<CODE>VBT</CODE>s had most recently acquired the keyboard
   focus.  The <CODE>ZSplit</CODE> supports menus and other pop-up
   operations, even if there is no <CODE>ZSplit</CODE> explicitly mentioned
   in the description.  To get the <CODE>ZSplit</CODE> that is inserted, use
   <CODE>GetZSplit</CODE>.  Clients should not traverse a cooked form
   directly.  We reserve the right to change the filters that are
   inserted.
<P>
   The <CODE>path</CODE> parameter is used for looking up all resources that
   are mentioned in the form, including the name of a
   <CODE>Pixmap</CODE> or <CODE>Image</CODE>; a file for <CODE>Insert</CODE>; the <CODE>ItemFromFile</CODE>
   property on <CODE>Browser</CODE> and <CODE>MultiBrowser</CODE>; and the <CODE>From</CODE>
   property on <CODE>Text</CODE>, <CODE>TypeIn</CODE>, and <CODE>TextEdit</CODE>.
<P>
   Briefly, the description of a form is an S-expression whose
   first element is the name of a component (e.g., <CODE>HBox</CODE>), and
   whose other elements are either properties (e.g., <CODE>Color</CODE>), or
   other components, typically describing the <CODE>VBT</CODE>-children of
   the outer component.
<P>
   The <CODE>VBT</CODE>-tree is created during a depth-first traversal of
   the S-expression.  On the way down, each <CODE>VBT</CODE> is {\it
   allocated}, typically with a call to <CODE>NEW(...)</CODE>.  Then the
   subexpressions, if any, are traversed.  On the way back up,
   each <CODE>VBT</CODE> is {\it initialized}, typically with a call to
   <CODE>v.init(...)</CODE>.  The result is returned to the caller, where it
   is typically an argument to the parent's <CODE>init</CODE> method.
<P>
   In other words, allocation occurs top-down, and initialization
   occurs bottom-up.  (For more details on allocation, see
   Section~\ref{realize}.)
<P>
   For each subexpression, the parser produces a <CODE>VBT</CODE> whose type
   is defined in the <CODE>FVTypes</CODE> interface, and whose name
   corresponds to the first element of the subexpression.  For
   example, from the S-expression <CODE>(HBox ...)</CODE>, the parser
   creates an object of type <CODE>FVTypes.FVHBox</CODE>. 

<P><PRE>PROCEDURE <A HREF="FVRuntime.m3#NewFromFile">NewFromFile</A> (filename: TEXT;
                       raw                 := FALSE;
                       path    : Rsrc.Path := NIL    ): T
  RAISES {Error, Rd.Failure, Thread.Alerted};
</PRE><BLOCKQUOTE><EM> Create a new form from the description in the file.  <CODE>Rd.EndOfFile</CODE> is
   signalled as <CODE>Error</CODE>.
<P>
   Equivalent to <CODE>NEW(T).initFromFile (name, raw, path)</CODE> </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="FVRuntime.m3#GetZSplit">GetZSplit</A> (fv: T): ZSplit.T RAISES {Error};
</PRE><BLOCKQUOTE><EM> Return the <CODE>ZSplit</CODE> that ``cooked'' mode inserts.  An
   exception is raised if <CODE>fv</CODE> was created with <CODE>raw =
   TRUE</CODE>. </EM></BLOCKQUOTE><PRE>
</PRE><P>
\section{Events and Symbols} \label{sec:programming-events}
\subsection{Attaching event-handlers}
<P>
   Most interactive components in the user interface generate
   events. (See the Appendix~\ref{ap:longcatalog} for a
   description of all components.) To register an event-handler for such a component,
   the component must be named, and the client must call <CODE>Attach</CODE>
   or <CODE>AttachProc</CODE>, giving the name of the component and a
   procedure to be called when an event occurs in that
   component. 

<P><PRE>PROCEDURE <A HREF="FVRuntime.m3#Attach">Attach</A> (fv: T; name: TEXT; cl: Closure) RAISES {Error};
</PRE><BLOCKQUOTE><EM> Attach an event-handler (``callback'') to the component of <CODE>fv</CODE>
   whose name is given by <CODE>name</CODE>.  If there is no such component, or
   if that component does not generate events (e.g., <CODE>Text</CODE>), then
   <CODE>Error</CODE> will be raised.  If <CODE>cl</CODE> is <CODE>NIL</CODE>, then any existing
   event-handler for that component is removed.  Otherwise, when an
   event occurs in the named component, the implementation calls
<PRE>
         cl.apply(fv, name, <KBD>{\it time}</KBD>)
   </EM></BLOCKQUOTE><PRE>

TYPE
  Closure = OBJECT
            METHODS
              apply (fv: T; name: TEXT; time: VBT.TimeStamp);
            END;

PROCEDURE <A HREF="FVRuntime.m3#AttachProc">AttachProc</A> (fv       : T;
                      name     : TEXT;
                      p        : Proc;
                      eventData: REFANY := NIL) RAISES {Error};
</PRE><BLOCKQUOTE><EM> This is an alternate, somewhat simpler way to attach an
   event-handler.  When an event occurs in the named component,
   the implementation calls
<PRE>
      p(fv, name, eventData, <KBD>{\it time}</KBD>)
   </EM></BLOCKQUOTE><PRE>

TYPE
  Proc = PROCEDURE (fv       : T;
                    name     : TEXT;
                    eventData: REFANY;
                    time     : VBT.TimeStamp);
</PRE> These event-handlers do not provide any other details, such as
   what key or mouse button was pressed, or whether it was a
   double-click.  If such information is needed, call
   <CODE>GetTheEvent</CODE> to retrieve it. 

<P><PRE>PROCEDURE <A HREF="FVRuntime.m3#AttachEditOps">AttachEditOps</A> (fv        : T;
                         editorName: TEXT;
                         cut, copy, paste, clear,
                         selectAll, undo, redo,
                         findFirst, findNext, findPrev: TEXT := NIL)
  RAISES {Error};                &lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Create and attach event-handlers for common editing operations. </EM></BLOCKQUOTE><PRE>
</PRE> <CODE>editorName</CODE> must be the name of a text-editing component:
   <CODE>TextEdit</CODE>, <CODE>TypeIn</CODE>, <CODE>Numeric</CODE>, or <CODE>Typescript</CODE>. If <CODE>cut</CODE> is not
   <CODE>NIL</CODE>, then it must be the name of a component (typically a
   menu-button), and <CODE>AttachEditOps</CODE> will create an event-handler for
   it that will invoke the {\bf Cut} operation on the text-editing
   component.  Similarly, if <CODE>copy</CODE> is not <CODE>NIL</CODE>, then it should name
   a component for which <CODE>AttachEditOps</CODE> will create an event-handler
   that invokes the {\bf Copy} operation on the text-editing
   component. Likewise for <CODE>paste</CODE>, <CODE>clear</CODE>, and so on. 

<P> \subsection{Access to the current event} 

<P><PRE>PROCEDURE <A HREF="FVRuntime.m3#GetTheEvent">GetTheEvent</A>     (fv: T): AnyEvent.T    RAISES {Error};
PROCEDURE <A HREF="FVRuntime.m3#GetTheEventTime">GetTheEventTime</A> (fv: T): VBT.TimeStamp RAISES {Error};
</PRE><BLOCKQUOTE><EM> Retrieve the details of the event that is currently in
   progress.  These routines may be called only during the
   dynamic extent of an event-handler attached to some component
   via <CODE>Attach</CODE> or <CODE>AttachProc</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="FVRuntime.m3#MakeEvent">MakeEvent</A> (fv: T; name: TEXT; time: VBT.TimeStamp)
  RAISES {Error};
</PRE><BLOCKQUOTE><EM> <CODE>MakeEvent</CODE> invokes the event-handler for the component of <CODE>fv</CODE>
   whose name is <CODE>name</CODE>. A component has an event-handler if attached
   via <CODE>Attach</CODE> or <CODE>AttachProc</CODE>, or if the component is a PopButton,
   PopMButton, PageButton, PageMButton, LinkButton, or LinkMButton.
</EM></BLOCKQUOTE><PRE>
</PRE> <CODE>MakeEvent</CODE> is useful when one part of a large program wishes to
   communicate with another part, by pretending that the named event
   occurred. For example, a client might want typing a particular
   control-character in a text-editing component to have
   the same effect as selecting a menu-item such as ``Quit.''
   <CODE>MakeEvent</CODE> provides a way to link the two events to the same
   handler. 

<P><PRE>VAR MakeEventMiscCodeType: VBT.MiscCodeType; (* CONST *)
</PRE><BLOCKQUOTE><EM> The exact type of the result of <CODE>GetTheEvent</CODE> depends on the user
   action that caused the event to be generated, a key, a mouse-click,
   etc.  If the event was actually caused by a call to <CODE>MakeEvent</CODE>,
   the type of the result will be <CODE>AnyEvent.Misc</CODE>, and the value of
   its <CODE>type</CODE> field will be <CODE>MakeEventMiscCodeType</CODE>. </EM></BLOCKQUOTE><PRE>
</PRE> \subsection{Symbol management} 

<P><PRE>PROCEDURE <A HREF="FVRuntime.m3#AddSymbol">AddSymbol</A> (fv: T; name: TEXT) RAISES {Error};
</PRE><BLOCKQUOTE><EM> Add a ``virtual'' component to <CODE>fv</CODE> with the given <CODE>name</CODE>.
   The form will behave as if there was a component called <CODE>name</CODE>
   (i.e., the call <CODE>GetVBT(fv, name)</CODE> will return a valid
   <CODE>VBT</CODE>).
<P>
   This procedure is most useful as a means to communicate
   between distant parts of a large program.  One part of the
   program would use <CODE>AddSymbol</CODE> to create a new symbol; another
   part would call <CODE>MakeEvent</CODE> to invoke an event-handler for the
   symbol.
<P>
   <CODE>Error</CODE> is raised if <CODE>name</CODE> is already defined in <CODE>fv</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="FVRuntime.m3#AddUniqueSymbol">AddUniqueSymbol</A> (fv: T): TEXT;
</PRE><BLOCKQUOTE><EM> Just like <CODE>AddSymbol</CODE>, but finds a name that has not been used
   yet.  The name is returned. </EM></BLOCKQUOTE><PRE>
</PRE> \section{Reading and Changing State}
<P>
   \label{sec:programming-state}
<P>
   In response to an event or other occurrence, a program may
   want to read or change the state of various interactors in the
   form.  This is handled by the various Get and Put procedures.
   Get procedures take the form and the name of the interactor,
   and return its value.  Put procedures take the form, the name
   of the interactor, and the new value to be set.
<P>
   There are several Get procedures and several Put procedures,
   for convenient handling of various Modula-3 types.  These should
   be used as appropriate to the type of the interactor:
   <CODE>GetText</CODE> for a <CODE>TypeIn</CODE>, <CODE>GetInteger</CODE> for a <CODE>Numeric</CODE>,
   <CODE>GetBoolean</CODE> for a <CODE>Boolean</CODE> or <CODE>Choice</CODE>, etc. However, some
   conversions are supported: <CODE>PutInteger</CODE> to a <CODE>TypeIn</CODE> will
   convert the integer into text; <CODE>GetInteger</CODE> will likewise
   attempt to convert the text of the <CODE>TypeIn</CODE> to an integer
   (and return 0 in case of failure).  All Get and Put
   procedures, however, will raise <CODE>Error</CODE> if applied to a
   component that does not have a value.
<P>
   \subsection{Access to the {\tt Main} and {\tt Value} properties}
 

<P><PRE>PROCEDURE <A HREF="FVRuntime.m3#GetText">GetText</A> (fv: T; name: TEXT): TEXT
  RAISES {Error, Unimplemented};
</PRE><BLOCKQUOTE><EM> This is implemented for <CODE>Browser</CODE>, <CODE>FileBrowser</CODE>, <CODE>Numeric</CODE>,
   <CODE>Text</CODE>, <CODE>Typescript</CODE>, and the text-interactors: <CODE>TextEdit</CODE>,
   <CODE>TypeIn</CODE>, and <CODE>TextArea</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="FVRuntime.m3#PutText">PutText</A> (fv: T; name: TEXT; t: TEXT; append := FALSE)
  RAISES {Error, Unimplemented};
</PRE><BLOCKQUOTE><EM> This is implemented for <CODE>Browser</CODE>, <CODE>FileBrowser</CODE>, <CODE>Pixmap</CODE>, <CODE>Text</CODE>,
   <CODE>Typescript</CODE>, and the text-interactors: <CODE>TextEdit</CODE>, <CODE>TypeIn</CODE>, and
   <CODE>TextArea</CODE>.  For <CODE>Text</CODE> and the text-interactors, if <CODE>append</CODE> is
   true, then <CODE>t</CODE> is added to the end of the current text, rather than
   replacing it. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="FVRuntime.m3#GetInteger">GetInteger</A> (fv: T; name: TEXT): INTEGER
  RAISES {Error, Unimplemented};
PROCEDURE <A HREF="FVRuntime.m3#PutInteger">PutInteger</A> (fv: T; name: TEXT; n: INTEGER)
  RAISES {Error, Unimplemented};
</PRE><BLOCKQUOTE><EM> These are implemented for <CODE>Browser</CODE>, <CODE>Numeric</CODE>, <CODE>Scroller</CODE>, and
   <CODE>TSplit</CODE>. <CODE>PutInteger</CODE> only is implemented for <CODE>Audio</CODE>. </EM></BLOCKQUOTE><PRE>
</PRE> If you use <CODE>PutInteger</CODE> to select the <CODE>n</CODE>th child of a <CODE>TSplit</CODE> and
   that child has a text-editing component that has the <CODE>FirstFocus</CODE>
   property, then the text-editor will acquire the keyboard focus, and
   if it's a <CODE>TypeIn</CODE>, its text will be selected in replace-mode. 

<P><PRE>PROCEDURE <A HREF="FVRuntime.m3#GetBoolean">GetBoolean</A> (fv: T; name: TEXT): BOOLEAN
  RAISES {Error, Unimplemented};
PROCEDURE <A HREF="FVRuntime.m3#PutBoolean">PutBoolean</A> (fv: T; name: TEXT; val: BOOLEAN)
  RAISES {Error, Unimplemented};
</PRE><BLOCKQUOTE><EM> These are implemented for <CODE>Boolean</CODE> and <CODE>Choice</CODE>. </EM></BLOCKQUOTE><PRE>
</PRE> \subsection{Access to arbitrary properties}
<P>
   FormsVBT provides access to properties other than <CODE>Main</CODE> and
   <CODE>Value</CODE>.  The intention is to provide access to all the inherited
   and class properties.  For example, the <CODE>Scroller</CODE> component has an
   integer-valued property named <CODE>Min</CODE>, so it should be possible to
   call
<PRE>
      GetIntegerProperty(fv, name, &quot;Min&quot;)
   </PRE>
to retrieve that value, or
<PRE>
      PutIntegerProperty(fv, name, &quot;Min&quot;, 6)
   </PRE>
to change the value to 6.
 <P>
   \vspace {5mm}
  {\bf WARNING: The current implementation provides access
   only to the inherited properties, and even that access is limited.}
   \vspace {5mm}
<P>
   Note also that changing the value of a property in a component will not affect
   its subcomponents. 

<P><PRE>PROCEDURE <A HREF="FVRuntime.m3#GetTextProperty">GetTextProperty</A> (fv: T; name, propertyName: TEXT): TEXT
  RAISES {Error, Unimplemented};
</PRE><BLOCKQUOTE><EM> This is implemented for the <CODE>Font</CODE> and <CODE>LabelFont</CODE> properties for
   all components, as well as the <CODE>Items</CODE> and <CODE>Select</CODE> properties of <CODE>Browser</CODE>s,
   and the <CODE>ActiveTarget</CODE> property of <CODE>Source</CODE>s. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="FVRuntime.m3#PutTextProperty">PutTextProperty</A> (fv: T; name, propertyName: TEXT; value: TEXT)
  RAISES {Error, Unimplemented};
</PRE><BLOCKQUOTE><EM> This is implemented for the <CODE>Color</CODE>, <CODE>BgColor</CODE>, <CODE>Font</CODE>, and
   <CODE>LabelFont</CODE> properties for all components, as well as the <CODE>Items</CODE> and <CODE>Select</CODE> 
   properties of <CODE>Browser</CODE>s. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="FVRuntime.m3#GetIntegerProperty">GetIntegerProperty</A> (fv: T; name, propertyName: TEXT):
  INTEGER RAISES {Error, Unimplemented};
PROCEDURE <A HREF="FVRuntime.m3#PutIntegerProperty">PutIntegerProperty</A> (fv                : T;
                              name, propertyName: TEXT;
                              value             : INTEGER)
  RAISES {Error, Unimplemented};
</PRE><BLOCKQUOTE><EM> This is implemented for the <CODE>Min</CODE> and <CODE>Max</CODE> properties of
   <CODE>Numeric</CODE>s; the <CODE>Min</CODE>, <CODE>Max</CODE>, <CODE>Step</CODE>, and <CODE>Thumb</CODE> properties
   of <CODE>Scroller</CODE>s; and the <CODE>Quality</CODE>, <CODE>ImageWidth</CODE>, <CODE>ImageHeight</CODE>
   and <CODE>MSecs</CODE> properties of <CODE>Video</CODE>s, and the <CODE>NorthEdge</CODE>,
   <CODE>SouthEdge</CODE>, <CODE>EastEdge</CODE> and <CODE>WestEdge</CODE> properties of all
   VBTs.</EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="FVRuntime.m3#GetRealProperty">GetRealProperty</A> (fv: T; name, propertyName: TEXT): REAL
  RAISES {Error, Unimplemented};
PROCEDURE <A HREF="FVRuntime.m3#PutRealProperty">PutRealProperty</A> (fv                : T;
                           name, propertyName: TEXT;
                           value             : REAL  )
  RAISES {Error, Unimplemented};
</PRE><BLOCKQUOTE><EM> This is implemented for the <CODE>HScale</CODE> and <CODE>VScale</CODE> properties of
   <CODE>Scale</CODE>s. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="FVRuntime.m3#GetColorProperty">GetColorProperty</A> (fv: T; name, property: TEXT): Color.T
  RAISES {Error, Unimplemented};
</PRE><BLOCKQUOTE><EM> Return the color used by the named component. <CODE>property</CODE> must
   be one of <CODE>Color</CODE>, <CODE>BgColor</CODE>, <CODE>LightShadow</CODE>, or <CODE>DarkShadow</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="FVRuntime.m3#PutColorProperty">PutColorProperty</A> (         fv            : T;
                                     name, property: TEXT;
                            READONLY color         : Color.T)
  RAISES {Error, Unimplemented};
</PRE><BLOCKQUOTE><EM> Set the color used by the named component. <CODE>property</CODE> must be
   <CODE>Color</CODE> or <CODE>BgColor</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="FVRuntime.m3#GetBooleanProperty">GetBooleanProperty</A> (fv: T; name, propertyName: TEXT):
  BOOLEAN RAISES {Error, Unimplemented};
PROCEDURE <A HREF="FVRuntime.m3#PutBooleanProperty">PutBooleanProperty</A> (fv                : T;
                              name, propertyName: TEXT;
                              value             : BOOLEAN)
  RAISES {Error, Unimplemented};
 (* This is implemented for the &quot;ReadOnly&quot; property of
   &quot;TextEdit&quot;s, and the shadow styles of &quot;Frame&quot;s.  The
   &quot;PutBooleanProperty&quot; is implemented for the &quot;Synchronous&quot;,
   &quot;Paused&quot; and &quot;FixedSize&quot; properties of &quot;Video&quot;, and for the
   &quot;Mute&quot; and &quot;MuteWhenUnmapped&quot; properties of &quot;Audio&quot; *)
</PRE> \subsection{Access to the underlying {\tt VBT}s} 

<P><PRE>PROCEDURE <A HREF="FVRuntime.m3#GetVBT">GetVBT</A> (fv: T; name: TEXT): VBT.T RAISES {Error};
</PRE><BLOCKQUOTE><EM> Return the <CODE>VBT</CODE> corresponding to a named interactor in <CODE>fv</CODE>.
   <CODE>Error</CODE> is raised if there is no such <CODE>VBT</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="FVRuntime.m3#GetName">GetName</A> (vbt: VBT.T): TEXT RAISES {Error};
</PRE><BLOCKQUOTE><EM> If <CODE>vbt</CODE> is the <CODE>VBT</CODE> corresponding to a named interactor
   in some form, returns the name given to that interactor.
   Otherwise, raisses <CODE>Error</CODE>. </EM></BLOCKQUOTE><PRE>
</PRE> \subsection{Radios and Choices} 

<P><PRE>PROCEDURE <A HREF="FVRuntime.m3#GetChoice">GetChoice</A> (fv: T; radioName: TEXT): TEXT
  RAISES {Error, Unimplemented};
PROCEDURE <A HREF="FVRuntime.m3#PutChoice">PutChoice</A> (fv: T; radioName, choiceName: TEXT)
  RAISES {Error, Unimplemented};
</PRE><BLOCKQUOTE><EM> Get/Put the name of the selected <CODE>Choice</CODE> in a radio-button
   group. If there is no selection, <CODE>GetChoice</CODE> returns <CODE>NIL</CODE>.
   If <CODE>choiceName</CODE> is <CODE>NIL</CODE>, the radio-group will have no selection. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="FVRuntime.m3#MakeSelected">MakeSelected</A> (fv: T; choiceName: TEXT) RAISES {Error};
PROCEDURE <A HREF="FVRuntime.m3#IsSelected">IsSelected</A> (fv: T; choiceName: TEXT): BOOLEAN
  RAISES {Error};
</PRE><BLOCKQUOTE><EM> Set/test a <CODE>Choice</CODE>-button without referring to its group. </EM></BLOCKQUOTE><PRE>
</PRE> \subsection{Generic interactors} 

<P><PRE>PROCEDURE <A HREF="FVRuntime.m3#GetGeneric">GetGeneric</A> (fv: T; genericName: TEXT): VBT.T
  RAISES {Error};
</PRE><BLOCKQUOTE><EM> Retrieve the <CODE>VBT</CODE> used by the named <CODE>Generic</CODE> interactor. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="FVRuntime.m3#PutGeneric">PutGeneric</A> (fv: T; genericName: TEXT; vbt: VBT.T)
  RAISES {Error};
</PRE><BLOCKQUOTE><EM> Replace the named <CODE>Generic</CODE> interactor with <CODE>vbt</CODE>, which may
   be <CODE>NIL</CODE>.  When <CODE>NIL</CODE> is specified, a default (and initial)
   <CODE>VBT</CODE> is used: a <CODE>TextureVBT</CODE> with 0 size and 0 stretch in
   each dimension. </EM></BLOCKQUOTE><PRE>
</PRE> \subsection{Special controls for Filters}
<P>
   The <CODE>(Filter ...)</CODE> expression in FormsVBT supports a feature called
   {\em reactivity}.\index{reactivity} This has one of four states:
   Active, Passive, Dormant, or Vanished.  The state can be specified
   in the description and changed by the application at runtime.  The
   default state is Active.  In the Passive state, the component and
   its descendants, if any, are unresponsive to mouse clicks.  The
   Dormant state is like Passive, but the component and descendants
   are ``grayed out.'' Dormant is often to be preferred over Passive,
   because it provide additional feedback to the user.  In the
   Vanished state, the component becomes unreactive and disappears
   entirely. 
<P>
   A cursor is specified when the state is set, and the name is interpretted
   by the Trestle implementation. An empty string (the default value)
   indicates that you don't care about the cursor shape. 
   <P>
   Standard X screentypes support the cursors named in {\it X Window
   System} by Scheifler et.  al. \cite{XSpec} Appendix B. Therefore, for
   example, <CODE>XC_arrow</CODE> returns a cursor that behaves like the X arrow 
   cursor on X screentypes, and like the default cursor on screentypes 
   that have no cursor named <CODE>XC_arrow</CODE>. 

<P>
<P><PRE>PROCEDURE <A HREF="FVRuntime.m3#MakeActive">MakeActive</A>  (fv: T; name: TEXT; cursor:= &quot;&quot;) RAISES {Error};
PROCEDURE <A HREF="FVRuntime.m3#MakePassive">MakePassive</A> (fv: T; name: TEXT; cursor:= &quot;&quot;) RAISES {Error};
PROCEDURE <A HREF="FVRuntime.m3#MakeDormant">MakeDormant</A> (fv: T; name: TEXT; cursor:= &quot;&quot;) RAISES {Error};
PROCEDURE <A HREF="FVRuntime.m3#MakeVanish">MakeVanish</A>  (fv: T; name: TEXT; cursor:= &quot;&quot;) RAISES {Error};
</PRE><BLOCKQUOTE><EM> Find the nearest ancestor of the named component that is of
   type <CODE>FVFilter</CODE>, and set its state and cursor as indicated. 
   The exception is raised if no such ancestor can be found. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="FVRuntime.m3#IsActive">IsActive</A>   (fv: T; name: TEXT): BOOLEAN RAISES {Error};
PROCEDURE <A HREF="FVRuntime.m3#IsPassive">IsPassive</A>  (fv: T; name: TEXT): BOOLEAN RAISES {Error};
PROCEDURE <A HREF="FVRuntime.m3#IsDormant">IsDormant</A>  (fv: T; name: TEXT): BOOLEAN RAISES {Error};
PROCEDURE <A HREF="FVRuntime.m3#IsVanished">IsVanished</A> (fv: T; name: TEXT): BOOLEAN RAISES {Error};
</PRE><BLOCKQUOTE><EM> Find the nearest ancestor of the named component that is of
   type <CODE>FVFilter</CODE>, and test its state as indicated.  The
   exception is raised if no such ancestor can be found. </EM></BLOCKQUOTE><PRE>
</PRE> \subsection{Access to Subwindows} 

<P><PRE>PROCEDURE <A HREF="FVRuntime.m3#PopUp">PopUp</A> (fv        : T;
                 name      : TEXT;
                 forcePlace: BOOLEAN         := FALSE;
                 time      : VBT.TimeStamp := 0   )
  RAISES {Error};
</PRE><BLOCKQUOTE><EM> Pop up the named subwindow. </EM></BLOCKQUOTE><PRE>
</PRE> Assuming that <CODE>name</CODE> is the name of an element of <CODE>fv</CODE> that
   can be popped up, pop it up.  That is, the named element must
   be a non-background child of a <CODE>ZSplit</CODE>, or some descendant
   thereof.  In the latter case, the ancestor that is a direct
   child of the <CODE>ZSplit</CODE> will be the thing popped up.  Call this
   ancestor {\it zchild}.  <CODE>PopUp</CODE> is equivalent to activating
<P>
<PRE>
      (PopButton (For <KBD>{\it zchild}</KBD>) ...)
</PRE>
   If the target {\it zchild} is already open or has been opened
   before and has been moved by the user (to a location that is
   now visible), it will normally be left where the user left it.
   The <CODE>forcePlace</CODE> option will force it instead to be returned
   to its canonical place.
<P>
   If the subwindow contains a text-editing component that has the
   <CODE>FirstFocus</CODE> property, then that component will acquire the keyboard
   focus, and if it's a <CODE>TypeinVBT.T</CODE>, its text will be selected in
   replace-mode. 

<P><PRE>PROCEDURE <A HREF="FVRuntime.m3#PopDown">PopDown</A> (fv: T; name: TEXT) RAISES {Error};
</PRE><BLOCKQUOTE><EM> The inverse of <CODE>PopUp</CODE>: make the named element (or suitable
   ancestor) invisible.  This is implemented using <CODE>ZSplit</CODE>'s
   unmapping.  (Unfortunately, this doesn't cause the keyboard
   focus to be lost.)  The exception is raised if <CODE>name</CODE> is not
   the name of an element of <CODE>fv</CODE>. </EM></BLOCKQUOTE><PRE>
</PRE> \subsection{Special controls for text-interactors}  

<P><PRE>PROCEDURE <A HREF="FVRuntime.m3#TakeFocus">TakeFocus</A> (fv       : T;
                     name     : TEXT;
                     eventTime: VBT.TimeStamp;
                     select                     := FALSE)
  RAISES {Error};
</PRE><BLOCKQUOTE><EM> Give the keyboard focus to a specified interactor.  An exception is raised
   if the interactor is not of a suitable class to take it; however, no
   exception is raised if the keyboard focus cannot be taken because of a
   timeout, i.e., an invalid <CODE>eventTime</CODE>.  If <CODE>select</CODE> is <CODE>TRUE</CODE> and the focus
   was taken, then select the entire contents of the interactor's <CODE>TextPort</CODE>
   as a primary selection in replace-mode. </EM></BLOCKQUOTE><PRE>
</PRE> \section{Saving and restoring state} \label{sec:programming-snapshot} 

<P> FormsVBT allows clients
   to save and restore the entire state of a
   form. 
<P>
   A {\em snapshot\/} is an S-expression that captures the state of components
   in a form.  The call <CODE>fv.snapshot(wr)</CODE> writes a snapshot of <CODE>fv</CODE> to the
   writer <CODE>wr</CODE>, and the call <CODE>fv.restore(rd)</CODE> reads a snapshot from the reader
   <CODE>rd</CODE> and restores the components of <CODE>fv</CODE> to the state in
   the snapshot.
<P>
   A snapshot produced by the default method contains only those named
   components that have a modifiable value.  More precisely, a
   component is part of a snapshot if (1) it has a name and (2) the
   call to <CODE>GetText</CODE>, <CODE>GetInteger</CODE>, <CODE>GetReal</CODE>, <CODE>GetBoolean</CODE>, or
   <CODE>GetChoice</CODE> does not raise an exception. If you want to include
   a component into the snapshot that has state but does not respond
   to <CODE>GetText</CODE>, <CODE>GetInteger</CODE>, etc., then you need to override
   the defaults methods.
<P>
   The <CODE>snapshot</CODE> method raises the <CODE>Error</CODE> exception if there is a problem
   writing the snapshot to the writer.
<P>
   The <CODE>restore</CODE> method raises the <CODE>Error</CODE> exception if there is a syntax
   error in the S-expression or if there is any type of problem with the
   reader.
<P>
   When restoring, the snapshot need not precisely match the set of
   interactors in the form.  If the snapshot lacks values for some
   fields that the form contains, those fields will be left alone.  If
   the snapshot has values for some fields that the form does not
   contain, the <CODE>restore</CODE> method should raise <CODE>Mismatch</CODE>, but only
   after restoring all the values that do match.  If the snapshot has
   a value for a field that the form contains, but the types do not
   agree, this is a show-stopping error; the <CODE>restore</CODE> method should
   raise <CODE>Error</CODE>.  Catching <CODE>Mismatch</CODE> is useful when you want to
   continue to tolerate snapshots from old versions of a form.
<P>
   The default <CODE>snapshot</CODE> and <CODE>restore</CODE> methods write S-expressions in the
   following format:
<P>
<PRE>
         ((name1 value1)
          (name2 value2) ...)
</PRE>
  

<P> \section{Dynamic Alteration of Forms} \label{sec:programming-dynamicforms}
<P>
   In some applications, it may be desirable to change a form while the
   program is running.  For example, one might want to add or change items in
   a menu.  FormsVBT provides facilities to:
<P>
   \begin{itemize}
<P>
   \item add a new component, as a child of a named Split.
<P>
   \item delete a named component, provided that it is a direct child of a
   Split.
<P>
   \item read a FormsVBT S-expression from a text.
<P>
   \item print a FormsVBT S-expression as text.
<P>
   \end{itemize}
<P>
   \subsection{Modifying forms in place}
<P>
   <CODE>Insert</CODE> and <CODE>Delete</CODE> support dynamic modification of forms.  Any
   resizing that may be appropriate after an <CODE>Insert</CODE> or <CODE>Delete</CODE> is
   performed automatically.  For the common case of modifying menus,
   this is not an issue because the menu is (almost certainly) not
   visible at the time the alteration takes place. 

<P><PRE>PROCEDURE <A HREF="FVRuntime.m3#Insert">Insert</A> (fv         : T;
                  parent     : TEXT;
                  description: TEXT;
                  n          : CARDINAL := LAST (CARDINAL)): VBT.T
  RAISES {Error};
&lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> <CODE>Insert</CODE> parses a description in the context of an existing form, that is,
   in <CODE>fv</CODE>'s namespace, so that names already defined in <CODE>fv</CODE> are visible
   while the description is being parsed, and with the state (color,
   resource-path, etc.) that was in effect for <CODE>parent</CODE>.
<P>
   Once the new <CODE>VBT</CODE> is created, it is inserted into the named component,
   which must be a Split, as the <CODE>n</CODE>th child.  It is also returned. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="FVRuntime.m3#InsertFromFile">InsertFromFile</A> (fv      : T;
                          parent  : TEXT;
                          filename: TEXT;
                          n       : CARDINAL := LAST (CARDINAL)):
  VBT.T RAISES {Error, Rd.Failure, Thread.Alerted};
  &lt;* LL.sup = VBT.mu *&gt;
PROCEDURE <A HREF="FVRuntime.m3#InsertFromRsrc">InsertFromRsrc</A> (fv    : T;
                          parent: TEXT;
                          name  : TEXT;
                          path  : Rsrc.Path;
                          n     : CARDINAL    := LAST (CARDINAL)):
  VBT.T RAISES {Error, Rd.Failure, Rsrc.NotFound, Thread.Alerted};
&lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> <CODE>InsertFromFile</CODE> and <CODE>InsertFromRsrc</CODE> read a description from a file or
   named resource, and then call <CODE>Insert</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="FVRuntime.m3#InsertVBT">InsertVBT</A> (fv    : T;
                     name  : TEXT;
                     child : VBT.T;
                     n     : CARDINAL := LAST (CARDINAL))
  RAISES {Error};
  &lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Insert <CODE>child</CODE> as the <CODE>n</CODE>th child of the named component,
   which must be a Split. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="FVRuntime.m3#Delete">Delete</A> (fv    : T;
                  parent: TEXT;
                  n     : CARDINAL;
                  count : CARDINAL   := 1) RAISES {Error};
  &lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Delete the children whose indices are in the range
   <CODE>[n .. (n + count - 1)]</CODE> from the named component, which must be a
   Split. The names of the <CODE>n</CODE> components, as well as the names
   of all of the desendants of those components, are removed from
   <CODE>fv</CODE>'s namespace. </EM></BLOCKQUOTE><PRE>

END FormsVBT.
</PRE> \section{Subclasses of components} \label{realize}
<P>
   As the subexpressions describing the form <CODE>fv</CODE> are being parsed, the
   <CODE>VBT</CODE>-components are created (allocated) by calling
<PRE>
      fv.realize(<KBD>{\it type}</KBD>, <KBD>{\it name}</KBD>)
   </PRE>
where {\it type} is the name of the first element of the subexpression,
   and {\it name} is the <CODE>Name</CODE> property specified in the
   subexpression, or the empty string if no such property was
   specified.  For example, if the description contains the
   expression
<PRE>
      (Menu %mainMenu ...)
   </PRE>
then the FormsVBT parser will call
<PRE>
      fv.realize(&quot;Menu&quot;, &quot;mainMenu&quot;)
   </PRE>
to create the <CODE>VBT</CODE>.
<P>
   By overriding the <CODE>realize</CODE> method of <CODE>fv</CODE>, the client can
   create subtypes for any or all of the components.  For each
   kind of form, there is a corresponding type in the <CODE>FVTypes</CODE>
   interface.  For example, the result of parsing <CODE>(Menu ...)</CODE> is
   an object that is a subtype of <CODE>FVTypes.FVMenu</CODE>.  The
   <CODE>realize</CODE> method must allocate and return a <CODE>VBT</CODE> that is a
   subtype of the corresponding type in <CODE>FVTypes</CODE>.
<P>
   Example: suppose you wanted the form to keep a count of the
   number of menus it contains, and for each menu to store its own
   index.
<P>
<PRE>
      TYPE
        MyForm = FormsVBT.T OBJECT
                   count: CARDINAL := 0
                 OVERRIDES
                   realize := Realize
                 END;
        MyMenu = FVTypes.FVMenu OBJECT
                     index: CARDINAL
                 END;
      
      PROCEDURE Realize (fv: MyForm; type, name: TEXT):
        VBT.T RAISES {FormsVBT.Error} =
        BEGIN
          IF Text.Equal (type, &quot;Menu&quot;) THEN
            WITH m = NEW (MyMenu, index := fv.count) DO
              INC (fv.count);
              RETURN m
            END
          ELSE                     (* use the default 

<PRE>|       RETURN FormsVBT.T.realize (fv, type, name)
|     END
|   END Realize;

   Note that the &quot;realize&quot; method does not {\it initialize} the
   &quot;VBT&quot; that it allocates.  Actually, it may initialize any {\it
   private} fields, such as the &quot;index&quot; field in this example,
   but the &quot;VBT&quot;'s &quot;init&quot; method should not be called inside the
   call to &quot;fv.realize&quot;, since it will be called later during
   a ``bottom-up'' initialization phase.  Of course, the
   client may also override the &quot;init&quot; method to control what
   happens in that phase.

   A more complicated case arises with text-editing components.
   Textports are {\em contained} in three forms: &quot;TextEdit&quot;,
   &quot;Typescript&quot;, and &quot;Numeric&quot;.  In a &quot;TextEdit&quot; components, the
   textport is in an exported field, &quot;TextEditVBT.T.tp&quot;. If the
   &quot;realize&quot; method allocates a &quot;TextPort.T&quot;, even a private subtype
   of &quot;TextPort.T&quot;, it should not call the textport's &quot;init&quot; method,
   since FormsVBT will do that in the initialization phase, passing
   some of the current state information (such as background color and
   the width of the ``turn margin'') to the textport's &quot;init&quot; method.
   The same applies to &quot;Typescript&quot; components, since
   &quot;TypescriptVBT.T&quot; is a subtype of &quot;TextEditVBT.T&quot;.  Similarly, the
   textport in a &quot;Numeric&quot; component is in an exported field,
   &quot;NumericVBT.T.typein&quot;; again, it may be allocated but not
   initialized in the &quot;realize&quot; method.

   If you wish to redefine the interpretation of keystrokes, you do so
   by overriding the &quot;filter&quot; method of the textports.  The following
   code illustrates how to do this.

| TYPE
|   MyForm = FormsVBT.T OBJECT
|               OVERRIDES realize := Realize END;
|
| PROCEDURE Realize (fv: MyForm; type, name: TEXT): VBT.T
|   RAISES {FormsVBT.Error} =
|   BEGIN
|     IF Text.Equal (type, &quot;TextEdit&quot;) THEN
|       RETURN
|         NEW (FVTypes.FVTextEdit,
|              tp := NEW (TextPort.T, filter := MyFilter))
|     ELSIF Text.Equal (type, &quot;Numeric&quot;) THEN
|       RETURN NEW (FVTypes.FVNumeric,
|                   typein := NEW (NumericVBT.Typein,
|                                  filter := MyFilter))
|     ELSIF Text.Equal (type, &quot;Typescript&quot;) THEN
|       RETURN NEW (FVTypes.FVTypescript,
|                   tp := NEW (TypescriptVBT.Port,
|                              filter := MyFilter))
|     ELSIF Text.Equal (type, &quot;TypeIn&quot;) THEN
|       RETURN NEW (FVTypes.FVTypein, filter := MyFilter)
|     ELSE                         (* use the default *)
|       RETURN FormsVBT.T.realize (fv, type, name)
|     END
|   END Realize;

*)
</PRE>
</inInterface>
<HR>
<A NAME="x1">FormsVBT's implementation  is in:
</A><UL>
<LI><A HREF="FVRuntime.m3#0TOP0">formsvbt/src/FVRuntime.m3</A>
<LI><A HREF="FormsVBT.m3#0TOP0">formsvbt/src/FormsVBT.m3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
