<HTML>
<HEAD>
<TITLE>SRC Modula-3: formsvbt/src/FormsVBT.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>formsvbt/src/FormsVBT.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                            </EM></BLOCKQUOTE><PRE>
&lt;* PRAGMA LL *&gt;

MODULE <module>FormsVBT</module> EXPORTS <A HREF="FVRuntime.i3"><implements>FVRuntime</A></implements>, <A HREF="FormsVBT.i3"><implements>FormsVBT</A></implements>, <A HREF="FVTypes.i3"><implements>FVTypes</A></implements>;
</PRE> This module contains the code to construct (parse) FV-expressions. 

<P><PRE>IMPORT <A HREF="FVRuntime.i3">FVRuntime</A>;

IMPORT <A HREF="../../atom/src/Atom.i3">Atom</A>, <A HREF="../../libm3/derived/AtomIntTbl.i3">AtomIntTbl</A>, <A HREF="../../geometry/src/Axis.i3">Axis</A>, <A HREF="../../lego/src/BiFeedbackVBT.i3">BiFeedbackVBT</A>, <A HREF="../../lego/src/BooleanVBT.i3">BooleanVBT</A>,
       <A HREF="../../ui/src/split/ButtonVBT.i3">ButtonVBT</A>, <A HREF="../../lego/src/ChoiceVBT.i3">ChoiceVBT</A>, <A HREF="../../color/src/Color.i3">Color</A>, <A HREF="../../color/src/ColorName.i3">ColorName</A>, <A HREF="../../ui/src/vbt/Cursor.i3">Cursor</A>,
       <A HREF="../../lego/src/FeedbackVBT.i3">FeedbackVBT</A>, <A HREF="../../lego/src/FileBrowserVBT.i3">FileBrowserVBT</A>, <A HREF="../../ui/src/split/Filter.i3">Filter</A>, <A HREF="../../lego/src/FlexVBT.i3">FlexVBT</A>, <A HREF="../../fmtlex/src/Fmt.i3">Fmt</A>,
       <A HREF="../../ui/src/split/HVSplit.i3">HVSplit</A>, <A HREF="../../lego/src/Image.i3">Image</A>, <A HREF="../../jvideo/src/Jva.i3">Jva</A>, <A HREF="../../jvideo/src/JVSink.i3">JVSink</A>, <A HREF="../../lego/src/ListVBT.i3">ListVBT</A>, <A HREF="Macro.i3">Macro</A>,
       <A HREF="../../lego/src/MarginFeedbackVBT.i3">MarginFeedbackVBT</A>, <A HREF="../../lego/src/MenuSwitchVBT.i3">MenuSwitchVBT</A>, <A HREF="../../lego/src/MultiSplit.i3">MultiSplit</A>, <A HREF="../../lego/src/MultiFilter.i3">MultiFilter</A>,
       <A HREF="../../lego/src/NumericVBT.i3">NumericVBT</A>, <A HREF="../../os/src/Common/OSError.i3">OSError</A>, <A HREF="../../ui/src/vbt/PaintOp.i3">PaintOp</A>, <A HREF="../../ui/src/vbt/Pixmap.i3">Pixmap</A>, <A HREF="../../vbtkitutils/src/Pts.i3">Pts</A>, <A HREF="../../rw/src/Common/Rd.i3">Rd</A>, <A HREF="../../rw/src/Common/RdUtils.i3">RdUtils</A>,
       <A HREF="../../lego/src/ReactivityVBT.i3">ReactivityVBT</A>, <A HREF="../../libm3/derived/RefList.i3">RefList</A>, <A HREF="../../vbtkitutils/src/Rsrc.i3">Rsrc</A>, <A HREF="../../lego/src/ScaleFilter.i3">ScaleFilter</A>, <A HREF="../../lego/src/ScrollerVBT.i3">ScrollerVBT</A>,
       <A HREF="../../lego/src/Shadow.i3">Shadow</A>, <A HREF="../../lego/src/ShadowedFeedbackVBT.i3">ShadowedFeedbackVBT</A>, <A HREF="../../lego/src/ShadowedVBT.i3">ShadowedVBT</A>, <A HREF="../../lego/src/SourceVBT.i3">SourceVBT</A>,
       <A HREF="../../ui/src/split/Split.i3">Split</A>, <A HREF="../../lego/src/SplitterVBT.i3">SplitterVBT</A>, <A HREF="../../lego/src/SwitchVBT.i3">SwitchVBT</A>, <A HREF="../../sx/src/Sx.i3">Sx</A>, <A HREF="../../text/src/Text.i3">Text</A>, <A HREF="../../etext/src/TextEditVBT.i3">TextEditVBT</A>,
       <A HREF="../../etext/src/TextPort.i3">TextPort</A>, <A HREF="../../etext/src/TextPortClass.i3">TextPortClass</A>, <A HREF="../../ui/src/split/TextureVBT.i3">TextureVBT</A>, <A HREF="../../ui/src/split/TextVBT.i3">TextVBT</A>, <A HREF="../../rw/src/Common/TextWr.i3">TextWr</A>,
       <A HREF="../../thread/src/Common/Thread.i3">Thread</A>, <A HREF="../../ui/src/split/TSplit.i3">TSplit</A>, <A HREF="../../etext/src/TypescriptVBT.i3">TypescriptVBT</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>, <A HREF="../../lego/src/ViewportVBT.i3">ViewportVBT</A>, <A HREF="../../rw/src/Common/Wr.i3">Wr</A>,
       <A HREF="../../lego/src/ZChildVBT.i3">ZChildVBT</A>, <A HREF="../../ui/src/split/ZSplit.i3">ZSplit</A>;
</PRE>IMPORT StubImageRd AS ImageRd;

<P><PRE>FROM <A HREF="RefListUtils.i3">RefListUtils</A> IMPORT Pop, Push, AssocQ;

&lt;* FATAL Thread.Alerted *&gt;

TYPE
  ParseClosure = Thread.SizedClosure OBJECT
                   description: Sx.T;
                   fv         : T;
                   fixupList  : FixupLink := NIL;
                   state      : State
                 OVERRIDES
                   apply := Apply
                 END;
  FixupLink = REF RECORD
                    targetName: TEXT;
                    sourceVBT : VBT.T;
                    next      : FixupLink
                  END;

VAR                              (* CONST *)
  qBar    := Atom.FromText (&quot;Bar&quot;);
  qChisel := Atom.FromText (&quot;Chisel&quot;);
  qFill   := Atom.FromText (&quot;Fill&quot;);
  qGlue   := Atom.FromText (&quot;Glue&quot;);
  qInsert := Atom.FromText (&quot;Insert&quot;);
  qMain   := Atom.FromText (&quot;Main&quot;);
  qMinus  := Atom.FromText (&quot;-&quot;);
  qPlus   := Atom.FromText (&quot;+&quot;);
  qReset  := Atom.FromText (&quot;Reset&quot;);
  qRidge  := Atom.FromText (&quot;Ridge&quot;);

PROCEDURE <A NAME="Parse"><procedure>Parse</procedure></A> (t: T; description: Sx.T; READONLY state: State): VBT.T
  RAISES {Error} =
  BEGIN
    TYPECASE
        Thread.Join (Thread.Fork (NEW (ParseClosure, stackSize := 10000,
                                       description := description, fv := t,
                                       state := state))) OF
    | TEXT (msg) =&gt; RAISE Error (msg)
    | VBT.T (ch) =&gt; RETURN ch
    ELSE &lt;* ASSERT FALSE *&gt;
    END
  END Parse;

PROCEDURE <A NAME="Apply"><procedure>Apply</procedure></A> (cl: ParseClosure): REFANY =
  &lt;* LL = 0 *&gt;
  VAR ch: VBT.T;
  BEGIN
    TRY
      ch := Item (cl, cl.description, cl.state);
      Pass2 (cl);
      RETURN ch
    EXCEPT
    | Error (msg) =&gt; RETURN msg
    END
  END Apply;

EXCEPTION Narrow;
</PRE><BLOCKQUOTE><EM> NARROW-faults are checked runtime errors, but implementations
   are not required to map them into exceptions, so you can't
   catch them with TRY EXCEPT ELSE. That would have been handy
   in the following procedure.  (So would multi-methods!) </EM></BLOCKQUOTE><PRE>

PROCEDURE <A NAME="Pass2"><procedure>Pass2</procedure></A> (cl: ParseClosure) RAISES {Error} =
  (* Find targets of (For xxx) and (TabTo xxx) forms. *)
  BEGIN
    WHILE cl.fixupList # NIL DO
      TRY
        WITH target = GetVBT (cl.fv, cl.fixupList.targetName),
             source = cl.fixupList.sourceVBT                   DO
          TYPECASE source OF
          | FVHelper (fbh) =&gt;
              TYPECASE target OF
              | FVFileBrowser (x) =&gt; FileBrowserVBT.SetHelper (x, fbh)
              | TextPort.T (target) =&gt; fbh.tabNext := target
              | NumericVBT.T (target) =&gt; fbh.tabNext := target.typein
              | TextEditVBT.T (target) =&gt; fbh.tabNext := target.tp
              ELSE
                RAISE Narrow
              END
          | FVDirMenu (dm) =&gt;
              TYPECASE target OF
              | FVFileBrowser (x) =&gt; FileBrowserVBT.SetDirMenu (x, dm)
              ELSE
                RAISE Narrow
              END
          | FVPageButton, FVPageMButton =&gt;
              TYPECASE target OF
              | FVTSplit (x) =&gt; FVRuntime.SetPageTarget (source, x)
              ELSE
                RAISE Narrow
              END
          | FVLinkButton, FVLinkMButton =&gt;
              FVRuntime.SetLinkTarget (
                source, FindTChild (target, cl.fixupList.targetName))
          | FVCloseButton (cb) =&gt;
              TYPECASE target OF
              | ZChildVBT.T (x) =&gt; cb.target := x
              ELSE
                RAISE Narrow
              END
          | FVPopButton, FVPopMButton =&gt;
              TYPECASE target OF
              | ZChildVBT.T (x) =&gt; FVRuntime.SetPopTarget (source, x)
              ELSE
                RAISE Narrow
              END
          | FVTypeIn (source) =&gt;
              TYPECASE target OF
              | TextPort.T (target) =&gt; source.tabNext := target
              | NumericVBT.T (target) =&gt; source.tabNext := target.typein
              | TextEditVBT.T (target) =&gt; source.tabNext := target.tp
              ELSE
                RAISE Narrow
              END
          | FVNumeric (source) =&gt;
              TYPECASE target OF
              | TextPort.T (target) =&gt; source.typein.tabNext := target
              | NumericVBT.T (target) =&gt;
                  source.typein.tabNext := target.typein
              | TextEditVBT.T (target) =&gt; source.typein.tabNext := target.tp
              ELSE
                RAISE Narrow
              END
          ELSE
            Gripe (&quot;Internal error [Pass2]: &quot;, source)
          END                    (* TYPECASE source *)
        END                      (* WITH *)
      EXCEPT
      | FileBrowserVBT.Error (e) =&gt;
          Gripe (Fmt.F (&quot;Error in FileBrowser %s: %s %s&quot;,
                        cl.fixupList.targetName, e.path, e.text))
      | Error (msg) =&gt; RAISE Error (msg)
      ELSE                       (* NARROW fault, NIL, etc. *)
        Gripe (Fmt.F (&quot;The form named %s is of the wrong type&quot;,
                      cl.fixupList.targetName))
      END;
      cl.fixupList := cl.fixupList.next
    END                          (* WHILE *)
  END Pass2;

PROCEDURE <A NAME="FindTChild"><procedure>FindTChild</procedure></A> (vbt: VBT.T; vbtName: TEXT): VBT.T RAISES {Error} =
  BEGIN
    (* &quot;The named component must be either a TSplit child, or a descendant of
       something that is.  In the latter case the TSplit child is the true
       target.&quot; *)
    LOOP
      TYPECASE VBT.Parent (vbt) OF
      | NULL =&gt; RAISE Error (vbtName &amp; &quot; is not in a TSplit&quot;)
      | FVTSplit =&gt; RETURN vbt
      | VBT.Split (parent) =&gt; vbt := parent
      END
    END
  END FindTChild;
</PRE>************************** Parser ******************************

<P><PRE>TYPE
  ComponentProc =
    PROCEDURE (cl: ParseClosure; VAR list: RefList.T; READONLY s: State): VBT.T
      RAISES {Error};
  RealizeProc = PROCEDURE (): VBT.T RAISES {Error};
  StateProc = PROCEDURE (list: RefList.T; VAR state: State) RAISES {Error};
  MetricsProc =
    PROCEDURE (sym: Atom.T; arglist: RefList.T; VAR metrics: RefList.T)
      RAISES {Error};
</PRE> The <CODE>state</CODE> data structure, about 132 bytes, could be made
   much more efficient. Currently, a copy of the data structure is
   made each time that a component is encountered. (Further, a copy from
   the heap is made on each component that has a name, so that the 
   inheritable props can be changed at runtime.) 
<P>
   For instance, a copy of the entire data structure isn't needed, 
   just those variables that have actually changed. Other (more) 
   efficient schemes are possible. --mhb 1/24/94 

<P>
<P><PRE>PROCEDURE <A NAME="Item"><procedure>Item</procedure></A> (cl: ParseClosure; exp: Sx.T; READONLY state: State):
  VBT.T RAISES {Error} =
  (*
    This routine interprets an S-expression as a component (VBT).
     - NIL is illegal.
     - The symbol Fill is parsed as (Fill).
     - The symbol Bar is parsed as (Bar 2).
     - The symbol Chisel is parsed as (Chisel 2).
     - The symbol Ridge is parsed as (Ridge 2).
     - The symbol Glue is parsed as (Glue 2).
     - A text &quot;abc&quot; is parsed as (Text &quot;abc&quot;).
     - Lists whose first element names a component are parsed by
       specific routines, stored in &quot;componentProcTable&quot;.
    Nothing else is legal. *)
  VAR
    list: RefList.T;
    res : VBT.T;
  BEGIN
    Push (cl.fv.formstack, exp); (* For debugging *)
    TYPECASE exp OF
    | NULL =&gt;
    | Atom.T (s) =&gt;
        res := ParseSymbolComponent (cl, s, state);
        cl.fv.formstack := cl.fv.formstack.tail;
        RETURN res
    | TEXT (text) =&gt;
        list := RefList.List1 (text);
        res := pText (cl, list, state);
        cl.fv.formstack := cl.fv.formstack.tail;
        RETURN res
    | RefList.T (list) =&gt;
        TYPECASE list.head OF
        | NULL =&gt;
        | Atom.T (sym) =&gt;
            list := list.tail;
            WITH p = FindComponentProc (sym) DO
              IF p # NIL THEN
                res := p (cl, list, state)
              ELSE
                WITH m = MacroFunction (sym, state) DO
                  IF m # NIL THEN
                    res := Item (cl, m.apply (list), state)
                  ELSIF sym = qInsert THEN
                    res :=
                      OneChild (
                        cl, InsertFile (OneText (list), cl.fv.path), state)
                  ELSE
                    Gripe (&quot;Unknown component: &quot;, sym)
                  END
                END
              END
            END;
            cl.fv.formstack := cl.fv.formstack.tail;
            RETURN res
        ELSE
        END
    ELSE
    END;
    Gripe (&quot;Syntax error: &quot;, exp); &lt;* ASSERT FALSE *&gt;
  END Item;

PROCEDURE <A NAME="MacroFunction"><procedure>MacroFunction</procedure></A> (sym: Atom.T; READONLY state: State): Macro.T =
  BEGIN
    WITH pair = AssocQ (state.macros, sym) DO
      IF pair # NIL THEN RETURN pair.tail.head ELSE RETURN NIL END
    END
  END MacroFunction;

PROCEDURE <A NAME="ParseSymbolComponent"><procedure>ParseSymbolComponent</procedure></A> (cl: ParseClosure; sym: Atom.T; READONLY state: State):
  VBT.T RAISES {Error} =
  BEGIN
    IF sym = qBar OR sym = qGlue OR sym = qRidge OR sym = qChisel
         OR sym = qFill THEN
      RETURN Item (cl, RefList.List1 (sym), state)
    ELSE
      Gripe (&quot;Unknown Symbol-component: &quot;, sym); &lt;* ASSERT FALSE *&gt;
    END
  END ParseSymbolComponent;

PROCEDURE <A NAME="Gripe"><procedure>Gripe</procedure></A> (msg: TEXT; form: REFANY := NIL) RAISES {Error} =
  BEGIN
    IF form # NIL THEN msg := msg &amp; ToText (form) END;
    RAISE Error (msg)
  END Gripe;
</PRE> ====================================================================== 
 Parsing routines for components 
 ====================================================================== 

<P><PRE>VAR Unnamed := Atom.FromText (&quot;&quot;);

PROCEDURE <A NAME="NamePP"><procedure>NamePP</procedure></A> (): SymbolPP =
  BEGIN
    RETURN NEW (SymbolPP, val := Unnamed, valname := &quot;&quot;, name := &quot;Name&quot;)
  END NamePP;

PROCEDURE <A NAME="Named"><procedure>Named</procedure></A> (n: SymbolPP): BOOLEAN =
  BEGIN
    RETURN n.val # Unnamed
  END Named;
</PRE> ======================= Realizing VBTs ========================== 

<P><PRE>REVEAL
  T &lt;: Private;
  <A NAME="Private">Private</A> = SemiPublic BRANDED OBJECT OVERRIDES realize := Realize END;

PROCEDURE <A NAME="Realize"><procedure>Realize</procedure></A> (&lt;* UNUSED *&gt; fv  : Private;
                                type: TEXT;
                   &lt;* UNUSED *&gt; name: TEXT     ): VBT.T RAISES {Error} =
  BEGIN
    RETURN FindRealizeProc (Atom.FromText (type)) ()
  END Realize;

PROCEDURE <A NAME="rAudio"><procedure>rAudio</procedure></A> (): VBT.T =
  BEGIN
    RETURN NEW(FVAudio)
  END rAudio;

PROCEDURE <A NAME="rBar"><procedure>rBar</procedure></A> (): VBT.T =
  BEGIN
    RETURN NEW (FVBar)
  END rBar;

PROCEDURE <A NAME="rBoolean"><procedure>rBoolean</procedure></A> (): VBT.T =
  BEGIN
    RETURN NEW (FVBoolean)
  END rBoolean;

PROCEDURE <A NAME="rBorder"><procedure>rBorder</procedure></A> (): VBT.T =
  BEGIN
    RETURN NEW (FVBorder)
  END rBorder;

PROCEDURE <A NAME="rBrowser"><procedure>rBrowser</procedure></A> (): VBT.T =
  BEGIN
    RETURN NEW (FVBrowser)
  END rBrowser;

PROCEDURE <A NAME="rButton"><procedure>rButton</procedure></A> (): VBT.T =
  BEGIN
    RETURN NEW (FVButton)
  END rButton;

PROCEDURE <A NAME="rChisel"><procedure>rChisel</procedure></A> (): VBT.T =
  BEGIN
    RETURN NEW (FVChisel)
  END rChisel;

PROCEDURE <A NAME="rChoice"><procedure>rChoice</procedure></A> (): VBT.T =
  BEGIN
    RETURN NEW (FVChoice)
  END rChoice;

PROCEDURE <A NAME="rCloseButton"><procedure>rCloseButton</procedure></A> (): VBT.T =
  BEGIN
    RETURN NEW (FVCloseButton)
  END rCloseButton;

PROCEDURE <A NAME="rDirMenu"><procedure>rDirMenu</procedure></A> (): VBT.T =
  BEGIN
    RETURN NEW (FVDirMenu)
  END rDirMenu;

PROCEDURE <A NAME="rFileBrowser"><procedure>rFileBrowser</procedure></A> (): VBT.T =
  BEGIN
    RETURN NEW (FVFileBrowser)
  END rFileBrowser;

PROCEDURE <A NAME="rFill"><procedure>rFill</procedure></A> (): VBT.T =
  BEGIN
    RETURN NEW (FVFill)
  END rFill;

PROCEDURE <A NAME="rFilter"><procedure>rFilter</procedure></A> (): VBT.T =
  BEGIN
    RETURN NEW (FVFilter)
  END rFilter;

PROCEDURE <A NAME="rFrame"><procedure>rFrame</procedure></A> (): VBT.T =
  BEGIN
    RETURN NEW (FVFrame)
  END rFrame;

PROCEDURE <A NAME="rGeneric"><procedure>rGeneric</procedure></A> (): VBT.T =
  BEGIN
    RETURN NEW (FVGeneric)
  END rGeneric;

PROCEDURE <A NAME="rGlue"><procedure>rGlue</procedure></A> (): VBT.T =
  BEGIN
    RETURN NEW (FVGlue)
  END rGlue;

PROCEDURE <A NAME="rGuard"><procedure>rGuard</procedure></A> (): VBT.T =
  BEGIN
    RETURN NEW (FVGuard)
  END rGuard;

PROCEDURE <A NAME="rHBox"><procedure>rHBox</procedure></A> (): VBT.T =
  BEGIN
    RETURN NEW (FVHBox)
  END rHBox;

PROCEDURE <A NAME="rHPackSplit"><procedure>rHPackSplit</procedure></A> (): VBT.T =
  BEGIN
    RETURN NEW (FVHPackSplit)
  END rHPackSplit;

PROCEDURE <A NAME="rHTile"><procedure>rHTile</procedure></A> (): VBT.T =
  BEGIN
    RETURN NEW (FVHTile)
  END rHTile;

PROCEDURE <A NAME="rHelper"><procedure>rHelper</procedure></A> (): VBT.T =
  BEGIN
    RETURN NEW (FVHelper)
  END rHelper;

PROCEDURE <A NAME="rImage"><procedure>rImage</procedure></A> (): VBT.T =
  BEGIN
    RETURN NEW (FVImage)
  END rImage;

PROCEDURE <A NAME="rIntApply"><procedure>rIntApply</procedure></A> (): VBT.T =
  BEGIN
    RETURN NEW(FVIntApply)
  END rIntApply;

PROCEDURE <A NAME="rLinkButton"><procedure>rLinkButton</procedure></A> (): VBT.T =
  BEGIN
    RETURN NEW (FVLinkButton)
  END rLinkButton;

PROCEDURE <A NAME="rLinkMButton"><procedure>rLinkMButton</procedure></A> (): VBT.T =
  BEGIN
    RETURN NEW (FVLinkMButton)
  END rLinkMButton;

PROCEDURE <A NAME="rMButton"><procedure>rMButton</procedure></A> (): VBT.T =
  BEGIN
    RETURN NEW (FVMButton)
  END rMButton;

PROCEDURE <A NAME="rMenu"><procedure>rMenu</procedure></A> (): VBT.T =
  BEGIN
    RETURN NEW (FVMenu)
  END rMenu;

PROCEDURE <A NAME="rMultiBrowser"><procedure>rMultiBrowser</procedure></A> (): VBT.T =
  BEGIN
    RETURN NEW (FVMultiBrowser)
  END rMultiBrowser;

PROCEDURE <A NAME="rNumeric"><procedure>rNumeric</procedure></A> (): VBT.T =
  BEGIN
    RETURN NEW (FVNumeric)
  END rNumeric;

PROCEDURE <A NAME="rPageButton"><procedure>rPageButton</procedure></A> (): VBT.T =
  BEGIN
    RETURN NEW (FVPageButton)
  END rPageButton;

PROCEDURE <A NAME="rPageMButton"><procedure>rPageMButton</procedure></A> (): VBT.T =
  BEGIN
    RETURN NEW (FVPageMButton)
  END rPageMButton;

PROCEDURE <A NAME="rPixmap"><procedure>rPixmap</procedure></A> (): VBT.T =
  BEGIN
    RETURN NEW (FVPixmap)
  END rPixmap;

PROCEDURE <A NAME="rPopButton"><procedure>rPopButton</procedure></A> (): VBT.T =
  BEGIN
    RETURN NEW (FVPopButton)
  END rPopButton;

PROCEDURE <A NAME="rPopMButton"><procedure>rPopMButton</procedure></A> (): VBT.T =
  BEGIN
    RETURN NEW (FVPopMButton)
  END rPopMButton;

PROCEDURE <A NAME="rRadio"><procedure>rRadio</procedure></A> (): VBT.T =
  BEGIN
    RETURN NEW (FVRadio)
  END rRadio;

PROCEDURE <A NAME="rRidge"><procedure>rRidge</procedure></A> (): VBT.T =
  BEGIN
    RETURN NEW (FVRidge)
  END rRidge;

PROCEDURE <A NAME="rRim"><procedure>rRim</procedure></A> (): VBT.T =
  BEGIN
    RETURN NEW (FVRim)
  END rRim;

PROCEDURE <A NAME="rScale"><procedure>rScale</procedure></A> (): VBT.T =
  BEGIN
    RETURN NEW (FVScale)
  END rScale;

PROCEDURE <A NAME="rScroller"><procedure>rScroller</procedure></A> (): VBT.T =
  BEGIN
    RETURN NEW (FVScroller)
  END rScroller;

PROCEDURE <A NAME="rShape"><procedure>rShape</procedure></A> (): VBT.T =
  BEGIN
    RETURN NEW (FVShape)
  END rShape;

PROCEDURE <A NAME="rSource"><procedure>rSource</procedure></A> (): VBT.T =
  BEGIN
    RETURN NEW (FVSource)
  END rSource;

PROCEDURE <A NAME="rStable"><procedure>rStable</procedure></A> (): VBT.T =
  BEGIN
    RETURN NEW (FVStable)
  END rStable;

PROCEDURE <A NAME="rTSplit"><procedure>rTSplit</procedure></A> (): VBT.T =
  BEGIN
    RETURN NEW (FVTSplit)
  END rTSplit;

PROCEDURE <A NAME="rTarget"><procedure>rTarget</procedure></A> (): VBT.T =
  BEGIN
    RETURN NEW (FVTarget)
  END rTarget;

PROCEDURE <A NAME="rText"><procedure>rText</procedure></A> (): VBT.T =
  BEGIN
    RETURN NEW (FVText)
  END rText;

PROCEDURE <A NAME="rTextEdit"><procedure>rTextEdit</procedure></A> (): VBT.T =
  BEGIN
    RETURN NEW (FVTextEdit)
  END rTextEdit;

PROCEDURE <A NAME="rTexture"><procedure>rTexture</procedure></A> (): VBT.T =
  BEGIN
    RETURN NEW (FVTexture)
  END rTexture;

PROCEDURE <A NAME="rTrillButton"><procedure>rTrillButton</procedure></A> (): VBT.T =
  BEGIN
    RETURN NEW (FVTrillButton)
  END rTrillButton;

PROCEDURE <A NAME="rTypeIn"><procedure>rTypeIn</procedure></A> (): VBT.T =
  BEGIN
    RETURN NEW (FVTypeIn)
  END rTypeIn;

PROCEDURE <A NAME="rTypescript"><procedure>rTypescript</procedure></A> (): VBT.T =
  BEGIN
    RETURN NEW (FVTypescript)
  END rTypescript;

PROCEDURE <A NAME="rVBox"><procedure>rVBox</procedure></A> (): VBT.T =
  BEGIN
    RETURN NEW (FVVBox)
  END rVBox;

PROCEDURE <A NAME="rVTile"><procedure>rVTile</procedure></A> (): VBT.T =
  BEGIN
    RETURN NEW (FVVTile)
  END rVTile;

PROCEDURE <A NAME="rVideo"><procedure>rVideo</procedure></A> (): VBT.T =
  BEGIN
    RETURN NEW(FVVideo)
  END rVideo;

PROCEDURE <A NAME="rViewport"><procedure>rViewport</procedure></A> (): VBT.T =
  BEGIN
    RETURN NEW (FVViewport)
  END rViewport;

PROCEDURE <A NAME="rVPackSplit"><procedure>rVPackSplit</procedure></A> (): VBT.T =
  BEGIN
    RETURN NEW (FVHPackSplit)
  END rVPackSplit;

PROCEDURE <A NAME="rZBackground"><procedure>rZBackground</procedure></A> (): VBT.T =
  BEGIN
    RETURN NEW (FVZBackground)
  END rZBackground;

PROCEDURE <A NAME="rZChassis"><procedure>rZChassis</procedure></A> (): VBT.T =
  BEGIN
    RETURN NEW (FVZChassis)
  END rZChassis;

PROCEDURE <A NAME="rZChild"><procedure>rZChild</procedure></A> (): VBT.T =
  BEGIN
    RETURN NEW (FVZChild)
  END rZChild;

PROCEDURE <A NAME="rZGrow"><procedure>rZGrow</procedure></A> (): VBT.T =
  BEGIN
    RETURN NEW (FVZGrow)
  END rZGrow;

PROCEDURE <A NAME="rZMove"><procedure>rZMove</procedure></A> (): VBT.T =
  BEGIN
    RETURN NEW (FVZMove)
  END rZMove;

PROCEDURE <A NAME="rZSplit"><procedure>rZSplit</procedure></A> (): VBT.T =
  BEGIN
    RETURN NEW (FVZSplit)
  END rZSplit;
</PRE> ========================= Bar &amp; Glue ============================= 

<P> Bar uses the current Color.  Glue uses the current BgColor. 

<P><PRE>CONST
  FlexOne = FlexVBT.SizeRange{
              1.0 * Pts.MMPerInch / Pts.PtsPerInch, 0.0, 0.0};
</PRE><BLOCKQUOTE><EM><P>
  FlexOnePointFive = FlexVBT.SizeRange{
              1.5 * Pts.MMPerInch / Pts.PtsPerInch, 0.0, 0.0};
</EM></BLOCKQUOTE><PRE>

PROCEDURE <A NAME="pBar"><procedure>pBar</procedure></A> (         cl  : ParseClosure;
                VAR      list: RefList.T;
                READONLY s   : State         ): VBT.T
  RAISES {Error} =
  VAR
    name  := NamePP();
    main  := NEW(SizeRangePP, val := FlexOne, found := TRUE);
    state := s;
    res: FVBar;
  BEGIN
    IF state.hvsplit = NIL THEN
      RAISE Error(&quot;Bar must appear inside an HBox or VBox.&quot;)
    END;
    ParseProps(cl, list, state, PP2{name, main}, main := main);
    res := cl.fv.realize(&quot;Bar&quot;, name.valname);
    res := res.init(TextureVBT.New(state.fgOp),
                    ShapefromSpec(main.val, state));
    AddNameProp(cl, res, name, state);
    RETURN res
  END pBar;

PROCEDURE <A NAME="pGlue"><procedure>pGlue</procedure></A> (         cl  : ParseClosure;
                 VAR      list: RefList.T;
                 READONLY s   : State         ): VBT.T
  RAISES {Error} =
  VAR
    name  := NamePP();
    main  := NEW(SizeRangePP, val := FlexOne, found := TRUE);
    state := s;
    res: FVGlue;
  BEGIN
    IF state.hvsplit = NIL THEN
      RAISE Error(&quot;Glue must appear inside an HBox or VBox.&quot;)
    END;
    ParseProps(cl, list, state, PP2{name, main}, main := main);
    res := cl.fv.realize(&quot;Glue&quot;, name.valname);
    res := res.init(TextureVBT.New(state.bgOp),
                    ShapefromSpec(main.val, state));
    AddNameProp(cl, res, name, state);
    RETURN res
  END pGlue;

PROCEDURE <A NAME="ShapefromSpec"><procedure>ShapefromSpec</procedure></A> (         f    : FlexVBT.SizeRange;
                         READONLY state: State             ): FlexVBT.Shape =
  VAR sh := FlexVBT.Default;
  BEGIN
    sh [state.glueAxis] := f;
    RETURN sh
  END ShapefromSpec;
</PRE> ========================= Border &amp; Rim ============================= 

<P><PRE>PROCEDURE <A NAME="pBorder"><procedure>pBorder</procedure></A> (         cl  : ParseClosure;
                   VAR      list: RefList.T;
                   READONLY s   : State         ): VBT.T
  RAISES {Error} =
  VAR
    state   := s;
    name    := NamePP();
    pen     := NEW(RealPP, name := &quot;Pen&quot;, val := 1.0);
    texture := NEW(TextPP, name := &quot;Pattern&quot;);
    txt     := Pixmap.Solid;
  VAR
    res: FVBorder;
    ch : VBT.T;
  BEGIN
    ParseProps(cl, list, state, PP3{name, pen, texture});
    ch := OneChild(cl, list, state);
    res := cl.fv.realize(&quot;Border&quot;, name.valname);
    IF texture.val # NIL THEN
      txt := GetPixmap(texture.val, cl.fv.path)
    END;
    res :=
      res.init(ch, Pts.ToMM(pen.val), state.shadow.bgFg, txt);
    AddNameProp(cl, res, name, state);
    RETURN res
  END pBorder;

PROCEDURE <A NAME="pRim"><procedure>pRim</procedure></A> (cl: ParseClosure; VAR list: RefList.T; READONLY s: State): VBT.T
  RAISES {Error} =
  VAR
    state   := s;
    name    := NamePP ();
    pen     := NEW (RealPP, name := &quot;Pen&quot;, val := 1.0);
    texture := NEW (TextPP, name := &quot;Pattern&quot;);
    txt     := Pixmap.Solid;
  VAR
    res: FVRim;
    ch : VBT.T;
  BEGIN
    ParseProps (cl, list, state, PP3 {name, pen, texture});
    ch := OneChild (cl, list, state);
    res := cl.fv.realize (&quot;Rim&quot;, name.valname);
    IF texture.val # NIL THEN txt := GetPixmap (texture.val, cl.fv.path) END;
    res := res.init (ch, Pts.ToMM (pen.val), state.shadow.fgBg, txt);
    AddNameProp (cl, res, name, state);
    RETURN res
  END pRim;

PROCEDURE <A NAME="GetPixmap"><procedure>GetPixmap</procedure></A> (name: TEXT; path: Rsrc.Path): Pixmap.T
  RAISES {Error} =
  BEGIN
    WITH image = GetRawImage(name, path) DO RETURN Image.Scaled(image) END
  END GetPixmap;

PROCEDURE <A NAME="GetRawImage"><procedure>GetRawImage</procedure></A> (name: TEXT; path: Rsrc.Path): Image.Raw
  RAISES {Error} =
  VAR rd: Rd.T;
  BEGIN
    TRY
      rd := Rsrc.Open(name, path);
      TRY RETURN Image.FromRd(rd) FINALLY Rd.Close(rd) END;
    EXCEPT
    | Image.Error =&gt;
        RAISE Error(&quot;Format error in pixmap for &quot; &amp; name)
    | Rsrc.NotFound =&gt; RAISE Error(&quot;No such resource: &quot; &amp; name)
    | Rd.Failure (ref) =&gt; RAISE Error(RdUtils.FailureText(ref))
    END
  END GetRawImage;
</PRE> ========================= Frame &amp; Ridge ============================= 

<P><PRE>PROCEDURE <A NAME="pFrame"><procedure>pFrame</procedure></A> (         cl  : ParseClosure;
                  VAR      list: RefList.T;
                  READONLY s   : State         ): VBT.T
  RAISES {Error} =
  VAR
    state       := s;
    name        := NamePP();
    shadowStyle := NewShadowStyle(Shadow.Style.Raised);
  VAR
    res: FVFrame;
    ch : VBT.T;
  BEGIN
    ParseProps(
      cl, list, state, PP1{name}, enums := EP1{shadowStyle});
    ch := OneChild(cl, list, state);
    res := cl.fv.realize(&quot;Frame&quot;, name.valname);
    res := res.init(ch, state.shadow,
                    VAL(shadowStyle.chosen, Shadow.Style));
    AddNameProp(cl, res, name, state);
    RETURN res
  END pFrame;

PROCEDURE <A NAME="pRidge"><procedure>pRidge</procedure></A> (         cl  : ParseClosure;
                  VAR      list: RefList.T;
                  READONLY s   : State         ): VBT.T
  RAISES {Error} =
  VAR
    state := s;
    name  := NamePP();
    main := NEW(
              RealPP, val := DefaultShadowSizePts, found := TRUE);
  VAR
    res   : FVRidge;
    shadow: Shadow.T;
  BEGIN
    ParseProps(cl, list, state, PP2{name, main}, main := main);
    res := cl.fv.realize(&quot;Ridge&quot;, name.valname);
    shadow :=
      Shadow.New(Pts.ToMM(main.val), state.bgOp, state.fgOp,
                 state.lightOp, state.darkOp);
    res := res.init(state.glueAxis, shadow, Shadow.Style.Ridged);
    AddNameProp(cl, res, name, state);
    RETURN res
  END pRidge;

PROCEDURE <A NAME="pChisel"><procedure>pChisel</procedure></A> (         cl  : ParseClosure;
                   VAR      list: RefList.T;
                   READONLY s   : State         ): VBT.T
  RAISES {Error} =
  VAR
    state := s;
    name  := NamePP();
    main := NEW(
              RealPP, val := DefaultShadowSizePts, found := TRUE);
  VAR
    res   : FVChisel;
    shadow: Shadow.T;
  BEGIN
    ParseProps(cl, list, state, PP2{name, main}, main := main);
    res := cl.fv.realize(&quot;Chisel&quot;, name.valname);
    shadow :=
      Shadow.New(Pts.ToMM(main.val), state.bgOp, state.fgOp,
                 state.lightOp, state.darkOp);
    res :=
      res.init(state.glueAxis, shadow, Shadow.Style.Chiseled);
    AddNameProp(cl, res, name, state);
    RETURN res
  END pChisel;
</PRE> =========================== Fill &amp; Shape =========================== 

<P><PRE>PROCEDURE <A NAME="pFill"><procedure>pFill</procedure></A> (         cl  : ParseClosure;
                 VAR      list: RefList.T;
                 READONLY s   : State         ): VBT.T
  RAISES {Error} =
  CONST
    INFINITESTRETCH = FlexVBT.SizeRange{
                        natural := 0.0, shrink := 0.0, stretch :=
                        FlexVBT.Infinity};
  VAR
    state         := s;
    name          := NamePP();
    shape         := FlexVBT.Default;
    res  : FVFill;
  BEGIN
    IF state.hvsplit = NIL THEN
      RAISE Error(&quot;Fill must appear inside an HBox or VBox.&quot;)
    END;
    ParseProps(cl, list, state, PP1{name});
    AssertEmpty(list);
    shape[state.glueAxis] := INFINITESTRETCH;
    res := cl.fv.realize(&quot;Fill&quot;, name.valname);
    res := res.init(TextureVBT.New(state.bgOp), shape);
    AddNameProp(cl, res, name, state);
    RETURN res
  END pFill;

PROCEDURE <A NAME="pShape"><procedure>pShape</procedure></A> (         cl  : ParseClosure;
                  VAR      list: RefList.T;
                  READONLY s   : State         ): VBT.T
  RAISES {Error} =
  VAR
    state           := s;
    name            := NamePP();
    height          := NEW(SizeRangePP, name := &quot;Height&quot;);
    width           := NEW(SizeRangePP, name := &quot;Width&quot;);
    res   : FVShape;
    ch    : VBT.T;
  BEGIN
    ParseProps(cl, list, state, PP3{name, height, width});
    ch := OneChild(cl, list, state);
    res := cl.fv.realize(&quot;Shape&quot;, name.valname);
    res := res.init(ch, FlexVBT.Shape{width.val, height.val});
    AddNameProp(cl, res, name, state);
    RETURN res
  END pShape;
</PRE> =========================== Buttons =============================== 

<P><PRE>PROCEDURE <A NAME="pButton"><procedure>pButton</procedure></A> (         cl  : ParseClosure;
                   VAR      list: RefList.T;
                   READONLY s   : State         ): VBT.T
  RAISES {Error} =
  VAR
    state           := s;
    name            := NamePP();
    res  : FVButton;
    ch   : VBT.T;
  BEGIN
    ParseProps(cl, list, state, PP1{name});
    ch := OneChild(cl, list, state);
    res := cl.fv.realize(&quot;Button&quot;, name.valname);
    res := res.init(
             NEW(ShadowedFeedbackVBT.T).init(ch, state.shadow));
    AddNameProp(cl, res, name, state);
    RETURN res
  END pButton;

PROCEDURE <A NAME="pMButton"><procedure>pMButton</procedure></A> (         cl  : ParseClosure;
                    VAR      list: RefList.T;
                    READONLY s   : State         ): VBT.T
  RAISES {Error} =
  VAR
    state            := s;
    name             := NamePP();
    res  : FVMButton;
    ch   : VBT.T;
  BEGIN
    ParseProps(cl, list, state, PP1{name});
    ch := OneChild(cl, list, state);
    res := cl.fv.realize(&quot;MButton&quot;, name.valname);
    res :=
      res.init(ShadowedFeedbackVBT.NewMenu(ch, state.shadow));
    AddNameProp(cl, res, name, state);
    RETURN res
  END pMButton;

PROCEDURE <A NAME="pPopButton"><procedure>pPopButton</procedure></A> (         cl  : ParseClosure;
                      VAR      list: RefList.T;
                      READONLY s   : State         ): VBT.T
  RAISES {Error} =
  VAR
    state                := s;
    name                 := NamePP();
    forName              := NEW(SymbolPP, name := &quot;For&quot;);
    res    : FVPopButton;
    ch     : VBT.T;
  BEGIN
    ParseProps(cl, list, state, PP2{name, forName});
    ch := OneChild(cl, list, state);
    res := cl.fv.realize(&quot;PopButton&quot;, name.valname);
    res := res.init(
             NEW(ShadowedFeedbackVBT.T).init(ch, state.shadow));
    AddForProp(cl, res, forName);
    AddNameProp(cl, res, name, state);
    RETURN res
  END pPopButton;

PROCEDURE <A NAME="pPopMButton"><procedure>pPopMButton</procedure></A> (         cl  : ParseClosure;
                       VAR      list: RefList.T;
                       READONLY s   : State         ): VBT.T
  RAISES {Error} =
  VAR
    state                 := s;
    name                  := NamePP();
    forName               := NEW(SymbolPP, name := &quot;For&quot;);
    res    : FVPopMButton;
    ch     : VBT.T;
  BEGIN
    ParseProps(cl, list, state, PP2{name, forName});
    ch := OneChild(cl, list, state);
    res := cl.fv.realize(&quot;PopMButton&quot;, name.valname);
    res :=
      res.init(ShadowedFeedbackVBT.NewMenu(ch, state.shadow));
    AddForProp(cl, res, forName);
    AddNameProp(cl, res, name, state);
    RETURN res
  END pPopMButton;

PROCEDURE <A NAME="pGuard"><procedure>pGuard</procedure></A> (         cl  : ParseClosure;
                  VAR      list: RefList.T;
                  READONLY s   : State         ): VBT.T
  RAISES {Error} =
  VAR
    state          := s;
    name           := NamePP();
    res  : FVGuard;
    ch   : VBT.T;
  BEGIN
    ParseProps(cl, list, state, PP1{name});
    ch := OneChild(cl, list, state);
    res := cl.fv.realize(&quot;Guard&quot;, name.valname);
    res := res.init(ch, state.shadow);
    AddNameProp(cl, res, name, state);
    RETURN res
  END pGuard;

PROCEDURE <A NAME="pTrillButton"><procedure>pTrillButton</procedure></A> (         cl  : ParseClosure;
                        VAR      list: RefList.T;
                        READONLY s   : State         ): VBT.T
  RAISES {Error} =
  VAR
    state                := s;
    name                 := NamePP();
    res  : FVTrillButton;
    ch   : VBT.T;
  BEGIN
    ParseProps(cl, list, state, PP1{name});
    ch := OneChild(cl, list, state);
    res := cl.fv.realize(&quot;TrillButton&quot;, name.valname);
    res := res.init(
             NEW(ShadowedFeedbackVBT.T).init(ch, state.shadow));
    AddNameProp(cl, res, name, state);
    RETURN res
  END pTrillButton;

PROCEDURE <A NAME="pPageButton"><procedure>pPageButton</procedure></A> (         cl  : ParseClosure;
                       VAR      list: RefList.T;
                       READONLY s   : State         ): VBT.T
  RAISES {Error} =
  VAR
    state                   := s;
    name                    := NamePP();
    forName                 := NEW(SymbolPP, name := &quot;For&quot;);
    backwards               := NEW(BooleanPP, name := &quot;Back&quot;);
    res      : FVPageButton;
    ch       : VBT.T;
  BEGIN
    ParseProps(
      cl, list, state, PP2{name, forName}, KP1{backwards});
    ch := OneChild(cl, list, state);
    res := cl.fv.realize(&quot;PageButton&quot;, name.valname);
    IF forName.val # NIL THEN
      AddForProp(cl, res, forName)
    ELSIF state.tsplit = NIL THEN
      RAISE
        Error(&quot;This PageButton is not included in a TSplit and &quot;
                &amp; &quot;it has no (For ...) property.&quot;)
    END;
    res :=
      res.init(ch, state.shadow, backwards.val, state.tsplit);
    AddNameProp(cl, res, name, state);
    RETURN res
  END pPageButton;

PROCEDURE <A NAME="pPageMButton"><procedure>pPageMButton</procedure></A> (         cl  : ParseClosure;
                        VAR      list: RefList.T;
                        READONLY s   : State         ): VBT.T
  RAISES {Error} =
  VAR
    state                    := s;
    name                     := NamePP();
    forName                  := NEW(SymbolPP, name := &quot;For&quot;);
    backwards                := NEW(BooleanPP, name := &quot;Back&quot;);
    res      : FVPageMButton;
    ch       : VBT.T;
  BEGIN
    ParseProps(
      cl, list, state, PP2{name, forName}, KP1{backwards});
    ch := OneChild(cl, list, state);
    res := cl.fv.realize(&quot;PageMButton&quot;, name.valname);
    IF forName.val # NIL THEN
      AddForProp(cl, res, forName)
    ELSIF state.tsplit = NIL THEN
      RAISE
        Error(&quot;This PageMButton is not included in a TSplit and &quot;
                &amp; &quot;it has no (For ...) property.&quot;)
    END;
    res :=
      res.init(ch, state.shadow, backwards.val, state.tsplit);
    AddNameProp(cl, res, name, state);
    RETURN res
  END pPageMButton;

PROCEDURE <A NAME="pLinkButton"><procedure>pLinkButton</procedure></A> (         cl  : ParseClosure;
                       VAR      list: RefList.T;
                       READONLY s   : State         ): VBT.T
  RAISES {Error} =
  VAR
    state                := s;
    name                 := NamePP();
    toName               := NEW(SymbolPP, name := &quot;For&quot;);
    res   : FVLinkButton;
    ch    : VBT.T;
  BEGIN
    ParseProps(cl, list, state, PP2{name, toName});
    ch := OneChild(cl, list, state);
    res := cl.fv.realize(&quot;LinkButton&quot;, name.valname);
    IF toName.val = NIL THEN
      RAISE Error(&quot;LinkButton must include (To &lt;name&gt;)&quot;)
    END;
    AddForProp(cl, res, toName);
    res := res.init(
             NEW(ShadowedFeedbackVBT.T).init(ch, state.shadow));
    AddNameProp(cl, res, name, state);
    RETURN res
  END pLinkButton;

PROCEDURE <A NAME="pLinkMButton"><procedure>pLinkMButton</procedure></A> (         cl  : ParseClosure;
                        VAR      list: RefList.T;
                        READONLY s   : State         ): VBT.T
  RAISES {Error} =
  VAR
    state                 := s;
    name                  := NamePP();
    toName                := NEW(SymbolPP, name := &quot;For&quot;);
    res   : FVLinkMButton;
    ch    : VBT.T;
  BEGIN
    ParseProps(cl, list, state, PP2{name, toName});
    ch := OneChild(cl, list, state);
    res := cl.fv.realize(&quot;LinkMButton&quot;, name.valname);
    IF toName.val = NIL THEN
      RAISE Error(&quot;LinkMButton must include (To &lt;name&gt;)&quot;)
    END;
    AddForProp(cl, res, toName);
    res :=
      res.init(ShadowedFeedbackVBT.NewMenu(ch, state.shadow));
    AddNameProp(cl, res, name, state);
    RETURN res
  END pLinkMButton;

PROCEDURE <A NAME="pCloseButton"><procedure>pCloseButton</procedure></A> (         cl  : ParseClosure;
                        VAR      list: RefList.T;
                        READONLY s   : State         ): VBT.T
  RAISES {Error} =
  VAR
    state                  := s;
    name                   := NamePP();
    forName                := NEW(SymbolPP, name := &quot;For&quot;);
    res    : FVCloseButton;
    ch     : VBT.T;
  BEGIN
    ParseProps(cl, list, state, PP2{name, forName});
    ch := OneChild(cl, list, state);
    res := cl.fv.realize(&quot;CloseButton&quot;, name.valname);
    IF forName.val # NIL THEN
      AddForProp(cl, res, forName)
    ELSIF state.zchild # NIL THEN
      res.target := state.zchild
    ELSE
      RAISE
        Error(
          &quot;This CloseButton is not included in a ZChild or ZChassis &quot;
            &amp; &quot;and it has no (For ...) property.&quot;)
    END;
    res := res.init(ch, state.shadow);
    AddNameProp(cl, res, name, state);
    RETURN res
  END pCloseButton;
</PRE> ====================== Boolean, Choice, Radio ======================= 

<P><PRE>PROCEDURE <A NAME="pBoolean"><procedure>pBoolean</procedure></A> (         cl  : ParseClosure;
                    VAR      list: RefList.T;
                    READONLY s   : State         ): VBT.T
  RAISES {Error} =
  VAR
    state     := s;
    name      := NamePP();
    value     := NEW(BooleanPP, name := &quot;Value&quot;);
    checkbox  := NEW(BooleanPP, name := &quot;CheckBox&quot;);
    checkmark := NEW(BooleanPP, name := &quot;CheckMark&quot;);
    inverting := NEW(BooleanPP, name := &quot;Inverting&quot;);
    menustyle := NEW(BooleanPP, name := &quot;MenuStyle&quot;);
    enum := NEW(EnumPP).init(
              KP3{checkbox, checkmark, inverting}, 0);
    child, feedback: VBT.T;
    switch         : ButtonVBT.T;
    res            : FVBoolean;
  BEGIN
    ParseProps(cl, list, state, PP2{name, value}, KP1{menustyle},
               enums := EP1{enum});
    child := OneChild(cl, list, state);
    IF inverting.val THEN
      feedback :=
        NEW(ShadowedFeedbackVBT.T).init(child, state.shadow)
    ELSIF checkmark.val THEN
      feedback := MarginFeedbackVBT.NewCheck(child, state.shadow)
    ELSE
      feedback := MarginFeedbackVBT.NewBox(child, state.shadow)
    END;
    IF menustyle.val THEN
      switch := NEW(MenuSwitchVBT.T).init(
                  MenuStyle(feedback, state.shadow))
    ELSE
      switch := NEW(SwitchVBT.T).init(feedback)
    END;
    res := cl.fv.realize(&quot;Boolean&quot;, name.valname);
    res := res.init(switch);
    BooleanVBT.Put(res, value.val);
    AddNameProp(cl, res, name, state);
    RETURN res
  END pBoolean;

PROCEDURE <A NAME="pChoice"><procedure>pChoice</procedure></A> (         cl  : ParseClosure;
                   VAR      list: RefList.T;
                   READONLY s   : State         ): VBT.T
  RAISES {Error} =
  VAR
    state     := s;
    name      := NamePP();
    value     := NEW(BooleanPP, name := &quot;Value&quot;);
    checkmark := NEW(BooleanPP, name := &quot;CheckMark&quot;);
    checkbox  := NEW(BooleanPP, name := &quot;CheckBox&quot;);
    inverting := NEW(BooleanPP, name := &quot;Inverting&quot;);
    enum := NEW(EnumPP).init(
              KP3{checkbox, checkmark, inverting}, 0);
    menustyle := NEW(BooleanPP, name := &quot;MenuStyle&quot;);
    child, feedback: VBT.T;
    switch         : ButtonVBT.T;
    res            : FVChoice;
  BEGIN
    IF state.radio = NIL THEN
      RAISE Error(&quot;Choice must be contained within Radio&quot;)
    END;
    ParseProps(cl, list, state, PP2{name, value}, KP1{menustyle},
               enums := EP1{enum});
    IF name.val = NIL THEN
      RAISE Error(&quot;Choices must be named.&quot;)
    END;
    child := OneChild(cl, list, state);
    IF inverting.val THEN
      feedback :=
        NEW(ShadowedFeedbackVBT.T).init(child, state.shadow)
    ELSIF checkmark.val THEN
      feedback := MarginFeedbackVBT.NewCheck(child, state.shadow)
    ELSE
      feedback :=
        MarginFeedbackVBT.NewBullet(child, state.shadow)
    END;
    IF menustyle.val THEN
      switch := NEW(MenuSwitchVBT.T).init(
                  MenuStyle(feedback, state.shadow))
    ELSE
      switch := NEW(SwitchVBT.T).init(feedback)
    END;
    res := cl.fv.realize(&quot;Choice&quot;, name.valname);
    res := res.init(switch, state.radio.radio);
    res.radio := state.radio;
    res.name := name.valname;
    IF value.val THEN ChoiceVBT.Put(res) END;
    AddNameProp(cl, res, name, state);
    RETURN res
  END pChoice;

PROCEDURE <A NAME="pRadio"><procedure>pRadio</procedure></A> (         cl  : ParseClosure;
                  VAR      list: RefList.T;
                  READONLY s   : State         ): VBT.T
  RAISES {Error} =
  VAR
    state          := s;
    name           := NamePP();
    value          := NEW(SymbolPP, name := &quot;Value&quot;);
    res  : FVRadio;
  BEGIN
    ParseProps(cl, list, state, PP2{name, value});
    res := cl.fv.realize(&quot;Radio&quot;, name.valname);
    res.radio := NEW(ChoiceVBT.Group);
    state.radio := res;
    EVAL Filter.T.init(res, OneChild(cl, list, state));
    (* Did the client select a choice via (Radio ...  =&lt;symbol&gt;
       ...)? *)
    IF value.val # NIL THEN
      ChoiceVBT.Put(GetVBT(cl.fv, value.valname))
    END;
    AddNameProp(cl, res, name, state);
    RETURN res
  END pRadio;

PROCEDURE <A NAME="MenuStyle"><procedure>MenuStyle</procedure></A> (feedback: FeedbackVBT.T; shadow: Shadow.T):
  FeedbackVBT.T =
  BEGIN
    WITH ch = MultiFilter.Replace(feedback, NIL),
         sh = ShadowedFeedbackVBT.NewMenu(NIL, shadow) DO
      RETURN NEW(BiFeedbackVBT.T).init(sh, feedback, ch)
    END
  END MenuStyle;
</PRE> =========================== Splits =============================== 

<P><PRE>PROCEDURE <A NAME="pHBox"><procedure>pHBox</procedure></A> (cl: ParseClosure; VAR list : RefList.T; READONLY s: State):
    VBT.T
  RAISES {Error} =
  BEGIN
    RETURN pHVBox(cl, list, s, Axis.T.Hor)
  END pHBox;

PROCEDURE <A NAME="pVBox"><procedure>pVBox</procedure></A> (cl: ParseClosure; VAR list : RefList.T; READONLY s: State):
    VBT.T
  RAISES {Error} =
  BEGIN
    RETURN pHVBox(cl, list, s, Axis.T.Ver)
  END pVBox;

PROCEDURE <A NAME="pHVBox"><procedure>pHVBox</procedure></A> (         cl  : ParseClosure;
                  VAR      list: RefList.T;
                  READONLY s   : State;
                           axis: Axis.T        ): VBT.T
  RAISES {Error} =
  CONST TypeNames = ARRAY Axis.T OF TEXT{&quot;HBox&quot;, &quot;VBox&quot;};
  VAR
    state            := s;
    name             := NamePP();
    res  : HVSplit.T;
  BEGIN
    ParseProps(cl, list, state, PP1{name});
    res := cl.fv.realize(TypeNames[axis], name.valname);
    res := res.init(axis, adjustable := FALSE);
    state.glueAxis := axis;
    state.hvsplit := res;
    AddChildren(cl, res, list, state);
    AddNameProp(cl, res, name, state);
    RETURN res
  END pHVBox;

PROCEDURE <A NAME="pHTile"><procedure>pHTile</procedure></A> (cl: ParseClosure; VAR list: RefList.T; READONLY s: State):
    VBT.T
  RAISES {Error} =
  BEGIN
    RETURN pHVTile (cl, list, s, Axis.T.Hor)
  END pHTile;

PROCEDURE <A NAME="pVTile"><procedure>pVTile</procedure></A> (cl: ParseClosure; VAR list: RefList.T; READONLY s: State):
    VBT.T
  RAISES {Error} =
  BEGIN
    RETURN pHVTile (cl, list, s, Axis.T.Ver)
  END pVTile;

PROCEDURE <A NAME="pHVTile"><procedure>pHVTile</procedure></A> (         cl  : ParseClosure;
                   VAR      list: RefList.T;
                   READONLY s   : State;
                            axis: Axis.T        ): VBT.T
  RAISES {Error} =
  CONST TypeNames = ARRAY Axis.T OF TEXT{&quot;HTile&quot;, &quot;VTile&quot;};
  VAR
    state := s;
    name  := NamePP();
    (* asTargets := NEW (BooleanPP, name := &quot;Targets&quot;); *)
    res: SplitterVBT.T;
  BEGIN
    ParseProps(
      cl, list, state, PP1{name} (* , KP1 {asTargets} *));
    res := cl.fv.realize(TypeNames[axis], name.valname);
    res := res.init(axis, op := state.shadow.bgFg);
    state.glueAxis := axis;
    AddChildren(cl, res, list, state);
    AddNameProp(cl, res, name, state);
    RETURN res
  END pHVTile;

PROCEDURE <A NAME="pHPackSplit"><procedure>pHPackSplit</procedure></A> (cl: ParseClosure;
    VAR list: RefList.T; READONLY state: State): VBT.T RAISES {Error} =
  BEGIN
    RETURN pHVPackSplit (cl, list, state, Axis.T.Hor)
  END pHPackSplit;

PROCEDURE <A NAME="pVPackSplit"><procedure>pVPackSplit</procedure></A> (cl: ParseClosure;
    VAR list: RefList.T; READONLY state: State): VBT.T RAISES {Error} =
  BEGIN
    RETURN pHVPackSplit (cl, list, state, Axis.T.Ver)
  END pVPackSplit;

PROCEDURE <A NAME="pHVPackSplit"><procedure>pHVPackSplit</procedure></A> (         cl  : ParseClosure;
                        VAR      list: RefList.T;
                        READONLY s   : State;
                                 axis: Axis.T        ): VBT.T
  RAISES {Error} =
  CONST
    TypeNames = ARRAY Axis.T OF TEXT{&quot;HPackSplit&quot;, &quot;VPackSplit&quot;};
  VAR
    state      := s;
    name       := NamePP();
    hgap       := NEW(RealPP, name := &quot;HGap&quot;, val := 2.0);
    vgap       := NEW(RealPP, name := &quot;VGap&quot;, val := 2.0);
    background := NEW(TextPP, name := &quot;Background&quot;);
    txt        := Pixmap.Solid;
  VAR res: FVHPackSplit;
  BEGIN
    ParseProps(
      cl, list, state, PP4{name, hgap, vgap, background});
    res := cl.fv.realize(TypeNames[axis], name.valname);
    IF background.val # NIL THEN
      txt := GetPixmap(background.val, cl.fv.path)
    END;
    res := res.init(hv := axis, hgap := Pts.ToMM(hgap.val),
                    vgap := Pts.ToMM(vgap.val), txt := txt,
                    op := state.bgOp);
    AddChildren(cl, res, list, state);
    AddNameProp(cl, res, name, state);
    RETURN res
  END pHVPackSplit;
</PRE> ========================== TSplits ============================ 

<P><PRE>PROCEDURE <A NAME="pTSplit"><procedure>pTSplit</procedure></A> (         cl  : ParseClosure;
                   VAR      list: RefList.T;
                   READONLY s   : State         ): VBT.T
  RAISES {Error} =
  VAR
    state := s;
    name  := NamePP();
    value := NEW(CardinalPP, name := &quot;Value&quot;,
                 val := LAST(CARDINAL));
    which              := NEW(SymbolPP, name := &quot;Which&quot;);
    circular           := NEW(BooleanPP, name := &quot;Circular&quot;);
    flexible           := NEW(BooleanPP, name := &quot;Flex&quot;);
    res     : FVTSplit;
    n       : CARDINAL;
    namedChild, numberedChild: VBT.T := NIL;
  BEGIN
    ParseProps(cl, list, state, PP3{name, value, which},
               KP2{circular, flexible});
    res := cl.fv.realize(&quot;TSplit&quot;, name.valname);
    res := res.init(fickle := flexible.val);
    res.circular := circular.val;
    state.tsplit := res;
    AddChildren(cl, res, list, state);

    (* Check validity and consistency of (Which n) and (Value
       name). *)
    n := Split.NumChildren(res);

    IF which.val # NIL THEN
      namedChild := GetVBT(cl.fv, which.valname)
    END;

    TRY
      IF value.val = LAST(CARDINAL) THEN
        IF namedChild # NIL THEN
          TSplit.SetCurrent(res, namedChild)
        ELSE
          TSplit.SetCurrent(res, Split.Nth(res, 0))
        END
      ELSIF value.val &lt; n THEN
        numberedChild := Split.Nth(res, value.val);
        IF namedChild = NIL OR namedChild = numberedChild THEN
          TSplit.SetCurrent(res, numberedChild)
        ELSE
          RAISE
            Error(
              Fmt.F(
                &quot;(Which %s) is not the same child as (Value %s)&quot;,
                Atom.ToText(which.val), Fmt.Int(value.val)))
        END
      ELSIF value.val = 1 THEN
        RAISE Error(&quot;TSplit has no children.&quot;)
      ELSE
        RAISE
          Error(
            Fmt.F(&quot;TSplit has only %s children.&quot;, Fmt.Int(n)))
      END
    EXCEPT
      Split.NotAChild =&gt;
        RAISE
          Error(
            Atom.ToText(which.val)
              &amp; &quot; is not the name of a child of this TSplit.&quot;)
    END;
    AddNameProp(cl, res, name, state);
    RETURN res
  END pTSplit;
</PRE> ===================== FileBrowser &amp; Helper ==================== 

<P><PRE>PROCEDURE <A NAME="pFileBrowser"><procedure>pFileBrowser</procedure></A> (         cl  : ParseClosure;
                        VAR      list: RefList.T;
                        READONLY s   : State         ): VBT.T
  RAISES {Error} =
  VAR
    state    := s;
    name     := NamePP();
    value    := NEW(TextPP, name := &quot;Value&quot;, val := &quot;.&quot;);
    suffixes := NEW(TextListPP, name := &quot;Suffixes&quot;);
    readOnly := NEW(BooleanPP, name := &quot;ReadOnly&quot;);
    res: FVFileBrowser;
  BEGIN
    ParseProps(
      cl, list, state, PP3{name, value, suffixes}, KP1{readOnly});
    AssertEmpty(list);
    res := cl.fv.realize(&quot;FileBrowser&quot;, name.valname);
    res := res.init(state.font, state.shadow);
    TRY
      IF value.found THEN FileBrowserVBT.Set(res, value.val) END;
      FileBrowserVBT.SetReadOnly(res, readOnly.val);
      IF suffixes.val # NIL THEN
        FileBrowserVBT.SetSuffixes(
          res, SuffixesFromList(suffixes.val))
      END
    EXCEPT
    | FileBrowserVBT.Error (e) =&gt;
        RAISE Error(Fmt.F(&quot;Error for %s: %s&quot;, e.path, e.text))
    END;
    AddNameProp(cl, res, name, state);
    RETURN res
  END pFileBrowser;

PROCEDURE <A NAME="SuffixesFromList"><procedure>SuffixesFromList</procedure></A> (list: RefList.T): TEXT =
  VAR wr := TextWr.New ();
  &lt;* FATAL Wr.Failure, Thread.Alerted *&gt;
  BEGIN
    LOOP
      IF Text.Empty (list.head) THEN
        Wr.PutChar (wr, '$')
      ELSE
        Wr.PutText (wr, list.head)
      END;
      list := list.tail;
      IF list = NIL THEN RETURN TextWr.ToText (wr) END;
      Wr.PutChar (wr, ' ')
    END
  END SuffixesFromList;

PROCEDURE <A NAME="pHelper"><procedure>pHelper</procedure></A> (         cl  : ParseClosure;
                   VAR      list: RefList.T;
                   READONLY s   : State         ): VBT.T
  RAISES {Error} =
  VAR
    state          := s;
    name           := NamePP();
    forName        := NEW(SymbolPP, name := &quot;For&quot;);
    firstFocus     := NEW(BooleanPP, name := &quot;FirstFocus&quot;);
    expandOnDemand := NEW(BooleanPP, name := &quot;ExpandOnDemand&quot;);
    tabTo          := NEW(SymbolPP, name := &quot;TabTo&quot;);
  VAR res: FVHelper;
  BEGIN
    ParseProps(cl, list, state, PP3{name, forName, tabTo},
               KP2{firstFocus, expandOnDemand});
    IF forName.val = NIL THEN
      RAISE Error(&quot;Helper must include (For &lt;name&gt;)&quot;)
    END;
    AssertEmpty(list);
    res := cl.fv.realize(&quot;Helper&quot;, name.valname);
    res := res.init(expandOnDemand.val, font := state.font,
                    colorScheme := state.shadow);
    AddForProp(cl, res, forName);
    IF tabTo.val # NIL THEN AddForProp(cl, res, tabTo) END;
    CheckFirstFocus(firstFocus, res);
    AddNameProp(cl, res, name, state);
    RETURN res
  END pHelper;

PROCEDURE <A NAME="CheckFirstFocus"><procedure>CheckFirstFocus</procedure></A> (firstFocus: BooleanPP; widget: VBT.T) =
  BEGIN
    IF firstFocus.val THEN FVRuntime.SetFirstFocus(widget) END
  END CheckFirstFocus;

PROCEDURE <A NAME="pDirMenu"><procedure>pDirMenu</procedure></A> (         cl  : ParseClosure;
                    VAR      list: RefList.T;
                    READONLY s   : State         ): VBT.T
  RAISES {Error} =
  VAR
    state              := s;
    name               := NamePP();
    forName            := NEW(SymbolPP, name := &quot;For&quot;);
    res    : FVDirMenu;
  BEGIN
    ParseProps(cl, list, state, PP2{name, forName});
    IF forName.val = NIL THEN
      RAISE Error(&quot;DirMenu must include (For &lt;name&gt;)&quot;)
    END;
    AssertEmpty(list);
    res := cl.fv.realize(&quot;DirMenu&quot;, name.valname);
    res := res.init(font := state.font, shadow := state.shadow);
    AddForProp(cl, res, forName);
    AddNameProp(cl, res, name, state);
    RETURN res
  END pDirMenu;

PROCEDURE <A NAME="pBrowser"><procedure>pBrowser</procedure></A> (         cl  : ParseClosure;
                    VAR      list: RefList.T;
                    READONLY s   : State         ): VBT.T
  RAISES {Error} =
  VAR
    state  := s;
    name   := NamePP();
    value  := NEW(IntegerPP, name := &quot;Value&quot;, val := -1);
    select := NEW(TextPP, name := &quot;Select&quot;);
    items  := NEW(TextListPP, name := &quot;Items&quot;);
    from   := NEW(TextPP, name := &quot;From&quot;);
    quick  := NEW(BooleanPP, name := &quot;Quick&quot;);
    colors: Shadow.T;
    res   : FVBrowser;
    u     : UniSelector;
  BEGIN
    ParseProps(cl, list, state,
               PP5{name, value, select, items, from}, KP1{quick});
    AssertEmpty(list);
    res := cl.fv.realize(&quot;Browser&quot;, name.valname);
    colors := state.shadow;
    TYPECASE res.painter OF
    | NULL =&gt;
        res.painter := NEW(ListVBT.TextPainter).init(
                         colors.bg, colors.fg, colors.fg,
                         colors.bg, state.font)
    | ListVBT.TextPainter (tp) =&gt;
        res.painter := tp.init(colors.bg, colors.fg, colors.fg,
                               colors.bg, state.font)
    ELSE
    END;
    TYPECASE res.selector OF
    | NULL =&gt; u := NEW(UniSelector).init(res); res.selector := u
    | UniSelector (sel) =&gt; u := sel.init(res)
    ELSE
      RAISE
        Error(
          &quot;Browser has a selector that is not a subtype of FVTypes.UniSelector&quot;)
    END;
    u.browser := res;
    u.quick := quick.val;
    res := res.init(colors := state.shadow);
    IF items.val # NIL THEN
      SetValues(res, items.val)
    ELSIF from.val # NIL THEN
      SetValues(res, ItemsFromFile(from.val, cl))
    END;
    IF value.val # -1 THEN
      res.selectOnly(value.val)
    ELSIF select.val # NIL THEN
      res.selectOnly(ListVBTPosition(res, select.val))
    END;
    AddNameProp(cl, res, name, state);
    RETURN res
  END pBrowser;

PROCEDURE <A NAME="pMultiBrowser"><procedure>pMultiBrowser</procedure></A> (         cl  : ParseClosure;
                         VAR      list: RefList.T;
                         READONLY s   : State         ): VBT.T
  RAISES {Error} =
  VAR
    state  := s;
    name   := NamePP();
    value  := NEW(CardinalListPP, name := &quot;Value&quot;);
    select := NEW(TextListPP, name := &quot;Select&quot;);
    items  := NEW(TextListPP, name := &quot;Items&quot;);
    from   := NEW(TextPP, name := &quot;From&quot;);
    quick  := NEW(BooleanPP, name := &quot;Quick&quot;);
    res   : FVMultiBrowser;
    m     : MultiSelector;
    colors: Shadow.T;
  BEGIN
    ParseProps(cl, list, state,
               PP5{name, value, select, items, from}, KP1{quick});
    AssertEmpty(list);
    res := cl.fv.realize(&quot;MultiBrowser&quot;, name.valname);
    colors := state.shadow;
    TYPECASE res.painter OF
    | NULL =&gt;
        res.painter := NEW(ListVBT.TextPainter).init(
                         colors.bg, colors.fg, colors.fg,
                         colors.bg, state.font)
    | ListVBT.TextPainter (tp) =&gt;
        res.painter := tp.init(colors.bg, colors.fg, colors.fg,
                               colors.bg, state.font)
    ELSE
    END;
    TYPECASE res.selector OF
    | NULL =&gt;
        m := NEW(MultiSelector).init(res);
        res.selector := m
    | MultiSelector (sel) =&gt; m := sel.init(res)
    ELSE
      RAISE
        Error(
          &quot;MultiBrowser has a selector that is not a subtype &quot;
            &amp; &quot;of FVTypes.MultiSelector&quot;)
    END;
    m.quick := quick.val;
    m.browser := res;
    res := res.init(colors := state.shadow);
    IF items.val # NIL THEN
      SetValues(res, items.val)
    ELSIF from.val # NIL THEN
      SetValues(res, ItemsFromFile(from.val, cl))
    END;
    IF value.val # NIL THEN
      REPEAT
        res.select(NARROW(Pop(value.val), REF INTEGER)^, TRUE)
      UNTIL value.val = NIL
    ELSIF select.val # NIL THEN
      REPEAT
        res.select(ListVBTPosition(res, Pop(select.val)), TRUE)
      UNTIL select.val = NIL
    END;
    AddNameProp(cl, res, name, state);
    RETURN res
  END pMultiBrowser;

PROCEDURE <A NAME="SetValues"><procedure>SetValues</procedure></A> (v: ListVBT.T; new: RefList.T) =
  VAR
    oldCount := v.count ();
    newCount := RefList.Length (new);
    delta    := oldCount - newCount;
  BEGIN
    IF delta &lt; 0 THEN
      v.insertCells (oldCount, -delta)
    ELSIF delta &gt; 0 THEN
      v.removeCells (newCount, delta)
    END;
    FOR j := 0 TO newCount - 1 DO v.setValue (j, Pop (new)) END
  END SetValues;

PROCEDURE <A NAME="ListVBTPosition"><procedure>ListVBTPosition</procedure></A> (v: ListVBT.T; item: TEXT):
  [-1 .. LAST (CARDINAL)] =
  BEGIN
    FOR i := v.count () - 1 TO 0 BY -1 DO
      IF Text.Equal (v.getValue (i), item) THEN RETURN i END
    END;
    RETURN -1
  END ListVBTPosition;

PROCEDURE <A NAME="ItemsFromFile"><procedure>ItemsFromFile</procedure></A> (name: TEXT; cl: ParseClosure): RefList.T
  RAISES {Error} =
  VAR tl: RefList.T := NIL;
  BEGIN
    TRY                          (* EXCEPT *)
      WITH in = Rsrc.Open(name, cl.fv.path) DO
        TRY                      (* FINALLY *)
          TRY                    (* EXCEPT *)
            LOOP Push(tl, Rd.GetLine(in)) END
          EXCEPT
          | Rd.EndOfFile =&gt; RETURN RefList.ReverseD(tl)
          END                    (* TRY *)
        FINALLY
          Rd.Close(in)
        END                      (* TRY *)
      END                        (* WITH *)
    EXCEPT
    | Rd.Failure (ref) =&gt; RAISE Error(RdUtils.FailureText(ref))
    | Rsrc.NotFound =&gt; RAISE Error(&quot;No such resource: &quot; &amp; name)
    END                          (* TRY *)
  END ItemsFromFile;
</PRE> =========================== Insert =========================== 

<P><PRE>PROCEDURE <A NAME="InsertFile"><procedure>InsertFile</procedure></A> (pathname: TEXT; path: Rsrc.Path): RefList.T
  RAISES {Error} =
  VAR
    res: RefList.T := NIL;
    rd : Rd.T;
  BEGIN
    TRY
      rd := Rsrc.Open (pathname, path);
      TRY
        LOOP Push (res, Sx.Read (rd, syntax := FVSyntax)) END
      FINALLY
        Rd.Close (rd)
      END
    EXCEPT
    | Sx.ReadError (txt) =&gt; RAISE Error (&quot;Sx.ReadError: &quot; &amp; txt)
    | Rd.EndOfFile =&gt; RETURN RefList.ReverseD (res)
    | Rd.Failure (ref) =&gt; RAISE Error (RdUtils.FailureText (ref))
    | Rsrc.NotFound =&gt; RAISE Error (&quot;No such resource: &quot; &amp; pathname)
    END
  END InsertFile;
</PRE> =========================== Menus =============================== 

<P><PRE>PROCEDURE <A NAME="pMenu"><procedure>pMenu</procedure></A> (         cl  : ParseClosure;
                 VAR      list: RefList.T;
                 READONLY s   : State         ): VBT.T
  RAISES {Error} =
  VAR
    state           := s;
    name            := NamePP();
    local           := NEW(BooleanPP, name := &quot;NotInTrestle&quot;);
    res  : FVMenu;
    count: CARDINAL;
  BEGIN
    ParseProps(cl, list, state, PP1{name}, KP1{local});
    WITH feedback = NEW(ShadowedFeedbackVBT.T).init(
                      NIL, state.shadow),
         menuFrame = NEW(ShadowedVBT.T).init(
                       NIL, state.shadow, Shadow.Style.Raised) DO
      res := cl.fv.realize(&quot;Menu&quot;, name.valname);
      IF local.val THEN
        count := 0
      ELSE
        count := LAST(CARDINAL)
      END;
      res := res.init(feedback, menuFrame, count, state.menubar);
      AddChildren(cl, res, list, state);
      AddNameProp(cl, res, name, state);
      RETURN res
    END
  END pMenu;
</PRE> =========================== Numeric =============================== 

<P><PRE>PROCEDURE <A NAME="pNumeric"><procedure>pNumeric</procedure></A> (         cl  : ParseClosure;
                    VAR      list: RefList.T;
                    READONLY s   : State         ): VBT.T
  RAISES {Error} =
  VAR
    state       := s;
    name        := NamePP();
    allowEmpty  := NEW(BooleanPP, name := &quot;AllowEmpty&quot;);
    hideButtons := NEW(BooleanPP, name := &quot;HideButtons&quot;);
    value       := NEW(IntegerPP, name := &quot;Value&quot;);
    min := NEW(IntegerPP, name := &quot;Min&quot;, val := FIRST(INTEGER));
    max := NEW(IntegerPP, name := &quot;Max&quot;, val := LAST(INTEGER));
    forName    := NEW(SymbolPP, name := &quot;TabTo&quot;);
    firstFocus := NEW(BooleanPP, name := &quot;FirstFocus&quot;);
    res: FVNumeric;
  BEGIN
    ParseProps(
      cl, list, state, PP5{min, max, value, name, forName},
      KP3{allowEmpty, hideButtons, firstFocus});
    AssertEmpty(list);
    IF max.val &lt; min.val THEN
      RAISE Error(Fmt.F(&quot;Numeric max (%s) is less than min (%s)&quot;,
                        Fmt.Int(max.val), Fmt.Int(min.val)))
    ELSIF NOT value.found THEN
      value.val := MIN(MAX(0, min.val), max.val)
    ELSIF min.val &lt;= value.val AND value.val &lt;= max.val THEN (* skip *)
    ELSE
      RAISE
        Error(
          Fmt.F(
            &quot;Initial Numeric value (%s) is not between %s and %s&quot;,
            Fmt.Int(value.val), Fmt.Int(min.val),
            Fmt.Int(max.val)))
    END;
    res := cl.fv.realize(&quot;Numeric&quot;, name.valname);
    res := res.init(min.val, max.val, allowEmpty.val,
                    hideButtons.val, state.font, state.shadow);
    NumericVBT.Put(res, value.val);
    IF forName.val # NIL THEN AddForProp(cl, res, forName) END;
    CheckFirstFocus(firstFocus, res);
    AddNameProp(cl, res, name, state);
    RETURN res
  END pNumeric;
</PRE> ======================= Texture =========================== 

<P><PRE>PROCEDURE <A NAME="pTexture"><procedure>pTexture</procedure></A> (         cl  : ParseClosure;
                    VAR      list: RefList.T;
                    READONLY s   : State         ): VBT.T
  RAISES {Error} =
  VAR
    state      := s;
    name       := NamePP();
    main       := NEW(TextPP, found := TRUE);
    localalign := NEW(BooleanPP, name := &quot;LocalAlign&quot;);
    res: FVTexture;
    txt            := Pixmap.Solid;
  BEGIN
    ParseProps(
      cl, list, state, PP2{name, main}, KP1{localalign}, main);
    res := cl.fv.realize(&quot;Texture&quot;, name.valname);
    IF main.val # NIL THEN
      txt := GetPixmap(main.val, cl.fv.path)
    END;
    res := res.init(state.shadow.bgFg, txt, localalign.val);
    AddNameProp(cl, res, name, state);
    RETURN res
  END pTexture;
</PRE> ======================= Pixmap &amp; Image =========================== 

<P><PRE>PROCEDURE <A NAME="pImage"><procedure>pImage</procedure></A> (&lt;*UNUSED*&gt;          cl  : ParseClosure;
                  &lt;*UNUSED*&gt; VAR      list: RefList.T;
                  &lt;*UNUSED*&gt; READONLY s   : State         ): VBT.T
  RAISES {Error} =
</PRE><BLOCKQUOTE><EM>******************
  VAR
    state               := s;
    name                := NamePP();
    main                := NEW(TextPP);
    accurate            := NEW(BooleanPP, name := <CODE>Accurate</CODE>);
    gamma               := NEW(BooleanPP, name := <CODE>NeedsGamma</CODE>);
    res     : FVImage;
    len: INTEGER; 
****************</EM></BLOCKQUOTE><PRE>
  BEGIN
    RAISE Error (&quot;Image not currently supported.&quot;);
</PRE><BLOCKQUOTE><EM>************
    ParseProps(cl, list, state, PP2{name, main},
               KP2{accurate, gamma}, main := main);
    res := cl.fv.realize(<CODE>Image</CODE>, name.valname);
    res.bg := state.shadow.bg;
    res.op := state.shadow.bgFg;
    IF gamma.val THEN res.gamma := 2.4
    ELSE res.gamma := 1.0 END;
    TRY res.rd := Rsrc.Open(main.val, cl.fv.path) EXCEPT
    <PRE>
      Rsrc.NotFound =&gt; RAISE Error(&quot;No such resource: &quot; &amp; main.val)
    </PRE>
END;
    TRY len := Rd.Length(res.rd) EXCEPT
    <PRE>
      Thread.Alerted =&gt; &lt;* ASSERT FALSE *&gt;
          Rd.Failure (ref) =&gt; RAISE Error(RdUtils.FailureText(ref))
    </PRE>
END;
    WITH pm = NEW(ImageRd.T).init(res.rd, 0, len, res.op, NIL, res.gamma) DO
      res := res.init(pm, res.bg)
    END;
    AddNameProp(cl, res, name, state);
    RETURN res
**************</EM></BLOCKQUOTE><PRE>
  END pImage;

PROCEDURE <A NAME="pPixmap"><procedure>pPixmap</procedure></A> (         cl  : ParseClosure;
                   VAR      list: RefList.T;
                   READONLY s   : State         ): VBT.T
  RAISES {Error} =
  VAR
    state               := s;
    name                := NamePP();
    main                := NEW(TextPP);
    accurate            := NEW(BooleanPP, name := &quot;Accurate&quot;);
    gamma               := NEW(BooleanPP, name := &quot;NeedsGamma&quot;);
    res     : FVPixmap;
    image   : Image.Raw;
    op      : PaintOp.T;
  BEGIN
    ParseProps(cl, list, state, PP2{name, main},
               KP2{accurate, gamma}, main := main);
    res := cl.fv.realize(&quot;Pixmap&quot;, name.valname);
    image := GetRawImage(main.val, cl.fv.path);
    TYPECASE image OF
    | Image.RawBitmap =&gt; op := state.shadow.bgFg
    | Image.RawPixmap (im) =&gt;
        op := PaintOp.Copy;
        im.needsGamma := gamma.val;
        IF accurate.val THEN
          im.colorMode := Image.Mode.Accurate
        ELSE
          im.colorMode := Image.Mode.Normal
        END
    ELSE                         &lt;* ASSERT FALSE *&gt;
    END;
    res := res.init(Image.Scaled(image), op, state.shadow.bg);
    AddNameProp(cl, res, name, state);
    RETURN res
  END pPixmap;
</PRE> =========================== Scroller =============================== 

<P><PRE>PROCEDURE <A NAME="pScroller"><procedure>pScroller</procedure></A> (         cl  : ParseClosure;
                     VAR      list: RefList.T;
                     READONLY s   : State         ): VBT.T
  RAISES {Error} =
  VAR
    state := s;
    name  := NamePP();
    value := NEW(IntegerPP, name := &quot;Value&quot;, val := 50);
    min   := NEW(IntegerPP, name := &quot;Min&quot;, val := 0);
    max   := NEW(IntegerPP, name := &quot;Max&quot;, val := 100);
    v     := NEW(BooleanPP, name := &quot;Vertical&quot;);
    thumb := NEW(CardinalPP, name := &quot;Thumb&quot;, val := 0);
    step  := NEW(CardinalPP, name := &quot;Step&quot;, val := 1);
    axis  := Axis.T.Hor;
    res: FVScroller;
  BEGIN
    ParseProps(cl, list, state,
               PP6{name, value, min, max, thumb, step}, KP1{v});
    AssertEmpty(list);
    IF v.val THEN axis := Axis.T.Ver END;
    thumb.val := MIN(thumb.val, max.val - min.val);
    res := cl.fv.realize(&quot;Scroller&quot;, name.valname);
    res := res.init(axis, min.val, max.val, state.shadow,
                    step.val, thumb.val);
    ScrollerVBT.Put(res, value.val);
    AddNameProp(cl, res, name, state);
    RETURN res
  END pScroller;
</PRE> ======================== Source &amp; Target ======================= 

<P><PRE>PROCEDURE <A NAME="pSource"><procedure>pSource</procedure></A> (         cl  : ParseClosure;
                   VAR      list: RefList.T;
                   READONLY s   : State         ): VBT.T
  RAISES {Error} =
  VAR
    state           := s;
    name            := NamePP();
    res  : FVSource;
    ch   : VBT.T;
  BEGIN
    ParseProps(cl, list, state, PP1{name});
    ch := OneChild(cl, list, state);
    res := cl.fv.realize(&quot;Source&quot;, name.valname);
    res := res.init(
             NEW(ShadowedFeedbackVBT.T).init(ch, state.shadow));
    AddNameProp(cl, res, name, state);
    RETURN res
  END pSource;

PROCEDURE <A NAME="pTarget"><procedure>pTarget</procedure></A> (         cl  : ParseClosure;
                   VAR      list: RefList.T;
                   READONLY s   : State         ): VBT.T
  RAISES {Error} =
  VAR
    state           := s;
    name            := NamePP();
    res  : FVTarget;
    ch   : VBT.T;
  BEGIN
    ParseProps(cl, list, state, PP1{name});
    ch := OneChild(cl, list, state);
    res := cl.fv.realize(&quot;Target&quot;, name.valname);
    res := res.init(ch);
    SourceVBT.BeTarget(res, SourceVBT.NewTarget());
    AddNameProp(cl, res, name, state);
    RETURN res
  END pTarget;
</PRE> ==================== Stable ===================== 

<P><PRE>PROCEDURE <A NAME="pStable"><procedure>pStable</procedure></A> (         cl  : ParseClosure;
                   VAR      list: RefList.T;
                   READONLY s   : State         ): VBT.T
  RAISES {Error} =
  VAR
    state           := s;
    name            := NamePP();
    res  : FVStable;
    ch   : VBT.T;
  BEGIN
    ParseProps(cl, list, state, PP1{name});
    ch := OneChild(cl, list, state);
    res := cl.fv.realize(&quot;Stable&quot;, name.valname);
    res := res.init(ch);
    AddNameProp(cl, res, name, state);
    RETURN res
  END pStable;
</PRE> ==================== Filter, Generic, Viewport ===================== 

<P><PRE>PROCEDURE <A NAME="pFilter"><procedure>pFilter</procedure></A> (         cl  : ParseClosure;
                   VAR      list: RefList.T;
                   READONLY s   : State         ): VBT.T
  RAISES {Error} =
  VAR
    state   := s;
    name    := NamePP();
    active  := NEW(BooleanPP, name := &quot;Active&quot;);
    passive := NEW(BooleanPP, name := &quot;Passive&quot;);
    dormant := NEW(BooleanPP, name := &quot;Dormant&quot;);
    vanish  := NEW(BooleanPP, name := &quot;Vanish&quot;);
    enum := NEW(EnumPP).init(
              KP4{active, passive, dormant, vanish}, 0);
    cursor           := NEW(TextPP, name := &quot;Cursor&quot;, val := &quot;&quot;);
    curs  : Cursor.T;
    res   : FVFilter;
    ch    : VBT.T;
  BEGIN
    ParseProps(
      cl, list, state, PP2{name, cursor}, enums := EP1{enum});
    ch := OneChild(cl, list, state);
    res := cl.fv.realize(&quot;Filter&quot;, name.valname);
    res := res.init(ch, state.shadow);
    IF Text.Empty(cursor.val) THEN
      curs := Cursor.DontCare
    ELSE
      curs := Cursor.FromName(ARRAY OF TEXT{cursor.val})
    END;
    ReactivityVBT.Set(
      res, VAL(enum.chosen, ReactivityVBT.State), curs);
    AddNameProp(cl, res, name, state);
    RETURN res
  END pFilter;

PROCEDURE <A NAME="pScale"><procedure>pScale</procedure></A> (         cl  : ParseClosure;
                  VAR      list: RefList.T;
                  READONLY s   : State         ): VBT.T
  RAISES {Error} =
  VAR
    state     := s;
    name      := NamePP();
    hscale    := NEW(RealPP, name := &quot;HScale&quot;, val := 1.0);
    vscale    := NEW(RealPP, name := &quot;VScale&quot;, val := 1.0);
    auto      := NEW(BooleanPP, name := &quot;Auto&quot;);
    autoFixed := NEW(BooleanPP, name := &quot;AutoFixed&quot;);
  VAR
    res: FVScale;
    ch : VBT.T;
  BEGIN
    ParseProps(cl, list, state, PP3{name, hscale, vscale},
               KP2{auto, autoFixed});
    ch := OneChild(cl, list, state);
    res := cl.fv.realize(&quot;Scale&quot;, name.valname);
    res := res.init(ch);
    IF auto.val THEN
      ScaleFilter.AutoScale(res, keepAspectRatio := FALSE)
    ELSIF autoFixed.val THEN
      ScaleFilter.AutoScale(res, keepAspectRatio := TRUE)
    ELSE
      IF hscale.val &lt; 1.0E-6 THEN
        RAISE Error(&quot;HScale is too small&quot;)
      END;
      IF vscale.val &lt; 1.0E-6 THEN
        RAISE Error(&quot;VScale is too small&quot;)
      END;
      ScaleFilter.Scale(res, hscale.val, vscale.val)
    END;
    AddNameProp(cl, res, name, state);
    RETURN res
  END pScale;

PROCEDURE <A NAME="pGeneric"><procedure>pGeneric</procedure></A> (         cl  : ParseClosure;
                    VAR      list: RefList.T;
                    READONLY s   : State         ): VBT.T
  RAISES {Error} =
  VAR
    state            := s;
    name             := NamePP();
    res  : FVGeneric;
  BEGIN
    ParseProps(cl, list, state, PP1{name});
    AssertEmpty(list);
    res := cl.fv.realize(&quot;Generic&quot;, name.valname);
    res := res.init(NEW(TextureVBT.T).init(txt := Pixmap.Gray),
                    FVRuntime.EMPTYSHAPE);
    AddNameProp(cl, res, name, state);
    RETURN res
  END pGeneric;

PROCEDURE <A NAME="pViewport"><procedure>pViewport</procedure></A> (         cl  : ParseClosure;
                     VAR      list: RefList.T;
                     READONLY s   : State         ): VBT.T
  RAISES {Error} =
  VAR
    state       := s;
    name        := NamePP();
    h           := NEW(BooleanPP, name := &quot;Horizontal&quot;);
    v           := NEW(BooleanPP, name := &quot;Vertical&quot;);
    enum1       := NEW(EnumPP).init(KP2{h, v}, 1);
    step        := NEW(CardinalPP, name := &quot;Step&quot;, val := 10);
    horandver   := NEW(BooleanPP, name := &quot;HorAndVer&quot;);
    horonly     := NEW(BooleanPP, name := &quot;HorOnly&quot;);
    veronly     := NEW(BooleanPP, name := &quot;VerOnly&quot;);
    noscroll    := NEW(BooleanPP, name := &quot;NoScroll&quot;);
    alaviewport := NEW(BooleanPP, name := &quot;AlaViewport&quot;);
    auto        := NEW(BooleanPP, name := &quot;Auto&quot;);
    unrelated   := NEW(BooleanPP, name := &quot;Unrelated&quot;);
    enum2 := NEW(EnumPP).init(
               KP7{horandver, horonly, veronly, noscroll,
                   alaviewport, auto, unrelated}, 2);
    axis                   := Axis.T.Ver;
    res       : FVViewport;
    ch        : VBT.T;
    shapeStyle             := ViewportVBT.ShapeStyle.Related;
  BEGIN
    ParseProps(cl, list, state, PP2{name, step},
               enums := EP2{enum1, enum2});
    ch := OneChild(cl, list, state);
    IF h.val THEN axis := Axis.T.Hor END;
    IF unrelated.val THEN
      shapeStyle := ViewportVBT.ShapeStyle.Unrelated
    END;
    res := cl.fv.realize(&quot;Viewport&quot;, name.valname);
    res :=
      res.init(ch := ch, axis := axis, shadow := state.shadow,
               step := step.val, shapeStyle := shapeStyle,
               scrollStyle :=
                 VAL(enum2.chosen, ViewportVBT.ScrollStyle));
    AddNameProp(cl, res, name, state);
    RETURN res
  END pViewport;
</PRE> ============================= Text ================================= 

<P><PRE>PROCEDURE <A NAME="pText"><procedure>pText</procedure></A> (         cl  : ParseClosure;
                 VAR      list: RefList.T;
                 READONLY s   : State         ): VBT.T
  RAISES {Error} =
  VAR
    state       := s;
    name        := NamePP();
    main        := NEW(TextPP, found := TRUE);
    margin      := NEW(RealPP, name := &quot;Margin&quot;, val := 2.0);
    vmargin     := NEW(RealPP, name := &quot;VMargin&quot;, val := 0.0);
    leftalign   := NEW(BooleanPP, name := &quot;LeftAlign&quot;);
    centeralign := NEW(BooleanPP, name := &quot;Center&quot;);
    rightalign  := NEW(BooleanPP, name := &quot;RightAlign&quot;);
    enum := NEW(EnumPP).init(
              KP3{leftalign, centeralign, rightalign}, 1);
    from         := NEW(TextPP, name := &quot;From&quot;);
    res : FVText;
  BEGIN
    ParseProps(cl, list, state, PP5{name, main, margin, vmargin, from},
               main := main, enums := EP1{enum});
    IF main.val # NIL THEN       (* skip *)
    ELSIF from.val # NIL THEN
      main.val := TextFromFile(from.val, cl)
    ELSE
      RAISE Error(&quot;Main property is missing&quot;)
    END;
    res := cl.fv.realize(&quot;Text&quot;, name.valname);
    res := res.init(main.val, bgFg := state.shadow,
                    fnt := state.labelFont,
                    halign := FLOAT(enum.chosen) * 0.5,
                    vmargin := Pts.ToMM(vmargin.val),
                    hmargin := Pts.ToMM(margin.val));
    AddNameProp(cl, res, name, state);
    RETURN res
  END pText;
</PRE> ========================== Text editors ========================= 

<P><PRE>PROCEDURE <A NAME="pTypeIn"><procedure>pTypeIn</procedure></A> (         cl  : ParseClosure;
                   VAR      list: RefList.T;
                   READONLY s   : State         ): VBT.T
  RAISES {Error} =
  VAR
    state          := s;
    name           := NamePP();
    value          := NEW(TextPP, name := &quot;Value&quot;, val := &quot;&quot;);
    readOnly       := NEW(BooleanPP, name := &quot;ReadOnly&quot;);
    expandOnDemand := NEW(BooleanPP, name := &quot;ExpandOnDemand&quot;);
    forName        := NEW(SymbolPP, name := &quot;TabTo&quot;);
    turnMargin := NEW(RealPP, name := &quot;TurnMargin&quot;, val := 2.0);
    firstFocus := NEW(BooleanPP, name := &quot;FirstFocus&quot;);
    from       := NEW(TextPP, name := &quot;From&quot;);
  VAR res: FVTypeIn;
  BEGIN
    ParseProps(cl, list, state,
               PP5{name, value, forName, turnMargin, from},
               KP3{readOnly, expandOnDemand, firstFocus});
    AssertEmpty(list);
    res := cl.fv.realize(&quot;TypeIn&quot;, name.valname);
    res := res.init(expandOnDemand.val, font := state.font,
                    colorScheme := state.shadow,
                    readOnly := readOnly.val,
                    turnMargin := Pts.ToMM(turnMargin.val));
    IF value.found OR from.val = NIL THEN
      TextPort.SetText(res, value.val)
    ELSE
      TextPort.SetText(res, TextFromFile(from.val, cl))
    END;
    VBT.SetCursor(res, Cursor.TextPointer);
    IF forName.val # NIL THEN AddForProp(cl, res, forName) END;
    CheckFirstFocus(firstFocus, res);
    AddNameProp(cl, res, name, state);
    RETURN res
  END pTypeIn;

PROCEDURE <A NAME="pTextEdit"><procedure>pTextEdit</procedure></A> (         cl  : ParseClosure;
                     VAR      list: RefList.T;
                     READONLY s   : State         ): VBT.T
  RAISES {Error} =
  VAR
    state       := s;
    name        := NamePP();
    value       := NEW(TextPP, name := &quot;Value&quot;, val := &quot;&quot;);
    readOnly    := NEW(BooleanPP, name := &quot;ReadOnly&quot;);
    clip        := NEW(BooleanPP, name := &quot;Clip&quot;);
    turnMargin  := NEW(RealPP, name := &quot;TurnMargin&quot;, val := 2.0);
    from        := NEW(TextPP, name := &quot;From&quot;);
    noScrollbar := NEW(BooleanPP, name := &quot;NoScrollbar&quot;);
    firstFocus  := NEW(BooleanPP, name := &quot;FirstFocus&quot;);
    reportKeys  := NEW(BooleanPP, name := &quot;ReportKeys&quot;);
  VAR res: FVTextEdit;
  BEGIN
    ParseProps(
      cl, list, state, PP4{name, value, from, turnMargin},
      KP5{readOnly, clip, noScrollbar, firstFocus, reportKeys});
    AssertEmpty(list);
    res := cl.fv.realize(&quot;TextEdit&quot;, name.valname);
    IF res.tp = NIL THEN res.tp := NEW(Port) END;
    res.tp :=
      NARROW(res.tp, Port).init(
        textedit := res, reportKeys := TRUE (* reportKeys.val *),
        font := state.font, colorScheme := state.shadow,
        readOnly := readOnly.val, wrap := NOT clip.val,
        turnMargin := Pts.ToMM(turnMargin.val));
    IF value.found OR from.val = NIL THEN
      TextPort.SetText(res.tp, value.val)
    ELSE
      TextPort.SetText(res.tp, TextFromFile(from.val, cl))
    END;
    IF res.sb # NIL THEN
      res.sb := res.sb.init(Axis.T.Ver, state.shadow)
    ELSIF NOT noScrollbar.val THEN
      res.sb :=
        NEW(TextEditVBT.Scrollbar).init(Axis.T.Ver, state.shadow)
    END;
    res := res.init(NOT noScrollbar.val);
    VBT.SetCursor(res, Cursor.TextPointer);
    CheckFirstFocus(firstFocus, res);
    AddNameProp(cl, res, name, state);
    RETURN res
  END pTextEdit;

PROCEDURE <A NAME="pTypescript"><procedure>pTypescript</procedure></A> (         cl  : ParseClosure;
                       VAR      list: RefList.T;
                       READONLY s   : State         ): VBT.T
  RAISES {Error} =
  VAR
    state      := s;
    name       := NamePP();
    readOnly   := NEW(BooleanPP, name := &quot;ReadOnly&quot;);
    clip       := NEW(BooleanPP, name := &quot;Clip&quot;);
    turnMargin := NEW(RealPP, name := &quot;TurnMargin&quot;, val := 2.0);
    firstFocus := NEW(BooleanPP, name := &quot;FirstFocus&quot;);
  VAR res: FVTypescript;
  BEGIN
    ParseProps(cl, list, state, PP2{name, turnMargin},
               KP2{readOnly, clip});
    AssertEmpty(list);
    res := cl.fv.realize(&quot;Typescript&quot;, name.valname);
    TYPECASE res.tp OF
    | NULL =&gt; res.tp := NEW(TypescriptVBT.Port)
    | TypescriptVBT.Port =&gt;
    ELSE
      RAISE Error(&quot;The .tp field of the Typescript must be &quot;
                    &amp; &quot;a subtype of TypescriptVBT.Port&quot;)
    END;
    res.tp := res.tp.init(
                font := state.font, colorScheme := state.shadow,
                readOnly := readOnly.val, wrap := NOT clip.val,
                turnMargin := Pts.ToMM(turnMargin.val));
    IF res.sb = NIL THEN
      res.sb := NEW(TextEditVBT.Scrollbar)
    END;
    res.sb := res.sb.init(Axis.T.Ver, state.shadow);
    res := res.init();
    VBT.SetCursor(res, Cursor.TextPointer);
    CheckFirstFocus(firstFocus, res);
    AddNameProp(cl, res, name, state);
    RETURN res
  END pTypescript;

PROCEDURE <A NAME="TextFromFile"><procedure>TextFromFile</procedure></A> (filename: TEXT; cl: ParseClosure): TEXT
  RAISES {Error} =
  BEGIN
    TRY
      RETURN Rsrc.Get (filename, cl.fv.path);
    EXCEPT
    | Rd.Failure (ref) =&gt; RAISE Error (RdUtils.FailureText (ref))
    | Thread.Alerted =&gt; RAISE Error (&quot;interrupted (Thread.Alerted)&quot;)
    | Rsrc.NotFound =&gt; RAISE Error (&quot;No such resource: &quot; &amp; filename)
    END
  END TextFromFile;

PROCEDURE <A NAME="NewShadowStyle"><procedure>NewShadowStyle</procedure></A> (default := Shadow.Style.Flat): EnumPP =
  VAR
    flat     := NEW (BooleanPP, name := &quot;Flat&quot;);
    raised   := NEW (BooleanPP, name := &quot;Raised&quot;);
    lowered  := NEW (BooleanPP, name := &quot;Lowered&quot;);
    ridged   := NEW (BooleanPP, name := &quot;Ridged&quot;);
    chiseled := NEW (BooleanPP, name := &quot;Chiseled&quot;);
  BEGIN
    RETURN NEW (EnumPP).init (
             KP5 {flat, raised, lowered, ridged, chiseled}, ORD (default))
  END NewShadowStyle;
</PRE> ======================== ZSplits &amp; ZChildren ===================== 

<P><PRE>PROCEDURE <A NAME="pZSplit"><procedure>pZSplit</procedure></A> (         cl  : ParseClosure;
                   VAR      list: RefList.T;
                   READONLY s   : State         ): VBT.T
  RAISES {Error} =
  VAR
    state           := s;
    name            := NamePP();
    res  : FVZSplit;
  BEGIN
    ParseProps(cl, list, state, PP1{name});
    res := cl.fv.realize(&quot;ZSplit&quot;, name.valname);
    res := res.init();
    state.zsplit := res;
    AddChildren(cl, res, list, state);
    AddNameProp(cl, res, name, state);
    RETURN res
  END pZSplit;

PROCEDURE <A NAME="pZBackground"><procedure>pZBackground</procedure></A> (         cl  : ParseClosure;
                        VAR      list: RefList.T;
                        READONLY s   : State         ): VBT.T
  RAISES {Error} =
  VAR
    state                := s;
    name                 := NamePP();
    res  : FVZBackground;
    ch   : VBT.T;
  BEGIN
    (* it's OK, because we may be inserting the form dynamically
       IF state.zsplit = NIL THEN RAISE Error (&quot;ZBackground must
       be inside a ZSplit.&quot;) END; *)
    ParseProps(cl, list, state, PP1{name});
    ch := OneChild(cl, list, state);
    res := cl.fv.realize(&quot;ZBackground&quot;, name.valname);
    res := res.init(ch);
    AddNameProp(cl, res, name, state);
    RETURN res
  END pZBackground;

PROCEDURE <A NAME="pZChassis"><procedure>pZChassis</procedure></A> (         cl  : ParseClosure;
                     VAR      list: RefList.T;
                     READONLY s   : State         ): VBT.T
  RAISES {Error} =
  VAR
    state   := s;
    name    := NamePP();
    open    := NEW(BooleanPP, name := &quot;Open&quot;);
    noClose := NEW(BooleanPP, name := &quot;NoClose&quot;);
    title   := NEW(VBTPP, name := &quot;Title&quot;);
    at      := NEW(AtSpecPP, name := &quot;At&quot;);
    chain   := NEW(ChainsPP, name := &quot;Chain&quot;);
    scaled  := NEW(BooleanPP, name := &quot;Scaled&quot;);
    fixedH  := NEW(BooleanPP, name := &quot;FixedH&quot;);
    fixedV  := NEW(BooleanPP, name := &quot;FixedV&quot;);
    fixedHV := NEW(BooleanPP, name := &quot;FixedHV&quot;);
  VAR
    res           : FVZChassis;
    titleChild, ch: VBT.T;
    shaper        : ZSplit.ReshapeControl;
  BEGIN
    (* it's OK, because we may be inserting the form dynamically
       IF state.zsplit = NIL THEN RAISE Error (&quot;ZChassis must be
       inside a ZSplit.&quot;) END; *)
    ParseProps(
      cl, list, state, PP4{name, title, at, chain},
      KP6{open, noClose, scaled, fixedH, fixedV, fixedHV});
    IF title.val = NIL THEN
      titleChild :=
        TextVBT.New(&quot;&lt;Untitled&gt;&quot;, fnt := state.labelFont,
                    bgFg := state.shadow)
    ELSE
      titleChild := OneChild(cl, title.val, state)
    END;
    res := cl.fv.realize(&quot;ZChassis&quot;, name.valname);
    state.zchild := res;
    ch := OneChild(cl, list, state);
    IF chain.shaper # NIL THEN
      shaper := chain.shaper
    ELSIF scaled.val THEN
      shaper := ZChildVBT.Scaled
    ELSIF fixedH.val THEN
      shaper := ZChildVBT.ScaledHFixed
    ELSIF fixedV.val THEN
      shaper := ZChildVBT.ScaledVFixed
    ELSIF fixedHV.val THEN
      shaper := ZChildVBT.ScaledHVFixed
    ELSE
      shaper := NIL
    END;
    IF at.val.edges THEN
      IF shaper = NIL THEN shaper := ZChildVBT.Scaled END;
      res := res.initFromEdges(
               ch, titleChild, at.val.w, at.val.e, at.val.n,
               at.val.s, state.shadow, NOT noClose.val, open.val,
               at.val.type, shaper)
    ELSE
      IF shaper = NIL THEN shaper := ZChildVBT.ScaledHVFixed END;
      res := res.init(ch, titleChild, state.shadow,
                      NOT noClose.val, open.val, at.val.h,
                      at.val.v, at.val.loc, at.val.type, shaper)
    END;
    AddNameProp(cl, res, name, state);
    RETURN res
  END pZChassis;

PROCEDURE <A NAME="pZChild"><procedure>pZChild</procedure></A> (         cl  : ParseClosure;
                   VAR      list: RefList.T;
                   READONLY s   : State         ): VBT.T
  RAISES {Error} =
  VAR
    state   := s;
    name    := NamePP();
    open    := NEW(BooleanPP, name := &quot;Open&quot;);
    at      := NEW(AtSpecPP, name := &quot;At&quot;);
    chain   := NEW(ChainsPP, name := &quot;Chain&quot;);
    scaled  := NEW(BooleanPP, name := &quot;Scaled&quot;);
    fixedH  := NEW(BooleanPP, name := &quot;FixedH&quot;);
    fixedV  := NEW(BooleanPP, name := &quot;FixedV&quot;);
    fixedHV := NEW(BooleanPP, name := &quot;FixedHV&quot;);
  VAR
    res   : FVZChild;
    ch    : VBT.T;
    shaper: ZSplit.ReshapeControl;
  BEGIN
    (* it's OK, because we may be inserting the form dynamically
       IF state.zsplit = NIL THEN RAISE Error (&quot;ZChild must be
       inside a ZSplit.&quot;) END; *)
    ParseProps(cl, list, state, PP3{name, at, chain},
               KP5{open, scaled, fixedH, fixedV, fixedHV});
    res := cl.fv.realize(&quot;ZChild&quot;, name.valname);
    state.zchild := res;
    ch := OneChild(cl, list, state);
    IF chain.shaper # NIL THEN
      shaper := chain.shaper
    ELSIF scaled.val THEN
      shaper := ZChildVBT.Scaled
    ELSIF fixedH.val THEN
      shaper := ZChildVBT.ScaledHFixed
    ELSIF fixedV.val THEN
      shaper := ZChildVBT.ScaledVFixed
    ELSIF fixedHV.val THEN
      shaper := ZChildVBT.ScaledHVFixed
    ELSE
      shaper := NIL
    END;
    IF at.val.edges THEN
      IF shaper = NIL THEN shaper := ZChildVBT.Scaled END;
      res := res.initFromEdges(
               ch, at.val.w, at.val.e, at.val.n, at.val.s,
               at.val.type, shaper, open.val)
    ELSE
      IF shaper = NIL THEN shaper := ZChildVBT.ScaledHVFixed END;
      res := res.init(ch, at.val.h, at.val.v, at.val.loc,
                      at.val.type, shaper, open.val)
    END;
    AddNameProp(cl, res, name, state);
    RETURN res
  END pZChild;

PROCEDURE <A NAME="pZGrow"><procedure>pZGrow</procedure></A> (         cl  : ParseClosure;
                  VAR      list: RefList.T;
                  READONLY s   : State         ): VBT.T
  RAISES {Error} =
  VAR
    state          := s;
    name           := NamePP();
    res  : FVZGrow;
    ch   : VBT.T;
  BEGIN
    ParseProps(cl, list, state, PP1{name});
    ch := OneChild(cl, list, state);
    res := cl.fv.realize(&quot;ZGrow&quot;, name.valname);
    res := res.init(
             NEW(ShadowedFeedbackVBT.T).init(ch, state.shadow));
    AddNameProp(cl, res, name, state);
    RETURN res
  END pZGrow;

PROCEDURE <A NAME="pZMove"><procedure>pZMove</procedure></A> (         cl  : ParseClosure;
                  VAR      list: RefList.T;
                  READONLY s   : State         ): VBT.T
  RAISES {Error} =
  VAR
    state          := s;
    name           := NamePP();
    res  : FVZMove;
    ch   : VBT.T;
  BEGIN
    ParseProps(cl, list, state, PP1{name});
    ch := OneChild(cl, list, state);
    res := cl.fv.realize(&quot;ZMove&quot;, name.valname);
    res := res.init(
             NEW(ShadowedFeedbackVBT.T).init(ch, state.shadow));
    AddNameProp(cl, res, name, state);
    RETURN res
  END pZMove;
</PRE> ============================ Video and Audio  =========================== 

<P><PRE>PROCEDURE <A NAME="pVideo"><procedure>pVideo</procedure></A> (         cl  : ParseClosure;
                  VAR      list: RefList.T;
                  READONLY s   : State         ): VBT.T
  RAISES {Error} =
  VAR
    state       := s;
    name        := NamePP();
    source      := NEW(TextPP, found := TRUE);
    quality     := NEW(CardinalPP, name := &quot;Quality&quot;, val := 8);
    colors      := NEW(CardinalPP, name := &quot;Colors&quot;, val := 50);
    width       := NEW(CardinalPP, name := &quot;Width&quot;, val := 640);
    height      := NEW(CardinalPP, name := &quot;Height&quot;, val := 480);
    synchronous := NEW(BooleanPP, name := &quot;Synchronous&quot;);
    msecs       := NEW(CardinalPP, name := &quot;MSecs&quot;);
    paused      := NEW(BooleanPP, name := &quot;Paused&quot;);
    fixed       := NEW(BooleanPP, name := &quot;FixedSize&quot;);

    res: FVVideo;
  BEGIN
    ParseProps(
      cl, list, state,
      PP7{name, source, quality, colors, width, height, msecs},
      KP3{synchronous, paused, fixed}, main := source);

    IF source.val = NIL OR Text.Empty(source.val) THEN
      RAISE Error(&quot;Video: must specify a source host name&quot;);
    END;
    IF quality.val &lt; FIRST(JVSink.Quality)
         OR LAST(JVSink.Quality) &lt; quality.val THEN
      RAISE Error(&quot;Video quality must be between 0 and 15&quot;);
    END;
    res := cl.fv.realize(&quot;Video&quot;, name.valname);
    res := res.init(
             source.val, quality.val, colors.val, width.val,
             height.val, synchronous.val, fixed.val, msecs.val);

    IF paused.val THEN res.setPaused(TRUE); END;

    AddNameProp(cl, res, name, state);
    RETURN res
  END pVideo;

PROCEDURE <A NAME="pAudio"><procedure>pAudio</procedure></A> (         cl  : ParseClosure;
                  VAR      list: RefList.T;
                  READONLY s   : State         ): VBT.T
  RAISES {Error} =
  VAR
    state         := s;
    name          := NamePP();
    source        := NEW(TextPP, name := &quot;Value&quot;);
    volume        := NEW(IntegerPP, name := &quot;Volume&quot;);
    mute          := NEW(BooleanPP, name := &quot;Mute&quot;);
    ignoreMapping := NEW(BooleanPP, name := &quot;IgnoreMapping&quot;);
    res: FVAudio;
  BEGIN
    ParseProps(cl, list, state, PP3{name, source, volume},
               KP2{mute, ignoreMapping});

    IF source.val = NIL OR Text.Empty(source.val) THEN
      RAISE Error(&quot;Audio: must specify a source host name&quot;);
    END;

    IF volume.val &lt; FIRST(Jva.Volume)
         OR LAST(Jva.Volume) &lt; volume.val THEN
      RAISE Error(Fmt.F(&quot;Audio: value must be in range [%s..%s]&quot;,
                        Fmt.Int(FIRST(Jva.Volume)),
                        Fmt.Int(LAST(Jva.Volume))));
    END;

    res := cl.fv.realize(&quot;Audio&quot;, name.valname);
    TRY
      EVAL res.init(OneChild(cl, list, state), source.val,
                    mute.val, ignoreMapping.val, volume.val);
    EXCEPT
    | OSError.E (e) =&gt;
        VAR etext := &quot;&quot;;
        BEGIN
          IF e # NIL AND e.head # NIL THEN
            etext := RdUtils.FailureText(e);
          END;
          RAISE Error(&quot;Audio: initialising &quot; &amp; etext);
        END;
    | Thread.Alerted =&gt; RAISE Error(&quot;Audio: Thread alerted&quot;);
    END;

    AddNameProp(cl, res, name, state);
    RETURN res
  END pAudio;
</PRE> ============================= IntApply  =============================== 

<P><PRE>PROCEDURE <A NAME="pIntApply"><procedure>pIntApply</procedure></A> (         cl  : ParseClosure;
                     VAR      list: RefList.T;
                     READONLY s   : State         ): VBT.T
  RAISES {Error} =
  VAR
    state                    := s;
    name                     := NamePP();
    forName                  := NEW(SymbolPP, name := &quot;For&quot;);
    propertyName             := NEW(TextPP, name := &quot;Property&quot;);
    res         : FVIntApply;
  BEGIN
    ParseProps(cl, list, state, PP3{name, forName, propertyName});
    IF forName = NIL OR Text.Empty(forName.valname) THEN
      RAISE Error(&quot;IntApply: must specify (For ...) property&quot;);
    END;
    res := cl.fv.realize(&quot;IntApply&quot;, name.valname);
    EVAL res.init(cl.fv, OneChild(cl, list, state),
                  forName.valname, propertyName.val);
    AddNameProp(cl, res, name, state);
    RETURN res;
  END pIntApply;
</PRE> ====================================================================== 
 Parsing routines for inherited properties (<CODE>states</CODE>) 
 ====================================================================== 

<P><PRE>PROCEDURE <A NAME="pMacro"><procedure>pMacro</procedure></A> (list: RefList.T; VAR state: State) RAISES {Error} =
  (* (Macro name [BOA] (formals) bq-expr) *)
  BEGIN
    WITH m    = Macro.Parse (list),
         pair = AssocQ (state.macros, list.head) DO
      IF pair # NIL THEN
        pair.tail.head := m
      ELSE
        Push (state.macros, RefList.List2 (list.head, m))
      END
    END
  END pMacro;
</PRE> Follow the guidelines in Kobara's book on Motif.  Nice background colors
   have RGB components that are each between 155 and 175 on a scale of 0-255.
   If the color is in that range, then the LightShadow should be computed <CODE>by
   multiplying the background color R, G, and B numbers each by 1.50</CODE>.  Well,
   that arithmetic isn't quite right; 175 * 1.50 &gt; 255.  So we just scale
   linearly so that 175 comes out at 0.95 (<CODE>not quite hitting white</CODE>).
   Likewise, the DarkShadow should be computed by multiplying the BgColor
   values by 0.5.  The values in an RGB will be <CODE>gamma-corrected</CODE>
   by Trestle, so we use <CODE>true RGB</CODE> values here. 
   
<P><PRE>CONST
  rgb155      = 155.0 / 255.0;
  rgb175      = 175.0 / 255.0;
  scaleLight  = 0.95 / rgb175;
  scaleDark   = 0.5;

PROCEDURE <A NAME="pBgColor"><procedure>pBgColor</procedure></A> (list: RefList.T; VAR state: State)
  RAISES {Error} =
  VAR
    r     := ColorRGB(list, PaintOp.BW.UseBg);
    red   := r.rgb.r;
    green := r.rgb.g;
    blue  := r.rgb.b;
    nice  := TRUE;
  BEGIN
    state.bgRGB := r.rgb;
    state.bgOp := r.op;
    nice := nice AND rgb155 &lt;= red AND red &lt;= rgb175;
    nice := nice AND rgb155 &lt;= green AND green &lt;= rgb175;
    nice := nice AND rgb155 &lt;= blue AND blue &lt;= rgb175;
    IF nice THEN
      state.darkRGB.r := red * scaleDark;
      state.darkRGB.g := green * scaleDark;
      state.darkRGB.b := blue * scaleDark;
      state.lightRGB.r := red * scaleLight;
      state.lightRGB.g := green * scaleLight;
      state.lightRGB.b := blue * scaleLight;
      state.lightOp :=
        PaintOp.FromRGB(
          state.lightRGB.r, state.lightRGB.g, state.lightRGB.b,
          PaintOp.Mode.Accurate, -1.0, PaintOp.BW.UseFg);
      state.darkOp :=
        PaintOp.FromRGB(
          state.darkRGB.r, state.darkRGB.g, state.darkRGB.b,
          PaintOp.Mode.Accurate, -1.0, PaintOp.BW.UseFg)
    END;
    state.shadow :=
      Shadow.New(state.shadowSz, state.bgOp, state.fgOp,
                 state.lightOp, state.darkOp)
  END pBgColor;

PROCEDURE <A NAME="pColor"><procedure>pColor</procedure></A> (list: RefList.T; VAR state: State) RAISES {Error} =
  BEGIN
    WITH r = ColorRGB (list) DO state.fgRGB := r.rgb; state.fgOp := r.op END;
    state.shadow := Shadow.New (state.shadowSz, state.bgOp, state.fgOp,
                                state.lightOp, state.darkOp)
  END pColor;

PROCEDURE <A NAME="pLightShadow"><procedure>pLightShadow</procedure></A> (list: RefList.T; VAR state: State) RAISES {Error} =
  BEGIN
    WITH r = ColorRGB (list) DO
      state.lightRGB := r.rgb;
      state.lightOp := r.op
    END;
    state.shadow := Shadow.New (state.shadowSz, state.bgOp, state.fgOp,
                                state.lightOp, state.darkOp)
  END pLightShadow;

PROCEDURE <A NAME="pDarkShadow"><procedure>pDarkShadow</procedure></A> (list: RefList.T; VAR state: State) RAISES {Error} =
  BEGIN
    WITH r = ColorRGB (list) DO
      state.darkRGB := r.rgb;
      state.darkOp := r.op
    END;
    state.shadow := Shadow.New (state.shadowSz, state.bgOp, state.fgOp,
                                state.lightOp, state.darkOp)
  END pDarkShadow;

EXCEPTION BadColorSpec;         (* internal *)

TYPE RgbOp = RECORD rgb: Color.T; op: PaintOp.T END;

VAR
  qRGB := Atom.FromText (&quot;RGB&quot;);
  qHSV := Atom.FromText (&quot;HSV&quot;);

PROCEDURE <A NAME="ColorRGB"><procedure>ColorRGB</procedure></A> (list: RefList.T; bw := PaintOp.BW.UseFg): RgbOp
  RAISES {Error} =
  VAR
    original                         := list;
    res     : RgbOp;
    rep                              := qRGB;
    vals    : ARRAY [0 .. 2] OF REAL;
  BEGIN
    TRY
      IF list = NIL THEN RAISE BadColorSpec END;
      TYPECASE list.head OF
      | NULL =&gt; RAISE BadColorSpec
      | TEXT (t) =&gt;
          IF list.tail # NIL THEN RAISE BadColorSpec END;
          res.rgb := ColorName.ToRGB (t)
      | REFANY =&gt;
          IF RefList.Length (list) = 4 THEN
            TYPECASE Pop (list) OF
            | NULL =&gt; RAISE BadColorSpec
            | Atom.T (s) =&gt;
                IF s = qRGB OR s = qHSV THEN
                  rep := s
                ELSE
                  RAISE BadColorSpec
                END
            ELSE
              RAISE BadColorSpec
            END
          END;
          IF RefList.Length (list) # 3 THEN RAISE BadColorSpec END;
          FOR i := 0 TO 2 DO
            TYPECASE Pop (list) OF
            | NULL =&gt; RAISE BadColorSpec
            | REF INTEGER (ri) =&gt;
                IF ri^ = 0 THEN
                  vals [i] := 0.0
                ELSIF ri^ = 1 THEN
                  vals [i] := 1.0
                ELSE
                  RAISE BadColorSpec
                END
            | REF REAL (rr) =&gt; vals [i] := rr^
            ELSE
              RAISE BadColorSpec
            END
          END;
          IF rep = qHSV THEN
            res.rgb :=
              Color.FromHSV (Color.HSV {vals [0], vals [1], vals [2]})
          ELSE
            res.rgb := Color.T {vals [0], vals [1], vals [2]};
          END;
      END;
      res.op := PaintOp.FromRGB (res.rgb.r, res.rgb.g, res.rgb.b,
                                 PaintOp.Mode.Accurate, -1.0, bw)
    EXCEPT
    | BadColorSpec =&gt;
        Gripe (&quot;Illegal color-spec: &quot;, original); &lt;* ASSERT FALSE *&gt;
    | ColorName.NotFound =&gt;
        Gripe (&quot;No such color: &quot;, original); &lt;* ASSERT FALSE *&gt;
    END;
    RETURN res
  END ColorRGB;

PROCEDURE <A NAME="pFont"><procedure>pFont</procedure></A> (list: RefList.T; VAR state: State) RAISES {Error} =
  BEGIN
    IF RefList.Length (list) = 1 AND ISTYPE (list.head, TEXT) THEN
      state.fontName := OneText (list)
    ELSE
      state.fontMetrics :=
        ParseFont (list, state.fontMetrics, DefaultFontMetrics);
      state.fontName := MetricsToName (state.fontMetrics)
    END;
    state.font := FVRuntime.FindFont (state.fontName)
  END pFont;

PROCEDURE <A NAME="pLabelFont"><procedure>pLabelFont</procedure></A> (list: RefList.T; VAR state: State) RAISES {Error} =
  BEGIN
    IF RefList.Length (list) = 1 AND ISTYPE (list.head, TEXT) THEN
      state.labelFontName := OneText (list)
    ELSE
      state.labelFontMetrics :=
        ParseFont (list, state.labelFontMetrics, DefaultLabelFontMetrics);
      state.labelFontName := MetricsToName (state.labelFontMetrics)
    END;
    state.labelFont := FindFont (state.labelFontName)
  END pLabelFont;

PROCEDURE <A NAME="MetricsToName"><procedure>MetricsToName</procedure></A> (metrics: RefList.T): TEXT =
  VAR
    wr           := TextWr.New ();
    pair: RefList.T;
  &lt;* FATAL Wr.Failure, Thread.Alerted *&gt;
  BEGIN
    FOR i := 0 TO LAST (MetricsProcs) DO
      Wr.PutChar (wr, '-');
      pair := AssocQ (metrics, MetricsProcs [i].symname);
      IF pair = NIL THEN
        Wr.PutChar (wr, '*')
      ELSE
        Wr.PutText (wr, pair.tail.head)
      END
    END;
    RETURN TextWr.ToText (wr)
  END MetricsToName;

PROCEDURE <A NAME="ParseFont"><procedure>ParseFont</procedure></A> (alist, metrics, default: RefList.T): RefList.T
  RAISES {Error} =
  VAR n: INTEGER;
  PROCEDURE gripe (x: REFANY) RAISES {Error} =
    BEGIN
      Gripe (&quot;Bad font-spec: &quot;, x)
    END gripe;
  BEGIN
    WHILE alist # NIL DO
      TYPECASE Pop (alist) OF
      | NULL =&gt; gripe (NIL)
      | Atom.T (sym) =&gt;
          IF sym = qReset THEN
            metrics := RefList.Append (default, metrics)
          ELSE
            gripe (sym)
          END
      | RefList.T (pair) =&gt;
          TYPECASE pair.head OF
          | NULL =&gt; gripe (pair)
          | Atom.T (sym) =&gt;
              IF MetricsNameTable.get (sym, n) THEN
                MetricsProcs [n].proc (sym, pair.tail, metrics)
              ELSE
                gripe (pair)
              END
          | REFANY =&gt; gripe (pair)
          END
      | REFANY (r) =&gt; gripe (r)
      END
    END;
    RETURN metrics
  END ParseFont;

PROCEDURE <A NAME="mText"><procedure>mText</procedure></A> (sym: Atom.T; arglist: RefList.T; VAR metrics: RefList.T)
  RAISES {Error} =
  BEGIN
    Push (metrics, RefList.List2 (sym, OneText (arglist)))
  END mText;

PROCEDURE <A NAME="mCardinal"><procedure>mCardinal</procedure></A> (sym: Atom.T; arglist: RefList.T; VAR metrics: RefList.T)
  RAISES {Error} =
  BEGIN
    IF RefList.Length (arglist) = 1 THEN (* gripe *)
      TYPECASE arglist.head OF
      | NULL =&gt;                 (* gripe *)
      | TEXT (t) =&gt;
          IF Text.Equal (t, &quot;*&quot;) THEN
            Push (metrics, RefList.List2 (sym, t));
            RETURN
          END
      | REF INTEGER (ri) =&gt;
          IF ri^ &gt;= 0 THEN
            Push (metrics, RefList.List2 (sym, Fmt.Int (ri^)));
            RETURN
          END
      ELSE                      (* gripe *)
      END
    END;
    Gripe (&quot;Bad font-spec: &quot;, arglist); &lt;* ASSERT FALSE *&gt;
  END mCardinal;

PROCEDURE <A NAME="pShadowSize"><procedure>pShadowSize</procedure></A> (list: RefList.T; VAR state: State) RAISES {Error} =
  BEGIN
    state.shadowSz := Pts.ToMM(OneReal (list));
    state.shadow := Shadow.New (state.shadowSz, state.bgOp, state.fgOp,
                                state.lightOp, state.darkOp)
  END pShadowSize;
</PRE> ====================================================================== 
 Parsing routines for local properties 
 ====================================================================== 

<P><PRE>TYPE
  PP = OBJECT                   (* Property pair *)
         name  := &quot;Main&quot;;
         found := FALSE
       METHODS
         set (form: RefList.T) RAISES {Error}
       END;
  KP0 = ARRAY [0 .. -1] OF BooleanPP;
  KP1 = ARRAY [0 .. 0] OF BooleanPP;
  KP2 = ARRAY [0 .. 1] OF BooleanPP;
  KP3 = ARRAY [0 .. 2] OF BooleanPP;
  KP4 = ARRAY [0 .. 3] OF BooleanPP;
  KP5 = ARRAY [0 .. 4] OF BooleanPP;
  KP6 = ARRAY [0 .. 5] OF BooleanPP;
  KP7 = ARRAY [0 .. 6] OF BooleanPP;

  PP0 = ARRAY [0 .. -1] OF PP;
  PP1 = ARRAY [0 .. 0] OF PP;
  PP2 = ARRAY [0 .. 1] OF PP;
  PP3 = ARRAY [0 .. 2] OF PP;
  PP4 = ARRAY [0 .. 3] OF PP;
  PP5 = ARRAY [0 .. 4] OF PP;
  PP6 = ARRAY [0 .. 5] OF PP;
  PP7 = ARRAY [0 .. 6] OF PP;

  EP0 = ARRAY [0 .. -1] OF EnumPP;
  EP1 = ARRAY [0 .. 0] OF EnumPP;
  EP2 = ARRAY [0 .. 1] OF EnumPP;

PROCEDURE <A NAME="ParseProps"><procedure>ParseProps</procedure></A> (         cl   : ParseClosure;
                      VAR      list : RefList.T;
                      VAR      state: State;
                      READONLY props: ARRAY OF PP        := PP0 {};
                      READONLY keys : ARRAY OF BooleanPP := KP0 {};
                               main : PP                 := NIL;
                      READONLY enums: ARRAY OF EnumPP    := EP0 {}  )
  RAISES {Error} =
  (* This is where we parse the properties in a component-list.  We keep
     scanning items until we reach something that isn't a known property.  The
     component-parser that called us is responsible for parsing all the
     remaining items on the list. *)
  VAR copy := list;
  BEGIN
    WHILE list # NIL DO
      copy := list;
      list := ParseProp (cl, list, state, props, keys, main, enums);
      IF list = copy THEN EXIT END
    END;
    IF main = NIL THEN          (* skip *)
    ELSIF list # NIL THEN
      main.set (list);
      list := NIL
    ELSIF NOT main.found THEN
      RAISE Error (&quot;Missing Main property&quot;)
    END;
    (* Make sure they picked one in each enumeration. *)
    FOR i := FIRST (enums) TO LAST (enums) DO
      IF enums [i].chosen # -1 THEN (* skip *)
      ELSIF NOT enums [i].choices [enums [i].default].found THEN
        enums [i].choices [enums [i].default].val := TRUE;
        enums [i].chosen := enums [i].default
      ELSE
        Gripe (&quot;Default marked #False, but no alternative was selected: &quot;,
               enums [i].choices [enums [i].default].name); &lt;* ASSERT FALSE *&gt;
      END
    END
  END ParseProps;

PROCEDURE <A NAME="ParseProp"><procedure>ParseProp</procedure></A> (         cl   : ParseClosure;
                     VAR      list : RefList.T;
                     VAR      state: State;
                     READONLY props: ARRAY OF PP;
                     READONLY keys : ARRAY OF BooleanPP;
                              main : PP;
                     READONLY enums: ARRAY OF EnumPP     ): RefList.T
  RAISES {Error} =
  VAR sProc: StateProc; symname: TEXT;
  BEGIN
    TYPECASE list.head OF
    | NULL =&gt;
    | Atom.T (sym) =&gt;            (* Is it a &quot;keyword&quot;, like MenuStyle? *)
        symname := Atom.ToText (sym);
        FOR i := FIRST (keys) TO LAST (keys) DO
          IF Text.Equal (symname, keys [i].name) THEN
            keys [i].val := TRUE;
            keys [i].found := TRUE;
            RETURN list.tail
          END
        END;
        (* It might be an enumeration keyword. *)
        FOR i := FIRST (enums) TO LAST (enums) DO
          FOR j := FIRST (enums [i].choices^) TO LAST (enums [i].choices^) DO
            IF Text.Equal (symname, enums [i].choices [j].name) THEN
              IF enums [i].chosen # -1 THEN
                Gripe (&quot;Contradictory choices: &quot;,
                       enums [i].choices [j].name &amp; &quot; &quot;
                         &amp; enums [i].choices [enums [i].chosen].name);
                &lt;* ASSERT FALSE *&gt;
              ELSE
                enums [i].choices [j].val := TRUE;
                enums [i].choices [j].found := TRUE;
                enums [i].chosen := j;
                RETURN list.tail
              END
            END
          END
        END
      (* If it's not a keyword, it might be a symbol-component (Bar or
         Fill) *)
    | RefList.T (form) =&gt;
        TYPECASE Pop (form) OF
        | NULL =&gt;
        | Atom.T (sym) =&gt;
            (* Is it specific to this component?  E.g., (Height ...) *)
            symname := Atom.ToText (sym);
            FOR i := FIRST (props) TO LAST (props) DO
              IF Text.Equal (symname, props [i].name) THEN
                props [i].set (form); (* parse and set *)
                props [i].found := TRUE;
                RETURN list.tail
              END
            END;
            (* Is it a state like (BgColor ...)? *)
            sProc := FindStateProc (sym);
            IF sProc # NIL THEN sProc (form, state); RETURN list.tail END;
            (* Is it a macro?  Expand and re-test. *)
            WITH m = MacroFunction (sym, state) DO
              IF m # NIL THEN
                RETURN RefList.Cons (m.apply (form), list.tail)
              END
            END;
            (* Is it a Boolean for this component?  E.g., (Flex #True ...) *)
            FOR i := FIRST (keys) TO LAST (keys) DO
              IF Text.Equal (symname, keys [i].name) THEN
                keys [i].val := OneBoolean (form);
                keys [i].found := TRUE;
                RETURN list.tail
              END
            END;
            (* Is it an enumeration keyword? *)
            FOR i := FIRST (enums) TO LAST (enums) DO
              FOR j := FIRST (enums [i].choices^)
                  TO LAST (enums [i].choices^) DO
                IF Text.Equal (symname, enums [i].choices [j].name) THEN
                  enums [i].choices [j].found := TRUE;
                  IF OneBoolean (form) THEN
                    IF enums [i].chosen # -1 THEN
                      Gripe (&quot;Contradictory choices: &quot;,
                             enums [i].choices [j].name &amp; &quot; &quot;
                               &amp; enums [i].choices [enums [i].chosen].name);
                      &lt;* ASSERT FALSE *&gt;
                    ELSE
                      enums [i].choices [j].val := TRUE;
                      enums [i].chosen := j;
                      RETURN list.tail
                    END
                  ELSIF enums [i].chosen = j THEN
                    enums [i].choices [j].val := FALSE;
                    enums [i].chosen := -1;
                    RETURN list.tail
                  ELSE
                    RETURN list.tail
                  END
                END
              END
            END;
            (* Is it (Main ...)? *)
            IF main # NIL AND sym = qMain THEN
              main.set (form);
              main.found := TRUE;
              RETURN list.tail
            END;
            (* Is it Insert? *)
            IF sym = qInsert THEN
              RETURN RefList.AppendD (
                       InsertFile (OneText (form), cl.fv.path), list.tail)
            END
          (* It must a component like (HBox ...). *)
        ELSE
        END
    ELSE
    END;
    RETURN list
  END ParseProp;

TYPE
  AtSpecPP = PP OBJECT
               val: RECORD
                      h, v, w, e, n, s := 0.5;
                      loc              := ZChildVBT.Location.Center;
                      type             := ZChildVBT.CoordType.Scaled;
                      edges            := FALSE
                    END
             OVERRIDES
               set := SetAtSpecPP
             END;
  BooleanPP = PP OBJECT val := FALSE OVERRIDES set := SetBooleanPP END;
  CardinalPP =
    PP OBJECT val: CARDINAL := 0 OVERRIDES set := SetCardinalPP END;
  CardinalListPP =
    PP OBJECT val: RefList.T := NIL OVERRIDES set := SetCardinalListPP END;
  ChainsPP =
    PP OBJECT
      shaper: ZSplit.ReshapeControl;
    OVERRIDES
      set := SetChainsPP
    END;
  EnumPP =
    PP OBJECT
      choices: REF ARRAY OF BooleanPP;
      chosen : [-1 .. LAST (CARDINAL)]  := -1;
      default: CARDINAL                 := 0
    METHODS
      init (READONLY a: ARRAY OF BooleanPP; default: CARDINAL): EnumPP
        := InitEnumPP
    END;
  IntegerPP = PP OBJECT val := 0 OVERRIDES set := SetIntegerPP END;
  RealPP = PP OBJECT val := 0.0 OVERRIDES set := SetRealPP END;
  SizeRangePP =
    PP OBJECT val := FlexVBT.DefaultRange OVERRIDES set := SetSizeRangePP END;
  SymbolPP = PP OBJECT
               val    : Atom.T := NIL;
               valname: TEXT   := &quot;&quot;
             OVERRIDES
               set := SetSymbolPP
             END;
  TextPP = PP OBJECT val: TEXT := NIL OVERRIDES set := SetTextPP END;
  TextListPP =
    PP OBJECT val: RefList.T := NIL OVERRIDES set := SetTextListPP END;
  VBTPP = PP OBJECT val: RefList.T := NIL;  OVERRIDES set := SetVBTPP END;

PROCEDURE <A NAME="InitEnumPP"><procedure>InitEnumPP</procedure></A> (         pp     : EnumPP;
                      READONLY a      : ARRAY OF BooleanPP;
                               default: CARDINAL            ): EnumPP =
  BEGIN
    pp.choices := NEW (REF ARRAY OF BooleanPP, NUMBER (a));
    pp.choices^ := a;
    pp.default := default;
    RETURN pp
  END InitEnumPP;

PROCEDURE <A NAME="SetSymbolPP"><procedure>SetSymbolPP</procedure></A> (pp: SymbolPP; form: RefList.T) RAISES {Error} =
  BEGIN
    pp.val := OneSymbol (form);
    pp.valname := Atom.ToText (pp.val)
  END SetSymbolPP;

PROCEDURE <A NAME="SetBooleanPP"><procedure>SetBooleanPP</procedure></A> (pp: BooleanPP; form: RefList.T) RAISES {Error} =
  BEGIN
    pp.val := OneBoolean (form)
  END SetBooleanPP;

PROCEDURE <A NAME="SetIntegerPP"><procedure>SetIntegerPP</procedure></A> (pp: IntegerPP; form: RefList.T) RAISES {Error} =
  BEGIN
    pp.val := OneInteger (form)
  END SetIntegerPP;

PROCEDURE <A NAME="SetRealPP"><procedure>SetRealPP</procedure></A> (pp: RealPP; form: RefList.T) RAISES {Error} =
  BEGIN
    pp.val := OneReal (form)
  END SetRealPP;

PROCEDURE <A NAME="SetCardinalPP"><procedure>SetCardinalPP</procedure></A> (pp: CardinalPP; form: RefList.T) RAISES {Error} =
  BEGIN
    pp.val := OneCardinal (form)
  END SetCardinalPP;

PROCEDURE <A NAME="SetCardinalListPP"><procedure>SetCardinalListPP</procedure></A> (pp: CardinalListPP; form: RefList.T)
  RAISES {Error} =
  PROCEDURE cardinalp (ref: REFANY): BOOLEAN =
    BEGIN
      TYPECASE ref OF
      | NULL =&gt; RETURN FALSE
      | REF INTEGER (ri) =&gt; RETURN ri^ &gt;= 0
      ELSE
        RETURN FALSE
      END
    END cardinalp;
  BEGIN
    pp.val := ListOfType (form, cardinalp, &quot;cardinals &quot;)
  END SetCardinalListPP;

PROCEDURE <A NAME="SetTextListPP"><procedure>SetTextListPP</procedure></A> (pp: TextListPP; form: RefList.T) RAISES {Error} =
  PROCEDURE textp (ref: REFANY): BOOLEAN =
    BEGIN
      RETURN ISTYPE (ref, TEXT)
    END textp;
  BEGIN
    pp.val := ListOfType (form, textp, &quot;texts &quot;)
  END SetTextListPP;

PROCEDURE <A NAME="ListOfType"><procedure>ListOfType</procedure></A> (form: RefList.T;
                      p   : (PROCEDURE (ref: REFANY): BOOLEAN);
                      name: TEXT                                ): RefList.T
  RAISES {Error} =
  PROCEDURE every (l: RefList.T): BOOLEAN =
    BEGIN
      WHILE l # NIL DO IF NOT p (Pop (l)) THEN RETURN FALSE END END;
      RETURN TRUE
    END every;
  BEGIN
    (** Allow form to be (1 2 3 ...) or ((1 2 3 ...)),
        since =(1 2 3) is read as (Value (1 2 3)), which is
        the same as (Value 1 2 3). *)
    IF every (form) THEN RETURN form END;
    TYPECASE form.head OF
    | RefList.T (l) =&gt; IF form.tail = NIL AND every (l) THEN RETURN l END
    ELSE
    END;
    Gripe (&quot;Bad list of &quot; &amp; name, form); &lt;* ASSERT FALSE *&gt;
  END ListOfType;

EXCEPTION BadAtSpec;

PROCEDURE <A NAME="SetAtSpecPP"><procedure>SetAtSpecPP</procedure></A> (pp: AtSpecPP; form: RefList.T)
  RAISES {Error} =
  VAR
    n       : ARRAY [0 .. 1] OF REAL;
    original := form;
    len   := RefList.Length (form);
    gotCoordType := FALSE;
  PROCEDURE pct (x: REAL) RAISES {BadAtSpec} =
    BEGIN IF x &lt; 0.0 OR 1.0 &lt; x THEN RAISE BadAtSpec END END pct;
  PROCEDURE ispct (x: REAL): BOOLEAN =
    BEGIN RETURN x &gt;= 0.0 AND x &lt;= 1.0 END ispct;
  PROCEDURE check () RAISES {BadAtSpec} =
    BEGIN
      IF form # NIL THEN RAISE BadAtSpec END;
      IF NOT gotCoordType THEN
        pp.val.type := ZChildVBT.CoordType.Absolute;
        IF pp.val.edges THEN
           IF ispct(pp.val.w) AND ispct(pp.val.e) AND
              ispct(pp.val.n) AND ispct(pp.val.s) THEN
                pp.val.type := ZChildVBT.CoordType.Scaled
           END
        ELSE
           IF ispct(pp.val.h) AND ispct(pp.val.v) THEN
                pp.val.type := ZChildVBT.CoordType.Scaled
           END
        END
      END;
      IF pp.val.type = ZChildVBT.CoordType.Absolute THEN
        IF pp.val.edges THEN
          pp.val.w := Pts.ToMM (pp.val.w);
          pp.val.e := Pts.ToMM (pp.val.e);
          pp.val.n := Pts.ToMM (pp.val.n);
          pp.val.s := Pts.ToMM (pp.val.s)
        ELSE
          pp.val.h := Pts.ToMM (pp.val.h);
          pp.val.v := Pts.ToMM (pp.val.v)
        END
      ELSE
        IF pp.val.edges THEN
          pct (pp.val.w);
          pct (pp.val.e);
          pct (pp.val.n);
          pct (pp.val.s)
        ELSE
          pct (pp.val.h);
          pct (pp.val.v)
        END
      END
    END check;
  BEGIN
    TRY
      pp.val.type := ZChildVBT.CoordType.Absolute;
      IF len &lt; 2 OR len &gt; 5 THEN RAISE BadAtSpec END;
      FOR i := 0 TO 1 DO
        TYPECASE Pop (form) OF
        | NULL =&gt; RAISE BadAtSpec
        | REF INTEGER (ri) =&gt; n [i] := FLOAT (ri^)
        | REF REAL (rr) =&gt; n [i] := rr^
        ELSE
          RAISE BadAtSpec
        END
      END;
      pp.val.h := n [0];
      pp.val.v := n [1];
      IF form = NIL THEN check (); RETURN END;
      TYPECASE Pop (form) OF
      | NULL =&gt; RAISE BadAtSpec
      | Atom.T (s) =&gt;
          IF GetLocation (s, pp.val.loc) THEN
            IF form # NIL THEN
              IF GetCoordType (Pop (form), pp.val.type) THEN
                gotCoordType := TRUE
              ELSE RAISE BadAtSpec END
            END
          ELSIF GetCoordType (s, pp.val.type) THEN gotCoordType := TRUE
          ELSE RAISE BadAtSpec END;
          check ();
          RETURN
      | REF INTEGER (ri) =&gt; pp.val.n := FLOAT (ri^)
      | REF REAL (rr) =&gt; pp.val.n := rr^
      ELSE
        RAISE BadAtSpec
      END;
      IF form = NIL THEN RAISE BadAtSpec END;
      pp.val.edges := TRUE;
      pp.val.w := n [0];
      pp.val.e := n [1];
      TYPECASE Pop (form) OF
      | NULL =&gt; RAISE BadAtSpec
      | REF INTEGER (ri) =&gt; pp.val.s := FLOAT (ri^)
      | REF REAL (rr) =&gt; pp.val.s := rr^
      ELSE RAISE BadAtSpec
      END;
      IF form # NIL THEN
        IF GetCoordType (Pop (form), pp.val.type) THEN gotCoordType := TRUE
        ELSE RAISE BadAtSpec END;
      END;
      check ()
    EXCEPT
    | BadAtSpec =&gt;
        Gripe (&quot;Bad 'At' spec: &quot;, original); &lt;* ASSERT FALSE *&gt;
    END
  END SetAtSpecPP;

VAR
  Locations := ARRAY ZChildVBT.Location OF
                 Atom.T {Atom.FromText (&quot;NW&quot;),
                             Atom.FromText (&quot;NE&quot;),
                             Atom.FromText (&quot;SW&quot;),
                             Atom.FromText (&quot;SE&quot;),
                             Atom.FromText (&quot;Center&quot;)};

PROCEDURE <A NAME="GetLocation"><procedure>GetLocation</procedure></A> (s: Atom.T; VAR loc: ZChildVBT.Location):
  BOOLEAN =
  BEGIN
    FOR i := FIRST (Locations) TO LAST (Locations) DO
      IF s = Locations [i] THEN loc := i; RETURN TRUE END
    END;
    RETURN FALSE
  END GetLocation;

VAR
  CoordTypes := ARRAY ZChildVBT.CoordType OF Atom.T {
                  Atom.FromText (&quot;Absolute&quot;),
                  Atom.FromText (&quot;Relative&quot;)};

PROCEDURE <A NAME="GetCoordType"><procedure>GetCoordType</procedure></A> (x: REFANY; VAR type: ZChildVBT.CoordType):
  BOOLEAN =
  BEGIN
    TYPECASE x OF
    | NULL =&gt;
    | Atom.T (s) =&gt;
        FOR i := FIRST (CoordTypes) TO LAST (CoordTypes) DO
          IF s = CoordTypes [i] THEN type := i; RETURN TRUE END
        END
    ELSE
    END;
    RETURN FALSE
  END GetCoordType;

PROCEDURE <A NAME="SetChainsPP"><procedure>SetChainsPP</procedure></A> (pp: ChainsPP; form: RefList.T) RAISES {Error} =
  BEGIN
    pp.shaper := NEW(ZSplit.ChainReshapeControl, chains := ChainSet (form));
  END SetChainsPP;

PROCEDURE <A NAME="ChainSet"><procedure>ChainSet</procedure></A> (VAR list: RefList.T): ZSplit.ChainSet
    RAISES {Error} =
  VAR chain: ZSplit.Ch;
    chainSet := ZSplit.ChainSet{};
  BEGIN
    WHILE RefList.Length (list) # 0 DO
      IF GetChain (Pop(list), chain) THEN
        chainSet := chainSet + ZSplit.ChainSet{chain};
      ELSE
        Gripe (&quot;Unknown side for chaining&quot;, list)
      END
    END;
    RETURN chainSet
  END ChainSet;

VAR
  Chains := ARRAY ZSplit.Ch OF
                 Atom.T {Atom.FromText (&quot;W&quot;),
                             Atom.FromText (&quot;E&quot;),
                             Atom.FromText (&quot;N&quot;),
                             Atom.FromText (&quot;S&quot;)};

PROCEDURE <A NAME="GetChain"><procedure>GetChain</procedure></A> (s: Atom.T; VAR ch: ZSplit.Ch):
  BOOLEAN =
  BEGIN
    FOR i := FIRST (Chains) TO LAST (Chains) DO
      IF s = Chains [i] THEN ch := i; RETURN TRUE END
    END;
    RETURN FALSE
  END GetChain;

PROCEDURE <A NAME="SetSizeRangePP"><procedure>SetSizeRangePP</procedure></A> (pp: SizeRangePP; form: RefList.T) RAISES {Error} =
  BEGIN
    pp.val := SizeRange (form)
  END SetSizeRangePP;

EXCEPTION BadSize;

PROCEDURE <A NAME="SizeRange"><procedure>SizeRange</procedure></A> (VAR list: RefList.T): FlexVBT.SizeRange
  RAISES {Error} =
  VAR
    size     := FlexVBT.DefaultRange;
    original := list;
  BEGIN
    TRY
      IF list = NIL THEN RAISE BadSize END;
      GetNatural (list, size);
      IF RefList.Length (list) = 4 THEN GetStretchOrShrink (list, size); END;
      IF RefList.Length (list) = 2 THEN GetStretchOrShrink (list, size); END;
      IF RefList.Length (list) # 0 THEN RAISE BadSize END;
      RETURN size;
    EXCEPT
    | BadSize =&gt; Gripe (&quot;Illegal size&quot;, original); &lt;* ASSERT FALSE *&gt;
    END;
  END SizeRange;

PROCEDURE <A NAME="GetNatural"><procedure>GetNatural</procedure></A> (VAR list: RefList.T;
                      VAR size: FlexVBT.SizeRange)
  RAISES {BadSize} =
  BEGIN
    TYPECASE list.head OF
    | NULL =&gt; RAISE BadSize
    | REF REAL, REF INTEGER =&gt;
        size.natural := Pts.ToMM(GetNum(list));
    ELSE
      (* no leading number *)
    END;
  END GetNatural;

PROCEDURE <A NAME="GetStretchOrShrink"><procedure>GetStretchOrShrink</procedure></A> (VAR list: RefList.T;
                              VAR size: FlexVBT.SizeRange)
  RAISES {BadSize} =
  BEGIN
    TYPECASE Pop(list) OF
    | NULL =&gt; RAISE BadSize
    | Atom.T (sym) =&gt;
        IF sym = qPlus THEN
          size.stretch := Pts.ToMM(GetNum(list, TRUE));
        ELSIF sym = qMinus THEN
          size.shrink := Pts.ToMM(GetNum(list, TRUE));
        ELSE
          RAISE BadSize
        END
    ELSE
      RAISE BadSize
    END
  END GetStretchOrShrink;

VAR
  Infinities := ARRAY [0 .. 5] OF
                  Atom.T {
                  Atom.FromText (&quot;Inf&quot;), Atom.FromText (&quot;inf&quot;),
                  Atom.FromText (&quot;INF&quot;), Atom.FromText (&quot;Infinity&quot;),
                  Atom.FromText (&quot;infinity&quot;), Atom.FromText (&quot;INFINITY&quot;)};

PROCEDURE <A NAME="GetNum"><procedure>GetNum</procedure></A> (VAR list        : RefList.T;
                      infOK       : BOOLEAN     := FALSE;
                      positiveOnly: BOOLEAN     := TRUE   ): REAL
  RAISES {BadSize} =
  BEGIN
    TYPECASE Pop(list) OF
    | NULL =&gt;
    | REF REAL (rr) =&gt;
        IF positiveOnly AND rr^ &lt; 0.0 THEN RAISE BadSize END;
        RETURN rr^
    | REF INTEGER (ri) =&gt;
        IF positiveOnly AND ri^ &lt; 0 THEN RAISE BadSize END;
        RETURN FLOAT(ri^)
    | Atom.T (sym) =&gt;
        IF NOT infOK THEN RAISE BadSize END;
        FOR i := FIRST(Infinities) TO LAST(Infinities) DO
          IF sym = Infinities[i] THEN RETURN FlexVBT.Infinity END
        END
    ELSE
    END;
    RAISE BadSize
  END GetNum;

PROCEDURE <A NAME="SetVBTPP"><procedure>SetVBTPP</procedure></A> (pp: VBTPP; form: RefList.T) =
  BEGIN
    pp.val := form
  END SetVBTPP;
</PRE><P>
  VAR
    state := pp.state;
    name  := NamePP ();
  BEGIN
    ParseProps (form, state, PP1 {name});
    pp.val := OneChild (pp.cl, form, state);
    AddNameProp (pp.cl, pp.val, name, state)
  END SetVBTPP;


<P><PRE>PROCEDURE <A NAME="OneChild"><procedure>OneChild</procedure></A> (         cl   : ParseClosure;
                             list : RefList.T;
                    READONLY state: State         ): VBT.T
  RAISES {Error} =
  BEGIN
    IF list = NIL THEN
      Gripe(&quot;A component is required here&quot;, &quot;&quot;); &lt;* ASSERT FALSE *&gt;
    ELSIF list.tail # NIL THEN
      Gripe(Fmt.F(&quot;A single component is required here: %s&quot;,
                  ToText(list, maxDepth := 3, maxLength := 4)));
      &lt;* ASSERT FALSE *&gt;
    ELSE
      RETURN Item(cl, Pop(list), state)
    END
  END OneChild;

PROCEDURE <A NAME="SetTextPP"><procedure>SetTextPP</procedure></A> (pp: TextPP; form: RefList.T) RAISES {Error} =
  BEGIN
    pp.val := OneText (form)
  END SetTextPP;

PROCEDURE <A NAME="AddChildren"><procedure>AddChildren</procedure></A> (         cl   : ParseClosure;
                                v    : MultiSplit.T;
                                list : RefList.T;
                       READONLY state: State         )
  RAISES {Error} =
  BEGIN
    WHILE list # NIL DO
      TYPECASE Pop(list) OF
      | NULL =&gt;
          Gripe(&quot;NIL is an illegal form&quot;); &lt;* ASSERT FALSE *&gt;
      | RefList.T (a) =&gt;
          TYPECASE a.head OF
          | NULL =&gt;
              Gripe(&quot;(NIL ...) is an illegal form&quot;); &lt;* ASSERT FALSE *&gt;
          | Atom.T (sym) =&gt;
              IF sym = qInsert THEN
                list := RefList.Append(InsertFile(
                                         OneText(a.tail),
                                         cl.fv.path), list)
              ELSE
                MultiSplit.AddChild(v, Item(cl, a, state))
              END
          ELSE
            MultiSplit.AddChild(v, Item(cl, a, state))
          END
      | REFANY (ra) =&gt;
          MultiSplit.AddChild(v, Item(cl, ra, state))
      END
    END
  END AddChildren;

PROCEDURE <A NAME="OneText"><procedure>OneText</procedure></A> (list: RefList.T): TEXT RAISES {Error} =
  BEGIN
    IF list # NIL THEN
      TYPECASE list.head OF
      | NULL =&gt;
          (* Technically, this is illegal, but the FormsVBT prettyprinter
             in Ivy converts &quot;&quot; to (), and there's still some of that code
             around. *)
          IF list.tail = NIL THEN RETURN &quot;&quot; END
      | TEXT (t) =&gt; IF list.tail = NIL THEN RETURN t END
      ELSE
      END
    END;
    Gripe (&quot;Bad text-form: &quot;, list); &lt;* ASSERT FALSE *&gt;
  END OneText;

PROCEDURE <A NAME="OneCardinal"><procedure>OneCardinal</procedure></A> (list: RefList.T): CARDINAL RAISES {Error} =
  BEGIN
    IF list # NIL THEN
      TYPECASE list.head OF
      | NULL =&gt;
      | REF INTEGER (ri) =&gt;
          IF ri^ &gt;= 0 AND list.tail = NIL THEN RETURN ri^ END
      ELSE
      END
    END;
    Gripe (&quot;Expected a cardinal integer: &quot;, list); &lt;* ASSERT FALSE *&gt;
  END OneCardinal;

PROCEDURE <A NAME="OneInteger"><procedure>OneInteger</procedure></A> (list: RefList.T): INTEGER RAISES {Error} =
  BEGIN
    IF list # NIL THEN
      TYPECASE list.head OF
      | NULL =&gt;
      | REF INTEGER (ri) =&gt; IF list.tail = NIL THEN RETURN ri^ END
      ELSE
      END
    END;
    Gripe (&quot;Expected an integer: &quot;, list); &lt;* ASSERT FALSE *&gt;
  END OneInteger;

PROCEDURE <A NAME="OneReal"><procedure>OneReal</procedure></A> (list: RefList.T): REAL RAISES {Error} =
  BEGIN
    IF list # NIL THEN
      TYPECASE list.head OF
      | NULL =&gt;
      | REF INTEGER (ri) =&gt; IF list.tail = NIL THEN RETURN FLOAT (ri^) END
      | REF REAL (rr) =&gt; IF list.tail = NIL THEN RETURN rr^ END
      ELSE
      END
    END;
    Gripe (&quot;Expected a real number: &quot;, list); &lt;* ASSERT FALSE *&gt;
  END OneReal;

PROCEDURE <A NAME="OneBoolean"><procedure>OneBoolean</procedure></A> (form: RefList.T): BOOLEAN RAISES {Error} =
  BEGIN
    IF form # NIL AND form.tail = NIL THEN
      TYPECASE form.head OF
      | NULL =&gt;
      | Atom.T (sym) =&gt;
          IF sym = Sx.True THEN
            RETURN TRUE
          ELSIF sym = Sx.False THEN
            RETURN FALSE
          END
      ELSE
      END
    END;
    Gripe (&quot;Not a BOOLEAN: &quot;, form); &lt;* ASSERT FALSE *&gt;
  END OneBoolean;

PROCEDURE <A NAME="OneSymbol"><procedure>OneSymbol</procedure></A> (form: RefList.T): Atom.T RAISES {Error} =
  BEGIN
    IF form # NIL AND form.tail = NIL THEN
      TYPECASE form.head OF
      | NULL =&gt;
      | Atom.T (sym) =&gt; RETURN sym
      ELSE
      END
    END;
    Gripe (&quot;Not a symbol: &quot;, form); &lt;* ASSERT FALSE *&gt;
  END OneSymbol;

PROCEDURE <A NAME="AssertEmpty"><procedure>AssertEmpty</procedure></A> (list: RefList.T) RAISES {Error} =
  BEGIN
    IF list # NIL THEN Gripe (&quot;Extra junk in form: &quot;, list) END
  END AssertEmpty;
</PRE> ====================== Runtime Utilities ========================= 

<P><PRE>PROCEDURE <A NAME="AddNameProp"><procedure>AddNameProp</procedure></A> (         cl   : ParseClosure;
                                v    : VBT.T;
                                pp   : SymbolPP;
                       READONLY state: State         ) RAISES {Error} =
  VAR stateRef: REF State;
  BEGIN
    IF Named (pp) THEN
      FVRuntime.SetVBT (cl.fv, pp.valname, v);
      stateRef := NEW (REF State);
      stateRef^ := state;
      stateRef^.name := pp.valname;
      VBT.PutProp (v, stateRef);
    END
  END AddNameProp;

PROCEDURE <A NAME="AddForProp"><procedure>AddForProp</procedure></A> (cl: ParseClosure; v: VBT.T; pp: SymbolPP)
  RAISES {Error} =
  BEGIN
    IF pp.val = NIL THEN RAISE Error (&quot;A name is required here.&quot;) END;
    cl.fixupList := NEW (FixupLink, targetName := pp.valname,
                         sourceVBT := v, next := cl.fixupList)
  END AddForProp;
</PRE> ========================== Table Lookup =========================== 

<P><PRE>PROCEDURE <A NAME="FindComponentProc"><procedure>FindComponentProc</procedure></A> (sym: Atom.T): ComponentProc =
  VAR n: INTEGER;
  BEGIN
    IF ComponentNameTable.get (sym, n) THEN
      RETURN ComponentProcs [n]
    ELSE
      RETURN NIL
    END
  END FindComponentProc;

PROCEDURE <A NAME="FindRealizeProc"><procedure>FindRealizeProc</procedure></A> (sym: Atom.T): RealizeProc RAISES {Error} =
  VAR n: INTEGER;
  BEGIN
    IF ComponentNameTable.get (sym, n) THEN
      RETURN RealizeProcs [n]
    ELSE
      Gripe (&quot;Unknown component: &quot;, sym); &lt;* ASSERT FALSE *&gt;
    END
  END FindRealizeProc;

PROCEDURE <A NAME="FindStateProc"><procedure>FindStateProc</procedure></A> (sym: Atom.T): StateProc =
  VAR n: INTEGER;
  BEGIN
    IF StateNameTable.get (sym, n) THEN
      RETURN StateProcs [n]
    ELSE
      RETURN NIL
    END
  END FindStateProc;

CONST
  StateNames = ARRAY OF
                 TEXT {&quot;BgColor&quot;, &quot;Color&quot;, &quot;DarkShadow&quot;, &quot;Font&quot;,
                       &quot;LabelFont&quot;, &quot;LightShadow&quot;, &quot;Macro&quot;, &quot;ShadowSize&quot;};

CONST
  StateProcs = ARRAY [0 .. LAST (StateNames)] OF
                 StateProc {pBgColor, pColor, pDarkShadow, pFont,
                            pLabelFont, pLightShadow, pMacro, pShadowSize};
</PRE> NOTE: FVTypes contains type declarations corresponding to each
   component. When a new component is added, be sure to add an entry to
    Also, if the VBT class for a component changes (unlikely, but
   possible), be sure to modify the component's entry in FVTypes
   appropriately. 

<P><PRE>CONST
  ComponentNames = ARRAY OF
                     TEXT{
                     &quot;Audio&quot;, &quot;Bar&quot;, &quot;Boolean&quot;, &quot;Border&quot;, &quot;Browser&quot;,
                     &quot;Button&quot;, &quot;Chisel&quot;, &quot;Choice&quot;, &quot;CloseButton&quot;,
                     &quot;DirMenu&quot;, &quot;FileBrowser&quot;, &quot;Fill&quot;, &quot;Filter&quot;, &quot;Frame&quot;,
                     &quot;Generic&quot;, &quot;Glue&quot;, &quot;Guard&quot;, &quot;HBox&quot;, &quot;HPackSplit&quot;,
                     &quot;HTile&quot;, &quot;Helper&quot;, &quot;Image&quot;, &quot;IntApply&quot;, &quot;LinkButton&quot;,
                     &quot;LinkMButton&quot;, &quot;MButton&quot;, &quot;Menu&quot;, &quot;MultiBrowser&quot;,
                     &quot;Numeric&quot;, &quot;PageButton&quot;, &quot;PageMButton&quot;, &quot;Pixmap&quot;,
                     &quot;PopButton&quot;, &quot;PopMButton&quot;, &quot;Radio&quot;, &quot;Ridge&quot;, &quot;Rim&quot;,
                     &quot;Scale&quot;, &quot;Scroller&quot;, &quot;Shape&quot;, &quot;Source&quot;, &quot;Stable&quot;, &quot;TSplit&quot;,
                     &quot;Target&quot;, &quot;Text&quot;, &quot;TextEdit&quot;, &quot;Texture&quot;,
                     &quot;TrillButton&quot;, &quot;TypeIn&quot;, &quot;Typescript&quot;, &quot;VBox&quot;,
                     &quot;VPackSplit&quot;, &quot;VTile&quot;, &quot;Video&quot;, &quot;Viewport&quot;,
                     &quot;ZBackground&quot;, &quot;ZChassis&quot;, &quot;ZChild&quot;, &quot;ZGrow&quot;, &quot;ZMove&quot;,
                     &quot;ZSplit&quot;};

CONST
  ComponentProcs = ARRAY [0 .. LAST(ComponentNames)] OF
                     ComponentProc{
                     pAudio, pBar, pBoolean, pBorder, pBrowser, pButton,
                     pChisel, pChoice, pCloseButton, pDirMenu,
                     pFileBrowser, pFill, pFilter, pFrame, pGeneric, pGlue,
                     pGuard, pHBox, pHPackSplit, pHTile, pHelper, pImage,
                     pIntApply, pLinkButton, pLinkMButton, pMButton, pMenu,
                     pMultiBrowser, pNumeric, pPageButton, pPageMButton,
                     pPixmap, pPopButton, pPopMButton, pRadio, pRidge,
                     pRim, pScale, pScroller, pShape, pSource, pStable, pTSplit,
                     pTarget, pText, pTextEdit, pTexture, pTrillButton,
                     pTypeIn, pTypescript, pVBox, pVPackSplit, pVTile,
                     pVideo, pViewport, pZBackground, pZChassis, pZChild,
                     pZGrow, pZMove, pZSplit};

CONST
  RealizeProcs = ARRAY [0 .. LAST(ComponentNames)] OF
                   RealizeProc{
                   rAudio, rBar, rBoolean, rBorder, rBrowser, rButton,
                   rChisel, rChoice, rCloseButton, rDirMenu, rFileBrowser,
                   rFill, rFilter, rFrame, rGeneric, rGlue, rGuard, rHBox,
                   rHPackSplit, rHTile, rHelper, rImage, rIntApply, rLinkButton,
                   rLinkMButton, rMButton, rMenu, rMultiBrowser, rNumeric,
                   rPageButton, rPageMButton, rPixmap, rPopButton,
                   rPopMButton, rRadio, rRidge, rRim, rScale, rScroller,
                   rShape, rSource, rStable, rTSplit, rTarget, rText, rTextEdit,
                   rTexture, rTrillButton, rTypeIn, rTypescript, rVBox,
                   rVPackSplit, rVTile, rVideo, rViewport, rZBackground,
                   rZChassis, rZChild, rZGrow, rZMove, rZSplit};

TYPE
  mp = RECORD
         name                         : TEXT;
         proc                         : MetricsProc;
         fontDefault, labelFontDefault: TEXT;
         symname                      : Atom.T
       END;
</PRE> In the following table, we use <CODE>impossible</CODE> names to prevent the client
   from specifying AdStyle and PixelSize, so these will always be <CODE>*</CODE> in
   the font name. 
<PRE>VAR
  MetricsProcs := ARRAY [0 .. 13] OF
                    mp {mp {&quot;Foundry&quot;, mText, &quot;*&quot;, &quot;*&quot;, NIL},
                        mp {&quot;Family&quot;, mText, &quot;fixed&quot;, &quot;helvetica&quot;, NIL},
                        mp {&quot;WeightName&quot;, mText, &quot;medium&quot;, &quot;bold&quot;, NIL},
                        mp {&quot;Slant&quot;, mText, &quot;r&quot;, &quot;r&quot;, NIL},
                        mp {&quot;Width&quot;, mText, &quot;semicondensed&quot;, &quot;*&quot;, NIL},
                        mp {&quot; -AdStyle- &quot;, mText, &quot;*&quot;, &quot;*&quot;, NIL},
                        mp {&quot; -PixelSize- &quot;, mCardinal, &quot;*&quot;, &quot;*&quot;, NIL},
                        mp {&quot;PointSize&quot;, mCardinal, &quot;100&quot;, &quot;100&quot;, NIL},
                        mp {&quot;HRes&quot;, mCardinal, &quot;*&quot;, &quot;*&quot;, NIL},
                        mp {&quot;VRes&quot;, mCardinal, &quot;*&quot;, &quot;*&quot;, NIL},
                        mp {&quot;Spacing&quot;, mText, &quot;*&quot;, &quot;*&quot;, NIL},
                        mp {&quot;AvgWidth&quot;, mCardinal, &quot;*&quot;, &quot;*&quot;, NIL},
                        mp {&quot;Registry&quot;, mText, &quot;iso8859&quot;, &quot;iso8859&quot;, NIL},
                        mp {&quot;Encoding&quot;, mText, &quot;1&quot;, &quot;1&quot;, NIL}};
</PRE><BLOCKQUOTE><EM> The 14 metrics-components must be in this order, so that we can generate
   the strings easily.  I have no idea what <CODE>AdStyle</CODE> is. </EM></BLOCKQUOTE><PRE>

VAR StateNameTable, ComponentNameTable, MetricsNameTable: AtomIntTbl.T;

PROCEDURE <A NAME="InitParser"><procedure>InitParser</procedure></A> () =
  BEGIN
    StateNameTable := NEW (AtomIntTbl.Default).init (NUMBER (StateNames));
    ComponentNameTable :=
      NEW (AtomIntTbl.Default).init (NUMBER (ComponentNames));
    MetricsNameTable := NEW (AtomIntTbl.Default).init (NUMBER (MetricsProcs));
    FOR i := FIRST (StateNames) TO LAST (StateNames) DO
      EVAL StateNameTable.put (Atom.FromText (StateNames [i]), i)
    END;
    FOR i := FIRST (ComponentNames) TO LAST (ComponentNames) DO
      EVAL ComponentNameTable.put (Atom.FromText (ComponentNames [i]), i)
    END;
    FOR i := FIRST (MetricsProcs) TO LAST (MetricsProcs) DO
      WITH s = Atom.FromText (MetricsProcs [i].name) DO
        EVAL MetricsNameTable.put (s, i);
        MetricsProcs [i].symname := s
      END
    END;
    DefaultFontMetrics := NIL;
    DefaultLabelFontMetrics := NIL;
    FOR i := 0 TO 13 DO
      WITH mp = MetricsProcs [i] DO
        Push (DefaultFontMetrics, RefList.List2 (mp.symname, mp.fontDefault));
        Push (DefaultLabelFontMetrics,
              RefList.List2 (mp.symname, mp.labelFontDefault))
      END
    END
  END InitParser;

BEGIN
END FormsVBT.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
