<HTML>
<HEAD>
<TITLE>SRC Modula-3: formsvbt/src/Manpage.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>formsvbt/src/Manpage.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                             </EM></BLOCKQUOTE><PRE>
&lt;* PRAGMA LL *&gt;

INTERFACE <interface><A HREF="Manpage.m3">Manpage</A></interface>;

IMPORT <A HREF="FormsVBT.i3">FormsVBT</A>, <A HREF="../../vbtkitutils/src/Rsrc.i3">Rsrc</A>;

TYPE
  ErrorReporter = OBJECT
                  METHODS
                    apply (msg: TEXT) &lt;* LL = VBT.mu *&gt;
                  END;

PROCEDURE <A HREF="Manpage.m3#Init">Init</A> (fv           : FormsVBT.T;
                name         : TEXT;
                er           : ErrorReporter;
                helpfindfirst                  := &quot;helpfindfirst&quot;;
                helpfindnext                   := &quot;helpfindnext&quot;;
                helpfindprev                   := &quot;helpfindprev&quot;;
                helpfindtext                   := &quot;helpfindtext&quot;;
                manpagetext                    := &quot;manpagetext&quot;;
                notfound                       := &quot;notfound&quot;;
                helpcase                       := &quot;helpcase&quot;;
                path         : Rsrc.Path       := NIL              )
  RAISES {FormsVBT.Error};

PROCEDURE <A HREF="Manpage.m3#TextReverse">TextReverse</A> (t: TEXT): TEXT;
</PRE><BLOCKQUOTE><EM> This produces a new text with the characters in opposite order. </EM></BLOCKQUOTE><PRE>

END Manpage.
</PRE> <CODE>fv</CODE> is a FormsVBT.T that will be used for displaying a file (e.g., a
   manpage) and providing some string-search capabilities.  <CODE>name</CODE> is the name
   of a resource (e.g., a file) containing the text of the manpage.  <CODE>fv</CODE>
   should have buttons and various text-fields, described below, that are used
   for displaying the file and searching.  <CODE>Init</CODE> attaches procedures to the
   buttons, and it forks a thread to read the file into one of the
   text-fields, so that the text will be ready the first time the user asks
   for it.  The intention is that the text will be displayed in pop-up window
   attached to a Help button of some sort.
<P>
   The file is opened without locking VBT.mu, so this shouldn't interfere with
   user actions.  After the file has been opened, VBT.mu is locked briefly
   while a pointer to the text is stored in the object; we don't actually copy
   the bytes until the user views that part of the file.  If the user opens
   the window before the file has been read, the process will block until the
   text is ready.
<P>
   If the name of the Boolean (helpcase) or popup (notfound) is NIL,
   then there will be no attachment; the Boolean defaults to being
   case-insensitive.
   <P>
   If the named buttons are missing, then Init will raise an exception.  All
   errors that occur in the thread that reads the file, or during the search,
   are signaled by calling <CODE>er.apply</CODE> with VBT.mu locked.  An unsuccessful
   search isn't an error; that causes a subwindow to pop up and disappear
   two seconds later.
<P>
   The form, <CODE>fv</CODE>, must have the following named VBTs:
<P>
<PRE>
      helpfindtext '-- the name of the TypeIn that contains the
         string to search for'
      helpfindfirst '-- the name of the Button that will cause
         a search for the first occurrence of the string'
      helpfindnext '-- the name of the Button that will cause
         a search for the next occurrence of the string'
      helpfindprev <KBD>-- the name of the Button that will cause
|    a search for the previous occurrence of the string'
| manpagetext </KBD>-- the name of the TextEdit (should be ReadOnly)
         where the text of the file should appear'
      notfound <KBD>-- the name of a ZChild or ZChassis displaying a
|    message like </KBD><KBD>Not found'', which will pop up if the
|    search is unsuccessful.'
| helpcase </KBD>-- the name of the Boolean that controls
         case-sensitivity during the search. (&quot;TRUE&quot; means
         case-sensitive.)'
</PRE>
   

<P>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
