<HTML>
<HEAD>
<TITLE>SRC Modula-3: formsvbt/src/Manpage.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>formsvbt/src/Manpage.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
&lt;* PRAGMA LL *&gt;

MODULE <module><implements><A HREF="Manpage.i3">Manpage</A></implements></module>;

IMPORT <A HREF="../../fmtlex/src/Fmt.i3">Fmt</A>, <A HREF="FormsVBT.i3">FormsVBT</A>, <A HREF="../../mtext/src/MTextRd.i3">MTextRd</A>, <A HREF="../../rw/src/Common/Rd.i3">Rd</A>, <A HREF="../../rw/src/Common/RdUtils.i3">RdUtils</A>, <A HREF="../../vbtkitutils/src/Rsrc.i3">Rsrc</A>, <A HREF="../../text/src/Text.i3">Text</A>, <A HREF="../../etext/src/TextEditVBT.i3">TextEditVBT</A>,
       <A HREF="../../etext/src/TextPort.i3">TextPort</A>, <A HREF="../../thread/src/Common/Thread.i3">Thread</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>, <A HREF="../../vtext/src/VTDef.i3">VTDef</A>, <A HREF="../../vtext/src/VText.i3">VText</A>;

TYPE
  T = FormsVBT.Closure OBJECT
        rd, revRd: MTextRd.T;
        textport : TextPort.T;
        length   : CARDINAL;
        er       : ErrorReporter;
        ready    : Thread.Condition;
        done                          := FALSE; &lt;* LL = VBT.mu *&gt;
        helpfindfirst, helpfindnext, helpfindprev, helpfindtext, notfound,
          helpcase: TEXT := NIL;
        caseSensitive := FALSE
      OVERRIDES
        apply := Help
      END;
  HelpThreadClosure = Thread.Closure OBJECT
                        t       : T;
                        resource: TEXT;
                        path    : Rsrc.Path
                      OVERRIDES
                        apply := ReadManpage
                      END;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A> (fv           : FormsVBT.T;
                resource     : TEXT;
                er           : ErrorReporter;
                helpfindfirst                  := &quot;helpfindfirst&quot;;
                helpfindnext                   := &quot;helpfindnext&quot;;
                helpfindprev                   := &quot;helpfindprev&quot;;
                helpfindtext                   := &quot;helpfindtext&quot;;
                manpagetext                    := &quot;manpagetext&quot;;
                notfound                       := &quot;notfound&quot;;
                helpcase                       := &quot;helpcase&quot;;
                path         : Rsrc.Path       := NIL              )
  RAISES {FormsVBT.Error} =
  VAR
    t := NEW (T, er := er, ready := NEW (Thread.Condition),
              helpfindfirst := helpfindfirst, helpfindnext := helpfindnext,
              helpfindprev := helpfindprev, helpfindtext := helpfindtext,
              notfound := notfound, helpcase := helpcase);
    htc := NEW (HelpThreadClosure, t := t, resource := resource, path := path);
  BEGIN
    TYPECASE FormsVBT.GetVBT (fv, manpagetext) OF
    | TextEditVBT.T (x) =&gt; t.textport := x.tp
    ELSE
      RAISE FormsVBT.Error (
              &quot;\&quot;&quot; &amp; manpagetext &amp; &quot;\&quot; is not the name of a TextEdit form&quot;)
    END;
    FormsVBT.Attach (fv, helpfindfirst, t);
    FormsVBT.Attach (fv, helpfindnext, t);
    FormsVBT.Attach (fv, helpfindprev, t);
    FormsVBT.Attach (fv, helpfindtext, t);
    IF helpcase # NIL THEN FormsVBT.Attach (fv, helpcase, t) END;
    EVAL Thread.Fork (htc)
  END Init;

PROCEDURE <A NAME="ReadManpage"><procedure>ReadManpage</procedure></A> (htc: HelpThreadClosure): REFANY =
  &lt;* LL = 0 *&gt;
  VAR
    rd: Rd.T;
    t        := htc.t;
  PROCEDURE oops (msg: TEXT) =
    BEGIN
      LOCK VBT.mu DO
        t.er.apply (
          Fmt.F (&quot;Sorry, couldn't read the manpage in %s\nError: %s\n&quot;,
                 htc.resource, msg))
      END
    END oops;
  BEGIN
    TRY                         (* Fetch the file in non-event time. *)
      rd := Rsrc.Open (htc.resource, htc.path);
      LOCK VBT.mu DO
        (* MText and (therefore) VText support a &quot;text segment&quot; that is
           actually just a reader, and they don't actually copy bytes until
           they're needed. *)
        WITH vtext = TextPort.GetVText (t.textport),
             mtext = vtext.mtext                     DO
          VText.ReplaceFile (
            vtext, begin := 0, end := LAST (CARDINAL), file := rd);
          VBT.Mark (t.textport);
          (* Create forward- and reverse-readers for searching. *)
          t.rd := MTextRd.New (mtext);
          t.revRd := MTextRd.New (mtext, reverse := TRUE);
          t.length := Rd.Length (rd)
        END
      END
    EXCEPT
    | Rd.Failure (ref) =&gt; oops (RdUtils.FailureText (ref))
    | Rd.EndOfFile =&gt; oops (&quot;End of file&quot;)
    | VTDef.Error (code) =&gt; oops (VTDef.ErrorCodeTexts [code])
    | Thread.Alerted =&gt; oops (&quot;interrupted (Thread.Alerted)&quot;)
    | Rsrc.NotFound =&gt; oops (&quot;No such resource: &quot; &amp; htc.resource)
    END;
    LOCK VBT.mu DO t.done := TRUE END;
    Thread.Signal (t.ready);
    RETURN NIL
  END ReadManpage;

PROCEDURE <A NAME="Help"><procedure>Help</procedure></A> (t: T; fv: FormsVBT.T; name: TEXT; time: VBT.TimeStamp) =
  &lt;* LL = VBT.mu *&gt;
  VAR
    pattern: TEXT;
    pos    : INTEGER;
    n      : CARDINAL;
    x      : TextPort.Extent;
  PROCEDURE show (start: INTEGER) RAISES {FormsVBT.Error} =
    BEGIN
      IF pos &gt;= 0 THEN
        TextPort.Select (
          t.textport, time, start, start + n, replaceMode := TRUE);
        TextPort.Normalize (t.textport, start)
      ELSIF t.notfound # NIL THEN
        FormsVBT.PopUp (fv, t.notfound);
        EVAL Thread.Fork (NEW (PDNF, t := t, fv := fv))
      END
    END show;
  BEGIN
    (* Wait for ReadManpage to finish. *)
    WHILE NOT t.done DO Thread.Wait (VBT.mu, t.ready) END;
    x := TextPort.GetSelection (t.textport);
    TRY
      TRY
        pattern := FormsVBT.GetText (fv, t.helpfindtext)
      EXCEPT
      | FormsVBT.Unimplemented =&gt;
          t.er.apply (t.helpfindtext &amp; &quot; is not a text component [Manpage]&quot;);
          RETURN
      END;
      n := Text.Length (pattern);
      IF n = 0 THEN
        RETURN
      ELSIF Text.Equal (name, t.helpfindfirst)
              OR Text.Equal (name, t.helpfindtext)
              OR Text.Equal (name, t.helpfindnext) THEN
        IF Text.Equal (name, t.helpfindnext)
             OR Text.Equal (name, t.helpfindtext) THEN
          Rd.Seek (t.rd, x.r)
        ELSE
          Rd.Seek (t.rd, 0)
        END;
        IF t.caseSensitive THEN
          pos := RdUtils.Find (t.rd, pattern)
        ELSE
          pos := RdUtils.Find (t.rd, pattern, RdUtils.ToUpperCaseASCII)
        END;
        show (pos)
      ELSIF Text.Equal (name, t.helpfindprev) THEN
        Rd.Seek (t.revRd, t.length - x.l);
        IF t.caseSensitive THEN
          pos := RdUtils.Find (t.revRd, TextReverse (pattern));
        ELSE
          pos := RdUtils.Find (
                   t.revRd, TextReverse (pattern), RdUtils.ToUpperCaseASCII)
        END;
        show (t.length - pos - n)
      ELSIF t.helpcase # NIL AND Text.Equal (name, t.helpcase) THEN
        t.caseSensitive := FormsVBT.GetBoolean (fv, name)
      END
    EXCEPT
    | FormsVBT.Error (msg) =&gt; t.er.apply (msg)
    | FormsVBT.Unimplemented =&gt;
        t.er.apply (name &amp; &quot; is not a Boolean component [Manpage]&quot;)
    | Thread.Alerted =&gt;
    | Rd.Failure (ref) =&gt; t.er.apply (RdUtils.FailureText (ref))
    END
  END Help;

TYPE
  PDNF = Thread.Closure OBJECT
           t : T;
           fv: FormsVBT.T
         OVERRIDES
           apply := PopDownNotFound
         END;

PROCEDURE <A NAME="PopDownNotFound"><procedure>PopDownNotFound</procedure></A> (cl: PDNF): REFANY =
  BEGIN
    Thread.Pause (2.0D0);
    LOCK VBT.mu DO
      TRY
        FormsVBT.PopDown (cl.fv, cl.t.notfound)
      EXCEPT
      | FormsVBT.Error (msg) =&gt; cl.t.er.apply (msg)
      END
    END;
    RETURN NIL
  END PopDownNotFound;

PROCEDURE <A NAME="TextReverse"><procedure>TextReverse</procedure></A> (t: TEXT): TEXT =
  VAR
    len : CARDINAL          := Text.Length (t);
    buf : REF ARRAY OF CHAR;
    i, j: CARDINAL;
    c   : CHAR;
  BEGIN
    buf := NEW (REF ARRAY OF CHAR, len);
    Text.SetChars (buf^, t);
    i := 0;
    j := len - 1;
    WHILE i &lt; j DO
      c := buf [i];
      buf [i] := buf [j];
      buf [j] := c;
      INC (i);
      DEC (j)
    END;
    RETURN Text.FromChars (buf^)
  END TextReverse;

BEGIN END Manpage.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
