<HTML>
<HEAD>
<TITLE>SRC Modula-3: formsvbt/src/RefListUtils.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>formsvbt/src/RefListUtils.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>

MODULE <module><implements><A HREF="RefListUtils.i3">RefListUtils</A></implements></module>;

IMPORT <A HREF="../../atom/src/Atom.i3">Atom</A>, <A HREF="../../libm3/derived/RefList.i3">RefList</A>, <A HREF="../../text/src/Text.i3">Text</A>;

PROCEDURE <A NAME="Pop"><procedure>Pop</procedure></A> (VAR list: RefList.T): REFANY =
  VAR car := list.head;
  BEGIN
    list := list.tail;
    RETURN car
  END Pop;

PROCEDURE <A NAME="Push"><procedure>Push</procedure></A> (VAR list: RefList.T; item: REFANY) =
  BEGIN
    list := RefList.Cons (item, list)
  END Push;

PROCEDURE <A NAME="Assoc"><procedure>Assoc</procedure></A> (z: RefList.T; item: REFANY): RefList.T =
  VAR pair: RefList.T;
  BEGIN
    WHILE z # NIL DO
      pair := Pop (z);
      IF Equal (pair.head, item) THEN RETURN pair END
    END;
    RETURN NIL
  END Assoc;

PROCEDURE <A NAME="AssocQ"><procedure>AssocQ</procedure></A> (z: RefList.T; item: REFANY): RefList.T =
  VAR pair: RefList.T;
  BEGIN
    WHILE z # NIL DO
      pair := Pop (z);
      IF pair.head = item THEN RETURN pair END
    END;
    RETURN NIL
  END AssocQ;

PROCEDURE <A NAME="Equal"><procedure>Equal</procedure></A> (a, b: REFANY): BOOLEAN =
  BEGIN
    IF a = b THEN RETURN TRUE END;
    IF a = NIL OR b = NIL THEN RETURN FALSE END;
    TYPECASE a OF
    | REF CHAR (ar) =&gt;
        TYPECASE b OF
          REF CHAR (br) =&gt; RETURN ar^ = br^
        ELSE
          RETURN FALSE
        END
    | REF INTEGER (ar) =&gt;
        TYPECASE b OF
          REF INTEGER (br) =&gt; RETURN ar^ = br^
        ELSE
          RETURN FALSE
        END
    | REF REAL (ar) =&gt;
        TYPECASE b OF
          REF REAL (br) =&gt; RETURN ar^ = br^
        ELSE
          RETURN FALSE
        END
    | REF LONGREAL (ar) =&gt;
        TYPECASE b OF
          REF LONGREAL (br) =&gt; RETURN ar^ = br^
        ELSE
          RETURN FALSE
        END
    | REF EXTENDED (ar) =&gt;
        TYPECASE b OF
          REF EXTENDED (br) =&gt; RETURN ar^ = br^
        ELSE
          RETURN FALSE
        END
    | Atom.T =&gt; RETURN FALSE
    | Text.T (ta) =&gt;
        TYPECASE b OF
        | TEXT (tb) =&gt; RETURN Text.Equal(ta, tb)
        ELSE
          RETURN FALSE
        END;
    | RefList.T (ar) =&gt;
        TYPECASE b OF
        | RefList.T (br) =&gt;
            VAR al := RefList.Length(ar);
            BEGIN
              IF al # RefList.Length(br) THEN RETURN FALSE END;
              WHILE ar # NIL DO
                IF NOT Equal(Pop(ar), Pop(br)) THEN RETURN FALSE END
              END;
              RETURN TRUE
            END
        ELSE
          RETURN FALSE
        END
    ELSE
      RETURN FALSE
    END
  END Equal;

PROCEDURE <A NAME="SetNth"><procedure>SetNth</procedure></A> (list: RefList.T; n: CARDINAL; item: REFANY) =
  BEGIN
    LOOP
      IF list = NIL THEN
        RETURN
      ELSIF n = 0 THEN
        list.head := item;
        RETURN
      ELSE
        list := list.tail;
        DEC (n)
      END
    END
  END SetNth;

PROCEDURE <A NAME="NthTail"><procedure>NthTail</procedure></A> (l: RefList.T; n: CARDINAL): RefList.T =
  BEGIN
    WHILE n &gt; 0 AND l # NIL DO l := l.tail; DEC (n) END;
    RETURN l
  END NthTail;

PROCEDURE <A NAME="Delete"><procedure>Delete</procedure></A> (VAR list: RefList.T; item: REFANY) =
  VAR l, t: RefList.T;
  BEGIN
    LOOP
      IF list = NIL THEN
        RETURN
      ELSIF Equal (list.head, item) THEN
        list := list.tail
      ELSE
        l := list;
        LOOP
          t := l.tail;
          IF t = NIL THEN
            RETURN
          ELSIF Equal (t.head, item) THEN
            l.tail := t.tail
          ELSE
            l := t
          END
        END
      END
    END;
  END Delete;

PROCEDURE <A NAME="DeleteQ"><procedure>DeleteQ</procedure></A> (VAR list: RefList.T; item: REFANY) =
  VAR l, t: RefList.T;
  BEGIN
    LOOP
      IF list = NIL THEN
        RETURN
      ELSIF Equal (list.head, item) THEN
        list := list.tail
      ELSE
        l := list;
        LOOP
          t := l.tail;
          IF t = NIL THEN
            RETURN
          ELSIF t.head = item THEN
            l.tail := t.tail
          ELSE
            l := t
          END
        END
      END
    END;
  END DeleteQ;

BEGIN
END RefListUtils.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
