<HTML>
<HEAD>
<TITLE>SRC Modula-3: formsvbt/src/StubImages.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>formsvbt/src/StubImages.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> Lectern: a user interface for viewing documents stored as images 
 The object class for paintable images. 

<P>
<P><PRE>UNSAFE MODULE <module>Images</module> EXPORTS <implements>Images</implements>;

IMPORT <A HREF="../../fmtlex/src/Fmt.i3">Fmt</A>, <A HREF="../../ui/src/vbt/PaintPrivate.i3">PaintPrivate</A>, <A HREF="../../geometry/src/Point.i3">Point</A>, <A HREF="../../geometry/src/Rect.i3">Rect</A>, <A HREF="../../ui/src/vbt/ScrnPixmap.i3">ScrnPixmap</A>, <A HREF="../../thread/src/Common/Thread.i3">Thread</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>, <A HREF="../../word/src/Word.i3">Word</A>, <A HREF="../../rw/src/Common/Wr.i3">Wr</A>;

PROCEDURE <A NAME="RawGetLine"><procedure>RawGetLine</procedure></A>(c: RawContents; v: INTEGER; VAR line: ARRAY OF INTEGER) =
  VAR
    raw := c.raw;
    rowStart := (v-raw.bounds.north)*raw.wordsPerRow + raw.offset;
    bitsPerPixel := raw.bitsPerPixel;
    pixelsPerWord := BITSIZE(Word.T) DIV bitsPerPixel;
    sourceBitDelta, sourceBitOrigin: INTEGER;
  BEGIN
    IF raw.pixelOrder = PaintPrivate.ByteOrder.LSBFirst THEN
      sourceBitDelta := raw.bitsPerPixel;
      sourceBitOrigin := 0;
    ELSE
      sourceBitDelta := - raw.bitsPerPixel;
      sourceBitOrigin := (pixelsPerWord-1) * raw.bitsPerPixel;
    END;
    VAR
      pixels := LOOPHOLE(ADR(raw.pixels[rowStart]),
                         UNTRACED REF ARRAY [0..999999] OF Word.T);
      sourceWord := 0;
      sourceBit := sourceBitOrigin;
      sourceCount := pixelsPerWord;
      source := pixels[0];
    BEGIN
      FOR destH := 0 TO Rect.HorSize(raw.bounds)-1 DO
        line[destH] := Word.Extract(source, sourceBit, bitsPerPixel);
        INC(sourceBit, sourceBitDelta);
        DEC(sourceCount);
        IF sourceCount = 0 THEN
          INC(sourceWord);
          source := pixels[sourceWord];
          sourceBit := sourceBitOrigin;
          sourceCount := pixelsPerWord;
        END;
      END;
    END;
  END RawGetLine;

PROCEDURE <A NAME="BitFromGray"><procedure>BitFromGray</procedure></A>(g: Gray): Bit =
  BEGIN
    RETURN ORD(g &lt; 128)
  END BitFromGray;

PROCEDURE <A NAME="GrayFromBit"><procedure>GrayFromBit</procedure></A>(b: Bit): Gray =
  BEGIN
    RETURN (1-b) * 255
  END GrayFromBit;

PROCEDURE <A NAME="GrayFromRGB"><procedure>GrayFromRGB</procedure></A>(rgb: RGB): Gray =
  BEGIN
    RETURN ROUND(0.239*FLOAT(rgb.r) + 0.686*FLOAT(rgb.g) + 0.075*FLOAT(rgb.b))
  END GrayFromRGB;

PROCEDURE <A NAME="RGBFromGray"><procedure>RGBFromGray</procedure></A>(g: Gray): RGB =
  BEGIN
    RETURN RGB{ r := g, g := g, b := g }
  END RGBFromGray;

PROCEDURE <A NAME="GrayMapFromRGBMap"><procedure>GrayMapFromRGBMap</procedure></A>(map: RGBMap): GrayMap =
  VAR
    toGray := NEW(GrayMap, NUMBER(map^));
  BEGIN
    FOR i := 0 TO LAST(toGray^) DO
      toGray[i] := GrayFromRGB(map[i]);
    END;
    RETURN toGray;
  END GrayMapFromRGBMap;

PROCEDURE <A NAME="Lasso"><procedure>Lasso</procedure></A>(contents: RawContents): Rect.T =
  VAR
    raw := contents.raw;
    bounds := Rect.Inset(raw.bounds, 1);
    seed := raw.get(Rect.NorthWest(bounds));
    res := Rect.T{ west := bounds.east,
                   east := bounds.west,
                   north := bounds.south,
                   south := bounds.north }; (* an improper rectangle, so far *)
    h: INTEGER;
  BEGIN
    FOR v := bounds.north TO bounds.south-1 DO
      h := bounds.west;
      WHILE h &lt; bounds.east DO
        IF h &lt; res.west OR v &lt; res.north OR v &gt;= res.south THEN
          IF raw.get(Point.T{h := h, v := v}) # seed THEN
            res.west := MIN(res.west, h);
            res.north := MIN(res.north, v);
            res.east := MAX(res.east, h+1);
            res.south := MAX(res.south, v+1);
            EXIT (* this row is now boring, except for .east *)
          END;
        ELSE
          EXIT
        END;
        INC(h);
      END;
      h := bounds.east;
      WHILE h &gt; res.east DO
        DEC(h);
        IF raw.get(Point.T{h := h, v := v}) # seed THEN
          res.east := MAX(res.east, h+1);
        END;
      END;
    END;
    IF res.west &gt;= res.east OR res.north &gt;= res.south THEN
      RETURN Rect.Empty (* so that we don't return an improper rectangle *)
    ELSE
      RETURN res
    END;
  END Lasso;

PROCEDURE <A NAME="ToPNM"><procedure>ToPNM</procedure></A>(contents: Contents; wr: Wr.T)
                RAISES { Wr.Failure, Thread.Alerted } =
  VAR
    map := contents.map;
    toGray := GrayMapFromRGBMap(map);
    line := NEW(REF ARRAY OF INTEGER, contents.width);
    chars := NEW(REF ARRAY OF CHAR, contents.width*3);
  BEGIN
    Wr.PutChar(wr, 'P');
    IF contents.isBW THEN
      Wr.PutChar(wr, '4');
    ELSIF contents.isGray THEN
      Wr.PutChar(wr, '5');
    ELSE
      Wr.PutChar(wr, '6');
    END;
    Wr.PutText(wr, &quot;\n&quot; &amp; Fmt.Int(contents.width) &amp;
                   &quot;\n&quot; &amp; Fmt.Int(contents.height) &amp; &quot;\n&quot;);
    IF NOT contents.isBW THEN Wr.PutText(wr, &quot;255\n&quot;) END;
    FOR v := 0 TO contents.height-1 DO
      contents.getLine(v, line^);
      IF contents.isBW THEN
        &lt;*ASSERT FALSE*&gt; (* not yet implemented *)
      ELSIF contents.isGray THEN
        FOR h := 0 TO contents.width-1 DO
          chars[h] := VAL(toGray[line[h]], CHAR);
        END;
        Wr.PutString(wr, SUBARRAY(chars^, 0, contents.width));
      ELSE
        FOR h := 0 TO contents.width-1 DO
          VAR
            rgb := map[line[h]];
          BEGIN
            chars[h*3] := VAL(rgb.r, CHAR);
            chars[h*3+1] := VAL(rgb.g, CHAR);
            chars[h*3+2] := VAL(rgb.b, CHAR);
          END;
        END;
        Wr.PutString(wr, SUBARRAY(chars^, 0, 3*contents.width));
      END;
    END;
  END ToPNM;

REVEAL <A NAME="EmptyImage">EmptyImage</A> = T BRANDED OBJECT
  OVERRIDES
    domain := EmptyDomain;
    paint := EmptyPaint;
    render := EmptyRender;
    contents := EmptyContents;
  END;

PROCEDURE <A NAME="EmptyDomain"><procedure>EmptyDomain</procedure></A>(&lt;*UNUSED*&gt;i: T; &lt;*UNUSED*&gt;v: VBT.Leaf): Rect.T =
  BEGIN
    RETURN Rect.Empty
  END EmptyDomain;

PROCEDURE <A NAME="EmptyPaint"><procedure>EmptyPaint</procedure></A>(&lt;*UNUSED*&gt;i: T;
                     &lt;*UNUSED*&gt;v: VBT.Leaf;
                     &lt;*UNUSED*&gt;READONLY clip: Rect.T := Rect.Full;
                     &lt;*UNUSED*&gt;READONLY delta: Point.T) =
  BEGIN
  END EmptyPaint;

PROCEDURE <A NAME="EmptyRender"><procedure>EmptyRender</procedure></A>(&lt;*UNUSED*&gt;i: T; &lt;*UNUSED*&gt;v: VBT.Leaf): ScrnPixmap.Raw
                      RAISES { Error } =
  BEGIN
    RETURN ScrnPixmap.NewRaw(1, Rect.Empty);
  END EmptyRender;

PROCEDURE <A NAME="EmptyContents"><procedure>EmptyContents</procedure></A>(&lt;*UNUSED*&gt;i: T): Contents RAISES { Error } =
  BEGIN
    RETURN NEW(RawContents, width := 0,
                            height := 0,
                            map := NEW(RGBMap, 0),
                            isBW := TRUE,
                            isGray := TRUE,
                            isGrayRamp := FALSE,
                            raw := ScrnPixmap.NewRaw(1, Rect.Empty))
  END EmptyContents;

BEGIN
  Empty := NEW(EmptyImage);
END Images.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
