<HTML>
<HEAD>
<TITLE>SRC Modula-3: gef/derived/gefeventAlgClass.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>gef/derived/gefeventAlgClass.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE>********************************************************************
<PRE>
      *  NOTE: This file is generated automatically from the event 
      *        definition file gefevent.evt.
 </PRE>
********************************************************************

<P><PRE>MODULE <module><implements><A HREF="gefeventAlgClass.i3">gefeventAlgClass</A></implements></module>;

&lt;* NOWARN *&gt; IMPORT <A HREF="../../libm3/derived/RefList.i3">RefList</A>;
&lt;* NOWARN *&gt; IMPORT <A HREF="../../slisp/src/SLispClass.i3">SLispClass</A>;
IMPORT <A HREF="../../zeus/src/Algorithm.i3">Algorithm</A>, <A HREF="../../fmtlex/src/Fmt.i3">Fmt</A>, <A HREF="../../formsvbt/src/FormsVBT.i3">FormsVBT</A>, <A HREF="../../rw/src/Common/Rd.i3">Rd</A>, <A HREF="../../text/src/Text.i3">Text</A>;
IMPORT <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>, <A HREF="../../rw/src/Common/Wr.i3">Wr</A>, <A HREF="../../zeus/src/ZeusClass.i3">ZeusClass</A>, <A HREF="../../zeus/src/ZeusPanel.i3">ZeusPanel</A>, <A HREF="../../zeus/src/ZeusUtil.i3">ZeusUtil</A>;

&lt;* PRAGMA LL *&gt;
</PRE> Fix any FormsVBT errors; don't handle exceptions for them. 
<PRE>&lt;* FATAL FormsVBT.Error, FormsVBT.Unimplemented, Rd.Failure *&gt;

REVEAL
  <A NAME="T">T</A> = Public BRANDED OBJECT
      OVERRIDES
        &lt;* LL = VBT.mu *&gt;
        init := gefeventDefaultInit;
        snapshot := gefeventDefaultSnapshot;
        restore := gefeventDefaultRestore;
        updateEventCounts := gefeventDefaultUpdateCts;
        feFeedback := Feedback;
      END;

PROCEDURE <A NAME="gefeventDefaultInit"><procedure>gefeventDefaultInit</procedure></A> (v: T): Algorithm.T =
  &lt;* LL = VBT.mu *&gt;
  PROCEDURE Attach (id: TEXT; proc: FormsVBT.Proc) =
    BEGIN
      FormsVBT.AttachProc(v.eventData, id, proc, v);
    END Attach;
  BEGIN
    v.eventData := ZeusPanel.NewForm(&quot;gefeventEventData.fv&quot;);
    Attach(&quot;stopatCodeEvents&quot;, gefeventDoIt);
    Attach(&quot;waitatCodeEvents&quot;, gefeventDoIt);
    Attach(&quot;eventCounts&quot;, gefeventRefreshCts);
    Attach(&quot;stopAtInit&quot;, gefeventDoIt);
    Attach(&quot;waitAtInit&quot;, gefeventDoIt);
    Attach(&quot;stopAtEvent&quot;, gefeventDoIt);
    Attach(&quot;waitAtEvent&quot;, gefeventDoIt);
    Attach(&quot;stopAtPause&quot;, gefeventDoIt);
    Attach(&quot;waitAtPause&quot;, gefeventDoIt);
    FromFV (v.eventData, v);    (* Get FV and internal data in sync *)
    RETURN Algorithm.T.init(v);
  END gefeventDefaultInit;

PROCEDURE <A NAME="gefeventDoIt"><procedure>gefeventDoIt</procedure></A> (           fv : FormsVBT.T;
                           e  : TEXT;
                           arg: REFANY;
                &lt;*UNUSED*&gt; t  : VBT.TimeStamp) =
  &lt;* LL = VBT.mu *&gt;
  BEGIN
    IF Text.Equal(e, &quot;stopatCodeEvents&quot;) THEN
      NARROW(arg, T).stopatCodeEvents :=
          FormsVBT.GetBoolean(fv, &quot;stopatCodeEvents&quot;);
    END;
    IF Text.Equal(e, &quot;waitatCodeEvents&quot;) THEN
      NARROW(arg, T).waitatCodeEvents :=
          FormsVBT.GetInteger(fv, &quot;waitatCodeEvents&quot;);
    END;
    IF Text.Equal(e, &quot;stopAtInit&quot;) THEN
      NARROW(arg, T).eventDataRec.stopAtInit :=
          FormsVBT.GetBoolean(fv, &quot;stopAtInit&quot;);
    END;
    IF Text.Equal(e, &quot;waitAtInit&quot;) THEN
      NARROW(arg, T).eventDataRec.waitAtInit :=
          FormsVBT.GetInteger(fv, &quot;waitAtInit&quot;);
    END;
    IF Text.Equal(e, &quot;stopAtEvent&quot;) THEN
      NARROW(arg, T).eventDataRec.stopAtEvent :=
          FormsVBT.GetBoolean(fv, &quot;stopAtEvent&quot;);
    END;
    IF Text.Equal(e, &quot;waitAtEvent&quot;) THEN
      NARROW(arg, T).eventDataRec.waitAtEvent :=
          FormsVBT.GetInteger(fv, &quot;waitAtEvent&quot;);
    END;
    IF Text.Equal(e, &quot;stopAtPause&quot;) THEN
      NARROW(arg, T).eventDataRec.stopAtPause :=
          FormsVBT.GetBoolean(fv, &quot;stopAtPause&quot;);
    END;
    IF Text.Equal(e, &quot;waitAtPause&quot;) THEN
      NARROW(arg, T).eventDataRec.waitAtPause :=
          FormsVBT.GetInteger(fv, &quot;waitAtPause&quot;);
    END;
  END gefeventDoIt;

PROCEDURE <A NAME="gefeventRefreshCts"><procedure>gefeventRefreshCts</procedure></A> (
                &lt;*UNUSED*&gt; fv  : FormsVBT.T;
                &lt;*UNUSED*&gt; e   : TEXT;
                           arg : REFANY;
                &lt;*UNUSED*&gt; t   : VBT.TimeStamp) =
  &lt;* LL = VBT.mu *&gt;
  BEGIN
    NARROW(arg, T).updateEventCounts(FALSE);
  END gefeventRefreshCts;

PROCEDURE <A NAME="FromFV"><procedure>FromFV</procedure></A> (fv : FormsVBT.T; alg: T) =
  &lt;* LL = VBT.mu *&gt;
  BEGIN
    alg.stopatCodeEvents :=
        FormsVBT.GetBoolean(fv, &quot;stopatCodeEvents&quot;);
    alg.waitatCodeEvents :=
        FormsVBT.GetInteger(fv, &quot;waitatCodeEvents&quot;);
    alg.eventDataRec.stopAtInit :=
        FormsVBT.GetBoolean(fv, &quot;stopAtInit&quot;);
    alg.eventDataRec.waitAtInit :=
        FormsVBT.GetInteger(fv, &quot;waitAtInit&quot;);
    alg.eventDataRec.stopAtEvent :=
        FormsVBT.GetBoolean(fv, &quot;stopAtEvent&quot;);
    alg.eventDataRec.waitAtEvent :=
        FormsVBT.GetInteger(fv, &quot;waitAtEvent&quot;);
    alg.eventDataRec.stopAtPause :=
        FormsVBT.GetBoolean(fv, &quot;stopAtPause&quot;);
    alg.eventDataRec.waitAtPause :=
        FormsVBT.GetInteger(fv, &quot;waitAtPause&quot;);
  END FromFV;

&lt;*UNUSED*&gt;
PROCEDURE <A NAME="ToFV"><procedure>ToFV</procedure></A> (fv : FormsVBT.T; alg: T) =
  &lt;* LL = VBT.mu *&gt;
  BEGIN
    FormsVBT.PutBoolean(fv, &quot;stopatCodeEvents&quot;, alg.stopatCodeEvents);
    FormsVBT.PutInteger(fv, &quot;waitatCodeEvents&quot;, alg.waitatCodeEvents);
    FormsVBT.PutBoolean(fv, &quot;stopAtInit&quot;,
                        alg.eventDataRec.stopAtInit);
    FormsVBT.PutInteger(fv, &quot;waitAtInit&quot;,
                        alg.eventDataRec.waitAtInit);
    FormsVBT.PutBoolean(fv, &quot;stopAtEvent&quot;,
                        alg.eventDataRec.stopAtEvent);
    FormsVBT.PutInteger(fv, &quot;waitAtEvent&quot;,
                        alg.eventDataRec.waitAtEvent);
    FormsVBT.PutBoolean(fv, &quot;stopAtPause&quot;,
                        alg.eventDataRec.stopAtPause);
    FormsVBT.PutInteger(fv, &quot;waitAtPause&quot;,
                        alg.eventDataRec.waitAtPause);
    CountsToFV (fv, alg);
  END ToFV;

PROCEDURE <A NAME="CountsToFV"><procedure>CountsToFV</procedure></A> (fv : FormsVBT.T; alg: T) =
  &lt;* LL = VBT.mu *&gt;
  BEGIN
    FormsVBT.PutText(fv, &quot;ctOfInit&quot;,
                        Fmt.Int(alg.eventDataRec.ctOfInit));
    FormsVBT.PutText(fv, &quot;ctOfEvent&quot;,
                        Fmt.Int(alg.eventDataRec.ctOfEvent));
    FormsVBT.PutText(fv, &quot;ctOfPause&quot;,
                        Fmt.Int(alg.eventDataRec.ctOfPause));
  END CountsToFV;

PROCEDURE <A NAME="gefeventDefaultUpdateCts"><procedure>gefeventDefaultUpdateCts</procedure></A> ( v: T; reset: BOOLEAN) =
  &lt;* LL = VBT.mu *&gt;
  BEGIN
    IF reset THEN
      v.eventDataRec.ctOfInit := 0;
      v.eventDataRec.ctOfEvent := 0;
      v.eventDataRec.ctOfPause := 0;
    END;
    CountsToFV (v.eventData, v);
  END gefeventDefaultUpdateCts;

PROCEDURE <A NAME="gefeventDefaultSnapshot"><procedure>gefeventDefaultSnapshot</procedure></A> (v: T; wr: Wr.T)
  RAISES {ZeusClass.Error} =
  &lt;* LL = VBT.mu *&gt;
  BEGIN
    TRY
      Wr.PutChar(wr, '(')
    EXCEPT
    ELSE
      RAISE ZeusClass.Error(
          &quot;gefeventAlgClass.gefeventDefaultSnapshot write error&quot;);
    END;
    IF v.eventData = NIL THEN
      RAISE ZeusClass.Error(
          &quot;gefeventAlgClass.gefeventDefaultSnapshot: &quot; &amp;
          &quot;eventData not set!&quot;);
    END;
    TRY
      v.eventData.snapshot(wr)
    EXCEPT
      FormsVBT.Error (msg) =&gt;
        RAISE ZeusClass.Error(
          &quot;gefeventAlgClass.gefeventDefaultSnapshot FV error: &quot;
          &amp; msg);
    ELSE
      RAISE ZeusClass.Error(
        &quot;gefeventAlgClass.gefeventDefaultSnapshot error&quot;);
    END;
    Algorithm.T.snapshot(v, wr);
    TRY
      Wr.PutChar(wr, ')')
    EXCEPT
    ELSE
      RAISE ZeusClass.Error(
          &quot;gefeventAlgClass.gefeventDefaultSnapshot write error&quot;);
    END;
  END gefeventDefaultSnapshot;

PROCEDURE <A NAME="gefeventDefaultRestore"><procedure>gefeventDefaultRestore</procedure></A> (v: T; rd: Rd.T)
  RAISES {ZeusClass.Error} =
  &lt;* LL = VBT.mu *&gt;
  BEGIN
    IF rd = NIL THEN RETURN END;
    IF NOT ZeusUtil.EatChar(rd, '(') THEN
      RAISE ZeusClass.Error(
          &quot;gefeventAlgClass.gefeventDefaultRestore read error&quot;);
    END;
    IF v.eventData = NIL THEN
      RAISE ZeusClass.Error(
          &quot;gefeventAlgClass.gefeventDefaultRestore: &quot; &amp;
          &quot;eventData not set!&quot;);
    END;
    TRY
      v.eventData.restore(rd);
      v.updateEventCounts(FALSE);
      FromFV(v.eventData, v);
    EXCEPT
    ELSE
      RAISE ZeusClass.Error(
          &quot;gefeventAlgClass.gefeventDefaultRestore error&quot;);
    END;
    Algorithm.T.restore(v, rd);
    IF NOT ZeusUtil.EatChar(rd, ')') THEN
      RAISE ZeusClass.Error(
          &quot;gefeventAlgClass.gefeventDefaultRestore read error&quot;);
    END;
  END gefeventDefaultRestore;

PROCEDURE <A NAME="Feedback"><procedure>Feedback</procedure></A> (self: T
    ; &lt;*UNUSED*&gt; name: TEXT
    ; &lt;*UNUSED*&gt; args: RefList.T
) =
  &lt;* LL = VBT.mu *&gt;
  BEGIN
    self.evtHandled := FALSE;
  END Feedback;

BEGIN
END gefeventAlgClass.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
