<HTML>
<HEAD>
<TITLE>SRC Modula-3: gef/src/GEFLisp.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>gef/src/GEFLisp.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module>GEFLisp</module> EXPORTS <A HREF="GEFLisp.i3"><implements>GEFLisp</A></implements>, <A HREF="GEF.i3"><implements>GEF</A></implements> (* InvokeEvent, EventData *);

&lt;* PRAGMA LL *&gt;

IMPORT <A HREF="../../atom/src/Atom.i3">Atom</A>, <A HREF="../../fmtlex/src/Fmt.i3">Fmt</A>, <A HREF="GEF.i3">GEF</A>, <A HREF="GEFClass.i3">GEFClass</A>, <A HREF="GEFError.i3">GEFError</A>, <A HREF="../../rw/src/Common/Rd.i3">Rd</A>, <A HREF="../../libm3/derived/RefList.i3">RefList</A>, <A HREF="../../formsvbt/src/RefListUtils.i3">RefListUtils</A>, <A HREF="../../slisp/src/SLisp.i3">SLisp</A>,
       <A HREF="../../slisp/src/SLispClass.i3">SLispClass</A>, <A HREF="../../sx/src/Sx.i3">Sx</A>, <A HREF="../../text/src/Text.i3">Text</A>, <A HREF="../../rw/src/Common/TextRd.i3">TextRd</A>, <A HREF="../../rw/src/Common/TextWr.i3">TextWr</A>, <A HREF="../../thread/src/Common/Thread.i3">Thread</A>, <A HREF="../../rw/src/Common/Wr.i3">Wr</A>, <A HREF="../../zeus/src/ZeusPanel.i3">ZeusPanel</A>;

PROCEDURE <A NAME="RegisterPO"><procedure>RegisterPO</procedure></A> (interp: SLisp.T; name: TEXT; po: GEFClass.ParseObject) =
  BEGIN
    interp.defineFun(NEW(LispBuiltin, name := name, minArgs := 0,
                         maxArgs := LAST(INTEGER), po := po));
  END RegisterPO;

PROCEDURE <A NAME="RegisterFuns"><procedure>RegisterFuns</procedure></A>(interp: SLisp.T) =
  &lt;* FATAL SLisp.Error *&gt;
  BEGIN
    interp.defineFun(NEW(SLisp.Builtin, name := &quot;get&quot;, minArgs := 2,
                         maxArgs := 2, apply := Get));
    interp.defineFun(NEW(SLisp.Builtin, name := &quot;set&quot;, minArgs := 1,
                         maxArgs := LAST(INTEGER), apply := Set));
    interp.defineFun(NEW(SLisp.Builtin, name := &quot;delete&quot;, minArgs := 1,
                         maxArgs := LAST(INTEGER), apply := Delete));

    ZeusifyInterp(interp);
  END RegisterFuns;

PROCEDURE <A NAME="ZeusifyInterp"><procedure>ZeusifyInterp</procedure></A>(interp: SLisp.T) =
  &lt;* FATAL SLisp.Error *&gt;
  BEGIN
    (* override the standard slisp printing procedures with ones that write to
       Zeus *)
    interp.defineFun (NEW (SLisp.Builtin, name := &quot;print&quot;, apply := Print,
                         minArgs := 0, maxArgs := LAST (INTEGER)));
    interp.defineFun (NEW (SLisp.Builtin, name := &quot;backtrace&quot;, apply := Backtrace,
                         minArgs := 0, maxArgs := 0));

    interp.defineVar(&quot;true&quot;, interp.varEval(&quot;t&quot;));
    interp.defineVar(&quot;false&quot;, NIL);
    interp.defineVar(&quot;TRUE&quot;, interp.varEval(&quot;t&quot;));
    interp.defineVar(&quot;FALSE&quot;, NIL);
  END ZeusifyInterp;

TYPE
  LispBuiltin = SLisp.Builtin OBJECT
                  po: GEFClass.ParseObject;
                OVERRIDES
                  apply := ParseLisp;
                END;

PROCEDURE <A NAME="EvalList"><procedure>EvalList</procedure></A> (interp: SLisp.T; args: RefList.T): RefList.T
  RAISES {SLisp.Error} =
  VAR res, last: RefList.T := NIL;
  BEGIN
    WHILE args # NIL DO
      IF last = NIL THEN
        last := RefList.Cons(interp.eval(args.head), NIL);
        res := last;
      ELSE
        last.tail := RefList.Cons(interp.eval(args.head), NIL);
        last := last.tail;
      END;
      args := args.tail;
    END;
    RETURN res;
  END EvalList;

VAR
  quote := Atom.FromText(&quot;quote&quot;);

PROCEDURE <A NAME="QuoteList"><procedure>QuoteList</procedure></A> (args: RefList.T): RefList.T =
  VAR a, l: RefList.T := NIL;
  BEGIN
    WHILE args # NIL DO
      IF l = NIL THEN
        l := RefList.List1(RefList.List2(quote, args.head));
        a := l;
      ELSE
        l.tail := RefList.List1(RefList.List2(quote, args.head));
        l := l.tail;
      END;
      args := args.tail;
    END;
    RETURN a
  END QuoteList;

PROCEDURE <A NAME="ParseLisp"><procedure>ParseLisp</procedure></A> (self: LispBuiltin; interp: SLisp.T; args: RefList.T):
  GEFClass.S_exp RAISES {SLisp.Error} = &lt;* LL &lt; GEFClass.mu *&gt;
  &lt;* FATAL Sx.PrintError *&gt;
  VAR
    graph         : GEF.T          := interp.varEval(&quot;graph&quot;);
    arg, name, res: GEFClass.S_exp;
  BEGIN
    TRY
      interp.pushScope();
      WHILE args # NIL DO
        arg := RefListUtils.Pop(args);
        TYPECASE arg OF
        | NULL =&gt; RETURN interp.error(&quot;Bad binding: NIL name&quot;);
        | RefList.T (bind) =&gt;
            name := RefListUtils.Pop(bind);
            TYPECASE name OF
            | NULL =&gt; RETURN interp.error(&quot;Bad binding name: ()&quot;);
            | SLisp.String (str) =&gt;
                EVAL
                  interp.lookup(
                    Atom.FromText(str), SLispClass.LookupMode.CreateLocal);
                interp.defineVar(str, EvalList(interp, bind));
            | SLisp.Symbol (sym) =&gt;
                EVAL
                  interp.lookup(sym, SLispClass.LookupMode.CreateLocal);
                interp.defineVar(Atom.ToText(sym), EvalList(interp, bind));
            ELSE
              RETURN interp.error(
                       &quot;Bad binding name: &quot; &amp; SLispClass.SxToText(name));
            END;
        ELSE
          RETURN interp.error(&quot;Bad binding: &quot; &amp; SLispClass.SxToText(arg));
        END;
      END;
      res := GEFClass.CreateElemFromPO(graph, self.po);
      interp.popScope();
      RETURN res;
    EXCEPT
    | GEFError.T (msg) =&gt;
        RETURN interp.error(msg); (* raises SLisp.Error *)
    | Thread.Alerted =&gt; RAISE SLisp.Error;
    END;
  END ParseLisp;

PROCEDURE <A NAME="Set"><procedure>Set</procedure></A> (&lt;* UNUSED *&gt; self  : SLisp.Builtin;
                            interp: SLisp.T;
                            args  : RefList.T         ): GEFClass.S_exp
  RAISES {SLisp.Error} =
  &lt;* FATAL Sx.PrintError *&gt;
  VAR
    elem, res: GEFClass.S_exp;
    graph    : GEFClass.T;
  BEGIN
    TRY
      graph := interp.varEval(&quot;graph&quot;);
      elem := interp.eval(args.head);
      args := args.tail;
      WHILE args # NIL DO
        TYPECASE args.head OF
        | NULL =&gt; RETURN interp.error(&quot;empty binding given to \&quot;set\&quot;&quot;);
        | RefList.T (l) =&gt;
            IF RefList.Length(l) &gt;= 2 THEN
              res := EvalList(interp, l.tail);
              GEFClass.SetProp(graph, elem, l.head, res)
            ELSE
              RETURN
                interp.error(
                  &quot;not enough items in a \&quot;name\\values\&quot; binding to \&quot;set\&quot;&quot;);
            END;
        ELSE
          RETURN interp.error(
                   &quot;all items to \&quot;set\&quot; must be \&quot;name\\values\&quot; bindings&quot;);
        END;
        args := args.tail;
      END;
      RETURN res
    EXCEPT
    | Thread.Alerted =&gt; RAISE SLisp.Error
    | GEFError.T (msg) =&gt;
        RETURN interp.error(msg); (* raises SLisp.Error *)
    END;
  END Set;

PROCEDURE <A NAME="Get"><procedure>Get</procedure></A> (&lt;* UNUSED *&gt; self  : SLisp.Builtin;
                            interp: SLisp.T;
                            args  : RefList.T         ): GEFClass.S_exp
  RAISES {SLisp.Error} =
  &lt;* FATAL Sx.PrintError *&gt;
  BEGIN
    TRY
      (* evaluate the first argument to get an element *)
      RETURN GEFClass.GetProp(interp.varEval(&quot;graph&quot;), interp.eval(args.head),
                          args.tail.head);
    EXCEPT
    | Thread.Alerted =&gt; RAISE SLisp.Error
    | GEFError.T (msg) =&gt;
        RETURN interp.error(msg); (* raises SLisp.Error *)
    END;
  END Get;

PROCEDURE <A NAME="Delete"><procedure>Delete</procedure></A> (&lt;* UNUSED *&gt; self  : SLisp.Builtin;
                               interp: SLisp.T;
                               args  : RefList.T         ): GEFClass.S_exp
  RAISES {SLisp.Error} =
  VAR graph: GEFClass.T;
  &lt;* FATAL Sx.PrintError *&gt;
  BEGIN
    TRY
      graph := interp.varEval(&quot;graph&quot;);
      WHILE args # NIL DO
        GEFClass.Delete(graph, interp.eval(args.head));
        args := args.tail;
      END;
      RETURN NIL
    EXCEPT
    | Thread.Alerted =&gt; RAISE SLisp.Error
    | GEFError.T (msg) =&gt;
        RETURN interp.error(msg); (* raises SLisp.Error *)
    END;
  END Delete;

PROCEDURE <A NAME="InvokeEvent"><procedure>InvokeEvent</procedure></A> (t          : T;
                       event      : TEXT;
                       args       : RefList.T;
                       nonEventsOK              := TRUE)
  RAISES {GEFError.T, Thread.Alerted} =
  &lt;* FATAL SLisp.Error *&gt;
  BEGIN
    WITH atom = Atom.FromText(event),
         fun  = t.interp.lookup(atom, SLispClass.LookupMode.LookupOnly) DO
      TRY
        IF fun # NIL AND fun.funDefined THEN
          EVAL t.interp.eval(RefList.Cons(atom, args));
        ELSIF NOT nonEventsOK THEN
          EVAL t.interp.error(Fmt.F(&quot;Event \&quot;%s\&quot; undefined in view&quot;, event));
        END;
      EXCEPT
      | SLisp.Error =&gt; RAISE Thread.Alerted;
      END;
    END;
  END InvokeEvent;
</PRE> Convert Atom.Ts back into TEXTs 
<PRE>PROCEDURE <A NAME="DeAtom"><procedure>DeAtom</procedure></A> (l: RefList.T): RefList.T =
  VAR ll := l;
  BEGIN
    WHILE ll # NIL DO
      TYPECASE ll.head OF
      | Atom.T (at) =&gt; ll.head := Atom.ToText(at)
      ELSE
      END;
      ll := ll.tail;
    END;
    RETURN l;
  END DeAtom;

PROCEDURE <A NAME="EventData"><procedure>EventData</procedure></A> (t1, t2, t3, t4, t5, t6, t7, t8, t9, t10: TEXT := &quot;&quot;):
  RefList.T =
  &lt;* FATAL Sx.ReadError, Rd.EndOfFile, Thread.Alerted *&gt;
  BEGIN
    RETURN
      DeAtom(Sx.Read(TextRd.New(Fmt.F(&quot;(%s %s %s %s %s &quot;, t1, t2, t3, t4, t5)
                           &amp; Fmt.F(&quot;%s %s %s %s %s)&quot;, t6, t7, t8, t9, t10))));
  END EventData;

PROCEDURE <A NAME="Print"><procedure>Print</procedure></A> (&lt;*UNUSED*&gt; self  : SLisp.Builtin;
                            interp: SLisp.T;
                            args  : SLisp.List     ): SLisp.Sexp
  RAISES {SLisp.Error} =
  VAR
    wr  := TextWr.New();
    res := args;
  &lt;* FATAL Wr.Failure, Thread.Alerted *&gt;
  BEGIN
    WHILE args # NIL DO
      SLisp.Write(wr, interp.eval(args.head));
      args := args.tail;
    END;
    ZeusPanel.ReportError(TextWr.ToText(wr));
    RETURN res;
  END Print;

PROCEDURE <A NAME="Backtrace"><procedure>Backtrace</procedure></A> (&lt;*UNUSED*&gt; self  : SLisp.Builtin;
                                interp: SLisp.T;
                                args  : SLisp.List     ): SLisp.Sexp
  RAISES {SLisp.Error} =
  VAR
    frame  := interp.frame;
    stdout := TextWr.New();
  &lt;* FATAL Wr.Failure, Thread.Alerted *&gt;
  BEGIN
    IF interp.depth &gt; 0 THEN
      SLisp.Write(stdout, interp.underEval.tail.head);
      Wr.PutText(stdout, &quot;)\n&quot;);
    END;
    WHILE frame # interp.topFrame DO
      IF frame.procName = NIL OR Text.Length(frame.procName) = 0 THEN
        Wr.PutText(stdout, &quot;  (let&quot;);
      ELSE
        Wr.PutText(stdout, &quot;  (&quot; &amp; frame.procName);
      END;
      FOR i := 0 TO frame.size - 1 DO
        Wr.PutText(stdout, &quot; &quot;);
        WITH atom = frame.table[i].atom,
             sym  = frame.table[i].symbol DO
          IF sym # NIL THEN
            Wr.PutText(stdout, Atom.ToText(sym));
            Wr.PutText(stdout, &quot;: &quot;);
          END;
          SLisp.Write(stdout, atom.val);
        END;
      END;
      Wr.PutText(stdout, &quot;)\n&quot;);
      Wr.Flush(stdout);
      frame := frame.next;
    END;
    ZeusPanel.ReportError(TextWr.ToText(stdout));
    RETURN args;
  END Backtrace;

BEGIN
END GEFLisp.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
