<HTML>
<HEAD>
<TITLE>SRC Modula-3: geometry/src/Interval.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>geometry/src/Interval.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> An <CODE>Interval.T</CODE> is a contiguous set of integers.  An interval <CODE>a</CODE>
   contains an integer <CODE>n</CODE> if
<P>
<PRE>
      a.lo &lt;= n  AND  n &lt; a.hi
</PRE>
   We impose the restriction that if an interval contains no integers, 
   then it must be equal as a record to <CODE>Interval.Empty</CODE>. 

<P><PRE>INTERFACE <interface><A HREF="Interval.m3">Interval</A></interface>;

IMPORT <A HREF="../../word/src/Word.i3">Word</A>;

TYPE T = RECORD lo, hi: INTEGER END;
TYPE Bound = {Lo, Hi};

CONST Empty = T { 0, 0 }; (* A point-like interval *)
CONST Full  = T {FIRST(INTEGER), LAST(INTEGER)}; (* The biggest interval *)
</PRE> --- Initialization --- 

<P><PRE>PROCEDURE <A HREF="Interval.m3#FromBounds">FromBounds</A>(lo, hi: INTEGER): T;
</PRE><BLOCKQUOTE><EM> If <CODE>lo &gt;= hi</CODE> then return <CODE>Empty</CODE>, else return <CODE>T{lo, hi}</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Interval.m3#FromAbsBounds">FromAbsBounds</A>(n, m: INTEGER): T;
</PRE><BLOCKQUOTE><EM> Return <CODE>FromBounds(MIN(n,m), MAX(n,m))</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Interval.m3#FromBound">FromBound</A>(lo: INTEGER; s: CARDINAL): T;
</PRE><BLOCKQUOTE><EM> Return <CODE>FromBounds(lo, lo+s)</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Interval.m3#FromSize">FromSize</A>(s: CARDINAL): T;
</PRE><BLOCKQUOTE><EM> Return <CODE>FromBounds(0, s)</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Interval.m3#Center">Center</A>(READONLY a: T; n: INTEGER): T;
</PRE><BLOCKQUOTE><EM> If <CODE>a</CODE> is empty then return <CODE>Empty</CODE>, else return <CODE>b</CODE> such that
   <CODE>Size(b) = Size(a)</CODE> and <CODE>Middle(b) = n</CODE>.  </EM></BLOCKQUOTE><PRE>
</PRE> --- Selection --- 

<P><PRE>PROCEDURE <A HREF="Interval.m3#Size">Size</A>(READONLY a: T): CARDINAL;
</PRE><BLOCKQUOTE><EM> Return <CODE>a.hi - a.lo</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Interval.m3#Middle">Middle</A>(READONLY a: T): INTEGER;
</PRE><BLOCKQUOTE><EM> Return <CODE>(a.hi + a.lo) DIV 2</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Interval.m3#PickBound">PickBound</A> (READONLY a: T; n: INTEGER): Bound;
</PRE><BLOCKQUOTE><EM> Return the bound of a closest to n (one of them if equidistant) </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Interval.m3#Project">Project</A>(READONLY a: T; n: INTEGER): INTEGER;
</PRE><BLOCKQUOTE><EM> Return the element of <CODE>a</CODE> that is closest to <CODE>n</CODE>.  This
   is a checked runtime error if <CODE>a</CODE> is empty. </EM></BLOCKQUOTE><PRE>
</PRE> --- Transformation --- 

<P><PRE>PROCEDURE <A HREF="Interval.m3#Move">Move</A>(READONLY a: T; n: INTEGER): T;
</PRE><BLOCKQUOTE><EM> Return <CODE>FromBounds(a.lo+n, a.hi+n)</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Interval.m3#Inset">Inset</A>(READONLY a: T; n: INTEGER): T;
</PRE><BLOCKQUOTE><EM> If <CODE>a</CODE> is empty then return <CODE>Empty</CODE>, else return 
   <CODE>FromBounds(a.lo + n, a.hi - n)</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Interval.m3#Change">Change</A>(READONLY a: T; dlo, dhi: INTEGER): T;
</PRE><BLOCKQUOTE><EM> If <CODE>a</CODE> is empty then return <CODE>Empty</CODE>, else return 
  <CODE>FromBounds(a.lo + dlo, a.hi + dhi)</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Interval.m3#MoveBound">MoveBound</A> (x: Bound; READONLY a: T; dn: INTEGER): T;
</PRE><BLOCKQUOTE><EM> If r is empty return empty, else add dn to the edge x of a </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Interval.m3#Join">Join</A>(READONLY a, b: T): T;
</PRE><BLOCKQUOTE><EM> Return the smallest interval containing both <CODE>a</CODE> and <CODE>b</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Interval.m3#Meet">Meet</A>(READONLY a, b: T): T;
</PRE><BLOCKQUOTE><EM> Return the largest interval contained in both of <CODE>a</CODE> and <CODE>b</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Interval.m3#Chop">Chop</A> (READONLY a: T; n: INTEGER; VAR (* out *) b, c: T);
</PRE><BLOCKQUOTE><EM> Chop an interval in two; b is to the left of c </EM></BLOCKQUOTE><PRE>

TYPE Partition = ARRAY [0..2] OF T;

PROCEDURE <A HREF="Interval.m3#Factor">Factor</A> (READONLY a, by: T; VAR (*out*) f: Partition; dn: INTEGER)
 ;
</PRE><BLOCKQUOTE><EM> a is partitioned into 3 pieces f[0]..f[2], where f[1] = Meet (a,by). The
   order of f is such that if i&lt;j then f[i] translated by dn doesn't intersect
   f[j]. (Only the sign of dn affects the order, not its magnitude.) </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Interval.m3#Mod">Mod</A>(n: INTEGER; READONLY a: T): INTEGER;
</PRE><BLOCKQUOTE><EM> Return the member of <CODE>a</CODE> whose distance from <CODE>n</CODE> is a multiple of 
   <CODE>Size(a)</CODE>.  This is a checked runtime error if <CODE>a</CODE> is empty. </EM></BLOCKQUOTE><PRE>
</PRE> --- Test --- 

<P><PRE>PROCEDURE <A HREF="Interval.m3#Equal">Equal</A> (READONLY a, b: T): BOOLEAN;
</PRE><BLOCKQUOTE><EM> Interval equality; as all empty intervals must be represented
   as Empty, this is equivalent to a = b. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Interval.m3#IsEmpty">IsEmpty</A>(READONLY a: T): BOOLEAN;
</PRE><BLOCKQUOTE><EM> Return whether <CODE>a</CODE> is empty. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Interval.m3#Member">Member</A>(n: INTEGER; READONLY a: T): BOOLEAN;
</PRE><BLOCKQUOTE><EM> Return whether <CODE>n</CODE> is in <CODE>a</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Interval.m3#Overlap">Overlap</A>(READONLY a, b: T): BOOLEAN;
</PRE><BLOCKQUOTE><EM> Return whether <CODE>a</CODE> and <CODE>b</CODE> have any element in common. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Interval.m3#Subset">Subset</A>(READONLY a, b: T): BOOLEAN;
</PRE><BLOCKQUOTE><EM> Return whether <CODE>a</CODE> is contained in <CODE>b</CODE>. </EM></BLOCKQUOTE><PRE>
</PRE> --- Standard type operations --- 

<P><PRE>PROCEDURE <A HREF="Interval.m3#Compare">Compare</A> (READONLY a, b: T): [-1 .. 1];
</PRE><BLOCKQUOTE><EM> == RETURN 0 if Equal(a, b), -1 if (a.lo &lt; b.lo) OR ((a.lo = b.lo) AND (a.hi &lt; b.hi)), +1 o.  w.) </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Interval.m3#Hash">Hash</A> (READONLY a: T): Word.T;
</PRE><BLOCKQUOTE><EM> == RETURN a suitable hash value </EM></BLOCKQUOTE><PRE>

END Interval.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
