<HTML>
<HEAD>
<TITLE>SRC Modula-3: geometry/src/Interval.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>geometry/src/Interval.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module><implements><A HREF="Interval.i3">Interval</A></implements></module>;

IMPORT <A HREF="../../word/src/Word.i3">Word</A>, <A HREF="../../text/src/Text.i3">Text</A>;

PROCEDURE <A NAME="FromBounds"><procedure>FromBounds</procedure></A> (lo, hi: INTEGER): T RAISES {} =
  VAR a: T;
  BEGIN
    IF lo &lt; hi THEN a.lo := lo; a.hi := hi;  ELSE a := Empty;  END;
    RETURN a;
  END FromBounds;

PROCEDURE <A NAME="FromAbsBounds"><procedure>FromAbsBounds</procedure></A> (lo, hi: INTEGER): T RAISES {} =
  VAR a: T;
  BEGIN
    IF lo &lt; hi THEN
      a.lo := lo;
      a.hi := hi;
    ELSIF hi &lt; lo THEN
      a.lo := hi;
      a.hi := lo;
    ELSE
      a := Empty
    END;
    RETURN a;
  END FromAbsBounds;

PROCEDURE <A NAME="FromBound"><procedure>FromBound</procedure></A> (lo: INTEGER; s: CARDINAL): T RAISES {} =
  VAR a: T;
  BEGIN
    IF s = 0 THEN RETURN Empty;  END;
    a.lo := lo;
    a.hi := lo + s;
    RETURN a;
  END FromBound;

PROCEDURE <A NAME="FromSize"><procedure>FromSize</procedure></A> (s: CARDINAL): T RAISES {} =
  VAR a: T;
  BEGIN
    a.lo := 0; a.hi := s; RETURN a;
  END FromSize;

PROCEDURE <A NAME="Center"><procedure>Center</procedure></A> (READONLY a: T; b: INTEGER): T RAISES {} =
  VAR res: T; d: INTEGER;
  BEGIN
    IF a.lo = a.hi THEN RETURN a END;
    d := b - (a.lo + a.hi) DIV 2;
    res.lo := a.lo + d;
    res.hi := a.hi + d;
    RETURN res;
  END Center;

PROCEDURE <A NAME="Size"><procedure>Size</procedure></A> (READONLY a: T): CARDINAL RAISES {} =
  BEGIN
    RETURN a.hi - a.lo;
  END Size;

PROCEDURE <A NAME="PickBound"><procedure>PickBound</procedure></A> (READONLY a: T; n: INTEGER): Bound RAISES {} =
  BEGIN
    IF n &lt;= Middle (a) THEN RETURN Bound.Lo ELSE RETURN Bound.Hi END;
  END PickBound;

PROCEDURE <A NAME="Project"><procedure>Project</procedure></A> (READONLY a: T; n: INTEGER): INTEGER RAISES {} =
  BEGIN
    IF (a.hi &lt;= a.lo) THEN FAIL(&quot;Interval.Project: empty interval&quot;) END;
    RETURN MAX (a.lo, MIN (a.hi - 1, n))
  END Project;

PROCEDURE <A NAME="Middle"><procedure>Middle</procedure></A> (READONLY a: T): INTEGER RAISES {} =
  BEGIN RETURN (a.lo + a.hi) DIV 2 END Middle;

PROCEDURE <A NAME="Move"><procedure>Move</procedure></A> (READONLY a: T; n: INTEGER): T RAISES {} =
  VAR b: T;
  BEGIN
    IF a.lo &gt;= a.hi THEN RETURN Empty END;
    b.lo := a.lo + n;
    b.hi := a.hi + n;
    RETURN b;
  END Move;

PROCEDURE <A NAME="Inset"><procedure>Inset</procedure></A> (READONLY a: T; n: INTEGER): T RAISES {} =
  VAR b: T;
  BEGIN
    IF a.lo &gt;= a.hi THEN RETURN Empty END;
    b.lo := a.lo + n;
    b.hi := a.hi - n;
    IF b.lo &gt;= b.hi THEN RETURN Empty END;
    RETURN b
  END Inset;

PROCEDURE <A NAME="Change"><procedure>Change</procedure></A> (READONLY a: T; dlo, dhi: INTEGER): T RAISES {} =
  VAR b: T;
  BEGIN
    IF a.lo &gt;= a.hi THEN RETURN Empty;  END;
    b.lo := a.lo + dlo;
    b.hi := a.hi + dhi;
    IF b.lo &gt;= b.hi THEN RETURN Empty;  END;
    RETURN b;
  END Change;

PROCEDURE <A NAME="MoveBound"><procedure>MoveBound</procedure></A> (x: Bound; READONLY a: T; dn: INTEGER): T RAISES {} =
  VAR b: T;
  BEGIN
    IF a.lo &gt;= a.hi THEN RETURN Empty;  END;
    b := a;
    IF (x = Bound.Lo) THEN b.lo := b.lo + dn;  ELSE b.hi := b.hi + dn;  END;
    IF b.lo &gt;= b.hi THEN RETURN Empty;  END;
    RETURN b;
  END MoveBound;

PROCEDURE <A NAME="Join"><procedure>Join</procedure></A> (READONLY a, b: T): T RAISES {} =
  VAR c: T;
  BEGIN
    IF a.lo &gt;= a.hi THEN RETURN b;  END;
    IF b.lo &gt;= b.hi THEN RETURN a;  END;
    c.lo := MIN (a.lo, b.lo);
    c.hi := MAX (a.hi, b.hi);
    RETURN c;
  END Join;

PROCEDURE <A NAME="Meet"><procedure>Meet</procedure></A> (READONLY a, b: T): T RAISES {} =
  VAR c: T;
  BEGIN
    c.lo := MAX (a.lo, b.lo);
    c.hi := MIN (a.hi, b.hi);
    IF c.lo &gt;= c.hi THEN RETURN Empty;  END;
    RETURN c;
  END Meet;

PROCEDURE <A NAME="Chop"><procedure>Chop</procedure></A> (READONLY a: T; n: INTEGER; VAR (* out *) b, c: T) RAISES {} =
  BEGIN
    IF n &lt;= a.lo THEN
      b := Empty;
      c := a
    ELSIF n &gt;= a.hi THEN
      b := a;
      c := Empty
    ELSE
      b.lo := a.lo;
      b.hi := n;
      c.lo := n;
      c.hi := a.hi
    END
  END Chop;

PROCEDURE <A NAME="Factor"><procedure>Factor</procedure></A> (READONLY a, by: T;  VAR (*out*) f: Partition; dn: INTEGER)
  RAISES {} =
  VAR index: [0..2]; temp: T;
  BEGIN
    IF dn &gt; 0 THEN index := 2;  ELSE index := 0;  END;
    Chop (a, by.lo, f[index], temp);
    Chop (temp, by.hi, f[1], f[2 - index]);
  END Factor;

PROCEDURE <A NAME="Mod"><procedure>Mod</procedure></A> (n: INTEGER; READONLY a: T): INTEGER RAISES {} =
  VAR res: INTEGER;
  BEGIN
    IF (a.lo &gt;= a.hi) THEN FAIL(&quot;Interval.Mod: a is empty!&quot;) END;
    res := (n - a.lo) MOD (a.hi - a.lo);
    RETURN res + a.lo
  END Mod;

PROCEDURE <A NAME="Equal"><procedure>Equal</procedure></A> (READONLY a, b: T): BOOLEAN RAISES {} =
  BEGIN RETURN a = b END Equal;

PROCEDURE <A NAME="IsEmpty"><procedure>IsEmpty</procedure></A> (READONLY a: T): BOOLEAN RAISES {} =
  BEGIN RETURN a.lo &gt;= a.hi; END IsEmpty;

PROCEDURE <A NAME="Member"><procedure>Member</procedure></A> (n: INTEGER; READONLY a: T): BOOLEAN RAISES {} =
  BEGIN RETURN (a.lo &lt;= n) AND (n &lt; a.hi) END Member;

PROCEDURE <A NAME="Overlap"><procedure>Overlap</procedure></A> (READONLY a, b: T): BOOLEAN RAISES {} =
  BEGIN
    RETURN MAX (a.lo, b.lo) &lt; MIN (a.hi, b.hi);
  END Overlap;

PROCEDURE <A NAME="Subset"><procedure>Subset</procedure></A> (READONLY a, b: T): BOOLEAN RAISES {} =
  BEGIN
    RETURN (a.lo &gt;= a.hi) OR ((a.lo &gt;= b.lo) AND (a.hi &lt;= b.hi));
  END Subset;

PROCEDURE <A NAME="Compare"><procedure>Compare</procedure></A> (READONLY a, b: T): [-1..1] =
  BEGIN
    IF (a.lo &lt; b.lo) THEN
      RETURN  -1;
    ELSIF (a.lo &gt; b.lo) THEN
      RETURN  +1;
    ELSIF (a.hi = b.hi) THEN
      RETURN 0;
    ELSIF (a.hi &lt; b.hi) THEN
      RETURN  -1;
    ELSE
      RETURN  +1;
    END;
  END Compare;

PROCEDURE <A NAME="Hash"><procedure>Hash</procedure></A> (READONLY a: T): Word.T =
  BEGIN
    RETURN Word.Xor (a.lo, a.hi);
  END Hash;

EXCEPTION ASSERT_FAILED (Text.T);
&lt;*INLINE*&gt; PROCEDURE <A NAME="FAIL"><procedure>FAIL</procedure></A> (msg: Text.T := NIL) =
&lt;*FATAL ASSERT_FAILED*&gt;
  BEGIN
    RAISE ASSERT_FAILED (msg);
  END FAIL;

BEGIN
END Interval.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
