<HTML>
<HEAD>
<TITLE>SRC Modula-3: geometry/src/Path.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>geometry/src/Path.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE> Path.def, by Greg Nelson, Wed Nov 12 00:05:53 1986                        
<PRE>&lt;*PRAGMA LL*&gt;
</PRE> A <CODE>Path.T</CODE> is a sequence of straight and curved line segments,
   suitable for stroking or filling.
<P>
   A {\it segment} is a directed arc in the Cartesian plane determined
   by two cubic polynomials <CODE>h(t)</CODE>, <CODE>v(t)</CODE>, where <CODE>t</CODE> ranges over the
   interval of real numbers <CODE>[0, 1]</CODE>. The segment is said to {\it start}
   at <CODE>(h(0), v(0))</CODE> and {\it end} at <CODE>(h(1), v(1))</CODE>.  If <CODE>h</CODE> and <CODE>v</CODE>
   are linear functions of <CODE>t</CODE>, then the segment is {\it linear}: it
   consists of a line segment.  If <CODE>h</CODE> and <CODE>v</CODE> are constant functions of
   <CODE>t</CODE>, then the segment is {\it degenerate}: it consists of a single
   point.
<P>
   The segments of a path are grouped into contiguous {\it subpaths},
   which can be {\it open} or {\it closed}.  Within a subpath, each 
   segment starts where the previous segment ends.  In a closed subpath,
   the last segment ends where the first segment starts.  (This may also 
   happen for an open subpath, but this coincidence does not make the
   subpath closed.)
<P>
   The {\it current point} of a path is the endpoint of the last segment
   of its last subpath, assuming this subpath is open.  If the path is 
   empty or if the last subpath is closed, the current point is undefined.   

<P><PRE>INTERFACE <interface><A HREF="Path.m3">Path</A></interface>;

IMPORT <A HREF="Point.i3">Point</A>, <A HREF="Rect.i3">Rect</A>;

TYPE T &lt;: ROOT;
</PRE> The call <CODE>NEW(Path.T)</CODE> creates an empty path. 

<P><PRE>PROCEDURE <A HREF="Path.m3#Reset">Reset</A>(path: T);
</PRE><BLOCKQUOTE><EM> Set <CODE>path</CODE> to be empty. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Path.m3#MoveTo">MoveTo</A>(path: T; READONLY p: Point.T);
</PRE><BLOCKQUOTE><EM> Extend <CODE>path</CODE> with a new degenerate segment that starts 
   and ends at <CODE>p</CODE>. This begins a new subpath. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Path.m3#LineTo">LineTo</A>(path: T; READONLY p: Point.T);
</PRE><BLOCKQUOTE><EM> Extend <CODE>path</CODE> with a linear segment that starts
   at its current point and ends at <CODE>p</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Path.m3#CurveTo">CurveTo</A>(path: T; READONLY q, r, s: Point.T);
</PRE><BLOCKQUOTE><EM> Extend <CODE>path</CODE> with a curved segment that starts
   at its current point and ends at <CODE>s</CODE>.  </EM></BLOCKQUOTE><PRE>
</PRE> <CODE>CurveTo</CODE> adds a curve that starts from the current point of <CODE>path</CODE>
   in the direction of <CODE>q</CODE>, and ends at <CODE>s</CODE> coming from the direction 
   of <CODE>r</CODE>.  More precisely, let <CODE>p</CODE> be the current point of <CODE>path</CODE>
   and let <CODE>h(t)</CODE> and <CODE>v(t)</CODE> be the cubic polynomials such that
<P>
<PRE>
      (h(0), v(0)) = p	
      (h(1), v(1)) = s
      (h'(0), v'(0)) = 3 * (q - p)
      (h'(1), v'(1)) = 3 * (s - r)
</PRE>
   (Where the primes denote differentiation with respect to <CODE>t</CODE>.)  Then
   <CODE>CurveTo</CODE> adds the segment <CODE>(h(t), v(t))</CODE> for <CODE>t</CODE> between zero and
   one.  (This is called the {\it Bezier} arc determined by <CODE>p</CODE>, <CODE>q</CODE>,
   <CODE>r</CODE>, and <CODE>s</CODE>.)  

<P><PRE>PROCEDURE <A HREF="Path.m3#Close">Close</A>(path: T);
</PRE><BLOCKQUOTE><EM> Add a linear segment to create a closed loop in <CODE>path</CODE>. </EM></BLOCKQUOTE><PRE>
</PRE> More precisely, let <CODE>p</CODE> be the current point of <CODE>path</CODE>, and let
  <CODE>q</CODE> be last point of <CODE>path</CODE> that was added by a call to <CODE>MoveTo</CODE>
  (Thus <CODE>q</CODE> is the startpoint of the first segment of the last subpath
  of <CODE>path</CODE>.)  <CODE>Close</CODE> adds a linear segment from <CODE>p</CODE> to <CODE>q</CODE> and marks
  the sequence of segments from <CODE>q</CODE> to the end of the path as a closed
  subpath.  

<P><PRE>PROCEDURE <A HREF="Path.m3#IsEmpty">IsEmpty</A>(p: T): BOOLEAN;
</PRE><BLOCKQUOTE><EM> Returns <CODE>TRUE</CODE> if <CODE>p</CODE> is empty. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Path.m3#IsClosed">IsClosed</A>(p: T): BOOLEAN;
</PRE><BLOCKQUOTE><EM> Returns <CODE>TRUE</CODE> if <CODE>p</CODE> is empty or the last subpath of <CODE>p</CODE> is closed. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Path.m3#CurrentPoint">CurrentPoint</A>(p: T): Point.T;
</PRE><BLOCKQUOTE><EM> Returns the current point of <CODE>p</CODE>. </EM></BLOCKQUOTE><PRE>
</PRE> <CODE>LineTo</CODE>, <CODE>CurveTo</CODE>, <CODE>Close</CODE>, and <CODE>CurrentPoint</CODE> are checked runtime 
   errors if the path has no current point. 

<P><PRE>EXCEPTION Malformed;
</PRE> The <CODE>Malformed</CODE> exception is raised when a procedure detects
   a malformed path. 

<P><PRE>PROCEDURE <A HREF="Path.m3#Translate">Translate</A>(p: T; READONLY delta: Point.T): T
  RAISES {Malformed};
</PRE><BLOCKQUOTE><EM> The result of translating <CODE>p</CODE> by <CODE>delta</CODE>. </EM></BLOCKQUOTE><PRE>

TYPE
  MapObject = OBJECT METHODS
    move(READONLY pt: Point.T);
    line(READONLY pt1, pt2: Point.T);
    close(READONLY pt1, pt2: Point.T);
    curve(READONLY pt1, pt2, pt3, pt4: Point.T)
  END;

PROCEDURE <A HREF="Path.m3#Map">Map</A>(path: T; map: MapObject) RAISES {Malformed};
</PRE><BLOCKQUOTE><EM> Apply the appropriate method of <CODE>map</CODE> to each segment of <CODE>path</CODE>. </EM></BLOCKQUOTE><PRE>
</PRE> That is, for each segment <CODE>s</CODE> of <CODE>path</CODE>, in order, <CODE>Map</CODE> excecutes
   the following:
<P>
<PRE>
      IF s <KBD>is a linear segment</KBD> (p, q) THEN
        IF s <KBD>was generated by</KBD> MoveTo THEN
           (* p = q 

<PRE>|      map.move(p)
|   ELSIF s `was generated by` LineTo THEN
|     map.line(p, q)
|   ELSE (* s `was generated by` Close *)
|     map.close(p, q)
|   END
| ELSE (* s `is a curved segment` (p, q, r, s) *)
|   map.curve(p, q, r, s)
| END

&quot;Map&quot; raises the exception if it is passed a malformed path. *)

PROCEDURE <A HREF="Path.m3#Copy">Copy</A>(p: T): T;
</PRE><BLOCKQUOTE><EM> Returns a newly allocated path with the same contents as <CODE>p</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Path.m3#Flatten">Flatten</A>(p: T): T RAISES {Malformed};
</PRE><BLOCKQUOTE><EM> Return a path like <CODE>p</CODE> but with curved segments replaced by
   polygonal approximations. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Path.m3#BoundingBox">BoundingBox</A>(p: T): Rect.T RAISES {Malformed};
</PRE><BLOCKQUOTE><EM> Return a rectangle that contains all points of <CODE>p</CODE>, and that is as
   small as convenient to compute. </EM></BLOCKQUOTE><PRE>

END Path.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
