<HTML>
<HEAD>
<TITLE>SRC Modula-3: geometry/src/Path.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>geometry/src/Path.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE> Path.mod, by cgn, mkent and msm, Wed Nov 12 17:58:38 1986 
<PRE>UNSAFE MODULE <module>Path</module> EXPORTS <A HREF="Path.i3"><implements>Path</A></implements>, <A HREF="#x1"><implements>PathPrivate</A></implements>;
&lt;*PRAGMA LL*&gt;

IMPORT <A HREF="Point.i3">Point</A>, <A HREF="Rect.i3">Rect</A>, <A HREF="../../word/src/Word.i3">Word</A>;

CONST InitialSize = 32;

PROCEDURE <A NAME="Freeze"><procedure>Freeze</procedure></A>(path: T): Lock =
  VAR res: Lock; BEGIN
    IF path.points = NIL THEN RETURN NIL END;
    res := ADR(path.points[0]);
    IF res # path.start THEN
      WITH delta = res - path.start DO
        INC(path.start, delta);
        INC(path.current, delta);
        INC(path.next, delta);
        INC(path.end, delta)
      END
    END;
    RETURN res
  END Freeze;

PROCEDURE <A NAME="Thaw"><procedure>Thaw</procedure></A>(&lt;*UNUSED*&gt;l: Lock) =
  BEGIN END Thaw;

PROCEDURE <A NAME="ReAllocate"><procedure>ReAllocate</procedure></A>(path: T; VAR l: Lock) =
  VAR newPoints: ArrayRef; nl: Lock; BEGIN
    IF path.points = NIL THEN
      newPoints := NEW(ArrayRef, InitialSize);
      nl := ADR(newPoints[0]);
      path.start := nl;
      path.next := nl;
      path.current := nl
    ELSE
      newPoints := NEW(ArrayRef, 2 * NUMBER(path.points^));
      nl := ADR(newPoints[0]);
      SUBARRAY(newPoints^, 0, NUMBER(path.points^)) := path.points^;
      WITH delta = nl - path.start DO
        INC(path.start, delta);
        INC(path.next, delta);
        INC(path.current, delta)
      END
    END;
    path.end := nl + ADRSIZE(Word.T) * NUMBER(newPoints^);
    l := nl;
    path.points := newPoints
  END ReAllocate;

PROCEDURE <A NAME="Reset"><procedure>Reset</procedure></A>(path: T) =
  BEGIN
    path.next := path.start;
    path.current := path.start;
    path.curveCount := 0
  END Reset;

CONST
  LineSize = ADRSIZE (LineRec);
  CurveSize = ADRSIZE (CurveRec);

PROCEDURE <A NAME="MoveTo"><procedure>MoveTo</procedure></A>(path: T; READONLY pt: Point.T) =
  VAR l := Freeze(path); BEGIN
    IF path.end - path.next &lt; LineSize THEN ReAllocate(path, l) END;
    VAR ptr: PLine := path.next; BEGIN
      ptr.ct := Type.Move;
      ptr.p := pt
    END;
    path.current := path.next;
    INC(path.next, LineSize);
    Thaw(l)
  END MoveTo;

EXCEPTION FatalError(TEXT); &lt;*FATAL FatalError*&gt;

PROCEDURE <A NAME="LineTo"><procedure>LineTo</procedure></A>(path: T; READONLY pt: Point.T) =
  VAR l := Freeze(path); BEGIN
    IF path.current = path.next THEN
      RAISE FatalError(&quot;LineTo with no current point&quot;)
    END;
    IF path.end - path.next &lt; LineSize THEN ReAllocate(path, l) END;
    VAR ptr: PLine := path.next; BEGIN
      ptr.ct := Type.Line;
      ptr.p := pt
    END;
    INC(path.next, LineSize);
    Thaw(l)
  END LineTo;

PROCEDURE <A NAME="Close"><procedure>Close</procedure></A>(path: T) =
  VAR l := Freeze(path); BEGIN
    IF path.current = path.next THEN
      RAISE FatalError(&quot;Close with no current point&quot;)
    END;
    IF path.end - path.next &lt; LineSize THEN ReAllocate(path, l) END;
    VAR ptr: PLine := path.next; BEGIN
      ptr.ct := Type.Close;
      ptr.p := LOOPHOLE(path.current, PLine).p
    END;
    INC(path.next, LineSize);
    path.current := path.next;
    Thaw(l)
  END Close;

PROCEDURE <A NAME="CurveTo"><procedure>CurveTo</procedure></A> (path: T; READONLY p, q, r: Point.T) =
  VAR l := Freeze(path); BEGIN
    IF path.current = path.next THEN
      RAISE FatalError(&quot;CurveTo with no current point&quot;)
    END;
    IF path.end - path.next &lt; CurveSize THEN ReAllocate(path, l) END;
    VAR ptr: PCurve := path.next; BEGIN
      ptr.ct := Type.Curve;
      ptr.p := p;
      ptr.q := q;
      ptr.r := r
    END;
    INC(path.next, CurveSize);
    INC(path.curveCount);
    Thaw(l)
  END CurveTo;

PROCEDURE <A NAME="Map"><procedure>Map</procedure></A>(path: T; map: MapObject) RAISES {Malformed} =
  VAR l := Freeze(path); ptr: PCurve; current: Point.T; BEGIN
    ptr := path.start;
    WHILE ptr &lt; path.next DO
      CASE ptr.ct OF
        Type.Move =&gt;
          map.move(ptr.p); current := ptr.p; INC(ptr, LineSize)
      | Type.Line =&gt;
          map.line(current, ptr.p);
          current := ptr.p;
          INC(ptr, LineSize)
      | Type.Curve =&gt;
          map.curve(current, ptr.p, ptr.q, ptr.r);
          current := ptr.r;
          INC(ptr, CurveSize)
      | Type.Close =&gt;
          map.close(current, ptr.p);
          INC(ptr, LineSize)
      ELSE
        RAISE Malformed
      END
    END;
    IF ptr # path.next THEN RAISE Malformed END;
    Thaw(l)
  END Map;

PROCEDURE <A NAME="Translate"><procedure>Translate</procedure></A>(path: T; READONLY delta: Point.T): T RAISES {Malformed} =
  VAR l := Freeze(path); res := Copy(path); BEGIN
    DTranslate(res, delta);
    Thaw(l);
    RETURN res
  END Translate;

PROCEDURE <A NAME="DTranslate"><procedure>DTranslate</procedure></A>(path: T; READONLY delta: Point.T) RAISES {Malformed} =
  VAR ptr: PCurve := path.start; BEGIN
    WHILE ptr &lt; path.next DO
      CASE ptr.ct OF
        Type.Move, Type.Line, Type.Close =&gt;
          ptr.p := Point.Add(ptr.p, delta); INC(ptr, LineSize)
      | Type.Curve =&gt;
          ptr.p := Point.Add(ptr.p, delta);
          ptr.q := Point.Add(ptr.q, delta);
          ptr.r := Point.Add(ptr.r, delta);
          INC(ptr, CurveSize)
      ELSE
        RAISE Malformed
      END
    END;
    IF ptr # path.next THEN RAISE Malformed END
  END DTranslate;

PROCEDURE <A NAME="IsClosed"><procedure>IsClosed</procedure></A> (path: T): BOOLEAN =
  BEGIN
    RETURN path.current = path.next
  END IsClosed;

PROCEDURE <A NAME="IsEmpty"><procedure>IsEmpty</procedure></A> (path: T): BOOLEAN =
  BEGIN
    RETURN path.next = path.start
  END IsEmpty;

PROCEDURE <A NAME="CurrentPoint"><procedure>CurrentPoint</procedure></A> (path: T): Point.T =
  VAR l := Freeze(path); ptr: UNTRACED REF Point.T; res: Point.T; BEGIN
    IF path.next = path.current THEN
      RAISE FatalError(&quot;No currentpoint&quot;)
    END;
    ptr := path.next - ADRSIZE(Point.T);
    res := ptr^;
    Thaw(l);
    RETURN res
  END CurrentPoint;

PROCEDURE <A NAME="Copy"><procedure>Copy</procedure></A> (path: T): T =
  BEGIN
    IF path.next # path.start THEN
      IF (path.points = NIL) THEN
        RETURN NEW(T, points := NIL, start := path.start, next := path.next,
                   current := path.current, end := path.end,
                   curveCount := path.curveCount);
      END;
      WITH l1        = Freeze(path),
           pathWords = (path.next - path.start) DIV ADRSIZE(Word.T),
           res = NEW(
                   T, points := NEW(ArrayRef, MAX(InitialSize, pathWords))),
           l2 = Freeze(res) DO
        res.start := ADR(res.points[0]);
	IF path.points # NIL THEN
          SUBARRAY(res.points^, 0, pathWords) :=
            SUBARRAY(path.points^, 0, pathWords)
	ELSE
	  VAR p,q: UNTRACED REF Word.T;
	  BEGIN
	    p := path.start;
	    q := res.start;
	    FOR i := 0 TO pathWords DO
	      q^ := p^;
	      p := p + ADRSIZE(Word.T);
	      q := q + ADRSIZE(Word.T)
	    END
	  END
	END;
        WITH delta = res.start - path.start DO
          res.next := path.next + delta;
          res.current := path.current + delta
        END;
        res.end := res.start + ADRSIZE(Word.T) * NUMBER(res.points^);
        res.curveCount := path.curveCount;
        Thaw(l1);
        Thaw(l2);
        RETURN res
      END
    ELSE
      RETURN NEW(T)
    END;
  END Copy;

PROCEDURE <A NAME="Flatten"><procedure>Flatten</procedure></A>(p: T): T RAISES {Malformed} =
  VAR flat: FlatMap;
  BEGIN
    IF p.curveCount = 0 THEN RETURN p END;
    flat := NEW(FlatMap, res := NEW(T));
    Map(p, flat);
    RETURN flat.res
  END Flatten;

TYPE FlatMap =
  MapObject OBJECT
    res: T;
  OVERRIDES
    line := FlatLine;
    move := FlatMove;
    close := FlatClose;
    curve := FlatCurve
  END;

PROCEDURE <A NAME="FlatLine"><procedure>FlatLine</procedure></A>(self: FlatMap; &lt;*UNUSED*&gt;
  READONLY p: Point.T; READONLY q: Point.T) =
  BEGIN
    LineTo(self.res, q)
  END FlatLine;

PROCEDURE <A NAME="FlatClose"><procedure>FlatClose</procedure></A>(self: FlatMap; &lt;*UNUSED*&gt; READONLY p, q: Point.T) =
  BEGIN
    Close(self.res)
  END FlatClose;

PROCEDURE <A NAME="FlatMove"><procedure>FlatMove</procedure></A>(self: FlatMap; READONLY q: Point.T) =
  BEGIN
    MoveTo(self.res, q)
  END FlatMove;

TYPE Bezier = RECORD ph, pv, qh, qv, rh, rv, sh, sv: INTEGER END;

PROCEDURE <A NAME="FlatCurve"><procedure>FlatCurve</procedure></A>(self: FlatMap; READONLY pp, qq, rr, ss: Point.T) =
  BEGIN
    NonMonotonicFlatCurve(self, 4*pp.h, 4*pp.v, 4*qq.h, 4*qq.v,
      4*rr.h, 4*rr.v, 4*ss.h, 4*ss.v)
  END FlatCurve;

PROCEDURE <A NAME="NonMonotonicFlatCurve"><procedure>NonMonotonicFlatCurve</procedure></A>(self: FlatMap;
  ph, pv, qh, qv, rh, rv, sh, sv: INTEGER) =
  VAR st: ARRAY [0..20] OF Bezier; n := 0;
      ah, av, bh, bv, ch, cv, dh, dv, eh, ev, fh, fv: INTEGER;
  BEGIN
    LOOP
      IF ( ph &lt;= qh AND qh &lt;= rh AND rh &lt;= sh
        OR ph &gt;= qh AND qh &gt;= rh AND rh &gt;= sh )
      AND
         ( pv &lt;= qv AND qv &lt;= rv AND rv &lt;= sv
        OR pv &gt;= qv AND qv &gt;= rv AND rv &gt;= sv )
      THEN
        MonotonicFlatCurve(self, ph, pv, qh, qv, rh, rv, sh, sv);
        IF n = 0 THEN RETURN END;
        DEC(n);
        WITH top = st[n] DO
          ph := top.ph; pv := top.pv;
          qh := top.qh; qv := top.qv;
          rh := top.rh; rv := top.rv;
          sh := top.sh; sv := top.sv
        END
      ELSE
        (* subdivide *)
        ah := (ph + qh) DIV 2; av := (pv + qv) DIV 2;
        bh := (qh + rh) DIV 2; bv := (qv + rv) DIV 2;
        ch := (rh + sh) DIV 2; cv := (rv + sv) DIV 2;
        dh := (ah + bh) DIV 2; dv := (av + bv) DIV 2;
        eh := (bh + ch) DIV 2; ev := (bv + cv) DIV 2;
        fh := (dh + eh) DIV 2; fv := (dv + ev) DIV 2;
        IF n = NUMBER(st) THEN
          NonMonotonicFlatCurve(self, ph, pv, ah, av, dh, dv, fh, fv);
          ph := fh; pv := fv;
          qh := eh; qv := ev;
          rh := ch; rv := cv
        ELSE
          WITH top = st[n] DO
            top.ph := fh; top.pv := fv;
            top.qh := eh; top.qv := ev;
            top.rh := ch; top.rv := cv;
            top.sh := sh; top.sv := sv
          END;
          INC(n);
          qh := ah; qv := av;
          rh := dh; rv := dv;
          sh := fh; sv := fv
        END
      END
    END
  END NonMonotonicFlatCurve;

PROCEDURE <A NAME="MonotonicFlatCurve"><procedure>MonotonicFlatCurve</procedure></A>(self: FlatMap;
    ph, pv, qh, qv, rh, rv, sh, sv: INTEGER) =
  VAR st: ARRAY [0..20] OF Bezier; n := 0;
      res := self.res;
      ah, av, bh, bv, ch, cv, dh, dv, eh, ev, fh, fv: INTEGER;
  BEGIN
    LOOP
      ah := qh - ph;
      av := qv - pv;
      bh := rh - ph;
      bv := rv - pv;
      ch := sh - ph;
      cv := sv - pv;
      dh := ah * cv - av * ch;
      dv := bh * cv - bv * ch;
      eh := ABS(ch) + ABS(cv);
      IF ABS(dh) &lt;= eh AND ABS(dv) &lt;= eh THEN
        LineTo(res, Point.T{sh DIV 4, sv DIV 4});
        IF n = 0 THEN RETURN END;
        DEC(n);
        WITH top = st[n] DO
          ph := top.ph; pv := top.pv;
          qh := top.qh; qv := top.qv;
          rh := top.rh; rv := top.rv;
          sh := top.sh; sv := top.sv
        END
      ELSE
        (* subdivide *)
        ah := (ph + qh) DIV 2; av := (pv + qv) DIV 2;
        bh := (qh + rh) DIV 2; bv := (qv + rv) DIV 2;
        ch := (rh + sh) DIV 2; cv := (rv + sv) DIV 2;
        dh := (ah + bh) DIV 2; dv := (av + bv) DIV 2;
        eh := (bh + ch) DIV 2; ev := (bv + cv) DIV 2;
        fh := (dh + eh) DIV 2; fv := (dv + ev) DIV 2;
        IF n = NUMBER(st) THEN
          MonotonicFlatCurve(self, ph, pv, ah, av, dh, dv, fh, fv);
          ph := fh; pv := fv;
          qh := eh; qv := ev;
          rh := ch; rv := cv
        ELSE
          WITH top = st[n] DO
            top.ph := fh; top.pv := fv;
            top.qh := eh; top.qv := ev;
            top.rh := ch; top.rv := cv;
            top.sh := sh; top.sv := sv
          END;
          INC(n);
          qh := ah; qv := av;
          rh := dh; rv := dv;
          sh := fh; sv := fv
        END
      END
    END
  END MonotonicFlatCurve;

TYPE
  BBClosure = MapObject OBJECT
    res: Rect.T
  OVERRIDES
    move := BBMove;
    line := BBLine;
    close := BBClose;
    curve := BBCurve
  END;

PROCEDURE <A NAME="BBMove"><procedure>BBMove</procedure></A>(
    bbc: BBClosure;
    READONLY pt: Point.T) =
  BEGIN
    WITH r = bbc.res DO
      IF Rect.IsEmpty(r) THEN
    	r := Rect.FromPoint(pt)
      ELSE
    	r.west := MIN(r.west, pt.h);
        r.east := MAX(r.east, pt.h+1);
        r.north := MIN(r.north, pt.v);
        r.south := MAX(r.south, pt.v+1)
      END
    END
  END BBMove;

PROCEDURE <A NAME="BBClose"><procedure>BBClose</procedure></A>(
    &lt;*UNUSED*&gt; bbc: BBClosure;
    &lt;*UNUSED*&gt; READONLY pt1, pt2: Point.T) =
  BEGIN END BBClose;

PROCEDURE <A NAME="BBLine"><procedure>BBLine</procedure></A>(
    bbc: BBClosure;
    &lt;*UNUSED*&gt; READONLY pt1: Point.T;
    READONLY pt2: Point.T) =
  BEGIN
    WITH r = bbc.res DO
      r.west := MIN(r.west, pt2.h);
      r.east := MAX(r.east, pt2.h+1);
      r.north := MIN(r.north, pt2.v);
      r.south := MAX(r.south, pt2.v+1)
    END
  END BBLine;

PROCEDURE <A NAME="BBCurve"><procedure>BBCurve</procedure></A>(bbc: BBClosure; READONLY p, q, r, s: Point.T) =
  VAR psRect := RectHull(p, s); BEGIN
    IF Rect.Member(q, psRect) AND Rect.Member(r, psRect) THEN
      bbc.res := Rect.Join(bbc.res, psRect)
    ELSE
      VAR ah, av, bh, bv, ch, cv, dh, dv, eh, ev, fh, fv: INTEGER; BEGIN
        (* quadruple and subdivide *)
        ah := (p.h + q.h) * 2; av := (p.v + q.v) * 2;
        bh := (q.h + r.h) * 2; bv := (q.v + r.v) * 2;
        ch := (r.h + s.h) * 2; cv := (r.v + s.v) * 2;
        dh := (ah + bh) DIV 2; dv := (av + bv) DIV 2;
        eh := (bh + ch) DIV 2; ev := (bv + cv) DIV 2;
        fh := (dh + eh) DIV 2; fv := (dv + ev) DIV 2;
        WITH res = bbc.res DO
          JoinPoint(res, p);
          JoinPoint(res, Point.T{ah DIV 4, av DIV 4});
          JoinPoint(res, Point.T{dh DIV 4, dv DIV 4});
          JoinPoint(res, Point.T{fh DIV 4, fv DIV 4});
          JoinPoint(res, Point.T{eh DIV 4, ev DIV 4});
          JoinPoint(res, Point.T{ch DIV 4, cv DIV 4});
          JoinPoint(res, s)
        END
      END
    END
  END BBCurve;

PROCEDURE <A NAME="RectHull"><procedure>RectHull</procedure></A>(READONLY p, q: Point.T): Rect.T =
  BEGIN
    RETURN Rect.T{
      MIN(p.h, q.h), MAX(p.h, q.h) + 1,
      MIN(p.v, q.v), MAX(p.v, q.v) + 1}
  END RectHull;

PROCEDURE <A NAME="JoinPoint"><procedure>JoinPoint</procedure></A>(VAR r: Rect.T; READONLY pt: Point.T) =
</PRE><BLOCKQUOTE><EM> Requires <CODE>NOT Rect.IsEmpty(r)</CODE>. </EM></BLOCKQUOTE><PRE>
  BEGIN
    r.west := MIN(r.west, pt.h);
    r.east := MAX(r.east, pt.h + 1);
    r.north := MIN(r.north, pt.v);
    r.south := MAX(r.south, pt.v + 1)
  END JoinPoint;

PROCEDURE <A NAME="BoundingBox"><procedure>BoundingBox</procedure></A>(p: T): Rect.T RAISES {Malformed} =
  VAR cl := NEW(BBClosure, res := Rect.Empty); BEGIN
    Map(p, cl);
    RETURN cl.res
  END BoundingBox;

BEGIN
END Path.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface PathPrivate is in:
</A><UL>
<LI><A HREF="PathPrivate.i3#0TOP0">geometry/src/PathPrivate.i3</A>
<LI><A HREF="../../mg/src/PathPrivate.i3#0TOP0">mg/src/PathPrivate.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
