<HTML>
<HEAD>
<TITLE>SRC Modula-3: geometry/src/Point.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>geometry/src/Point.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE> A <CODE>Point.T</CODE> is a pair of integers representing a position in the
   plane.  If <CODE>pt</CODE> is a point, then <CODE>pt.h</CODE> is the distance of <CODE>pt</CODE> to
   the right of the coordinate origin, and <CODE>pt.v</CODE> is the distance of
   <CODE>pt</CODE> below the coordinate origin.  That is, the <CODE>hv</CODE> coordinate
   system is related to the Cartesian coordinate system by the equation
   <CODE>(h, v) = (x, -y)</CODE>.  
   <P>
   Index: points; geometry, points 
   
<P><PRE>INTERFACE <interface><A HREF="Point.m3">Point</A></interface>;

IMPORT <A HREF="Axis.i3">Axis</A>, <A HREF="../../word/src/Word.i3">Word</A>;

TYPE T = RECORD h, v: INTEGER END;

CONST Origin = T { 0, 0 };
</PRE> --- Initialization --- 

<P><PRE>PROCEDURE <A HREF="Point.m3#FromCoords">FromCoords</A> (h, v: INTEGER): T;
</PRE><BLOCKQUOTE><EM> Build a point out of integers </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Point.m3#FromAxes">FromAxes</A> (axis: Axis.T; n, m: INTEGER): T;
</PRE><BLOCKQUOTE><EM> If axis=Hor then FromCoords (n,m), else FromCoords (m,n) </EM></BLOCKQUOTE><PRE>
</PRE> --- Selection --- 

<P><PRE>PROCEDURE <A HREF="Point.m3#DistSquare">DistSquare</A>(READONLY p, q: T): INTEGER;
</PRE><BLOCKQUOTE><EM> Return the square of the Euclidean distance between <CODE>p</CODE> and <CODE>q</CODE>. </EM></BLOCKQUOTE><PRE>
</PRE> --- Transformation --- 

<P><PRE>PROCEDURE <A HREF="Point.m3#Minus">Minus</A> (READONLY p: T): T;
</PRE><BLOCKQUOTE><EM> -p.h,-p.v </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Point.m3#Add">Add</A>(READONLY p, q: T): T;
</PRE><BLOCKQUOTE><EM> Return <CODE>T{p.h + q.h, p.v + q.v}</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Point.m3#Sub">Sub</A>(READONLY p, q: T): T;
</PRE><BLOCKQUOTE><EM> Return <CODE>T{p.h - q.h, p.v -q.v}</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Point.m3#Mul">Mul</A>(READONLY p: T; n: INTEGER): T;
</PRE><BLOCKQUOTE><EM> Return <CODE>T{p.h * n, p.v * n}</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Point.m3#Div">Div</A>(READONLY p: T; n: INTEGER): T;
</PRE><BLOCKQUOTE><EM> Return <CODE>T{p.h DIV n, p.v DIV n}</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Point.m3#Mod">Mod</A>(READONLY p: T; n: INTEGER): T;
</PRE><BLOCKQUOTE><EM> Return <CODE>T{p.h MOD n, p.v MOD n}</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Point.m3#Scale">Scale</A>(READONLY p: T; num, den: INTEGER): T;
</PRE><BLOCKQUOTE><EM> Return <CODE>Div(Mul(p, num), den)</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Point.m3#Min">Min</A>(READONLY p, q: T): T;
</PRE><BLOCKQUOTE><EM> Return <CODE>T{MIN(p.h, q.h), MIN(p.v, q.v)}</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Point.m3#Max">Max</A>(READONLY p, q: T): T;
</PRE><BLOCKQUOTE><EM> Return <CODE>T{MAX(p.h, q.h), MAX(p.v, q.v)}</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Point.m3#Move">Move</A> (READONLY p, dp: T): T;
</PRE><BLOCKQUOTE><EM> Increment p.h by dp.h and p.v by dp.v; same as Add </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Point.m3#MoveH">MoveH</A>(READONLY p: T; dh: INTEGER): T;
</PRE><BLOCKQUOTE><EM> Return <CODE>T{p.h+dh, p.v}</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Point.m3#MoveV">MoveV</A>(READONLY p: T; dv: INTEGER): T;
</PRE><BLOCKQUOTE><EM> Return <CODE>T{p.h, p.v+dv}</CODE>.  </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Point.m3#MoveHV">MoveHV</A>(READONLY p: T; dh, dv: INTEGER): T;
</PRE><BLOCKQUOTE><EM> Return <CODE>T{p.h+dh, p.v+dv}</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Point.m3#Transpose">Transpose</A>(READONLY p: T; ax := Axis.T.Ver): T;
</PRE><BLOCKQUOTE><EM> If <CODE>ax = Hor</CODE> then return <CODE>p</CODE> else return <CODE>T{p.v, p.h}</CODE>. </EM></BLOCKQUOTE><PRE>
</PRE> --- Test --- 

<P><PRE>PROCEDURE <A HREF="Point.m3#Less">Less</A> (READONLY p, q: T): BOOLEAN;
</PRE><BLOCKQUOTE><EM> Whether p.h &lt; q.h and p.v &lt; q.v </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Point.m3#LessEq">LessEq</A> (READONLY p, q: T): BOOLEAN;
</PRE><BLOCKQUOTE><EM> Whether p.h &lt;= q.h and p.v &lt;= q.v </EM></BLOCKQUOTE><PRE>
</PRE> --- Standard type operations --- 

<P><PRE>PROCEDURE <A HREF="Point.m3#Equal">Equal</A> (READONLY p, q: T): BOOLEAN;
</PRE><BLOCKQUOTE><EM> Point equality </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Point.m3#Compare">Compare</A> (READONLY a, b: T): [-1 .. 1];
</PRE><BLOCKQUOTE><EM> == RETURN (-1 if Lt (a, b), 0 if Equal (a, b), +1 o. w.) </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Point.m3#Hash">Hash</A> (READONLY a: T): Word.T;
</PRE><BLOCKQUOTE><EM> == RETURN a suitable hash value  </EM></BLOCKQUOTE><PRE>

END Point.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
